/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <Plot.h>
#include <DataNode.h>

//
// Enum conversion methods for Plot::StateType
//

static const char *StateType_strings[] = {
"NewlyCreated", "Pending", "Completed", 
"Error"};

std::string
Plot::StateType_ToString(Plot::StateType t)
{
    int index = int(t);
    if(index < 0 || index >= 4) index = 0;
    return StateType_strings[index];
}

std::string
Plot::StateType_ToString(int t)
{
    int index = (t < 0 || t >= 4) ? 0 : t;
    return StateType_strings[index];
}

bool
Plot::StateType_FromString(const std::string &s, Plot::StateType &val)
{
    val = Plot::NewlyCreated;
    for(int i = 0; i < 4; ++i)
    {
        if(s == StateType_strings[i])
        {
            val = (StateType)i;
            return true;
        }
    }
    return false;
}

// Type map format string
const char *Plot::TypeMapFormatString = "iisbbbssi*s*iiiii*i*bbs";

// ****************************************************************************
// Method: Plot::Plot
//
// Purpose: 
//   Constructor for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Plot::Plot() : 
    AttributeSubject(Plot::TypeMapFormatString)
{
    stateType = NewlyCreated;
    plotType = 0;
    activeFlag = false;
    hiddenFlag = false;
    expandedFlag = false;
    plotVar = "notset";
    databaseName = "notset";
    activeOperator = -1;
    id = -1;
    beginFrame = -999;
    endFrame = 999;
    isFromSimulation = false;
    followsTime = true;
}

// ****************************************************************************
// Method: Plot::Plot
//
// Purpose: 
//   Copy constructor for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Plot::Plot(const Plot &obj) : 
    AttributeSubject(Plot::TypeMapFormatString)
{
    stateType = obj.stateType;
    plotType = obj.plotType;
    plotName = obj.plotName;
    activeFlag = obj.activeFlag;
    hiddenFlag = obj.hiddenFlag;
    expandedFlag = obj.expandedFlag;
    plotVar = obj.plotVar;
    databaseName = obj.databaseName;
    operators = obj.operators;
    operatorNames = obj.operatorNames;
    activeOperator = obj.activeOperator;
    id = obj.id;
    beginFrame = obj.beginFrame;
    endFrame = obj.endFrame;
    keyframes = obj.keyframes;
    databaseKeyframes = obj.databaseKeyframes;
    isFromSimulation = obj.isFromSimulation;
    followsTime = obj.followsTime;
    description = obj.description;

    SelectAll();
}

// ****************************************************************************
// Method: Plot::~Plot
//
// Purpose: 
//   Destructor for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Plot::~Plot()
{
    // nothing here
}

// ****************************************************************************
// Method: Plot::operator = 
//
// Purpose: 
//   Assignment operator for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

Plot& 
Plot::operator = (const Plot &obj)
{
    if (this == &obj) return *this;
    stateType = obj.stateType;
    plotType = obj.plotType;
    plotName = obj.plotName;
    activeFlag = obj.activeFlag;
    hiddenFlag = obj.hiddenFlag;
    expandedFlag = obj.expandedFlag;
    plotVar = obj.plotVar;
    databaseName = obj.databaseName;
    operators = obj.operators;
    operatorNames = obj.operatorNames;
    activeOperator = obj.activeOperator;
    id = obj.id;
    beginFrame = obj.beginFrame;
    endFrame = obj.endFrame;
    keyframes = obj.keyframes;
    databaseKeyframes = obj.databaseKeyframes;
    isFromSimulation = obj.isFromSimulation;
    followsTime = obj.followsTime;
    description = obj.description;

    SelectAll();
    return *this;
}

// ****************************************************************************
// Method: Plot::operator == 
//
// Purpose: 
//   Comparison operator == for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::operator == (const Plot &obj) const
{
    // Create the return value
    return ((stateType == obj.stateType) &&
            (plotType == obj.plotType) &&
            (plotName == obj.plotName) &&
            (activeFlag == obj.activeFlag) &&
            (hiddenFlag == obj.hiddenFlag) &&
            (expandedFlag == obj.expandedFlag) &&
            (plotVar == obj.plotVar) &&
            (databaseName == obj.databaseName) &&
            (operators == obj.operators) &&
            (operatorNames == obj.operatorNames) &&
            (activeOperator == obj.activeOperator) &&
            (id == obj.id) &&
            (beginFrame == obj.beginFrame) &&
            (endFrame == obj.endFrame) &&
            (keyframes == obj.keyframes) &&
            (databaseKeyframes == obj.databaseKeyframes) &&
            (isFromSimulation == obj.isFromSimulation) &&
            (followsTime == obj.followsTime) &&
            (description == obj.description));
}

// ****************************************************************************
// Method: Plot::operator != 
//
// Purpose: 
//   Comparison operator != for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::operator != (const Plot &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: Plot::TypeName
//
// Purpose: 
//   Type name method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
Plot::TypeName() const
{
    return "Plot";
}

// ****************************************************************************
// Method: Plot::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const Plot *tmp = (const Plot *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: Plot::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Plot::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new Plot(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: Plot::NewInstance
//
// Purpose: 
//   NewInstance method for the Plot class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
Plot::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new Plot(*this);
    else
        retval = new Plot;

    return retval;
}

// ****************************************************************************
// Method: Plot::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
Plot::SelectAll()
{
    Select(ID_stateType,         (void *)&stateType);
    Select(ID_plotType,          (void *)&plotType);
    Select(ID_plotName,          (void *)&plotName);
    Select(ID_activeFlag,        (void *)&activeFlag);
    Select(ID_hiddenFlag,        (void *)&hiddenFlag);
    Select(ID_expandedFlag,      (void *)&expandedFlag);
    Select(ID_plotVar,           (void *)&plotVar);
    Select(ID_databaseName,      (void *)&databaseName);
    Select(ID_operators,         (void *)&operators);
    Select(ID_operatorNames,     (void *)&operatorNames);
    Select(ID_activeOperator,    (void *)&activeOperator);
    Select(ID_id,                (void *)&id);
    Select(ID_beginFrame,        (void *)&beginFrame);
    Select(ID_endFrame,          (void *)&endFrame);
    Select(ID_keyframes,         (void *)&keyframes);
    Select(ID_databaseKeyframes, (void *)&databaseKeyframes);
    Select(ID_isFromSimulation,  (void *)&isFromSimulation);
    Select(ID_followsTime,       (void *)&followsTime);
    Select(ID_description,       (void *)&description);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
Plot::SetStateType(Plot::StateType stateType_)
{
    stateType = stateType_;
    Select(ID_stateType, (void *)&stateType);
}

void
Plot::SetPlotType(int plotType_)
{
    plotType = plotType_;
    Select(ID_plotType, (void *)&plotType);
}

void
Plot::SetPlotName(const std::string &plotName_)
{
    plotName = plotName_;
    Select(ID_plotName, (void *)&plotName);
}

void
Plot::SetActiveFlag(bool activeFlag_)
{
    activeFlag = activeFlag_;
    Select(ID_activeFlag, (void *)&activeFlag);
}

void
Plot::SetHiddenFlag(bool hiddenFlag_)
{
    hiddenFlag = hiddenFlag_;
    Select(ID_hiddenFlag, (void *)&hiddenFlag);
}

void
Plot::SetExpandedFlag(bool expandedFlag_)
{
    expandedFlag = expandedFlag_;
    Select(ID_expandedFlag, (void *)&expandedFlag);
}

void
Plot::SetPlotVar(const std::string &plotVar_)
{
    plotVar = plotVar_;
    Select(ID_plotVar, (void *)&plotVar);
}

void
Plot::SetDatabaseName(const std::string &databaseName_)
{
    databaseName = databaseName_;
    Select(ID_databaseName, (void *)&databaseName);
}

void
Plot::SetOperators(const intVector &operators_)
{
    operators = operators_;
    Select(ID_operators, (void *)&operators);
}

void
Plot::SetOperatorNames(const stringVector &operatorNames_)
{
    operatorNames = operatorNames_;
    Select(ID_operatorNames, (void *)&operatorNames);
}

void
Plot::SetActiveOperator(int activeOperator_)
{
    activeOperator = activeOperator_;
    Select(ID_activeOperator, (void *)&activeOperator);
}

void
Plot::SetId(int id_)
{
    id = id_;
    Select(ID_id, (void *)&id);
}

void
Plot::SetBeginFrame(int beginFrame_)
{
    beginFrame = beginFrame_;
    Select(ID_beginFrame, (void *)&beginFrame);
}

void
Plot::SetEndFrame(int endFrame_)
{
    endFrame = endFrame_;
    Select(ID_endFrame, (void *)&endFrame);
}

void
Plot::SetKeyframes(const intVector &keyframes_)
{
    keyframes = keyframes_;
    Select(ID_keyframes, (void *)&keyframes);
}

void
Plot::SetDatabaseKeyframes(const intVector &databaseKeyframes_)
{
    databaseKeyframes = databaseKeyframes_;
    Select(ID_databaseKeyframes, (void *)&databaseKeyframes);
}

void
Plot::SetIsFromSimulation(bool isFromSimulation_)
{
    isFromSimulation = isFromSimulation_;
    Select(ID_isFromSimulation, (void *)&isFromSimulation);
}

void
Plot::SetFollowsTime(bool followsTime_)
{
    followsTime = followsTime_;
    Select(ID_followsTime, (void *)&followsTime);
}

void
Plot::SetDescription(const std::string &description_)
{
    description = description_;
    Select(ID_description, (void *)&description);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

Plot::StateType
Plot::GetStateType() const
{
    return StateType(stateType);
}

int
Plot::GetPlotType() const
{
    return plotType;
}

const std::string &
Plot::GetPlotName() const
{
    return plotName;
}

std::string &
Plot::GetPlotName()
{
    return plotName;
}

bool
Plot::GetActiveFlag() const
{
    return activeFlag;
}

bool
Plot::GetHiddenFlag() const
{
    return hiddenFlag;
}

bool
Plot::GetExpandedFlag() const
{
    return expandedFlag;
}

const std::string &
Plot::GetPlotVar() const
{
    return plotVar;
}

std::string &
Plot::GetPlotVar()
{
    return plotVar;
}

const std::string &
Plot::GetDatabaseName() const
{
    return databaseName;
}

std::string &
Plot::GetDatabaseName()
{
    return databaseName;
}

const intVector &
Plot::GetOperators() const
{
    return operators;
}

intVector &
Plot::GetOperators()
{
    return operators;
}

const stringVector &
Plot::GetOperatorNames() const
{
    return operatorNames;
}

stringVector &
Plot::GetOperatorNames()
{
    return operatorNames;
}

int
Plot::GetActiveOperator() const
{
    return activeOperator;
}

int
Plot::GetId() const
{
    return id;
}

int
Plot::GetBeginFrame() const
{
    return beginFrame;
}

int
Plot::GetEndFrame() const
{
    return endFrame;
}

const intVector &
Plot::GetKeyframes() const
{
    return keyframes;
}

intVector &
Plot::GetKeyframes()
{
    return keyframes;
}

const intVector &
Plot::GetDatabaseKeyframes() const
{
    return databaseKeyframes;
}

intVector &
Plot::GetDatabaseKeyframes()
{
    return databaseKeyframes;
}

bool
Plot::GetIsFromSimulation() const
{
    return isFromSimulation;
}

bool
Plot::GetFollowsTime() const
{
    return followsTime;
}

const std::string &
Plot::GetDescription() const
{
    return description;
}

std::string &
Plot::GetDescription()
{
    return description;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
Plot::SelectPlotName()
{
    Select(ID_plotName, (void *)&plotName);
}

void
Plot::SelectPlotVar()
{
    Select(ID_plotVar, (void *)&plotVar);
}

void
Plot::SelectDatabaseName()
{
    Select(ID_databaseName, (void *)&databaseName);
}

void
Plot::SelectOperators()
{
    Select(ID_operators, (void *)&operators);
}

void
Plot::SelectOperatorNames()
{
    Select(ID_operatorNames, (void *)&operatorNames);
}

void
Plot::SelectKeyframes()
{
    Select(ID_keyframes, (void *)&keyframes);
}

void
Plot::SelectDatabaseKeyframes()
{
    Select(ID_databaseKeyframes, (void *)&databaseKeyframes);
}

void
Plot::SelectDescription()
{
    Select(ID_description, (void *)&description);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: Plot::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Plot::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_stateType:         return "stateType";
    case ID_plotType:          return "plotType";
    case ID_plotName:          return "plotName";
    case ID_activeFlag:        return "activeFlag";
    case ID_hiddenFlag:        return "hiddenFlag";
    case ID_expandedFlag:      return "expandedFlag";
    case ID_plotVar:           return "plotVar";
    case ID_databaseName:      return "databaseName";
    case ID_operators:         return "operators";
    case ID_operatorNames:     return "operatorNames";
    case ID_activeOperator:    return "activeOperator";
    case ID_id:                return "id";
    case ID_beginFrame:        return "beginFrame";
    case ID_endFrame:          return "endFrame";
    case ID_keyframes:         return "keyframes";
    case ID_databaseKeyframes: return "databaseKeyframes";
    case ID_isFromSimulation:  return "isFromSimulation";
    case ID_followsTime:       return "followsTime";
    case ID_description:       return "description";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Plot::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
Plot::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_stateType:         return FieldType_enum;
    case ID_plotType:          return FieldType_int;
    case ID_plotName:          return FieldType_string;
    case ID_activeFlag:        return FieldType_bool;
    case ID_hiddenFlag:        return FieldType_bool;
    case ID_expandedFlag:      return FieldType_bool;
    case ID_plotVar:           return FieldType_string;
    case ID_databaseName:      return FieldType_string;
    case ID_operators:         return FieldType_intVector;
    case ID_operatorNames:     return FieldType_stringVector;
    case ID_activeOperator:    return FieldType_int;
    case ID_id:                return FieldType_int;
    case ID_beginFrame:        return FieldType_int;
    case ID_endFrame:          return FieldType_int;
    case ID_keyframes:         return FieldType_intVector;
    case ID_databaseKeyframes: return FieldType_intVector;
    case ID_isFromSimulation:  return FieldType_bool;
    case ID_followsTime:       return FieldType_bool;
    case ID_description:       return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: Plot::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
Plot::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_stateType:         return "enum";
    case ID_plotType:          return "int";
    case ID_plotName:          return "string";
    case ID_activeFlag:        return "bool";
    case ID_hiddenFlag:        return "bool";
    case ID_expandedFlag:      return "bool";
    case ID_plotVar:           return "string";
    case ID_databaseName:      return "string";
    case ID_operators:         return "intVector";
    case ID_operatorNames:     return "stringVector";
    case ID_activeOperator:    return "int";
    case ID_id:                return "int";
    case ID_beginFrame:        return "int";
    case ID_endFrame:          return "int";
    case ID_keyframes:         return "intVector";
    case ID_databaseKeyframes: return "intVector";
    case ID_isFromSimulation:  return "bool";
    case ID_followsTime:       return "bool";
    case ID_description:       return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: Plot::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
Plot::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const Plot &obj = *((const Plot*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_stateType:
        {  // new scope
        retval = (stateType == obj.stateType);
        }
        break;
    case ID_plotType:
        {  // new scope
        retval = (plotType == obj.plotType);
        }
        break;
    case ID_plotName:
        {  // new scope
        retval = (plotName == obj.plotName);
        }
        break;
    case ID_activeFlag:
        {  // new scope
        retval = (activeFlag == obj.activeFlag);
        }
        break;
    case ID_hiddenFlag:
        {  // new scope
        retval = (hiddenFlag == obj.hiddenFlag);
        }
        break;
    case ID_expandedFlag:
        {  // new scope
        retval = (expandedFlag == obj.expandedFlag);
        }
        break;
    case ID_plotVar:
        {  // new scope
        retval = (plotVar == obj.plotVar);
        }
        break;
    case ID_databaseName:
        {  // new scope
        retval = (databaseName == obj.databaseName);
        }
        break;
    case ID_operators:
        {  // new scope
        retval = (operators == obj.operators);
        }
        break;
    case ID_operatorNames:
        {  // new scope
        retval = (operatorNames == obj.operatorNames);
        }
        break;
    case ID_activeOperator:
        {  // new scope
        retval = (activeOperator == obj.activeOperator);
        }
        break;
    case ID_id:
        {  // new scope
        retval = (id == obj.id);
        }
        break;
    case ID_beginFrame:
        {  // new scope
        retval = (beginFrame == obj.beginFrame);
        }
        break;
    case ID_endFrame:
        {  // new scope
        retval = (endFrame == obj.endFrame);
        }
        break;
    case ID_keyframes:
        {  // new scope
        retval = (keyframes == obj.keyframes);
        }
        break;
    case ID_databaseKeyframes:
        {  // new scope
        retval = (databaseKeyframes == obj.databaseKeyframes);
        }
        break;
    case ID_isFromSimulation:
        {  // new scope
        retval = (isFromSimulation == obj.isFromSimulation);
        }
        break;
    case ID_followsTime:
        {  // new scope
        retval = (followsTime == obj.followsTime);
        }
        break;
    case ID_description:
        {  // new scope
        retval = (description == obj.description);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

void
Plot::AddOperator(int op, const char *name)
{
    operators.push_back(op);
    operatorNames.push_back(name);
    Select(ID_operators, (void *)&operators);
    Select(ID_operatorNames, (void *)&operatorNames);
}

void
Plot::ClearAllOperators()
{
    if(operators.size() > 0)
    {
        operators.clear();
        operatorNames.clear();
        Select(ID_operators, (void *)&operators);
        Select(ID_operatorNames, (void *)&operatorNames);
    }
}

int
Plot::GetNumOperators() const
{
    return operators.size();
}

int
Plot::GetOperator(int i) const
{
    return operators[i];
}

const std::string &
Plot::GetOperatorName(int i) const
{
    return operatorNames[i];
}

void
Plot::RemoveLastOperator()
{
    if(operators.size() > 0)
    {
        operators.pop_back();
        operatorNames.pop_back();
        Select(ID_operators, (void *)&operators);
        Select(ID_operatorNames, (void *)&operatorNames);
    }
}

