// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PLOT3DPluginInfo.C
// ****************************************************************************

#include <PLOT3DPluginInfo.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(PLOT3D,DBP_EXPORT)

VISIT_DATABASE_PLUGIN_ENTRY(PLOT3D,General)

// ****************************************************************************
//  Method: PLOT3DGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the database plugin.
//
//  Returns:    A pointer to the name of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PLOT3DGeneralPluginInfo::GetName() const
{
    return "PLOT3D";
}

// ****************************************************************************
//  Method: PLOT3DGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the database plugin.
//
//  Returns:    A pointer to the version of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PLOT3DGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: PLOT3DGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the database plugin.
//
//  Returns:    A pointer to the id of the database plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PLOT3DGeneralPluginInfo::GetID() const
{
    return "PLOT3D_1.0";
}
// ****************************************************************************
//  Method: PLOT3DGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PLOT3DGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}
// ****************************************************************************
//  Method: PLOT3DGeneralPluginInfo::HasWriter
//
//  Purpose:
//    Return true if this plugin has a database writer.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
PLOT3DGeneralPluginInfo::HasWriter() const
{
    return false;
}
// ****************************************************************************
//  Method:  PLOT3DGeneralPluginInfo::GetDefaultFilePatterns
//
//  Purpose:
//    Returns the default patterns for a PLOT3D database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
std::vector<std::string>
PLOT3DGeneralPluginInfo::GetDefaultFilePatterns() const
{
    std::vector<std::string> defaultPatterns;
    defaultPatterns.push_back("*.q");
    defaultPatterns.push_back("*.x");
    defaultPatterns.push_back("*.vp3d");

    return defaultPatterns;
}

// ****************************************************************************
//  Method:  PLOT3DGeneralPluginInfo::AreDefaultFilePatternsStrict
//
//  Purpose:
//    Returns if the file patterns for a PLOT3D database are
//    intended to be interpreted strictly by default.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
PLOT3DGeneralPluginInfo::AreDefaultFilePatternsStrict() const
{
    return false;
}

// ****************************************************************************
//  Method:  PLOT3DGeneralPluginInfo::OpensWholeDirectory
//
//  Purpose:
//    Returns if the PLOT3D plugin opens a whole directory name
//    instead of a single file.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
bool
PLOT3DGeneralPluginInfo::OpensWholeDirectory() const
{
    return false;
}
