#!/usr/bin/python3
import sys, os
PACKAGE_DIR = os.path.abspath(os.path.abspath(os.path.dirname(os.path.dirname(os.path.dirname(__file__)))))
sys.path.insert(0, PACKAGE_DIR)
from numpy.testing import assert_almost_equal
from traj_satellite import *

def test_trajectoire_terre():
    gastre = nouvChampGrav((0,0,0), 6e23)
    pos = (0, 6e6, 0)
    vit = (8e3,0,0)
    t = 20
    dt = 1
    traj = trajectoire(dt, t, pos+vit, gastre)
    pv = array([[ 0.00000000e+00,  6.00000000e+06,  0.00000000e+00,
             8.00000000e+03,  0.00000000e+00,  0.00000000e+00],
           [ 7.99999975e+03,  5.99999944e+06,  0.00000000e+00,
             7.99999926e+03, -1.11166575e+00,  0.00000000e+00],
           [ 1.59999980e+04,  5.99999778e+06,  0.00000000e+00,
             7.99999704e+03, -2.22332598e+00,  0.00000000e+00],
           [ 2.39999933e+04,  5.99999500e+06,  0.00000000e+00,
             7.99999333e+03, -3.33497517e+00,  0.00000000e+00],
           [ 3.19999842e+04,  5.99999111e+06,  0.00000000e+00,
             7.99998814e+03, -4.44660782e+00,  0.00000000e+00],
           [ 3.99999691e+04,  5.99998610e+06,  0.00000000e+00,
             7.99998147e+03, -5.55821840e+00,  0.00000000e+00],
           [ 4.79999466e+04,  5.99997999e+06,  0.00000000e+00,
             7.99997332e+03, -6.66980140e+00,  0.00000000e+00],
           [ 5.59999153e+04,  5.99997276e+06,  0.00000000e+00,
             7.99996369e+03, -7.78135130e+00,  0.00000000e+00],
           [ 6.39998735e+04,  5.99996443e+06,  0.00000000e+00,
             7.99995257e+03, -8.89286259e+00,  0.00000000e+00],
           [ 7.19998199e+04,  5.99995498e+06,  0.00000000e+00,
             7.99993998e+03, -1.00043298e+01,  0.00000000e+00],
           [ 7.99997530e+04,  5.99994442e+06,  0.00000000e+00,
             7.99992590e+03, -1.11157473e+01,  0.00000000e+00],
           [ 8.79996712e+04,  5.99993275e+06,  0.00000000e+00,
             7.99991034e+03, -1.22271097e+01,  0.00000000e+00],
           [ 9.59995732e+04,  5.99991996e+06,  0.00000000e+00,
             7.99989330e+03, -1.33384114e+01,  0.00000000e+00],
           [ 1.03999457e+05,  5.99990607e+06,  0.00000000e+00,
             7.99987478e+03, -1.44496470e+01,  0.00000000e+00],
           [ 1.11999322e+05,  5.99989107e+06,  0.00000000e+00,
             7.99985478e+03, -1.55608108e+01,  0.00000000e+00],
           [ 1.19999166e+05,  5.99987495e+06,  0.00000000e+00,
             7.99983330e+03, -1.66718976e+01,  0.00000000e+00],
           [ 1.27998988e+05,  5.99985772e+06,  0.00000000e+00,
             7.99981033e+03, -1.77829016e+01,  0.00000000e+00],
           [ 1.35998787e+05,  5.99983938e+06,  0.00000000e+00,
             7.99978589e+03, -1.88938175e+01,  0.00000000e+00],
           [ 1.43998560e+05,  5.99981993e+06,  0.00000000e+00,
             7.99975997e+03, -2.00046396e+01,  0.00000000e+00],
           [ 1.51998306e+05,  5.99979937e+06,  0.00000000e+00,
             7.99973258e+03, -2.11153626e+01,  0.00000000e+00]])
    assert_almost_equal(
        pv, traj.pv, decimal = 2,
        err_msg = "positions and velocities are too different from expected values")       
