\name{read.AP}
\alias{read.AP}
\title{
Read Atom Pair/Fingerprint Strings
}
\description{
Function to convert atom pairs (AP) or fingerprints (e.g. AP fingerprints) stored as character strings to \code{APset} or \code{FPset} objects (e.g. generated by \code{sdfStream}). Alternatively, one can provide the AP or fingerprint strings in a named character vector.
}
\usage{
read.AP(x, type, colid, isFile = class(x) == "character" & length(x) == 1)
}
\arguments{
  \item{x}{
name of file from where to read the AP/APFP character strings; or named character vector containing the AP/APFP strings
}
  \item{type}{
\code{type="ap"} for AP character string input, and \code{type="fp"} for fingerprint character string input
}
  \item{colid}{
column containing AP/FP character strings if \code{x} is a file
}
	\item{isFile}{
		Is \code{x} a file name or not?
	}
}
\details{
...
}
\value{
object of class \code{APset} or \code{FPset}
}
\references{
...
}
\author{
Thomas Girke
}
\seealso{
\code{sdf2ap}, \code{sdfStream}
}
\examples{
## Load sample data
library(ChemmineR)
data(sdfsample); sdfset <- sdfsample
\dontrun{write.SDF(sdfset, "test.sdf")

## Define descriptor set in a simple function
desc <- function(sdfset) {
        cbind(SDFID=sdfid(sdfset), 
              # datablock2ma(datablocklist=datablock(sdfset)), 
              MW=MW(sdfset), 
              groups(sdfset),
              APFP=desc2fp(x=sdf2ap(sdfset), descnames=1024, type="character"), 
              AP=sdf2ap(sdfset, type="character"),
              rings(sdfset, type="count", upper=6, arom=TRUE)
        )
}

## Run sdfStream with desc function and write results to a file called 'matrix.xls'
sdfStream(input="test.sdf", output="matrix.xls", fct=desc, Nlines=1000)

## Select molecules from SD File using line index from sdfStream
indexDF <- read.delim("matrix.xls", row.names=1)[,1:4]
indexDFsub <- indexDF[indexDF$MW < 400, ] # Selects molecules with MW < 400
sdfset <- read.SDFindex(file="test.sdf", index=indexDFsub, type="SDFset")

## Write result directly to SD file without storing larger numbers of molecules in memory
read.SDFindex(file="test.sdf", index=indexDFsub, type="file", outfile="sub.sdf")

## Read AP/APFP strings from file into APset or FP object
apset <- read.AP(x="matrix.xls", type="ap", colid="AP")
apfp <- read.AP(x="matrix.xls", type="apfp", colid="APFP")

## Alternatively, one can provide the AP/APFP strings in a named character vector
apset <- read.AP(x=sdf2ap(sdfset[1:20], type="character"), type="ap")
apfp <- read.AP(x=desc2fp(x=sdf2ap(sdfset[1:20]), descnames=1024, type="character"), type="apfp")
}
}
\keyword{ utilities }
