% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/findStatus.R
\name{findDone}
\alias{findDisappeared}
\alias{findDone}
\alias{findErrors}
\alias{findExpired}
\alias{findMissingResults}
\alias{findNotDone}
\alias{findNotErrors}
\alias{findNotOnSystem}
\alias{findNotRunning}
\alias{findNotStarted}
\alias{findNotSubmitted}
\alias{findNotTerminated}
\alias{findOnSystem}
\alias{findRunning}
\alias{findStarted}
\alias{findSubmitted}
\alias{findTerminated}
\title{Find jobs depending on computional state.}
\usage{
findDone(reg, ids, limit = NULL)

findNotDone(reg, ids, limit = NULL)

findMissingResults(reg, ids, limit = NULL)

findErrors(reg, ids, limit = NULL)

findNotErrors(reg, ids, limit = NULL)

findTerminated(reg, ids, limit = NULL)

findNotTerminated(reg, ids, limit = NULL)

findSubmitted(reg, ids, limit = NULL)

findNotSubmitted(reg, ids, limit = NULL)

findOnSystem(reg, ids, limit = NULL)

findNotOnSystem(reg, ids, limit = NULL)

findRunning(reg, ids, limit = NULL)

findNotRunning(reg, ids, limit = NULL)

findStarted(reg, ids, limit = NULL)

findNotStarted(reg, ids, limit = NULL)

findExpired(reg, ids, limit = NULL)

findDisappeared(reg, ids, limit = NULL)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Subset of job ids to restrict the result to.
Default is all jobs.}

\item{limit}{[\code{integer(1)}]\cr
Limit the number of returned ids.
Default is all ids.}
}
\value{
[\code{integer}]. Ids of jobs.
}
\description{
\code{findDone}: Find jobs which succesfully terminated.

\code{findNotDone}: Find jobs for which results are still missing.

\code{findMissingResults}: Deprecated. Alias for findNotDone.

\code{findErrors}: Find jobs where errors occured.

\code{findNotErrors}: Find jobs where no errors occured.

\code{findTerminated}: Find jobs which have terminated (done / error).

\code{findNotTerminated}: Find jobs which have not terminated (not done / no error).

\code{findSubmitted}: Find jobs which have been submitted.

\code{findNotSubmitted}: Find jobs which have not been submitted.

\code{findOnSystem}: Find jobs which are present on the batch system at the moment.

\code{findNotOnSystem}: Find jobs which are not present on the batch system at the moment.

\code{findRunning}: Find jobs which are running.

\code{findNotRunning}: Find jobs which are not running.

\code{findStarted}: Find jobs which have been started on the batch system.

\code{findStarted}: Find jobs which have not been started on the batch system.
\code{findNotRunning}: Find jobs which are not running.

\code{findExpired}: Find jobs where walltime was probably hit.
Right now the heuristic is as follows:
Find all jobs that have started, did not abort with an error,
did not complete with a result and are not submitted or running anymore.
Note that this heuristic does not include jobs the scheduler looses before starting.

\code{findDisappeared}: Find jobs which disappeared from the system.
Right now the heuristic is as follows:
Find all jobs that are submitted but not started nor on the system anymore.
}

