% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns_search.R
\name{ns_search}
\alias{ns_search}
\title{NatureServe taxonomic name search}
\usage{
ns_search(x, key = NULL, ...)
}
\arguments{
\item{x}{(character) A name to search for. An asterisk (*) wildcarded species
name, e.g., 'Aquila chry*'. Name matching is case-insensitive and all of
the primary and synonymous scientific names, along with all common names,
are matched. Required.}

\item{key}{(character) API key. Required. See \strong{Authentication} below
for more.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A tibble (data.frame), with columns:
\itemize{
 \item jurisdictionScientificName - Scientfic name
 \item commonName - Common name
 \item globalSpeciesUid - UID - the taxonomic identifier NatureServe uses
 \item natureServeExplorerURI - URL to get to info online for the taxon
 \item taxonomicComments - comments about the taxon, if any
}
}
\description{
NatureServe taxonomic name search
}
\section{Authentication}{

Get an API key from NatureServe at
\url{https://services.natureserve.org/developer/index.jsp}.
You can pass your token in as an argument or store it one of two places:

\itemize{
  \item your .Rprofile file with an entry like
  \code{options(NatureServeKey = "your-natureserve-key")}
  \item your .Renviron file with an entry like
  \code{NATURE_SERVE_KEY=your-natureserve-key}
}

See \code{\link{Startup}} for information on how to create/find your
.Rrofile and .Renviron files
}
\examples{
\dontrun{
ns_search(x = "Ruby*")
ns_search(x = "Helianthus annuus")
ns_search(x = "Ursus americanus")
}
}
\references{
\url{https://services.natureserve.org/index.jsp}
}

