% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_types.R
\name{guess_type}
\alias{guess_type}
\title{Guess the type of a vector}
\usage{
guess_type(
  x,
  na = c("", "NA"),
  locale = default_locale(),
  guess_integer = FALSE
)
}
\arguments{
\item{x}{Character vector of values to parse.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[readr:locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{guess_integer}{If \code{TRUE}, guess integer types for whole numbers, if
\code{FALSE} guess numeric type for all numbers.}
}
\description{
Guess the type of a vector
}
\examples{
 # Logical vectors
 guess_type(c("FALSE", "TRUE", "F", "T"))
 # Integers and doubles
 guess_type(c("1","2","3"))
 guess_type(c("1.6","2.6","3.4"))
 # Numbers containing grouping mark
 guess_type("1,234,566")
 # ISO 8601 date times
 guess_type(c("2010-10-10"))
 guess_type(c("2010-10-10 01:02:03"))
 guess_type(c("01:02:03 AM"))
}
