/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_Vertex.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/23
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_VERTEX_H__
#define __LIST_VERTEX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_VERTEX_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL VERTEX_LIST *p_vertex_list;
//	GLOBAL VERTEX_LIST_INFO vertex_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _LIST_VERTEX_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int init_vertex(VERTEX *vertex);
/* VERTEX Data をリストの最初に追加 */
VERTEX_LIST *vertex_list_add_first(VERTEX *add_vertex, VERTEX_LIST_INFO *p_vertex_list_info);

/* VERTEX Data をリストの最後に追加 */
VERTEX_LIST *vertex_list_add_last(VERTEX *add_vertex, VERTEX_LIST_INFO *p_vertex_list_info);

/* VERTEX Data の削除機能 (メモリの削除ではない) */
int vertex_list_delete(VERTEX_LIST *del_List, VERTEX_LIST_INFO *p_vertex_list_info);

/* VERTEX Data を変更する */
VERTEX_LIST *vertex_list_edit(VERTEX_LIST *point, VERTEX *change_vertex, VERTEX_LIST_INFO *p_vertex_list_info);

/* リストの総数を調べる */
long vertex_list_num(VERTEX_LIST_INFO *p_vertex_list_info);
/* n 番目のデータの検索 */
VERTEX_LIST *vertex_search_num(long search_number, VERTEX_LIST_INFO *p_vertex_list_info);
/* データの検索(VERTEX *p_vertex から VERTEX_LIST を求める) */
VERTEX_LIST *vertex_search_vertex(VERTEX *p_vertex, VERTEX_LIST_INFO *p_vertex_list_info);
/* データの検索(VERTEX *p_vertex から Data No. の long 値を求める) */
long vertex_search_vertex_to_num(VERTEX *p_vertex, VERTEX_LIST_INFO *p_vertex_list_info);


/* VERTEX Data をリストから削除 */
int vertex_list_free(VERTEX_LIST *del_List, VERTEX_LIST_INFO *p_vertex_list_info);
/* 全リストを削除 */
void vertex_list_all_free(VERTEX_LIST_INFO *p_vertex_list_info);

/* VERTEX リストを表示 */
void vertex_list_print(VERTEX_LIST_INFO *p_vertex_list_info);

/* VERTEX_LIST_INFO_1 を VERTEX_LIST_INFO_2 にコピー */
int copy_vertex_list_info(VERTEX_LIST_INFO *org_vertex_list_info, VERTEX_LIST_INFO *cpy_vertex_list_info);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_VERTEX_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_Vertex.h
 * ====================================================================
 */
