/* Copyright (c) 2024-2025. The SimGrid Team. All rights reserved.          */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

package org.simgrid.s4u;

public abstract class CallbackDHostDouble {
  /** This method shall contain the code of your callback */
  public abstract double run(Host h, double d);

  /* Internal method to ensure that your callback can be called from C++ */
  public final double run(long h, double d) { return run(new Host(h), d); }
}