--[[
Copyright (C) 2013-2018 Draios Inc dba Sysdig.

This file is part of sysdig.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

--]]

view_info = 
{
	id = "docker_events",
	name = "Docker Events",
	description = "Lists all the events generated by docker activity, for example container start, stop, kill, etc.",
	tags = {"Default", "nocsysdig"},
	view_type = "list",
	applies_to = {""},
	filter = "evt.type=infra",
	use_defaults = true,
	columns = 
	{
		{
			name = "TIME",
			field = "evt.time",
			description = "Time when the event happened.",
			colsize = 18,
		},
		{
			name = "EVENT TYPE",
			field = "evt.arg.name",
			description = "Type of docker event.",
			colsize = 20,
		},
		{
			name = "CONTAINER ID",
			field = "evt.infra.docker.container.id",
			description = "ID of the container that generated this event.",
			colsize = 20,
		},
		{
			name = "CONTAINER IMAGE",
			field = "evt.infra.docker.container.image",
			description = "Image name of the container that generated this event.",
			colsize = 20,
		},
		{
			name = "CONTAINER NAME",
			field = "evt.infra.docker.container.name",
			description = "Name of the container that generated this event.",
			colsize = 0,
		},
	}
}
