---
draft: false
date: 2023-01-09
categories:
  - DevLog
authors:
  - davep
---

# So you're looking for a wee bit of Textual help...

## Introduction

!!! quote

    Patience, Highlander. You have done well. But it'll take time. You are
    generations being born and dying. You are at one with all living things.
    Each man's thoughts and dreams are yours to know. You have power beyond
    imagination. Use it well, my friend. Don't lose your head.

    <cite>Juan Sánchez Villalobos Ramírez, Chief metallurgist to King Charles V of Spain</cite>

As of the time of writing, I'm a couple or so days off having been with
Textualize for 3 months. It's been fun, and educational, and every bit as
engaging as I'd hoped, and more. One thing I hadn't quite prepared for
though, but which I really love, is how so many other people are learning
Textual along with me.

<!-- more -->

Even in those three months the library has changed and expanded quite a lot,
and it continues to do so. Meanwhile, more people are turning up and using
the framework; you can see this online in social media, blogs and of course
[in the ever-growing list of projects on GitHub which depend on
Textual](https://github.com/Textualize/textual/network/dependents).

This inevitably means there's a lot of people getting to grips with a new
tool, and one that is still a bit of a moving target. This in turn means
lots of people are coming to us to get help.

As I've watched this happen I've noticed a few patterns emerging. Some of
these good or neutral, some... let's just say not really beneficial to those
seeking the help, or to those trying to provide the help. So I wanted to
write a little bit about the different ways you can get help with Textual
and your Textual-based projects, and to also try and encourage people to
take the most helpful and positive approach to getting that help.

Now, before I go on, I want to make something *very* clear: I'm writing this
as an individual. This is my own personal view, and my own advice from me to
anyone who wishes to take it. It's not Textual (the project) or Textualize
(the company) policy, rules or guidelines. This is just some ageing hacker's
take on how best to go about asking for help, informed by years of asking
for and also providing help in email, on Usenet, on forums, etc.

Or, put another way: if what you read in here seems sensible to you, I
figure we'll likely have already hit it off [over on
GitHub](https://github.com/Textualize/textual) or in [the Discord
server](https://discord.gg/Enf6Z3qhVr). ;-)

## Where to go for help

At this point this is almost a bit of an FAQ itself, so I thought I'd
address it here: where's the best place to ask for help about Textual, and
what's the difference between GitHub Issues, Discussions and our Discord
server?

I'd suggest thinking of them like this:

### Discord

You have a question, or need help with something, and perhaps you could do
with a reply as soon as possible. But, and this is the **really important
part**, it doesn't matter if you don't get a response. If you're in this
situation then the Discord server is possibly a good place to start. If
you're lucky someone will be hanging about who can help out.

I can't speak for anyone else, but keep this in mind: when I look in on
Discord I tend not to go scrolling back much to see if anything has been
missed. If something catches my eye, I'll try and reply, but if it
doesn't... well, it's mostly an instant chat thing so I don't dive too
deeply back in time.

!!! tip inline end "Going from Discord to a GitHub issue"

    As a slight aside here: sometimes people will pop up in Discord, ask a
    question about something that turns out looking like a bug, and that's
    the last we hear of it. Please, please, **please**, if this happens, the
    most helpful thing you can do is go raise an issue for us. It'll help us
    to keep track of problems, it'll help get your problem fixed, it'll mean
    everyone benefits.

My own advice would be to treat Discord as an ephemeral resource. It happens
in the moment but fades away pretty quickly. It's like knocking on a
friend's door to see if they're in. If they're not in, you might leave them
a note, which is sort of like going to...

### GitHub

On the other hand, if you have a question or need some help or something
where you want to stand a good chance of the Textual developers (amongst
others) seeing it and responding, I'd recommend that GitHub is the place to
go. Dropping something into the discussions there, or leaving an issue,
ensures it'll get seen. It won't get lost.

As for which you should use -- a discussion or an issue -- I'd suggest this:
if you need help with something, or you want to check your understanding of
something, or you just want to be sure something is a problem before taking
it further, a discussion might be the best thing. On the other hand, if
you've got a clear bug or feature request on your hands, an issue makes a
lot of sense.

Don't worry if you're not sure which camp your question or whatever falls
into though; go with what you think is right. There's no harm done either
way (I may move an issue to a discussion first before replying, if it's
really just a request for help -- but that's mostly so everyone can benefit
from finding it in the right place later on down the line).

## The dos and don'ts of getting help

Now on to the fun part. This is where I get a bit preachy. Ish. Kinda. A
little bit. Again, please remember, this isn't a set of rules, this isn't a
set of official guidelines, this is just a bunch of *"if you want my advice,
and I know you didn't ask but you've read this far so you actually sort of
did don't say I didn't warn you!"* waffle.

This isn't going to be an exhaustive collection, far from it. But I feel
these are some important highlights.

### Do...

When looking for help, in any of the locations mentioned above, I'd totally
encourage:

#### Be clear and detailed

Too much detail is almost always way better than not enough. *"My program
didn't run"*, often even with some of the code supplied, is so much harder
to help than *"I ran this code I'm posting here, and I expected this
particular outcome, and I expected it because I'd read this particular thing
in the docs and had comprehended it to mean this, but instead the outcome
was this exception here, and I'm a bit stuck -- can someone offer some
pointers?"*

The former approach means there often ends up having to be a back and forth
which can last a long time, and which can sometimes be frustrating for the
person asking. Manage frustration: be clear, tell us everything you can.

#### Say what resources you've used already

If you've read the potions of the documentation that relate to what you're
trying to do, it's going to be really helpful if you say so. If you don't,
it might be assumed you haven't and you may end up being pointed at them.

So, please, if you've checked the documentation, looked in the FAQ, done a
search of past issues or discussions or perhaps even done a search on the
Discord server... please say so.

#### Be polite

This one can go a long way when looking for help. Look, I get it,
programming is bloody frustrating at times. We've all rage-quit some code at
some point, I'm sure. It's likely going to be your moment of greatest
frustration when you go looking for help. But if you turn up looking for
help acting all grumpy and stuff it's not going to come over well. Folk are
less likely to be motivated to lend a hand to someone who seems rather
annoyed.

If you throw in a please and thank-you here and there that makes it all the
better.

#### Fully consider the replies

You could find yourself getting a reply that you're sure won't help at all.
That's fair. But be sure to fully consider it first. Perhaps you missed the
obvious along the way and this is 100% the course correction you'd
unknowingly come looking for in the first place. Sure, the person replying
might have totally misunderstood what was being asked, or might be giving a
wrong answer (it me! I've totally done that and will again!), but even then
a reply along the lines of *"I'm not sure that's what I'm looking for,
because..."* gets everyone to the solution faster than *"lol nah"*.

#### Entertain what might seem like odd questions

Aye, I get it, being asked questions when you're looking for an *answer* can
be a bit frustrating. But if you find yourself on the receiving end of a
small series of questions about your question, keep this in mind: Textual is
still rather new and still developing and it's possible that what you're
trying to do isn't the correct way to do that thing. To the person looking
to help you it may seem to them you have an [XY
problem](https://en.wikipedia.org/wiki/XY_problem).

Entertaining those questions might just get you to the real solution to your
problem.

#### Allow for language differences

You don't need me to tell you that a project such as Textual has a global
audience. With that rather obvious fact comes the other fact that we don't
all share the same first language. So, please, as much as possible, try and
allow for that. If someone is trying to help you out, and they make it clear
they're struggling to follow you, keep this in mind.

#### Acknowledge the answer

I suppose this is a variation on "be polite" (really, a thanks can go a long
way), but there's more to this than a friendly acknowledgement. If someone
has gone to the trouble of offering some help, it's helpful to everyone who
comes after you to acknowledge if it worked or not. That way a future
help-seeker will know if the answer they're reading stands a chance of being
the right one.

#### Accept that Textual is zero-point software (right now)

Of course the aim is to have every release of Textual be stable and useful,
but things will break. So, please, do keep in mind things like:

- Textual likely doesn't have your feature of choice just yet.
- We might accidentally break something (perhaps pinning Textual and testing
  each release is a good plan here?).
- We might deliberately break something because we've decided to take a
  particular feature or way of doing things in a better direction.

Of course it can be a bit frustrating a times, but overall the aim is to
have the best framework possible in the long run.

### Don't...

Okay, now for a bit of old-hacker finger-wagging. Here's a few things I'd
personally discourage:

#### Lack patience

Sure, it can be annoying. You're in your flow, you've got a neat idea for a
thing you want to build, you're stuck on one particular thing and you really
need help right now! Thing is, that's unlikely to happen. Badgering
individuals, or a whole resource, to reply right now, or complaining that
it's been `$TIME_PERIOD` since you asked and nobody has replied... that's
just going to make people less likely to reply.

#### Unnecessarily tag individuals

This one often goes hand in hand with the "lack patience" thing: Be it
asking on Discord, or in GitHub issues, discussions or even PRs,
unnecessarily tagging individuals is a bit rude. Speaking for myself and
only myself: I *love* helping folk with Textual. If I could help everyone
all the time the moment they have a problem, I would. But it doesn't work
like that. There's any number of reasons I might not be responding to a
particular request, including but not limited to (here I'm talking
personally because I don't want to speak for anyone else, but I'm sure I'm
not alone here):

- I have a job. Sure, my job is (in part) Textual, but there's more to it
  than that particular issue. I might be doing other stuff.
- I have my own projects to work on too. I like coding for fun as well (or
  writing preaching old dude blog posts like this I guess, but you get the
  idea).
- I actually have other interests outside of work hours so I might actually
  be out doing a 10k in the local glen, or battling headcrabs in VR, or
  something.
- Housework. :-/

You get the idea though. So while I'm off having a well-rounded life, it's
not good to get unnecessarily intrusive alerts to something that either a)
doesn't actually directly involve me or b) could wait.

#### Seek personal support

Again, I'm going to speak totally for myself here, but I also feel the
general case is polite for all: there's a lot of good support resources
available already; sending DMs on Discord or Twitter or in the Fediverse,
looking for direct personal support, isn't really the best way to get help.
Using the public/collective resources is absolutely the *best* way to get
that help. Why's it a bad idea to dive into DMs? Here's some reasons I think
it's not a good idea:

- It's a variation on "unnecessarily tagging individuals".
- You're short-changing yourself when it comes to getting help. If you ask
  somewhere more public you're asking a much bigger audience, who
  collectively have more time, more knowledge and more experience than a
  single individual.
- Following on from that, any answers can be (politely) fact-checked or
  enhanced by that audience, resulting in a better chance of getting the
  best help possible.
- The next seeker-of-help gets to miss out on your question and the answer.
  If asked and answered in public, it's a record that can help someone else
  in the future.

#### Doubt your ability or skill level

I suppose this should really be phrased as a do rather than a don't, as here
I want to encourage something positive. A few times I've helped people out
who have been very apologetic about their questions being "noob" questions,
or about how they're fairly new to Python, or programming in general.
Really, please, don't feel the need to apologise and don't be ashamed of
where you're at.

If you've asked something that's obviously answered in the documentation,
that's not a problem; you'll likely get pointed at the docs and it's what
happens next that's the key bit. If the attitude is *"oh, cool, that's
exactly what I needed to be reading, thanks!"* that's a really positive
thing. The only time it's a problem is when there's a real reluctance to use
the available resources. We've all seen that person somewhere at some point,
right? ;-)

Not knowing things [is totally cool](https://xkcd.com/1053/).

## Conclusion

So, that's my waffle over. As I said at the start: this is my own personal
thoughts on how to get help with Textual, both as someone whose job it is to
work on Textual and help people with Textual, and also as a FOSS advocate
and supporter who can normally be found helping Textual users when he's not
"on the clock" too.

What I've written here isn't exhaustive. Neither is it novel. Plenty has
been written on the general subject in the past, and I'm sure more will be
written on the subject in the future. I do, however, feel that these are the
most common things I notice. I'd say those dos and don'ts cover 90% of *"can
I get some help?"* interactions; perhaps closer to 99%.

Finally, and I think this is the most important thing to remember, the next
time you are battling some issue while working with Textual: [don't lose
your head](https://www.youtube.com/watch?v=KdYvKF9O7Y8)!
