\set ORACLE_USER system
\set ORACLE_PASS oracle
\set ORACLE_SVC xe
\set ORACLE_HOST `docker port oracle 1521`

\prompt NAME 'Create database user: '
\prompt -password PASS 'Password for "':NAME'": '

\connect 'oracle://':ORACLE_USER':':ORACLE_PASS'@':ORACLE_HOST'/':ORACLE_SVC

\set DATNAME :NAME.dat

CREATE
  TABLESPACE :NAME
  NOLOGGING
  DATAFILE :'DATNAME'
  SIZE 100m
  AUTOEXTEND ON;

CREATE
  USER :NAME
  IDENTIFIED BY :NAME
  DEFAULT TABLESPACE :NAME;

GRANT
  CREATE SESSION,
  CREATE TABLE,
  CREATE VIEW,
  CREATE SEQUENCE,
  CREATE PROCEDURE,
  CREATE TRIGGER,
  UNLIMITED TABLESPACE,
  SELECT ANY DICTIONARY
TO :NAME;

ALTER SYSTEM
  SET OPEN_CURSORS=400
  SCOPE=both;
