/* ppc32-sha256-asm
 *
 * Copyright (C) 2006-2025 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

/* Generated using (from wolfssl):
 *   cd ../scripts
 *   ruby ./sha2/sha256.rb ppc32 \
 *       ../wolfssl/wolfcrypt/src/port/ppc32/ppc32-sha256-asm.c
 */

#include <wolfssl/wolfcrypt/libwolfssl_sources_asm.h>
#include <wolfssl/wolfcrypt/error-crypt.h>

#ifdef WOLFSSL_PPC32_ASM
#include <stdint.h>
#include <wolfssl/wolfcrypt/libwolfssl_sources.h>
#ifdef WOLFSSL_PPC32_ASM_INLINE

#ifdef __IAR_SYSTEMS_ICC__
#define __asm__        asm
#define __volatile__   volatile
#define WOLFSSL_NO_VAR_ASSIGN_REG
#endif /* __IAR_SYSTEMS_ICC__ */
#ifdef __KEIL__
#define __asm__        __asm
#define __volatile__   volatile
#endif /* __KEIL__ */
#ifdef __ghs__
#define __asm__        __asm
#define __volatile__
#define WOLFSSL_NO_VAR_ASSIGN_REG
#endif /* __ghs__ */
#ifndef NO_SHA256
#include <wolfssl/wolfcrypt/sha256.h>

#ifdef WOLFSSL_PPC32_ASM_SPE
static const word32 L_SHA256_transform_spe_len_k[] = {
    0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
    0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
    0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
    0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
    0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
    0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
    0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
    0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
    0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
    0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
    0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
    0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
    0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
    0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
    0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
    0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2,
};

void Transform_Sha256_Len(wc_Sha256* sha256_p, const byte* data_p,
    word32 len_p);
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
void Transform_Sha256_Len(wc_Sha256* sha256_p, const byte* data_p, word32 len_p)
#else
void Transform_Sha256_Len(wc_Sha256* sha256, const byte* data, word32 len)
#endif /* WOLFSSL_NO_VAR_ASSIGN_REG */
{
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
    register wc_Sha256* sha256 asm ("3") = (wc_Sha256*)sha256_p;
    register const byte* data asm ("4") = (const byte*)data_p;
    register word32 len asm ("5") = (word32)len_p;
    register word32* L_SHA256_transform_spe_len_k_c asm ("6") =
        (word32*)&L_SHA256_transform_spe_len_k;
#else
    register word32* L_SHA256_transform_spe_len_k_c =
        (word32*)&L_SHA256_transform_spe_len_k;

#endif /* !WOLFSSL_NO_VAR_ASSIGN_REG */

    __asm__ __volatile__ (
        "srwi    %[len], %[len], 6\n\t"
        "mr      30, %[L_SHA256_transform_spe_len_k]\n\t"
        /* Load digest into registers */
        "lwz     14, 0(%[sha256])\n\t"
        "lwz     15, 4(%[sha256])\n\t"
        "lwz     16, 8(%[sha256])\n\t"
        "lwz     17, 12(%[sha256])\n\t"
        "lwz     18, 16(%[sha256])\n\t"
        "lwz     19, 20(%[sha256])\n\t"
        "lwz     20, 24(%[sha256])\n\t"
        "lwz     21, 28(%[sha256])\n\t"
        /* Start of loop processing a block */
        "\n"
    "L_SHA256_transform_spe_len_begin_%=: \n\t"
        /* Load W */
        "lwz     22, 0(%[data])\n\t"
        "lwz     0, 4(%[data])\n\t"
        "evmergelo       22, 0, 22\n\t"
        "lwz     23, 8(%[data])\n\t"
        "lwz     0, 12(%[data])\n\t"
        "evmergelo       23, 0, 23\n\t"
        "lwz     24, 16(%[data])\n\t"
        "lwz     0, 20(%[data])\n\t"
        "evmergelo       24, 0, 24\n\t"
        "lwz     25, 24(%[data])\n\t"
        "lwz     0, 28(%[data])\n\t"
        "evmergelo       25, 0, 25\n\t"
        "lwz     26, 32(%[data])\n\t"
        "lwz     0, 36(%[data])\n\t"
        "evmergelo       26, 0, 26\n\t"
        "lwz     27, 40(%[data])\n\t"
        "lwz     0, 44(%[data])\n\t"
        "evmergelo       27, 0, 27\n\t"
        "lwz     28, 48(%[data])\n\t"
        "lwz     0, 52(%[data])\n\t"
        "evmergelo       28, 0, 28\n\t"
        "lwz     29, 56(%[data])\n\t"
        "lwz     0, 60(%[data])\n\t"
        "evmergelo       29, 0, 29\n\t"
        "li      0, 3\n\t"
        "mtctr   0\n\t"
        /* Start of 16 rounds */
        "\n"
    "L_SHA256_transform_spe_len_start_%=: \n\t"
        /* Round 0 */
        "mr      9, 22\n\t"
        "rotlwi  6, 18, 26\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 18, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 18\n\t"
        "rotlwi  8, 18, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        "lwz     6, 0(30)\n\t"
        "add     21, 21, 9\n\t"
        "add     21, 21, 6\n\t"
        "add     17, 17, 21\n\t"
        "rotlwi  6, 14, 30\n\t"
        "xor     7, 14, 15\n\t"
        "rotlwi  8, 14, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 15, 16\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 14, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 15\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        /* Round 1 */
        "evmergehi       9, 22, 22\n\t"
        /* Calc new W[0]-W[1] */
        "evmergelohi     12, 23, 22\n\t"
        "rotlwi  6, 17, 26\n\t"
        "evrlwi  10, 29, 15\n\t"
        "xor     7, 18, 19\n\t"
        "evrlwi  11, 29, 13\n\t"
        "rotlwi  8, 17, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 29, 10\n\t"
        "and     7, 7, 17\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 17, 7\n\t"
        "evaddw  22, 22, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 27, 26\n\t"
        "xor     7, 7, 19\n\t"
        "evaddw  22, 22, 10\n\t"
        "add     20, 20, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     20, 20, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 4(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     20, 20, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     20, 20, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     16, 16, 20\n\t"
        "evaddw  22, 22, 11\n\t"
        "rotlwi  6, 21, 30\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 21, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 14, 15\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 21, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     20, 20, 6\n\t"
        "add     20, 20, 7\n\t"
        /* Round 2 */
        "mr      9, 23\n\t"
        "rotlwi  6, 16, 26\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 16, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 16\n\t"
        "rotlwi  8, 16, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        "lwz     6, 8(30)\n\t"
        "add     19, 19, 9\n\t"
        "add     19, 19, 6\n\t"
        "add     15, 15, 19\n\t"
        "rotlwi  6, 20, 30\n\t"
        "xor     7, 20, 21\n\t"
        "rotlwi  8, 20, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 21, 14\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 20, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 21\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        /* Round 3 */
        "evmergehi       9, 23, 23\n\t"
        /* Calc new W[2]-W[3] */
        "evmergelohi     12, 24, 23\n\t"
        "rotlwi  6, 15, 26\n\t"
        "evrlwi  10, 22, 15\n\t"
        "xor     7, 16, 17\n\t"
        "evrlwi  11, 22, 13\n\t"
        "rotlwi  8, 15, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 22, 10\n\t"
        "and     7, 7, 15\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 15, 7\n\t"
        "evaddw  23, 23, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 28, 27\n\t"
        "xor     7, 7, 17\n\t"
        "evaddw  23, 23, 10\n\t"
        "add     18, 18, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     18, 18, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 12(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     18, 18, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     18, 18, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     14, 14, 18\n\t"
        "evaddw  23, 23, 11\n\t"
        "rotlwi  6, 19, 30\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 19, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 20, 21\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 19, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     18, 18, 6\n\t"
        "add     18, 18, 7\n\t"
        /* Round 4 */
        "mr      9, 24\n\t"
        "rotlwi  6, 14, 26\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 14, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 14\n\t"
        "rotlwi  8, 14, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        "lwz     6, 16(30)\n\t"
        "add     17, 17, 9\n\t"
        "add     17, 17, 6\n\t"
        "add     21, 21, 17\n\t"
        "rotlwi  6, 18, 30\n\t"
        "xor     7, 18, 19\n\t"
        "rotlwi  8, 18, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 19, 20\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 18, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 19\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        /* Round 5 */
        "evmergehi       9, 24, 24\n\t"
        /* Calc new W[4]-W[5] */
        "evmergelohi     12, 25, 24\n\t"
        "rotlwi  6, 21, 26\n\t"
        "evrlwi  10, 23, 15\n\t"
        "xor     7, 14, 15\n\t"
        "evrlwi  11, 23, 13\n\t"
        "rotlwi  8, 21, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 23, 10\n\t"
        "and     7, 7, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 21, 7\n\t"
        "evaddw  24, 24, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 29, 28\n\t"
        "xor     7, 7, 15\n\t"
        "evaddw  24, 24, 10\n\t"
        "add     16, 16, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     16, 16, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 20(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     16, 16, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     16, 16, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     20, 20, 16\n\t"
        "evaddw  24, 24, 11\n\t"
        "rotlwi  6, 17, 30\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 17, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 18, 19\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 17, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     16, 16, 6\n\t"
        "add     16, 16, 7\n\t"
        /* Round 6 */
        "mr      9, 25\n\t"
        "rotlwi  6, 20, 26\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 20, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 20\n\t"
        "rotlwi  8, 20, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        "lwz     6, 24(30)\n\t"
        "add     15, 15, 9\n\t"
        "add     15, 15, 6\n\t"
        "add     19, 19, 15\n\t"
        "rotlwi  6, 16, 30\n\t"
        "xor     7, 16, 17\n\t"
        "rotlwi  8, 16, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 17, 18\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 16, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 17\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        /* Round 7 */
        "evmergehi       9, 25, 25\n\t"
        /* Calc new W[6]-W[7] */
        "evmergelohi     12, 26, 25\n\t"
        "rotlwi  6, 19, 26\n\t"
        "evrlwi  10, 24, 15\n\t"
        "xor     7, 20, 21\n\t"
        "evrlwi  11, 24, 13\n\t"
        "rotlwi  8, 19, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 24, 10\n\t"
        "and     7, 7, 19\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 19, 7\n\t"
        "evaddw  25, 25, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 22, 29\n\t"
        "xor     7, 7, 21\n\t"
        "evaddw  25, 25, 10\n\t"
        "add     14, 14, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     14, 14, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 28(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     14, 14, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     14, 14, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     18, 18, 14\n\t"
        "evaddw  25, 25, 11\n\t"
        "rotlwi  6, 15, 30\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 15, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 16, 17\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 15, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     14, 14, 6\n\t"
        "add     14, 14, 7\n\t"
        /* Round 8 */
        "mr      9, 26\n\t"
        "rotlwi  6, 18, 26\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 18, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 18\n\t"
        "rotlwi  8, 18, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        "lwz     6, 32(30)\n\t"
        "add     21, 21, 9\n\t"
        "add     21, 21, 6\n\t"
        "add     17, 17, 21\n\t"
        "rotlwi  6, 14, 30\n\t"
        "xor     7, 14, 15\n\t"
        "rotlwi  8, 14, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 15, 16\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 14, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 15\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        /* Round 9 */
        "evmergehi       9, 26, 26\n\t"
        /* Calc new W[8]-W[9] */
        "evmergelohi     12, 27, 26\n\t"
        "rotlwi  6, 17, 26\n\t"
        "evrlwi  10, 25, 15\n\t"
        "xor     7, 18, 19\n\t"
        "evrlwi  11, 25, 13\n\t"
        "rotlwi  8, 17, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 25, 10\n\t"
        "and     7, 7, 17\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 17, 7\n\t"
        "evaddw  26, 26, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 23, 22\n\t"
        "xor     7, 7, 19\n\t"
        "evaddw  26, 26, 10\n\t"
        "add     20, 20, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     20, 20, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 36(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     20, 20, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     20, 20, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     16, 16, 20\n\t"
        "evaddw  26, 26, 11\n\t"
        "rotlwi  6, 21, 30\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 21, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 14, 15\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 21, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     20, 20, 6\n\t"
        "add     20, 20, 7\n\t"
        /* Round 10 */
        "mr      9, 27\n\t"
        "rotlwi  6, 16, 26\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 16, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 16\n\t"
        "rotlwi  8, 16, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        "lwz     6, 40(30)\n\t"
        "add     19, 19, 9\n\t"
        "add     19, 19, 6\n\t"
        "add     15, 15, 19\n\t"
        "rotlwi  6, 20, 30\n\t"
        "xor     7, 20, 21\n\t"
        "rotlwi  8, 20, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 21, 14\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 20, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 21\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        /* Round 11 */
        "evmergehi       9, 27, 27\n\t"
        /* Calc new W[10]-W[11] */
        "evmergelohi     12, 28, 27\n\t"
        "rotlwi  6, 15, 26\n\t"
        "evrlwi  10, 26, 15\n\t"
        "xor     7, 16, 17\n\t"
        "evrlwi  11, 26, 13\n\t"
        "rotlwi  8, 15, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 26, 10\n\t"
        "and     7, 7, 15\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 15, 7\n\t"
        "evaddw  27, 27, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 24, 23\n\t"
        "xor     7, 7, 17\n\t"
        "evaddw  27, 27, 10\n\t"
        "add     18, 18, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     18, 18, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 44(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     18, 18, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     18, 18, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     14, 14, 18\n\t"
        "evaddw  27, 27, 11\n\t"
        "rotlwi  6, 19, 30\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 19, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 20, 21\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 19, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     18, 18, 6\n\t"
        "add     18, 18, 7\n\t"
        /* Round 12 */
        "mr      9, 28\n\t"
        "rotlwi  6, 14, 26\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 14, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 14\n\t"
        "rotlwi  8, 14, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        "lwz     6, 48(30)\n\t"
        "add     17, 17, 9\n\t"
        "add     17, 17, 6\n\t"
        "add     21, 21, 17\n\t"
        "rotlwi  6, 18, 30\n\t"
        "xor     7, 18, 19\n\t"
        "rotlwi  8, 18, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 19, 20\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 18, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 19\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        /* Round 13 */
        "evmergehi       9, 28, 28\n\t"
        /* Calc new W[12]-W[13] */
        "evmergelohi     12, 29, 28\n\t"
        "rotlwi  6, 21, 26\n\t"
        "evrlwi  10, 27, 15\n\t"
        "xor     7, 14, 15\n\t"
        "evrlwi  11, 27, 13\n\t"
        "rotlwi  8, 21, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 27, 10\n\t"
        "and     7, 7, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 21, 7\n\t"
        "evaddw  28, 28, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 25, 24\n\t"
        "xor     7, 7, 15\n\t"
        "evaddw  28, 28, 10\n\t"
        "add     16, 16, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     16, 16, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 52(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     16, 16, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     16, 16, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     20, 20, 16\n\t"
        "evaddw  28, 28, 11\n\t"
        "rotlwi  6, 17, 30\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 17, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 18, 19\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 17, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     16, 16, 6\n\t"
        "add     16, 16, 7\n\t"
        /* Round 14 */
        "mr      9, 29\n\t"
        "rotlwi  6, 20, 26\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 20, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 20\n\t"
        "rotlwi  8, 20, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        "lwz     6, 56(30)\n\t"
        "add     15, 15, 9\n\t"
        "add     15, 15, 6\n\t"
        "add     19, 19, 15\n\t"
        "rotlwi  6, 16, 30\n\t"
        "xor     7, 16, 17\n\t"
        "rotlwi  8, 16, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 17, 18\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 16, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 17\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        /* Round 15 */
        "evmergehi       9, 29, 29\n\t"
        /* Calc new W[14]-W[15] */
        "evmergelohi     12, 22, 29\n\t"
        "rotlwi  6, 19, 26\n\t"
        "evrlwi  10, 28, 15\n\t"
        "xor     7, 20, 21\n\t"
        "evrlwi  11, 28, 13\n\t"
        "rotlwi  8, 19, 21\n\t"
        "evxor   11, 11, 10\n\t"
        "xor     6, 6, 8\n\t"
        "evsrwiu 10, 28, 10\n\t"
        "and     7, 7, 19\n\t"
        "evxor   11, 11, 10\n\t"
        "rotlwi  8, 19, 7\n\t"
        "evaddw  29, 29, 11\n\t"
        "xor     6, 6, 8\n\t"
        "evmergelohi     10, 26, 25\n\t"
        "xor     7, 7, 21\n\t"
        "evaddw  29, 29, 10\n\t"
        "add     14, 14, 6\n\t"
        "evrlwi  10, 12, 25\n\t"
        "add     14, 14, 7\n\t"
        "evrlwi  11, 12, 14\n\t"
        "lwz     6, 60(30)\n\t"
        "evxor   11, 11, 10\n\t"
        "add     14, 14, 9\n\t"
        "evsrwiu 12, 12, 3\n\t"
        "add     14, 14, 6\n\t"
        "evxor   11, 11, 12\n\t"
        "add     18, 18, 14\n\t"
        "evaddw  29, 29, 11\n\t"
        "rotlwi  6, 15, 30\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 15, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 16, 17\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 15, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     14, 14, 6\n\t"
        "add     14, 14, 7\n\t"
        "addi    30, 30, 0x40\n\t"
        "bdnz    L_SHA256_transform_spe_len_start_%=\n\t"
        /* Round 0 */
        "mr      9, 22\n\t"
        "rotlwi  6, 18, 26\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 18, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 18\n\t"
        "rotlwi  8, 18, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        "lwz     6, 0(30)\n\t"
        "add     21, 21, 9\n\t"
        "add     21, 21, 6\n\t"
        "add     17, 17, 21\n\t"
        "rotlwi  6, 14, 30\n\t"
        "xor     7, 14, 15\n\t"
        "rotlwi  8, 14, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 15, 16\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 14, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 15\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        /* Round 1 */
        "evmergehi       9, 22, 22\n\t"
        "rotlwi  6, 17, 26\n\t"
        "xor     7, 18, 19\n\t"
        "rotlwi  8, 17, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 17\n\t"
        "rotlwi  8, 17, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 19\n\t"
        "add     20, 20, 6\n\t"
        "add     20, 20, 7\n\t"
        "lwz     6, 4(30)\n\t"
        "add     20, 20, 9\n\t"
        "add     20, 20, 6\n\t"
        "add     16, 16, 20\n\t"
        "rotlwi  6, 21, 30\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 21, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 14, 15\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 21, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     20, 20, 6\n\t"
        "add     20, 20, 7\n\t"
        /* Round 2 */
        "mr      9, 23\n\t"
        "rotlwi  6, 16, 26\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 16, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 16\n\t"
        "rotlwi  8, 16, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        "lwz     6, 8(30)\n\t"
        "add     19, 19, 9\n\t"
        "add     19, 19, 6\n\t"
        "add     15, 15, 19\n\t"
        "rotlwi  6, 20, 30\n\t"
        "xor     7, 20, 21\n\t"
        "rotlwi  8, 20, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 21, 14\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 20, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 21\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        /* Round 3 */
        "evmergehi       9, 23, 23\n\t"
        "rotlwi  6, 15, 26\n\t"
        "xor     7, 16, 17\n\t"
        "rotlwi  8, 15, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 15\n\t"
        "rotlwi  8, 15, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 17\n\t"
        "add     18, 18, 6\n\t"
        "add     18, 18, 7\n\t"
        "lwz     6, 12(30)\n\t"
        "add     18, 18, 9\n\t"
        "add     18, 18, 6\n\t"
        "add     14, 14, 18\n\t"
        "rotlwi  6, 19, 30\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 19, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 20, 21\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 19, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     18, 18, 6\n\t"
        "add     18, 18, 7\n\t"
        /* Round 4 */
        "mr      9, 24\n\t"
        "rotlwi  6, 14, 26\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 14, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 14\n\t"
        "rotlwi  8, 14, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        "lwz     6, 16(30)\n\t"
        "add     17, 17, 9\n\t"
        "add     17, 17, 6\n\t"
        "add     21, 21, 17\n\t"
        "rotlwi  6, 18, 30\n\t"
        "xor     7, 18, 19\n\t"
        "rotlwi  8, 18, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 19, 20\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 18, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 19\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        /* Round 5 */
        "evmergehi       9, 24, 24\n\t"
        "rotlwi  6, 21, 26\n\t"
        "xor     7, 14, 15\n\t"
        "rotlwi  8, 21, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 21\n\t"
        "rotlwi  8, 21, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 15\n\t"
        "add     16, 16, 6\n\t"
        "add     16, 16, 7\n\t"
        "lwz     6, 20(30)\n\t"
        "add     16, 16, 9\n\t"
        "add     16, 16, 6\n\t"
        "add     20, 20, 16\n\t"
        "rotlwi  6, 17, 30\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 17, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 18, 19\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 17, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     16, 16, 6\n\t"
        "add     16, 16, 7\n\t"
        /* Round 6 */
        "mr      9, 25\n\t"
        "rotlwi  6, 20, 26\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 20, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 20\n\t"
        "rotlwi  8, 20, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        "lwz     6, 24(30)\n\t"
        "add     15, 15, 9\n\t"
        "add     15, 15, 6\n\t"
        "add     19, 19, 15\n\t"
        "rotlwi  6, 16, 30\n\t"
        "xor     7, 16, 17\n\t"
        "rotlwi  8, 16, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 17, 18\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 16, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 17\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        /* Round 7 */
        "evmergehi       9, 25, 25\n\t"
        "rotlwi  6, 19, 26\n\t"
        "xor     7, 20, 21\n\t"
        "rotlwi  8, 19, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 19\n\t"
        "rotlwi  8, 19, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 21\n\t"
        "add     14, 14, 6\n\t"
        "add     14, 14, 7\n\t"
        "lwz     6, 28(30)\n\t"
        "add     14, 14, 9\n\t"
        "add     14, 14, 6\n\t"
        "add     18, 18, 14\n\t"
        "rotlwi  6, 15, 30\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 15, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 16, 17\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 15, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     14, 14, 6\n\t"
        "add     14, 14, 7\n\t"
        /* Round 8 */
        "mr      9, 26\n\t"
        "rotlwi  6, 18, 26\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 18, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 18\n\t"
        "rotlwi  8, 18, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        "lwz     6, 32(30)\n\t"
        "add     21, 21, 9\n\t"
        "add     21, 21, 6\n\t"
        "add     17, 17, 21\n\t"
        "rotlwi  6, 14, 30\n\t"
        "xor     7, 14, 15\n\t"
        "rotlwi  8, 14, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 15, 16\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 14, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 15\n\t"
        "add     21, 21, 6\n\t"
        "add     21, 21, 7\n\t"
        /* Round 9 */
        "evmergehi       9, 26, 26\n\t"
        "rotlwi  6, 17, 26\n\t"
        "xor     7, 18, 19\n\t"
        "rotlwi  8, 17, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 17\n\t"
        "rotlwi  8, 17, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 19\n\t"
        "add     20, 20, 6\n\t"
        "add     20, 20, 7\n\t"
        "lwz     6, 36(30)\n\t"
        "add     20, 20, 9\n\t"
        "add     20, 20, 6\n\t"
        "add     16, 16, 20\n\t"
        "rotlwi  6, 21, 30\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 21, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 14, 15\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 21, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     20, 20, 6\n\t"
        "add     20, 20, 7\n\t"
        /* Round 10 */
        "mr      9, 27\n\t"
        "rotlwi  6, 16, 26\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 16, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 16\n\t"
        "rotlwi  8, 16, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        "lwz     6, 40(30)\n\t"
        "add     19, 19, 9\n\t"
        "add     19, 19, 6\n\t"
        "add     15, 15, 19\n\t"
        "rotlwi  6, 20, 30\n\t"
        "xor     7, 20, 21\n\t"
        "rotlwi  8, 20, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 21, 14\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 20, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 21\n\t"
        "add     19, 19, 6\n\t"
        "add     19, 19, 7\n\t"
        /* Round 11 */
        "evmergehi       9, 27, 27\n\t"
        "rotlwi  6, 15, 26\n\t"
        "xor     7, 16, 17\n\t"
        "rotlwi  8, 15, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 15\n\t"
        "rotlwi  8, 15, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 17\n\t"
        "add     18, 18, 6\n\t"
        "add     18, 18, 7\n\t"
        "lwz     6, 44(30)\n\t"
        "add     18, 18, 9\n\t"
        "add     18, 18, 6\n\t"
        "add     14, 14, 18\n\t"
        "rotlwi  6, 19, 30\n\t"
        "xor     7, 19, 20\n\t"
        "rotlwi  8, 19, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 20, 21\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 19, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 20\n\t"
        "add     18, 18, 6\n\t"
        "add     18, 18, 7\n\t"
        /* Round 12 */
        "mr      9, 28\n\t"
        "rotlwi  6, 14, 26\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 14, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 14\n\t"
        "rotlwi  8, 14, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        "lwz     6, 48(30)\n\t"
        "add     17, 17, 9\n\t"
        "add     17, 17, 6\n\t"
        "add     21, 21, 17\n\t"
        "rotlwi  6, 18, 30\n\t"
        "xor     7, 18, 19\n\t"
        "rotlwi  8, 18, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 19, 20\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 18, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 19\n\t"
        "add     17, 17, 6\n\t"
        "add     17, 17, 7\n\t"
        /* Round 13 */
        "evmergehi       9, 28, 28\n\t"
        "rotlwi  6, 21, 26\n\t"
        "xor     7, 14, 15\n\t"
        "rotlwi  8, 21, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 21\n\t"
        "rotlwi  8, 21, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 15\n\t"
        "add     16, 16, 6\n\t"
        "add     16, 16, 7\n\t"
        "lwz     6, 52(30)\n\t"
        "add     16, 16, 9\n\t"
        "add     16, 16, 6\n\t"
        "add     20, 20, 16\n\t"
        "rotlwi  6, 17, 30\n\t"
        "xor     7, 17, 18\n\t"
        "rotlwi  8, 17, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 18, 19\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 17, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 18\n\t"
        "add     16, 16, 6\n\t"
        "add     16, 16, 7\n\t"
        /* Round 14 */
        "mr      9, 29\n\t"
        "rotlwi  6, 20, 26\n\t"
        "xor     7, 21, 14\n\t"
        "rotlwi  8, 20, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 20\n\t"
        "rotlwi  8, 20, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 14\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        "lwz     6, 56(30)\n\t"
        "add     15, 15, 9\n\t"
        "add     15, 15, 6\n\t"
        "add     19, 19, 15\n\t"
        "rotlwi  6, 16, 30\n\t"
        "xor     7, 16, 17\n\t"
        "rotlwi  8, 16, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 17, 18\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 16, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 17\n\t"
        "add     15, 15, 6\n\t"
        "add     15, 15, 7\n\t"
        /* Round 15 */
        "evmergehi       9, 29, 29\n\t"
        "rotlwi  6, 19, 26\n\t"
        "xor     7, 20, 21\n\t"
        "rotlwi  8, 19, 21\n\t"
        "xor     6, 6, 8\n\t"
        "and     7, 7, 19\n\t"
        "rotlwi  8, 19, 7\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 21\n\t"
        "add     14, 14, 6\n\t"
        "add     14, 14, 7\n\t"
        "lwz     6, 60(30)\n\t"
        "add     14, 14, 9\n\t"
        "add     14, 14, 6\n\t"
        "add     18, 18, 14\n\t"
        "rotlwi  6, 15, 30\n\t"
        "xor     7, 15, 16\n\t"
        "rotlwi  8, 15, 19\n\t"
        "xor     6, 6, 8\n\t"
        "xor     8, 16, 17\n\t"
        "and     7, 7, 8\n\t"
        "rotlwi  8, 15, 10\n\t"
        "xor     6, 6, 8\n\t"
        "xor     7, 7, 16\n\t"
        "add     14, 14, 6\n\t"
        "add     14, 14, 7\n\t"
        /* Add in digest from start */
        "lwz     6, 0(%[sha256])\n\t"
        "lwz     7, 4(%[sha256])\n\t"
        "add     14, 14, 6\n\t"
        "add     15, 15, 7\n\t"
        "lwz     6, 8(%[sha256])\n\t"
        "lwz     7, 12(%[sha256])\n\t"
        "add     16, 16, 6\n\t"
        "add     17, 17, 7\n\t"
        "lwz     6, 16(%[sha256])\n\t"
        "lwz     7, 20(%[sha256])\n\t"
        "add     18, 18, 6\n\t"
        "add     19, 19, 7\n\t"
        "lwz     6, 24(%[sha256])\n\t"
        "lwz     7, 28(%[sha256])\n\t"
        "add     20, 20, 6\n\t"
        "add     21, 21, 7\n\t"
        "stw     14, 0(%[sha256])\n\t"
        "stw     15, 4(%[sha256])\n\t"
        "stw     16, 8(%[sha256])\n\t"
        "stw     17, 12(%[sha256])\n\t"
        "stw     18, 16(%[sha256])\n\t"
        "stw     19, 20(%[sha256])\n\t"
        "stw     20, 24(%[sha256])\n\t"
        "stw     21, 28(%[sha256])\n\t"
        "subi    30, 30, 0xc0\n\t"
        "mtctr   %[len]\n\t"
        "addi    %[data], %[data], 0x40\n\t"
        "subi    %[len], %[len], 1\n\t"
        "bdnz    L_SHA256_transform_spe_len_begin_%=\n\t"
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
        : [sha256] "+r" (sha256), [data] "+r" (data), [len] "+r" (len),
          [L_SHA256_transform_spe_len_k] "+r" (L_SHA256_transform_spe_len_k_c)
        :
#else
        :
        : [sha256] "r" (sha256), [data] "r" (data), [len] "r" (len),
          [L_SHA256_transform_spe_len_k] "r" (L_SHA256_transform_spe_len_k_c)
#endif /* !WOLFSSL_NO_VAR_ASSIGN_REG */
        : "memory", "cc", "0", "7", "8", "9", "10", "11", "12", "14", "15",
            "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
            "27", "28", "29", "30"
    );
}

#endif /* WOLFSSL_PPC32_ASM_SPE */
#ifndef WOLFSSL_PPC32_ASM_SPE
#include <wolfssl/wolfcrypt/sha256.h>

static const word32 L_SHA256_transform_len_k[] = {
    0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5,
    0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
    0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3,
    0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
    0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc,
    0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
    0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7,
    0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
    0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13,
    0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
    0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3,
    0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
    0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5,
    0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
    0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208,
    0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2,
};

void Transform_Sha256_Len(wc_Sha256* sha256_p, const byte* data_p,
    word32 len_p);
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
void Transform_Sha256_Len(wc_Sha256* sha256_p, const byte* data_p, word32 len_p)
#else
void Transform_Sha256_Len(wc_Sha256* sha256, const byte* data, word32 len)
#endif /* WOLFSSL_NO_VAR_ASSIGN_REG */
{
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
    register wc_Sha256* sha256 asm ("3") = (wc_Sha256*)sha256_p;
    register const byte* data asm ("4") = (const byte*)data_p;
    register word32 len asm ("5") = (word32)len_p;
    register word32* L_SHA256_transform_len_k_c asm ("6") =
        (word32*)&L_SHA256_transform_len_k;
#else
    register word32* L_SHA256_transform_len_k_c =
        (word32*)&L_SHA256_transform_len_k;

#endif /* !WOLFSSL_NO_VAR_ASSIGN_REG */

    __asm__ __volatile__ (
        "srwi    %[len], %[len], 6\n\t"
        "mr      6, %[L_SHA256_transform_len_k]\n\t"
        /* Copy digest to add in at end */
        "lwz     7, 0(%[sha256])\n\t"
        "lwz     8, 4(%[sha256])\n\t"
        "lwz     9, 8(%[sha256])\n\t"
        "lwz     10, 12(%[sha256])\n\t"
        "lwz     11, 16(%[sha256])\n\t"
        "lwz     12, 20(%[sha256])\n\t"
        "lwz     14, 24(%[sha256])\n\t"
        "lwz     15, 28(%[sha256])\n\t"
#ifndef WOLFSSL_PPC32_ASM_SMALL
        "mtctr   %[len]\n\t"
        /* Start of loop processing a block */
        "\n"
    "L_SHA256_transform_len_begin_%=: \n\t"
        /* Load W - 64 bytes */
        "lwz     16, 0(%[data])\n\t"
        "lwz     17, 4(%[data])\n\t"
        "lwz     18, 8(%[data])\n\t"
        "lwz     19, 12(%[data])\n\t"
        "lwz     20, 16(%[data])\n\t"
        "lwz     21, 20(%[data])\n\t"
        "lwz     22, 24(%[data])\n\t"
        "lwz     23, 28(%[data])\n\t"
        "lwz     24, 32(%[data])\n\t"
        "lwz     25, 36(%[data])\n\t"
        "lwz     26, 40(%[data])\n\t"
        "lwz     27, 44(%[data])\n\t"
        "lwz     28, 48(%[data])\n\t"
        "lwz     29, 52(%[data])\n\t"
        "lwz     30, 56(%[data])\n\t"
        "lwz     31, 60(%[data])\n\t"
        /* Start of 16 rounds */
        /* Round 0 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 0(6)\n\t"
        "add     15, 15, 16\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Calc new W[0] */
        "rotlwi  0, 17, 25\n\t"
        "rotlwi  %[len], 17, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "rotlwi  0, 30, 15\n\t"
        "rotlwi  %[len], 30, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "add     16, 16, 25\n\t"
        /* Round 1 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 4(6)\n\t"
        "add     14, 14, 17\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Calc new W[1] */
        "rotlwi  0, 18, 25\n\t"
        "rotlwi  %[len], 18, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "rotlwi  0, 31, 15\n\t"
        "rotlwi  %[len], 31, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "add     17, 17, 26\n\t"
        /* Round 2 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 8(6)\n\t"
        "add     12, 12, 18\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Calc new W[2] */
        "rotlwi  0, 19, 25\n\t"
        "rotlwi  %[len], 19, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "rotlwi  0, 16, 15\n\t"
        "rotlwi  %[len], 16, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "add     18, 18, 27\n\t"
        /* Round 3 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 12(6)\n\t"
        "add     11, 11, 19\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Calc new W[3] */
        "rotlwi  0, 20, 25\n\t"
        "rotlwi  %[len], 20, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "rotlwi  0, 17, 15\n\t"
        "rotlwi  %[len], 17, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "add     19, 19, 28\n\t"
        /* Round 4 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 16(6)\n\t"
        "add     10, 10, 20\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Calc new W[4] */
        "rotlwi  0, 21, 25\n\t"
        "rotlwi  %[len], 21, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "rotlwi  0, 18, 15\n\t"
        "rotlwi  %[len], 18, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "add     20, 20, 29\n\t"
        /* Round 5 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 20(6)\n\t"
        "add     9, 9, 21\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Calc new W[5] */
        "rotlwi  0, 22, 25\n\t"
        "rotlwi  %[len], 22, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "rotlwi  0, 19, 15\n\t"
        "rotlwi  %[len], 19, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "add     21, 21, 30\n\t"
        /* Round 6 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 24(6)\n\t"
        "add     8, 8, 22\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Calc new W[6] */
        "rotlwi  0, 23, 25\n\t"
        "rotlwi  %[len], 23, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "rotlwi  0, 20, 15\n\t"
        "rotlwi  %[len], 20, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "add     22, 22, 31\n\t"
        /* Round 7 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 28(6)\n\t"
        "add     7, 7, 23\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Calc new W[7] */
        "rotlwi  0, 24, 25\n\t"
        "rotlwi  %[len], 24, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "rotlwi  0, 21, 15\n\t"
        "rotlwi  %[len], 21, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "add     23, 23, 16\n\t"
        /* Round 8 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 32(6)\n\t"
        "add     15, 15, 24\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Calc new W[8] */
        "rotlwi  0, 25, 25\n\t"
        "rotlwi  %[len], 25, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "rotlwi  0, 22, 15\n\t"
        "rotlwi  %[len], 22, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "add     24, 24, 17\n\t"
        /* Round 9 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 36(6)\n\t"
        "add     14, 14, 25\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Calc new W[9] */
        "rotlwi  0, 26, 25\n\t"
        "rotlwi  %[len], 26, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "rotlwi  0, 23, 15\n\t"
        "rotlwi  %[len], 23, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "add     25, 25, 18\n\t"
        /* Round 10 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 40(6)\n\t"
        "add     12, 12, 26\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Calc new W[10] */
        "rotlwi  0, 27, 25\n\t"
        "rotlwi  %[len], 27, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "rotlwi  0, 24, 15\n\t"
        "rotlwi  %[len], 24, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "add     26, 26, 19\n\t"
        /* Round 11 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 44(6)\n\t"
        "add     11, 11, 27\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Calc new W[11] */
        "rotlwi  0, 28, 25\n\t"
        "rotlwi  %[len], 28, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "rotlwi  0, 25, 15\n\t"
        "rotlwi  %[len], 25, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "add     27, 27, 20\n\t"
        /* Round 12 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 48(6)\n\t"
        "add     10, 10, 28\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Calc new W[12] */
        "rotlwi  0, 29, 25\n\t"
        "rotlwi  %[len], 29, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "rotlwi  0, 26, 15\n\t"
        "rotlwi  %[len], 26, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "add     28, 28, 21\n\t"
        /* Round 13 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 52(6)\n\t"
        "add     9, 9, 29\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Calc new W[13] */
        "rotlwi  0, 30, 25\n\t"
        "rotlwi  %[len], 30, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "rotlwi  0, 27, 15\n\t"
        "rotlwi  %[len], 27, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "add     29, 29, 22\n\t"
        /* Round 14 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 56(6)\n\t"
        "add     8, 8, 30\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Calc new W[14] */
        "rotlwi  0, 31, 25\n\t"
        "rotlwi  %[len], 31, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "rotlwi  0, 28, 15\n\t"
        "rotlwi  %[len], 28, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "add     30, 30, 23\n\t"
        /* Round 15 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 60(6)\n\t"
        "add     7, 7, 31\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Calc new W[15] */
        "rotlwi  0, 16, 25\n\t"
        "rotlwi  %[len], 16, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "rotlwi  0, 29, 15\n\t"
        "rotlwi  %[len], 29, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "add     31, 31, 24\n\t"
        "addi    6, 6, 0x40\n\t"
        /* Round 0 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 0(6)\n\t"
        "add     15, 15, 16\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Calc new W[0] */
        "rotlwi  0, 17, 25\n\t"
        "rotlwi  %[len], 17, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "rotlwi  0, 30, 15\n\t"
        "rotlwi  %[len], 30, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "add     16, 16, 25\n\t"
        /* Round 1 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 4(6)\n\t"
        "add     14, 14, 17\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Calc new W[1] */
        "rotlwi  0, 18, 25\n\t"
        "rotlwi  %[len], 18, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "rotlwi  0, 31, 15\n\t"
        "rotlwi  %[len], 31, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "add     17, 17, 26\n\t"
        /* Round 2 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 8(6)\n\t"
        "add     12, 12, 18\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Calc new W[2] */
        "rotlwi  0, 19, 25\n\t"
        "rotlwi  %[len], 19, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "rotlwi  0, 16, 15\n\t"
        "rotlwi  %[len], 16, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "add     18, 18, 27\n\t"
        /* Round 3 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 12(6)\n\t"
        "add     11, 11, 19\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Calc new W[3] */
        "rotlwi  0, 20, 25\n\t"
        "rotlwi  %[len], 20, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "rotlwi  0, 17, 15\n\t"
        "rotlwi  %[len], 17, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "add     19, 19, 28\n\t"
        /* Round 4 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 16(6)\n\t"
        "add     10, 10, 20\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Calc new W[4] */
        "rotlwi  0, 21, 25\n\t"
        "rotlwi  %[len], 21, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "rotlwi  0, 18, 15\n\t"
        "rotlwi  %[len], 18, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "add     20, 20, 29\n\t"
        /* Round 5 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 20(6)\n\t"
        "add     9, 9, 21\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Calc new W[5] */
        "rotlwi  0, 22, 25\n\t"
        "rotlwi  %[len], 22, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "rotlwi  0, 19, 15\n\t"
        "rotlwi  %[len], 19, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "add     21, 21, 30\n\t"
        /* Round 6 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 24(6)\n\t"
        "add     8, 8, 22\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Calc new W[6] */
        "rotlwi  0, 23, 25\n\t"
        "rotlwi  %[len], 23, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "rotlwi  0, 20, 15\n\t"
        "rotlwi  %[len], 20, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "add     22, 22, 31\n\t"
        /* Round 7 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 28(6)\n\t"
        "add     7, 7, 23\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Calc new W[7] */
        "rotlwi  0, 24, 25\n\t"
        "rotlwi  %[len], 24, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "rotlwi  0, 21, 15\n\t"
        "rotlwi  %[len], 21, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "add     23, 23, 16\n\t"
        /* Round 8 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 32(6)\n\t"
        "add     15, 15, 24\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Calc new W[8] */
        "rotlwi  0, 25, 25\n\t"
        "rotlwi  %[len], 25, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "rotlwi  0, 22, 15\n\t"
        "rotlwi  %[len], 22, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "add     24, 24, 17\n\t"
        /* Round 9 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 36(6)\n\t"
        "add     14, 14, 25\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Calc new W[9] */
        "rotlwi  0, 26, 25\n\t"
        "rotlwi  %[len], 26, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "rotlwi  0, 23, 15\n\t"
        "rotlwi  %[len], 23, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "add     25, 25, 18\n\t"
        /* Round 10 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 40(6)\n\t"
        "add     12, 12, 26\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Calc new W[10] */
        "rotlwi  0, 27, 25\n\t"
        "rotlwi  %[len], 27, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "rotlwi  0, 24, 15\n\t"
        "rotlwi  %[len], 24, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "add     26, 26, 19\n\t"
        /* Round 11 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 44(6)\n\t"
        "add     11, 11, 27\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Calc new W[11] */
        "rotlwi  0, 28, 25\n\t"
        "rotlwi  %[len], 28, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "rotlwi  0, 25, 15\n\t"
        "rotlwi  %[len], 25, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "add     27, 27, 20\n\t"
        /* Round 12 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 48(6)\n\t"
        "add     10, 10, 28\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Calc new W[12] */
        "rotlwi  0, 29, 25\n\t"
        "rotlwi  %[len], 29, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "rotlwi  0, 26, 15\n\t"
        "rotlwi  %[len], 26, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "add     28, 28, 21\n\t"
        /* Round 13 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 52(6)\n\t"
        "add     9, 9, 29\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Calc new W[13] */
        "rotlwi  0, 30, 25\n\t"
        "rotlwi  %[len], 30, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "rotlwi  0, 27, 15\n\t"
        "rotlwi  %[len], 27, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "add     29, 29, 22\n\t"
        /* Round 14 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 56(6)\n\t"
        "add     8, 8, 30\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Calc new W[14] */
        "rotlwi  0, 31, 25\n\t"
        "rotlwi  %[len], 31, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "rotlwi  0, 28, 15\n\t"
        "rotlwi  %[len], 28, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "add     30, 30, 23\n\t"
        /* Round 15 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 60(6)\n\t"
        "add     7, 7, 31\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Calc new W[15] */
        "rotlwi  0, 16, 25\n\t"
        "rotlwi  %[len], 16, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "rotlwi  0, 29, 15\n\t"
        "rotlwi  %[len], 29, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "add     31, 31, 24\n\t"
        "addi    6, 6, 0x40\n\t"
        /* Round 0 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 0(6)\n\t"
        "add     15, 15, 16\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Calc new W[0] */
        "rotlwi  0, 17, 25\n\t"
        "rotlwi  %[len], 17, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "rotlwi  0, 30, 15\n\t"
        "rotlwi  %[len], 30, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "add     16, 16, 25\n\t"
        /* Round 1 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 4(6)\n\t"
        "add     14, 14, 17\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Calc new W[1] */
        "rotlwi  0, 18, 25\n\t"
        "rotlwi  %[len], 18, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "rotlwi  0, 31, 15\n\t"
        "rotlwi  %[len], 31, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "add     17, 17, 26\n\t"
        /* Round 2 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 8(6)\n\t"
        "add     12, 12, 18\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Calc new W[2] */
        "rotlwi  0, 19, 25\n\t"
        "rotlwi  %[len], 19, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "rotlwi  0, 16, 15\n\t"
        "rotlwi  %[len], 16, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "add     18, 18, 27\n\t"
        /* Round 3 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 12(6)\n\t"
        "add     11, 11, 19\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Calc new W[3] */
        "rotlwi  0, 20, 25\n\t"
        "rotlwi  %[len], 20, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "rotlwi  0, 17, 15\n\t"
        "rotlwi  %[len], 17, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "add     19, 19, 28\n\t"
        /* Round 4 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 16(6)\n\t"
        "add     10, 10, 20\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Calc new W[4] */
        "rotlwi  0, 21, 25\n\t"
        "rotlwi  %[len], 21, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "rotlwi  0, 18, 15\n\t"
        "rotlwi  %[len], 18, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "add     20, 20, 29\n\t"
        /* Round 5 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 20(6)\n\t"
        "add     9, 9, 21\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Calc new W[5] */
        "rotlwi  0, 22, 25\n\t"
        "rotlwi  %[len], 22, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "rotlwi  0, 19, 15\n\t"
        "rotlwi  %[len], 19, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "add     21, 21, 30\n\t"
        /* Round 6 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 24(6)\n\t"
        "add     8, 8, 22\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Calc new W[6] */
        "rotlwi  0, 23, 25\n\t"
        "rotlwi  %[len], 23, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "rotlwi  0, 20, 15\n\t"
        "rotlwi  %[len], 20, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "add     22, 22, 31\n\t"
        /* Round 7 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 28(6)\n\t"
        "add     7, 7, 23\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Calc new W[7] */
        "rotlwi  0, 24, 25\n\t"
        "rotlwi  %[len], 24, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "rotlwi  0, 21, 15\n\t"
        "rotlwi  %[len], 21, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "add     23, 23, 16\n\t"
        /* Round 8 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 32(6)\n\t"
        "add     15, 15, 24\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Calc new W[8] */
        "rotlwi  0, 25, 25\n\t"
        "rotlwi  %[len], 25, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "rotlwi  0, 22, 15\n\t"
        "rotlwi  %[len], 22, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "add     24, 24, 17\n\t"
        /* Round 9 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 36(6)\n\t"
        "add     14, 14, 25\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Calc new W[9] */
        "rotlwi  0, 26, 25\n\t"
        "rotlwi  %[len], 26, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "rotlwi  0, 23, 15\n\t"
        "rotlwi  %[len], 23, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "add     25, 25, 18\n\t"
        /* Round 10 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 40(6)\n\t"
        "add     12, 12, 26\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Calc new W[10] */
        "rotlwi  0, 27, 25\n\t"
        "rotlwi  %[len], 27, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "rotlwi  0, 24, 15\n\t"
        "rotlwi  %[len], 24, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "add     26, 26, 19\n\t"
        /* Round 11 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 44(6)\n\t"
        "add     11, 11, 27\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Calc new W[11] */
        "rotlwi  0, 28, 25\n\t"
        "rotlwi  %[len], 28, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "rotlwi  0, 25, 15\n\t"
        "rotlwi  %[len], 25, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "add     27, 27, 20\n\t"
        /* Round 12 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 48(6)\n\t"
        "add     10, 10, 28\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Calc new W[12] */
        "rotlwi  0, 29, 25\n\t"
        "rotlwi  %[len], 29, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "rotlwi  0, 26, 15\n\t"
        "rotlwi  %[len], 26, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "add     28, 28, 21\n\t"
        /* Round 13 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 52(6)\n\t"
        "add     9, 9, 29\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Calc new W[13] */
        "rotlwi  0, 30, 25\n\t"
        "rotlwi  %[len], 30, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "rotlwi  0, 27, 15\n\t"
        "rotlwi  %[len], 27, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "add     29, 29, 22\n\t"
        /* Round 14 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 56(6)\n\t"
        "add     8, 8, 30\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Calc new W[14] */
        "rotlwi  0, 31, 25\n\t"
        "rotlwi  %[len], 31, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "rotlwi  0, 28, 15\n\t"
        "rotlwi  %[len], 28, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "add     30, 30, 23\n\t"
        /* Round 15 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 60(6)\n\t"
        "add     7, 7, 31\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Calc new W[15] */
        "rotlwi  0, 16, 25\n\t"
        "rotlwi  %[len], 16, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "rotlwi  0, 29, 15\n\t"
        "rotlwi  %[len], 29, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "add     31, 31, 24\n\t"
        "addi    6, 6, 0x40\n\t"
        /* Round 0 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 0(6)\n\t"
        "add     15, 15, 16\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Round 1 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 4(6)\n\t"
        "add     14, 14, 17\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Round 2 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 8(6)\n\t"
        "add     12, 12, 18\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Round 3 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 12(6)\n\t"
        "add     11, 11, 19\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Round 4 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 16(6)\n\t"
        "add     10, 10, 20\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Round 5 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 20(6)\n\t"
        "add     9, 9, 21\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Round 6 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 24(6)\n\t"
        "add     8, 8, 22\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Round 7 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 28(6)\n\t"
        "add     7, 7, 23\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        /* Round 8 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 32(6)\n\t"
        "add     15, 15, 24\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        /* Round 9 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 36(6)\n\t"
        "add     14, 14, 25\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        /* Round 10 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 40(6)\n\t"
        "add     12, 12, 26\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        /* Round 11 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 44(6)\n\t"
        "add     11, 11, 27\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        /* Round 12 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 48(6)\n\t"
        "add     10, 10, 28\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        /* Round 13 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 52(6)\n\t"
        "add     9, 9, 29\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        /* Round 14 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 56(6)\n\t"
        "add     8, 8, 30\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        /* Round 15 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 60(6)\n\t"
        "add     7, 7, 31\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        "subi    6, 6, 0xc0\n\t"
        /* Add in digest from start */
        "lwz     0, 0(%[sha256])\n\t"
        "lwz     %[len], 4(%[sha256])\n\t"
        "add     7, 7, 0\n\t"
        "add     8, 8, %[len]\n\t"
        "lwz     0, 8(%[sha256])\n\t"
        "lwz     %[len], 12(%[sha256])\n\t"
        "add     9, 9, 0\n\t"
        "add     10, 10, %[len]\n\t"
        "lwz     0, 16(%[sha256])\n\t"
        "lwz     %[len], 20(%[sha256])\n\t"
        "add     11, 11, 0\n\t"
        "add     12, 12, %[len]\n\t"
        "lwz     0, 24(%[sha256])\n\t"
        "lwz     %[len], 28(%[sha256])\n\t"
        "add     14, 14, 0\n\t"
        "add     15, 15, %[len]\n\t"
        "stw     7, 0(%[sha256])\n\t"
        "stw     8, 4(%[sha256])\n\t"
        "stw     9, 8(%[sha256])\n\t"
        "stw     10, 12(%[sha256])\n\t"
        "stw     11, 16(%[sha256])\n\t"
        "stw     12, 20(%[sha256])\n\t"
        "stw     14, 24(%[sha256])\n\t"
        "stw     15, 28(%[sha256])\n\t"
        "addi    %[data], %[data], 0x40\n\t"
        "bdnz    L_SHA256_transform_len_begin_%=\n\t"
#else
        "subi    1, 1, 4\n\t"
        "stw     %[len], 0(1)\n\t"
        /* Start of loop processing a block */
        "\n"
    "L_SHA256_transform_len_begin_%=: \n\t"
        /* Load W - 64 bytes */
        "lwz     16, 0(%[data])\n\t"
        "lwz     17, 4(%[data])\n\t"
        "lwz     18, 8(%[data])\n\t"
        "lwz     19, 12(%[data])\n\t"
        "lwz     20, 16(%[data])\n\t"
        "lwz     21, 20(%[data])\n\t"
        "lwz     22, 24(%[data])\n\t"
        "lwz     23, 28(%[data])\n\t"
        "lwz     24, 32(%[data])\n\t"
        "lwz     25, 36(%[data])\n\t"
        "lwz     26, 40(%[data])\n\t"
        "lwz     27, 44(%[data])\n\t"
        "lwz     28, 48(%[data])\n\t"
        "lwz     29, 52(%[data])\n\t"
        "lwz     30, 56(%[data])\n\t"
        "lwz     31, 60(%[data])\n\t"
        "li      0, 4\n\t"
        "mtctr   0\n\t"
        /* Start of 16 rounds */
        "\n"
    "L_SHA256_transform_len_start_%=: \n\t"
        /* Round 0 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 0(6)\n\t"
        "add     15, 15, 16\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_0_%=\n\t"
        /* Calc new W[0] */
        "rotlwi  0, 17, 25\n\t"
        "rotlwi  %[len], 17, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "rotlwi  0, 30, 15\n\t"
        "rotlwi  %[len], 30, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     16, 16, 0\n\t"
        "add     16, 16, 25\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_0_%=: \n\t"
        /* Round 1 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 4(6)\n\t"
        "add     14, 14, 17\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_1_%=\n\t"
        /* Calc new W[1] */
        "rotlwi  0, 18, 25\n\t"
        "rotlwi  %[len], 18, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "rotlwi  0, 31, 15\n\t"
        "rotlwi  %[len], 31, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     17, 17, 0\n\t"
        "add     17, 17, 26\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_1_%=: \n\t"
        /* Round 2 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 8(6)\n\t"
        "add     12, 12, 18\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_2_%=\n\t"
        /* Calc new W[2] */
        "rotlwi  0, 19, 25\n\t"
        "rotlwi  %[len], 19, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "rotlwi  0, 16, 15\n\t"
        "rotlwi  %[len], 16, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     18, 18, 0\n\t"
        "add     18, 18, 27\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_2_%=: \n\t"
        /* Round 3 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 12(6)\n\t"
        "add     11, 11, 19\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_3_%=\n\t"
        /* Calc new W[3] */
        "rotlwi  0, 20, 25\n\t"
        "rotlwi  %[len], 20, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "rotlwi  0, 17, 15\n\t"
        "rotlwi  %[len], 17, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 17, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     19, 19, 0\n\t"
        "add     19, 19, 28\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_3_%=: \n\t"
        /* Round 4 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 16(6)\n\t"
        "add     10, 10, 20\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_4_%=\n\t"
        /* Calc new W[4] */
        "rotlwi  0, 21, 25\n\t"
        "rotlwi  %[len], 21, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "rotlwi  0, 18, 15\n\t"
        "rotlwi  %[len], 18, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 18, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     20, 20, 0\n\t"
        "add     20, 20, 29\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_4_%=: \n\t"
        /* Round 5 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 20(6)\n\t"
        "add     9, 9, 21\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_5_%=\n\t"
        /* Calc new W[5] */
        "rotlwi  0, 22, 25\n\t"
        "rotlwi  %[len], 22, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "rotlwi  0, 19, 15\n\t"
        "rotlwi  %[len], 19, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 19, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     21, 21, 0\n\t"
        "add     21, 21, 30\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_5_%=: \n\t"
        /* Round 6 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 24(6)\n\t"
        "add     8, 8, 22\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_6_%=\n\t"
        /* Calc new W[6] */
        "rotlwi  0, 23, 25\n\t"
        "rotlwi  %[len], 23, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "rotlwi  0, 20, 15\n\t"
        "rotlwi  %[len], 20, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 20, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     22, 22, 0\n\t"
        "add     22, 22, 31\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_6_%=: \n\t"
        /* Round 7 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 28(6)\n\t"
        "add     7, 7, 23\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_7_%=\n\t"
        /* Calc new W[7] */
        "rotlwi  0, 24, 25\n\t"
        "rotlwi  %[len], 24, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "rotlwi  0, 21, 15\n\t"
        "rotlwi  %[len], 21, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 21, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     23, 23, 0\n\t"
        "add     23, 23, 16\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_7_%=: \n\t"
        /* Round 8 */
        "rotlwi  0, 11, 26\n\t"
        "rotlwi  %[len], 11, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, 11\n\t"
        "xor     0, 0, 14\n\t"
        "add     15, 15, 0\n\t"
        "lwz     0, 32(6)\n\t"
        "add     15, 15, 24\n\t"
        "add     15, 15, 0\n\t"
        "add     10, 10, 15\n\t"
        "rotlwi  0, 7, 30\n\t"
        "rotlwi  %[len], 7, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     15, 15, 0\n\t"
        "xor     %[len], 7, 8\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 8\n\t"
        "add     15, 15, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_8_%=\n\t"
        /* Calc new W[8] */
        "rotlwi  0, 25, 25\n\t"
        "rotlwi  %[len], 25, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "rotlwi  0, 22, 15\n\t"
        "rotlwi  %[len], 22, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 22, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     24, 24, 0\n\t"
        "add     24, 24, 17\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_8_%=: \n\t"
        /* Round 9 */
        "rotlwi  0, 10, 26\n\t"
        "rotlwi  %[len], 10, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, 10\n\t"
        "xor     0, 0, 12\n\t"
        "add     14, 14, 0\n\t"
        "lwz     0, 36(6)\n\t"
        "add     14, 14, 25\n\t"
        "add     14, 14, 0\n\t"
        "add     9, 9, 14\n\t"
        "rotlwi  0, 15, 30\n\t"
        "rotlwi  %[len], 15, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     14, 14, 0\n\t"
        "xor     %[len], 15, 7\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 7\n\t"
        "add     14, 14, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_9_%=\n\t"
        /* Calc new W[9] */
        "rotlwi  0, 26, 25\n\t"
        "rotlwi  %[len], 26, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "rotlwi  0, 23, 15\n\t"
        "rotlwi  %[len], 23, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 23, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     25, 25, 0\n\t"
        "add     25, 25, 18\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_9_%=: \n\t"
        /* Round 10 */
        "rotlwi  0, 9, 26\n\t"
        "rotlwi  %[len], 9, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, 9\n\t"
        "xor     0, 0, 11\n\t"
        "add     12, 12, 0\n\t"
        "lwz     0, 40(6)\n\t"
        "add     12, 12, 26\n\t"
        "add     12, 12, 0\n\t"
        "add     8, 8, 12\n\t"
        "rotlwi  0, 14, 30\n\t"
        "rotlwi  %[len], 14, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     12, 12, 0\n\t"
        "xor     %[len], 14, 15\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 15\n\t"
        "add     12, 12, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_10_%=\n\t"
        /* Calc new W[10] */
        "rotlwi  0, 27, 25\n\t"
        "rotlwi  %[len], 27, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "rotlwi  0, 24, 15\n\t"
        "rotlwi  %[len], 24, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 24, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     26, 26, 0\n\t"
        "add     26, 26, 19\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_10_%=: \n\t"
        /* Round 11 */
        "rotlwi  0, 8, 26\n\t"
        "rotlwi  %[len], 8, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, 8\n\t"
        "xor     0, 0, 10\n\t"
        "add     11, 11, 0\n\t"
        "lwz     0, 44(6)\n\t"
        "add     11, 11, 27\n\t"
        "add     11, 11, 0\n\t"
        "add     7, 7, 11\n\t"
        "rotlwi  0, 12, 30\n\t"
        "rotlwi  %[len], 12, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     11, 11, 0\n\t"
        "xor     %[len], 12, 14\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 14\n\t"
        "add     11, 11, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_11_%=\n\t"
        /* Calc new W[11] */
        "rotlwi  0, 28, 25\n\t"
        "rotlwi  %[len], 28, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "rotlwi  0, 25, 15\n\t"
        "rotlwi  %[len], 25, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 25, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     27, 27, 0\n\t"
        "add     27, 27, 20\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_11_%=: \n\t"
        /* Round 12 */
        "rotlwi  0, 7, 26\n\t"
        "rotlwi  %[len], 7, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 7, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     0, 8, 9\n\t"
        "and     0, 0, 7\n\t"
        "xor     0, 0, 9\n\t"
        "add     10, 10, 0\n\t"
        "lwz     0, 48(6)\n\t"
        "add     10, 10, 28\n\t"
        "add     10, 10, 0\n\t"
        "add     15, 15, 10\n\t"
        "rotlwi  0, 11, 30\n\t"
        "rotlwi  %[len], 11, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 11, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     10, 10, 0\n\t"
        "xor     %[len], 11, 12\n\t"
        "xor     0, 12, 14\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 12\n\t"
        "add     10, 10, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_12_%=\n\t"
        /* Calc new W[12] */
        "rotlwi  0, 29, 25\n\t"
        "rotlwi  %[len], 29, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "rotlwi  0, 26, 15\n\t"
        "rotlwi  %[len], 26, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 26, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     28, 28, 0\n\t"
        "add     28, 28, 21\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_12_%=: \n\t"
        /* Round 13 */
        "rotlwi  0, 15, 26\n\t"
        "rotlwi  %[len], 15, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 15, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     0, 7, 8\n\t"
        "and     0, 0, 15\n\t"
        "xor     0, 0, 8\n\t"
        "add     9, 9, 0\n\t"
        "lwz     0, 52(6)\n\t"
        "add     9, 9, 29\n\t"
        "add     9, 9, 0\n\t"
        "add     14, 14, 9\n\t"
        "rotlwi  0, 10, 30\n\t"
        "rotlwi  %[len], 10, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 10, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     9, 9, 0\n\t"
        "xor     %[len], 10, 11\n\t"
        "xor     0, 11, 12\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 11\n\t"
        "add     9, 9, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_13_%=\n\t"
        /* Calc new W[13] */
        "rotlwi  0, 30, 25\n\t"
        "rotlwi  %[len], 30, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 30, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "rotlwi  0, 27, 15\n\t"
        "rotlwi  %[len], 27, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 27, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     29, 29, 0\n\t"
        "add     29, 29, 22\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_13_%=: \n\t"
        /* Round 14 */
        "rotlwi  0, 14, 26\n\t"
        "rotlwi  %[len], 14, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 14, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     0, 15, 7\n\t"
        "and     0, 0, 14\n\t"
        "xor     0, 0, 7\n\t"
        "add     8, 8, 0\n\t"
        "lwz     0, 56(6)\n\t"
        "add     8, 8, 30\n\t"
        "add     8, 8, 0\n\t"
        "add     12, 12, 8\n\t"
        "rotlwi  0, 9, 30\n\t"
        "rotlwi  %[len], 9, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 9, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     8, 8, 0\n\t"
        "xor     %[len], 9, 10\n\t"
        "xor     0, 10, 11\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 10\n\t"
        "add     8, 8, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_14_%=\n\t"
        /* Calc new W[14] */
        "rotlwi  0, 31, 25\n\t"
        "rotlwi  %[len], 31, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 31, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "rotlwi  0, 28, 15\n\t"
        "rotlwi  %[len], 28, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 28, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     30, 30, 0\n\t"
        "add     30, 30, 23\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_14_%=: \n\t"
        /* Round 15 */
        "rotlwi  0, 12, 26\n\t"
        "rotlwi  %[len], 12, 21\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 12, 7\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     0, 14, 15\n\t"
        "and     0, 0, 12\n\t"
        "xor     0, 0, 15\n\t"
        "add     7, 7, 0\n\t"
        "lwz     0, 60(6)\n\t"
        "add     7, 7, 31\n\t"
        "add     7, 7, 0\n\t"
        "add     11, 11, 7\n\t"
        "rotlwi  0, 8, 30\n\t"
        "rotlwi  %[len], 8, 19\n\t"
        "xor     0, 0, %[len]\n\t"
        "rotlwi  %[len], 8, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     7, 7, 0\n\t"
        "xor     %[len], 8, 9\n\t"
        "xor     0, 9, 10\n\t"
        "and     0, 0, %[len]\n\t"
        "xor     0, 0, 9\n\t"
        "add     7, 7, 0\n\t"
        "mfctr   %[len]\n\t"
        "cmpwi   0, %[len], 1\n\t"
        "beq     0, L_SHA256_transform_len_after_blk_15_%=\n\t"
        /* Calc new W[15] */
        "rotlwi  0, 16, 25\n\t"
        "rotlwi  %[len], 16, 14\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 16, 3\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "rotlwi  0, 29, 15\n\t"
        "rotlwi  %[len], 29, 13\n\t"
        "xor     0, 0, %[len]\n\t"
        "srwi    %[len], 29, 10\n\t"
        "xor     0, 0, %[len]\n\t"
        "add     31, 31, 0\n\t"
        "add     31, 31, 24\n\t"
        "\n"
    "L_SHA256_transform_len_after_blk_15_%=: \n\t"
        "addi    6, 6, 0x40\n\t"
        "bdnz    L_SHA256_transform_len_start_%=\n\t"
        "subi    6, 6, 0x100\n\t"
        /* Add in digest from start */
        "lwz     0, 0(%[sha256])\n\t"
        "lwz     %[len], 4(%[sha256])\n\t"
        "add     7, 7, 0\n\t"
        "add     8, 8, %[len]\n\t"
        "lwz     0, 8(%[sha256])\n\t"
        "lwz     %[len], 12(%[sha256])\n\t"
        "add     9, 9, 0\n\t"
        "add     10, 10, %[len]\n\t"
        "lwz     0, 16(%[sha256])\n\t"
        "lwz     %[len], 20(%[sha256])\n\t"
        "add     11, 11, 0\n\t"
        "add     12, 12, %[len]\n\t"
        "lwz     0, 24(%[sha256])\n\t"
        "lwz     %[len], 28(%[sha256])\n\t"
        "add     14, 14, 0\n\t"
        "add     15, 15, %[len]\n\t"
        "stw     7, 0(%[sha256])\n\t"
        "stw     8, 4(%[sha256])\n\t"
        "stw     9, 8(%[sha256])\n\t"
        "stw     10, 12(%[sha256])\n\t"
        "stw     11, 16(%[sha256])\n\t"
        "stw     12, 20(%[sha256])\n\t"
        "stw     14, 24(%[sha256])\n\t"
        "stw     15, 28(%[sha256])\n\t"
        "lwz     %[len], 0(1)\n\t"
        "mtctr   %[len]\n\t"
        "subi    %[len], %[len], 1\n\t"
        "addi    %[data], %[data], 0x40\n\t"
        "stw     %[len], 0(1)\n\t"
        "bdnz    L_SHA256_transform_len_begin_%=\n\t"
        "addi    1, 1, 4\n\t"
#endif /* WOLFSSL_PPC32_ASM_SMALL */
#ifndef WOLFSSL_NO_VAR_ASSIGN_REG
        : [sha256] "+r" (sha256), [data] "+r" (data), [len] "+r" (len),
          [L_SHA256_transform_len_k] "+r" (L_SHA256_transform_len_k_c)
        :
#else
        :
        : [sha256] "r" (sha256), [data] "r" (data), [len] "r" (len),
          [L_SHA256_transform_len_k] "r" (L_SHA256_transform_len_k_c)
#endif /* !WOLFSSL_NO_VAR_ASSIGN_REG */
        : "memory", "cc", "0", "7", "8", "9", "10", "11", "12", "14", "15",
            "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26",
            "27", "28", "29", "30", "31"
    );
}

#endif /* !WOLFSSL_PPC32_ASM_SPE */
#endif /* !NO_SHA256 */

#endif /* WOLFSSL_PPC32_ASM_INLINE */
#endif /* WOLFSSL_PPC32_ASM */
