/* nm_filetype_thread.hh
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef NM_FILETYPE_THREAD_HH
#define NM_FILETYPE_THREAD_HH

#include <wdefines.h>
#include <aguix/thread.hh>
#include <memory>
#include "fileentry_customcolor.hh"
#include <aguix/condvar.h>
#include "condparser.h"
#include <list>
#include <aguix/lowlevelfunc.h>

class List;
class Worker;

class NM_Filetype_Thread : public Thread
{
public:
    NM_Filetype_Thread();
    ~NM_Filetype_Thread();

    void setWorker( Worker *worker );

    int run();

    typedef enum { THREAD_RUN,
                   THREAD_EXIT,
                   THREAD_STOP } thread_order_t;

    int switchOrder( thread_order_t neworder );

    class checkFiletypeRes_t {
    public:
        //TODO use auto_ptr?
        std::vector<unsigned int> *v;
        std::auto_ptr<FileEntryCustomColor> custom_color;
    
        checkFiletypeRes_t() {
            v = NULL;
        }
        checkFiletypeRes_t( const checkFiletypeRes_t &other );
        checkFiletypeRes_t &operator=( const checkFiletypeRes_t &rhs );
    };

    void putRequest( const std::string &name,
                     bool dont_check_content );
    void clearRequests();

    // this is the type for the filetype-recogn-result
    // contains the name and the position of the ft in the wconfig list
    // index of ft because so every slave can hold a copy of the ft-list
    // to work without need to lock
    class ft_recres_list_t {
    public:
        std::string name;
        std::vector<unsigned int> *ft_index;
        std::auto_ptr<FileEntryCustomColor> custom_color;

        ft_recres_list_t()
        {
            ft_index = NULL;
        }
        ~ft_recres_list_t()
        {
            if ( ft_index != NULL ) delete ft_index;
        }
        ft_recres_list_t( const ft_recres_list_t &other );
        ft_recres_list_t &operator=( const ft_recres_list_t &other );
    };

    void res_list_clear();
    void res_list_lock();
    void res_list_unlock();
    ft_recres_list_t *res_list_remove_locked();
    bool res_list_is_empty_locked();

    void copy_filetypes( List *filetypes );
    void clear_filetypes();
private:
    typedef struct {
        std::string name;
        bool dont_check_content;
    } check_entry_t;

    // fifo for ft-results
    // main thread does remove
    // slave does put
    // no size limitation
    class ft_recres_list {
    public:
        ft_recres_list();
        ~ft_recres_list();
        ft_recres_list( const ft_recres_list &other );
        ft_recres_list &operator=( const ft_recres_list &other );

        bool isEmpty_locked();
        int put_locked( ft_recres_list_t *elem );
        ft_recres_list_t *remove_locked();
    
        void lock();
        void unlock();
    protected:
        std::list<ft_recres_list_t *> entries;
        MutEx ex;
    };

    int slave_checkFiletype( const std::string &fullname, bool dontCheckContent, checkFiletypeRes_t &res_return );
    int switchStatus( thread_order_t newstatus );

    Worker *m_worker;

    CondParser condparser;

    int m_running;

    CondVar m_ordervar_cv;
    thread_order_t m_order;
    CondVar m_statusvar_cv;
    thread_order_t m_status;

    std::list< check_entry_t > m_entries_to_check;
    ft_recres_list recreslist;

    struct {
        List *filetypes;
        MutEx filetype_ex;
    } m_filetype_copy;
};

#endif
