/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "GRID_F.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** MKFORCE **
c ** Define the forcing terms in the momentum equation
c ***************************************************************

      subroutine FORT_MKSCALFORCE(force,s,time,dx,DIMS,numscal)

      implicit none

      integer DIMS

      integer numscal
      REAL_T  force(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numscal)
      REAL_T      s(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numscal)
      REAL_T  time
      REAL_T  dx(2)

c     Local variables
      integer i,j,n

      do n = 1,numscal
      do j = lo_2-1,hi_2+1
      do i = lo_1-1,hi_1+1
        force(i,j,n) = zero
      enddo
      enddo
      enddo

      return
      end
