#include "plugins/accelerometer.h"
#include "plugins/app.h"
#include "plugins/camera.h"
#include "plugins/cameraresolution.h"
#include "plugins/capture.h"
#include "plugins/compass.h"
#include "plugins/connection.h"
#include "plugins/console.h"
#include "plugins/contacts.h"
#include "plugins/device.h"
#include "plugins/events.h"
#include "plugins/fileapi.h"
#include "plugins/geolocation.h"
#include "plugins/globalization.h"
#include "plugins/inappbrowser.h"
#include "plugins/media.h"
#include "plugins/notification.h"
#include "plugins/splashscreen.h"

#define CHECK_PLUGIN(class) \
    if (pluginNames.contains(class::fullID())) { \
        res.prepend(QSharedPointer<class>(new class(cordova))); \
    }

extern "C" {

Q_DECL_EXPORT QList<QSharedPointer<CPlugin>> cordovaGetPluginInstances(const QList<QString> &pluginNames, Cordova *cordova) {
    QList<QSharedPointer<CPlugin>> res;

    CHECK_PLUGIN(Accelerometer);
    CHECK_PLUGIN(App);
    CHECK_PLUGIN(Camera);
    CHECK_PLUGIN(Capture);
    CHECK_PLUGIN(Compass);
    CHECK_PLUGIN(Connection);
    CHECK_PLUGIN(Console);
    CHECK_PLUGIN(Contacts);
    CHECK_PLUGIN(Device);
    CHECK_PLUGIN(Events);
    CHECK_PLUGIN(FileAPI);
    CHECK_PLUGIN(Geolocation);
    CHECK_PLUGIN(Globalization);
    CHECK_PLUGIN(InAppBrowser);
    CHECK_PLUGIN(Media);
    CHECK_PLUGIN(Notification);
    CHECK_PLUGIN(Splashscreen);

    return res;
}

}
