/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.io.Serializable;
import java.util.Comparator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.CalendarValueComparer;
import net.sf.saxon.sort.CodepointCollatingComparer;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollatingAtomicComparer;
import net.sf.saxon.sort.ComparableAtomicValueComparer;
import net.sf.saxon.sort.ComparisonKey;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class GenericAtomicComparer
implements AtomicComparer,
Comparator,
Serializable {
    private Comparator collator;
    private XPathContext conversionContext;

    public GenericAtomicComparer(Comparator comparator, XPathContext xPathContext) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = xPathContext;
    }

    public GenericAtomicComparer(Comparator comparator, Configuration configuration) {
        this.collator = comparator;
        if (comparator == null) {
            this.collator = CodepointCollator.getInstance();
        }
        this.conversionContext = configuration.getConversionContext();
    }

    public static AtomicComparer makeAtomicComparer(int n, int n2, Comparator comparator, Configuration configuration) {
        if (n == n2) {
            switch (n) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new CalendarValueComparer(configuration);
                }
                case 514: 
                case 518: 
                case 527: 
                case 528: 
                case 530: 
                case 531: 
                case 644: 
                case 645: {
                    return new ComparableAtomicValueComparer();
                }
            }
        }
        if (Type.isNumericPrimitiveType(n) && Type.isNumericPrimitiveType(n2)) {
            return new ComparableAtomicValueComparer();
        }
        if (!(n != 513 && n != 642 && n != 529 || n2 != 513 && n2 != 642 && n2 != 529)) {
            if (comparator instanceof CodepointCollator) {
                return CodepointCollatingComparer.getInstance();
            }
            return new CollatingAtomicComparer(comparator, configuration.getPlatform());
        }
        return new GenericAtomicComparer(comparator, configuration);
    }

    public int compare(Object object, Object object2) {
        if (object instanceof AtomicValue && !((AtomicValue)object).hasBuiltInType()) {
            object = ((AtomicValue)object).getPrimitiveValue();
        }
        if (object2 instanceof AtomicValue && !((AtomicValue)object2).hasBuiltInType()) {
            object2 = ((AtomicValue)object2).getPrimitiveValue();
        }
        if (object instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)object).compareTo(object2, this.collator, this.conversionContext);
        }
        if (object2 instanceof UntypedAtomicValue) {
            return -((UntypedAtomicValue)object2).compareTo(object, this.collator, this.conversionContext);
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.conversionContext.getConfiguration());
        }
        if (object instanceof Comparable) {
            return ((Comparable)object).compareTo(object2);
        }
        if (object instanceof StringValue) {
            return this.collator.compare(((StringValue)object).getStringValue(), ((StringValue)object2).getStringValue());
        }
        throw new ClassCastException("Objects are not comparable (" + object.getClass() + ", " + object2.getClass() + ')');
    }

    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        atomicValue = atomicValue.getPrimitiveValue();
        atomicValue2 = atomicValue2.getPrimitiveValue();
        if (atomicValue instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)atomicValue).compareTo(atomicValue2, this.collator, this.conversionContext) == 0;
        }
        if (atomicValue2 instanceof UntypedAtomicValue) {
            return ((UntypedAtomicValue)atomicValue2).compareTo(atomicValue, this.collator, this.conversionContext) == 0;
        }
        if (atomicValue instanceof StringValue) {
            return this.collator.compare(((StringValue)atomicValue).getStringValue(), ((StringValue)atomicValue2).getStringValue()) == 0;
        }
        if (atomicValue instanceof CalendarValue && atomicValue2 instanceof CalendarValue) {
            return ((CalendarValue)atomicValue).compareTo((CalendarValue)atomicValue2, this.conversionContext.getConfiguration()) == 0;
        }
        return atomicValue.equals(atomicValue2);
    }

    public ComparisonKey getComparisonKey(AtomicValue atomicValue) {
        if (atomicValue instanceof AtomicValue && !atomicValue.hasBuiltInType()) {
            atomicValue = atomicValue.getPrimitiveValue();
        }
        if (atomicValue instanceof StringValue) {
            Platform platform = this.conversionContext.getConfiguration().getPlatform();
            if (platform.canReturnCollationKeys(this.collator)) {
                return new ComparisonKey(513, platform.getCollationKey(this.collator, ((StringValue)atomicValue).getStringValue()));
            }
            return new ComparisonKey(513, ((StringValue)atomicValue).getStringValue());
        }
        return new ComparisonKey(513, atomicValue);
    }
}

