#!/bin/sh

if [ $# -ne 1 ];
 then
  echo "usage: $0 color"
  echo "example: $0 blue   will make a left-handed version of the blue theme"
 exit 1
fi

cp -r $1'_src' $1'_src_left'

function flopcursors () {
 debug=1
 for i in `find . -name '*.png'`; do
     convert $i -flop $i
     test -n $debug && echo Converting: $i
 done
 
 for i in `find . -name '*.conf'`; do
     test -n $debug && echo Adjusting: $i
     cat $i | \
         (
         rm -f $i.flopcursorstmp
         while read ln; do
             size=`echo $ln | cut -f 1 -d " "`
             xhot=`echo $ln | cut -f 2 -d " "`
             yhot=`echo $ln | cut -f 3 -d " "`
             filename=`echo $ln | cut -f 4 -d " "`
             delay=`echo $ln | cut -f 5 -d " "`
             file=`dirname $i`/$filename
             if test -r "$file"; then
                 width=`identify -format %w $file`
             else
                 file=`dirname $i`/`basename $filename`
                 width=`identify -format %w $file`
             fi
             echo $size $((width-xhot)) $yhot $filename $delay >>$i.flopcursorstmp
         done
         mv -f $i.flopcursorstmp $i
         )
 done
}



cd $1"_src_left"
flopcursors

sed "s/$1/$1left/g" Makefile > Make2
mv Make2 Makefile

cp ../left-handed_templates/$1index.theme index.theme


cd watch
flopcursors

cd ../nonanim
sed "s/$1/$1left/g" Makefile > Make2
mv Make2 Makefile

cp ../../left-handed_templates/$1nonanimindex.theme index.theme

if test -d "../classic"; then
 cd ../classic
 sed "s/$1/$1left/g" Makefile > Make2
 mv Make2 Makefile
 cp ../../left-handed_templates/$1classicindex.theme index.theme
fi

cd ../left_ptr_watch
cp ../../left-handed_templates/left_ptr_watch.conf left_ptr_watch.conf

cd ..
cp ../left-handed_templates/$1question_arrow.png question_arrow.png
cp ../left-handed_templates/$1question_arrow_32.png question_arrow_32.png
