/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_pri_arb_trace_regs.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:15p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:42 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_pri_arb_trace_regs.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:15p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_PRI_ARB_TRACE_REGS_H__
#define BCHP_PRI_ARB_TRACE_REGS_H__

/***************************************************************************
 *PRI_ARB_TRACE_REGS - PRIMARY_ARB tracelog registers
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_VERSION          0x0040c600 /* Tracelog Version */
#define BCHP_PRI_ARB_TRACE_REGS_MBIST_TM         0x0040c604 /* MBIST Test Mode */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_ADDR        0x0040c608 /* Beginning of buffer DRAM address in the TraceLog */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_SIZE        0x0040c60c /* Size of the buffer in DRAM */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_WR_PTR      0x0040c610 /* Initial location of the write pointer in DRAM */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE        0x0040c614 /* Trigger configuration */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_N_EVENTS    0x0040c618 /* N transactions */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD         0x0040c61c /* Trigger command register */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_LOWER  0x0040c620 /* Lower 32 bits of Trigger Time Interval */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_UPPER  0x0040c624 /* Upper 16 bits of Trigger Time Interval */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS 0x0040c628 /* Transaction Status Register */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_UPPER 0x0040c62c /* Upper 16 bits of elapsed time */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_LOWER 0x0040c630 /* Lower 32 bits of elapsed time */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_WR_PTR      0x0040c634 /* Buffer Write Pointer Position at the Time of Trigger */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_COUNT_BEFORE_TRIGGER 0x0040c638 /* Trigger Count Before Trigger */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_COUNT_AFTER_TRIGGER 0x0040c63c /* Trigger Count After Trigger */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_EVENT_COUNTER 0x0040c640 /* Trigger Event Counter */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_NUMBER 0x0040c644 /* Number of transactions captured */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_UPPER 0x0040c648 /* Upper 16 bits of timestamp at the time of Trigger */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_LOWER 0x0040c64c /* Lower 32 bits of timestamp at the time of Trigger */

/***************************************************************************
 *VERSION - Tracelog Version
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: VERSION :: MAJOR_REVISION_NUMBER [31:16] */
#define BCHP_PRI_ARB_TRACE_REGS_VERSION_MAJOR_REVISION_NUMBER_MASK 0xffff0000
#define BCHP_PRI_ARB_TRACE_REGS_VERSION_MAJOR_REVISION_NUMBER_SHIFT 16

/* PRI_ARB_TRACE_REGS :: VERSION :: MINOR_REVISION_NUMBER [15:08] */
#define BCHP_PRI_ARB_TRACE_REGS_VERSION_MINOR_REVISION_NUMBER_MASK 0x0000ff00
#define BCHP_PRI_ARB_TRACE_REGS_VERSION_MINOR_REVISION_NUMBER_SHIFT 8

/* PRI_ARB_TRACE_REGS :: VERSION :: METAL_REVISION_ID [07:00] */
#define BCHP_PRI_ARB_TRACE_REGS_VERSION_METAL_REVISION_ID_MASK     0x000000ff
#define BCHP_PRI_ARB_TRACE_REGS_VERSION_METAL_REVISION_ID_SHIFT    0

/***************************************************************************
 *MBIST_TM - MBIST Test Mode
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: MBIST_TM :: reserved0 [31:02] */
#define BCHP_PRI_ARB_TRACE_REGS_MBIST_TM_reserved0_MASK            0xfffffffc
#define BCHP_PRI_ARB_TRACE_REGS_MBIST_TM_reserved0_SHIFT           2

/* PRI_ARB_TRACE_REGS :: MBIST_TM :: MBIST_TESTMODE [01:00] */
#define BCHP_PRI_ARB_TRACE_REGS_MBIST_TM_MBIST_TESTMODE_MASK       0x00000003
#define BCHP_PRI_ARB_TRACE_REGS_MBIST_TM_MBIST_TESTMODE_SHIFT      0

/***************************************************************************
 *BUFF_ADDR - Beginning of buffer DRAM address in the TraceLog
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: BUFF_ADDR :: ADDR [31:08] */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_ADDR_ADDR_MASK                0xffffff00
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_ADDR_ADDR_SHIFT               8

/* PRI_ARB_TRACE_REGS :: BUFF_ADDR :: reserved0 [07:00] */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_ADDR_reserved0_MASK           0x000000ff
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_ADDR_reserved0_SHIFT          0

/***************************************************************************
 *BUFF_SIZE - Size of the buffer in DRAM
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: BUFF_SIZE :: SIZE [31:08] */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_SIZE_SIZE_MASK                0xffffff00
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_SIZE_SIZE_SHIFT               8

/* PRI_ARB_TRACE_REGS :: BUFF_SIZE :: reserved0 [07:00] */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_SIZE_reserved0_MASK           0x000000ff
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_SIZE_reserved0_SHIFT          0

/***************************************************************************
 *BUFF_WR_PTR - Initial location of the write pointer in DRAM
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: BUFF_WR_PTR :: ADDR [31:08] */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_WR_PTR_ADDR_MASK              0xffffff00
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_WR_PTR_ADDR_SHIFT             8

/* PRI_ARB_TRACE_REGS :: BUFF_WR_PTR :: reserved0 [07:00] */
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_WR_PTR_reserved0_MASK         0x000000ff
#define BCHP_PRI_ARB_TRACE_REGS_BUFF_WR_PTR_reserved0_SHIFT        0

/***************************************************************************
 *TRIG_MODE - Trigger configuration
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MODE :: reserved0 [31:06] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE_reserved0_MASK           0xffffffc0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE_reserved0_SHIFT          6

/* PRI_ARB_TRACE_REGS :: TRIG_MODE :: EVENT_MODE [05:03] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE_EVENT_MODE_MASK          0x00000038
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE_EVENT_MODE_SHIFT         3

/* PRI_ARB_TRACE_REGS :: TRIG_MODE :: CAPTURE_MODE [02:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE_CAPTURE_MODE_MASK        0x00000007
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MODE_CAPTURE_MODE_SHIFT       0

/***************************************************************************
 *TRIG_N_EVENTS - N transactions
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_N_EVENTS :: N_EVENTS [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_N_EVENTS_N_EVENTS_MASK        0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_N_EVENTS_N_EVENTS_SHIFT       0

/***************************************************************************
 *TRIG_CMD - Trigger command register
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_CMD :: reserved0 [31:05] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_reserved0_MASK            0xffffffe0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_reserved0_SHIFT           5

/* PRI_ARB_TRACE_REGS :: TRIG_CMD :: RESET [04:04] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_RESET_MASK                0x00000010
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_RESET_SHIFT               4

/* PRI_ARB_TRACE_REGS :: TRIG_CMD :: STOP [03:03] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_STOP_MASK                 0x00000008
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_STOP_SHIFT                3

/* PRI_ARB_TRACE_REGS :: TRIG_CMD :: FLUSH [02:02] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_FLUSH_MASK                0x00000004
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_FLUSH_SHIFT               2

/* PRI_ARB_TRACE_REGS :: TRIG_CMD :: MANUAL_TRIGGER [01:01] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_MANUAL_TRIGGER_MASK       0x00000002
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_MANUAL_TRIGGER_SHIFT      1

/* PRI_ARB_TRACE_REGS :: TRIG_CMD :: START [00:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_START_MASK                0x00000001
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_CMD_START_SHIFT               0

/***************************************************************************
 *TRIG_TIME_LOWER - Lower 32 bits of Trigger Time Interval
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_TIME_LOWER :: TRANSACTION_TIME_LOWER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_LOWER_TRANSACTION_TIME_LOWER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_LOWER_TRANSACTION_TIME_LOWER_SHIFT 0

/***************************************************************************
 *TRIG_TIME_UPPER - Upper 16 bits of Trigger Time Interval
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_TIME_UPPER :: reserved0 [31:16] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_UPPER_reserved0_MASK     0xffff0000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_UPPER_reserved0_SHIFT    16

/* PRI_ARB_TRACE_REGS :: TRIG_TIME_UPPER :: TRANSACTION_TIME_UPPER [15:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_UPPER_TRANSACTION_TIME_UPPER_MASK 0x0000ffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TIME_UPPER_TRANSACTION_TIME_UPPER_SHIFT 0

/***************************************************************************
 *TRANSACTION_STATUS - Transaction Status Register
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: reserved0 [31:13] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_reserved0_MASK  0xffffe000
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_reserved0_SHIFT 13

/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: RESET_ACTIVE [12:12] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_RESET_ACTIVE_MASK 0x00001000
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_RESET_ACTIVE_SHIFT 12

/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: FIFO_EMPTY [11:11] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_FIFO_EMPTY_MASK 0x00000800
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_FIFO_EMPTY_SHIFT 11

/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: TRIGGER_EVENT [10:10] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_TRIGGER_EVENT_MASK 0x00000400
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_TRIGGER_EVENT_SHIFT 10

/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: LOST [09:09] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_LOST_MASK       0x00000200
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_LOST_SHIFT      9

/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: ACTIVE [08:08] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_ACTIVE_MASK     0x00000100
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_ACTIVE_SHIFT    8

/* PRI_ARB_TRACE_REGS :: TRANSACTION_STATUS :: CONTINUITY_COUNT [07:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_CONTINUITY_COUNT_MASK 0x000000ff
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_STATUS_CONTINUITY_COUNT_SHIFT 0

/***************************************************************************
 *TRANSACTION_TIME_UPPER - Upper 16 bits of elapsed time
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRANSACTION_TIME_UPPER :: reserved0 [31:16] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_UPPER_reserved0_MASK 0xffff0000
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_UPPER_reserved0_SHIFT 16

/* PRI_ARB_TRACE_REGS :: TRANSACTION_TIME_UPPER :: TRANSACTION_TIME_UPPER [15:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_UPPER_TRANSACTION_TIME_UPPER_MASK 0x0000ffff
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_UPPER_TRANSACTION_TIME_UPPER_SHIFT 0

/***************************************************************************
 *TRANSACTION_TIME_LOWER - Lower 32 bits of elapsed time
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRANSACTION_TIME_LOWER :: TRANSACTION_TIME_LOWER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_LOWER_TRANSACTION_TIME_LOWER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_TIME_LOWER_TRANSACTION_TIME_LOWER_SHIFT 0

/***************************************************************************
 *TRIG_WR_PTR - Buffer Write Pointer Position at the Time of Trigger
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_WR_PTR :: TRIGGER_WRITE_POINTER_ADDRESS [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_WR_PTR_TRIGGER_WRITE_POINTER_ADDRESS_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_WR_PTR_TRIGGER_WRITE_POINTER_ADDRESS_SHIFT 0

/***************************************************************************
 *TRIG_COUNT_BEFORE_TRIGGER - Trigger Count Before Trigger
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_COUNT_BEFORE_TRIGGER :: EVENT_COUNT_BEFORE_TRIGGER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_COUNT_BEFORE_TRIGGER_EVENT_COUNT_BEFORE_TRIGGER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_COUNT_BEFORE_TRIGGER_EVENT_COUNT_BEFORE_TRIGGER_SHIFT 0

/***************************************************************************
 *TRIG_COUNT_AFTER_TRIGGER - Trigger Count After Trigger
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_COUNT_AFTER_TRIGGER :: EVENT_COUNT_AFTER_TRIGGER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_COUNT_AFTER_TRIGGER_EVENT_COUNT_AFTER_TRIGGER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_COUNT_AFTER_TRIGGER_EVENT_COUNT_AFTER_TRIGGER_SHIFT 0

/***************************************************************************
 *TRIG_EVENT_COUNTER - Trigger Event Counter
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_EVENT_COUNTER :: TRIGGER_EVENT_MATCH_COUNT [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_EVENT_COUNTER_TRIGGER_EVENT_MATCH_COUNT_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_EVENT_COUNTER_TRIGGER_EVENT_MATCH_COUNT_SHIFT 0

/***************************************************************************
 *TRANSACTION_NUMBER - Number of transactions captured
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRANSACTION_NUMBER :: TRANS_NUMBER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_NUMBER_TRANS_NUMBER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRANSACTION_NUMBER_TRANS_NUMBER_SHIFT 0

/***************************************************************************
 *TRIG_TRANS_TIME_UPPER - Upper 16 bits of timestamp at the time of Trigger
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_TRANS_TIME_UPPER :: reserved0 [31:16] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_UPPER_reserved0_MASK 0xffff0000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_UPPER_reserved0_SHIFT 16

/* PRI_ARB_TRACE_REGS :: TRIG_TRANS_TIME_UPPER :: TRANSACTION_TIME_UPPER [15:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_UPPER_TRANSACTION_TIME_UPPER_MASK 0x0000ffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_UPPER_TRANSACTION_TIME_UPPER_SHIFT 0

/***************************************************************************
 *TRIG_TRANS_TIME_LOWER - Lower 32 bits of timestamp at the time of Trigger
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_TRANS_TIME_LOWER :: TRANSACTION_TIME_LOWER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_LOWER_TRANSACTION_TIME_LOWER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_TRANS_TIME_LOWER_TRANSACTION_TIME_LOWER_SHIFT 0

/***************************************************************************
 *DATA_MEM_FILT_MODE%i - Data Memory Filter Window Mode
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_ARRAY_BASE     0x0040c650
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_ARRAY_START    0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_ARRAY_END      3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_MODE%i - Data Memory Filter Window Mode
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: reserved0 [31:12] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_reserved0_MASK 0xfffff000
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_reserved0_SHIFT 12

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: FILTER_MEMORY_EN [11:11] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_FILTER_MEMORY_EN_MASK 0x00000800
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_FILTER_MEMORY_EN_SHIFT 11

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_MCACHE_MODE [10:10] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_MCACHE_MODE_MASK 0x00000400
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_MCACHE_MODE_SHIFT 10

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_READ_MODE [09:09] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_READ_MODE_MASK 0x00000200
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_READ_MODE_SHIFT 9

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_WRITE_MODE [08:08] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_WRITE_MODE_MASK 0x00000100
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_WRITE_MODE_SHIFT 8

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_PIXEL_MODE [07:07] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_PIXEL_MODE_MASK 0x00000080
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_PIXEL_MODE_SHIFT 7

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_LINEAR_MODE [06:06] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_LINEAR_MODE_MASK 0x00000040
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_LINEAR_MODE_SHIFT 6

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_DISPLAY_MODE [05:05] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_DISPLAY_MODE_MASK 0x00000020
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_DISPLAY_MODE_SHIFT 5

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_CACHE_MODE [04:04] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_CACHE_MODE_MASK 0x00000010
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_CACHE_MODE_SHIFT 4

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_FILTER_PIXEL_MODE [03:03] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_FILTER_PIXEL_MODE_MASK 0x00000008
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_FILTER_PIXEL_MODE_SHIFT 3

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_CLIENT_MASK_MODE [02:02] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_CLIENT_MASK_MODE_MASK 0x00000004
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_CLIENT_MASK_MODE_SHIFT 2

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_IN_OUT [01:01] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_IN_OUT_MASK 0x00000002
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_IN_OUT_SHIFT 1

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_MODEi :: MEMORY_ADDRESS_EN [00:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_ADDRESS_EN_MASK 0x00000001
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_MODEi_MEMORY_ADDRESS_EN_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_PIX_X1_Y1_COORD%i - X1,Y1 Coordinate
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_BASE 0x0040c660
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_PIX_X1_Y1_COORD%i - X1,Y1 Coordinate
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X1_Y1_COORDi :: reserved0 [31:27] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_reserved0_MASK 0xf8000000
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_reserved0_SHIFT 27

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X1_Y1_COORDi :: Y1_COORD [26:16] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_Y1_COORD_MASK 0x07ff0000
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_Y1_COORD_SHIFT 16

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X1_Y1_COORDi :: reserved1 [15:11] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_reserved1_MASK 0x0000f800
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_reserved1_SHIFT 11

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X1_Y1_COORDi :: X1_COORD [10:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_X1_COORD_MASK 0x000007ff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X1_Y1_COORDi_X1_COORD_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_PIX_X2_Y2_COORD%i - X2,Y2 Coordinate
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_BASE 0x0040c670
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_PIX_X2_Y2_COORD%i - X2,Y2 Coordinate
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X2_Y2_COORDi :: reserved0 [31:27] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_reserved0_MASK 0xf8000000
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_reserved0_SHIFT 27

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X2_Y2_COORDi :: Y2_COORD [26:16] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_Y2_COORD_MASK 0x07ff0000
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_Y2_COORD_SHIFT 16

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X2_Y2_COORDi :: reserved1 [15:11] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_reserved1_MASK 0x0000f800
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_reserved1_SHIFT 11

/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_PIX_X2_Y2_COORDi :: X2_COORD [10:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_X2_COORD_MASK 0x000007ff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_PIX_X2_Y2_COORDi_X2_COORD_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_CLIENT_MASK_64_95_%i - Data Memory Filter Window Client Mask for Clients 64-95
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_BASE 0x0040c680
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_CLIENT_MASK_64_95_%i - Data Memory Filter Window Client Mask for Clients 64-95
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_CLIENT_MASK_64_95_i :: MEMORY_CLIENT_MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_64_95_i_MEMORY_CLIENT_MASK_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_64_95_i_MEMORY_CLIENT_MASK_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_CLIENT_MASK_32_63_%i - Data Memory Filter Window Client Mask for Clients 32-63
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_BASE 0x0040c690
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_CLIENT_MASK_32_63_%i - Data Memory Filter Window Client Mask for Clients 32-63
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_CLIENT_MASK_32_63_i :: MEMORY_CLIENT_MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_32_63_i_MEMORY_CLIENT_MASK_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_32_63_i_MEMORY_CLIENT_MASK_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_CLIENT_MASK_31_0_%i - Data Memory Filter Window Client Mask for Clients 0-31
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_BASE 0x0040c6a0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_CLIENT_MASK_31_0_%i - Data Memory Filter Window Client Mask for Clients 0-31
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_CLIENT_MASK_31_0_i :: MEMORY_CLIENT_MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_31_0_i_MEMORY_CLIENT_MASK_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_CLIENT_MASK_31_0_i_MEMORY_CLIENT_MASK_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_ADDR_UPPER%i - Data Memory Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_UPPERi_ARRAY_BASE 0x0040c6b0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_UPPERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_UPPERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_UPPERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_ADDR_UPPER%i - Data Memory Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_ADDR_UPPERi :: UPPER_MEMORY_ADDR [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_UPPERi_UPPER_MEMORY_ADDR_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_UPPERi_UPPER_MEMORY_ADDR_SHIFT 0


/***************************************************************************
 *DATA_MEM_FILT_ADDR_LOWER%i - Data Memory Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_LOWERi_ARRAY_BASE 0x0040c6c0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_LOWERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_LOWERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_LOWERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_MEM_FILT_ADDR_LOWER%i - Data Memory Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_MEM_FILT_ADDR_LOWERi :: LOWER_MEMORY_ADDR [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_LOWERi_LOWER_MEMORY_ADDR_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_MEM_FILT_ADDR_LOWERi_LOWER_MEMORY_ADDR_SHIFT 0


/***************************************************************************
 *DATA_IO_FILT_MODE%i - Data I/O Filter Mode
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_ARRAY_BASE      0x0040c6d0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_ARRAY_START     0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_ARRAY_END       3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_IO_FILT_MODE%i - Data I/O Filter Mode
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: reserved0 [31:06] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_reserved0_MASK  0xffffffc0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_reserved0_SHIFT 6

/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: FILTER_IO_EN [05:05] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_FILTER_IO_EN_MASK 0x00000020
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_FILTER_IO_EN_SHIFT 5

/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: GISB_READ_MODE [04:04] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_GISB_READ_MODE_MASK 0x00000010
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_GISB_READ_MODE_SHIFT 4

/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: GISB_WRITE_MODE [03:03] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_GISB_WRITE_MODE_MASK 0x00000008
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_GISB_WRITE_MODE_SHIFT 3

/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: DATA_MODE [02:02] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_DATA_MODE_MASK  0x00000004
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_DATA_MODE_SHIFT 2

/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: IO_IN_OUT [01:01] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_IO_IN_OUT_MASK  0x00000002
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_IO_IN_OUT_SHIFT 1

/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_MODEi :: IO_ADDRESS_EN [00:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_IO_ADDRESS_EN_MASK 0x00000001
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_MODEi_IO_ADDRESS_EN_SHIFT 0


/***************************************************************************
 *DATA_IO_FILT_ADDR_UPPER%i - Data I/O Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_UPPERi_ARRAY_BASE 0x0040c6e0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_UPPERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_UPPERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_UPPERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_IO_FILT_ADDR_UPPER%i - Data I/O Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_ADDR_UPPERi :: IO_ADDR_UPPER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_UPPERi_IO_ADDR_UPPER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_UPPERi_IO_ADDR_UPPER_SHIFT 0


/***************************************************************************
 *DATA_IO_FILT_ADDR_LOWER%i - Data I/O Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_LOWERi_ARRAY_BASE 0x0040c6f0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_LOWERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_LOWERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_LOWERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_IO_FILT_ADDR_LOWER%i - Data I/O Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_ADDR_LOWERi :: IO_ADDR_LOWER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_LOWERi_IO_ADDR_LOWER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_ADDR_LOWERi_IO_ADDR_LOWER_SHIFT 0


/***************************************************************************
 *DATA_IO_FILT_DATA%i - Data I/O Filter Window Data
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATAi_ARRAY_BASE      0x0040c700
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATAi_ARRAY_START     0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATAi_ARRAY_END       3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATAi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_IO_FILT_DATA%i - Data I/O Filter Window Data
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_DATAi :: DATA [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATAi_DATA_MASK       0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATAi_DATA_SHIFT      0


/***************************************************************************
 *DATA_IO_FILT_DATA_MASK%i - Data I/O Filter Window Data Mask
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATA_MASKi_ARRAY_BASE 0x0040c710
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATA_MASKi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATA_MASKi_ARRAY_END  3
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATA_MASKi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *DATA_IO_FILT_DATA_MASK%i - Data I/O Filter Window Data Mask
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: DATA_IO_FILT_DATA_MASKi :: MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATA_MASKi_MASK_MASK  0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_DATA_IO_FILT_DATA_MASKi_MASK_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_MODE%i - Trigger Memory Filter Window Mode
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_ARRAY_BASE     0x0040c720
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_ARRAY_START    0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_ARRAY_END      3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_MODE%i - Trigger Memory Filter Window Mode
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: reserved0 [31:12] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_reserved0_MASK 0xfffff000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_reserved0_SHIFT 12

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: FILTER_MEMORY_EN [11:11] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_FILTER_MEMORY_EN_MASK 0x00000800
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_FILTER_MEMORY_EN_SHIFT 11

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_MCACHE_MODE [10:10] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_MCACHE_MODE_MASK 0x00000400
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_MCACHE_MODE_SHIFT 10

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_READ_MODE [09:09] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_READ_MODE_MASK 0x00000200
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_READ_MODE_SHIFT 9

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_WRITE_MODE [08:08] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_WRITE_MODE_MASK 0x00000100
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_WRITE_MODE_SHIFT 8

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_PIXEL_MODE [07:07] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_PIXEL_MODE_MASK 0x00000080
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_PIXEL_MODE_SHIFT 7

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_LINEAR_MODE [06:06] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_LINEAR_MODE_MASK 0x00000040
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_LINEAR_MODE_SHIFT 6

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_DISPLAY_MODE [05:05] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_DISPLAY_MODE_MASK 0x00000020
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_DISPLAY_MODE_SHIFT 5

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_CACHE_MODE [04:04] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_CACHE_MODE_MASK 0x00000010
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_CACHE_MODE_SHIFT 4

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_FILTER_PIXEL_MODE [03:03] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_FILTER_PIXEL_MODE_MASK 0x00000008
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_FILTER_PIXEL_MODE_SHIFT 3

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_CLIENT_MASK_MODE [02:02] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_CLIENT_MASK_MODE_MASK 0x00000004
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_CLIENT_MASK_MODE_SHIFT 2

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_IN_OUT [01:01] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_IN_OUT_MASK 0x00000002
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_IN_OUT_SHIFT 1

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_MODEi :: MEMORY_ADDRESS_EN [00:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_ADDRESS_EN_MASK 0x00000001
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_MODEi_MEMORY_ADDRESS_EN_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_PIX_X1_Y1_COORD%i - X1,Y1 Coordinate
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_BASE 0x0040c730
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_PIX_X1_Y1_COORD%i - X1,Y1 Coordinate
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X1_Y1_COORDi :: reserved0 [31:27] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_reserved0_MASK 0xf8000000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_reserved0_SHIFT 27

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X1_Y1_COORDi :: Y1_COORD [26:16] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_Y1_COORD_MASK 0x07ff0000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_Y1_COORD_SHIFT 16

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X1_Y1_COORDi :: reserved1 [15:11] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_reserved1_MASK 0x0000f800
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_reserved1_SHIFT 11

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X1_Y1_COORDi :: X1_COORD [10:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_X1_COORD_MASK 0x000007ff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X1_Y1_COORDi_X1_COORD_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_PIX_X2_Y2_COORD%i - X2,Y2 Coordinate
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_BASE 0x0040c740
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_PIX_X2_Y2_COORD%i - X2,Y2 Coordinate
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X2_Y2_COORDi :: reserved0 [31:27] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_reserved0_MASK 0xf8000000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_reserved0_SHIFT 27

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X2_Y2_COORDi :: Y2_COORD [26:16] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_Y2_COORD_MASK 0x07ff0000
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_Y2_COORD_SHIFT 16

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X2_Y2_COORDi :: reserved1 [15:11] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_reserved1_MASK 0x0000f800
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_reserved1_SHIFT 11

/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_PIX_X2_Y2_COORDi :: X2_COORD [10:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_X2_COORD_MASK 0x000007ff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_PIX_X2_Y2_COORDi_X2_COORD_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_CLIENT_MASK_64_95_%i - Trigger Memory Filter Window Client Mask for Clients 64-95
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_BASE 0x0040c750
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_64_95_i_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_CLIENT_MASK_64_95_%i - Trigger Memory Filter Window Client Mask for Clients 64-95
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_CLIENT_MASK_64_95_i :: MEMORY_CLIENT_MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_64_95_i_MEMORY_CLIENT_MASK_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_64_95_i_MEMORY_CLIENT_MASK_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_CLIENT_MASK_32_63_%i - Trigger Memory Filter Window Client Mask for Clients 32-63
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_BASE 0x0040c760
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_32_63_i_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_CLIENT_MASK_32_63_%i - Trigger Memory Filter Window Client Mask for Clients 32-63
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_CLIENT_MASK_32_63_i :: MEMORY_CLIENT_MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_32_63_i_MEMORY_CLIENT_MASK_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_32_63_i_MEMORY_CLIENT_MASK_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_CLIENT_MASK_31_0_%i - Trigger Memory Filter Window Client Mask for Clients 0-31
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_BASE 0x0040c770
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_31_0_i_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_CLIENT_MASK_31_0_%i - Trigger Memory Filter Window Client Mask for Clients 0-31
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_CLIENT_MASK_31_0_i :: MEMORY_CLIENT_MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_31_0_i_MEMORY_CLIENT_MASK_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_CLIENT_MASK_31_0_i_MEMORY_CLIENT_MASK_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_ADDR_UPPER%i - Trigger Memory Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_UPPERi_ARRAY_BASE 0x0040c780
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_UPPERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_UPPERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_UPPERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_ADDR_UPPER%i - Trigger Memory Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_ADDR_UPPERi :: UPPER_MEMORY_ADDR [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_UPPERi_UPPER_MEMORY_ADDR_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_UPPERi_UPPER_MEMORY_ADDR_SHIFT 0


/***************************************************************************
 *TRIG_MEM_FILT_ADDR_LOWER%i - Trigger Memory Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_LOWERi_ARRAY_BASE 0x0040c790
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_LOWERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_LOWERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_LOWERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_MEM_FILT_ADDR_LOWER%i - Trigger Memory Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_MEM_FILT_ADDR_LOWERi :: LOWER_MEMORY_ADDR [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_LOWERi_LOWER_MEMORY_ADDR_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_MEM_FILT_ADDR_LOWERi_LOWER_MEMORY_ADDR_SHIFT 0


/***************************************************************************
 *TRIG_IO_FILT_MODE%i - Trigger I/O Filter Mode
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_ARRAY_BASE      0x0040c7a0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_ARRAY_START     0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_ARRAY_END       3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_IO_FILT_MODE%i - Trigger I/O Filter Mode
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: reserved0 [31:06] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_reserved0_MASK  0xffffffc0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_reserved0_SHIFT 6

/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: FILTER_IO_EN [05:05] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_FILTER_IO_EN_MASK 0x00000020
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_FILTER_IO_EN_SHIFT 5

/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: GISB_READ_MODE [04:04] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_GISB_READ_MODE_MASK 0x00000010
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_GISB_READ_MODE_SHIFT 4

/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: GISB_WRITE_MODE [03:03] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_GISB_WRITE_MODE_MASK 0x00000008
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_GISB_WRITE_MODE_SHIFT 3

/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: DATA_MODE [02:02] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_DATA_MODE_MASK  0x00000004
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_DATA_MODE_SHIFT 2

/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: IO_IN_OUT [01:01] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_IO_IN_OUT_MASK  0x00000002
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_IO_IN_OUT_SHIFT 1

/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_MODEi :: IO_ADDRESS_EN [00:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_IO_ADDRESS_EN_MASK 0x00000001
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_MODEi_IO_ADDRESS_EN_SHIFT 0


/***************************************************************************
 *TRIG_IO_FILT_ADDR_UPPER%i - Trigger I/O Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_UPPERi_ARRAY_BASE 0x0040c7b0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_UPPERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_UPPERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_UPPERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_IO_FILT_ADDR_UPPER%i - Trigger I/O Filter Window Client Mask Upper Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_ADDR_UPPERi :: IO_ADDR_UPPER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_UPPERi_IO_ADDR_UPPER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_UPPERi_IO_ADDR_UPPER_SHIFT 0


/***************************************************************************
 *TRIG_IO_FILT_ADDR_LOWER%i - Trigger I/O Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_LOWERi_ARRAY_BASE 0x0040c7c0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_LOWERi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_LOWERi_ARRAY_END 3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_LOWERi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_IO_FILT_ADDR_LOWER%i - Trigger I/O Filter Window Client Mask Lower Bound Address
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_ADDR_LOWERi :: IO_ADDR_LOWER [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_LOWERi_IO_ADDR_LOWER_MASK 0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_ADDR_LOWERi_IO_ADDR_LOWER_SHIFT 0


/***************************************************************************
 *TRIG_IO_FILT_DATA%i - Trigger I/O Filter Window Data
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATAi_ARRAY_BASE      0x0040c7d0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATAi_ARRAY_START     0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATAi_ARRAY_END       3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATAi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_IO_FILT_DATA%i - Trigger I/O Filter Window Data
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_DATAi :: DATA [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATAi_DATA_MASK       0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATAi_DATA_SHIFT      0


/***************************************************************************
 *TRIG_IO_FILT_DATA_MASK%i - Trigger I/O Filter Window Data Mask
 ***************************************************************************/
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATA_MASKi_ARRAY_BASE 0x0040c7e0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATA_MASKi_ARRAY_START 0
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATA_MASKi_ARRAY_END  3
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATA_MASKi_ARRAY_ELEMENT_SIZE 32

/***************************************************************************
 *TRIG_IO_FILT_DATA_MASK%i - Trigger I/O Filter Window Data Mask
 ***************************************************************************/
/* PRI_ARB_TRACE_REGS :: TRIG_IO_FILT_DATA_MASKi :: MASK [31:00] */
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATA_MASKi_MASK_MASK  0xffffffff
#define BCHP_PRI_ARB_TRACE_REGS_TRIG_IO_FILT_DATA_MASKi_MASK_SHIFT 0


#endif /* #ifndef BCHP_PRI_ARB_TRACE_REGS_H__ */

/* End of File */
