/*
 *      plugins.h - this file is part of Geany, a fast and lightweight IDE
 *
 *      Copyright 2007 The Geany contributors
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along
 *      with this program; if not, write to the Free Software Foundation, Inc.,
 *      51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef GEANY_PLUGINS_H
#define GEANY_PLUGINS_H 1

#ifdef HAVE_PLUGINS

#include <glib.h>

G_BEGIN_DECLS

extern GList *active_plugin_list;


void plugins_init(void);

void plugins_finalize(void);

void plugins_load_active(void);

gboolean plugins_have_preferences(void);

G_END_DECLS

#endif /* HAVE_PLUGINS */

#endif /* GEANY_PLUGINS_H */
