.TH GRDIMAGE l "1 Jan 2004"
.SH NAME
grdimage \- Create grayshaded or colored image from a 2-D netCDF grd file
.SH SYNOPSIS
\fBgrdimage\fP \fIgrdfile\fP \fB\-C\fP\fIcptfile\fP \fB\-J\fP\fIparameters\fP
[ \fB\-B\fP\fItickinfo\fP ] [ \fB\-E\fP\fIdpi\fP ] [ \fB\-G\fP[\fBf|b\fP]\fIrgb\fP ] [ \fB\-I\fP\fIintensfile\fP] [ \fB\-K\fP ]
[ \fB\-M\fP ] [ \fB\-O\fP ] [ \fB\-P\fP ] [ \fB\-R\fP\fIwest/east/south/north\fP[\fBr\fP] ] [ \fB\-S\fP\fIsearch_radius\fP ]
[ \fB\-T\fP[\fBs\fP] ] [ \fB\-U\fP[\fI/dx/dy/\fP][\fIlabel\fP] ] [ \fB\-V \fP ] [ \fB\-X\fP\fIx-shift\fP ] [ \fB\-Y\fP\fIy-shift\fP ]
[ \fB\-c\fP\fIcopies\fP ]
.SH DESCRIPTION
\fBgrdimage\fP reads a 2-D gridded file and produces a gray-shaded (or colored) map by assigning
each contour interval a gray-shade (or color). Optionally, illumination may be added by providing
a file with intensities in the (-1,+1) range. Values outside this range will be clipped.
Such intensity files can be created from the
grdfile using \fBgrdgradient\fP and modified by \fBgrdmath\fP or \fBgrdhisteq\fP. Each grid-node in the
grdfile is represented as a shaded (or colored) rectangle centered on the grid node. When using map projections,
the grid is first resampled on a new rectangular grid (This can be a time-consuming process for large grid files; but see -T).
A 24-bit true color \fIPostScript\fP file is output.
The region option can be used to select a map region larger or smaller than that implied by the extent of the
grdfile.
.TP
\fIgrdfile\fP
2-D gridded data set to be imaged
.TP
.B \-C
name of the color palette table
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the MEASURE_UNIT setting in .gmtdefaults, but this can be
overridden on the command line by appending the c, i, or m to the scale/width value.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection)
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert).
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant).
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic).
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic).
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP] (polar (theta,r) coordinates, optional \fBa\fP for azimuths and offset theta [0])
.br
\fB\-Jx\fP\fIx-scale\fP[\fBl|p\fP\fIpow\fP][\fI/y-scale\fP[\fBl|p\fP\fIpow\fP]] (Linear, log, and power scaling)
.br
More details can be found in the \fBpsbasemap\fP manpages.
.br
.SH OPTIONS
No space between the option flag and the associated arguments.
.TP
.B \-B
Sets map boundary tickmark intervals. See \fBpsbasemap\fP for details.
.TP
.B \-E
Sets the resolution of the projected grid that will be created if
a map projection other than Linear or Mercator was selected. By default,
the projected grid will be of the same size (rows and columns) as the
input file.
.TP
.B \-G
This option only applies when the resulting image otherwise would consist
of only two colors: black (0) and white (255). If so, this option will
instead use the image as a transparent mask and point the mask (or its
inverse, with \fB\-Gb\fP) with the given color combination.
.TP
.B \-I
Gives the name of a grdfile with intensities in the (-1,+1) range. [Default is no illumination].
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Force conversion to monochrome image using the (television) YIQ transformation.
.TP
.B \-bo
Selects binary output. Append \fBs\fP for single precision [Default is double].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see gmtdefaults to change this].
.TP
.B \-R
\fIwest, east, south,\fP and \fInorth\fP specify the Region of interest. To specify boundaries
in degrees and minutes [and seconds], use the dd:mm[:ss] format. Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.
You may ask for a larger \fIw/e/s/n\fP region to have more room between the image and the axes.
A smaller region than specified in the grdfile will result in a subset of the grid [Default is
region given by the grdfile].
.TP
.B \-S
Set the search radius for the averaging procedure [Default avoids aliasing].
.TP
.B \-T
Plot image without any interpolation. This involves converting each node-centered
bin into a polygon which is then painted separately. Append \fBs\fP to skip
nodes with z = NaN. This option is useful for categorical data where
interpolating between values is meaningless.
.TP
.B \-U
Draw Unix System time stamp on plot. User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot. Optionally,
append a label, or \fBc\fP (which will plot the command string.). The GMT parameters
UNIX_TIME and UNIX_TIME_POS can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
.TP
.B \-c
Specifies the number of plot copies. [Default is 1]
.SH EXAMPLES
To gray-shade the file hawaii_grav.grd with shades given in shades.cpt on a Lambert map
at 1.5 cm/degree along the standard parallels 18 and 24, and using 1 degree tickmarks, try
.br
.sp
grdimage hawaii_grav.grd \fB\-Jl\fP18/24/1.5\fBc\fP \fB\-C\fPshades.cpt \fB\-B\fP1 > hawaii_grav_image.ps
.br
.sp
To create an illuminated color \fIPostScript\fP plot of the gridded data set image.grd, using the
intensities provided by the file intens.grd, and color
levels in the file colors.cpt, with linear scaling at 10 inch/x-unit, tickmarks every 5 units, try
.br
.sp
grdimage image.grd \fB\-Jx\fP10\fBi\fP \fB\-C\fPcolors.cpt \fB\-I\fPintens.grd \fB\-B\fP5 > image.ps
.SH "SEE ALSO"
.IR gmt (l),
.IR grdcontour (l),
.IR grdview (l),
.IR grdgradient (l),
.IR grdhisteq (l)
