-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_menu.adb,v $
--  Description     : Handling of menu entires                               --
--  Author          : Michael Erdmann                                        --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: persan $
--  Last Modified On: $Date: 2007/09/06 20:17:53 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings;              use Ada.Strings;

-- Gdk
with Gdk;
with Gdk.Window;               use Gdk.Window;
-- Gtk
with Gtk;                      use Gtk;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Menu_Bar;             use Gtk.Menu_Bar;
with Gtk.Menu;                 use Gtk.Menu;
with Gtk.Main;                 use Gtk.Main;
with Gtk.Menu_Item;            use Gtk.Menu_Item;
with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;

with GUI_Dialog;               use GUI_Dialog;
with GUI_License;              use GUI_License;
with GUI_About;                use GUI_About;

package body GUI_Menu is

   Version  : constant String := "$Id: gui_menu.adb,v 1.10 2007/09/06 20:17:53 persan Exp $";

   -----------------
   -- GTK Objects --
   -----------------
   Menubar    : Gtk_Menu_Bar;

   MI_Exit          : constant Natural := 1;
   MI_About         : constant Natural := 2;
   MI_License       : constant Natural := 3;
   MI_Save_As       : constant Natural := 4;

   MI_Open_Project  : constant Natural := 5;
   MI_Close_Project : constant Natural := 6;
   MI_New_Project   : constant Natural := 7;

   File_Menu : Menu_Definition (1 .. 2) := (
                                            1 => (To_Unbounded_String ("Exit"),          MI_Exit),
                                            2 => (To_Unbounded_String ("Close"),         MI_Close_Project)
                                             --         3 => ( To_Unbounded_String("Save as"),       MI_Save_As       ),
                                             --
                                             --         4 => ( To_Unbounded_String("Open Project"),  MI_Open_Project  ),
                                             --         5 => ( To_Unbounded_String("Close Project"), MI_Close_Project ),
                                             --         6 => ( To_Unbounded_String("New Project"),   MI_New_Project   )
                                           );

   Help_Menu : Menu_Definition (1 .. 2) := (
                                            1 => (To_Unbounded_String ("About"),   MI_About),
                                            2 => (To_Unbounded_String ("License"), MI_License)
                                           );
   ------------------------
   -- Menu Item Handling --
   ------------------------
   type Menu_Item_Record is new Gtk_Menu_Item_Record with record
      Id   : Natural := 0;
   end record;

   type Menu_Item is access all Menu_Item_Record;

   package Menu_Item_Callback is new
     Gtk.Handlers.Callback (Gtk_Menu_Item_Record);

   ----------------------
   -- Support Packages --
   ----------------------
   package Destroyed is new Gtk.Handlers.Callback (
                                                   Widget_Type => Gtk_Window_Record);

   Dlg_License : GUI_License.Object;
   Dlg_About   : GUI_About.Object;

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize is
   -- package initialization (non GTK related).
   begin
      null;
   end Initialize;

   --------------
   -- Finalize --
   --------------
   procedure Finalize is
   -- package finalization (non GTK related).
   begin
      null;
   end Finalize;
   --------------------
   -- CB_Menu_Select --
   --------------------
   procedure Cb_Menu_Select (
                             Object : access Gtk_Menu_Item_Record'Class) is
   -- this procedure is called every time a menu item has
   -- been selected.
      Item   : constant Menu_Item := Menu_Item (Object);
   begin
      case Item.Id is
         when MI_Exit =>
            Dont_Save := False;
            Gtk.Main.Main_Quit;

         when MI_Close_Project =>
            Dont_Save := True;
            Gtk.Main.Main_Quit;

         when MI_License =>
            Initialize (Dlg_License);
            Add_Dialog (Dlg_License, "License", 580, 550);
         when MI_About =>
            Initialize (Dlg_About);
            Add_Dialog (Dlg_About, "GSQL About", 300, 190);

         when others =>
            null;
      end case;
   end Cb_Menu_Select;

   -------------------
   -- Add_Menu_Item --
   -------------------
   procedure Add_Menu_Item (
                            Submenu   : in Gtk_Menu;
                            Menu_Text : in Unbounded_String;
                            Id        : in Natural) is
      Item      : Menu_Item := new Menu_Item_Record;

   begin
      Gtk.Menu_Item.Initialize (Item, To_String (Menu_Text));
      Item.Id := Id;

      Menu_Item_Callback.Connect (
                                  Item,
                                  "activate",
                                  Menu_Item_Callback.To_Marshaller (Cb_Menu_Select'Access)
                                 );
      Insert (Submenu, Item);
   end Add_Menu_Item;

   -----------------
   -- Add_Menubar --
   -----------------
   procedure Add_Menubar (
                          Wbox : in out Gtk_Box) is
   begin
      Gtk_New (Menubar);
      Pack_Start (Wbox, Child => Menubar, Expand => False);
      Show_All (Menubar);

      Add_Menu ("File", File_Menu);
      Add_Menu ("Help", Help_Menu);
   end Add_Menubar;

   ----------------
   -- Menu_Entry --
   ----------------
   function Menu_Entry (
                        Name : in String;
                        Id   : in Natural) return Menu_Definition_Record is
   ---
      Result : Menu_Definition_Record := (Name => To_Unbounded_String (Name), Id => Id);
   begin
      return Result;
   end Menu_Entry;

   --------------
   -- Add_Menu --
   --------------
   procedure Add_Menu (
                       Title    : in String;
                       Contents : in Menu_Definition) is
      Menu     : Gtk_Menu_Item;
      Submenu  : Gtk_Menu;
   begin
      Gtk_New (Menu, Title);
      Append (Menubar, Menu);

      Gtk_New (Submenu);

      for I in Contents'Range loop
         Add_Menu_Item (Submenu, Contents (I).Name, Contents (I).Id);
      end loop;

      Set_Submenu (Menu, Submenu);
   end Add_Menu;

end GUI_Menu;

