/* 
 * Copyright (C) 2004, 2005 Jean-Yves Lefort <jylefort@brutele.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GT_SHELL_H
#define _GT_SHELL_H

#include <gtk/gtk.h>
#include <translate.h>

#define GT_TYPE_SHELL			(gt_shell_get_type())
#define GT_SHELL(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), GT_TYPE_SHELL, GTShell))
#define GT_SHELL_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GT_TYPE_SHELL, GTShellClass))
#define GT_IS_SHELL(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GT_TYPE_SHELL))
#define GT_IS_SHELL_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GT_TYPE_SHELL))
#define GT_SHELL_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), GT_TYPE_SHELL, GTShellClass))

typedef struct _GTShellPrivate GTShellPrivate;

typedef struct
{
  GObject		parent;
  GTShellPrivate	*priv;
} GTShell;

typedef struct
{
  GObjectClass		parent;
} GTShellClass;

extern GTShell *gt_shell;

GType gt_shell_get_type (void);
GTShell *gt_shell_new (void);

TranslateSession *gt_shell_get_translate_session (GTShell *shell);

#endif /* _GT_SHELL_H */
