// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpDecryptData struct {
}

func (*validateOpDecryptData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDecryptData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DecryptDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDecryptDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpEncryptData struct {
}

func (*validateOpEncryptData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpEncryptData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*EncryptDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpEncryptDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateCardValidationData struct {
}

func (*validateOpGenerateCardValidationData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateCardValidationData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateCardValidationDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateCardValidationDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGenerateMac struct {
}

func (*validateOpGenerateMac) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGenerateMac) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GenerateMacInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGenerateMacInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGeneratePinData struct {
}

func (*validateOpGeneratePinData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGeneratePinData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GeneratePinDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGeneratePinDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpReEncryptData struct {
}

func (*validateOpReEncryptData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpReEncryptData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ReEncryptDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpReEncryptDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTranslatePinData struct {
}

func (*validateOpTranslatePinData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTranslatePinData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TranslatePinDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTranslatePinDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpVerifyAuthRequestCryptogram struct {
}

func (*validateOpVerifyAuthRequestCryptogram) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpVerifyAuthRequestCryptogram) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*VerifyAuthRequestCryptogramInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpVerifyAuthRequestCryptogramInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpVerifyCardValidationData struct {
}

func (*validateOpVerifyCardValidationData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpVerifyCardValidationData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*VerifyCardValidationDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpVerifyCardValidationDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpVerifyMac struct {
}

func (*validateOpVerifyMac) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpVerifyMac) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*VerifyMacInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpVerifyMacInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpVerifyPinData struct {
}

func (*validateOpVerifyPinData) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpVerifyPinData) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*VerifyPinDataInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpVerifyPinDataInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpDecryptDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDecryptData{}, middleware.After)
}

func addOpEncryptDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpEncryptData{}, middleware.After)
}

func addOpGenerateCardValidationDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateCardValidationData{}, middleware.After)
}

func addOpGenerateMacValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGenerateMac{}, middleware.After)
}

func addOpGeneratePinDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGeneratePinData{}, middleware.After)
}

func addOpReEncryptDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpReEncryptData{}, middleware.After)
}

func addOpTranslatePinDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTranslatePinData{}, middleware.After)
}

func addOpVerifyAuthRequestCryptogramValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpVerifyAuthRequestCryptogram{}, middleware.After)
}

func addOpVerifyCardValidationDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpVerifyCardValidationData{}, middleware.After)
}

func addOpVerifyMacValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpVerifyMac{}, middleware.After)
}

func addOpVerifyPinDataValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpVerifyPinData{}, middleware.After)
}

func validateAmexCardSecurityCodeVersion1(v *types.AmexCardSecurityCodeVersion1) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AmexCardSecurityCodeVersion1"}
	if v.CardExpiryDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardExpiryDate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAmexCardSecurityCodeVersion2(v *types.AmexCardSecurityCodeVersion2) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AmexCardSecurityCodeVersion2"}
	if v.CardExpiryDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardExpiryDate"))
	}
	if v.ServiceCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceCode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCardGenerationAttributes(v types.CardGenerationAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CardGenerationAttributes"}
	switch uv := v.(type) {
	case *types.CardGenerationAttributesMemberAmexCardSecurityCodeVersion1:
		if err := validateAmexCardSecurityCodeVersion1(&uv.Value); err != nil {
			invalidParams.AddNested("[AmexCardSecurityCodeVersion1]", err.(smithy.InvalidParamsError))
		}

	case *types.CardGenerationAttributesMemberAmexCardSecurityCodeVersion2:
		if err := validateAmexCardSecurityCodeVersion2(&uv.Value); err != nil {
			invalidParams.AddNested("[AmexCardSecurityCodeVersion2]", err.(smithy.InvalidParamsError))
		}

	case *types.CardGenerationAttributesMemberCardHolderVerificationValue:
		if err := validateCardHolderVerificationValue(&uv.Value); err != nil {
			invalidParams.AddNested("[CardHolderVerificationValue]", err.(smithy.InvalidParamsError))
		}

	case *types.CardGenerationAttributesMemberCardVerificationValue1:
		if err := validateCardVerificationValue1(&uv.Value); err != nil {
			invalidParams.AddNested("[CardVerificationValue1]", err.(smithy.InvalidParamsError))
		}

	case *types.CardGenerationAttributesMemberCardVerificationValue2:
		if err := validateCardVerificationValue2(&uv.Value); err != nil {
			invalidParams.AddNested("[CardVerificationValue2]", err.(smithy.InvalidParamsError))
		}

	case *types.CardGenerationAttributesMemberDynamicCardVerificationCode:
		if err := validateDynamicCardVerificationCode(&uv.Value); err != nil {
			invalidParams.AddNested("[DynamicCardVerificationCode]", err.(smithy.InvalidParamsError))
		}

	case *types.CardGenerationAttributesMemberDynamicCardVerificationValue:
		if err := validateDynamicCardVerificationValue(&uv.Value); err != nil {
			invalidParams.AddNested("[DynamicCardVerificationValue]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCardHolderVerificationValue(v *types.CardHolderVerificationValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CardHolderVerificationValue"}
	if v.UnpredictableNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UnpredictableNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCardVerificationAttributes(v types.CardVerificationAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CardVerificationAttributes"}
	switch uv := v.(type) {
	case *types.CardVerificationAttributesMemberAmexCardSecurityCodeVersion1:
		if err := validateAmexCardSecurityCodeVersion1(&uv.Value); err != nil {
			invalidParams.AddNested("[AmexCardSecurityCodeVersion1]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberAmexCardSecurityCodeVersion2:
		if err := validateAmexCardSecurityCodeVersion2(&uv.Value); err != nil {
			invalidParams.AddNested("[AmexCardSecurityCodeVersion2]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberCardHolderVerificationValue:
		if err := validateCardHolderVerificationValue(&uv.Value); err != nil {
			invalidParams.AddNested("[CardHolderVerificationValue]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberCardVerificationValue1:
		if err := validateCardVerificationValue1(&uv.Value); err != nil {
			invalidParams.AddNested("[CardVerificationValue1]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberCardVerificationValue2:
		if err := validateCardVerificationValue2(&uv.Value); err != nil {
			invalidParams.AddNested("[CardVerificationValue2]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberDiscoverDynamicCardVerificationCode:
		if err := validateDiscoverDynamicCardVerificationCode(&uv.Value); err != nil {
			invalidParams.AddNested("[DiscoverDynamicCardVerificationCode]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberDynamicCardVerificationCode:
		if err := validateDynamicCardVerificationCode(&uv.Value); err != nil {
			invalidParams.AddNested("[DynamicCardVerificationCode]", err.(smithy.InvalidParamsError))
		}

	case *types.CardVerificationAttributesMemberDynamicCardVerificationValue:
		if err := validateDynamicCardVerificationValue(&uv.Value); err != nil {
			invalidParams.AddNested("[DynamicCardVerificationValue]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCardVerificationValue1(v *types.CardVerificationValue1) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CardVerificationValue1"}
	if v.CardExpiryDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardExpiryDate"))
	}
	if v.ServiceCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceCode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCardVerificationValue2(v *types.CardVerificationValue2) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CardVerificationValue2"}
	if v.CardExpiryDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardExpiryDate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCryptogramAuthResponse(v types.CryptogramAuthResponse) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CryptogramAuthResponse"}
	switch uv := v.(type) {
	case *types.CryptogramAuthResponseMemberArpcMethod1:
		if err := validateCryptogramVerificationArpcMethod1(&uv.Value); err != nil {
			invalidParams.AddNested("[ArpcMethod1]", err.(smithy.InvalidParamsError))
		}

	case *types.CryptogramAuthResponseMemberArpcMethod2:
		if err := validateCryptogramVerificationArpcMethod2(&uv.Value); err != nil {
			invalidParams.AddNested("[ArpcMethod2]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCryptogramVerificationArpcMethod1(v *types.CryptogramVerificationArpcMethod1) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CryptogramVerificationArpcMethod1"}
	if v.AuthResponseCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthResponseCode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCryptogramVerificationArpcMethod2(v *types.CryptogramVerificationArpcMethod2) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CryptogramVerificationArpcMethod2"}
	if v.CardStatusUpdate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardStatusUpdate"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDiscoverDynamicCardVerificationCode(v *types.DiscoverDynamicCardVerificationCode) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DiscoverDynamicCardVerificationCode"}
	if v.CardExpiryDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardExpiryDate"))
	}
	if v.UnpredictableNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UnpredictableNumber"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDukptAttributes(v *types.DukptAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DukptAttributes"}
	if v.KeySerialNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeySerialNumber"))
	}
	if len(v.DukptDerivationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DukptDerivationType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDukptDerivationAttributes(v *types.DukptDerivationAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DukptDerivationAttributes"}
	if v.KeySerialNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeySerialNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDukptEncryptionAttributes(v *types.DukptEncryptionAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DukptEncryptionAttributes"}
	if v.KeySerialNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeySerialNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynamicCardVerificationCode(v *types.DynamicCardVerificationCode) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynamicCardVerificationCode"}
	if v.UnpredictableNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UnpredictableNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if v.TrackData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrackData"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDynamicCardVerificationValue(v *types.DynamicCardVerificationValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DynamicCardVerificationValue"}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if v.CardExpiryDate == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CardExpiryDate"))
	}
	if v.ServiceCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceCode"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEncryptionDecryptionAttributes(v types.EncryptionDecryptionAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionDecryptionAttributes"}
	switch uv := v.(type) {
	case *types.EncryptionDecryptionAttributesMemberDukpt:
		if err := validateDukptEncryptionAttributes(&uv.Value); err != nil {
			invalidParams.AddNested("[Dukpt]", err.(smithy.InvalidParamsError))
		}

	case *types.EncryptionDecryptionAttributesMemberSymmetric:
		if err := validateSymmetricEncryptionAttributes(&uv.Value); err != nil {
			invalidParams.AddNested("[Symmetric]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIbm3624NaturalPin(v *types.Ibm3624NaturalPin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ibm3624NaturalPin"}
	if v.DecimalizationTable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DecimalizationTable"))
	}
	if v.PinValidationDataPadCharacter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if v.PinValidationData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationData"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIbm3624PinFromOffset(v *types.Ibm3624PinFromOffset) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ibm3624PinFromOffset"}
	if v.DecimalizationTable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DecimalizationTable"))
	}
	if v.PinValidationDataPadCharacter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if v.PinValidationData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationData"))
	}
	if v.PinOffset == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinOffset"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIbm3624PinOffset(v *types.Ibm3624PinOffset) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ibm3624PinOffset"}
	if v.EncryptedPinBlock == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptedPinBlock"))
	}
	if v.DecimalizationTable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DecimalizationTable"))
	}
	if v.PinValidationDataPadCharacter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if v.PinValidationData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationData"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIbm3624PinVerification(v *types.Ibm3624PinVerification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ibm3624PinVerification"}
	if v.DecimalizationTable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DecimalizationTable"))
	}
	if v.PinValidationDataPadCharacter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if v.PinValidationData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationData"))
	}
	if v.PinOffset == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinOffset"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIbm3624RandomPin(v *types.Ibm3624RandomPin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Ibm3624RandomPin"}
	if v.DecimalizationTable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DecimalizationTable"))
	}
	if v.PinValidationDataPadCharacter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationDataPadCharacter"))
	}
	if v.PinValidationData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinValidationData"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMacAlgorithmDukpt(v *types.MacAlgorithmDukpt) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MacAlgorithmDukpt"}
	if v.KeySerialNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeySerialNumber"))
	}
	if len(v.DukptKeyVariant) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DukptKeyVariant"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMacAlgorithmEmv(v *types.MacAlgorithmEmv) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MacAlgorithmEmv"}
	if len(v.MajorKeyDerivationMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MajorKeyDerivationMode"))
	}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if len(v.SessionKeyDerivationMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SessionKeyDerivationMode"))
	}
	if v.SessionKeyDerivationValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionKeyDerivationValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMacAttributes(v types.MacAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MacAttributes"}
	switch uv := v.(type) {
	case *types.MacAttributesMemberDukptCmac:
		if err := validateMacAlgorithmDukpt(&uv.Value); err != nil {
			invalidParams.AddNested("[DukptCmac]", err.(smithy.InvalidParamsError))
		}

	case *types.MacAttributesMemberDukptIso9797Algorithm1:
		if err := validateMacAlgorithmDukpt(&uv.Value); err != nil {
			invalidParams.AddNested("[DukptIso9797Algorithm1]", err.(smithy.InvalidParamsError))
		}

	case *types.MacAttributesMemberDukptIso9797Algorithm3:
		if err := validateMacAlgorithmDukpt(&uv.Value); err != nil {
			invalidParams.AddNested("[DukptIso9797Algorithm3]", err.(smithy.InvalidParamsError))
		}

	case *types.MacAttributesMemberEmvMac:
		if err := validateMacAlgorithmEmv(&uv.Value); err != nil {
			invalidParams.AddNested("[EmvMac]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePinGenerationAttributes(v types.PinGenerationAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PinGenerationAttributes"}
	switch uv := v.(type) {
	case *types.PinGenerationAttributesMemberIbm3624NaturalPin:
		if err := validateIbm3624NaturalPin(&uv.Value); err != nil {
			invalidParams.AddNested("[Ibm3624NaturalPin]", err.(smithy.InvalidParamsError))
		}

	case *types.PinGenerationAttributesMemberIbm3624PinFromOffset:
		if err := validateIbm3624PinFromOffset(&uv.Value); err != nil {
			invalidParams.AddNested("[Ibm3624PinFromOffset]", err.(smithy.InvalidParamsError))
		}

	case *types.PinGenerationAttributesMemberIbm3624PinOffset:
		if err := validateIbm3624PinOffset(&uv.Value); err != nil {
			invalidParams.AddNested("[Ibm3624PinOffset]", err.(smithy.InvalidParamsError))
		}

	case *types.PinGenerationAttributesMemberIbm3624RandomPin:
		if err := validateIbm3624RandomPin(&uv.Value); err != nil {
			invalidParams.AddNested("[Ibm3624RandomPin]", err.(smithy.InvalidParamsError))
		}

	case *types.PinGenerationAttributesMemberVisaPin:
		if err := validateVisaPin(&uv.Value); err != nil {
			invalidParams.AddNested("[VisaPin]", err.(smithy.InvalidParamsError))
		}

	case *types.PinGenerationAttributesMemberVisaPinVerificationValue:
		if err := validateVisaPinVerificationValue(&uv.Value); err != nil {
			invalidParams.AddNested("[VisaPinVerificationValue]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePinVerificationAttributes(v types.PinVerificationAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PinVerificationAttributes"}
	switch uv := v.(type) {
	case *types.PinVerificationAttributesMemberIbm3624Pin:
		if err := validateIbm3624PinVerification(&uv.Value); err != nil {
			invalidParams.AddNested("[Ibm3624Pin]", err.(smithy.InvalidParamsError))
		}

	case *types.PinVerificationAttributesMemberVisaPin:
		if err := validateVisaPinVerification(&uv.Value); err != nil {
			invalidParams.AddNested("[VisaPin]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReEncryptionAttributes(v types.ReEncryptionAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReEncryptionAttributes"}
	switch uv := v.(type) {
	case *types.ReEncryptionAttributesMemberDukpt:
		if err := validateDukptEncryptionAttributes(&uv.Value); err != nil {
			invalidParams.AddNested("[Dukpt]", err.(smithy.InvalidParamsError))
		}

	case *types.ReEncryptionAttributesMemberSymmetric:
		if err := validateSymmetricEncryptionAttributes(&uv.Value); err != nil {
			invalidParams.AddNested("[Symmetric]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionKeyAmex(v *types.SessionKeyAmex) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionKeyAmex"}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionKeyDerivation(v types.SessionKeyDerivation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionKeyDerivation"}
	switch uv := v.(type) {
	case *types.SessionKeyDerivationMemberAmex:
		if err := validateSessionKeyAmex(&uv.Value); err != nil {
			invalidParams.AddNested("[Amex]", err.(smithy.InvalidParamsError))
		}

	case *types.SessionKeyDerivationMemberEmv2000:
		if err := validateSessionKeyEmv2000(&uv.Value); err != nil {
			invalidParams.AddNested("[Emv2000]", err.(smithy.InvalidParamsError))
		}

	case *types.SessionKeyDerivationMemberEmvCommon:
		if err := validateSessionKeyEmvCommon(&uv.Value); err != nil {
			invalidParams.AddNested("[EmvCommon]", err.(smithy.InvalidParamsError))
		}

	case *types.SessionKeyDerivationMemberMastercard:
		if err := validateSessionKeyMastercard(&uv.Value); err != nil {
			invalidParams.AddNested("[Mastercard]", err.(smithy.InvalidParamsError))
		}

	case *types.SessionKeyDerivationMemberVisa:
		if err := validateSessionKeyVisa(&uv.Value); err != nil {
			invalidParams.AddNested("[Visa]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionKeyEmv2000(v *types.SessionKeyEmv2000) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionKeyEmv2000"}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionKeyEmvCommon(v *types.SessionKeyEmvCommon) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionKeyEmvCommon"}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionKeyMastercard(v *types.SessionKeyMastercard) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionKeyMastercard"}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if v.ApplicationTransactionCounter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationTransactionCounter"))
	}
	if v.UnpredictableNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UnpredictableNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSessionKeyVisa(v *types.SessionKeyVisa) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SessionKeyVisa"}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.PanSequenceNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PanSequenceNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSymmetricEncryptionAttributes(v *types.SymmetricEncryptionAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SymmetricEncryptionAttributes"}
	if len(v.Mode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Mode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTranslationIsoFormats(v types.TranslationIsoFormats) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TranslationIsoFormats"}
	switch uv := v.(type) {
	case *types.TranslationIsoFormatsMemberIsoFormat0:
		if err := validateTranslationPinDataIsoFormat034(&uv.Value); err != nil {
			invalidParams.AddNested("[IsoFormat0]", err.(smithy.InvalidParamsError))
		}

	case *types.TranslationIsoFormatsMemberIsoFormat3:
		if err := validateTranslationPinDataIsoFormat034(&uv.Value); err != nil {
			invalidParams.AddNested("[IsoFormat3]", err.(smithy.InvalidParamsError))
		}

	case *types.TranslationIsoFormatsMemberIsoFormat4:
		if err := validateTranslationPinDataIsoFormat034(&uv.Value); err != nil {
			invalidParams.AddNested("[IsoFormat4]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTranslationPinDataIsoFormat034(v *types.TranslationPinDataIsoFormat034) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TranslationPinDataIsoFormat034"}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVisaPin(v *types.VisaPin) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VisaPin"}
	if v.PinVerificationKeyIndex == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinVerificationKeyIndex"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVisaPinVerification(v *types.VisaPinVerification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VisaPinVerification"}
	if v.PinVerificationKeyIndex == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinVerificationKeyIndex"))
	}
	if v.VerificationValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VerificationValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVisaPinVerificationValue(v *types.VisaPinVerificationValue) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VisaPinVerificationValue"}
	if v.EncryptedPinBlock == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptedPinBlock"))
	}
	if v.PinVerificationKeyIndex == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PinVerificationKeyIndex"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDecryptDataInput(v *DecryptDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DecryptDataInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.CipherText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CipherText"))
	}
	if v.DecryptionAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DecryptionAttributes"))
	} else if v.DecryptionAttributes != nil {
		if err := validateEncryptionDecryptionAttributes(v.DecryptionAttributes); err != nil {
			invalidParams.AddNested("DecryptionAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpEncryptDataInput(v *EncryptDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptDataInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.PlainText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PlainText"))
	}
	if v.EncryptionAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionAttributes"))
	} else if v.EncryptionAttributes != nil {
		if err := validateEncryptionDecryptionAttributes(v.EncryptionAttributes); err != nil {
			invalidParams.AddNested("EncryptionAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateCardValidationDataInput(v *GenerateCardValidationDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateCardValidationDataInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.GenerationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GenerationAttributes"))
	} else if v.GenerationAttributes != nil {
		if err := validateCardGenerationAttributes(v.GenerationAttributes); err != nil {
			invalidParams.AddNested("GenerationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGenerateMacInput(v *GenerateMacInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GenerateMacInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.MessageData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MessageData"))
	}
	if v.GenerationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GenerationAttributes"))
	} else if v.GenerationAttributes != nil {
		if err := validateMacAttributes(v.GenerationAttributes); err != nil {
			invalidParams.AddNested("GenerationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGeneratePinDataInput(v *GeneratePinDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GeneratePinDataInput"}
	if v.GenerationKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GenerationKeyIdentifier"))
	}
	if v.EncryptionKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionKeyIdentifier"))
	}
	if v.GenerationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GenerationAttributes"))
	} else if v.GenerationAttributes != nil {
		if err := validatePinGenerationAttributes(v.GenerationAttributes); err != nil {
			invalidParams.AddNested("GenerationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if len(v.PinBlockFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PinBlockFormat"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpReEncryptDataInput(v *ReEncryptDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReEncryptDataInput"}
	if v.IncomingKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IncomingKeyIdentifier"))
	}
	if v.OutgoingKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutgoingKeyIdentifier"))
	}
	if v.CipherText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CipherText"))
	}
	if v.IncomingEncryptionAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IncomingEncryptionAttributes"))
	} else if v.IncomingEncryptionAttributes != nil {
		if err := validateReEncryptionAttributes(v.IncomingEncryptionAttributes); err != nil {
			invalidParams.AddNested("IncomingEncryptionAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutgoingEncryptionAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutgoingEncryptionAttributes"))
	} else if v.OutgoingEncryptionAttributes != nil {
		if err := validateReEncryptionAttributes(v.OutgoingEncryptionAttributes); err != nil {
			invalidParams.AddNested("OutgoingEncryptionAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTranslatePinDataInput(v *TranslatePinDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TranslatePinDataInput"}
	if v.IncomingKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IncomingKeyIdentifier"))
	}
	if v.OutgoingKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutgoingKeyIdentifier"))
	}
	if v.IncomingTranslationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IncomingTranslationAttributes"))
	} else if v.IncomingTranslationAttributes != nil {
		if err := validateTranslationIsoFormats(v.IncomingTranslationAttributes); err != nil {
			invalidParams.AddNested("IncomingTranslationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutgoingTranslationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("OutgoingTranslationAttributes"))
	} else if v.OutgoingTranslationAttributes != nil {
		if err := validateTranslationIsoFormats(v.OutgoingTranslationAttributes); err != nil {
			invalidParams.AddNested("OutgoingTranslationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptedPinBlock == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptedPinBlock"))
	}
	if v.IncomingDukptAttributes != nil {
		if err := validateDukptDerivationAttributes(v.IncomingDukptAttributes); err != nil {
			invalidParams.AddNested("IncomingDukptAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.OutgoingDukptAttributes != nil {
		if err := validateDukptDerivationAttributes(v.OutgoingDukptAttributes); err != nil {
			invalidParams.AddNested("OutgoingDukptAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpVerifyAuthRequestCryptogramInput(v *VerifyAuthRequestCryptogramInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerifyAuthRequestCryptogramInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.TransactionData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TransactionData"))
	}
	if v.AuthRequestCryptogram == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AuthRequestCryptogram"))
	}
	if len(v.MajorKeyDerivationMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("MajorKeyDerivationMode"))
	}
	if v.SessionKeyDerivationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionKeyDerivationAttributes"))
	} else if v.SessionKeyDerivationAttributes != nil {
		if err := validateSessionKeyDerivation(v.SessionKeyDerivationAttributes); err != nil {
			invalidParams.AddNested("SessionKeyDerivationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.AuthResponseAttributes != nil {
		if err := validateCryptogramAuthResponse(v.AuthResponseAttributes); err != nil {
			invalidParams.AddNested("AuthResponseAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpVerifyCardValidationDataInput(v *VerifyCardValidationDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerifyCardValidationDataInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if v.VerificationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VerificationAttributes"))
	} else if v.VerificationAttributes != nil {
		if err := validateCardVerificationAttributes(v.VerificationAttributes); err != nil {
			invalidParams.AddNested("VerificationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.ValidationData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ValidationData"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpVerifyMacInput(v *VerifyMacInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerifyMacInput"}
	if v.KeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyIdentifier"))
	}
	if v.MessageData == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MessageData"))
	}
	if v.Mac == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Mac"))
	}
	if v.VerificationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VerificationAttributes"))
	} else if v.VerificationAttributes != nil {
		if err := validateMacAttributes(v.VerificationAttributes); err != nil {
			invalidParams.AddNested("VerificationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpVerifyPinDataInput(v *VerifyPinDataInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VerifyPinDataInput"}
	if v.VerificationKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VerificationKeyIdentifier"))
	}
	if v.EncryptionKeyIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionKeyIdentifier"))
	}
	if v.VerificationAttributes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VerificationAttributes"))
	} else if v.VerificationAttributes != nil {
		if err := validatePinVerificationAttributes(v.VerificationAttributes); err != nil {
			invalidParams.AddNested("VerificationAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptedPinBlock == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptedPinBlock"))
	}
	if v.PrimaryAccountNumber == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrimaryAccountNumber"))
	}
	if len(v.PinBlockFormat) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("PinBlockFormat"))
	}
	if v.DukptAttributes != nil {
		if err := validateDukptAttributes(v.DukptAttributes); err != nil {
			invalidParams.AddNested("DukptAttributes", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
