// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/reach_plan_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [ReachForecastService.ListPlannableLocations][]
type ListPlannableLocationsRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPlannableLocationsRequest) Reset()         { *m = ListPlannableLocationsRequest{} }
func (m *ListPlannableLocationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlannableLocationsRequest) ProtoMessage()    {}
func (*ListPlannableLocationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{0}
}

func (m *ListPlannableLocationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableLocationsRequest.Unmarshal(m, b)
}
func (m *ListPlannableLocationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableLocationsRequest.Marshal(b, m, deterministic)
}
func (m *ListPlannableLocationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableLocationsRequest.Merge(m, src)
}
func (m *ListPlannableLocationsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPlannableLocationsRequest.Size(m)
}
func (m *ListPlannableLocationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableLocationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableLocationsRequest proto.InternalMessageInfo

// The list of plannable locations.
type ListPlannableLocationsResponse struct {
	// The list of locations available for planning (Countries, DMAs,
	// sub-countries).
	// For locations like Countries, DMAs see
	// https://developers.google.com/adwords/api/docs/appendix/geotargeting for
	// more information.
	PlannableLocations   []*PlannableLocation `protobuf:"bytes,1,rep,name=plannable_locations,json=plannableLocations,proto3" json:"plannable_locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ListPlannableLocationsResponse) Reset()         { *m = ListPlannableLocationsResponse{} }
func (m *ListPlannableLocationsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPlannableLocationsResponse) ProtoMessage()    {}
func (*ListPlannableLocationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{1}
}

func (m *ListPlannableLocationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableLocationsResponse.Unmarshal(m, b)
}
func (m *ListPlannableLocationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableLocationsResponse.Marshal(b, m, deterministic)
}
func (m *ListPlannableLocationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableLocationsResponse.Merge(m, src)
}
func (m *ListPlannableLocationsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPlannableLocationsResponse.Size(m)
}
func (m *ListPlannableLocationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableLocationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableLocationsResponse proto.InternalMessageInfo

func (m *ListPlannableLocationsResponse) GetPlannableLocations() []*PlannableLocation {
	if m != nil {
		return m.PlannableLocations
	}
	return nil
}

// A plannable location: a country, a DMA, a metro region, a tv region,
// a province.
type PlannableLocation struct {
	// The location identifier.
	Id *wrappers.StringValue `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The unique location name in english.
	Name *wrappers.StringValue `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The parent country code, not present if location is a country.
	// If present will always be a criterion id: additional information, such as
	// country name are returned both via ListPlannableLocations or directly by
	// accessing GeoTargetConstantService with the criterion id.
	ParentCountryId      *wrappers.Int64Value `protobuf:"bytes,3,opt,name=parent_country_id,json=parentCountryId,proto3" json:"parent_country_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannableLocation) Reset()         { *m = PlannableLocation{} }
func (m *PlannableLocation) String() string { return proto.CompactTextString(m) }
func (*PlannableLocation) ProtoMessage()    {}
func (*PlannableLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{2}
}

func (m *PlannableLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannableLocation.Unmarshal(m, b)
}
func (m *PlannableLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannableLocation.Marshal(b, m, deterministic)
}
func (m *PlannableLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannableLocation.Merge(m, src)
}
func (m *PlannableLocation) XXX_Size() int {
	return xxx_messageInfo_PlannableLocation.Size(m)
}
func (m *PlannableLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannableLocation.DiscardUnknown(m)
}

var xxx_messageInfo_PlannableLocation proto.InternalMessageInfo

func (m *PlannableLocation) GetId() *wrappers.StringValue {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *PlannableLocation) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *PlannableLocation) GetParentCountryId() *wrappers.Int64Value {
	if m != nil {
		return m.ParentCountryId
	}
	return nil
}

// Request to list available products in a given location.
type ListPlannableProductsRequest struct {
	// Required. The ID of the selected location for planning. To list the available
	// plannable location ids use ListPlannableLocations.
	PlannableLocationId  *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ListPlannableProductsRequest) Reset()         { *m = ListPlannableProductsRequest{} }
func (m *ListPlannableProductsRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlannableProductsRequest) ProtoMessage()    {}
func (*ListPlannableProductsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{3}
}

func (m *ListPlannableProductsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableProductsRequest.Unmarshal(m, b)
}
func (m *ListPlannableProductsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableProductsRequest.Marshal(b, m, deterministic)
}
func (m *ListPlannableProductsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableProductsRequest.Merge(m, src)
}
func (m *ListPlannableProductsRequest) XXX_Size() int {
	return xxx_messageInfo_ListPlannableProductsRequest.Size(m)
}
func (m *ListPlannableProductsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableProductsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableProductsRequest proto.InternalMessageInfo

func (m *ListPlannableProductsRequest) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

// A response with all available products.
type ListPlannableProductsResponse struct {
	// The list of products available for planning and related targeting metadata.
	ProductMetadata      []*ProductMetadata `protobuf:"bytes,1,rep,name=product_metadata,json=productMetadata,proto3" json:"product_metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ListPlannableProductsResponse) Reset()         { *m = ListPlannableProductsResponse{} }
func (m *ListPlannableProductsResponse) String() string { return proto.CompactTextString(m) }
func (*ListPlannableProductsResponse) ProtoMessage()    {}
func (*ListPlannableProductsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{4}
}

func (m *ListPlannableProductsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListPlannableProductsResponse.Unmarshal(m, b)
}
func (m *ListPlannableProductsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListPlannableProductsResponse.Marshal(b, m, deterministic)
}
func (m *ListPlannableProductsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlannableProductsResponse.Merge(m, src)
}
func (m *ListPlannableProductsResponse) XXX_Size() int {
	return xxx_messageInfo_ListPlannableProductsResponse.Size(m)
}
func (m *ListPlannableProductsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlannableProductsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlannableProductsResponse proto.InternalMessageInfo

func (m *ListPlannableProductsResponse) GetProductMetadata() []*ProductMetadata {
	if m != nil {
		return m.ProductMetadata
	}
	return nil
}

// The metadata associated with an available plannable product.
type ProductMetadata struct {
	// The code associated with the ad product. E.g. Trueview, Bumper
	// To list the available plannable product codes use ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The allowed plannable targeting for this product.
	PlannableTargeting   *PlannableTargeting `protobuf:"bytes,2,opt,name=plannable_targeting,json=plannableTargeting,proto3" json:"plannable_targeting,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ProductMetadata) Reset()         { *m = ProductMetadata{} }
func (m *ProductMetadata) String() string { return proto.CompactTextString(m) }
func (*ProductMetadata) ProtoMessage()    {}
func (*ProductMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{5}
}

func (m *ProductMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductMetadata.Unmarshal(m, b)
}
func (m *ProductMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductMetadata.Marshal(b, m, deterministic)
}
func (m *ProductMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductMetadata.Merge(m, src)
}
func (m *ProductMetadata) XXX_Size() int {
	return xxx_messageInfo_ProductMetadata.Size(m)
}
func (m *ProductMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ProductMetadata proto.InternalMessageInfo

func (m *ProductMetadata) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *ProductMetadata) GetPlannableTargeting() *PlannableTargeting {
	if m != nil {
		return m.PlannableTargeting
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type PlannableTargeting struct {
	// Allowed plannable age ranges for the product for which metrics will be
	// reported. Actual targeting is computed by mapping this age range onto
	// standard Google common.AgeRangeInfo values.
	AgeRanges []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,1,rep,packed,name=age_ranges,json=ageRanges,proto3,enum=google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_ranges,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,2,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices []*common.DeviceInfo `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	// Targetable networks for the ad product.
	Networks             []enums.ReachPlanNetworkEnum_ReachPlanNetwork `protobuf:"varint,4,rep,packed,name=networks,proto3,enum=google.ads.googleads.v3.enums.ReachPlanNetworkEnum_ReachPlanNetwork" json:"networks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *PlannableTargeting) Reset()         { *m = PlannableTargeting{} }
func (m *PlannableTargeting) String() string { return proto.CompactTextString(m) }
func (*PlannableTargeting) ProtoMessage()    {}
func (*PlannableTargeting) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{6}
}

func (m *PlannableTargeting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannableTargeting.Unmarshal(m, b)
}
func (m *PlannableTargeting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannableTargeting.Marshal(b, m, deterministic)
}
func (m *PlannableTargeting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannableTargeting.Merge(m, src)
}
func (m *PlannableTargeting) XXX_Size() int {
	return xxx_messageInfo_PlannableTargeting.Size(m)
}
func (m *PlannableTargeting) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannableTargeting.DiscardUnknown(m)
}

var xxx_messageInfo_PlannableTargeting proto.InternalMessageInfo

func (m *PlannableTargeting) GetAgeRanges() []enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if m != nil {
		return m.AgeRanges
	}
	return nil
}

func (m *PlannableTargeting) GetGenders() []*common.GenderInfo {
	if m != nil {
		return m.Genders
	}
	return nil
}

func (m *PlannableTargeting) GetDevices() []*common.DeviceInfo {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *PlannableTargeting) GetNetworks() []enums.ReachPlanNetworkEnum_ReachPlanNetwork {
	if m != nil {
		return m.Networks
	}
	return nil
}

// Request message for [ReachForecastService.GenerateProductMixIdeas][].
type GenerateProductMixIdeasRequest struct {
	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The ID of the location, this is one of the ids returned by
	// ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,2,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required. Currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,3,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Total budget.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros *wrappers.Int64Value `protobuf:"bytes,4,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	// The preferences of the suggested product mix.
	// An unset preference is interpreted as all possible values are allowed,
	// unless explicitly specified.
	Preferences          *Preferences `protobuf:"bytes,5,opt,name=preferences,proto3" json:"preferences,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GenerateProductMixIdeasRequest) Reset()         { *m = GenerateProductMixIdeasRequest{} }
func (m *GenerateProductMixIdeasRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateProductMixIdeasRequest) ProtoMessage()    {}
func (*GenerateProductMixIdeasRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{7}
}

func (m *GenerateProductMixIdeasRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Unmarshal(m, b)
}
func (m *GenerateProductMixIdeasRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Marshal(b, m, deterministic)
}
func (m *GenerateProductMixIdeasRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateProductMixIdeasRequest.Merge(m, src)
}
func (m *GenerateProductMixIdeasRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateProductMixIdeasRequest.Size(m)
}
func (m *GenerateProductMixIdeasRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateProductMixIdeasRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateProductMixIdeasRequest proto.InternalMessageInfo

func (m *GenerateProductMixIdeasRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GenerateProductMixIdeasRequest) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

func (m *GenerateProductMixIdeasRequest) GetPreferences() *Preferences {
	if m != nil {
		return m.Preferences
	}
	return nil
}

// Set of preferences about the planned mix.
type Preferences struct {
	// True if ad skippable.
	// If not set, default is any value.
	IsSkippable *wrappers.BoolValue `protobuf:"bytes,1,opt,name=is_skippable,json=isSkippable,proto3" json:"is_skippable,omitempty"`
	// True if ad start with sound.
	// If not set, default is any value.
	StartsWithSound *wrappers.BoolValue `protobuf:"bytes,2,opt,name=starts_with_sound,json=startsWithSound,proto3" json:"starts_with_sound,omitempty"`
	// The length of the ad.
	// If not set, default is any value.
	AdLength enums.ReachPlanAdLengthEnum_ReachPlanAdLength `protobuf:"varint,3,opt,name=ad_length,json=adLength,proto3,enum=google.ads.googleads.v3.enums.ReachPlanAdLengthEnum_ReachPlanAdLength" json:"ad_length,omitempty"`
	// True if ad will only show on the top content.
	// If not set, default is false.
	TopContentOnly *wrappers.BoolValue `protobuf:"bytes,4,opt,name=top_content_only,json=topContentOnly,proto3" json:"top_content_only,omitempty"`
	// True if the price guaranteed. The cost of serving the ad is agreed upfront
	// and not subject to an auction.
	// If not set, default is any value.
	HasGuaranteedPrice   *wrappers.BoolValue `protobuf:"bytes,5,opt,name=has_guaranteed_price,json=hasGuaranteedPrice,proto3" json:"has_guaranteed_price,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Preferences) Reset()         { *m = Preferences{} }
func (m *Preferences) String() string { return proto.CompactTextString(m) }
func (*Preferences) ProtoMessage()    {}
func (*Preferences) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{8}
}

func (m *Preferences) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Preferences.Unmarshal(m, b)
}
func (m *Preferences) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Preferences.Marshal(b, m, deterministic)
}
func (m *Preferences) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Preferences.Merge(m, src)
}
func (m *Preferences) XXX_Size() int {
	return xxx_messageInfo_Preferences.Size(m)
}
func (m *Preferences) XXX_DiscardUnknown() {
	xxx_messageInfo_Preferences.DiscardUnknown(m)
}

var xxx_messageInfo_Preferences proto.InternalMessageInfo

func (m *Preferences) GetIsSkippable() *wrappers.BoolValue {
	if m != nil {
		return m.IsSkippable
	}
	return nil
}

func (m *Preferences) GetStartsWithSound() *wrappers.BoolValue {
	if m != nil {
		return m.StartsWithSound
	}
	return nil
}

func (m *Preferences) GetAdLength() enums.ReachPlanAdLengthEnum_ReachPlanAdLength {
	if m != nil {
		return m.AdLength
	}
	return enums.ReachPlanAdLengthEnum_UNSPECIFIED
}

func (m *Preferences) GetTopContentOnly() *wrappers.BoolValue {
	if m != nil {
		return m.TopContentOnly
	}
	return nil
}

func (m *Preferences) GetHasGuaranteedPrice() *wrappers.BoolValue {
	if m != nil {
		return m.HasGuaranteedPrice
	}
	return nil
}

// The suggested product mix.
type GenerateProductMixIdeasResponse struct {
	// A list of products (ad formats) and the associated budget allocation idea.
	ProductAllocation    []*ProductAllocation `protobuf:"bytes,1,rep,name=product_allocation,json=productAllocation,proto3" json:"product_allocation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *GenerateProductMixIdeasResponse) Reset()         { *m = GenerateProductMixIdeasResponse{} }
func (m *GenerateProductMixIdeasResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateProductMixIdeasResponse) ProtoMessage()    {}
func (*GenerateProductMixIdeasResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{9}
}

func (m *GenerateProductMixIdeasResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Unmarshal(m, b)
}
func (m *GenerateProductMixIdeasResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Marshal(b, m, deterministic)
}
func (m *GenerateProductMixIdeasResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateProductMixIdeasResponse.Merge(m, src)
}
func (m *GenerateProductMixIdeasResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateProductMixIdeasResponse.Size(m)
}
func (m *GenerateProductMixIdeasResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateProductMixIdeasResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateProductMixIdeasResponse proto.InternalMessageInfo

func (m *GenerateProductMixIdeasResponse) GetProductAllocation() []*ProductAllocation {
	if m != nil {
		return m.ProductAllocation
	}
	return nil
}

// An allocation of a part of the budget on a given product.
type ProductAllocation struct {
	// Selected product for planning. The product codes returned are within the
	// set of the ones returned by ListPlannableProducts when using the same
	// location id.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// The value to be allocated for the suggested product in requested currency.
	// Amount in micros. One million is equivalent to one unit.
	BudgetMicros         *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ProductAllocation) Reset()         { *m = ProductAllocation{} }
func (m *ProductAllocation) String() string { return proto.CompactTextString(m) }
func (*ProductAllocation) ProtoMessage()    {}
func (*ProductAllocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{10}
}

func (m *ProductAllocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProductAllocation.Unmarshal(m, b)
}
func (m *ProductAllocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProductAllocation.Marshal(b, m, deterministic)
}
func (m *ProductAllocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProductAllocation.Merge(m, src)
}
func (m *ProductAllocation) XXX_Size() int {
	return xxx_messageInfo_ProductAllocation.Size(m)
}
func (m *ProductAllocation) XXX_DiscardUnknown() {
	xxx_messageInfo_ProductAllocation.DiscardUnknown(m)
}

var xxx_messageInfo_ProductAllocation proto.InternalMessageInfo

func (m *ProductAllocation) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *ProductAllocation) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

// Request message for [ReachPlanService.GenerateReachForecast][google.ads.googleads.v3.services.ReachPlanService.GenerateReachForecast].
type GenerateReachForecastRequest struct {
	// Required. The ID of the customer.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The currency code.
	// Three-character ISO 4217 currency code.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// Required. Campaign duration.
	CampaignDuration *CampaignDuration `protobuf:"bytes,3,opt,name=campaign_duration,json=campaignDuration,proto3" json:"campaign_duration,omitempty"`
	// Desired cookie frequency cap that will be applied to each planned product.
	// This is equivalent to the frequency cap exposed in Google Ads when creating
	// a campaign, it represents the maximum number of times an ad can be shown to
	// the same user.
	// If not specified no cap is applied.
	CookieFrequencyCap *wrappers.Int32Value `protobuf:"bytes,4,opt,name=cookie_frequency_cap,json=cookieFrequencyCap,proto3" json:"cookie_frequency_cap,omitempty"`
	// Desired minimum effective frequency (the number of times a person was
	// exposed to the ad) for the reported reach metrics [1-10].
	// This won't affect the targeting, but just the reporting.
	// If not specified, a default of 1 is applied.
	MinEffectiveFrequency *wrappers.Int32Value `protobuf:"bytes,5,opt,name=min_effective_frequency,json=minEffectiveFrequency,proto3" json:"min_effective_frequency,omitempty"`
	// The targeting to be applied to all products selected in the product mix.
	//
	// This is planned targeting: execution details might vary based on the
	// advertising product, please consult an implementation specialist.
	//
	// If no targeting dimensions are specified, then campaigns will target
	// everywhere and everyone.
	//
	// See specific metrics for details on how targeting affects them.
	//
	// In some cases, targeting may be overridden using the
	// PlannedProduct.advanced_product_targeting field.
	Targeting *Targeting `protobuf:"bytes,6,opt,name=targeting,proto3" json:"targeting,omitempty"`
	// Required. The product to be planned.
	PlannedProducts      []*PlannedProduct `protobuf:"bytes,7,rep,name=planned_products,json=plannedProducts,proto3" json:"planned_products,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *GenerateReachForecastRequest) Reset()         { *m = GenerateReachForecastRequest{} }
func (m *GenerateReachForecastRequest) String() string { return proto.CompactTextString(m) }
func (*GenerateReachForecastRequest) ProtoMessage()    {}
func (*GenerateReachForecastRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{11}
}

func (m *GenerateReachForecastRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateReachForecastRequest.Unmarshal(m, b)
}
func (m *GenerateReachForecastRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateReachForecastRequest.Marshal(b, m, deterministic)
}
func (m *GenerateReachForecastRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateReachForecastRequest.Merge(m, src)
}
func (m *GenerateReachForecastRequest) XXX_Size() int {
	return xxx_messageInfo_GenerateReachForecastRequest.Size(m)
}
func (m *GenerateReachForecastRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateReachForecastRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateReachForecastRequest proto.InternalMessageInfo

func (m *GenerateReachForecastRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *GenerateReachForecastRequest) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetCampaignDuration() *CampaignDuration {
	if m != nil {
		return m.CampaignDuration
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetCookieFrequencyCap() *wrappers.Int32Value {
	if m != nil {
		return m.CookieFrequencyCap
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetMinEffectiveFrequency() *wrappers.Int32Value {
	if m != nil {
		return m.MinEffectiveFrequency
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetTargeting() *Targeting {
	if m != nil {
		return m.Targeting
	}
	return nil
}

func (m *GenerateReachForecastRequest) GetPlannedProducts() []*PlannedProduct {
	if m != nil {
		return m.PlannedProducts
	}
	return nil
}

// The targeting for which traffic metrics will be reported.
type Targeting struct {
	// Required. The ID of the selected location.
	// Plannable locations ID can be obtained from ListPlannableLocations.
	PlannableLocationId *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_location_id,json=plannableLocationId,proto3" json:"plannable_location_id,omitempty"`
	// Required
	// Selected age range to be planned on.
	AgeRange enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange `protobuf:"varint,2,opt,name=age_range,json=ageRange,proto3,enum=google.ads.googleads.v3.enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange" json:"age_range,omitempty"`
	// Targetable genders for the ad product.
	Genders []*common.GenderInfo `protobuf:"bytes,3,rep,name=genders,proto3" json:"genders,omitempty"`
	// Targetable devices for the ad product.
	Devices []*common.DeviceInfo `protobuf:"bytes,4,rep,name=devices,proto3" json:"devices,omitempty"`
	// Targetable network for the ad product.
	Network              enums.ReachPlanNetworkEnum_ReachPlanNetwork `protobuf:"varint,5,opt,name=network,proto3,enum=google.ads.googleads.v3.enums.ReachPlanNetworkEnum_ReachPlanNetwork" json:"network,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *Targeting) Reset()         { *m = Targeting{} }
func (m *Targeting) String() string { return proto.CompactTextString(m) }
func (*Targeting) ProtoMessage()    {}
func (*Targeting) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{12}
}

func (m *Targeting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Targeting.Unmarshal(m, b)
}
func (m *Targeting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Targeting.Marshal(b, m, deterministic)
}
func (m *Targeting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Targeting.Merge(m, src)
}
func (m *Targeting) XXX_Size() int {
	return xxx_messageInfo_Targeting.Size(m)
}
func (m *Targeting) XXX_DiscardUnknown() {
	xxx_messageInfo_Targeting.DiscardUnknown(m)
}

var xxx_messageInfo_Targeting proto.InternalMessageInfo

func (m *Targeting) GetPlannableLocationId() *wrappers.StringValue {
	if m != nil {
		return m.PlannableLocationId
	}
	return nil
}

func (m *Targeting) GetAgeRange() enums.ReachPlanAgeRangeEnum_ReachPlanAgeRange {
	if m != nil {
		return m.AgeRange
	}
	return enums.ReachPlanAgeRangeEnum_UNSPECIFIED
}

func (m *Targeting) GetGenders() []*common.GenderInfo {
	if m != nil {
		return m.Genders
	}
	return nil
}

func (m *Targeting) GetDevices() []*common.DeviceInfo {
	if m != nil {
		return m.Devices
	}
	return nil
}

func (m *Targeting) GetNetwork() enums.ReachPlanNetworkEnum_ReachPlanNetwork {
	if m != nil {
		return m.Network
	}
	return enums.ReachPlanNetworkEnum_UNSPECIFIED
}

// The duration of a planned campaign.
type CampaignDuration struct {
	// The duration value in days.
	DurationInDays       *wrappers.Int32Value `protobuf:"bytes,1,opt,name=duration_in_days,json=durationInDays,proto3" json:"duration_in_days,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CampaignDuration) Reset()         { *m = CampaignDuration{} }
func (m *CampaignDuration) String() string { return proto.CompactTextString(m) }
func (*CampaignDuration) ProtoMessage()    {}
func (*CampaignDuration) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{13}
}

func (m *CampaignDuration) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CampaignDuration.Unmarshal(m, b)
}
func (m *CampaignDuration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CampaignDuration.Marshal(b, m, deterministic)
}
func (m *CampaignDuration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CampaignDuration.Merge(m, src)
}
func (m *CampaignDuration) XXX_Size() int {
	return xxx_messageInfo_CampaignDuration.Size(m)
}
func (m *CampaignDuration) XXX_DiscardUnknown() {
	xxx_messageInfo_CampaignDuration.DiscardUnknown(m)
}

var xxx_messageInfo_CampaignDuration proto.InternalMessageInfo

func (m *CampaignDuration) GetDurationInDays() *wrappers.Int32Value {
	if m != nil {
		return m.DurationInDays
	}
	return nil
}

// A product being planned for reach.
type PlannedProduct struct {
	// Required. Selected product for planning.
	// Plannable products codes can be obtained from ListPlannableProducts.
	PlannableProductCode *wrappers.StringValue `protobuf:"bytes,1,opt,name=plannable_product_code,json=plannableProductCode,proto3" json:"plannable_product_code,omitempty"`
	// Required. Maximum budget allocation in micros for the selected product.
	// The value is specified in the selected planning currency_code.
	// E.g. 1 000 000$ = 1 000 000 000 000 micros.
	BudgetMicros         *wrappers.Int64Value `protobuf:"bytes,2,opt,name=budget_micros,json=budgetMicros,proto3" json:"budget_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PlannedProduct) Reset()         { *m = PlannedProduct{} }
func (m *PlannedProduct) String() string { return proto.CompactTextString(m) }
func (*PlannedProduct) ProtoMessage()    {}
func (*PlannedProduct) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{14}
}

func (m *PlannedProduct) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PlannedProduct.Unmarshal(m, b)
}
func (m *PlannedProduct) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PlannedProduct.Marshal(b, m, deterministic)
}
func (m *PlannedProduct) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlannedProduct.Merge(m, src)
}
func (m *PlannedProduct) XXX_Size() int {
	return xxx_messageInfo_PlannedProduct.Size(m)
}
func (m *PlannedProduct) XXX_DiscardUnknown() {
	xxx_messageInfo_PlannedProduct.DiscardUnknown(m)
}

var xxx_messageInfo_PlannedProduct proto.InternalMessageInfo

func (m *PlannedProduct) GetPlannableProductCode() *wrappers.StringValue {
	if m != nil {
		return m.PlannableProductCode
	}
	return nil
}

func (m *PlannedProduct) GetBudgetMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetMicros
	}
	return nil
}

// Response message containing the generated reach curve.
type GenerateReachForecastResponse struct {
	// Reference on target audiences for this curve.
	OnTargetAudienceMetrics *OnTargetAudienceMetrics `protobuf:"bytes,1,opt,name=on_target_audience_metrics,json=onTargetAudienceMetrics,proto3" json:"on_target_audience_metrics,omitempty"`
	// The generated reach curve for the planned product mix.
	ReachCurve           *ReachCurve `protobuf:"bytes,2,opt,name=reach_curve,json=reachCurve,proto3" json:"reach_curve,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GenerateReachForecastResponse) Reset()         { *m = GenerateReachForecastResponse{} }
func (m *GenerateReachForecastResponse) String() string { return proto.CompactTextString(m) }
func (*GenerateReachForecastResponse) ProtoMessage()    {}
func (*GenerateReachForecastResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{15}
}

func (m *GenerateReachForecastResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GenerateReachForecastResponse.Unmarshal(m, b)
}
func (m *GenerateReachForecastResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GenerateReachForecastResponse.Marshal(b, m, deterministic)
}
func (m *GenerateReachForecastResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GenerateReachForecastResponse.Merge(m, src)
}
func (m *GenerateReachForecastResponse) XXX_Size() int {
	return xxx_messageInfo_GenerateReachForecastResponse.Size(m)
}
func (m *GenerateReachForecastResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GenerateReachForecastResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GenerateReachForecastResponse proto.InternalMessageInfo

func (m *GenerateReachForecastResponse) GetOnTargetAudienceMetrics() *OnTargetAudienceMetrics {
	if m != nil {
		return m.OnTargetAudienceMetrics
	}
	return nil
}

func (m *GenerateReachForecastResponse) GetReachCurve() *ReachCurve {
	if m != nil {
		return m.ReachCurve
	}
	return nil
}

// The reach curve for the planned products.
type ReachCurve struct {
	// All points on the reach curve.
	ReachForecasts       []*ReachForecast `protobuf:"bytes,1,rep,name=reach_forecasts,json=reachForecasts,proto3" json:"reach_forecasts,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReachCurve) Reset()         { *m = ReachCurve{} }
func (m *ReachCurve) String() string { return proto.CompactTextString(m) }
func (*ReachCurve) ProtoMessage()    {}
func (*ReachCurve) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{16}
}

func (m *ReachCurve) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReachCurve.Unmarshal(m, b)
}
func (m *ReachCurve) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReachCurve.Marshal(b, m, deterministic)
}
func (m *ReachCurve) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReachCurve.Merge(m, src)
}
func (m *ReachCurve) XXX_Size() int {
	return xxx_messageInfo_ReachCurve.Size(m)
}
func (m *ReachCurve) XXX_DiscardUnknown() {
	xxx_messageInfo_ReachCurve.DiscardUnknown(m)
}

var xxx_messageInfo_ReachCurve proto.InternalMessageInfo

func (m *ReachCurve) GetReachForecasts() []*ReachForecast {
	if m != nil {
		return m.ReachForecasts
	}
	return nil
}

// A point on reach curve.
type ReachForecast struct {
	// The cost in micros.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Forecasted traffic metrics for this point.
	Forecast *Forecast `protobuf:"bytes,2,opt,name=forecast,proto3" json:"forecast,omitempty"`
	// The forecasted allocation. This differs from the input allocation if one
	// or more product cannot fulfill the budget because of limited inventory.
	ForecastedProductAllocations []*ProductAllocation `protobuf:"bytes,3,rep,name=forecasted_product_allocations,json=forecastedProductAllocations,proto3" json:"forecasted_product_allocations,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}             `json:"-"`
	XXX_unrecognized             []byte               `json:"-"`
	XXX_sizecache                int32                `json:"-"`
}

func (m *ReachForecast) Reset()         { *m = ReachForecast{} }
func (m *ReachForecast) String() string { return proto.CompactTextString(m) }
func (*ReachForecast) ProtoMessage()    {}
func (*ReachForecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{17}
}

func (m *ReachForecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReachForecast.Unmarshal(m, b)
}
func (m *ReachForecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReachForecast.Marshal(b, m, deterministic)
}
func (m *ReachForecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReachForecast.Merge(m, src)
}
func (m *ReachForecast) XXX_Size() int {
	return xxx_messageInfo_ReachForecast.Size(m)
}
func (m *ReachForecast) XXX_DiscardUnknown() {
	xxx_messageInfo_ReachForecast.DiscardUnknown(m)
}

var xxx_messageInfo_ReachForecast proto.InternalMessageInfo

func (m *ReachForecast) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *ReachForecast) GetForecast() *Forecast {
	if m != nil {
		return m.Forecast
	}
	return nil
}

func (m *ReachForecast) GetForecastedProductAllocations() []*ProductAllocation {
	if m != nil {
		return m.ForecastedProductAllocations
	}
	return nil
}

// Forecasted traffic metrics for the planned products and targeting.
type Forecast struct {
	// Number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times that exactly
	// matches the Targeting.
	OnTargetReach *wrappers.Int64Value `protobuf:"bytes,1,opt,name=on_target_reach,json=onTargetReach,proto3" json:"on_target_reach,omitempty"`
	// Total number of unique people reached at least
	// GenerateReachForecastRequest.min_effective_frequency times. This includes
	// people that may fall outside the specified Targeting.
	TotalReach *wrappers.Int64Value `protobuf:"bytes,2,opt,name=total_reach,json=totalReach,proto3" json:"total_reach,omitempty"`
	// Number of ad impressions that exactly matches the Targeting.
	OnTargetImpressions *wrappers.Int64Value `protobuf:"bytes,3,opt,name=on_target_impressions,json=onTargetImpressions,proto3" json:"on_target_impressions,omitempty"`
	// Total number of ad impressions. This includes impressions that may fall
	// outside the specified Targeting, due to insufficent information on
	// signed-in users.
	TotalImpressions     *wrappers.Int64Value `protobuf:"bytes,4,opt,name=total_impressions,json=totalImpressions,proto3" json:"total_impressions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Forecast) Reset()         { *m = Forecast{} }
func (m *Forecast) String() string { return proto.CompactTextString(m) }
func (*Forecast) ProtoMessage()    {}
func (*Forecast) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{18}
}

func (m *Forecast) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Forecast.Unmarshal(m, b)
}
func (m *Forecast) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Forecast.Marshal(b, m, deterministic)
}
func (m *Forecast) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Forecast.Merge(m, src)
}
func (m *Forecast) XXX_Size() int {
	return xxx_messageInfo_Forecast.Size(m)
}
func (m *Forecast) XXX_DiscardUnknown() {
	xxx_messageInfo_Forecast.DiscardUnknown(m)
}

var xxx_messageInfo_Forecast proto.InternalMessageInfo

func (m *Forecast) GetOnTargetReach() *wrappers.Int64Value {
	if m != nil {
		return m.OnTargetReach
	}
	return nil
}

func (m *Forecast) GetTotalReach() *wrappers.Int64Value {
	if m != nil {
		return m.TotalReach
	}
	return nil
}

func (m *Forecast) GetOnTargetImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.OnTargetImpressions
	}
	return nil
}

func (m *Forecast) GetTotalImpressions() *wrappers.Int64Value {
	if m != nil {
		return m.TotalImpressions
	}
	return nil
}

// Audience metrics for the planned products.
// These metrics consider the following targeting dimensions:
//
// - Location
// - PlannableAgeRange
// - Gender
type OnTargetAudienceMetrics struct {
	// Reference audience size matching the considered targeting for YouTube.
	YoutubeAudienceSize *wrappers.Int64Value `protobuf:"bytes,1,opt,name=youtube_audience_size,json=youtubeAudienceSize,proto3" json:"youtube_audience_size,omitempty"`
	// Reference audience size matching the considered targeting for Census.
	CensusAudienceSize   *wrappers.Int64Value `protobuf:"bytes,2,opt,name=census_audience_size,json=censusAudienceSize,proto3" json:"census_audience_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OnTargetAudienceMetrics) Reset()         { *m = OnTargetAudienceMetrics{} }
func (m *OnTargetAudienceMetrics) String() string { return proto.CompactTextString(m) }
func (*OnTargetAudienceMetrics) ProtoMessage()    {}
func (*OnTargetAudienceMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_d80b4ff3bff090d4, []int{19}
}

func (m *OnTargetAudienceMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OnTargetAudienceMetrics.Unmarshal(m, b)
}
func (m *OnTargetAudienceMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OnTargetAudienceMetrics.Marshal(b, m, deterministic)
}
func (m *OnTargetAudienceMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OnTargetAudienceMetrics.Merge(m, src)
}
func (m *OnTargetAudienceMetrics) XXX_Size() int {
	return xxx_messageInfo_OnTargetAudienceMetrics.Size(m)
}
func (m *OnTargetAudienceMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_OnTargetAudienceMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_OnTargetAudienceMetrics proto.InternalMessageInfo

func (m *OnTargetAudienceMetrics) GetYoutubeAudienceSize() *wrappers.Int64Value {
	if m != nil {
		return m.YoutubeAudienceSize
	}
	return nil
}

func (m *OnTargetAudienceMetrics) GetCensusAudienceSize() *wrappers.Int64Value {
	if m != nil {
		return m.CensusAudienceSize
	}
	return nil
}

func init() {
	proto.RegisterType((*ListPlannableLocationsRequest)(nil), "google.ads.googleads.v3.services.ListPlannableLocationsRequest")
	proto.RegisterType((*ListPlannableLocationsResponse)(nil), "google.ads.googleads.v3.services.ListPlannableLocationsResponse")
	proto.RegisterType((*PlannableLocation)(nil), "google.ads.googleads.v3.services.PlannableLocation")
	proto.RegisterType((*ListPlannableProductsRequest)(nil), "google.ads.googleads.v3.services.ListPlannableProductsRequest")
	proto.RegisterType((*ListPlannableProductsResponse)(nil), "google.ads.googleads.v3.services.ListPlannableProductsResponse")
	proto.RegisterType((*ProductMetadata)(nil), "google.ads.googleads.v3.services.ProductMetadata")
	proto.RegisterType((*PlannableTargeting)(nil), "google.ads.googleads.v3.services.PlannableTargeting")
	proto.RegisterType((*GenerateProductMixIdeasRequest)(nil), "google.ads.googleads.v3.services.GenerateProductMixIdeasRequest")
	proto.RegisterType((*Preferences)(nil), "google.ads.googleads.v3.services.Preferences")
	proto.RegisterType((*GenerateProductMixIdeasResponse)(nil), "google.ads.googleads.v3.services.GenerateProductMixIdeasResponse")
	proto.RegisterType((*ProductAllocation)(nil), "google.ads.googleads.v3.services.ProductAllocation")
	proto.RegisterType((*GenerateReachForecastRequest)(nil), "google.ads.googleads.v3.services.GenerateReachForecastRequest")
	proto.RegisterType((*Targeting)(nil), "google.ads.googleads.v3.services.Targeting")
	proto.RegisterType((*CampaignDuration)(nil), "google.ads.googleads.v3.services.CampaignDuration")
	proto.RegisterType((*PlannedProduct)(nil), "google.ads.googleads.v3.services.PlannedProduct")
	proto.RegisterType((*GenerateReachForecastResponse)(nil), "google.ads.googleads.v3.services.GenerateReachForecastResponse")
	proto.RegisterType((*ReachCurve)(nil), "google.ads.googleads.v3.services.ReachCurve")
	proto.RegisterType((*ReachForecast)(nil), "google.ads.googleads.v3.services.ReachForecast")
	proto.RegisterType((*Forecast)(nil), "google.ads.googleads.v3.services.Forecast")
	proto.RegisterType((*OnTargetAudienceMetrics)(nil), "google.ads.googleads.v3.services.OnTargetAudienceMetrics")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/reach_plan_service.proto", fileDescriptor_d80b4ff3bff090d4)
}

var fileDescriptor_d80b4ff3bff090d4 = []byte{
	// 1769 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0xcb, 0x6f, 0x24, 0x47,
	0x19, 0x57, 0xf7, 0x2c, 0x59, 0xbb, 0x9c, 0xf5, 0xa3, 0x76, 0x1d, 0x0f, 0x13, 0xc7, 0xbb, 0x6a,
	0x2d, 0x52, 0x64, 0x9c, 0x99, 0xe0, 0x09, 0x51, 0x32, 0x64, 0x49, 0x66, 0xed, 0xb5, 0x33, 0xd2,
	0x9a, 0xb5, 0xda, 0xb0, 0x3c, 0x64, 0xd1, 0x29, 0x77, 0xd7, 0xb4, 0x4b, 0x3b, 0x53, 0xd5, 0x54,
	0x55, 0x7b, 0x99, 0xa0, 0x48, 0x08, 0x09, 0x24, 0x0e, 0x48, 0x48, 0xfc, 0x05, 0x70, 0x40, 0xc0,
	0x81, 0x3b, 0x12, 0xe2, 0xc0, 0x31, 0xe2, 0x86, 0xc4, 0x61, 0x4f, 0x1c, 0x10, 0x12, 0xfc, 0x0d,
	0x44, 0x42, 0x5d, 0x8f, 0x9e, 0xf7, 0x4c, 0xdb, 0xbb, 0x48, 0xdc, 0xca, 0x55, 0xdf, 0xef, 0x57,
	0xf5, 0xbd, 0xbf, 0x1e, 0x83, 0x77, 0x63, 0xc6, 0xe2, 0x0e, 0xae, 0xa1, 0x48, 0xd4, 0xf4, 0x32,
	0x5b, 0x5d, 0xd4, 0x6b, 0x02, 0xf3, 0x0b, 0x12, 0x62, 0x51, 0xe3, 0x18, 0x85, 0xe7, 0x41, 0xd2,
	0x41, 0x34, 0x30, 0x7b, 0xd5, 0x84, 0x33, 0xc9, 0xe0, 0x1d, 0x2d, 0x5f, 0x45, 0x91, 0xa8, 0xe6,
	0xd0, 0xea, 0x45, 0xbd, 0x6a, 0xa1, 0x95, 0x37, 0xa6, 0x91, 0x87, 0xac, 0xdb, 0x65, 0xb4, 0x16,
	0x72, 0x22, 0x31, 0x27, 0x48, 0x13, 0x56, 0xde, 0x99, 0x26, 0x8e, 0x69, 0xda, 0x1d, 0x7a, 0x08,
	0x8a, 0x82, 0x0e, 0xa6, 0xb1, 0x3c, 0xbf, 0x3c, 0x32, 0xc6, 0x01, 0x47, 0x34, 0x36, 0x4a, 0x54,
	0xde, 0x2e, 0x8c, 0xa4, 0x58, 0x3e, 0x65, 0xfc, 0x89, 0xc1, 0x6d, 0x5a, 0x5c, 0x42, 0x6a, 0x88,
	0x52, 0x26, 0x91, 0x24, 0x8c, 0x0a, 0x73, 0xba, 0x31, 0x70, 0x1a, 0x76, 0x08, 0xa6, 0xd2, 0x1c,
	0xdc, 0x1e, 0x38, 0x68, 0x13, 0xdc, 0x89, 0x82, 0x33, 0x7c, 0x8e, 0x2e, 0x08, 0xe3, 0x46, 0x60,
	0xcb, 0x08, 0xa8, 0xbf, 0xce, 0xd2, 0x76, 0xed, 0x29, 0x47, 0x49, 0x82, 0xb9, 0x61, 0xf6, 0x6e,
	0x83, 0xd7, 0x1e, 0x12, 0x21, 0x8f, 0x3b, 0x88, 0x52, 0x74, 0xd6, 0xc1, 0x0f, 0x59, 0xa8, 0x6f,
	0xf6, 0xf1, 0xf7, 0x52, 0x2c, 0xa4, 0xf7, 0x13, 0x07, 0x6c, 0x4d, 0x93, 0x10, 0x09, 0xa3, 0x02,
	0xc3, 0x08, 0xdc, 0x4c, 0xec, 0x69, 0xd0, 0xb1, 0xc7, 0x65, 0xe7, 0x4e, 0xe9, 0xf5, 0xa5, 0xdd,
	0x7a, 0x75, 0x9e, 0x5b, 0xab, 0x63, 0xd4, 0x3e, 0x4c, 0xc6, 0x6e, 0xf3, 0xfe, 0xe8, 0x80, 0xb5,
	0x31, 0x49, 0xb8, 0x03, 0x5c, 0x12, 0x95, 0x9d, 0x3b, 0xce, 0xeb, 0x4b, 0xbb, 0x9b, 0xf6, 0x2a,
	0xab, 0x6c, 0xf5, 0x44, 0x72, 0x42, 0xe3, 0xc7, 0xa8, 0x93, 0x62, 0xdf, 0x25, 0x11, 0x7c, 0x13,
	0x5c, 0xa3, 0xa8, 0x8b, 0xcb, 0x6e, 0x01, 0x79, 0x25, 0x09, 0x0f, 0xc1, 0x5a, 0x82, 0x38, 0xa6,
	0x32, 0x08, 0x59, 0x4a, 0x25, 0xef, 0x05, 0x24, 0x2a, 0x97, 0x14, 0xfc, 0xd5, 0x31, 0x78, 0x8b,
	0xca, 0xb7, 0xdf, 0xd2, 0xe8, 0x15, 0x8d, 0xda, 0xd3, 0xa0, 0x56, 0xe4, 0xa5, 0x60, 0x73, 0xc8,
	0x8c, 0xc7, 0x9c, 0x45, 0x69, 0x28, 0xad, 0x9d, 0xe1, 0x37, 0xc0, 0xfa, 0xb8, 0x11, 0x83, 0x62,
	0xba, 0xdd, 0x2f, 0xfd, 0xbd, 0xe9, 0xfa, 0x37, 0xc7, 0x8c, 0xd6, 0x8a, 0xbc, 0x4f, 0x46, 0xfc,
	0xdb, 0xbf, 0xd6, 0x38, 0xef, 0x14, 0xac, 0x26, 0x7a, 0x2f, 0xe8, 0x62, 0x89, 0x22, 0x24, 0x91,
	0xf1, 0xdc, 0x97, 0x0a, 0x78, 0x4e, 0x23, 0x8f, 0x0c, 0xd0, 0x5f, 0x49, 0x86, 0x37, 0xbc, 0xbf,
	0x38, 0x60, 0x65, 0x44, 0x08, 0xfa, 0xe0, 0x95, 0xbe, 0xa6, 0xf6, 0xee, 0x90, 0x45, 0xb8, 0x90,
	0x1b, 0x6f, 0x25, 0x23, 0xaa, 0xec, 0xb1, 0x08, 0x43, 0x3c, 0x18, 0x82, 0x12, 0xf1, 0x18, 0x4b,
	0x42, 0x63, 0xe3, 0xe7, 0xb7, 0x2e, 0x11, 0x82, 0x5f, 0xb7, 0xd8, 0x81, 0x18, 0xcc, 0xf7, 0xbc,
	0x7f, 0xb9, 0x00, 0x8e, 0x8b, 0x42, 0x0c, 0x40, 0x5e, 0x07, 0x74, 0xdc, 0x2f, 0xef, 0x1e, 0x4c,
	0xbd, 0x54, 0x55, 0x82, 0xaa, 0x9f, 0x55, 0x82, 0x8c, 0xab, 0x19, 0x63, 0x3f, 0x03, 0x3e, 0xa0,
	0x69, 0x77, 0x7c, 0xd7, 0x5f, 0x44, 0x66, 0x25, 0xe0, 0x3e, 0xb8, 0x1e, 0x63, 0x1a, 0x61, 0x2e,
	0xca, 0xae, 0xf2, 0xd0, 0xf6, 0xd4, 0x3b, 0x74, 0x41, 0xac, 0x1e, 0x2a, 0xf1, 0x16, 0x6d, 0x33,
	0xdf, 0x42, 0x33, 0x96, 0x08, 0x2b, 0xad, 0xcb, 0xa5, 0x62, 0x2c, 0xfb, 0x4a, 0x5c, 0xb3, 0x18,
	0x28, 0xfc, 0x08, 0x2c, 0x98, 0x02, 0x26, 0xca, 0xd7, 0x94, 0xc2, 0xfb, 0x45, 0x15, 0xfe, 0x9a,
	0xc6, 0x0d, 0xeb, 0x6b, 0x36, 0xfd, 0x9c, 0xd5, 0xfb, 0xcc, 0x05, 0x5b, 0x87, 0x98, 0x62, 0x8e,
	0xa4, 0x75, 0xf5, 0x11, 0xf9, 0x7e, 0x2b, 0xc2, 0x28, 0xcf, 0x99, 0xbb, 0x60, 0x29, 0x4c, 0x85,
	0x64, 0x5d, 0xcc, 0x6d, 0xa6, 0x2c, 0xea, 0x5c, 0x00, 0x76, 0xbf, 0x15, 0x4d, 0xcf, 0x2c, 0xf7,
	0x79, 0x32, 0x0b, 0x1e, 0x80, 0x1b, 0x61, 0xca, 0x39, 0xa6, 0x61, 0x4f, 0x47, 0x6f, 0xa9, 0x28,
	0xdd, 0xcb, 0x16, 0xa7, 0x42, 0xf7, 0x01, 0xb8, 0x71, 0x96, 0x46, 0x31, 0x96, 0x41, 0x97, 0x84,
	0x9c, 0x65, 0xe6, 0x9c, 0x57, 0x5d, 0x0c, 0x8d, 0x86, 0x1d, 0x29, 0x14, 0x7c, 0x04, 0x96, 0x12,
	0x8e, 0xdb, 0x38, 0x23, 0xc6, 0xa2, 0xfc, 0x39, 0x45, 0xf2, 0x46, 0x91, 0x14, 0xce, 0x41, 0xfe,
	0x20, 0x83, 0xf7, 0xb3, 0x12, 0x58, 0x1a, 0x38, 0x84, 0xf7, 0xc0, 0xcb, 0x44, 0x04, 0xe2, 0x09,
	0x49, 0x92, 0xcc, 0x12, 0x26, 0x59, 0x2b, 0x63, 0xcf, 0xbc, 0xcf, 0x58, 0x47, 0xa7, 0xea, 0x12,
	0x11, 0x27, 0x56, 0x1c, 0x1e, 0x80, 0x35, 0x21, 0x11, 0x97, 0x22, 0x78, 0x4a, 0xe4, 0x79, 0x20,
	0x58, 0x4a, 0xad, 0x07, 0x66, 0x71, 0xac, 0x68, 0xd0, 0x37, 0x89, 0x3c, 0x3f, 0xc9, 0x20, 0x30,
	0x04, 0x8b, 0x79, 0xb7, 0x56, 0x26, 0xbf, 0x4c, 0xaa, 0x45, 0x0f, 0x15, 0x6e, 0x24, 0xd5, 0xcc,
	0xae, 0xbf, 0x80, 0xcc, 0x0a, 0xee, 0x83, 0x55, 0xc9, 0x92, 0x20, 0x64, 0x54, 0x66, 0xa5, 0x9f,
	0xd1, 0x4e, 0xcf, 0xb8, 0x65, 0xd6, 0x5b, 0x97, 0x25, 0x4b, 0xf6, 0x34, 0xe4, 0x11, 0xed, 0xf4,
	0xe0, 0x43, 0x70, 0xeb, 0x1c, 0x89, 0x20, 0x4e, 0x11, 0x47, 0x54, 0x62, 0x1c, 0x05, 0x09, 0x27,
	0x21, 0x36, 0xbe, 0x99, 0xc5, 0x04, 0xcf, 0x91, 0x38, 0xcc, 0x61, 0xc7, 0x19, 0xca, 0xfb, 0xb1,
	0x03, 0x6e, 0x4f, 0xcd, 0x07, 0x53, 0xcc, 0xcf, 0x00, 0xb4, 0x05, 0x15, 0x75, 0x6c, 0xa8, 0x5f,
	0xa2, 0x11, 0x6b, 0x6c, 0x33, 0x87, 0xfa, 0x6b, 0xc9, 0xe8, 0x96, 0xf7, 0xdb, 0xac, 0x0f, 0x8f,
	0xee, 0xfe, 0x4f, 0x8a, 0xfa, 0x07, 0xa3, 0x99, 0xe1, 0xce, 0xef, 0xbb, 0x43, 0x49, 0xe1, 0xfd,
	0xe9, 0x1a, 0xd8, 0xb4, 0x36, 0x53, 0xfe, 0x3e, 0x60, 0x1c, 0x87, 0x48, 0xc8, 0xcb, 0x55, 0x90,
	0xe6, 0x68, 0xaa, 0x17, 0x99, 0x1f, 0x86, 0xb3, 0x3c, 0x02, 0x6b, 0x21, 0xea, 0x26, 0x88, 0xc4,
	0x34, 0x88, 0x52, 0xae, 0x1d, 0xa3, 0x2b, 0xc6, 0xee, 0x7c, 0xc7, 0xec, 0x19, 0xe8, 0xbe, 0x41,
	0xea, 0x27, 0xae, 0x86, 0x23, 0xdb, 0xf0, 0x08, 0xdc, 0x0a, 0x19, 0x7b, 0x42, 0x70, 0xd0, 0xe6,
	0x99, 0x86, 0xea, 0xc1, 0x28, 0x99, 0x55, 0x52, 0xea, 0xbb, 0x26, 0xe4, 0x34, 0xf0, 0xc0, 0xe2,
	0xf6, 0x50, 0x02, 0x4f, 0xc0, 0x46, 0x97, 0xd0, 0x00, 0xb7, 0xdb, 0x38, 0x94, 0xe4, 0x62, 0x80,
	0xd5, 0xc4, 0xf0, 0x4c, 0xc6, 0xf5, 0x2e, 0xa1, 0x0f, 0x2c, 0x34, 0xe7, 0x85, 0x2d, 0xb0, 0xd8,
	0x6f, 0xd0, 0x2f, 0x29, 0x9a, 0x2f, 0xce, 0xb7, 0x40, 0xbf, 0x2f, 0xf7, 0xd1, 0xf0, 0x23, 0xb0,
	0xaa, 0x02, 0x47, 0x65, 0x96, 0x9e, 0x6b, 0xca, 0xd7, 0x55, 0xb0, 0xbf, 0x59, 0xb0, 0xe5, 0x67,
	0xc9, 0xa5, 0x80, 0xda, 0xa2, 0x2b, 0xc9, 0xd0, 0xa6, 0xf0, 0x7e, 0x5f, 0x02, 0x8b, 0xfd, 0x3e,
	0x7f, 0xfc, 0x1c, 0x33, 0xda, 0xe4, 0x26, 0x92, 0x55, 0x33, 0x3b, 0x39, 0xa8, 0xa8, 0x7a, 0x71,
	0x83, 0xc3, 0x82, 0x1d, 0x1c, 0x06, 0xe7, 0x86, 0xd2, 0x0b, 0x99, 0x1b, 0xae, 0x5d, 0x7d, 0x6e,
	0xf8, 0x2e, 0xb8, 0x6e, 0x3a, 0xbc, 0x0a, 0xa1, 0x17, 0x35, 0x36, 0x58, 0x52, 0xef, 0xdb, 0x60,
	0x75, 0x34, 0x59, 0xe0, 0x03, 0xb0, 0x6a, 0x53, 0x2e, 0x20, 0x34, 0x88, 0x50, 0x4f, 0x18, 0x8f,
	0xcd, 0x8c, 0xdf, 0x65, 0x0b, 0x6a, 0xd1, 0x7d, 0xd4, 0x13, 0xde, 0xaf, 0x1d, 0xb0, 0x3c, 0x1c,
	0x34, 0xff, 0xa7, 0x55, 0xef, 0x9f, 0x0e, 0x78, 0x6d, 0x4a, 0xd5, 0x33, 0x7d, 0xe2, 0x02, 0x54,
	0x18, 0x35, 0x73, 0x72, 0x80, 0xd2, 0x88, 0x64, 0x2d, 0x3e, 0x9b, 0xff, 0x39, 0x09, 0xad, 0x6d,
	0xde, 0x9d, 0x9f, 0x42, 0x8f, 0xa8, 0xce, 0x8d, 0xa6, 0x61, 0x38, 0xd2, 0x04, 0xfe, 0x06, 0x9b,
	0x7c, 0x00, 0x8f, 0xc0, 0x92, 0xfe, 0x02, 0x0e, 0x53, 0x7e, 0x61, 0xcb, 0xe8, 0xce, 0xfc, 0x8b,
	0x94, 0x16, 0x7b, 0x19, 0xc6, 0x07, 0x3c, 0x5f, 0x7b, 0x6d, 0x00, 0xfa, 0x27, 0xf0, 0x5b, 0x60,
	0x45, 0x93, 0xb7, 0x8d, 0xba, 0xf6, 0x13, 0xb4, 0x56, 0xf0, 0x82, 0xdc, 0x4c, 0xcb, 0x7c, 0xf0,
	0x4f, 0xe1, 0xfd, 0xdc, 0x05, 0x37, 0x86, 0x24, 0xe0, 0x7b, 0x60, 0x29, 0x64, 0x22, 0x77, 0x91,
	0x33, 0xdf, 0x45, 0x20, 0x93, 0x37, 0xb3, 0xda, 0x01, 0x58, 0xb0, 0x6f, 0x34, 0x36, 0xd8, 0x9e,
	0xff, 0xc4, 0xfc, 0x75, 0x39, 0x16, 0xf6, 0xc0, 0x96, 0x5d, 0xf7, 0x4b, 0xe0, 0x40, 0xe7, 0xb7,
	0xf9, 0x7e, 0xa5, 0xd6, 0xbf, 0xd9, 0xa7, 0x1e, 0x3b, 0x14, 0xde, 0x6f, 0x5c, 0xb0, 0x90, 0x5b,
	0x63, 0x0f, 0xac, 0xf4, 0xc3, 0x49, 0xd9, 0xae, 0x88, 0x45, 0x6e, 0xd8, 0x28, 0x51, 0xa6, 0xcd,
	0x4c, 0x2a, 0x99, 0x44, 0x1d, 0x43, 0x50, 0x20, 0xea, 0x81, 0x92, 0xd7, 0xe8, 0x47, 0x60, 0xbd,
	0xff, 0x04, 0xd2, 0x4d, 0x38, 0x16, 0xc2, 0x58, 0x60, 0x2e, 0xcf, 0x4d, 0xfb, 0x90, 0x56, 0x1f,
	0x07, 0x3f, 0x04, 0x6b, 0xfa, 0x39, 0x83, 0x64, 0xf3, 0x47, 0x73, 0x7f, 0x55, 0xa1, 0x06, 0x98,
	0xbc, 0x3f, 0x38, 0x60, 0x63, 0x4a, 0xa6, 0x64, 0xcf, 0xee, 0xb1, 0x54, 0xa6, 0x67, 0xb8, 0x9f,
	0x86, 0x82, 0x7c, 0x8c, 0x8b, 0xd8, 0xef, 0xa6, 0x41, 0x5a, 0xce, 0x13, 0xf2, 0x31, 0x56, 0x13,
	0x00, 0xa6, 0x22, 0x15, 0x23, 0x7c, 0x05, 0xcc, 0x09, 0x35, 0x70, 0x90, 0x6e, 0xf7, 0xb3, 0xeb,
	0x60, 0x35, 0x2f, 0xb6, 0x27, 0x3a, 0x58, 0xe0, 0x9f, 0x1d, 0xf0, 0xca, 0xe4, 0x9f, 0x84, 0xe0,
	0xfb, 0xf3, 0x23, 0x6d, 0xe6, 0xcf, 0x4d, 0x95, 0x0f, 0xae, 0x4e, 0xa0, 0x6b, 0x9b, 0xf7, 0x85,
	0x1f, 0xfd, 0xf5, 0x1f, 0xbf, 0x70, 0x6f, 0x7b, 0x95, 0xda, 0x45, 0xbd, 0xd1, 0x99, 0x28, 0xdb,
	0x70, 0xb6, 0xe1, 0xdf, 0x1c, 0xb0, 0x3e, 0xf1, 0x97, 0x11, 0xf8, 0xd5, 0x4b, 0x3e, 0x61, 0xe4,
	0x97, 0x9c, 0xca, 0xfb, 0x57, 0xc6, 0x1b, 0x0d, 0xde, 0x7b, 0xd6, 0x9c, 0x3c, 0x67, 0x28, 0xcd,
	0xb6, 0xbc, 0xcf, 0x8f, 0x69, 0x66, 0x29, 0x32, 0xc5, 0x7e, 0xe9, 0x82, 0x8d, 0x29, 0xdf, 0x09,
	0xb0, 0x80, 0x75, 0x67, 0x7f, 0x72, 0x57, 0x9a, 0xcf, 0xc1, 0x60, 0xd4, 0xfb, 0xa1, 0xf3, 0xac,
	0x79, 0x6f, 0x60, 0xea, 0xde, 0x99, 0xa8, 0xeb, 0xce, 0xd0, 0xc4, 0xbd, 0x33, 0xd4, 0x12, 0x95,
	0x1d, 0x1a, 0xde, 0x97, 0xd5, 0x4f, 0xbf, 0x86, 0x48, 0xd4, 0x7e, 0x30, 0xc0, 0x79, 0x6f, 0xfb,
	0x93, 0x46, 0x3c, 0xf9, 0x1d, 0x99, 0x8d, 0x7e, 0xea, 0x82, 0xf5, 0x89, 0x1d, 0xb2, 0x88, 0xf3,
	0x67, 0x7d, 0x50, 0x14, 0x71, 0xfe, 0xcc, 0xd6, 0xec, 0xb1, 0x67, 0xcd, 0xea, 0xa0, 0x71, 0xc6,
	0xbe, 0x1a, 0x76, 0x46, 0x47, 0x5e, 0x65, 0x8d, 0x77, 0xbc, 0x7a, 0x31, 0x6b, 0x0c, 0xdd, 0xda,
	0x70, 0xb6, 0x2b, 0xaf, 0x7e, 0xda, 0x2c, 0xf7, 0x1f, 0x6a, 0x56, 0x09, 0x11, 0xd9, 0x14, 0x77,
	0xff, 0x3f, 0x0e, 0xb8, 0x1b, 0xb2, 0xee, 0x5c, 0xa5, 0xee, 0xaf, 0x8f, 0x56, 0x89, 0xe3, 0xac,
	0xc2, 0x1c, 0x3b, 0xdf, 0xf9, 0xd0, 0x40, 0x63, 0xd6, 0x41, 0x34, 0xae, 0x32, 0x1e, 0xd7, 0x62,
	0x4c, 0x55, 0xfd, 0xa9, 0xf5, 0x2f, 0x9b, 0xfe, 0xff, 0x82, 0xaf, 0xd8, 0xc5, 0xaf, 0xdc, 0xd2,
	0x61, 0xb3, 0xf9, 0x3b, 0xf7, 0xce, 0xa1, 0x26, 0x6c, 0x46, 0xa2, 0xaa, 0x97, 0xd9, 0xea, 0x71,
	0xbd, 0x6a, 0x2e, 0x16, 0x9f, 0x5a, 0x91, 0xd3, 0x66, 0x24, 0x4e, 0x73, 0x91, 0xd3, 0xc7, 0xf5,
	0x53, 0x2b, 0xf2, 0x6f, 0xf7, 0xae, 0xde, 0x6f, 0x34, 0x9a, 0x91, 0x68, 0x34, 0x72, 0xa1, 0x46,
	0xe3, 0x71, 0xbd, 0xd1, 0xb0, 0x62, 0x67, 0x2f, 0xa9, 0x77, 0xd6, 0xff, 0x1b, 0x00, 0x00, 0xff,
	0xff, 0x4d, 0x42, 0xf6, 0x7e, 0xd6, 0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ReachPlanServiceClient is the client API for ReachPlanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReachPlanServiceClient interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error)
}

type reachPlanServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReachPlanServiceClient(cc grpc.ClientConnInterface) ReachPlanServiceClient {
	return &reachPlanServiceClient{cc}
}

func (c *reachPlanServiceClient) ListPlannableLocations(ctx context.Context, in *ListPlannableLocationsRequest, opts ...grpc.CallOption) (*ListPlannableLocationsResponse, error) {
	out := new(ListPlannableLocationsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableLocations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) ListPlannableProducts(ctx context.Context, in *ListPlannableProductsRequest, opts ...grpc.CallOption) (*ListPlannableProductsResponse, error) {
	out := new(ListPlannableProductsResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableProducts", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateProductMixIdeas(ctx context.Context, in *GenerateProductMixIdeasRequest, opts ...grpc.CallOption) (*GenerateProductMixIdeasResponse, error) {
	out := new(GenerateProductMixIdeasResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/GenerateProductMixIdeas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reachPlanServiceClient) GenerateReachForecast(ctx context.Context, in *GenerateReachForecastRequest, opts ...grpc.CallOption) (*GenerateReachForecastResponse, error) {
	out := new(GenerateReachForecastResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.ReachPlanService/GenerateReachForecast", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReachPlanServiceServer is the server API for ReachPlanService service.
type ReachPlanServiceServer interface {
	// Returns the list of plannable locations (for example, countries & DMAs).
	ListPlannableLocations(context.Context, *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error)
	// Returns the list of per-location plannable YouTube ad formats with allowed
	// targeting.
	ListPlannableProducts(context.Context, *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error)
	// Generates a product mix ideas given a set of preferences. This method
	// helps the advertiser to obtain a good mix of ad formats and budget
	// allocations based on its preferences.
	GenerateProductMixIdeas(context.Context, *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error)
	// Generates a reach forecast for a given targeting / product mix.
	GenerateReachForecast(context.Context, *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error)
}

// UnimplementedReachPlanServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReachPlanServiceServer struct {
}

func (*UnimplementedReachPlanServiceServer) ListPlannableLocations(ctx context.Context, req *ListPlannableLocationsRequest) (*ListPlannableLocationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableLocations not implemented")
}
func (*UnimplementedReachPlanServiceServer) ListPlannableProducts(ctx context.Context, req *ListPlannableProductsRequest) (*ListPlannableProductsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlannableProducts not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateProductMixIdeas(ctx context.Context, req *GenerateProductMixIdeasRequest) (*GenerateProductMixIdeasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateProductMixIdeas not implemented")
}
func (*UnimplementedReachPlanServiceServer) GenerateReachForecast(ctx context.Context, req *GenerateReachForecastRequest) (*GenerateReachForecastResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateReachForecast not implemented")
}

func RegisterReachPlanServiceServer(s *grpc.Server, srv ReachPlanServiceServer) {
	s.RegisterService(&_ReachPlanService_serviceDesc, srv)
}

func _ReachPlanService_ListPlannableLocations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableLocations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableLocations(ctx, req.(*ListPlannableLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_ListPlannableProducts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlannableProductsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/ListPlannableProducts",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).ListPlannableProducts(ctx, req.(*ListPlannableProductsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateProductMixIdeas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateProductMixIdeasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/GenerateProductMixIdeas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateProductMixIdeas(ctx, req.(*GenerateProductMixIdeasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReachPlanService_GenerateReachForecast_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateReachForecastRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.ReachPlanService/GenerateReachForecast",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReachPlanServiceServer).GenerateReachForecast(ctx, req.(*GenerateReachForecastRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReachPlanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.ReachPlanService",
	HandlerType: (*ReachPlanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPlannableLocations",
			Handler:    _ReachPlanService_ListPlannableLocations_Handler,
		},
		{
			MethodName: "ListPlannableProducts",
			Handler:    _ReachPlanService_ListPlannableProducts_Handler,
		},
		{
			MethodName: "GenerateProductMixIdeas",
			Handler:    _ReachPlanService_GenerateProductMixIdeas_Handler,
		},
		{
			MethodName: "GenerateReachForecast",
			Handler:    _ReachPlanService_GenerateReachForecast_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/reach_plan_service.proto",
}
