// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/containeranalysis/v1beta1/vulnerability/vulnerability.proto

package vulnerability

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	common "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/common"
	cvss "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/cvss"
	_package "google.golang.org/genproto/googleapis/devtools/containeranalysis/v1beta1/package"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Note provider-assigned severity/impact ranking.
type Severity int32

const (
	// Unknown.
	Severity_SEVERITY_UNSPECIFIED Severity = 0
	// Minimal severity.
	Severity_MINIMAL Severity = 1
	// Low severity.
	Severity_LOW Severity = 2
	// Medium severity.
	Severity_MEDIUM Severity = 3
	// High severity.
	Severity_HIGH Severity = 4
	// Critical severity.
	Severity_CRITICAL Severity = 5
)

var Severity_name = map[int32]string{
	0: "SEVERITY_UNSPECIFIED",
	1: "MINIMAL",
	2: "LOW",
	3: "MEDIUM",
	4: "HIGH",
	5: "CRITICAL",
}

var Severity_value = map[string]int32{
	"SEVERITY_UNSPECIFIED": 0,
	"MINIMAL":              1,
	"LOW":                  2,
	"MEDIUM":               3,
	"HIGH":                 4,
	"CRITICAL":             5,
}

func (x Severity) String() string {
	return proto.EnumName(Severity_name, int32(x))
}

func (Severity) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0}
}

// Vulnerability provides metadata about a security vulnerability in a Note.
type Vulnerability struct {
	// The CVSS score for this vulnerability.
	CvssScore float32 `protobuf:"fixed32,1,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// Note provider assigned impact of the vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// All information about the package to specifically identify this
	// vulnerability. One entry per (version range and cpe_uri) the package
	// vulnerability has manifested in.
	Details []*Vulnerability_Detail `protobuf:"bytes,3,rep,name=details,proto3" json:"details,omitempty"`
	// The full description of the CVSSv3.
	CvssV3 *cvss.CVSSv3 `protobuf:"bytes,4,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	// Windows details get their own format because the information format and
	// model don't match a normal detail. Specifically Windows updates are done as
	// patches, thus Windows vulnerabilities really are a missing package, rather
	// than a package being at an incorrect version.
	WindowsDetails []*Vulnerability_WindowsDetail `protobuf:"bytes,5,rep,name=windows_details,json=windowsDetails,proto3" json:"windows_details,omitempty"`
	// The time this information was last changed at the source. This is an
	// upstream timestamp from the underlying information source - e.g. Ubuntu
	// security tracker.
	SourceUpdateTime     *timestamp.Timestamp `protobuf:"bytes,6,opt,name=source_update_time,json=sourceUpdateTime,proto3" json:"source_update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Vulnerability) Reset()         { *m = Vulnerability{} }
func (m *Vulnerability) String() string { return proto.CompactTextString(m) }
func (*Vulnerability) ProtoMessage()    {}
func (*Vulnerability) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0}
}

func (m *Vulnerability) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vulnerability.Unmarshal(m, b)
}
func (m *Vulnerability) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vulnerability.Marshal(b, m, deterministic)
}
func (m *Vulnerability) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vulnerability.Merge(m, src)
}
func (m *Vulnerability) XXX_Size() int {
	return xxx_messageInfo_Vulnerability.Size(m)
}
func (m *Vulnerability) XXX_DiscardUnknown() {
	xxx_messageInfo_Vulnerability.DiscardUnknown(m)
}

var xxx_messageInfo_Vulnerability proto.InternalMessageInfo

func (m *Vulnerability) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *Vulnerability) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *Vulnerability) GetDetails() []*Vulnerability_Detail {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *Vulnerability) GetCvssV3() *cvss.CVSSv3 {
	if m != nil {
		return m.CvssV3
	}
	return nil
}

func (m *Vulnerability) GetWindowsDetails() []*Vulnerability_WindowsDetail {
	if m != nil {
		return m.WindowsDetails
	}
	return nil
}

func (m *Vulnerability) GetSourceUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.SourceUpdateTime
	}
	return nil
}

// Identifies all appearances of this vulnerability in the package for a
// specific distro/location. For example: glibc in
// cpe:/o:debian:debian_linux:8 for versions 2.1 - 2.2
type Vulnerability_Detail struct {
	// Required. The CPE URI in
	// [cpe format](https://cpe.mitre.org/specification/) in which the
	// vulnerability manifests. Examples include distro or storage location for
	// vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The name of the package where the vulnerability was found.
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// The min version of the package in which the vulnerability exists.
	MinAffectedVersion *_package.Version `protobuf:"bytes,3,opt,name=min_affected_version,json=minAffectedVersion,proto3" json:"min_affected_version,omitempty"`
	// The max version of the package in which the vulnerability exists.
	MaxAffectedVersion *_package.Version `protobuf:"bytes,4,opt,name=max_affected_version,json=maxAffectedVersion,proto3" json:"max_affected_version,omitempty"`
	// The severity (eg: distro assigned severity) for this vulnerability.
	SeverityName string `protobuf:"bytes,5,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	// A vendor-specific description of this note.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// The fix for this specific package version.
	FixedLocation *VulnerabilityLocation `protobuf:"bytes,7,opt,name=fixed_location,json=fixedLocation,proto3" json:"fixed_location,omitempty"`
	// The type of package; whether native or non native(ruby gems, node.js
	// packages etc).
	PackageType string `protobuf:"bytes,8,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// Whether this detail is obsolete. Occurrences are expected not to point to
	// obsolete details.
	IsObsolete bool `protobuf:"varint,9,opt,name=is_obsolete,json=isObsolete,proto3" json:"is_obsolete,omitempty"`
	// The time this information was last changed at the source. This is an
	// upstream timestamp from the underlying information source - e.g. Ubuntu
	// security tracker.
	SourceUpdateTime     *timestamp.Timestamp `protobuf:"bytes,10,opt,name=source_update_time,json=sourceUpdateTime,proto3" json:"source_update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Vulnerability_Detail) Reset()         { *m = Vulnerability_Detail{} }
func (m *Vulnerability_Detail) String() string { return proto.CompactTextString(m) }
func (*Vulnerability_Detail) ProtoMessage()    {}
func (*Vulnerability_Detail) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0, 0}
}

func (m *Vulnerability_Detail) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vulnerability_Detail.Unmarshal(m, b)
}
func (m *Vulnerability_Detail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vulnerability_Detail.Marshal(b, m, deterministic)
}
func (m *Vulnerability_Detail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vulnerability_Detail.Merge(m, src)
}
func (m *Vulnerability_Detail) XXX_Size() int {
	return xxx_messageInfo_Vulnerability_Detail.Size(m)
}
func (m *Vulnerability_Detail) XXX_DiscardUnknown() {
	xxx_messageInfo_Vulnerability_Detail.DiscardUnknown(m)
}

var xxx_messageInfo_Vulnerability_Detail proto.InternalMessageInfo

func (m *Vulnerability_Detail) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *Vulnerability_Detail) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *Vulnerability_Detail) GetMinAffectedVersion() *_package.Version {
	if m != nil {
		return m.MinAffectedVersion
	}
	return nil
}

func (m *Vulnerability_Detail) GetMaxAffectedVersion() *_package.Version {
	if m != nil {
		return m.MaxAffectedVersion
	}
	return nil
}

func (m *Vulnerability_Detail) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

func (m *Vulnerability_Detail) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Vulnerability_Detail) GetFixedLocation() *VulnerabilityLocation {
	if m != nil {
		return m.FixedLocation
	}
	return nil
}

func (m *Vulnerability_Detail) GetPackageType() string {
	if m != nil {
		return m.PackageType
	}
	return ""
}

func (m *Vulnerability_Detail) GetIsObsolete() bool {
	if m != nil {
		return m.IsObsolete
	}
	return false
}

func (m *Vulnerability_Detail) GetSourceUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.SourceUpdateTime
	}
	return nil
}

type Vulnerability_WindowsDetail struct {
	// Required. The CPE URI in
	// [cpe format](https://cpe.mitre.org/specification/) in which the
	// vulnerability manifests. Examples include distro or storage location for
	// vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The name of the vulnerability.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the vulnerability.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The names of the KBs which have hotfixes to mitigate this
	// vulnerability. Note that there may be multiple hotfixes (and thus
	// multiple KBs) that mitigate a given vulnerability. Currently any listed
	// kb's presence is considered a fix.
	FixingKbs            []*Vulnerability_WindowsDetail_KnowledgeBase `protobuf:"bytes,4,rep,name=fixing_kbs,json=fixingKbs,proto3" json:"fixing_kbs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *Vulnerability_WindowsDetail) Reset()         { *m = Vulnerability_WindowsDetail{} }
func (m *Vulnerability_WindowsDetail) String() string { return proto.CompactTextString(m) }
func (*Vulnerability_WindowsDetail) ProtoMessage()    {}
func (*Vulnerability_WindowsDetail) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0, 1}
}

func (m *Vulnerability_WindowsDetail) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vulnerability_WindowsDetail.Unmarshal(m, b)
}
func (m *Vulnerability_WindowsDetail) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vulnerability_WindowsDetail.Marshal(b, m, deterministic)
}
func (m *Vulnerability_WindowsDetail) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vulnerability_WindowsDetail.Merge(m, src)
}
func (m *Vulnerability_WindowsDetail) XXX_Size() int {
	return xxx_messageInfo_Vulnerability_WindowsDetail.Size(m)
}
func (m *Vulnerability_WindowsDetail) XXX_DiscardUnknown() {
	xxx_messageInfo_Vulnerability_WindowsDetail.DiscardUnknown(m)
}

var xxx_messageInfo_Vulnerability_WindowsDetail proto.InternalMessageInfo

func (m *Vulnerability_WindowsDetail) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *Vulnerability_WindowsDetail) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Vulnerability_WindowsDetail) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Vulnerability_WindowsDetail) GetFixingKbs() []*Vulnerability_WindowsDetail_KnowledgeBase {
	if m != nil {
		return m.FixingKbs
	}
	return nil
}

type Vulnerability_WindowsDetail_KnowledgeBase struct {
	// The KB name (generally of the form KB[0-9]+ i.e. KB123456).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A link to the KB in the Windows update catalog -
	// https://www.catalog.update.microsoft.com/
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Vulnerability_WindowsDetail_KnowledgeBase) Reset() {
	*m = Vulnerability_WindowsDetail_KnowledgeBase{}
}
func (m *Vulnerability_WindowsDetail_KnowledgeBase) String() string { return proto.CompactTextString(m) }
func (*Vulnerability_WindowsDetail_KnowledgeBase) ProtoMessage()    {}
func (*Vulnerability_WindowsDetail_KnowledgeBase) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{0, 1, 0}
}

func (m *Vulnerability_WindowsDetail_KnowledgeBase) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Vulnerability_WindowsDetail_KnowledgeBase.Unmarshal(m, b)
}
func (m *Vulnerability_WindowsDetail_KnowledgeBase) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Vulnerability_WindowsDetail_KnowledgeBase.Marshal(b, m, deterministic)
}
func (m *Vulnerability_WindowsDetail_KnowledgeBase) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Vulnerability_WindowsDetail_KnowledgeBase.Merge(m, src)
}
func (m *Vulnerability_WindowsDetail_KnowledgeBase) XXX_Size() int {
	return xxx_messageInfo_Vulnerability_WindowsDetail_KnowledgeBase.Size(m)
}
func (m *Vulnerability_WindowsDetail_KnowledgeBase) XXX_DiscardUnknown() {
	xxx_messageInfo_Vulnerability_WindowsDetail_KnowledgeBase.DiscardUnknown(m)
}

var xxx_messageInfo_Vulnerability_WindowsDetail_KnowledgeBase proto.InternalMessageInfo

func (m *Vulnerability_WindowsDetail_KnowledgeBase) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Vulnerability_WindowsDetail_KnowledgeBase) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// Details of a vulnerability Occurrence.
type Details struct {
	// The type of package; whether native or non native(ruby gems, node.js
	// packages etc)
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The note provider assigned Severity of the vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"severity,omitempty"`
	// Output only. The CVSS score of this vulnerability. CVSS score is on a
	// scale of 0-10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float32 `protobuf:"fixed32,3,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// Required. The set of affected locations and their fixes (if available)
	// within the associated resource.
	PackageIssue []*PackageIssue `protobuf:"bytes,4,rep,name=package_issue,json=packageIssue,proto3" json:"package_issue,omitempty"`
	// Output only. A one sentence description of this vulnerability.
	ShortDescription string `protobuf:"bytes,5,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// Output only. A detailed description of this vulnerability.
	LongDescription string `protobuf:"bytes,6,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. URLs related to this vulnerability.
	RelatedUrls []*common.RelatedUrl `protobuf:"bytes,7,rep,name=related_urls,json=relatedUrls,proto3" json:"related_urls,omitempty"`
	// The distro assigned severity for this vulnerability when it is
	// available, and note provider assigned severity when distro has not yet
	// assigned a severity for this vulnerability.
	EffectiveSeverity    Severity `protobuf:"varint,8,opt,name=effective_severity,json=effectiveSeverity,proto3,enum=grafeas.v1beta1.vulnerability.Severity" json:"effective_severity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Details) Reset()         { *m = Details{} }
func (m *Details) String() string { return proto.CompactTextString(m) }
func (*Details) ProtoMessage()    {}
func (*Details) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{1}
}

func (m *Details) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Details.Unmarshal(m, b)
}
func (m *Details) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Details.Marshal(b, m, deterministic)
}
func (m *Details) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Details.Merge(m, src)
}
func (m *Details) XXX_Size() int {
	return xxx_messageInfo_Details.Size(m)
}
func (m *Details) XXX_DiscardUnknown() {
	xxx_messageInfo_Details.DiscardUnknown(m)
}

var xxx_messageInfo_Details proto.InternalMessageInfo

func (m *Details) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Details) GetSeverity() Severity {
	if m != nil {
		return m.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (m *Details) GetCvssScore() float32 {
	if m != nil {
		return m.CvssScore
	}
	return 0
}

func (m *Details) GetPackageIssue() []*PackageIssue {
	if m != nil {
		return m.PackageIssue
	}
	return nil
}

func (m *Details) GetShortDescription() string {
	if m != nil {
		return m.ShortDescription
	}
	return ""
}

func (m *Details) GetLongDescription() string {
	if m != nil {
		return m.LongDescription
	}
	return ""
}

func (m *Details) GetRelatedUrls() []*common.RelatedUrl {
	if m != nil {
		return m.RelatedUrls
	}
	return nil
}

func (m *Details) GetEffectiveSeverity() Severity {
	if m != nil {
		return m.EffectiveSeverity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

// This message wraps a location affected by a vulnerability and its
// associated fix (if one is available).
type PackageIssue struct {
	// Required. The location of the vulnerability.
	AffectedLocation *VulnerabilityLocation `protobuf:"bytes,1,opt,name=affected_location,json=affectedLocation,proto3" json:"affected_location,omitempty"`
	// The location of the available fix for vulnerability.
	FixedLocation *VulnerabilityLocation `protobuf:"bytes,2,opt,name=fixed_location,json=fixedLocation,proto3" json:"fixed_location,omitempty"`
	// Deprecated, use Details.effective_severity instead
	// The severity (e.g., distro assigned severity) for this vulnerability.
	SeverityName         string   `protobuf:"bytes,3,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PackageIssue) Reset()         { *m = PackageIssue{} }
func (m *PackageIssue) String() string { return proto.CompactTextString(m) }
func (*PackageIssue) ProtoMessage()    {}
func (*PackageIssue) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{2}
}

func (m *PackageIssue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PackageIssue.Unmarshal(m, b)
}
func (m *PackageIssue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PackageIssue.Marshal(b, m, deterministic)
}
func (m *PackageIssue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PackageIssue.Merge(m, src)
}
func (m *PackageIssue) XXX_Size() int {
	return xxx_messageInfo_PackageIssue.Size(m)
}
func (m *PackageIssue) XXX_DiscardUnknown() {
	xxx_messageInfo_PackageIssue.DiscardUnknown(m)
}

var xxx_messageInfo_PackageIssue proto.InternalMessageInfo

func (m *PackageIssue) GetAffectedLocation() *VulnerabilityLocation {
	if m != nil {
		return m.AffectedLocation
	}
	return nil
}

func (m *PackageIssue) GetFixedLocation() *VulnerabilityLocation {
	if m != nil {
		return m.FixedLocation
	}
	return nil
}

func (m *PackageIssue) GetSeverityName() string {
	if m != nil {
		return m.SeverityName
	}
	return ""
}

// The location of the vulnerability.
type VulnerabilityLocation struct {
	// Required. The CPE URI in [cpe format](https://cpe.mitre.org/specification/)
	// format. Examples include distro or storage location for vulnerable jar.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The package being described.
	Package string `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	// Required. The version of the package being described.
	Version              *_package.Version `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *VulnerabilityLocation) Reset()         { *m = VulnerabilityLocation{} }
func (m *VulnerabilityLocation) String() string { return proto.CompactTextString(m) }
func (*VulnerabilityLocation) ProtoMessage()    {}
func (*VulnerabilityLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_2a1e5608ee0186b1, []int{3}
}

func (m *VulnerabilityLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VulnerabilityLocation.Unmarshal(m, b)
}
func (m *VulnerabilityLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VulnerabilityLocation.Marshal(b, m, deterministic)
}
func (m *VulnerabilityLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VulnerabilityLocation.Merge(m, src)
}
func (m *VulnerabilityLocation) XXX_Size() int {
	return xxx_messageInfo_VulnerabilityLocation.Size(m)
}
func (m *VulnerabilityLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_VulnerabilityLocation.DiscardUnknown(m)
}

var xxx_messageInfo_VulnerabilityLocation proto.InternalMessageInfo

func (m *VulnerabilityLocation) GetCpeUri() string {
	if m != nil {
		return m.CpeUri
	}
	return ""
}

func (m *VulnerabilityLocation) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *VulnerabilityLocation) GetVersion() *_package.Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func init() {
	proto.RegisterEnum("grafeas.v1beta1.vulnerability.Severity", Severity_name, Severity_value)
	proto.RegisterType((*Vulnerability)(nil), "grafeas.v1beta1.vulnerability.Vulnerability")
	proto.RegisterType((*Vulnerability_Detail)(nil), "grafeas.v1beta1.vulnerability.Vulnerability.Detail")
	proto.RegisterType((*Vulnerability_WindowsDetail)(nil), "grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail")
	proto.RegisterType((*Vulnerability_WindowsDetail_KnowledgeBase)(nil), "grafeas.v1beta1.vulnerability.Vulnerability.WindowsDetail.KnowledgeBase")
	proto.RegisterType((*Details)(nil), "grafeas.v1beta1.vulnerability.Details")
	proto.RegisterType((*PackageIssue)(nil), "grafeas.v1beta1.vulnerability.PackageIssue")
	proto.RegisterType((*VulnerabilityLocation)(nil), "grafeas.v1beta1.vulnerability.VulnerabilityLocation")
}

func init() {
	proto.RegisterFile("google/devtools/containeranalysis/v1beta1/vulnerability/vulnerability.proto", fileDescriptor_2a1e5608ee0186b1)
}

var fileDescriptor_2a1e5608ee0186b1 = []byte{
	// 943 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xc6, 0x71, 0x1a, 0x27, 0x27, 0x49, 0xd7, 0x1d, 0x2d, 0xc2, 0x0a, 0x5a, 0x6d, 0x28, 0x42,
	0x04, 0x56, 0x72, 0xb4, 0x0d, 0x5c, 0xb0, 0x88, 0x45, 0xdd, 0x34, 0x6c, 0xad, 0x36, 0xdd, 0xca,
	0x69, 0xb2, 0x02, 0x24, 0xac, 0x89, 0x33, 0x31, 0xa3, 0x75, 0x3c, 0x96, 0xc7, 0x71, 0x9b, 0x17,
	0xe0, 0x9a, 0x1b, 0x5e, 0x80, 0x57, 0xe1, 0x8e, 0xd7, 0xe1, 0x1e, 0x21, 0x8f, 0xc7, 0x51, 0xd2,
	0xb0, 0xdb, 0xa6, 0xdb, 0x9b, 0x78, 0xe6, 0xcc, 0xf9, 0xbe, 0xf9, 0xe6, 0xfc, 0x29, 0x70, 0xe2,
	0x31, 0xe6, 0xf9, 0xa4, 0x3d, 0x21, 0x49, 0xcc, 0x98, 0xcf, 0xdb, 0x2e, 0x0b, 0x62, 0x4c, 0x03,
	0x12, 0xe1, 0x00, 0xfb, 0x0b, 0x4e, 0x79, 0x3b, 0x79, 0x3a, 0x26, 0x31, 0x7e, 0xda, 0x4e, 0xe6,
	0x7e, 0x6a, 0x1e, 0x53, 0x9f, 0xc6, 0x8b, 0xf5, 0x9d, 0x19, 0x46, 0x2c, 0x66, 0xe8, 0x91, 0x17,
	0xe1, 0x29, 0xc1, 0xdc, 0x94, 0x10, 0x73, 0xcd, 0xa9, 0xf1, 0x58, 0xde, 0x25, 0x9c, 0xc7, 0xf3,
	0x69, 0x3b, 0xa6, 0x33, 0xc2, 0x63, 0x3c, 0x0b, 0x33, 0x7c, 0xe3, 0xbb, 0xdb, 0x8b, 0x71, 0xd9,
	0x6c, 0xc6, 0x02, 0xf9, 0x91, 0xf0, 0x6f, 0xb6, 0x80, 0x27, 0x9c, 0x8b, 0x1f, 0x09, 0xfd, 0xfe,
	0xf6, 0xd0, 0x10, 0xbb, 0x6f, 0xb0, 0x47, 0xf2, 0x6f, 0x46, 0xb0, 0xff, 0x77, 0x05, 0xea, 0xa3,
	0xd5, 0xd7, 0xa2, 0x47, 0x00, 0xe9, 0x05, 0x0e, 0x77, 0x59, 0x44, 0x0c, 0xa5, 0xa9, 0xb4, 0x0a,
	0x76, 0x25, 0xb5, 0x0c, 0x52, 0x03, 0xea, 0x42, 0x99, 0x93, 0x84, 0x44, 0x34, 0x5e, 0x18, 0x85,
	0xa6, 0xd2, 0xda, 0x3d, 0xf8, 0xdc, 0x7c, 0x67, 0xf8, 0xcc, 0x81, 0x74, 0xb7, 0x97, 0x40, 0xd4,
	0x07, 0x6d, 0x42, 0x62, 0x4c, 0x7d, 0x6e, 0xa8, 0x4d, 0xb5, 0x55, 0x3d, 0xe8, 0xdc, 0xc0, 0xb1,
	0x26, 0xd1, 0x3c, 0x12, 0x58, 0x3b, 0xe7, 0x40, 0xcf, 0x41, 0x13, 0x92, 0x93, 0x8e, 0x51, 0x6c,
	0x2a, 0xad, 0xea, 0xc1, 0x67, 0x37, 0xd0, 0x75, 0x47, 0x83, 0x41, 0xd2, 0xb1, 0x4b, 0x29, 0x6a,
	0xd4, 0x41, 0x2e, 0x3c, 0xb8, 0xa4, 0xc1, 0x84, 0x5d, 0x72, 0x27, 0x97, 0xb5, 0x23, 0x64, 0x3d,
	0xdb, 0x4a, 0xd6, 0xeb, 0x8c, 0x43, 0xaa, 0xdb, 0xbd, 0x5c, 0xdd, 0x72, 0x74, 0x0c, 0x88, 0xb3,
	0x79, 0xe4, 0x12, 0x67, 0x1e, 0x4e, 0x70, 0x4c, 0x9c, 0xb4, 0x8a, 0x8c, 0x92, 0xd0, 0xdb, 0x30,
	0xb3, 0x3c, 0x9a, 0x79, 0x89, 0x99, 0x17, 0x79, 0x89, 0xd9, 0x7a, 0x86, 0x1a, 0x0a, 0x50, 0x6a,
	0x6e, 0xfc, 0x51, 0x84, 0x52, 0xc6, 0x8a, 0x3e, 0x02, 0xcd, 0x0d, 0x89, 0x33, 0x8f, 0xa8, 0xc8,
	0x54, 0xc5, 0x2e, 0xb9, 0x21, 0x19, 0x46, 0x14, 0x19, 0xa0, 0xc9, 0x44, 0x8b, 0x2c, 0x55, 0xec,
	0x7c, 0x8b, 0x6c, 0x78, 0x38, 0xa3, 0x81, 0x83, 0xa7, 0x53, 0xe2, 0xc6, 0x64, 0xe2, 0x24, 0x24,
	0xe2, 0x94, 0x05, 0x86, 0x2a, 0x94, 0x34, 0x37, 0x5e, 0x9c, 0xd7, 0xcb, 0x28, 0xf3, 0xb3, 0xd1,
	0x8c, 0x06, 0x87, 0x12, 0x2c, 0x6d, 0x82, 0x13, 0x5f, 0x6d, 0x72, 0x16, 0x6f, 0xcd, 0x89, 0xaf,
	0xae, 0x73, 0x7e, 0x0a, 0xf5, 0xbc, 0x5e, 0x9c, 0x00, 0xcf, 0x88, 0xb1, 0x23, 0xde, 0x51, 0xcb,
	0x8d, 0x67, 0x78, 0x46, 0x50, 0x13, 0xaa, 0x13, 0xc2, 0xdd, 0x88, 0x86, 0x71, 0x7a, 0x5f, 0x49,
	0xb8, 0xac, 0x9a, 0xd0, 0xcf, 0xb0, 0x3b, 0xa5, 0x57, 0x64, 0xe2, 0xf8, 0xcc, 0xc5, 0xc2, 0x49,
	0x13, 0xa2, 0xbe, 0xda, 0x26, 0xb5, 0xa7, 0x12, 0x6b, 0xd7, 0x05, 0x57, 0xbe, 0x45, 0x9f, 0x40,
	0x4d, 0x3e, 0xc5, 0x89, 0x17, 0x21, 0x31, 0xca, 0xd9, 0xfd, 0xd2, 0x76, 0xb1, 0x08, 0x09, 0x7a,
	0x0c, 0x55, 0xca, 0x1d, 0x36, 0xe6, 0xcc, 0x27, 0x31, 0x31, 0x2a, 0x4d, 0xa5, 0x55, 0xb6, 0x81,
	0xf2, 0x57, 0xd2, 0xf2, 0x96, 0xba, 0x80, 0x3b, 0xd4, 0xc5, 0xbf, 0x0a, 0xd4, 0xd7, 0x6a, 0xf0,
	0xed, 0xe5, 0x81, 0xa0, 0x28, 0x62, 0x9a, 0xd5, 0x86, 0x58, 0x5f, 0x8f, 0xa5, 0xba, 0x19, 0x4b,
	0x0f, 0x60, 0x4a, 0xaf, 0x68, 0xe0, 0x39, 0x6f, 0xc6, 0xdc, 0x28, 0x8a, 0x16, 0x39, 0xbe, 0x7b,
	0x8b, 0x98, 0x27, 0x01, 0xbb, 0xf4, 0xc9, 0xc4, 0x23, 0x2f, 0x30, 0x27, 0x76, 0x25, 0xe3, 0x3e,
	0x19, 0xf3, 0xc6, 0xd7, 0x50, 0x5f, 0x3b, 0x5b, 0xea, 0x55, 0x56, 0xf4, 0xea, 0xa0, 0xce, 0x23,
	0x5f, 0x3e, 0x21, 0x5d, 0xee, 0xff, 0xa5, 0x82, 0x96, 0xb7, 0x1b, 0x82, 0xa2, 0x48, 0x89, 0x44,
	0xa4, 0xeb, 0xfb, 0x99, 0x5d, 0xeb, 0xf3, 0x51, 0xbd, 0x3e, 0x1f, 0xcf, 0xa1, 0x9e, 0x97, 0x04,
	0xe5, 0x7c, 0x4e, 0x64, 0x98, 0x9e, 0xdc, 0x70, 0xd1, 0x79, 0x86, 0xb1, 0x52, 0x88, 0x9d, 0x17,
	0x95, 0xd8, 0xa1, 0x27, 0xb0, 0xc7, 0x7f, 0x65, 0x51, 0xec, 0xac, 0x66, 0x27, 0x6b, 0x06, 0x5d,
	0x1c, 0x1c, 0xad, 0xa4, 0xe8, 0x0b, 0xd0, 0x7d, 0x16, 0x78, 0xce, 0x66, 0x57, 0x3c, 0x48, 0xed,
	0xab, 0xae, 0xcf, 0xa1, 0x16, 0x11, 0x1f, 0xa7, 0xfd, 0x3a, 0x8f, 0x7c, 0x6e, 0x68, 0x42, 0xe8,
	0xc7, 0x1b, 0x42, 0xed, 0xcc, 0x69, 0x18, 0xf9, 0x76, 0x35, 0x5a, 0xae, 0x39, 0x1a, 0x01, 0x22,
	0xa2, 0x67, 0x69, 0x42, 0x9c, 0x65, 0x5c, 0xcb, 0xdb, 0xc5, 0x75, 0x6f, 0x49, 0x91, 0x9b, 0xf6,
	0xff, 0x51, 0xa0, 0xb6, 0x1a, 0x0e, 0x84, 0x61, 0x6f, 0x39, 0x59, 0x96, 0x5d, 0xac, 0xbc, 0x47,
	0x17, 0xeb, 0x39, 0xdd, 0xb2, 0x91, 0x37, 0xa7, 0x44, 0xe1, 0xfe, 0xa6, 0xc4, 0xc6, 0x24, 0x53,
	0x37, 0x27, 0xd9, 0xfe, 0x6f, 0x0a, 0x7c, 0xf8, 0xbf, 0x6c, 0x77, 0x99, 0xf1, 0xcf, 0x40, 0xdb,
	0x76, 0xac, 0xe7, 0x80, 0x2f, 0x7f, 0x81, 0x72, 0x9e, 0x0a, 0x64, 0xc0, 0xc3, 0x41, 0x6f, 0xd4,
	0xb3, 0xad, 0x8b, 0x1f, 0x9d, 0xe1, 0xd9, 0xe0, 0xbc, 0xd7, 0xb5, 0x7e, 0xb0, 0x7a, 0x47, 0xfa,
	0x07, 0xa8, 0x0a, 0x5a, 0xdf, 0x3a, 0xb3, 0xfa, 0x87, 0xa7, 0xba, 0x82, 0x34, 0x50, 0x4f, 0x5f,
	0xbd, 0xd6, 0x0b, 0x08, 0xa0, 0xd4, 0xef, 0x1d, 0x59, 0xc3, 0xbe, 0xae, 0xa2, 0x32, 0x14, 0x8f,
	0xad, 0x97, 0xc7, 0x7a, 0x11, 0xd5, 0xa0, 0xdc, 0xb5, 0xad, 0x0b, 0xab, 0x7b, 0x78, 0xaa, 0xef,
	0xbc, 0xf8, 0x5d, 0x81, 0x26, 0x65, 0xef, 0x8e, 0xeb, 0xb9, 0xf2, 0xd3, 0x44, 0x4e, 0x3e, 0x8f,
	0xf9, 0x38, 0xf0, 0x4c, 0x16, 0x79, 0x6d, 0x8f, 0x04, 0x62, 0x0e, 0xb6, 0xb3, 0x23, 0x1c, 0x52,
	0xbe, 0xf5, 0xff, 0xbf, 0x6f, 0xd7, 0x76, 0x7f, 0x16, 0xd4, 0x97, 0xf6, 0xe1, 0xb8, 0x24, 0x68,
	0x3b, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xa4, 0x56, 0x03, 0x08, 0x55, 0x0a, 0x00, 0x00,
}
