Name:		gsmartcontrol
Version: 	0.8.7
Release:	1as
License:	GPLv2, GPLv3
Url:		http://gsmartcontrol.berlios.de
Vendor:		Alexander Shaduri <ashaduri 'at' gmail.com>
# Packager:	Alexander Shaduri <ashaduri 'at' gmail.com>
Source:		gsmartcontrol-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-build
Summary:	GSmartControl - Hard Disk Health Inspection Tool

%if 0%{?mandriva_version}
Group:		System/Kernel and hardware
%else
Group:		Hardware/Other
%endif


# Dependencies for various distributions. The actual deps are:
# smartmontools, pcre, (gtkmm2 >= 2.12 || (gtkmm2 >= 2.6.0 && libglademm >= 2.4.0))
# (with the respective -devel packages of the libraries for build requirements).
# For non-specified distributions we don't specify any dependencies to avoid errors.

# For mandriva, these contain the su programs.
# Suggests:	libgnomesu, gksu, kdebase-progs


# SUSE / OpenSUSE. SLES also defines the correct suse_version.
%if 0%{?suse_version}

%if 0%{?%suse_version} >= 1030
Requires: smartmontools, pcre, gtkmm2 >= 2.12.0
BuildRequires: gcc-c++, libstdc++-devel, pcre-devel, gtkmm2-devel >= 2.12.0
%else
%if 0%{?%suse_version} == 1020
Requires: smartmontools, pcre, gtkmm2 >= 2.6.0, libglademm >= 2.4.0
BuildRequires: gcc-c++, libstdc++-devel, pcre-devel, gtkmm2-devel >= 2.6.0, libglademm-devel >= 2.4.0
%else
Requires: smartmontools, pcre, gtkmm24 >= 2.6.0, libglademm >= 2.4.0
BuildRequires: gcc-c++, libstdc++-devel, pcre-devel, gtkmm24-devel >= 2.6.0, libglademm-devel >= 2.4.0
%endif
%endif
BuildRequires: update-desktop-files

%if 0%{?suse_version} >= 1030
BuildRequires: fdupes
%endif

%endif


# Fedora, CentOS, RHEL
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}

# I'm not sure about centos and rhel versions
%if 0%{?fedora_version} >= 8 || 0%{?rhel_version} >= 600 || 0%{?centos_version} >= 600
Requires: smartmontools, pcre, gtkmm24 >= 2.12.0
BuildRequires: gcc-c++, pcre-devel, gtkmm24-devel >= 2.12.0
%else
Requires: smartmontools, pcre, gtkmm24 >= 2.6.0, libglademm24 >= 2.4.0
BuildRequires: gcc-c++, pcre-devel, gtkmm24-devel >= 2.6.0, libglademm24-devel >= 2.4.0
%endif

# Fedora with consolehelper.
# usermode-gtk is for consolehelper-gtk.
%if 0%{?fedora_version}
Requires: usermode-gtk
%endif

%endif


# Mandriva. Check the latest official spec file at
# http://svn.mandriva.com/cgi-bin/viewvc.cgi/packages/cooker/gsmartcontrol/current/
%if 0%{?mandriva_version}

%if 0%{?mandriva_version} >= 2008
Requires: smartmontools, libpcre0, gtkmm2.4 >= 2.12.0
BuildRequires: gcc-c++, gcc-cpp, pcre-devel, gtkmm2.4-devel >= 2.12.0, desktop-file-utils
%else
Requires: smartmontools, libpcre0, gtkmm2.4 >= 2.6.0, libglademm2.4 >= 2.4.0
BuildRequires: gcc-c++, gcc-cpp, pcre-devel, gtkmm2.4-devel >= 2.6.0, libglademm2.4-devel >= 2.4.0, desktop-file-utils
%endif

%endif


%description
GSmartControl is a graphical user interface for smartctl, which is a tool for
querying and controlling SMART (Self-Monitoring, Analysis, and Reporting
Technology) data in hard disk drives. It allows you to inspect the drive's
SMART data to determine its health, as well as run various tests on it.

%prep


%setup -q
%if 0%{?mandriva_version} <= 2006
%configure
%else
%configure --enable-optimize-options=auto
%endif

%build
# Set up for parallel builds
#numprocs=`grep -E -c ^cpu[0-9]+ /proc/stat || :`
#if [ "$numprocs" = "0" ]; then
#	numprocs=1
#fi
#make -j$numprocs
make


%install

# %%makeinstall
make DESTDIR=%buildroot install-strip
# Remove the icon cache file "make install" generates, to avoid package conflicts.
rm -f $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/icon-theme.cache

%if 0%{?suse_version}
%suse_update_desktop_file -n %{name}


# There are some png file duplicates, hardlink them.
%if 0%{?suse_version} >= 1030
%fdupes
%endif


# We install icons, so this is needed.
%if 0%{?suse_version} >= 1140
%post
%icon_theme_cache_post

%postun
%icon_theme_cache_postun
%endif

# endif suse
%endif


%if 0%{?fedora_version}
# We still retain gsmartcontrol-root for consistency with other distributions.

# Make the desktop file run gsmartcontrol instead of gsmartcontrol-root
sed "s|gsmartcontrol-root|gsmartcontrol|g" %{buildroot}%{_datadir}/applications/gsmartcontrol.desktop > %{buildroot}%{_datadir}/applications/gsmartcontrol.desktop.new
mv -f %{buildroot}%{_datadir}/applications/gsmartcontrol.desktop.new %{buildroot}%{_datadir}/applications/gsmartcontrol.desktop

# The rest is taken from the official fedora spec:
# http://pkgs.fedoraproject.org/cgit/gsmartcontrol.git/tree/

# Set up for console-helper
mkdir -p %{buildroot}%{_sbindir}
# Add a copy as "gsmartcontrol-noroot", since gsmartcontrol will always
# ask for root password.
cp %{buildroot}%{_bindir}/%{name} %{buildroot}%{_bindir}/%{name}-noroot
mv %{buildroot}%{_bindir}/%{name} %{buildroot}%{_sbindir}/%{name}
ln -s consolehelper %{buildroot}%{_bindir}/%{name}

mkdir -p %{buildroot}%{_sysconfdir}/pam.d
cat <<EOF >%{buildroot}%{_sysconfdir}/pam.d/%{name}
#%%PAM-1.0
auth		include		config-util
account		include		config-util
session		include		config-util
EOF

mkdir -p %{buildroot}%{_sysconfdir}/security/console.apps
cat <<EOF >%{buildroot}%{_sysconfdir}/security/console.apps/%{name}
USER=root
PROGRAM=/usr/sbin/gsmartcontrol
SESSION=true
EOF

# endif fedora
%endif


%if 0%{?mandriva_version}
desktop-file-install --vendor="" \
	--remove-category="Application" \
	--add-category="System" \
	--add-category="X-MandrivaLinux-System-Configuration-Hardware;Settings;HardwareSettings" \
	--dir $RPM_BUILD_ROOT%{_datadir}/applications $RPM_BUILD_ROOT%{_datadir}/applications/%{name}.desktop
%endif


%clean
rm -rf %buildroot


%files
%defattr(-,root,root)

%attr(0755,root,root) %{_bindir}/*
# %%attr(0644,root,root) %%config(noreplace) %%{_sysconfdir}/*

%doc %{_datadir}/doc/gsmartcontrol
%doc %{_mandir}/man1/*

%{_datadir}/gsmartcontrol
# %%{_datadir}/gsmartcontrol/*
%{_datadir}/applications/*.desktop
%{_datadir}/icons/*
%{_datadir}/pixmaps/*

%if 0%{?fedora_version}
%config(noreplace) %{_sysconfdir}/pam.d/%{name}
%config(noreplace) %{_sysconfdir}/security/console.apps/%{name}
%{_sbindir}/gsmartcontrol
%endif

%changelog
