//
// h225_1.cxx
//
// Code automatically generated by asnparse.
//

#ifdef P_USE_PRAGMA
#pragma implementation "h225.h"
#endif

#include <ptlib.h>
#include "h225.h"

#define new PNEW


#if ! H323_DISABLE_H225

#include "h235_t.cxx"



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ReleaseCompleteReason[]={
      {"noBandwidth",0}
     ,{"gatekeeperResources",1}
     ,{"unreachableDestination",2}
     ,{"destinationRejection",3}
     ,{"invalidRevision",4}
     ,{"noPermission",5}
     ,{"unreachableGatekeeper",6}
     ,{"gatewayResources",7}
     ,{"badFormatAddress",8}
     ,{"adaptiveBusy",9}
     ,{"inConf",10}
     ,{"undefinedReason",11}
     ,{"facilityCallDeflection",12}
     ,{"securityDenied",13}
     ,{"calledPartyNotRegistered",14}
     ,{"callerNotRegistered",15}
     ,{"newConnectionNeeded",16}
     ,{"nonStandardReason",17}
     ,{"replaceWithConferenceInvite",18}
     ,{"genericDataReason",19}
     ,{"neededFeatureNotSupported",20}
     ,{"tunnelledSignallingRejected",21}
     ,{"invalidCID",22}
     ,{"securityError",23}
     ,{"hopCountExceeded",24}
};
#endif
//
// ReleaseCompleteReason
//

H225_ReleaseCompleteReason::H225_ReleaseCompleteReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 12, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ReleaseCompleteReason,25
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_ReleaseCompleteReason::operator H225_NonStandardParameter &() const
#else
H225_ReleaseCompleteReason::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_ReleaseCompleteReason::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_ReleaseCompleteReason::operator H225_ConferenceIdentifier &() const
#else
H225_ReleaseCompleteReason::operator H225_ConferenceIdentifier &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ConferenceIdentifier), PInvalidCast);
#endif
  return *(H225_ConferenceIdentifier *)choice;
}


H225_ReleaseCompleteReason::operator const H225_ConferenceIdentifier &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ConferenceIdentifier), PInvalidCast);
#endif
  return *(H225_ConferenceIdentifier *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_ReleaseCompleteReason::operator H225_SecurityErrors &() const
#else
H225_ReleaseCompleteReason::operator H225_SecurityErrors &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors), PInvalidCast);
#endif
  return *(H225_SecurityErrors *)choice;
}


H225_ReleaseCompleteReason::operator const H225_SecurityErrors &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors), PInvalidCast);
#endif
  return *(H225_SecurityErrors *)choice;
}


PBoolean H225_ReleaseCompleteReason::CreateObject()
{
  switch (tag) {
    case e_noBandwidth :
    case e_gatekeeperResources :
    case e_unreachableDestination :
    case e_destinationRejection :
    case e_invalidRevision :
    case e_noPermission :
    case e_unreachableGatekeeper :
    case e_gatewayResources :
    case e_badFormatAddress :
    case e_adaptiveBusy :
    case e_inConf :
    case e_undefinedReason :
    case e_facilityCallDeflection :
    case e_securityDenied :
    case e_calledPartyNotRegistered :
    case e_callerNotRegistered :
    case e_newConnectionNeeded :
    case e_genericDataReason :
    case e_neededFeatureNotSupported :
    case e_tunnelledSignallingRejected :
    case e_invalidCID :
    case e_hopCountExceeded :
      choice = new PASN_Null();
      return TRUE;
    case e_nonStandardReason :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_replaceWithConferenceInvite :
      choice = new H225_ConferenceIdentifier();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_ReleaseCompleteReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ReleaseCompleteReason::Class()), PInvalidCast);
#endif
  return new H225_ReleaseCompleteReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ScnConnectionType[]={
      {"unknown",0}
     ,{"bChannel",1}
     ,{"hybrid2x64",2}
     ,{"hybrid384",3}
     ,{"hybrid1536",4}
     ,{"hybrid1920",5}
     ,{"multirate",6}
};
#endif
//
// ScnConnectionType
//

H225_ScnConnectionType::H225_ScnConnectionType(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 7, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ScnConnectionType,7
#endif
)
{
}


PBoolean H225_ScnConnectionType::CreateObject()
{
  choice = (tag <= e_multirate) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_ScnConnectionType::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ScnConnectionType::Class()), PInvalidCast);
#endif
  return new H225_ScnConnectionType(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ScnConnectionAggregation[]={
      {"auto",0}
     ,{"none",1}
     ,{"h221",2}
     ,{"bonded_mode1",3}
     ,{"bonded_mode2",4}
     ,{"bonded_mode3",5}
};
#endif
//
// ScnConnectionAggregation
//

H225_ScnConnectionAggregation::H225_ScnConnectionAggregation(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 6, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ScnConnectionAggregation,6
#endif
)
{
}


PBoolean H225_ScnConnectionAggregation::CreateObject()
{
  choice = (tag <= e_bonded_mode3) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_ScnConnectionAggregation::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ScnConnectionAggregation::Class()), PInvalidCast);
#endif
  return new H225_ScnConnectionAggregation(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_PresentationIndicator[]={
      {"presentationAllowed",0}
     ,{"presentationRestricted",1}
     ,{"addressNotAvailable",2}
};
#endif
//
// PresentationIndicator
//

H225_PresentationIndicator::H225_PresentationIndicator(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_PresentationIndicator,3
#endif
)
{
}


PBoolean H225_PresentationIndicator::CreateObject()
{
  choice = (tag <= e_addressNotAvailable) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_PresentationIndicator::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_PresentationIndicator::Class()), PInvalidCast);
#endif
  return new H225_PresentationIndicator(*this);
}


#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ScreeningIndicator[]={
        {"userProvidedNotScreened",0}
       ,{"userProvidedVerifiedAndPassed",1}
       ,{"userProvidedVerifiedAndFailed",2}
       ,{"networkProvided",3}
};
#endif
//
// ScreeningIndicator
//

H225_ScreeningIndicator::H225_ScreeningIndicator(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Enumeration(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ScreeningIndicator,4
#endif
    )
{
}


H225_ScreeningIndicator & H225_ScreeningIndicator::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H225_ScreeningIndicator::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ScreeningIndicator::Class()), PInvalidCast);
#endif
  return new H225_ScreeningIndicator(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_FacilityReason[]={
      {"routeCallToGatekeeper",0}
     ,{"callForwarded",1}
     ,{"routeCallToMC",2}
     ,{"undefinedReason",3}
     ,{"conferenceListChoice",4}
     ,{"startH245",5}
     ,{"noH245",6}
     ,{"newTokens",7}
     ,{"featureSetUpdate",8}
     ,{"forwardedElements",9}
     ,{"transportedInformation",10}
};
#endif
//
// FacilityReason
//

H225_FacilityReason::H225_FacilityReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_FacilityReason,11
#endif
)
{
}


PBoolean H225_FacilityReason::CreateObject()
{
  choice = (tag <= e_transportedInformation) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_FacilityReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_FacilityReason::Class()), PInvalidCast);
#endif
  return new H225_FacilityReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_TransportAddress[]={
      {"ipAddress",0}
     ,{"ipSourceRoute",1}
     ,{"ipxAddress",2}
     ,{"ip6Address",3}
     ,{"netBios",4}
     ,{"nsap",5}
     ,{"nonStandardAddress",6}
};
#endif
//
// TransportAddress
//

H225_TransportAddress::H225_TransportAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 7, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_TransportAddress,7
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TransportAddress::operator H225_TransportAddress_ipAddress &() const
#else
H225_TransportAddress::operator H225_TransportAddress_ipAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ipAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress_ipAddress *)choice;
}


H225_TransportAddress::operator const H225_TransportAddress_ipAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ipAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress_ipAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TransportAddress::operator H225_TransportAddress_ipSourceRoute &() const
#else
H225_TransportAddress::operator H225_TransportAddress_ipSourceRoute &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ipSourceRoute), PInvalidCast);
#endif
  return *(H225_TransportAddress_ipSourceRoute *)choice;
}


H225_TransportAddress::operator const H225_TransportAddress_ipSourceRoute &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ipSourceRoute), PInvalidCast);
#endif
  return *(H225_TransportAddress_ipSourceRoute *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TransportAddress::operator H225_TransportAddress_ipxAddress &() const
#else
H225_TransportAddress::operator H225_TransportAddress_ipxAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ipxAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress_ipxAddress *)choice;
}


H225_TransportAddress::operator const H225_TransportAddress_ipxAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ipxAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress_ipxAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TransportAddress::operator H225_TransportAddress_ip6Address &() const
#else
H225_TransportAddress::operator H225_TransportAddress_ip6Address &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ip6Address), PInvalidCast);
#endif
  return *(H225_TransportAddress_ip6Address *)choice;
}


H225_TransportAddress::operator const H225_TransportAddress_ip6Address &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress_ip6Address), PInvalidCast);
#endif
  return *(H225_TransportAddress_ip6Address *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TransportAddress::operator H225_NonStandardParameter &() const
#else
H225_TransportAddress::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_TransportAddress::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


PBoolean H225_TransportAddress::CreateObject()
{
  switch (tag) {
    case e_ipAddress :
      choice = new H225_TransportAddress_ipAddress();
      return TRUE;
    case e_ipSourceRoute :
      choice = new H225_TransportAddress_ipSourceRoute();
      return TRUE;
    case e_ipxAddress :
      choice = new H225_TransportAddress_ipxAddress();
      return TRUE;
    case e_ip6Address :
      choice = new H225_TransportAddress_ip6Address();
      return TRUE;
    case e_netBios :
      choice = new PASN_OctetString();
      choice->SetConstraints(PASN_Object::FixedConstraint, 16);
      return TRUE;
    case e_nsap :
      choice = new PASN_OctetString();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 20);
      return TRUE;
    case e_nonStandardAddress :
      choice = new H225_NonStandardParameter();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_TransportAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TransportAddress::Class()), PInvalidCast);
#endif
  return new H225_TransportAddress(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_SupportedProtocols[]={
      {"nonStandardData",0}
     ,{"h310",1}
     ,{"h320",2}
     ,{"h321",3}
     ,{"h322",4}
     ,{"h323",5}
     ,{"h324",6}
     ,{"voice",7}
     ,{"t120_only",8}
     ,{"nonStandardProtocol",9}
     ,{"t38FaxAnnexbOnly",10}
     ,{"sip",11}
};
#endif
//
// SupportedProtocols
//

H225_SupportedProtocols::H225_SupportedProtocols(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 9, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_SupportedProtocols,12
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_NonStandardParameter &() const
#else
H225_SupportedProtocols::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_SupportedProtocols::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_H310Caps &() const
#else
H225_SupportedProtocols::operator H225_H310Caps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H310Caps), PInvalidCast);
#endif
  return *(H225_H310Caps *)choice;
}


H225_SupportedProtocols::operator const H225_H310Caps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H310Caps), PInvalidCast);
#endif
  return *(H225_H310Caps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_H320Caps &() const
#else
H225_SupportedProtocols::operator H225_H320Caps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H320Caps), PInvalidCast);
#endif
  return *(H225_H320Caps *)choice;
}


H225_SupportedProtocols::operator const H225_H320Caps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H320Caps), PInvalidCast);
#endif
  return *(H225_H320Caps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_H321Caps &() const
#else
H225_SupportedProtocols::operator H225_H321Caps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H321Caps), PInvalidCast);
#endif
  return *(H225_H321Caps *)choice;
}


H225_SupportedProtocols::operator const H225_H321Caps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H321Caps), PInvalidCast);
#endif
  return *(H225_H321Caps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_H322Caps &() const
#else
H225_SupportedProtocols::operator H225_H322Caps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H322Caps), PInvalidCast);
#endif
  return *(H225_H322Caps *)choice;
}


H225_SupportedProtocols::operator const H225_H322Caps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H322Caps), PInvalidCast);
#endif
  return *(H225_H322Caps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_H323Caps &() const
#else
H225_SupportedProtocols::operator H225_H323Caps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H323Caps), PInvalidCast);
#endif
  return *(H225_H323Caps *)choice;
}


H225_SupportedProtocols::operator const H225_H323Caps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H323Caps), PInvalidCast);
#endif
  return *(H225_H323Caps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_H324Caps &() const
#else
H225_SupportedProtocols::operator H225_H324Caps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H324Caps), PInvalidCast);
#endif
  return *(H225_H324Caps *)choice;
}


H225_SupportedProtocols::operator const H225_H324Caps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H324Caps), PInvalidCast);
#endif
  return *(H225_H324Caps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_VoiceCaps &() const
#else
H225_SupportedProtocols::operator H225_VoiceCaps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_VoiceCaps), PInvalidCast);
#endif
  return *(H225_VoiceCaps *)choice;
}


H225_SupportedProtocols::operator const H225_VoiceCaps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_VoiceCaps), PInvalidCast);
#endif
  return *(H225_VoiceCaps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_T120OnlyCaps &() const
#else
H225_SupportedProtocols::operator H225_T120OnlyCaps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_T120OnlyCaps), PInvalidCast);
#endif
  return *(H225_T120OnlyCaps *)choice;
}


H225_SupportedProtocols::operator const H225_T120OnlyCaps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_T120OnlyCaps), PInvalidCast);
#endif
  return *(H225_T120OnlyCaps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_NonStandardProtocol &() const
#else
H225_SupportedProtocols::operator H225_NonStandardProtocol &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardProtocol), PInvalidCast);
#endif
  return *(H225_NonStandardProtocol *)choice;
}


H225_SupportedProtocols::operator const H225_NonStandardProtocol &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardProtocol), PInvalidCast);
#endif
  return *(H225_NonStandardProtocol *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_T38FaxAnnexbOnlyCaps &() const
#else
H225_SupportedProtocols::operator H225_T38FaxAnnexbOnlyCaps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_T38FaxAnnexbOnlyCaps), PInvalidCast);
#endif
  return *(H225_T38FaxAnnexbOnlyCaps *)choice;
}


H225_SupportedProtocols::operator const H225_T38FaxAnnexbOnlyCaps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_T38FaxAnnexbOnlyCaps), PInvalidCast);
#endif
  return *(H225_T38FaxAnnexbOnlyCaps *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SupportedProtocols::operator H225_SIPCaps &() const
#else
H225_SupportedProtocols::operator H225_SIPCaps &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SIPCaps), PInvalidCast);
#endif
  return *(H225_SIPCaps *)choice;
}


H225_SupportedProtocols::operator const H225_SIPCaps &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SIPCaps), PInvalidCast);
#endif
  return *(H225_SIPCaps *)choice;
}


PBoolean H225_SupportedProtocols::CreateObject()
{
  switch (tag) {
    case e_nonStandardData :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_h310 :
      choice = new H225_H310Caps();
      return TRUE;
    case e_h320 :
      choice = new H225_H320Caps();
      return TRUE;
    case e_h321 :
      choice = new H225_H321Caps();
      return TRUE;
    case e_h322 :
      choice = new H225_H322Caps();
      return TRUE;
    case e_h323 :
      choice = new H225_H323Caps();
      return TRUE;
    case e_h324 :
      choice = new H225_H324Caps();
      return TRUE;
    case e_voice :
      choice = new H225_VoiceCaps();
      return TRUE;
    case e_t120_only :
      choice = new H225_T120OnlyCaps();
      return TRUE;
    case e_nonStandardProtocol :
      choice = new H225_NonStandardProtocol();
      return TRUE;
    case e_t38FaxAnnexbOnly :
      choice = new H225_T38FaxAnnexbOnlyCaps();
      return TRUE;
    case e_sip :
      choice = new H225_SIPCaps();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_SupportedProtocols::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_SupportedProtocols::Class()), PInvalidCast);
#endif
  return new H225_SupportedProtocols(*this);
}


//
// H221NonStandard
//

H225_H221NonStandard::H225_H221NonStandard(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
  m_t35CountryCode.SetConstraints(PASN_Object::FixedConstraint, 0, 255);
  m_t35Extension.SetConstraints(PASN_Object::FixedConstraint, 0, 255);
  m_manufacturerCode.SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


#ifndef PASN_NOPRINTON
void H225_H221NonStandard::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+17) << "t35CountryCode = " << setprecision(indent) << m_t35CountryCode << '\n';
  strm << setw(indent+15) << "t35Extension = " << setprecision(indent) << m_t35Extension << '\n';
  strm << setw(indent+19) << "manufacturerCode = " << setprecision(indent) << m_manufacturerCode << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_H221NonStandard::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_H221NonStandard), PInvalidCast);
#endif
  const H225_H221NonStandard & other = (const H225_H221NonStandard &)obj;

  Comparison result;

  if ((result = m_t35CountryCode.Compare(other.m_t35CountryCode)) != EqualTo)
    return result;
  if ((result = m_t35Extension.Compare(other.m_t35Extension)) != EqualTo)
    return result;
  if ((result = m_manufacturerCode.Compare(other.m_manufacturerCode)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_H221NonStandard::GetDataLength() const
{
  PINDEX length = 0;
  length += m_t35CountryCode.GetObjectLength();
  length += m_t35Extension.GetObjectLength();
  length += m_manufacturerCode.GetObjectLength();
  return length;
}


PBoolean H225_H221NonStandard::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_t35CountryCode.Decode(strm))
    return FALSE;
  if (!m_t35Extension.Decode(strm))
    return FALSE;
  if (!m_manufacturerCode.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_H221NonStandard::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_t35CountryCode.Encode(strm);
  m_t35Extension.Encode(strm);
  m_manufacturerCode.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_H221NonStandard::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_H221NonStandard::Class()), PInvalidCast);
#endif
  return new H225_H221NonStandard(*this);
}


//
// TunnelledProtocolAlternateIdentifier
//

H225_TunnelledProtocolAlternateIdentifier::H225_TunnelledProtocolAlternateIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 1, TRUE, 0)
{
  m_protocolType.SetConstraints(PASN_Object::FixedConstraint, 1, 64);
  m_protocolVariant.SetConstraints(PASN_Object::FixedConstraint, 1, 64);
}


#ifndef PASN_NOPRINTON
void H225_TunnelledProtocolAlternateIdentifier::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+15) << "protocolType = " << setprecision(indent) << m_protocolType << '\n';
  if (HasOptionalField(e_protocolVariant))
    strm << setw(indent+18) << "protocolVariant = " << setprecision(indent) << m_protocolVariant << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_TunnelledProtocolAlternateIdentifier::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_TunnelledProtocolAlternateIdentifier), PInvalidCast);
#endif
  const H225_TunnelledProtocolAlternateIdentifier & other = (const H225_TunnelledProtocolAlternateIdentifier &)obj;

  Comparison result;

  if ((result = m_protocolType.Compare(other.m_protocolType)) != EqualTo)
    return result;
  if ((result = m_protocolVariant.Compare(other.m_protocolVariant)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_TunnelledProtocolAlternateIdentifier::GetDataLength() const
{
  PINDEX length = 0;
  length += m_protocolType.GetObjectLength();
  if (HasOptionalField(e_protocolVariant))
    length += m_protocolVariant.GetObjectLength();
  return length;
}


PBoolean H225_TunnelledProtocolAlternateIdentifier::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_protocolType.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_protocolVariant) && !m_protocolVariant.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_TunnelledProtocolAlternateIdentifier::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_protocolType.Encode(strm);
  if (HasOptionalField(e_protocolVariant))
    m_protocolVariant.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_TunnelledProtocolAlternateIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TunnelledProtocolAlternateIdentifier::Class()), PInvalidCast);
#endif
  return new H225_TunnelledProtocolAlternateIdentifier(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_NonStandardIdentifier[]={
      {"object",0}
     ,{"h221NonStandard",1}
};
#endif
//
// NonStandardIdentifier
//

H225_NonStandardIdentifier::H225_NonStandardIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_NonStandardIdentifier,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_NonStandardIdentifier::operator H225_H221NonStandard &() const
#else
H225_NonStandardIdentifier::operator H225_H221NonStandard &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H221NonStandard), PInvalidCast);
#endif
  return *(H225_H221NonStandard *)choice;
}


H225_NonStandardIdentifier::operator const H225_H221NonStandard &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H221NonStandard), PInvalidCast);
#endif
  return *(H225_H221NonStandard *)choice;
}


PBoolean H225_NonStandardIdentifier::CreateObject()
{
  switch (tag) {
    case e_object :
      choice = new PASN_ObjectId();
      return TRUE;
    case e_h221NonStandard :
      choice = new H225_H221NonStandard();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_NonStandardIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_NonStandardIdentifier::Class()), PInvalidCast);
#endif
  return new H225_NonStandardIdentifier(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_AliasAddress[]={
      {"dialedDigits",0}
     ,{"h323_ID",1}
     ,{"url_ID",2}
     ,{"transportID",3}
     ,{"email_ID",4}
     ,{"partyNumber",5}
     ,{"mobileUIM",6}
     ,{"isupNumber",7}
};
#endif
//
// AliasAddress
//

H225_AliasAddress::H225_AliasAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_AliasAddress,8
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AliasAddress::operator H225_TransportAddress &() const
#else
H225_AliasAddress::operator H225_TransportAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress *)choice;
}


H225_AliasAddress::operator const H225_TransportAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AliasAddress::operator H225_PartyNumber &() const
#else
H225_AliasAddress::operator H225_PartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_PartyNumber), PInvalidCast);
#endif
  return *(H225_PartyNumber *)choice;
}


H225_AliasAddress::operator const H225_PartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_PartyNumber), PInvalidCast);
#endif
  return *(H225_PartyNumber *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AliasAddress::operator H225_MobileUIM &() const
#else
H225_AliasAddress::operator H225_MobileUIM &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_MobileUIM), PInvalidCast);
#endif
  return *(H225_MobileUIM *)choice;
}


H225_AliasAddress::operator const H225_MobileUIM &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_MobileUIM), PInvalidCast);
#endif
  return *(H225_MobileUIM *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AliasAddress::operator H225_IsupNumber &() const
#else
H225_AliasAddress::operator H225_IsupNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupNumber), PInvalidCast);
#endif
  return *(H225_IsupNumber *)choice;
}


H225_AliasAddress::operator const H225_IsupNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupNumber), PInvalidCast);
#endif
  return *(H225_IsupNumber *)choice;
}


PBoolean H225_AliasAddress::CreateObject()
{
  switch (tag) {
    case e_dialedDigits :
      choice = new PASN_IA5String();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 128);
      choice->SetCharacterSet(PASN_Object::FixedConstraint, "0123456789#*,");
      return TRUE;
    case e_h323_ID :
      choice = new PASN_BMPString();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 256);
      return TRUE;
    case e_url_ID :
      choice = new PASN_IA5String();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 512);
      return TRUE;
    case e_transportID :
      choice = new H225_TransportAddress();
      return TRUE;
    case e_email_ID :
      choice = new PASN_IA5String();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 512);
      return TRUE;
    case e_partyNumber :
      choice = new H225_PartyNumber();
      return TRUE;
    case e_mobileUIM :
      choice = new H225_MobileUIM();
      return TRUE;
    case e_isupNumber :
      choice = new H225_IsupNumber();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_AliasAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_AliasAddress::Class()), PInvalidCast);
#endif
  return new H225_AliasAddress(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_AddressPattern[]={
      {"wildcard",0}
     ,{"range",1}
};
#endif
//
// AddressPattern
//

H225_AddressPattern::H225_AddressPattern(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_AddressPattern,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AddressPattern::operator H225_AliasAddress &() const
#else
H225_AddressPattern::operator H225_AliasAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AliasAddress), PInvalidCast);
#endif
  return *(H225_AliasAddress *)choice;
}


H225_AddressPattern::operator const H225_AliasAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AliasAddress), PInvalidCast);
#endif
  return *(H225_AliasAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AddressPattern::operator H225_AddressPattern_range &() const
#else
H225_AddressPattern::operator H225_AddressPattern_range &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AddressPattern_range), PInvalidCast);
#endif
  return *(H225_AddressPattern_range *)choice;
}


H225_AddressPattern::operator const H225_AddressPattern_range &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AddressPattern_range), PInvalidCast);
#endif
  return *(H225_AddressPattern_range *)choice;
}


PBoolean H225_AddressPattern::CreateObject()
{
  switch (tag) {
    case e_wildcard :
      choice = new H225_AliasAddress();
      return TRUE;
    case e_range :
      choice = new H225_AddressPattern_range();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_AddressPattern::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_AddressPattern::Class()), PInvalidCast);
#endif
  return new H225_AddressPattern(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_PartyNumber[]={
      {"e164Number",0}
     ,{"dataPartyNumber",1}
     ,{"telexPartyNumber",2}
     ,{"privateNumber",3}
     ,{"nationalStandardPartyNumber",4}
};
#endif
//
// PartyNumber
//

H225_PartyNumber::H225_PartyNumber(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 5, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_PartyNumber,5
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_PartyNumber::operator H225_PublicPartyNumber &() const
#else
H225_PartyNumber::operator H225_PublicPartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_PublicPartyNumber), PInvalidCast);
#endif
  return *(H225_PublicPartyNumber *)choice;
}


H225_PartyNumber::operator const H225_PublicPartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_PublicPartyNumber), PInvalidCast);
#endif
  return *(H225_PublicPartyNumber *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_PartyNumber::operator H225_NumberDigits &() const
#else
H225_PartyNumber::operator H225_NumberDigits &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NumberDigits), PInvalidCast);
#endif
  return *(H225_NumberDigits *)choice;
}


H225_PartyNumber::operator const H225_NumberDigits &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NumberDigits), PInvalidCast);
#endif
  return *(H225_NumberDigits *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_PartyNumber::operator H225_PrivatePartyNumber &() const
#else
H225_PartyNumber::operator H225_PrivatePartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_PrivatePartyNumber), PInvalidCast);
#endif
  return *(H225_PrivatePartyNumber *)choice;
}


H225_PartyNumber::operator const H225_PrivatePartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_PrivatePartyNumber), PInvalidCast);
#endif
  return *(H225_PrivatePartyNumber *)choice;
}


PBoolean H225_PartyNumber::CreateObject()
{
  switch (tag) {
    case e_e164Number :
      choice = new H225_PublicPartyNumber();
      return TRUE;
    case e_dataPartyNumber :
    case e_telexPartyNumber :
    case e_nationalStandardPartyNumber :
      choice = new H225_NumberDigits();
      return TRUE;
    case e_privateNumber :
      choice = new H225_PrivatePartyNumber();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_PartyNumber::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_PartyNumber::Class()), PInvalidCast);
#endif
  return new H225_PartyNumber(*this);
}


//
// NumberDigits
//

H225_NumberDigits::H225_NumberDigits(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_IA5String(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 128);
  SetCharacterSet(PASN_Object::FixedConstraint, "0123456789#*,");
}


H225_NumberDigits & H225_NumberDigits::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_NumberDigits & H225_NumberDigits::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_NumberDigits::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_NumberDigits::Class()), PInvalidCast);
#endif
  return new H225_NumberDigits(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_PublicTypeOfNumber[]={
      {"unknown",0}
     ,{"internationalNumber",1}
     ,{"nationalNumber",2}
     ,{"networkSpecificNumber",3}
     ,{"subscriberNumber",4}
     ,{"abbreviatedNumber",5}
};
#endif
//
// PublicTypeOfNumber
//

H225_PublicTypeOfNumber::H225_PublicTypeOfNumber(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 6, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_PublicTypeOfNumber,6
#endif
)
{
}


PBoolean H225_PublicTypeOfNumber::CreateObject()
{
  choice = (tag <= e_abbreviatedNumber) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_PublicTypeOfNumber::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_PublicTypeOfNumber::Class()), PInvalidCast);
#endif
  return new H225_PublicTypeOfNumber(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_PrivateTypeOfNumber[]={
      {"unknown",0}
     ,{"level2RegionalNumber",1}
     ,{"level1RegionalNumber",2}
     ,{"pISNSpecificNumber",3}
     ,{"localNumber",4}
     ,{"abbreviatedNumber",5}
};
#endif
//
// PrivateTypeOfNumber
//

H225_PrivateTypeOfNumber::H225_PrivateTypeOfNumber(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 6, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_PrivateTypeOfNumber,6
#endif
)
{
}


PBoolean H225_PrivateTypeOfNumber::CreateObject()
{
  choice = (tag <= e_abbreviatedNumber) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_PrivateTypeOfNumber::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_PrivateTypeOfNumber::Class()), PInvalidCast);
#endif
  return new H225_PrivateTypeOfNumber(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_MobileUIM[]={
      {"ansi_41_uim",0}
     ,{"gsm_uim",1}
};
#endif
//
// MobileUIM
//

H225_MobileUIM::H225_MobileUIM(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_MobileUIM,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_MobileUIM::operator H225_ANSI_41_UIM &() const
#else
H225_MobileUIM::operator H225_ANSI_41_UIM &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ANSI_41_UIM), PInvalidCast);
#endif
  return *(H225_ANSI_41_UIM *)choice;
}


H225_MobileUIM::operator const H225_ANSI_41_UIM &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ANSI_41_UIM), PInvalidCast);
#endif
  return *(H225_ANSI_41_UIM *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_MobileUIM::operator H225_GSM_UIM &() const
#else
H225_MobileUIM::operator H225_GSM_UIM &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GSM_UIM), PInvalidCast);
#endif
  return *(H225_GSM_UIM *)choice;
}


H225_MobileUIM::operator const H225_GSM_UIM &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GSM_UIM), PInvalidCast);
#endif
  return *(H225_GSM_UIM *)choice;
}


PBoolean H225_MobileUIM::CreateObject()
{
  switch (tag) {
    case e_ansi_41_uim :
      choice = new H225_ANSI_41_UIM();
      return TRUE;
    case e_gsm_uim :
      choice = new H225_GSM_UIM();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_MobileUIM::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_MobileUIM::Class()), PInvalidCast);
#endif
  return new H225_MobileUIM(*this);
}


//
// TBCD-STRING
//

H225_TBCD_STRING::H225_TBCD_STRING(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_IA5String(tag, tagClass)
{
  SetCharacterSet(PASN_Object::FixedConstraint, "0123456789#*abc");
}


H225_TBCD_STRING & H225_TBCD_STRING::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_TBCD_STRING & H225_TBCD_STRING::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_TBCD_STRING::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TBCD_STRING::Class()), PInvalidCast);
#endif
  return new H225_TBCD_STRING(*this);
}


//
// GSM-UIM
//

H225_GSM_UIM::H225_GSM_UIM(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 6, TRUE, 0)
{
  m_imsi.SetConstraints(PASN_Object::FixedConstraint, 3, 16);
  m_tmsi.SetConstraints(PASN_Object::FixedConstraint, 1, 4);
  m_msisdn.SetConstraints(PASN_Object::FixedConstraint, 3, 16);
  m_imei.SetConstraints(PASN_Object::FixedConstraint, 15, 16);
  m_hplmn.SetConstraints(PASN_Object::FixedConstraint, 1, 4);
  m_vplmn.SetConstraints(PASN_Object::FixedConstraint, 1, 4);
}


#ifndef PASN_NOPRINTON
void H225_GSM_UIM::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_imsi))
    strm << setw(indent+7) << "imsi = " << setprecision(indent) << m_imsi << '\n';
  if (HasOptionalField(e_tmsi))
    strm << setw(indent+7) << "tmsi = " << setprecision(indent) << m_tmsi << '\n';
  if (HasOptionalField(e_msisdn))
    strm << setw(indent+9) << "msisdn = " << setprecision(indent) << m_msisdn << '\n';
  if (HasOptionalField(e_imei))
    strm << setw(indent+7) << "imei = " << setprecision(indent) << m_imei << '\n';
  if (HasOptionalField(e_hplmn))
    strm << setw(indent+8) << "hplmn = " << setprecision(indent) << m_hplmn << '\n';
  if (HasOptionalField(e_vplmn))
    strm << setw(indent+8) << "vplmn = " << setprecision(indent) << m_vplmn << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_GSM_UIM::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_GSM_UIM), PInvalidCast);
#endif
  const H225_GSM_UIM & other = (const H225_GSM_UIM &)obj;

  Comparison result;

  if ((result = m_imsi.Compare(other.m_imsi)) != EqualTo)
    return result;
  if ((result = m_tmsi.Compare(other.m_tmsi)) != EqualTo)
    return result;
  if ((result = m_msisdn.Compare(other.m_msisdn)) != EqualTo)
    return result;
  if ((result = m_imei.Compare(other.m_imei)) != EqualTo)
    return result;
  if ((result = m_hplmn.Compare(other.m_hplmn)) != EqualTo)
    return result;
  if ((result = m_vplmn.Compare(other.m_vplmn)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_GSM_UIM::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_imsi))
    length += m_imsi.GetObjectLength();
  if (HasOptionalField(e_tmsi))
    length += m_tmsi.GetObjectLength();
  if (HasOptionalField(e_msisdn))
    length += m_msisdn.GetObjectLength();
  if (HasOptionalField(e_imei))
    length += m_imei.GetObjectLength();
  if (HasOptionalField(e_hplmn))
    length += m_hplmn.GetObjectLength();
  if (HasOptionalField(e_vplmn))
    length += m_vplmn.GetObjectLength();
  return length;
}


PBoolean H225_GSM_UIM::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_imsi) && !m_imsi.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_tmsi) && !m_tmsi.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_msisdn) && !m_msisdn.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_imei) && !m_imei.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_hplmn) && !m_hplmn.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_vplmn) && !m_vplmn.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_GSM_UIM::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_imsi))
    m_imsi.Encode(strm);
  if (HasOptionalField(e_tmsi))
    m_tmsi.Encode(strm);
  if (HasOptionalField(e_msisdn))
    m_msisdn.Encode(strm);
  if (HasOptionalField(e_imei))
    m_imei.Encode(strm);
  if (HasOptionalField(e_hplmn))
    m_hplmn.Encode(strm);
  if (HasOptionalField(e_vplmn))
    m_vplmn.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_GSM_UIM::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_GSM_UIM::Class()), PInvalidCast);
#endif
  return new H225_GSM_UIM(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_IsupNumber[]={
      {"e164Number",0}
     ,{"dataPartyNumber",1}
     ,{"telexPartyNumber",2}
     ,{"privateNumber",3}
     ,{"nationalStandardPartyNumber",4}
};
#endif
//
// IsupNumber
//

H225_IsupNumber::H225_IsupNumber(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 5, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_IsupNumber,5
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_IsupNumber::operator H225_IsupPublicPartyNumber &() const
#else
H225_IsupNumber::operator H225_IsupPublicPartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupPublicPartyNumber), PInvalidCast);
#endif
  return *(H225_IsupPublicPartyNumber *)choice;
}


H225_IsupNumber::operator const H225_IsupPublicPartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupPublicPartyNumber), PInvalidCast);
#endif
  return *(H225_IsupPublicPartyNumber *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_IsupNumber::operator H225_IsupDigits &() const
#else
H225_IsupNumber::operator H225_IsupDigits &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupDigits), PInvalidCast);
#endif
  return *(H225_IsupDigits *)choice;
}


H225_IsupNumber::operator const H225_IsupDigits &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupDigits), PInvalidCast);
#endif
  return *(H225_IsupDigits *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_IsupNumber::operator H225_IsupPrivatePartyNumber &() const
#else
H225_IsupNumber::operator H225_IsupPrivatePartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupPrivatePartyNumber), PInvalidCast);
#endif
  return *(H225_IsupPrivatePartyNumber *)choice;
}


H225_IsupNumber::operator const H225_IsupPrivatePartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_IsupPrivatePartyNumber), PInvalidCast);
#endif
  return *(H225_IsupPrivatePartyNumber *)choice;
}


PBoolean H225_IsupNumber::CreateObject()
{
  switch (tag) {
    case e_e164Number :
      choice = new H225_IsupPublicPartyNumber();
      return TRUE;
    case e_dataPartyNumber :
    case e_telexPartyNumber :
    case e_nationalStandardPartyNumber :
      choice = new H225_IsupDigits();
      return TRUE;
    case e_privateNumber :
      choice = new H225_IsupPrivatePartyNumber();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_IsupNumber::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_IsupNumber::Class()), PInvalidCast);
#endif
  return new H225_IsupNumber(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_NatureOfAddress[]={
      {"unknown",0}
     ,{"subscriberNumber",1}
     ,{"nationalNumber",2}
     ,{"internationalNumber",3}
     ,{"networkSpecificNumber",4}
     ,{"routingNumberNationalFormat",5}
     ,{"routingNumberNetworkSpecificFormat",6}
     ,{"routingNumberWithCalledDirectoryNumber",7}
};
#endif
//
// NatureOfAddress
//

H225_NatureOfAddress::H225_NatureOfAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 8, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_NatureOfAddress,8
#endif
)
{
}


PBoolean H225_NatureOfAddress::CreateObject()
{
  choice = (tag <= e_routingNumberWithCalledDirectoryNumber) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_NatureOfAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_NatureOfAddress::Class()), PInvalidCast);
#endif
  return new H225_NatureOfAddress(*this);
}


//
// IsupDigits
//

H225_IsupDigits::H225_IsupDigits(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_IA5String(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 128);
  SetCharacterSet(PASN_Object::FixedConstraint, "0123456789ABCDE");
}


H225_IsupDigits & H225_IsupDigits::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_IsupDigits & H225_IsupDigits::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_IsupDigits::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_IsupDigits::Class()), PInvalidCast);
#endif
  return new H225_IsupDigits(*this);
}


//
// ExtendedAliasAddress
//

H225_ExtendedAliasAddress::H225_ExtendedAliasAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_ExtendedAliasAddress::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+10) << "address = " << setprecision(indent) << m_address << '\n';
  if (HasOptionalField(e_presentationIndicator))
    strm << setw(indent+24) << "presentationIndicator = " << setprecision(indent) << m_presentationIndicator << '\n';
  if (HasOptionalField(e_screeningIndicator))
    strm << setw(indent+21) << "screeningIndicator = " << setprecision(indent) << m_screeningIndicator << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_ExtendedAliasAddress::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_ExtendedAliasAddress), PInvalidCast);
#endif
  const H225_ExtendedAliasAddress & other = (const H225_ExtendedAliasAddress &)obj;

  Comparison result;

  if ((result = m_address.Compare(other.m_address)) != EqualTo)
    return result;
  if ((result = m_presentationIndicator.Compare(other.m_presentationIndicator)) != EqualTo)
    return result;
  if ((result = m_screeningIndicator.Compare(other.m_screeningIndicator)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_ExtendedAliasAddress::GetDataLength() const
{
  PINDEX length = 0;
  length += m_address.GetObjectLength();
  if (HasOptionalField(e_presentationIndicator))
    length += m_presentationIndicator.GetObjectLength();
  if (HasOptionalField(e_screeningIndicator))
    length += m_screeningIndicator.GetObjectLength();
  return length;
}


PBoolean H225_ExtendedAliasAddress::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_address.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_presentationIndicator) && !m_presentationIndicator.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_screeningIndicator) && !m_screeningIndicator.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_ExtendedAliasAddress::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_address.Encode(strm);
  if (HasOptionalField(e_presentationIndicator))
    m_presentationIndicator.Encode(strm);
  if (HasOptionalField(e_screeningIndicator))
    m_screeningIndicator.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_ExtendedAliasAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ExtendedAliasAddress::Class()), PInvalidCast);
#endif
  return new H225_ExtendedAliasAddress(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_UseSpecifiedTransport[]={
      {"tcp",0}
     ,{"annexE",1}
     ,{"sctp",2}
};
#endif
//
// UseSpecifiedTransport
//

H225_UseSpecifiedTransport::H225_UseSpecifiedTransport(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_UseSpecifiedTransport,3
#endif
)
{
}


PBoolean H225_UseSpecifiedTransport::CreateObject()
{
  choice = (tag <= e_sctp) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_UseSpecifiedTransport::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_UseSpecifiedTransport::Class()), PInvalidCast);
#endif
  return new H225_UseSpecifiedTransport(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_SecurityServiceMode[]={
      {"nonStandard",0}
     ,{"none",1}
     ,{"default",2}
};
#endif
//
// SecurityServiceMode
//

H225_SecurityServiceMode::H225_SecurityServiceMode(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_SecurityServiceMode,3
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_SecurityServiceMode::operator H225_NonStandardParameter &() const
#else
H225_SecurityServiceMode::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_SecurityServiceMode::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


PBoolean H225_SecurityServiceMode::CreateObject()
{
  switch (tag) {
    case e_nonStandard :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_none :
    case e_default :
      choice = new PASN_Null();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_SecurityServiceMode::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_SecurityServiceMode::Class()), PInvalidCast);
#endif
  return new H225_SecurityServiceMode(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_SecurityErrors[]={
      {"securityWrongSyncTime",0}
     ,{"securityReplay",1}
     ,{"securityWrongGeneralID",2}
     ,{"securityWrongSendersID",3}
     ,{"securityIntegrityFailed",4}
     ,{"securityWrongOID",5}
     ,{"securityDHmismatch",6}
     ,{"securityCertificateExpired",7}
     ,{"securityCertificateDateInvalid",8}
     ,{"securityCertificateRevoked",9}
     ,{"securityCertificateNotReadable",10}
     ,{"securityCertificateSignatureInvalid",11}
     ,{"securityCertificateMissing",12}
     ,{"securityCertificateIncomplete",13}
     ,{"securityUnsupportedCertificateAlgOID",14}
     ,{"securityUnknownCA",15}
};
#endif
//
// SecurityErrors
//

H225_SecurityErrors::H225_SecurityErrors(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 16, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_SecurityErrors,16
#endif
)
{
}


PBoolean H225_SecurityErrors::CreateObject()
{
  choice = (tag <= e_securityUnknownCA) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_SecurityErrors::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_SecurityErrors::Class()), PInvalidCast);
#endif
  return new H225_SecurityErrors(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_SecurityErrors2[]={
      {"securityWrongSyncTime",0}
     ,{"securityReplay",1}
     ,{"securityWrongGeneralID",2}
     ,{"securityWrongSendersID",3}
     ,{"securityIntegrityFailed",4}
     ,{"securityWrongOID",5}
};
#endif
//
// SecurityErrors2
//

H225_SecurityErrors2::H225_SecurityErrors2(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 6, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_SecurityErrors2,6
#endif
)
{
}


PBoolean H225_SecurityErrors2::CreateObject()
{
  choice = (tag <= e_securityWrongOID) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_SecurityErrors2::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_SecurityErrors2::Class()), PInvalidCast);
#endif
  return new H225_SecurityErrors2(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_H245Security[]={
      {"nonStandard",0}
     ,{"noSecurity",1}
     ,{"tls",2}
     ,{"ipsec",3}
};
#endif
//
// H245Security
//

H225_H245Security::H225_H245Security(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_H245Security,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H245Security::operator H225_NonStandardParameter &() const
#else
H225_H245Security::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_H245Security::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H245Security::operator H225_SecurityCapabilities &() const
#else
H225_H245Security::operator H225_SecurityCapabilities &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityCapabilities), PInvalidCast);
#endif
  return *(H225_SecurityCapabilities *)choice;
}


H225_H245Security::operator const H225_SecurityCapabilities &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityCapabilities), PInvalidCast);
#endif
  return *(H225_SecurityCapabilities *)choice;
}


PBoolean H225_H245Security::CreateObject()
{
  switch (tag) {
    case e_nonStandard :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_noSecurity :
      choice = new PASN_Null();
      return TRUE;
    case e_tls :
    case e_ipsec :
      choice = new H225_SecurityCapabilities();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_H245Security::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_H245Security::Class()), PInvalidCast);
#endif
  return new H225_H245Security(*this);
}


//
// Q954Details
//

H225_Q954Details::H225_Q954Details(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_Q954Details::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+20) << "conferenceCalling = " << setprecision(indent) << m_conferenceCalling << '\n';
  strm << setw(indent+20) << "threePartyService = " << setprecision(indent) << m_threePartyService << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_Q954Details::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_Q954Details), PInvalidCast);
#endif
  const H225_Q954Details & other = (const H225_Q954Details &)obj;

  Comparison result;

  if ((result = m_conferenceCalling.Compare(other.m_conferenceCalling)) != EqualTo)
    return result;
  if ((result = m_threePartyService.Compare(other.m_threePartyService)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_Q954Details::GetDataLength() const
{
  PINDEX length = 0;
  length += m_conferenceCalling.GetObjectLength();
  length += m_threePartyService.GetObjectLength();
  return length;
}


PBoolean H225_Q954Details::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_conferenceCalling.Decode(strm))
    return FALSE;
  if (!m_threePartyService.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_Q954Details::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_conferenceCalling.Encode(strm);
  m_threePartyService.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_Q954Details::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_Q954Details::Class()), PInvalidCast);
#endif
  return new H225_Q954Details(*this);
}


//
// GloballyUniqueID
//

H225_GloballyUniqueID::H225_GloballyUniqueID(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 16);
}


H225_GloballyUniqueID::H225_GloballyUniqueID(const char * v)
{
  SetValue(v);
}


H225_GloballyUniqueID::H225_GloballyUniqueID(const PString & v)
{
  SetValue(v);
}


H225_GloballyUniqueID::H225_GloballyUniqueID(const PBYTEArray & v)
{
  SetValue(v);
}


H225_GloballyUniqueID & H225_GloballyUniqueID::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_GloballyUniqueID & H225_GloballyUniqueID::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H225_GloballyUniqueID & H225_GloballyUniqueID::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_GloballyUniqueID::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_GloballyUniqueID::Class()), PInvalidCast);
#endif
  return new H225_GloballyUniqueID(*this);
}


//
// ConferenceIdentifier
//

H225_ConferenceIdentifier::H225_ConferenceIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : H225_GloballyUniqueID(tag, tagClass)
{
}


H225_ConferenceIdentifier::H225_ConferenceIdentifier(const char * v)
{
  SetValue(v);
}


H225_ConferenceIdentifier::H225_ConferenceIdentifier(const PString & v)
{
  SetValue(v);
}


H225_ConferenceIdentifier::H225_ConferenceIdentifier(const PBYTEArray & v)
{
  SetValue(v);
}


H225_ConferenceIdentifier & H225_ConferenceIdentifier::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_ConferenceIdentifier & H225_ConferenceIdentifier::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H225_ConferenceIdentifier & H225_ConferenceIdentifier::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_ConferenceIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ConferenceIdentifier::Class()), PInvalidCast);
#endif
  return new H225_ConferenceIdentifier(*this);
}


//
// RequestSeqNum
//

H225_RequestSeqNum::H225_RequestSeqNum(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 65535);
}


H225_RequestSeqNum & H225_RequestSeqNum::operator=(int v)
{
  SetValue(v);
  return *this;
}


H225_RequestSeqNum & H225_RequestSeqNum::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H225_RequestSeqNum::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_RequestSeqNum::Class()), PInvalidCast);
#endif
  return new H225_RequestSeqNum(*this);
}


//
// GatekeeperIdentifier
//

H225_GatekeeperIdentifier::H225_GatekeeperIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_BMPString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 128);
}


H225_GatekeeperIdentifier & H225_GatekeeperIdentifier::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_GatekeeperIdentifier & H225_GatekeeperIdentifier::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H225_GatekeeperIdentifier & H225_GatekeeperIdentifier::operator=(const PWCharArray & v)
{
  SetValue(v);
  return *this;
}


H225_GatekeeperIdentifier & H225_GatekeeperIdentifier::operator=(const PASN_BMPString & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_GatekeeperIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_GatekeeperIdentifier::Class()), PInvalidCast);
#endif
  return new H225_GatekeeperIdentifier(*this);
}


//
// BandWidth
//

H225_BandWidth::H225_BandWidth(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 0, 4294967295U);
}


H225_BandWidth & H225_BandWidth::operator=(int v)
{
  SetValue(v);
  return *this;
}


H225_BandWidth & H225_BandWidth::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H225_BandWidth::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_BandWidth::Class()), PInvalidCast);
#endif
  return new H225_BandWidth(*this);
}


//
// CallReferenceValue
//

H225_CallReferenceValue::H225_CallReferenceValue(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


H225_CallReferenceValue & H225_CallReferenceValue::operator=(int v)
{
  SetValue(v);
  return *this;
}


H225_CallReferenceValue & H225_CallReferenceValue::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H225_CallReferenceValue::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallReferenceValue::Class()), PInvalidCast);
#endif
  return new H225_CallReferenceValue(*this);
}


//
// EndpointIdentifier
//

H225_EndpointIdentifier::H225_EndpointIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_BMPString(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 128);
}


H225_EndpointIdentifier & H225_EndpointIdentifier::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_EndpointIdentifier & H225_EndpointIdentifier::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H225_EndpointIdentifier & H225_EndpointIdentifier::operator=(const PWCharArray & v)
{
  SetValue(v);
  return *this;
}


H225_EndpointIdentifier & H225_EndpointIdentifier::operator=(const PASN_BMPString & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_EndpointIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_EndpointIdentifier::Class()), PInvalidCast);
#endif
  return new H225_EndpointIdentifier(*this);
}


//
// ProtocolIdentifier
//

H225_ProtocolIdentifier::H225_ProtocolIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_ObjectId(tag, tagClass)
{
}


PObject * H225_ProtocolIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ProtocolIdentifier::Class()), PInvalidCast);
#endif
  return new H225_ProtocolIdentifier(*this);
}


//
// TimeToLive
//

H225_TimeToLive::H225_TimeToLive(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Integer(tag, tagClass)
{
  SetConstraints(PASN_Object::FixedConstraint, 1, 4294967295U);
}


H225_TimeToLive & H225_TimeToLive::operator=(int v)
{
  SetValue(v);
  return *this;
}


H225_TimeToLive & H225_TimeToLive::operator=(unsigned v)
{
  SetValue(v);
  return *this;
}


PObject * H225_TimeToLive::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TimeToLive::Class()), PInvalidCast);
#endif
  return new H225_TimeToLive(*this);
}


//
// H248PackagesDescriptor
//

H225_H248PackagesDescriptor::H225_H248PackagesDescriptor(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


H225_H248PackagesDescriptor::H225_H248PackagesDescriptor(const char * v)
{
  SetValue(v);
}


H225_H248PackagesDescriptor::H225_H248PackagesDescriptor(const PString & v)
{
  SetValue(v);
}


H225_H248PackagesDescriptor::H225_H248PackagesDescriptor(const PBYTEArray & v)
{
  SetValue(v);
}


H225_H248PackagesDescriptor & H225_H248PackagesDescriptor::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_H248PackagesDescriptor & H225_H248PackagesDescriptor::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H225_H248PackagesDescriptor & H225_H248PackagesDescriptor::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_H248PackagesDescriptor::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_H248PackagesDescriptor::Class()), PInvalidCast);
#endif
  return new H225_H248PackagesDescriptor(*this);
}


//
// H248SignalsDescriptor
//

H225_H248SignalsDescriptor::H225_H248SignalsDescriptor(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


H225_H248SignalsDescriptor::H225_H248SignalsDescriptor(const char * v)
{
  SetValue(v);
}


H225_H248SignalsDescriptor::H225_H248SignalsDescriptor(const PString & v)
{
  SetValue(v);
}


H225_H248SignalsDescriptor::H225_H248SignalsDescriptor(const PBYTEArray & v)
{
  SetValue(v);
}


H225_H248SignalsDescriptor & H225_H248SignalsDescriptor::operator=(const char * v)
{
  SetValue(v);
  return *this;
}


H225_H248SignalsDescriptor & H225_H248SignalsDescriptor::operator=(const PString & v)
{
  SetValue(v);
  return *this;
}


H225_H248SignalsDescriptor & H225_H248SignalsDescriptor::operator=(const PBYTEArray & v)
{
  SetValue(v);
  return *this;
}


PObject * H225_H248SignalsDescriptor::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_H248SignalsDescriptor::Class()), PInvalidCast);
#endif
  return new H225_H248SignalsDescriptor(*this);
}


//
// CallIdentifier
//

H225_CallIdentifier::H225_CallIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CallIdentifier::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "guid = " << setprecision(indent) << m_guid << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CallIdentifier::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CallIdentifier), PInvalidCast);
#endif
  const H225_CallIdentifier & other = (const H225_CallIdentifier &)obj;

  Comparison result;

  if ((result = m_guid.Compare(other.m_guid)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CallIdentifier::GetDataLength() const
{
  PINDEX length = 0;
  length += m_guid.GetObjectLength();
  return length;
}


PBoolean H225_CallIdentifier::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_guid.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CallIdentifier::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_guid.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CallIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallIdentifier::Class()), PInvalidCast);
#endif
  return new H225_CallIdentifier(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_EncryptIntAlg[]={
      {"nonStandard",0}
     ,{"isoAlgorithm",1}
};
#endif
//
// EncryptIntAlg
//

H225_EncryptIntAlg::H225_EncryptIntAlg(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_EncryptIntAlg,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_EncryptIntAlg::operator H225_NonStandardParameter &() const
#else
H225_EncryptIntAlg::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_EncryptIntAlg::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


PBoolean H225_EncryptIntAlg::CreateObject()
{
  switch (tag) {
    case e_nonStandard :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_isoAlgorithm :
      choice = new PASN_ObjectId();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_EncryptIntAlg::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_EncryptIntAlg::Class()), PInvalidCast);
#endif
  return new H225_EncryptIntAlg(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_NonIsoIntegrityMechanism[]={
      {"hMAC_MD5",0}
     ,{"hMAC_iso10118_2_s",1}
     ,{"hMAC_iso10118_2_l",2}
     ,{"hMAC_iso10118_3",3}
};
#endif
//
// NonIsoIntegrityMechanism
//

H225_NonIsoIntegrityMechanism::H225_NonIsoIntegrityMechanism(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_NonIsoIntegrityMechanism,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_NonIsoIntegrityMechanism::operator H225_EncryptIntAlg &() const
#else
H225_NonIsoIntegrityMechanism::operator H225_EncryptIntAlg &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_EncryptIntAlg), PInvalidCast);
#endif
  return *(H225_EncryptIntAlg *)choice;
}


H225_NonIsoIntegrityMechanism::operator const H225_EncryptIntAlg &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_EncryptIntAlg), PInvalidCast);
#endif
  return *(H225_EncryptIntAlg *)choice;
}


PBoolean H225_NonIsoIntegrityMechanism::CreateObject()
{
  switch (tag) {
    case e_hMAC_MD5 :
      choice = new PASN_Null();
      return TRUE;
    case e_hMAC_iso10118_2_s :
    case e_hMAC_iso10118_2_l :
      choice = new H225_EncryptIntAlg();
      return TRUE;
    case e_hMAC_iso10118_3 :
      choice = new PASN_ObjectId();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_NonIsoIntegrityMechanism::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_NonIsoIntegrityMechanism::Class()), PInvalidCast);
#endif
  return new H225_NonIsoIntegrityMechanism(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_IntegrityMechanism[]={
      {"nonStandard",0}
     ,{"digSig",1}
     ,{"iso9797",2}
     ,{"nonIsoIM",3}
};
#endif
//
// IntegrityMechanism
//

H225_IntegrityMechanism::H225_IntegrityMechanism(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_IntegrityMechanism,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_IntegrityMechanism::operator H225_NonStandardParameter &() const
#else
H225_IntegrityMechanism::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_IntegrityMechanism::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_IntegrityMechanism::operator H225_NonIsoIntegrityMechanism &() const
#else
H225_IntegrityMechanism::operator H225_NonIsoIntegrityMechanism &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonIsoIntegrityMechanism), PInvalidCast);
#endif
  return *(H225_NonIsoIntegrityMechanism *)choice;
}


H225_IntegrityMechanism::operator const H225_NonIsoIntegrityMechanism &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonIsoIntegrityMechanism), PInvalidCast);
#endif
  return *(H225_NonIsoIntegrityMechanism *)choice;
}


PBoolean H225_IntegrityMechanism::CreateObject()
{
  switch (tag) {
    case e_nonStandard :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_digSig :
      choice = new PASN_Null();
      return TRUE;
    case e_iso9797 :
      choice = new PASN_ObjectId();
      return TRUE;
    case e_nonIsoIM :
      choice = new H225_NonIsoIntegrityMechanism();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_IntegrityMechanism::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_IntegrityMechanism::Class()), PInvalidCast);
#endif
  return new H225_IntegrityMechanism(*this);
}


//
// ICV
//

H225_ICV::H225_ICV(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_ICV::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+15) << "algorithmOID = " << setprecision(indent) << m_algorithmOID << '\n';
  strm << setw(indent+6) << "icv = " << setprecision(indent) << m_icv << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_ICV::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_ICV), PInvalidCast);
#endif
  const H225_ICV & other = (const H225_ICV &)obj;

  Comparison result;

  if ((result = m_algorithmOID.Compare(other.m_algorithmOID)) != EqualTo)
    return result;
  if ((result = m_icv.Compare(other.m_icv)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_ICV::GetDataLength() const
{
  PINDEX length = 0;
  length += m_algorithmOID.GetObjectLength();
  length += m_icv.GetObjectLength();
  return length;
}


PBoolean H225_ICV::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_algorithmOID.Decode(strm))
    return FALSE;
  if (!m_icv.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_ICV::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_algorithmOID.Encode(strm);
  m_icv.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_ICV::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ICV::Class()), PInvalidCast);
#endif
  return new H225_ICV(*this);
}


//
// FastStartToken
//

H225_FastStartToken::H225_FastStartToken(unsigned tag, PASN_Object::TagClass tagClass)
  : H235_ClearToken(tag, tagClass)
{
  IncludeOptionalField(e_generalID);
  IncludeOptionalField(e_dhkey);
  IncludeOptionalField(e_timeStamp);
}


PObject * H225_FastStartToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_FastStartToken::Class()), PInvalidCast);
#endif
  return new H225_FastStartToken(*this);
}


//
// EncodedFastStartToken
//

H225_EncodedFastStartToken::H225_EncodedFastStartToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_OctetString(tag, tagClass)
{
}


PObject * H225_EncodedFastStartToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_EncodedFastStartToken::Class()), PInvalidCast);
#endif
  return new H225_EncodedFastStartToken(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_CryptoH323Token[]={
      {"cryptoEPPwdHash",0}
     ,{"cryptoGKPwdHash",1}
     ,{"cryptoEPPwdEncr",2}
     ,{"cryptoGKPwdEncr",3}
     ,{"cryptoEPCert",4}
     ,{"cryptoGKCert",5}
     ,{"cryptoFastStart",6}
     ,{"nestedcryptoToken",7}
};
#endif
//
// CryptoH323Token
//

H225_CryptoH323Token::H225_CryptoH323Token(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 8, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_CryptoH323Token,8
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CryptoH323Token::operator H225_CryptoH323Token_cryptoEPPwdHash &() const
#else
H225_CryptoH323Token::operator H225_CryptoH323Token_cryptoEPPwdHash &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CryptoH323Token_cryptoEPPwdHash), PInvalidCast);
#endif
  return *(H225_CryptoH323Token_cryptoEPPwdHash *)choice;
}


H225_CryptoH323Token::operator const H225_CryptoH323Token_cryptoEPPwdHash &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CryptoH323Token_cryptoEPPwdHash), PInvalidCast);
#endif
  return *(H225_CryptoH323Token_cryptoEPPwdHash *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CryptoH323Token::operator H225_CryptoH323Token_cryptoGKPwdHash &() const
#else
H225_CryptoH323Token::operator H225_CryptoH323Token_cryptoGKPwdHash &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CryptoH323Token_cryptoGKPwdHash), PInvalidCast);
#endif
  return *(H225_CryptoH323Token_cryptoGKPwdHash *)choice;
}


H225_CryptoH323Token::operator const H225_CryptoH323Token_cryptoGKPwdHash &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CryptoH323Token_cryptoGKPwdHash), PInvalidCast);
#endif
  return *(H225_CryptoH323Token_cryptoGKPwdHash *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CryptoH323Token::operator H235_ENCRYPTED<H235_EncodedPwdCertToken> &() const
#else
H225_CryptoH323Token::operator H235_ENCRYPTED<H235_EncodedPwdCertToken> &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ENCRYPTED<H235_EncodedPwdCertToken>), PInvalidCast);
#endif
  return *(H235_ENCRYPTED<H235_EncodedPwdCertToken> *)choice;
}


H225_CryptoH323Token::operator const H235_ENCRYPTED<H235_EncodedPwdCertToken> &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_ENCRYPTED<H235_EncodedPwdCertToken>), PInvalidCast);
#endif
  return *(H235_ENCRYPTED<H235_EncodedPwdCertToken> *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CryptoH323Token::operator H235_SIGNED<H235_EncodedPwdCertToken> &() const
#else
H225_CryptoH323Token::operator H235_SIGNED<H235_EncodedPwdCertToken> &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_SIGNED<H235_EncodedPwdCertToken>), PInvalidCast);
#endif
  return *(H235_SIGNED<H235_EncodedPwdCertToken> *)choice;
}


H225_CryptoH323Token::operator const H235_SIGNED<H235_EncodedPwdCertToken> &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_SIGNED<H235_EncodedPwdCertToken>), PInvalidCast);
#endif
  return *(H235_SIGNED<H235_EncodedPwdCertToken> *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CryptoH323Token::operator H235_SIGNED<H225_EncodedFastStartToken> &() const
#else
H225_CryptoH323Token::operator H235_SIGNED<H225_EncodedFastStartToken> &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_SIGNED<H225_EncodedFastStartToken>), PInvalidCast);
#endif
  return *(H235_SIGNED<H225_EncodedFastStartToken> *)choice;
}


H225_CryptoH323Token::operator const H235_SIGNED<H225_EncodedFastStartToken> &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_SIGNED<H225_EncodedFastStartToken>), PInvalidCast);
#endif
  return *(H235_SIGNED<H225_EncodedFastStartToken> *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CryptoH323Token::operator H235_CryptoToken &() const
#else
H225_CryptoH323Token::operator H235_CryptoToken &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken), PInvalidCast);
#endif
  return *(H235_CryptoToken *)choice;
}


H225_CryptoH323Token::operator const H235_CryptoToken &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H235_CryptoToken), PInvalidCast);
#endif
  return *(H235_CryptoToken *)choice;
}


PBoolean H225_CryptoH323Token::CreateObject()
{
  switch (tag) {
    case e_cryptoEPPwdHash :
      choice = new H225_CryptoH323Token_cryptoEPPwdHash();
      return TRUE;
    case e_cryptoGKPwdHash :
      choice = new H225_CryptoH323Token_cryptoGKPwdHash();
      return TRUE;
    case e_cryptoEPPwdEncr :
    case e_cryptoGKPwdEncr :
      choice = new H235_ENCRYPTED<H235_EncodedPwdCertToken>();
      return TRUE;
    case e_cryptoEPCert :
    case e_cryptoGKCert :
      choice = new H235_SIGNED<H235_EncodedPwdCertToken>();
      return TRUE;
    case e_cryptoFastStart :
      choice = new H235_SIGNED<H225_EncodedFastStartToken>();
      return TRUE;
    case e_nestedcryptoToken :
      choice = new H235_CryptoToken();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_CryptoH323Token::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CryptoH323Token::Class()), PInvalidCast);
#endif
  return new H225_CryptoH323Token(*this);
}


//
// CallLinkage
//

H225_CallLinkage::H225_CallLinkage(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CallLinkage::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_globalCallId))
    strm << setw(indent+15) << "globalCallId = " << setprecision(indent) << m_globalCallId << '\n';
  if (HasOptionalField(e_threadId))
    strm << setw(indent+11) << "threadId = " << setprecision(indent) << m_threadId << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CallLinkage::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CallLinkage), PInvalidCast);
#endif
  const H225_CallLinkage & other = (const H225_CallLinkage &)obj;

  Comparison result;

  if ((result = m_globalCallId.Compare(other.m_globalCallId)) != EqualTo)
    return result;
  if ((result = m_threadId.Compare(other.m_threadId)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CallLinkage::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_globalCallId))
    length += m_globalCallId.GetObjectLength();
  if (HasOptionalField(e_threadId))
    length += m_threadId.GetObjectLength();
  return length;
}


PBoolean H225_CallLinkage::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_globalCallId) && !m_globalCallId.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_threadId) && !m_threadId.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CallLinkage::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_globalCallId))
    m_globalCallId.Encode(strm);
  if (HasOptionalField(e_threadId))
    m_threadId.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CallLinkage::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallLinkage::Class()), PInvalidCast);
#endif
  return new H225_CallLinkage(*this);
}


//
// CapacityReportingCapability
//

H225_CapacityReportingCapability::H225_CapacityReportingCapability(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CapacityReportingCapability::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+24) << "canReportCallCapacity = " << setprecision(indent) << m_canReportCallCapacity << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CapacityReportingCapability::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CapacityReportingCapability), PInvalidCast);
#endif
  const H225_CapacityReportingCapability & other = (const H225_CapacityReportingCapability &)obj;

  Comparison result;

  if ((result = m_canReportCallCapacity.Compare(other.m_canReportCallCapacity)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CapacityReportingCapability::GetDataLength() const
{
  PINDEX length = 0;
  length += m_canReportCallCapacity.GetObjectLength();
  return length;
}


PBoolean H225_CapacityReportingCapability::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_canReportCallCapacity.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CapacityReportingCapability::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_canReportCallCapacity.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CapacityReportingCapability::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CapacityReportingCapability::Class()), PInvalidCast);
#endif
  return new H225_CapacityReportingCapability(*this);
}


//
// CarrierInfo
//

H225_CarrierInfo::H225_CarrierInfo(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
  m_carrierIdentificationCode.SetConstraints(PASN_Object::FixedConstraint, 3, 4);
  m_carrierName.SetConstraints(PASN_Object::FixedConstraint, 1, 128);
}


#ifndef PASN_NOPRINTON
void H225_CarrierInfo::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_carrierIdentificationCode))
    strm << setw(indent+28) << "carrierIdentificationCode = " << setprecision(indent) << m_carrierIdentificationCode << '\n';
  if (HasOptionalField(e_carrierName))
    strm << setw(indent+14) << "carrierName = " << setprecision(indent) << m_carrierName << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CarrierInfo::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CarrierInfo), PInvalidCast);
#endif
  const H225_CarrierInfo & other = (const H225_CarrierInfo &)obj;

  Comparison result;

  if ((result = m_carrierIdentificationCode.Compare(other.m_carrierIdentificationCode)) != EqualTo)
    return result;
  if ((result = m_carrierName.Compare(other.m_carrierName)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CarrierInfo::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_carrierIdentificationCode))
    length += m_carrierIdentificationCode.GetObjectLength();
  if (HasOptionalField(e_carrierName))
    length += m_carrierName.GetObjectLength();
  return length;
}


PBoolean H225_CarrierInfo::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_carrierIdentificationCode) && !m_carrierIdentificationCode.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_carrierName) && !m_carrierName.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CarrierInfo::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_carrierIdentificationCode))
    m_carrierIdentificationCode.Encode(strm);
  if (HasOptionalField(e_carrierName))
    m_carrierName.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CarrierInfo::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CarrierInfo::Class()), PInvalidCast);
#endif
  return new H225_CarrierInfo(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ServiceControlDescriptor[]={
      {"url",0}
     ,{"signal",1}
     ,{"nonStandard",2}
     ,{"callCreditServiceControl",3}
};
#endif
//
// ServiceControlDescriptor
//

H225_ServiceControlDescriptor::H225_ServiceControlDescriptor(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ServiceControlDescriptor,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_ServiceControlDescriptor::operator H225_H248SignalsDescriptor &() const
#else
H225_ServiceControlDescriptor::operator H225_H248SignalsDescriptor &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H248SignalsDescriptor), PInvalidCast);
#endif
  return *(H225_H248SignalsDescriptor *)choice;
}


H225_ServiceControlDescriptor::operator const H225_H248SignalsDescriptor &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_H248SignalsDescriptor), PInvalidCast);
#endif
  return *(H225_H248SignalsDescriptor *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_ServiceControlDescriptor::operator H225_NonStandardParameter &() const
#else
H225_ServiceControlDescriptor::operator H225_NonStandardParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


H225_ServiceControlDescriptor::operator const H225_NonStandardParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardParameter), PInvalidCast);
#endif
  return *(H225_NonStandardParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_ServiceControlDescriptor::operator H225_CallCreditServiceControl &() const
#else
H225_ServiceControlDescriptor::operator H225_CallCreditServiceControl &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CallCreditServiceControl), PInvalidCast);
#endif
  return *(H225_CallCreditServiceControl *)choice;
}


H225_ServiceControlDescriptor::operator const H225_CallCreditServiceControl &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CallCreditServiceControl), PInvalidCast);
#endif
  return *(H225_CallCreditServiceControl *)choice;
}


PBoolean H225_ServiceControlDescriptor::CreateObject()
{
  switch (tag) {
    case e_url :
      choice = new PASN_IA5String();
      choice->SetConstraints(PASN_Object::FixedConstraint, 0, 512);
      return TRUE;
    case e_signal :
      choice = new H225_H248SignalsDescriptor();
      return TRUE;
    case e_nonStandard :
      choice = new H225_NonStandardParameter();
      return TRUE;
    case e_callCreditServiceControl :
      choice = new H225_CallCreditServiceControl();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_ServiceControlDescriptor::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ServiceControlDescriptor::Class()), PInvalidCast);
#endif
  return new H225_ServiceControlDescriptor(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_CallTerminationCause[]={
      {"releaseCompleteReason",0}
     ,{"releaseCompleteCauseIE",1}
};
#endif
//
// CallTerminationCause
//

H225_CallTerminationCause::H225_CallTerminationCause(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_CallTerminationCause,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_CallTerminationCause::operator H225_ReleaseCompleteReason &() const
#else
H225_CallTerminationCause::operator H225_ReleaseCompleteReason &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ReleaseCompleteReason), PInvalidCast);
#endif
  return *(H225_ReleaseCompleteReason *)choice;
}


H225_CallTerminationCause::operator const H225_ReleaseCompleteReason &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ReleaseCompleteReason), PInvalidCast);
#endif
  return *(H225_ReleaseCompleteReason *)choice;
}


PBoolean H225_CallTerminationCause::CreateObject()
{
  switch (tag) {
    case e_releaseCompleteReason :
      choice = new H225_ReleaseCompleteReason();
      return TRUE;
    case e_releaseCompleteCauseIE :
      choice = new PASN_OctetString();
      choice->SetConstraints(PASN_Object::FixedConstraint, 2, 32);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_CallTerminationCause::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallTerminationCause::Class()), PInvalidCast);
#endif
  return new H225_CallTerminationCause(*this);
}


//
// CallCreditCapability
//

H225_CallCreditCapability::H225_CallCreditCapability(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CallCreditCapability::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_canDisplayAmountString))
    strm << setw(indent+25) << "canDisplayAmountString = " << setprecision(indent) << m_canDisplayAmountString << '\n';
  if (HasOptionalField(e_canEnforceDurationLimit))
    strm << setw(indent+26) << "canEnforceDurationLimit = " << setprecision(indent) << m_canEnforceDurationLimit << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CallCreditCapability::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CallCreditCapability), PInvalidCast);
#endif
  const H225_CallCreditCapability & other = (const H225_CallCreditCapability &)obj;

  Comparison result;

  if ((result = m_canDisplayAmountString.Compare(other.m_canDisplayAmountString)) != EqualTo)
    return result;
  if ((result = m_canEnforceDurationLimit.Compare(other.m_canEnforceDurationLimit)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CallCreditCapability::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_canDisplayAmountString))
    length += m_canDisplayAmountString.GetObjectLength();
  if (HasOptionalField(e_canEnforceDurationLimit))
    length += m_canEnforceDurationLimit.GetObjectLength();
  return length;
}


PBoolean H225_CallCreditCapability::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_canDisplayAmountString) && !m_canDisplayAmountString.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_canEnforceDurationLimit) && !m_canEnforceDurationLimit.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CallCreditCapability::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_canDisplayAmountString))
    m_canDisplayAmountString.Encode(strm);
  if (HasOptionalField(e_canEnforceDurationLimit))
    m_canEnforceDurationLimit.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CallCreditCapability::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallCreditCapability::Class()), PInvalidCast);
#endif
  return new H225_CallCreditCapability(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_GenericIdentifier[]={
      {"standard",0}
     ,{"oid",1}
     ,{"nonStandard",2}
};
#endif
//
// GenericIdentifier
//

H225_GenericIdentifier::H225_GenericIdentifier(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_GenericIdentifier,3
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_GenericIdentifier::operator H225_GloballyUniqueID &() const
#else
H225_GenericIdentifier::operator H225_GloballyUniqueID &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GloballyUniqueID), PInvalidCast);
#endif
  return *(H225_GloballyUniqueID *)choice;
}


H225_GenericIdentifier::operator const H225_GloballyUniqueID &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GloballyUniqueID), PInvalidCast);
#endif
  return *(H225_GloballyUniqueID *)choice;
}


PBoolean H225_GenericIdentifier::CreateObject()
{
  switch (tag) {
    case e_standard :
      choice = new PASN_Integer();
      choice->SetConstraints(PASN_Object::ExtendableConstraint, 0, 16383);
      return TRUE;
    case e_oid :
      choice = new PASN_ObjectId();
      return TRUE;
    case e_nonStandard :
      choice = new H225_GloballyUniqueID();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_GenericIdentifier::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_GenericIdentifier::Class()), PInvalidCast);
#endif
  return new H225_GenericIdentifier(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_Content[]={
      {"raw",0}
     ,{"text",1}
     ,{"unicode",2}
     ,{"bool",3}
     ,{"number8",4}
     ,{"number16",5}
     ,{"number32",6}
     ,{"id",7}
     ,{"alias",8}
     ,{"transport",9}
     ,{"compound",10}
     ,{"nested",11}
};
#endif
//
// Content
//

H225_Content::H225_Content(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 12, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_Content,12
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_Content::operator H225_GenericIdentifier &() const
#else
H225_Content::operator H225_GenericIdentifier &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GenericIdentifier), PInvalidCast);
#endif
  return *(H225_GenericIdentifier *)choice;
}


H225_Content::operator const H225_GenericIdentifier &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GenericIdentifier), PInvalidCast);
#endif
  return *(H225_GenericIdentifier *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_Content::operator H225_AliasAddress &() const
#else
H225_Content::operator H225_AliasAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AliasAddress), PInvalidCast);
#endif
  return *(H225_AliasAddress *)choice;
}


H225_Content::operator const H225_AliasAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AliasAddress), PInvalidCast);
#endif
  return *(H225_AliasAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_Content::operator H225_TransportAddress &() const
#else
H225_Content::operator H225_TransportAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress *)choice;
}


H225_Content::operator const H225_TransportAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TransportAddress), PInvalidCast);
#endif
  return *(H225_TransportAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_Content::operator H225_ArrayOf_EnumeratedParameter &() const
#else
H225_Content::operator H225_ArrayOf_EnumeratedParameter &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_EnumeratedParameter), PInvalidCast);
#endif
  return *(H225_ArrayOf_EnumeratedParameter *)choice;
}


H225_Content::operator const H225_ArrayOf_EnumeratedParameter &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_EnumeratedParameter), PInvalidCast);
#endif
  return *(H225_ArrayOf_EnumeratedParameter *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_Content::operator H225_ArrayOf_GenericData &() const
#else
H225_Content::operator H225_ArrayOf_GenericData &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_GenericData), PInvalidCast);
#endif
  return *(H225_ArrayOf_GenericData *)choice;
}


H225_Content::operator const H225_ArrayOf_GenericData &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_GenericData), PInvalidCast);
#endif
  return *(H225_ArrayOf_GenericData *)choice;
}


PBoolean H225_Content::CreateObject()
{
  switch (tag) {
    case e_raw :
      choice = new PASN_OctetString();
      return TRUE;
    case e_text :
      choice = new PASN_IA5String();
      return TRUE;
    case e_unicode :
      choice = new PASN_BMPString();
      return TRUE;
    case e_bool :
      choice = new PASN_Boolean();
      return TRUE;
    case e_number8 :
      choice = new PASN_Integer();
      choice->SetConstraints(PASN_Object::FixedConstraint, 0, 255);
      return TRUE;
    case e_number16 :
      choice = new PASN_Integer();
      choice->SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
      return TRUE;
    case e_number32 :
      choice = new PASN_Integer();
      choice->SetConstraints(PASN_Object::FixedConstraint, 0, 4294967295U);
      return TRUE;
    case e_id :
      choice = new H225_GenericIdentifier();
      return TRUE;
    case e_alias :
      choice = new H225_AliasAddress();
      return TRUE;
    case e_transport :
      choice = new H225_TransportAddress();
      return TRUE;
    case e_compound :
      choice = new H225_ArrayOf_EnumeratedParameter();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 512);
      return TRUE;
    case e_nested :
      choice = new H225_ArrayOf_GenericData();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 16);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_Content::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_Content::Class()), PInvalidCast);
#endif
  return new H225_Content(*this);
}


//
// TransportChannelInfo
//

H225_TransportChannelInfo::H225_TransportChannelInfo(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_TransportChannelInfo::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_sendAddress))
    strm << setw(indent+14) << "sendAddress = " << setprecision(indent) << m_sendAddress << '\n';
  if (HasOptionalField(e_recvAddress))
    strm << setw(indent+14) << "recvAddress = " << setprecision(indent) << m_recvAddress << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_TransportChannelInfo::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_TransportChannelInfo), PInvalidCast);
#endif
  const H225_TransportChannelInfo & other = (const H225_TransportChannelInfo &)obj;

  Comparison result;

  if ((result = m_sendAddress.Compare(other.m_sendAddress)) != EqualTo)
    return result;
  if ((result = m_recvAddress.Compare(other.m_recvAddress)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_TransportChannelInfo::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_sendAddress))
    length += m_sendAddress.GetObjectLength();
  if (HasOptionalField(e_recvAddress))
    length += m_recvAddress.GetObjectLength();
  return length;
}


PBoolean H225_TransportChannelInfo::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_sendAddress) && !m_sendAddress.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_recvAddress) && !m_recvAddress.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_TransportChannelInfo::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_sendAddress))
    m_sendAddress.Encode(strm);
  if (HasOptionalField(e_recvAddress))
    m_recvAddress.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_TransportChannelInfo::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TransportChannelInfo::Class()), PInvalidCast);
#endif
  return new H225_TransportChannelInfo(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_RehomingModel[]={
      {"gatekeeperBased",0}
     ,{"endpointBased",1}
};
#endif
//
// RehomingModel
//

H225_RehomingModel::H225_RehomingModel(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, FALSE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_RehomingModel,2
#endif
)
{
}


PBoolean H225_RehomingModel::CreateObject()
{
  choice = (tag <= e_endpointBased) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_RehomingModel::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_RehomingModel::Class()), PInvalidCast);
#endif
  return new H225_RehomingModel(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_RasMessage[]={
      {"gatekeeperRequest",0}
     ,{"gatekeeperConfirm",1}
     ,{"gatekeeperReject",2}
     ,{"registrationRequest",3}
     ,{"registrationConfirm",4}
     ,{"registrationReject",5}
     ,{"unregistrationRequest",6}
     ,{"unregistrationConfirm",7}
     ,{"unregistrationReject",8}
     ,{"admissionRequest",9}
     ,{"admissionConfirm",10}
     ,{"admissionReject",11}
     ,{"bandwidthRequest",12}
     ,{"bandwidthConfirm",13}
     ,{"bandwidthReject",14}
     ,{"disengageRequest",15}
     ,{"disengageConfirm",16}
     ,{"disengageReject",17}
     ,{"locationRequest",18}
     ,{"locationConfirm",19}
     ,{"locationReject",20}
     ,{"infoRequest",21}
     ,{"infoRequestResponse",22}
     ,{"nonStandardMessage",23}
     ,{"unknownMessageResponse",24}
     ,{"requestInProgress",25}
     ,{"resourcesAvailableIndicate",26}
     ,{"resourcesAvailableConfirm",27}
     ,{"infoRequestAck",28}
     ,{"infoRequestNak",29}
     ,{"serviceControlIndication",30}
     ,{"serviceControlResponse",31}
     ,{"admissionConfirmSequence",32}
};
#endif
//
// RasMessage
//

H225_RasMessage::H225_RasMessage(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 25, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_RasMessage,33
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_GatekeeperRequest &() const
#else
H225_RasMessage::operator H225_GatekeeperRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GatekeeperRequest), PInvalidCast);
#endif
  return *(H225_GatekeeperRequest *)choice;
}


H225_RasMessage::operator const H225_GatekeeperRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GatekeeperRequest), PInvalidCast);
#endif
  return *(H225_GatekeeperRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_GatekeeperConfirm &() const
#else
H225_RasMessage::operator H225_GatekeeperConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GatekeeperConfirm), PInvalidCast);
#endif
  return *(H225_GatekeeperConfirm *)choice;
}


H225_RasMessage::operator const H225_GatekeeperConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GatekeeperConfirm), PInvalidCast);
#endif
  return *(H225_GatekeeperConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_GatekeeperReject &() const
#else
H225_RasMessage::operator H225_GatekeeperReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GatekeeperReject), PInvalidCast);
#endif
  return *(H225_GatekeeperReject *)choice;
}


H225_RasMessage::operator const H225_GatekeeperReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_GatekeeperReject), PInvalidCast);
#endif
  return *(H225_GatekeeperReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_RegistrationRequest &() const
#else
H225_RasMessage::operator H225_RegistrationRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationRequest), PInvalidCast);
#endif
  return *(H225_RegistrationRequest *)choice;
}


H225_RasMessage::operator const H225_RegistrationRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationRequest), PInvalidCast);
#endif
  return *(H225_RegistrationRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_RegistrationConfirm &() const
#else
H225_RasMessage::operator H225_RegistrationConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationConfirm), PInvalidCast);
#endif
  return *(H225_RegistrationConfirm *)choice;
}


H225_RasMessage::operator const H225_RegistrationConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationConfirm), PInvalidCast);
#endif
  return *(H225_RegistrationConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_RegistrationReject &() const
#else
H225_RasMessage::operator H225_RegistrationReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationReject), PInvalidCast);
#endif
  return *(H225_RegistrationReject *)choice;
}


H225_RasMessage::operator const H225_RegistrationReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationReject), PInvalidCast);
#endif
  return *(H225_RegistrationReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_UnregistrationRequest &() const
#else
H225_RasMessage::operator H225_UnregistrationRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnregistrationRequest), PInvalidCast);
#endif
  return *(H225_UnregistrationRequest *)choice;
}


H225_RasMessage::operator const H225_UnregistrationRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnregistrationRequest), PInvalidCast);
#endif
  return *(H225_UnregistrationRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_UnregistrationConfirm &() const
#else
H225_RasMessage::operator H225_UnregistrationConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnregistrationConfirm), PInvalidCast);
#endif
  return *(H225_UnregistrationConfirm *)choice;
}


H225_RasMessage::operator const H225_UnregistrationConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnregistrationConfirm), PInvalidCast);
#endif
  return *(H225_UnregistrationConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_UnregistrationReject &() const
#else
H225_RasMessage::operator H225_UnregistrationReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnregistrationReject), PInvalidCast);
#endif
  return *(H225_UnregistrationReject *)choice;
}


H225_RasMessage::operator const H225_UnregistrationReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnregistrationReject), PInvalidCast);
#endif
  return *(H225_UnregistrationReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_AdmissionRequest &() const
#else
H225_RasMessage::operator H225_AdmissionRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AdmissionRequest), PInvalidCast);
#endif
  return *(H225_AdmissionRequest *)choice;
}


H225_RasMessage::operator const H225_AdmissionRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AdmissionRequest), PInvalidCast);
#endif
  return *(H225_AdmissionRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_AdmissionConfirm &() const
#else
H225_RasMessage::operator H225_AdmissionConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AdmissionConfirm), PInvalidCast);
#endif
  return *(H225_AdmissionConfirm *)choice;
}


H225_RasMessage::operator const H225_AdmissionConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AdmissionConfirm), PInvalidCast);
#endif
  return *(H225_AdmissionConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_AdmissionReject &() const
#else
H225_RasMessage::operator H225_AdmissionReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AdmissionReject), PInvalidCast);
#endif
  return *(H225_AdmissionReject *)choice;
}


H225_RasMessage::operator const H225_AdmissionReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_AdmissionReject), PInvalidCast);
#endif
  return *(H225_AdmissionReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_BandwidthRequest &() const
#else
H225_RasMessage::operator H225_BandwidthRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_BandwidthRequest), PInvalidCast);
#endif
  return *(H225_BandwidthRequest *)choice;
}


H225_RasMessage::operator const H225_BandwidthRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_BandwidthRequest), PInvalidCast);
#endif
  return *(H225_BandwidthRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_BandwidthConfirm &() const
#else
H225_RasMessage::operator H225_BandwidthConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_BandwidthConfirm), PInvalidCast);
#endif
  return *(H225_BandwidthConfirm *)choice;
}


H225_RasMessage::operator const H225_BandwidthConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_BandwidthConfirm), PInvalidCast);
#endif
  return *(H225_BandwidthConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_BandwidthReject &() const
#else
H225_RasMessage::operator H225_BandwidthReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_BandwidthReject), PInvalidCast);
#endif
  return *(H225_BandwidthReject *)choice;
}


H225_RasMessage::operator const H225_BandwidthReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_BandwidthReject), PInvalidCast);
#endif
  return *(H225_BandwidthReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_DisengageRequest &() const
#else
H225_RasMessage::operator H225_DisengageRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_DisengageRequest), PInvalidCast);
#endif
  return *(H225_DisengageRequest *)choice;
}


H225_RasMessage::operator const H225_DisengageRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_DisengageRequest), PInvalidCast);
#endif
  return *(H225_DisengageRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_DisengageConfirm &() const
#else
H225_RasMessage::operator H225_DisengageConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_DisengageConfirm), PInvalidCast);
#endif
  return *(H225_DisengageConfirm *)choice;
}


H225_RasMessage::operator const H225_DisengageConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_DisengageConfirm), PInvalidCast);
#endif
  return *(H225_DisengageConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_DisengageReject &() const
#else
H225_RasMessage::operator H225_DisengageReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_DisengageReject), PInvalidCast);
#endif
  return *(H225_DisengageReject *)choice;
}


H225_RasMessage::operator const H225_DisengageReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_DisengageReject), PInvalidCast);
#endif
  return *(H225_DisengageReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_LocationRequest &() const
#else
H225_RasMessage::operator H225_LocationRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_LocationRequest), PInvalidCast);
#endif
  return *(H225_LocationRequest *)choice;
}


H225_RasMessage::operator const H225_LocationRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_LocationRequest), PInvalidCast);
#endif
  return *(H225_LocationRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_LocationConfirm &() const
#else
H225_RasMessage::operator H225_LocationConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_LocationConfirm), PInvalidCast);
#endif
  return *(H225_LocationConfirm *)choice;
}


H225_RasMessage::operator const H225_LocationConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_LocationConfirm), PInvalidCast);
#endif
  return *(H225_LocationConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_LocationReject &() const
#else
H225_RasMessage::operator H225_LocationReject &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_LocationReject), PInvalidCast);
#endif
  return *(H225_LocationReject *)choice;
}


H225_RasMessage::operator const H225_LocationReject &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_LocationReject), PInvalidCast);
#endif
  return *(H225_LocationReject *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_InfoRequest &() const
#else
H225_RasMessage::operator H225_InfoRequest &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequest), PInvalidCast);
#endif
  return *(H225_InfoRequest *)choice;
}


H225_RasMessage::operator const H225_InfoRequest &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequest), PInvalidCast);
#endif
  return *(H225_InfoRequest *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_InfoRequestResponse &() const
#else
H225_RasMessage::operator H225_InfoRequestResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequestResponse), PInvalidCast);
#endif
  return *(H225_InfoRequestResponse *)choice;
}


H225_RasMessage::operator const H225_InfoRequestResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequestResponse), PInvalidCast);
#endif
  return *(H225_InfoRequestResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_NonStandardMessage &() const
#else
H225_RasMessage::operator H225_NonStandardMessage &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardMessage), PInvalidCast);
#endif
  return *(H225_NonStandardMessage *)choice;
}


H225_RasMessage::operator const H225_NonStandardMessage &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_NonStandardMessage), PInvalidCast);
#endif
  return *(H225_NonStandardMessage *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_UnknownMessageResponse &() const
#else
H225_RasMessage::operator H225_UnknownMessageResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnknownMessageResponse), PInvalidCast);
#endif
  return *(H225_UnknownMessageResponse *)choice;
}


H225_RasMessage::operator const H225_UnknownMessageResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_UnknownMessageResponse), PInvalidCast);
#endif
  return *(H225_UnknownMessageResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_RequestInProgress &() const
#else
H225_RasMessage::operator H225_RequestInProgress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RequestInProgress), PInvalidCast);
#endif
  return *(H225_RequestInProgress *)choice;
}


H225_RasMessage::operator const H225_RequestInProgress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RequestInProgress), PInvalidCast);
#endif
  return *(H225_RequestInProgress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_ResourcesAvailableIndicate &() const
#else
H225_RasMessage::operator H225_ResourcesAvailableIndicate &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ResourcesAvailableIndicate), PInvalidCast);
#endif
  return *(H225_ResourcesAvailableIndicate *)choice;
}


H225_RasMessage::operator const H225_ResourcesAvailableIndicate &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ResourcesAvailableIndicate), PInvalidCast);
#endif
  return *(H225_ResourcesAvailableIndicate *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_ResourcesAvailableConfirm &() const
#else
H225_RasMessage::operator H225_ResourcesAvailableConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ResourcesAvailableConfirm), PInvalidCast);
#endif
  return *(H225_ResourcesAvailableConfirm *)choice;
}


H225_RasMessage::operator const H225_ResourcesAvailableConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ResourcesAvailableConfirm), PInvalidCast);
#endif
  return *(H225_ResourcesAvailableConfirm *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_InfoRequestAck &() const
#else
H225_RasMessage::operator H225_InfoRequestAck &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequestAck), PInvalidCast);
#endif
  return *(H225_InfoRequestAck *)choice;
}


H225_RasMessage::operator const H225_InfoRequestAck &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequestAck), PInvalidCast);
#endif
  return *(H225_InfoRequestAck *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_InfoRequestNak &() const
#else
H225_RasMessage::operator H225_InfoRequestNak &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequestNak), PInvalidCast);
#endif
  return *(H225_InfoRequestNak *)choice;
}


H225_RasMessage::operator const H225_InfoRequestNak &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_InfoRequestNak), PInvalidCast);
#endif
  return *(H225_InfoRequestNak *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_ServiceControlIndication &() const
#else
H225_RasMessage::operator H225_ServiceControlIndication &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ServiceControlIndication), PInvalidCast);
#endif
  return *(H225_ServiceControlIndication *)choice;
}


H225_RasMessage::operator const H225_ServiceControlIndication &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ServiceControlIndication), PInvalidCast);
#endif
  return *(H225_ServiceControlIndication *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_ServiceControlResponse &() const
#else
H225_RasMessage::operator H225_ServiceControlResponse &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ServiceControlResponse), PInvalidCast);
#endif
  return *(H225_ServiceControlResponse *)choice;
}


H225_RasMessage::operator const H225_ServiceControlResponse &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ServiceControlResponse), PInvalidCast);
#endif
  return *(H225_ServiceControlResponse *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RasMessage::operator H225_ArrayOf_AdmissionConfirm &() const
#else
H225_RasMessage::operator H225_ArrayOf_AdmissionConfirm &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_AdmissionConfirm), PInvalidCast);
#endif
  return *(H225_ArrayOf_AdmissionConfirm *)choice;
}


H225_RasMessage::operator const H225_ArrayOf_AdmissionConfirm &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_AdmissionConfirm), PInvalidCast);
#endif
  return *(H225_ArrayOf_AdmissionConfirm *)choice;
}


PBoolean H225_RasMessage::CreateObject()
{
  switch (tag) {
    case e_gatekeeperRequest :
      choice = new H225_GatekeeperRequest();
      return TRUE;
    case e_gatekeeperConfirm :
      choice = new H225_GatekeeperConfirm();
      return TRUE;
    case e_gatekeeperReject :
      choice = new H225_GatekeeperReject();
      return TRUE;
    case e_registrationRequest :
      choice = new H225_RegistrationRequest();
      return TRUE;
    case e_registrationConfirm :
      choice = new H225_RegistrationConfirm();
      return TRUE;
    case e_registrationReject :
      choice = new H225_RegistrationReject();
      return TRUE;
    case e_unregistrationRequest :
      choice = new H225_UnregistrationRequest();
      return TRUE;
    case e_unregistrationConfirm :
      choice = new H225_UnregistrationConfirm();
      return TRUE;
    case e_unregistrationReject :
      choice = new H225_UnregistrationReject();
      return TRUE;
    case e_admissionRequest :
      choice = new H225_AdmissionRequest();
      return TRUE;
    case e_admissionConfirm :
      choice = new H225_AdmissionConfirm();
      return TRUE;
    case e_admissionReject :
      choice = new H225_AdmissionReject();
      return TRUE;
    case e_bandwidthRequest :
      choice = new H225_BandwidthRequest();
      return TRUE;
    case e_bandwidthConfirm :
      choice = new H225_BandwidthConfirm();
      return TRUE;
    case e_bandwidthReject :
      choice = new H225_BandwidthReject();
      return TRUE;
    case e_disengageRequest :
      choice = new H225_DisengageRequest();
      return TRUE;
    case e_disengageConfirm :
      choice = new H225_DisengageConfirm();
      return TRUE;
    case e_disengageReject :
      choice = new H225_DisengageReject();
      return TRUE;
    case e_locationRequest :
      choice = new H225_LocationRequest();
      return TRUE;
    case e_locationConfirm :
      choice = new H225_LocationConfirm();
      return TRUE;
    case e_locationReject :
      choice = new H225_LocationReject();
      return TRUE;
    case e_infoRequest :
      choice = new H225_InfoRequest();
      return TRUE;
    case e_infoRequestResponse :
      choice = new H225_InfoRequestResponse();
      return TRUE;
    case e_nonStandardMessage :
      choice = new H225_NonStandardMessage();
      return TRUE;
    case e_unknownMessageResponse :
      choice = new H225_UnknownMessageResponse();
      return TRUE;
    case e_requestInProgress :
      choice = new H225_RequestInProgress();
      return TRUE;
    case e_resourcesAvailableIndicate :
      choice = new H225_ResourcesAvailableIndicate();
      return TRUE;
    case e_resourcesAvailableConfirm :
      choice = new H225_ResourcesAvailableConfirm();
      return TRUE;
    case e_infoRequestAck :
      choice = new H225_InfoRequestAck();
      return TRUE;
    case e_infoRequestNak :
      choice = new H225_InfoRequestNak();
      return TRUE;
    case e_serviceControlIndication :
      choice = new H225_ServiceControlIndication();
      return TRUE;
    case e_serviceControlResponse :
      choice = new H225_ServiceControlResponse();
      return TRUE;
    case e_admissionConfirmSequence :
      choice = new H225_ArrayOf_AdmissionConfirm();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_RasMessage::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_RasMessage::Class()), PInvalidCast);
#endif
  return new H225_RasMessage(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_GatekeeperRejectReason[]={
      {"resourceUnavailable",0}
     ,{"terminalExcluded",1}
     ,{"invalidRevision",2}
     ,{"undefinedReason",3}
     ,{"securityDenial",4}
     ,{"genericDataReason",5}
     ,{"neededFeatureNotSupported",6}
     ,{"securityError",7}
};
#endif
//
// GatekeeperRejectReason
//

H225_GatekeeperRejectReason::H225_GatekeeperRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_GatekeeperRejectReason,8
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_GatekeeperRejectReason::operator H225_SecurityErrors &() const
#else
H225_GatekeeperRejectReason::operator H225_SecurityErrors &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors), PInvalidCast);
#endif
  return *(H225_SecurityErrors *)choice;
}


H225_GatekeeperRejectReason::operator const H225_SecurityErrors &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors), PInvalidCast);
#endif
  return *(H225_SecurityErrors *)choice;
}


PBoolean H225_GatekeeperRejectReason::CreateObject()
{
  switch (tag) {
    case e_resourceUnavailable :
    case e_terminalExcluded :
    case e_invalidRevision :
    case e_undefinedReason :
    case e_securityDenial :
    case e_genericDataReason :
    case e_neededFeatureNotSupported :
      choice = new PASN_Null();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_GatekeeperRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_GatekeeperRejectReason::Class()), PInvalidCast);
#endif
  return new H225_GatekeeperRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_RegistrationRejectReason[]={
      {"discoveryRequired",0}
     ,{"invalidRevision",1}
     ,{"invalidCallSignalAddress",2}
     ,{"invalidRASAddress",3}
     ,{"duplicateAlias",4}
     ,{"invalidTerminalType",5}
     ,{"undefinedReason",6}
     ,{"transportNotSupported",7}
     ,{"transportQOSNotSupported",8}
     ,{"resourceUnavailable",9}
     ,{"invalidAlias",10}
     ,{"securityDenial",11}
     ,{"fullRegistrationRequired",12}
     ,{"additiveRegistrationNotSupported",13}
     ,{"invalidTerminalAliases",14}
     ,{"genericDataReason",15}
     ,{"neededFeatureNotSupported",16}
     ,{"securityError",17}
     ,{"registerWithAssignedGK",18}
};
#endif
//
// RegistrationRejectReason
//

H225_RegistrationRejectReason::H225_RegistrationRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 8, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_RegistrationRejectReason,19
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RegistrationRejectReason::operator H225_ArrayOf_AliasAddress &() const
#else
H225_RegistrationRejectReason::operator H225_ArrayOf_AliasAddress &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_AliasAddress), PInvalidCast);
#endif
  return *(H225_ArrayOf_AliasAddress *)choice;
}


H225_RegistrationRejectReason::operator const H225_ArrayOf_AliasAddress &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_AliasAddress), PInvalidCast);
#endif
  return *(H225_ArrayOf_AliasAddress *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RegistrationRejectReason::operator H225_RegistrationRejectReason_invalidTerminalAliases &() const
#else
H225_RegistrationRejectReason::operator H225_RegistrationRejectReason_invalidTerminalAliases &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationRejectReason_invalidTerminalAliases), PInvalidCast);
#endif
  return *(H225_RegistrationRejectReason_invalidTerminalAliases *)choice;
}


H225_RegistrationRejectReason::operator const H225_RegistrationRejectReason_invalidTerminalAliases &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_RegistrationRejectReason_invalidTerminalAliases), PInvalidCast);
#endif
  return *(H225_RegistrationRejectReason_invalidTerminalAliases *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_RegistrationRejectReason::operator H225_SecurityErrors &() const
#else
H225_RegistrationRejectReason::operator H225_SecurityErrors &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors), PInvalidCast);
#endif
  return *(H225_SecurityErrors *)choice;
}


H225_RegistrationRejectReason::operator const H225_SecurityErrors &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors), PInvalidCast);
#endif
  return *(H225_SecurityErrors *)choice;
}


PBoolean H225_RegistrationRejectReason::CreateObject()
{
  switch (tag) {
    case e_discoveryRequired :
    case e_invalidRevision :
    case e_invalidCallSignalAddress :
    case e_invalidRASAddress :
    case e_invalidTerminalType :
    case e_undefinedReason :
    case e_transportNotSupported :
    case e_transportQOSNotSupported :
    case e_resourceUnavailable :
    case e_invalidAlias :
    case e_securityDenial :
    case e_fullRegistrationRequired :
    case e_additiveRegistrationNotSupported :
    case e_genericDataReason :
    case e_neededFeatureNotSupported :
    case e_registerWithAssignedGK :
      choice = new PASN_Null();
      return TRUE;
    case e_duplicateAlias :
      choice = new H225_ArrayOf_AliasAddress();
      return TRUE;
    case e_invalidTerminalAliases :
      choice = new H225_RegistrationRejectReason_invalidTerminalAliases();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_RegistrationRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_RegistrationRejectReason::Class()), PInvalidCast);
#endif
  return new H225_RegistrationRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_UnregRequestReason[]={
      {"reregistrationRequired",0}
     ,{"ttlExpired",1}
     ,{"securityDenial",2}
     ,{"undefinedReason",3}
     ,{"maintenance",4}
     ,{"securityError",5}
     ,{"registerWithAssignedGK",6}
};
#endif
//
// UnregRequestReason
//

H225_UnregRequestReason::H225_UnregRequestReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_UnregRequestReason,7
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_UnregRequestReason::operator H225_SecurityErrors2 &() const
#else
H225_UnregRequestReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_UnregRequestReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_UnregRequestReason::CreateObject()
{
  switch (tag) {
    case e_reregistrationRequired :
    case e_ttlExpired :
    case e_securityDenial :
    case e_undefinedReason :
    case e_maintenance :
    case e_registerWithAssignedGK :
      choice = new PASN_Null();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_UnregRequestReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_UnregRequestReason::Class()), PInvalidCast);
#endif
  return new H225_UnregRequestReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_UnregRejectReason[]={
      {"notCurrentlyRegistered",0}
     ,{"callInProgress",1}
     ,{"undefinedReason",2}
     ,{"permissionDenied",3}
     ,{"securityDenial",4}
     ,{"securityError",5}
};
#endif
//
// UnregRejectReason
//

H225_UnregRejectReason::H225_UnregRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_UnregRejectReason,6
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_UnregRejectReason::operator H225_SecurityErrors2 &() const
#else
H225_UnregRejectReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_UnregRejectReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_UnregRejectReason::CreateObject()
{
  switch (tag) {
    case e_notCurrentlyRegistered :
    case e_callInProgress :
    case e_undefinedReason :
    case e_permissionDenied :
    case e_securityDenial :
      choice = new PASN_Null();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_UnregRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_UnregRejectReason::Class()), PInvalidCast);
#endif
  return new H225_UnregRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_CallType[]={
      {"pointToPoint",0}
     ,{"oneToN",1}
     ,{"nToOne",2}
     ,{"nToN",3}
};
#endif
//
// CallType
//

H225_CallType::H225_CallType(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_CallType,4
#endif
)
{
}


PBoolean H225_CallType::CreateObject()
{
  choice = (tag <= e_nToN) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_CallType::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallType::Class()), PInvalidCast);
#endif
  return new H225_CallType(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_CallModel[]={
      {"direct",0}
     ,{"gatekeeperRouted",1}
};
#endif
//
// CallModel
//

H225_CallModel::H225_CallModel(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_CallModel,2
#endif
)
{
}


PBoolean H225_CallModel::CreateObject()
{
  choice = (tag <= e_gatekeeperRouted) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_CallModel::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallModel::Class()), PInvalidCast);
#endif
  return new H225_CallModel(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_TransportQOS[]={
      {"endpointControlled",0}
     ,{"gatekeeperControlled",1}
     ,{"noControl",2}
     ,{"qOSCapabilities",3}
};
#endif
//
// TransportQOS
//

H225_TransportQOS::H225_TransportQOS(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_TransportQOS,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TransportQOS::operator H225_ArrayOf_QOSCapability &() const
#else
H225_TransportQOS::operator H225_ArrayOf_QOSCapability &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_QOSCapability), PInvalidCast);
#endif
  return *(H225_ArrayOf_QOSCapability *)choice;
}


H225_TransportQOS::operator const H225_ArrayOf_QOSCapability &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_QOSCapability), PInvalidCast);
#endif
  return *(H225_ArrayOf_QOSCapability *)choice;
}


PBoolean H225_TransportQOS::CreateObject()
{
  switch (tag) {
    case e_endpointControlled :
    case e_gatekeeperControlled :
    case e_noControl :
      choice = new PASN_Null();
      return TRUE;
    case e_qOSCapabilities :
      choice = new H225_ArrayOf_QOSCapability();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 256);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_TransportQOS::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TransportQOS::Class()), PInvalidCast);
#endif
  return new H225_TransportQOS(*this);
}


//
// UUIEsRequested
//

H225_UUIEsRequested::H225_UUIEsRequested(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 4)
{
  IncludeOptionalField(e_status);
  IncludeOptionalField(e_statusInquiry);
  IncludeOptionalField(e_setupAcknowledge);
  IncludeOptionalField(e_notify);
}


#ifndef PASN_NOPRINTON
void H225_UUIEsRequested::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+8) << "setup = " << setprecision(indent) << m_setup << '\n';
  strm << setw(indent+17) << "callProceeding = " << setprecision(indent) << m_callProceeding << '\n';
  strm << setw(indent+10) << "connect = " << setprecision(indent) << m_connect << '\n';
  strm << setw(indent+11) << "alerting = " << setprecision(indent) << m_alerting << '\n';
  strm << setw(indent+14) << "information = " << setprecision(indent) << m_information << '\n';
  strm << setw(indent+18) << "releaseComplete = " << setprecision(indent) << m_releaseComplete << '\n';
  strm << setw(indent+11) << "facility = " << setprecision(indent) << m_facility << '\n';
  strm << setw(indent+11) << "progress = " << setprecision(indent) << m_progress << '\n';
  strm << setw(indent+8) << "empty = " << setprecision(indent) << m_empty << '\n';
  if (HasOptionalField(e_status))
    strm << setw(indent+9) << "status = " << setprecision(indent) << m_status << '\n';
  if (HasOptionalField(e_statusInquiry))
    strm << setw(indent+16) << "statusInquiry = " << setprecision(indent) << m_statusInquiry << '\n';
  if (HasOptionalField(e_setupAcknowledge))
    strm << setw(indent+19) << "setupAcknowledge = " << setprecision(indent) << m_setupAcknowledge << '\n';
  if (HasOptionalField(e_notify))
    strm << setw(indent+9) << "notify = " << setprecision(indent) << m_notify << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_UUIEsRequested::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_UUIEsRequested), PInvalidCast);
#endif
  const H225_UUIEsRequested & other = (const H225_UUIEsRequested &)obj;

  Comparison result;

  if ((result = m_setup.Compare(other.m_setup)) != EqualTo)
    return result;
  if ((result = m_callProceeding.Compare(other.m_callProceeding)) != EqualTo)
    return result;
  if ((result = m_connect.Compare(other.m_connect)) != EqualTo)
    return result;
  if ((result = m_alerting.Compare(other.m_alerting)) != EqualTo)
    return result;
  if ((result = m_information.Compare(other.m_information)) != EqualTo)
    return result;
  if ((result = m_releaseComplete.Compare(other.m_releaseComplete)) != EqualTo)
    return result;
  if ((result = m_facility.Compare(other.m_facility)) != EqualTo)
    return result;
  if ((result = m_progress.Compare(other.m_progress)) != EqualTo)
    return result;
  if ((result = m_empty.Compare(other.m_empty)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_UUIEsRequested::GetDataLength() const
{
  PINDEX length = 0;
  length += m_setup.GetObjectLength();
  length += m_callProceeding.GetObjectLength();
  length += m_connect.GetObjectLength();
  length += m_alerting.GetObjectLength();
  length += m_information.GetObjectLength();
  length += m_releaseComplete.GetObjectLength();
  length += m_facility.GetObjectLength();
  length += m_progress.GetObjectLength();
  length += m_empty.GetObjectLength();
  return length;
}


PBoolean H225_UUIEsRequested::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_setup.Decode(strm))
    return FALSE;
  if (!m_callProceeding.Decode(strm))
    return FALSE;
  if (!m_connect.Decode(strm))
    return FALSE;
  if (!m_alerting.Decode(strm))
    return FALSE;
  if (!m_information.Decode(strm))
    return FALSE;
  if (!m_releaseComplete.Decode(strm))
    return FALSE;
  if (!m_facility.Decode(strm))
    return FALSE;
  if (!m_progress.Decode(strm))
    return FALSE;
  if (!m_empty.Decode(strm))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_status, m_status))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_statusInquiry, m_statusInquiry))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_setupAcknowledge, m_setupAcknowledge))
    return FALSE;
  if (!KnownExtensionDecode(strm, e_notify, m_notify))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_UUIEsRequested::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_setup.Encode(strm);
  m_callProceeding.Encode(strm);
  m_connect.Encode(strm);
  m_alerting.Encode(strm);
  m_information.Encode(strm);
  m_releaseComplete.Encode(strm);
  m_facility.Encode(strm);
  m_progress.Encode(strm);
  m_empty.Encode(strm);
  KnownExtensionEncode(strm, e_status, m_status);
  KnownExtensionEncode(strm, e_statusInquiry, m_statusInquiry);
  KnownExtensionEncode(strm, e_setupAcknowledge, m_setupAcknowledge);
  KnownExtensionEncode(strm, e_notify, m_notify);

  UnknownExtensionsEncode(strm);
}


PObject * H225_UUIEsRequested::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_UUIEsRequested::Class()), PInvalidCast);
#endif
  return new H225_UUIEsRequested(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_AdmissionRejectReason[]={
      {"calledPartyNotRegistered",0}
     ,{"invalidPermission",1}
     ,{"requestDenied",2}
     ,{"undefinedReason",3}
     ,{"callerNotRegistered",4}
     ,{"routeCallToGatekeeper",5}
     ,{"invalidEndpointIdentifier",6}
     ,{"resourceUnavailable",7}
     ,{"securityDenial",8}
     ,{"qosControlNotSupported",9}
     ,{"incompleteAddress",10}
     ,{"aliasesInconsistent",11}
     ,{"routeCallToSCN",12}
     ,{"exceedsCallCapacity",13}
     ,{"collectDestination",14}
     ,{"collectPIN",15}
     ,{"genericDataReason",16}
     ,{"neededFeatureNotSupported",17}
     ,{"securityErrors",18}
     ,{"securityDHmismatch",19}
     ,{"noRouteToDestination",20}
     ,{"unallocatedNumber",21}
     ,{"registerWithAssignedGK",22}
};
#endif
//
// AdmissionRejectReason
//

H225_AdmissionRejectReason::H225_AdmissionRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 8, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_AdmissionRejectReason,23
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AdmissionRejectReason::operator H225_ArrayOf_PartyNumber &() const
#else
H225_AdmissionRejectReason::operator H225_ArrayOf_PartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_PartyNumber), PInvalidCast);
#endif
  return *(H225_ArrayOf_PartyNumber *)choice;
}


H225_AdmissionRejectReason::operator const H225_ArrayOf_PartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_PartyNumber), PInvalidCast);
#endif
  return *(H225_ArrayOf_PartyNumber *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_AdmissionRejectReason::operator H225_SecurityErrors2 &() const
#else
H225_AdmissionRejectReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_AdmissionRejectReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_AdmissionRejectReason::CreateObject()
{
  switch (tag) {
    case e_calledPartyNotRegistered :
    case e_invalidPermission :
    case e_requestDenied :
    case e_undefinedReason :
    case e_callerNotRegistered :
    case e_routeCallToGatekeeper :
    case e_invalidEndpointIdentifier :
    case e_resourceUnavailable :
    case e_securityDenial :
    case e_qosControlNotSupported :
    case e_incompleteAddress :
    case e_aliasesInconsistent :
    case e_exceedsCallCapacity :
    case e_collectDestination :
    case e_collectPIN :
    case e_genericDataReason :
    case e_neededFeatureNotSupported :
    case e_securityDHmismatch :
    case e_noRouteToDestination :
    case e_unallocatedNumber :
    case e_registerWithAssignedGK :
      choice = new PASN_Null();
      return TRUE;
    case e_routeCallToSCN :
      choice = new H225_ArrayOf_PartyNumber();
      return TRUE;
    case e_securityErrors :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_AdmissionRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_AdmissionRejectReason::Class()), PInvalidCast);
#endif
  return new H225_AdmissionRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_BandRejectReason[]={
      {"notBound",0}
     ,{"invalidConferenceID",1}
     ,{"invalidPermission",2}
     ,{"insufficientResources",3}
     ,{"invalidRevision",4}
     ,{"undefinedReason",5}
     ,{"securityDenial",6}
     ,{"securityError",7}
};
#endif
//
// BandRejectReason
//

H225_BandRejectReason::H225_BandRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 6, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_BandRejectReason,8
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_BandRejectReason::operator H225_SecurityErrors2 &() const
#else
H225_BandRejectReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_BandRejectReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_BandRejectReason::CreateObject()
{
  switch (tag) {
    case e_notBound :
    case e_invalidConferenceID :
    case e_invalidPermission :
    case e_insufficientResources :
    case e_invalidRevision :
    case e_undefinedReason :
    case e_securityDenial :
      choice = new PASN_Null();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_BandRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_BandRejectReason::Class()), PInvalidCast);
#endif
  return new H225_BandRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_LocationRejectReason[]={
      {"notRegistered",0}
     ,{"invalidPermission",1}
     ,{"requestDenied",2}
     ,{"undefinedReason",3}
     ,{"securityDenial",4}
     ,{"aliasesInconsistent",5}
     ,{"routeCalltoSCN",6}
     ,{"resourceUnavailable",7}
     ,{"genericDataReason",8}
     ,{"neededFeatureNotSupported",9}
     ,{"hopCountExceeded",10}
     ,{"incompleteAddress",11}
     ,{"securityError",12}
     ,{"securityDHmismatch",13}
     ,{"noRouteToDestination",14}
     ,{"unallocatedNumber",15}
};
#endif
//
// LocationRejectReason
//

H225_LocationRejectReason::H225_LocationRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_LocationRejectReason,16
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_LocationRejectReason::operator H225_ArrayOf_PartyNumber &() const
#else
H225_LocationRejectReason::operator H225_ArrayOf_PartyNumber &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_PartyNumber), PInvalidCast);
#endif
  return *(H225_ArrayOf_PartyNumber *)choice;
}


H225_LocationRejectReason::operator const H225_ArrayOf_PartyNumber &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ArrayOf_PartyNumber), PInvalidCast);
#endif
  return *(H225_ArrayOf_PartyNumber *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_LocationRejectReason::operator H225_SecurityErrors2 &() const
#else
H225_LocationRejectReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_LocationRejectReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_LocationRejectReason::CreateObject()
{
  switch (tag) {
    case e_notRegistered :
    case e_invalidPermission :
    case e_requestDenied :
    case e_undefinedReason :
    case e_securityDenial :
    case e_aliasesInconsistent :
    case e_resourceUnavailable :
    case e_genericDataReason :
    case e_neededFeatureNotSupported :
    case e_hopCountExceeded :
    case e_incompleteAddress :
    case e_securityDHmismatch :
    case e_noRouteToDestination :
    case e_unallocatedNumber :
      choice = new PASN_Null();
      return TRUE;
    case e_routeCalltoSCN :
      choice = new H225_ArrayOf_PartyNumber();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_LocationRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_LocationRejectReason::Class()), PInvalidCast);
#endif
  return new H225_LocationRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_DisengageReason[]={
      {"forcedDrop",0}
     ,{"normalDrop",1}
     ,{"undefinedReason",2}
};
#endif
//
// DisengageReason
//

H225_DisengageReason::H225_DisengageReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_DisengageReason,3
#endif
)
{
}


PBoolean H225_DisengageReason::CreateObject()
{
  choice = (tag <= e_undefinedReason) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_DisengageReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_DisengageReason::Class()), PInvalidCast);
#endif
  return new H225_DisengageReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_DisengageRejectReason[]={
      {"notRegistered",0}
     ,{"requestToDropOther",1}
     ,{"securityDenial",2}
     ,{"securityError",3}
};
#endif
//
// DisengageRejectReason
//

H225_DisengageRejectReason::H225_DisengageRejectReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_DisengageRejectReason,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_DisengageRejectReason::operator H225_SecurityErrors2 &() const
#else
H225_DisengageRejectReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_DisengageRejectReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_DisengageRejectReason::CreateObject()
{
  switch (tag) {
    case e_notRegistered :
    case e_requestToDropOther :
    case e_securityDenial :
      choice = new PASN_Null();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_DisengageRejectReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_DisengageRejectReason::Class()), PInvalidCast);
#endif
  return new H225_DisengageRejectReason(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_InfoRequestResponseStatus[]={
      {"complete",0}
     ,{"incomplete",1}
     ,{"segment",2}
     ,{"invalidCall",3}
};
#endif
//
// InfoRequestResponseStatus
//

H225_InfoRequestResponseStatus::H225_InfoRequestResponseStatus(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 4, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_InfoRequestResponseStatus,4
#endif
)
{
}


PBoolean H225_InfoRequestResponseStatus::CreateObject()
{
  switch (tag) {
    case e_complete :
    case e_incomplete :
    case e_invalidCall :
      choice = new PASN_Null();
      return TRUE;
    case e_segment :
      choice = new PASN_Integer();
      choice->SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_InfoRequestResponseStatus::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_InfoRequestResponseStatus::Class()), PInvalidCast);
#endif
  return new H225_InfoRequestResponseStatus(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_InfoRequestNakReason[]={
      {"notRegistered",0}
     ,{"securityDenial",1}
     ,{"undefinedReason",2}
     ,{"securityError",3}
};
#endif
//
// InfoRequestNakReason
//

H225_InfoRequestNakReason::H225_InfoRequestNakReason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_InfoRequestNakReason,4
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_InfoRequestNakReason::operator H225_SecurityErrors2 &() const
#else
H225_InfoRequestNakReason::operator H225_SecurityErrors2 &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


H225_InfoRequestNakReason::operator const H225_SecurityErrors2 &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SecurityErrors2), PInvalidCast);
#endif
  return *(H225_SecurityErrors2 *)choice;
}


PBoolean H225_InfoRequestNakReason::CreateObject()
{
  switch (tag) {
    case e_notRegistered :
    case e_securityDenial :
    case e_undefinedReason :
      choice = new PASN_Null();
      return TRUE;
    case e_securityError :
      choice = new H225_SecurityErrors2();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_InfoRequestNakReason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_InfoRequestNakReason::Class()), PInvalidCast);
#endif
  return new H225_InfoRequestNakReason(*this);
}


//
// H323-UserInformation_user-data
//

H225_H323_UserInformation_user_data::H225_H323_UserInformation_user_data(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
  m_protocol_discriminator.SetConstraints(PASN_Object::FixedConstraint, 0, 255);
  m_user_information.SetConstraints(PASN_Object::FixedConstraint, 1, 131);
}


#ifndef PASN_NOPRINTON
void H225_H323_UserInformation_user_data::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+25) << "protocol_discriminator = " << setprecision(indent) << m_protocol_discriminator << '\n';
  strm << setw(indent+19) << "user_information = " << setprecision(indent) << m_user_information << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_H323_UserInformation_user_data::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_H323_UserInformation_user_data), PInvalidCast);
#endif
  const H225_H323_UserInformation_user_data & other = (const H225_H323_UserInformation_user_data &)obj;

  Comparison result;

  if ((result = m_protocol_discriminator.Compare(other.m_protocol_discriminator)) != EqualTo)
    return result;
  if ((result = m_user_information.Compare(other.m_user_information)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_H323_UserInformation_user_data::GetDataLength() const
{
  PINDEX length = 0;
  length += m_protocol_discriminator.GetObjectLength();
  length += m_user_information.GetObjectLength();
  return length;
}


PBoolean H225_H323_UserInformation_user_data::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_protocol_discriminator.Decode(strm))
    return FALSE;
  if (!m_user_information.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_H323_UserInformation_user_data::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_protocol_discriminator.Encode(strm);
  m_user_information.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_H323_UserInformation_user_data::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_H323_UserInformation_user_data::Class()), PInvalidCast);
#endif
  return new H225_H323_UserInformation_user_data(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_H323_UU_PDU_h323_message_body[]={
      {"setup",0}
     ,{"callProceeding",1}
     ,{"connect",2}
     ,{"alerting",3}
     ,{"information",4}
     ,{"releaseComplete",5}
     ,{"facility",6}
     ,{"progress",7}
     ,{"empty",8}
     ,{"status",9}
     ,{"statusInquiry",10}
     ,{"setupAcknowledge",11}
     ,{"notify",12}
};
#endif
//
// H323-UU-PDU_h323-message-body
//

H225_H323_UU_PDU_h323_message_body::H225_H323_UU_PDU_h323_message_body(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 7, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_H323_UU_PDU_h323_message_body,13
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Setup_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Setup_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Setup_UUIE), PInvalidCast);
#endif
  return *(H225_Setup_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Setup_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Setup_UUIE), PInvalidCast);
#endif
  return *(H225_Setup_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_CallProceeding_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_CallProceeding_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CallProceeding_UUIE), PInvalidCast);
#endif
  return *(H225_CallProceeding_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_CallProceeding_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_CallProceeding_UUIE), PInvalidCast);
#endif
  return *(H225_CallProceeding_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Connect_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Connect_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Connect_UUIE), PInvalidCast);
#endif
  return *(H225_Connect_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Connect_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Connect_UUIE), PInvalidCast);
#endif
  return *(H225_Connect_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Alerting_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Alerting_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Alerting_UUIE), PInvalidCast);
#endif
  return *(H225_Alerting_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Alerting_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Alerting_UUIE), PInvalidCast);
#endif
  return *(H225_Alerting_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Information_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Information_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Information_UUIE), PInvalidCast);
#endif
  return *(H225_Information_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Information_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Information_UUIE), PInvalidCast);
#endif
  return *(H225_Information_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_ReleaseComplete_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_ReleaseComplete_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ReleaseComplete_UUIE), PInvalidCast);
#endif
  return *(H225_ReleaseComplete_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_ReleaseComplete_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_ReleaseComplete_UUIE), PInvalidCast);
#endif
  return *(H225_ReleaseComplete_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Facility_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Facility_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Facility_UUIE), PInvalidCast);
#endif
  return *(H225_Facility_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Facility_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Facility_UUIE), PInvalidCast);
#endif
  return *(H225_Facility_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Progress_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Progress_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Progress_UUIE), PInvalidCast);
#endif
  return *(H225_Progress_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Progress_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Progress_UUIE), PInvalidCast);
#endif
  return *(H225_Progress_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Status_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Status_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Status_UUIE), PInvalidCast);
#endif
  return *(H225_Status_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Status_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Status_UUIE), PInvalidCast);
#endif
  return *(H225_Status_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_StatusInquiry_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_StatusInquiry_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_StatusInquiry_UUIE), PInvalidCast);
#endif
  return *(H225_StatusInquiry_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_StatusInquiry_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_StatusInquiry_UUIE), PInvalidCast);
#endif
  return *(H225_StatusInquiry_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_SetupAcknowledge_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_SetupAcknowledge_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SetupAcknowledge_UUIE), PInvalidCast);
#endif
  return *(H225_SetupAcknowledge_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_SetupAcknowledge_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_SetupAcknowledge_UUIE), PInvalidCast);
#endif
  return *(H225_SetupAcknowledge_UUIE *)choice;
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_H323_UU_PDU_h323_message_body::operator H225_Notify_UUIE &() const
#else
H225_H323_UU_PDU_h323_message_body::operator H225_Notify_UUIE &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Notify_UUIE), PInvalidCast);
#endif
  return *(H225_Notify_UUIE *)choice;
}


H225_H323_UU_PDU_h323_message_body::operator const H225_Notify_UUIE &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_Notify_UUIE), PInvalidCast);
#endif
  return *(H225_Notify_UUIE *)choice;
}


PBoolean H225_H323_UU_PDU_h323_message_body::CreateObject()
{
  switch (tag) {
    case e_setup :
      choice = new H225_Setup_UUIE();
      return TRUE;
    case e_callProceeding :
      choice = new H225_CallProceeding_UUIE();
      return TRUE;
    case e_connect :
      choice = new H225_Connect_UUIE();
      return TRUE;
    case e_alerting :
      choice = new H225_Alerting_UUIE();
      return TRUE;
    case e_information :
      choice = new H225_Information_UUIE();
      return TRUE;
    case e_releaseComplete :
      choice = new H225_ReleaseComplete_UUIE();
      return TRUE;
    case e_facility :
      choice = new H225_Facility_UUIE();
      return TRUE;
    case e_progress :
      choice = new H225_Progress_UUIE();
      return TRUE;
    case e_empty :
      choice = new PASN_Null();
      return TRUE;
    case e_status :
      choice = new H225_Status_UUIE();
      return TRUE;
    case e_statusInquiry :
      choice = new H225_StatusInquiry_UUIE();
      return TRUE;
    case e_setupAcknowledge :
      choice = new H225_SetupAcknowledge_UUIE();
      return TRUE;
    case e_notify :
      choice = new H225_Notify_UUIE();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_H323_UU_PDU_h323_message_body::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_H323_UU_PDU_h323_message_body::Class()), PInvalidCast);
#endif
  return new H225_H323_UU_PDU_h323_message_body(*this);
}


//
// ArrayOf_PASN_OctetString
//

H225_ArrayOf_PASN_OctetString::H225_ArrayOf_PASN_OctetString(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_PASN_OctetString::CreateObject() const
{
  return new PASN_OctetString;
}


PASN_OctetString & H225_ArrayOf_PASN_OctetString::operator[](PINDEX i) const
{
  return (PASN_OctetString &)array[i];
}


PObject * H225_ArrayOf_PASN_OctetString::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_PASN_OctetString::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_PASN_OctetString(*this);
}


//
// ArrayOf_NonStandardParameter
//

H225_ArrayOf_NonStandardParameter::H225_ArrayOf_NonStandardParameter(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_NonStandardParameter::CreateObject() const
{
  return new H225_NonStandardParameter;
}


H225_NonStandardParameter & H225_ArrayOf_NonStandardParameter::operator[](PINDEX i) const
{
  return (H225_NonStandardParameter &)array[i];
}


PObject * H225_ArrayOf_NonStandardParameter::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_NonStandardParameter::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_NonStandardParameter(*this);
}


//
// ArrayOf_GenericData
//

H225_ArrayOf_GenericData::H225_ArrayOf_GenericData(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_GenericData::CreateObject() const
{
  return new H225_GenericData;
}


H225_GenericData & H225_ArrayOf_GenericData::operator[](PINDEX i) const
{
  return (H225_GenericData &)array[i];
}


PObject * H225_ArrayOf_GenericData::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_GenericData::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_GenericData(*this);
}


//
// ArrayOf_ClearToken
//

H225_ArrayOf_ClearToken::H225_ArrayOf_ClearToken(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_ClearToken::CreateObject() const
{
  return new H235_ClearToken;
}


H235_ClearToken & H225_ArrayOf_ClearToken::operator[](PINDEX i) const
{
  return (H235_ClearToken &)array[i];
}


PObject * H225_ArrayOf_ClearToken::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_ClearToken::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_ClearToken(*this);
}


//
// ArrayOf_CryptoH323Token
//

H225_ArrayOf_CryptoH323Token::H225_ArrayOf_CryptoH323Token(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_CryptoH323Token::CreateObject() const
{
  return new H225_CryptoH323Token;
}


H225_CryptoH323Token & H225_ArrayOf_CryptoH323Token::operator[](PINDEX i) const
{
  return (H225_CryptoH323Token &)array[i];
}


PObject * H225_ArrayOf_CryptoH323Token::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_CryptoH323Token::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_CryptoH323Token(*this);
}


//
// ArrayOf_AliasAddress
//

H225_ArrayOf_AliasAddress::H225_ArrayOf_AliasAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_AliasAddress::CreateObject() const
{
  return new H225_AliasAddress;
}


H225_AliasAddress & H225_ArrayOf_AliasAddress::operator[](PINDEX i) const
{
  return (H225_AliasAddress &)array[i];
}


PObject * H225_ArrayOf_AliasAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_AliasAddress::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_AliasAddress(*this);
}


//
// ArrayOf_ServiceControlSession
//

H225_ArrayOf_ServiceControlSession::H225_ArrayOf_ServiceControlSession(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_ServiceControlSession::CreateObject() const
{
  return new H225_ServiceControlSession;
}


H225_ServiceControlSession & H225_ArrayOf_ServiceControlSession::operator[](PINDEX i) const
{
  return (H225_ServiceControlSession &)array[i];
}


PObject * H225_ArrayOf_ServiceControlSession::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_ServiceControlSession::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_ServiceControlSession(*this);
}


//
// Connect-UUIE_language
//

H225_Connect_UUIE_language::H225_Connect_UUIE_language(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_Connect_UUIE_language::CreateObject() const
{
  PASN_IA5String * obj = new PASN_IA5String;
  obj->SetConstraints(PASN_Object::FixedConstraint, 1, 32);
  return obj;
}


PASN_IA5String & H225_Connect_UUIE_language::operator[](PINDEX i) const
{
  return (PASN_IA5String &)array[i];
}


PObject * H225_Connect_UUIE_language::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_Connect_UUIE_language::Class()), PInvalidCast);
#endif
  return new H225_Connect_UUIE_language(*this);
}


//
// ArrayOf_CallReferenceValue
//

H225_ArrayOf_CallReferenceValue::H225_ArrayOf_CallReferenceValue(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_CallReferenceValue::CreateObject() const
{
  return new H225_CallReferenceValue;
}


H225_CallReferenceValue & H225_ArrayOf_CallReferenceValue::operator[](PINDEX i) const
{
  return (H225_CallReferenceValue &)array[i];
}


PObject * H225_ArrayOf_CallReferenceValue::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_CallReferenceValue::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_CallReferenceValue(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_Setup_UUIE_conferenceGoal[]={
      {"create",0}
     ,{"join",1}
     ,{"invite",2}
     ,{"capability_negotiation",3}
     ,{"callIndependentSupplementaryService",4}
};
#endif
//
// Setup-UUIE_conferenceGoal
//

H225_Setup_UUIE_conferenceGoal::H225_Setup_UUIE_conferenceGoal(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_Setup_UUIE_conferenceGoal,5
#endif
)
{
}


PBoolean H225_Setup_UUIE_conferenceGoal::CreateObject()
{
  choice = (tag <= e_callIndependentSupplementaryService) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_Setup_UUIE_conferenceGoal::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_Setup_UUIE_conferenceGoal::Class()), PInvalidCast);
#endif
  return new H225_Setup_UUIE_conferenceGoal(*this);
}


//
// ArrayOf_H245Security
//

H225_ArrayOf_H245Security::H225_ArrayOf_H245Security(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_H245Security::CreateObject() const
{
  return new H225_H245Security;
}


H225_H245Security & H225_ArrayOf_H245Security::operator[](PINDEX i) const
{
  return (H225_H245Security &)array[i];
}


PObject * H225_ArrayOf_H245Security::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_H245Security::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_H245Security(*this);
}


//
// Setup-UUIE_connectionParameters
//

H225_Setup_UUIE_connectionParameters::H225_Setup_UUIE_connectionParameters(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
  m_numberOfScnConnections.SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


#ifndef PASN_NOPRINTON
void H225_Setup_UUIE_connectionParameters::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+17) << "connectionType = " << setprecision(indent) << m_connectionType << '\n';
  strm << setw(indent+25) << "numberOfScnConnections = " << setprecision(indent) << m_numberOfScnConnections << '\n';
  strm << setw(indent+24) << "connectionAggregation = " << setprecision(indent) << m_connectionAggregation << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_Setup_UUIE_connectionParameters::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_Setup_UUIE_connectionParameters), PInvalidCast);
#endif
  const H225_Setup_UUIE_connectionParameters & other = (const H225_Setup_UUIE_connectionParameters &)obj;

  Comparison result;

  if ((result = m_connectionType.Compare(other.m_connectionType)) != EqualTo)
    return result;
  if ((result = m_numberOfScnConnections.Compare(other.m_numberOfScnConnections)) != EqualTo)
    return result;
  if ((result = m_connectionAggregation.Compare(other.m_connectionAggregation)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_Setup_UUIE_connectionParameters::GetDataLength() const
{
  PINDEX length = 0;
  length += m_connectionType.GetObjectLength();
  length += m_numberOfScnConnections.GetObjectLength();
  length += m_connectionAggregation.GetObjectLength();
  return length;
}


PBoolean H225_Setup_UUIE_connectionParameters::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_connectionType.Decode(strm))
    return FALSE;
  if (!m_numberOfScnConnections.Decode(strm))
    return FALSE;
  if (!m_connectionAggregation.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_Setup_UUIE_connectionParameters::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_connectionType.Encode(strm);
  m_numberOfScnConnections.Encode(strm);
  m_connectionAggregation.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_Setup_UUIE_connectionParameters::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_Setup_UUIE_connectionParameters::Class()), PInvalidCast);
#endif
  return new H225_Setup_UUIE_connectionParameters(*this);
}


//
// Setup-UUIE_language
//

H225_Setup_UUIE_language::H225_Setup_UUIE_language(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_Setup_UUIE_language::CreateObject() const
{
  PASN_IA5String * obj = new PASN_IA5String;
  obj->SetConstraints(PASN_Object::FixedConstraint, 1, 32);
  return obj;
}


PASN_IA5String & H225_Setup_UUIE_language::operator[](PINDEX i) const
{
  return (PASN_IA5String &)array[i];
}


PObject * H225_Setup_UUIE_language::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_Setup_UUIE_language::Class()), PInvalidCast);
#endif
  return new H225_Setup_UUIE_language(*this);
}


//
// ArrayOf_SupportedProtocols
//

H225_ArrayOf_SupportedProtocols::H225_ArrayOf_SupportedProtocols(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_SupportedProtocols::CreateObject() const
{
  return new H225_SupportedProtocols;
}


H225_SupportedProtocols & H225_ArrayOf_SupportedProtocols::operator[](PINDEX i) const
{
  return (H225_SupportedProtocols &)array[i];
}


PObject * H225_ArrayOf_SupportedProtocols::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_SupportedProtocols::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_SupportedProtocols(*this);
}


//
// ArrayOf_FeatureDescriptor
//

H225_ArrayOf_FeatureDescriptor::H225_ArrayOf_FeatureDescriptor(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_FeatureDescriptor::CreateObject() const
{
  return new H225_FeatureDescriptor;
}


H225_FeatureDescriptor & H225_ArrayOf_FeatureDescriptor::operator[](PINDEX i) const
{
  return (H225_FeatureDescriptor &)array[i];
}


PObject * H225_ArrayOf_FeatureDescriptor::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_FeatureDescriptor::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_FeatureDescriptor(*this);
}


//
// ArrayOf_ExtendedAliasAddress
//

H225_ArrayOf_ExtendedAliasAddress::H225_ArrayOf_ExtendedAliasAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_ExtendedAliasAddress::CreateObject() const
{
  return new H225_ExtendedAliasAddress;
}


H225_ExtendedAliasAddress & H225_ArrayOf_ExtendedAliasAddress::operator[](PINDEX i) const
{
  return (H225_ExtendedAliasAddress &)array[i];
}


PObject * H225_ArrayOf_ExtendedAliasAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_ExtendedAliasAddress::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_ExtendedAliasAddress(*this);
}


//
// ArrayOf_ConferenceList
//

H225_ArrayOf_ConferenceList::H225_ArrayOf_ConferenceList(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_ConferenceList::CreateObject() const
{
  return new H225_ConferenceList;
}


H225_ConferenceList & H225_ArrayOf_ConferenceList::operator[](PINDEX i) const
{
  return (H225_ConferenceList &)array[i];
}


PObject * H225_ArrayOf_ConferenceList::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_ConferenceList::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_ConferenceList(*this);
}


//
// TransportAddress_ipAddress
//

H225_TransportAddress_ipAddress::H225_TransportAddress_ipAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_ip.SetConstraints(PASN_Object::FixedConstraint, 4);
  m_port.SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


#ifndef PASN_NOPRINTON
void H225_TransportAddress_ipAddress::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+5) << "ip = " << setprecision(indent) << m_ip << '\n';
  strm << setw(indent+7) << "port = " << setprecision(indent) << m_port << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_TransportAddress_ipAddress::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_TransportAddress_ipAddress), PInvalidCast);
#endif
  const H225_TransportAddress_ipAddress & other = (const H225_TransportAddress_ipAddress &)obj;

  Comparison result;

  if ((result = m_ip.Compare(other.m_ip)) != EqualTo)
    return result;
  if ((result = m_port.Compare(other.m_port)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_TransportAddress_ipAddress::GetDataLength() const
{
  PINDEX length = 0;
  length += m_ip.GetObjectLength();
  length += m_port.GetObjectLength();
  return length;
}


PBoolean H225_TransportAddress_ipAddress::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_ip.Decode(strm))
    return FALSE;
  if (!m_port.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_TransportAddress_ipAddress::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_ip.Encode(strm);
  m_port.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_TransportAddress_ipAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TransportAddress_ipAddress::Class()), PInvalidCast);
#endif
  return new H225_TransportAddress_ipAddress(*this);
}


//
// TransportAddress_ipxAddress
//

H225_TransportAddress_ipxAddress::H225_TransportAddress_ipxAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
  m_node.SetConstraints(PASN_Object::FixedConstraint, 6);
  m_netnum.SetConstraints(PASN_Object::FixedConstraint, 4);
  m_port.SetConstraints(PASN_Object::FixedConstraint, 2);
}


#ifndef PASN_NOPRINTON
void H225_TransportAddress_ipxAddress::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+7) << "node = " << setprecision(indent) << m_node << '\n';
  strm << setw(indent+9) << "netnum = " << setprecision(indent) << m_netnum << '\n';
  strm << setw(indent+7) << "port = " << setprecision(indent) << m_port << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_TransportAddress_ipxAddress::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_TransportAddress_ipxAddress), PInvalidCast);
#endif
  const H225_TransportAddress_ipxAddress & other = (const H225_TransportAddress_ipxAddress &)obj;

  Comparison result;

  if ((result = m_node.Compare(other.m_node)) != EqualTo)
    return result;
  if ((result = m_netnum.Compare(other.m_netnum)) != EqualTo)
    return result;
  if ((result = m_port.Compare(other.m_port)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_TransportAddress_ipxAddress::GetDataLength() const
{
  PINDEX length = 0;
  length += m_node.GetObjectLength();
  length += m_netnum.GetObjectLength();
  length += m_port.GetObjectLength();
  return length;
}


PBoolean H225_TransportAddress_ipxAddress::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_node.Decode(strm))
    return FALSE;
  if (!m_netnum.Decode(strm))
    return FALSE;
  if (!m_port.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_TransportAddress_ipxAddress::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_node.Encode(strm);
  m_netnum.Encode(strm);
  m_port.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_TransportAddress_ipxAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TransportAddress_ipxAddress::Class()), PInvalidCast);
#endif
  return new H225_TransportAddress_ipxAddress(*this);
}


//
// TransportAddress_ip6Address
//

H225_TransportAddress_ip6Address::H225_TransportAddress_ip6Address(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, TRUE, 0)
{
  m_ip.SetConstraints(PASN_Object::FixedConstraint, 16);
  m_port.SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
}


#ifndef PASN_NOPRINTON
void H225_TransportAddress_ip6Address::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+5) << "ip = " << setprecision(indent) << m_ip << '\n';
  strm << setw(indent+7) << "port = " << setprecision(indent) << m_port << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_TransportAddress_ip6Address::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_TransportAddress_ip6Address), PInvalidCast);
#endif
  const H225_TransportAddress_ip6Address & other = (const H225_TransportAddress_ip6Address &)obj;

  Comparison result;

  if ((result = m_ip.Compare(other.m_ip)) != EqualTo)
    return result;
  if ((result = m_port.Compare(other.m_port)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_TransportAddress_ip6Address::GetDataLength() const
{
  PINDEX length = 0;
  length += m_ip.GetObjectLength();
  length += m_port.GetObjectLength();
  return length;
}


PBoolean H225_TransportAddress_ip6Address::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_ip.Decode(strm))
    return FALSE;
  if (!m_port.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_TransportAddress_ip6Address::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_ip.Encode(strm);
  m_port.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_TransportAddress_ip6Address::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TransportAddress_ip6Address::Class()), PInvalidCast);
#endif
  return new H225_TransportAddress_ip6Address(*this);
}


//
// ArrayOf_TunnelledProtocol
//

H225_ArrayOf_TunnelledProtocol::H225_ArrayOf_TunnelledProtocol(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_TunnelledProtocol::CreateObject() const
{
  return new H225_TunnelledProtocol;
}


H225_TunnelledProtocol & H225_ArrayOf_TunnelledProtocol::operator[](PINDEX i) const
{
  return (H225_TunnelledProtocol &)array[i];
}


PObject * H225_ArrayOf_TunnelledProtocol::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_TunnelledProtocol::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_TunnelledProtocol(*this);
}


//
// ArrayOf_DataRate
//

H225_ArrayOf_DataRate::H225_ArrayOf_DataRate(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_DataRate::CreateObject() const
{
  return new H225_DataRate;
}


H225_DataRate & H225_ArrayOf_DataRate::operator[](PINDEX i) const
{
  return (H225_DataRate &)array[i];
}


PObject * H225_ArrayOf_DataRate::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_DataRate::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_DataRate(*this);
}


//
// ArrayOf_SupportedPrefix
//

H225_ArrayOf_SupportedPrefix::H225_ArrayOf_SupportedPrefix(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_SupportedPrefix::CreateObject() const
{
  return new H225_SupportedPrefix;
}


H225_SupportedPrefix & H225_ArrayOf_SupportedPrefix::operator[](PINDEX i) const
{
  return (H225_SupportedPrefix &)array[i];
}


PObject * H225_ArrayOf_SupportedPrefix::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_SupportedPrefix::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_SupportedPrefix(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_TunnelledProtocol_id[]={
      {"tunnelledProtocolObjectID",0}
     ,{"tunnelledProtocolAlternateID",1}
};
#endif
//
// TunnelledProtocol_id
//

H225_TunnelledProtocol_id::H225_TunnelledProtocol_id(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_TunnelledProtocol_id,2
#endif
)
{
}


#if defined(__GNUC__) && __GNUC__ <= 2 && __GNUC_MINOR__ < 9
H225_TunnelledProtocol_id::operator H225_TunnelledProtocolAlternateIdentifier &() const
#else
H225_TunnelledProtocol_id::operator H225_TunnelledProtocolAlternateIdentifier &()
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TunnelledProtocolAlternateIdentifier), PInvalidCast);
#endif
  return *(H225_TunnelledProtocolAlternateIdentifier *)choice;
}


H225_TunnelledProtocol_id::operator const H225_TunnelledProtocolAlternateIdentifier &() const
#endif
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(PAssertNULL(choice), H225_TunnelledProtocolAlternateIdentifier), PInvalidCast);
#endif
  return *(H225_TunnelledProtocolAlternateIdentifier *)choice;
}


PBoolean H225_TunnelledProtocol_id::CreateObject()
{
  switch (tag) {
    case e_tunnelledProtocolObjectID :
      choice = new PASN_ObjectId();
      return TRUE;
    case e_tunnelledProtocolAlternateID :
      choice = new H225_TunnelledProtocolAlternateIdentifier();
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_TunnelledProtocol_id::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_TunnelledProtocol_id::Class()), PInvalidCast);
#endif
  return new H225_TunnelledProtocol_id(*this);
}


//
// AddressPattern_range
//

H225_AddressPattern_range::H225_AddressPattern_range(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_AddressPattern_range::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+15) << "startOfRange = " << setprecision(indent) << m_startOfRange << '\n';
  strm << setw(indent+13) << "endOfRange = " << setprecision(indent) << m_endOfRange << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_AddressPattern_range::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_AddressPattern_range), PInvalidCast);
#endif
  const H225_AddressPattern_range & other = (const H225_AddressPattern_range &)obj;

  Comparison result;

  if ((result = m_startOfRange.Compare(other.m_startOfRange)) != EqualTo)
    return result;
  if ((result = m_endOfRange.Compare(other.m_endOfRange)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_AddressPattern_range::GetDataLength() const
{
  PINDEX length = 0;
  length += m_startOfRange.GetObjectLength();
  length += m_endOfRange.GetObjectLength();
  return length;
}


PBoolean H225_AddressPattern_range::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_startOfRange.Decode(strm))
    return FALSE;
  if (!m_endOfRange.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_AddressPattern_range::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_startOfRange.Encode(strm);
  m_endOfRange.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_AddressPattern_range::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_AddressPattern_range::Class()), PInvalidCast);
#endif
  return new H225_AddressPattern_range(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ANSI_41_UIM_system_id[]={
      {"sid",0}
     ,{"mid",1}
};
#endif
//
// ANSI-41-UIM_system-id
//

H225_ANSI_41_UIM_system_id::H225_ANSI_41_UIM_system_id(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ANSI_41_UIM_system_id,2
#endif
)
{
}


PBoolean H225_ANSI_41_UIM_system_id::CreateObject()
{
  switch (tag) {
    case e_sid :
      choice = new PASN_IA5String();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 4);
      return TRUE;
    case e_mid :
      choice = new PASN_IA5String();
      choice->SetConstraints(PASN_Object::FixedConstraint, 1, 4);
      return TRUE;
  }

  choice = NULL;
  return FALSE;
}


PObject * H225_ANSI_41_UIM_system_id::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ANSI_41_UIM_system_id::Class()), PInvalidCast);
#endif
  return new H225_ANSI_41_UIM_system_id(*this);
}


//
// ArrayOf_TransportAddress
//

H225_ArrayOf_TransportAddress::H225_ArrayOf_TransportAddress(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_TransportAddress::CreateObject() const
{
  return new H225_TransportAddress;
}


H225_TransportAddress & H225_ArrayOf_TransportAddress::operator[](PINDEX i) const
{
  return (H225_TransportAddress &)array[i];
}


PObject * H225_ArrayOf_TransportAddress::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_TransportAddress::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_TransportAddress(*this);
}


//
// ArrayOf_AlternateGK
//

H225_ArrayOf_AlternateGK::H225_ArrayOf_AlternateGK(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_AlternateGK::CreateObject() const
{
  return new H225_AlternateGK;
}


H225_AlternateGK & H225_ArrayOf_AlternateGK::operator[](PINDEX i) const
{
  return (H225_AlternateGK &)array[i];
}


PObject * H225_ArrayOf_AlternateGK::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_AlternateGK::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_AlternateGK(*this);
}


//
// CryptoH323Token_cryptoEPPwdHash
//

H225_CryptoH323Token_cryptoEPPwdHash::H225_CryptoH323Token_cryptoEPPwdHash(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CryptoH323Token_cryptoEPPwdHash::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+8) << "alias = " << setprecision(indent) << m_alias << '\n';
  strm << setw(indent+12) << "timeStamp = " << setprecision(indent) << m_timeStamp << '\n';
  strm << setw(indent+8) << "token = " << setprecision(indent) << m_token << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CryptoH323Token_cryptoEPPwdHash::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CryptoH323Token_cryptoEPPwdHash), PInvalidCast);
#endif
  const H225_CryptoH323Token_cryptoEPPwdHash & other = (const H225_CryptoH323Token_cryptoEPPwdHash &)obj;

  Comparison result;

  if ((result = m_alias.Compare(other.m_alias)) != EqualTo)
    return result;
  if ((result = m_timeStamp.Compare(other.m_timeStamp)) != EqualTo)
    return result;
  if ((result = m_token.Compare(other.m_token)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CryptoH323Token_cryptoEPPwdHash::GetDataLength() const
{
  PINDEX length = 0;
  length += m_alias.GetObjectLength();
  length += m_timeStamp.GetObjectLength();
  length += m_token.GetObjectLength();
  return length;
}


PBoolean H225_CryptoH323Token_cryptoEPPwdHash::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_alias.Decode(strm))
    return FALSE;
  if (!m_timeStamp.Decode(strm))
    return FALSE;
  if (!m_token.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CryptoH323Token_cryptoEPPwdHash::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_alias.Encode(strm);
  m_timeStamp.Encode(strm);
  m_token.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CryptoH323Token_cryptoEPPwdHash::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CryptoH323Token_cryptoEPPwdHash::Class()), PInvalidCast);
#endif
  return new H225_CryptoH323Token_cryptoEPPwdHash(*this);
}


//
// CryptoH323Token_cryptoGKPwdHash
//

H225_CryptoH323Token_cryptoGKPwdHash::H225_CryptoH323Token_cryptoGKPwdHash(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 0, FALSE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CryptoH323Token_cryptoGKPwdHash::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  strm << setw(indent+15) << "gatekeeperId = " << setprecision(indent) << m_gatekeeperId << '\n';
  strm << setw(indent+12) << "timeStamp = " << setprecision(indent) << m_timeStamp << '\n';
  strm << setw(indent+8) << "token = " << setprecision(indent) << m_token << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CryptoH323Token_cryptoGKPwdHash::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CryptoH323Token_cryptoGKPwdHash), PInvalidCast);
#endif
  const H225_CryptoH323Token_cryptoGKPwdHash & other = (const H225_CryptoH323Token_cryptoGKPwdHash &)obj;

  Comparison result;

  if ((result = m_gatekeeperId.Compare(other.m_gatekeeperId)) != EqualTo)
    return result;
  if ((result = m_timeStamp.Compare(other.m_timeStamp)) != EqualTo)
    return result;
  if ((result = m_token.Compare(other.m_token)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CryptoH323Token_cryptoGKPwdHash::GetDataLength() const
{
  PINDEX length = 0;
  length += m_gatekeeperId.GetObjectLength();
  length += m_timeStamp.GetObjectLength();
  length += m_token.GetObjectLength();
  return length;
}


PBoolean H225_CryptoH323Token_cryptoGKPwdHash::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (!m_gatekeeperId.Decode(strm))
    return FALSE;
  if (!m_timeStamp.Decode(strm))
    return FALSE;
  if (!m_token.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CryptoH323Token_cryptoGKPwdHash::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  m_gatekeeperId.Encode(strm);
  m_timeStamp.Encode(strm);
  m_token.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CryptoH323Token_cryptoGKPwdHash::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CryptoH323Token_cryptoGKPwdHash::Class()), PInvalidCast);
#endif
  return new H225_CryptoH323Token_cryptoGKPwdHash(*this);
}


//
// CapacityReportingSpecification_when
//

H225_CapacityReportingSpecification_when::H225_CapacityReportingSpecification_when(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_CapacityReportingSpecification_when::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_callStart))
    strm << setw(indent+12) << "callStart = " << setprecision(indent) << m_callStart << '\n';
  if (HasOptionalField(e_callEnd))
    strm << setw(indent+10) << "callEnd = " << setprecision(indent) << m_callEnd << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_CapacityReportingSpecification_when::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_CapacityReportingSpecification_when), PInvalidCast);
#endif
  const H225_CapacityReportingSpecification_when & other = (const H225_CapacityReportingSpecification_when &)obj;

  Comparison result;

  if ((result = m_callStart.Compare(other.m_callStart)) != EqualTo)
    return result;
  if ((result = m_callEnd.Compare(other.m_callEnd)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_CapacityReportingSpecification_when::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_callStart))
    length += m_callStart.GetObjectLength();
  if (HasOptionalField(e_callEnd))
    length += m_callEnd.GetObjectLength();
  return length;
}


PBoolean H225_CapacityReportingSpecification_when::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_callStart) && !m_callStart.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_callEnd) && !m_callEnd.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_CapacityReportingSpecification_when::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_callStart))
    m_callStart.Encode(strm);
  if (HasOptionalField(e_callEnd))
    m_callEnd.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_CapacityReportingSpecification_when::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CapacityReportingSpecification_when::Class()), PInvalidCast);
#endif
  return new H225_CapacityReportingSpecification_when(*this);
}


//
// ArrayOf_CallsAvailable
//

H225_ArrayOf_CallsAvailable::H225_ArrayOf_CallsAvailable(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_ArrayOf_CallsAvailable::CreateObject() const
{
  return new H225_CallsAvailable;
}


H225_CallsAvailable & H225_ArrayOf_CallsAvailable::operator[](PINDEX i) const
{
  return (H225_CallsAvailable &)array[i];
}


PObject * H225_ArrayOf_CallsAvailable::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ArrayOf_CallsAvailable::Class()), PInvalidCast);
#endif
  return new H225_ArrayOf_CallsAvailable(*this);
}


//
// CicInfo_cic
//

H225_CicInfo_cic::H225_CicInfo_cic(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_CicInfo_cic::CreateObject() const
{
  PASN_OctetString * obj = new PASN_OctetString;
  obj->SetConstraints(PASN_Object::FixedConstraint, 2, 4);
  return obj;
}


PASN_OctetString & H225_CicInfo_cic::operator[](PINDEX i) const
{
  return (PASN_OctetString &)array[i];
}


PObject * H225_CicInfo_cic::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CicInfo_cic::Class()), PInvalidCast);
#endif
  return new H225_CicInfo_cic(*this);
}


//
// GroupID_member
//

H225_GroupID_member::H225_GroupID_member(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Array(tag, tagClass)
{
}


PASN_Object * H225_GroupID_member::CreateObject() const
{
  PASN_Integer * obj = new PASN_Integer;
  obj->SetConstraints(PASN_Object::FixedConstraint, 0, 65535);
  return obj;
}


PASN_Integer & H225_GroupID_member::operator[](PINDEX i) const
{
  return (PASN_Integer &)array[i];
}


PObject * H225_GroupID_member::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_GroupID_member::Class()), PInvalidCast);
#endif
  return new H225_GroupID_member(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_ServiceControlSession_reason[]={
      {"open",0}
     ,{"refresh",1}
     ,{"close",2}
};
#endif
//
// ServiceControlSession_reason
//

H225_ServiceControlSession_reason::H225_ServiceControlSession_reason(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 3, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_ServiceControlSession_reason,3
#endif
)
{
}


PBoolean H225_ServiceControlSession_reason::CreateObject()
{
  choice = (tag <= e_close) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_ServiceControlSession_reason::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_ServiceControlSession_reason::Class()), PInvalidCast);
#endif
  return new H225_ServiceControlSession_reason(*this);
}


//
// RasUsageSpecification_when
//

H225_RasUsageSpecification_when::H225_RasUsageSpecification_when(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 3, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_RasUsageSpecification_when::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_start))
    strm << setw(indent+8) << "start = " << setprecision(indent) << m_start << '\n';
  if (HasOptionalField(e_end))
    strm << setw(indent+6) << "end = " << setprecision(indent) << m_end << '\n';
  if (HasOptionalField(e_inIrr))
    strm << setw(indent+8) << "inIrr = " << setprecision(indent) << m_inIrr << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_RasUsageSpecification_when::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_RasUsageSpecification_when), PInvalidCast);
#endif
  const H225_RasUsageSpecification_when & other = (const H225_RasUsageSpecification_when &)obj;

  Comparison result;

  if ((result = m_start.Compare(other.m_start)) != EqualTo)
    return result;
  if ((result = m_end.Compare(other.m_end)) != EqualTo)
    return result;
  if ((result = m_inIrr.Compare(other.m_inIrr)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_RasUsageSpecification_when::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_start))
    length += m_start.GetObjectLength();
  if (HasOptionalField(e_end))
    length += m_end.GetObjectLength();
  if (HasOptionalField(e_inIrr))
    length += m_inIrr.GetObjectLength();
  return length;
}


PBoolean H225_RasUsageSpecification_when::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_start) && !m_start.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_end) && !m_end.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_inIrr) && !m_inIrr.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_RasUsageSpecification_when::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_start))
    m_start.Encode(strm);
  if (HasOptionalField(e_end))
    m_end.Encode(strm);
  if (HasOptionalField(e_inIrr))
    m_inIrr.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_RasUsageSpecification_when::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_RasUsageSpecification_when::Class()), PInvalidCast);
#endif
  return new H225_RasUsageSpecification_when(*this);
}


//
// RasUsageSpecification_callStartingPoint
//

H225_RasUsageSpecification_callStartingPoint::H225_RasUsageSpecification_callStartingPoint(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Sequence(tag, tagClass, 2, TRUE, 0)
{
}


#ifndef PASN_NOPRINTON
void H225_RasUsageSpecification_callStartingPoint::PrintOn(ostream & strm) const
{
  int indent = strm.precision() + 2;
  strm << "{\n";
  if (HasOptionalField(e_alerting))
    strm << setw(indent+11) << "alerting = " << setprecision(indent) << m_alerting << '\n';
  if (HasOptionalField(e_connect))
    strm << setw(indent+10) << "connect = " << setprecision(indent) << m_connect << '\n';
  strm << setw(indent-1) << setprecision(indent-2) << "}";
}
#endif


PObject::Comparison H225_RasUsageSpecification_callStartingPoint::Compare(const PObject & obj) const
{
#ifndef PASN_LEANANDMEAN
  PAssert(PIsDescendant(&obj, H225_RasUsageSpecification_callStartingPoint), PInvalidCast);
#endif
  const H225_RasUsageSpecification_callStartingPoint & other = (const H225_RasUsageSpecification_callStartingPoint &)obj;

  Comparison result;

  if ((result = m_alerting.Compare(other.m_alerting)) != EqualTo)
    return result;
  if ((result = m_connect.Compare(other.m_connect)) != EqualTo)
    return result;

  return PASN_Sequence::Compare(other);
}


PINDEX H225_RasUsageSpecification_callStartingPoint::GetDataLength() const
{
  PINDEX length = 0;
  if (HasOptionalField(e_alerting))
    length += m_alerting.GetObjectLength();
  if (HasOptionalField(e_connect))
    length += m_connect.GetObjectLength();
  return length;
}


PBoolean H225_RasUsageSpecification_callStartingPoint::Decode(PASN_Stream & strm)
{
  if (!PreambleDecode(strm))
    return FALSE;

  if (HasOptionalField(e_alerting) && !m_alerting.Decode(strm))
    return FALSE;
  if (HasOptionalField(e_connect) && !m_connect.Decode(strm))
    return FALSE;

  return UnknownExtensionsDecode(strm);
}


void H225_RasUsageSpecification_callStartingPoint::Encode(PASN_Stream & strm) const
{
  PreambleEncode(strm);

  if (HasOptionalField(e_alerting))
    m_alerting.Encode(strm);
  if (HasOptionalField(e_connect))
    m_connect.Encode(strm);

  UnknownExtensionsEncode(strm);
}


PObject * H225_RasUsageSpecification_callStartingPoint::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_RasUsageSpecification_callStartingPoint::Class()), PInvalidCast);
#endif
  return new H225_RasUsageSpecification_callStartingPoint(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_CallCreditServiceControl_billingMode[]={
      {"credit",0}
     ,{"debit",1}
};
#endif
//
// CallCreditServiceControl_billingMode
//

H225_CallCreditServiceControl_billingMode::H225_CallCreditServiceControl_billingMode(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_CallCreditServiceControl_billingMode,2
#endif
)
{
}


PBoolean H225_CallCreditServiceControl_billingMode::CreateObject()
{
  choice = (tag <= e_debit) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_CallCreditServiceControl_billingMode::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallCreditServiceControl_billingMode::Class()), PInvalidCast);
#endif
  return new H225_CallCreditServiceControl_billingMode(*this);
}



#ifndef PASN_NOPRINTON
const static PASN_Names Names_H225_CallCreditServiceControl_callStartingPoint[]={
      {"alerting",0}
     ,{"connect",1}
};
#endif
//
// CallCreditServiceControl_callStartingPoint
//

H225_CallCreditServiceControl_callStartingPoint::H225_CallCreditServiceControl_callStartingPoint(unsigned tag, PASN_Object::TagClass tagClass)
  : PASN_Choice(tag, tagClass, 2, TRUE
#ifndef PASN_NOPRINTON
    ,(const PASN_Names *)Names_H225_CallCreditServiceControl_callStartingPoint,2
#endif
)
{
}


PBoolean H225_CallCreditServiceControl_callStartingPoint::CreateObject()
{
  choice = (tag <= e_connect) ? new PASN_Null() : NULL;
  return choice != NULL;
}


PObject * H225_CallCreditServiceControl_callStartingPoint::Clone() const
{
#ifndef PASN_LEANANDMEAN
  PAssert(IsClass(H225_CallCreditServiceControl_callStartingPoint::Class()), PInvalidCast);
#endif
  return new H225_CallCreditServiceControl_callStartingPoint(*this);
}


#endif // if ! H323_DISABLE_H225


// End of h225_1.cxx
