/* hacktv - Analogue video transmitter for the HackRF                    */
/*=======================================================================*/
/* Copyright 2020 Philip Heron <phil@sanslogic.co.uk>                    */
/*                                                                       */
/* This program is free software: you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation, either version 3 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program.  If not, see <http://www.gnu.org/licenses/>. */

/* This is the shuffle sequence for each block in the Videocrypt S free-access mode */

const uint8_t _fa_sequence[256][12][47] = {
{
	/* Frame 0 */
	{ 23,3,19,6,22,2,18,39,35,38,34,15,25,11,14,24,10,43,28,46,42,29,1,17,37,0,16,36,33,4,20,32,5,21,9,31,45,27,8,30,44,26,41,12,40,13,7 },
	{ 20,33,30,10,38,25,12,27,0,42,7,37,22,2,29,40,17,4,19,14,34,9,11,39,24,44,21,32,31,43,6,13,26,1,3,28,41,16,36,46,23,35,8,5,18,15,45 },
	{ 20,13,43,17,8,36,1,6,14,41,3,26,18,21,34,12,42,5,24,0,45,7,30,40,22,33,27,38,19,46,11,35,28,4,25,16,44,9,37,31,23,32,15,39,2,10,29 },
	{ 17,12,38,9,22,35,40,19,14,24,37,11,21,0,42,13,26,39,44,23,2,28,41,15,25,4,46,1,30,43,32,27,6,16,45,3,29,8,34,5,18,36,31,10,20,33,7 },
	{ 25,39,45,6,18,12,24,38,44,7,19,9,21,35,41,2,30,8,20,34,40,3,31,5,17,37,14,26,4,16,46,36,15,27,1,29,43,33,10,22,0,28,42,32,11,23,13 },
	{ 12,22,46,21,41,10,9,31,39,28,36,3,0,26,34,25,45,14,13,19,43,16,40,7,4,30,38,29,33,2,1,23,20,44,11,8,18,42,17,37,6,5,27,35,24,32,15 },
	{ 43,38,33,44,11,16,26,23,9,4,34,14,40,21,19,39,0,45,10,7,17,28,22,5,35,46,41,36,3,24,18,31,1,12,42,6,32,29,27,8,37,2,15,25,20,30,13 },
	{ 3,39,41,12,34,23,25,18,32,5,43,14,0,27,20,7,9,45,2,38,29,22,24,36,11,33,4,42,31,17,26,40,13,35,6,8,19,28,15,1,37,10,46,21,30,16,44 },
	{ 32,13,10,38,0,22,28,3,9,37,34,31,21,18,24,44,43,6,33,12,27,17,15,40,5,2,46,8,30,20,11,39,1,45,42,23,29,26,16,36,35,14,41,4,19,25,7 },
	{ 36,41,23,26,12,1,40,6,27,21,0,7,10,20,25,46,35,45,30,11,5,24,34,44,33,31,18,4,9,32,14,19,29,8,39,15,2,28,17,38,43,37,22,3,13,16,42 },
	{ 20,24,22,26,21,25,23,27,46,42,12,8,14,10,45,41,43,13,9,15,11,44,40,28,16,30,18,29,17,31,19,38,34,4,0,6,2,37,33,39,35,5,1,7,3,36,32 },
	{ 37,18,13,20,38,0,14,23,40,35,29,5,11,45,30,6,24,36,46,12,21,27,3,33,43,22,9,16,34,4,10,19,44,39,25,1,15,41,26,2,28,32,42,8,17,31,7 },
},
{
	/* Frame 1 */
	{ 0,44,26,17,10,38,1,45,27,16,11,39,40,12,22,29,34,6,41,13,23,28,35,7,8,36,18,25,2,46,9,37,19,24,3,32,4,30,21,42,14,33,5,31,20,43,15 },
	{ 39,10,5,40,19,28,14,11,36,41,23,18,15,34,37,8,22,17,46,35,12,9,21,16,2,13,32,27,20,6,3,44,33,31,26,7,42,45,0,30,25,38,43,4,1,29,24 },
	{ 24,31,17,6,43,33,13,38,26,20,19,8,35,15,5,40,22,25,10,0,45,7,42,32,28,27,21,2,37,9,34,30,16,23,12,39,11,1,44,18,29,14,4,41,3,46,36 },
	{ 32,45,16,31,4,27,1,46,42,39,35,28,23,25,19,13,40,36,33,14,20,10,17,30,5,43,6,8,2,29,22,44,41,37,26,0,15,21,11,38,34,24,18,12,7,9,3 },
	{ 40,38,34,41,39,35,44,45,14,6,10,2,15,7,11,3,31,23,27,19,30,22,26,18,46,32,42,33,43,36,37,8,0,28,20,9,1,29,21,25,17,12,4,24,16,13,5 },
	{ 30,35,29,15,2,45,1,46,18,10,9,26,39,40,5,6,34,13,33,14,44,0,19,16,8,37,27,38,24,4,43,23,20,12,32,31,28,3,17,36,11,25,42,22,41,21,7 },
	{ 34,25,39,29,0,4,43,16,32,10,36,15,26,23,41,3,45,8,12,35,24,46,20,1,5,31,33,11,37,6,19,22,38,28,9,13,42,17,21,14,27,30,40,2,44,7,18 },
	{ 37,25,32,28,16,4,1,26,14,39,11,23,46,2,43,24,12,9,5,44,0,41,21,31,38,10,35,22,19,42,7,13,36,8,33,29,45,17,40,20,30,27,34,15,18,6,3 },
	{ 12,34,8,39,5,17,46,21,37,30,10,15,19,6,41,13,25,38,29,16,20,43,1,27,14,33,18,44,23,40,3,24,28,35,9,4,42,0,26,36,31,32,11,45,22,2,7 },
	{ 46,19,24,41,5,35,14,2,44,9,21,23,32,12,16,39,26,43,6,28,1,11,37,25,40,4,34,30,18,8,20,15,3,45,17,38,27,42,22,33,13,0,10,36,7,29,31 },
	{ 15,39,28,14,38,12,36,31,13,37,30,21,43,7,41,20,42,6,40,4,23,5,22,11,35,9,33,10,34,8,32,27,25,26,24,3,1,2,0,46,19,44,17,18,45,16,29 },
	{ 26,39,10,34,37,41,22,32,27,6,11,20,35,29,4,13,23,33,7,18,46,21,2,28,5,16,12,25,0,9,19,3,42,17,44,24,1,30,8,14,38,43,45,36,31,40,15 },
},
{
	/* Frame 2 */
	{ 45,39,8,21,2,31,24,36,46,33,43,22,17,13,27,7,40,34,4,18,14,9,20,3,37,0,29,10,23,16,44,38,41,35,30,25,5,19,15,32,42,12,26,6,1,28,11 },
	{ 40,36,46,34,41,37,35,12,4,10,2,29,21,27,19,13,5,11,3,28,20,26,18,44,32,42,38,45,33,43,39,8,0,14,6,25,17,31,23,9,1,15,7,24,16,30,22 },
	{ 44,33,0,15,5,10,16,46,35,12,7,25,2,28,32,41,37,14,4,27,17,30,20,39,34,43,6,9,19,29,22,40,36,45,26,1,31,21,11,38,42,8,18,13,23,24,3 },
	{ 41,35,45,6,31,19,11,22,46,33,37,28,17,9,21,13,38,14,2,27,7,30,18,42,0,25,4,29,16,40,34,44,39,10,23,15,3,26,32,36,43,8,20,12,1,24,5 },
	{ 28,33,25,36,13,0,41,21,44,16,14,34,11,30,42,7,19,32,9,12,40,20,17,5,10,39,31,26,6,3,22,8,29,24,37,1,4,45,38,15,35,27,46,2,43,23,18 },
	{ 36,24,39,11,17,18,0,12,15,32,28,22,41,21,42,25,26,8,19,45,1,46,2,30,33,29,34,23,5,43,6,27,37,9,38,10,44,16,3,31,13,35,14,4,7,40,20 },
	{ 33,28,30,21,42,6,4,9,38,26,36,25,2,45,16,29,34,14,12,43,7,40,5,23,39,10,37,24,3,0,19,35,15,32,13,31,41,20,22,11,8,27,1,46,18,44,17 },
	{ 36,15,2,8,4,43,31,33,18,24,38,29,1,10,45,6,12,35,17,26,22,40,3,9,20,37,14,19,25,39,5,42,30,32,11,44,7,28,0,27,23,41,13,34,16,46,21 },
	{ 19,0,39,26,44,25,46,11,22,20,35,7,12,42,14,41,18,36,17,38,3,45,24,10,9,4,34,6,33,13,31,40,29,37,16,2,1,27,8,5,23,32,21,30,28,43,15 },
	{ 7,39,14,46,6,38,31,23,30,22,11,33,3,10,32,2,27,19,40,26,18,41,5,37,29,4,36,28,21,12,44,20,13,45,1,43,25,35,0,42,24,34,17,8,16,9,15 },
	{ 17,15,23,8,16,14,22,41,40,46,1,29,7,27,0,28,6,26,33,39,32,38,13,21,11,19,12,20,10,18,45,43,44,42,5,25,3,31,4,24,2,30,37,35,36,34,9 },
	{ 45,36,44,4,16,12,24,5,17,13,25,33,31,41,32,30,40,0,8,22,1,9,23,15,27,39,14,26,38,6,18,46,7,19,11,35,10,34,43,20,2,28,42,21,3,29,37 },
},
{
	/* Frame 3 */
	{ 3,14,22,27,37,40,38,15,16,26,4,41,39,42,17,28,5,8,6,43,29,19,32,9,7,10,18,31,33,44,34,11,20,30,0,45,35,46,21,24,1,12,2,25,23,36,13 },
	{ 0,45,11,7,25,4,33,28,18,15,42,37,26,34,46,17,23,9,20,38,2,31,13,40,10,6,24,1,44,14,43,5,32,29,19,16,22,8,36,27,35,30,12,41,21,39,3 },
	{ 29,27,0,41,6,32,24,30,21,19,42,37,13,35,11,16,22,8,38,14,1,40,7,25,31,4,45,2,43,36,28,26,17,23,46,33,9,39,15,20,18,12,34,10,5,44,3 },
	{ 14,38,26,31,10,34,15,39,27,30,11,35,46,6,18,23,42,2,7,19,22,43,3,24,28,8,32,12,36,25,29,9,33,13,37,16,20,40,0,44,4,17,21,41,1,45,5 },
	{ 29,46,25,28,24,43,13,9,42,12,8,21,17,20,16,37,5,33,1,36,4,32,0,27,14,26,15,45,11,41,31,44,10,40,30,19,38,6,18,39,7,35,3,23,34,2,22 },
	{ 11,30,36,27,1,20,42,17,9,35,28,25,45,7,40,2,33,15,10,5,0,46,21,13,39,8,34,29,23,18,44,6,31,37,26,32,14,43,16,4,24,12,38,41,3,22,19 },
	{ 30,3,9,40,4,45,31,2,43,8,33,13,44,16,11,42,7,32,12,37,17,10,35,6,18,36,24,21,34,15,46,19,25,20,14,39,26,22,29,1,38,27,23,28,0,41,5 },
	{ 17,32,2,35,24,27,42,9,5,36,6,39,21,45,31,46,28,16,19,34,1,26,8,41,11,37,23,38,20,30,12,15,18,0,33,3,25,40,10,43,22,4,7,13,44,14,29 },
	{ 24,30,36,29,0,33,23,45,5,9,31,28,39,16,32,3,44,4,8,41,11,13,38,17,2,35,20,46,7,40,10,43,12,15,18,34,21,6,26,42,25,14,37,19,1,22,27 },
	{ 26,33,20,46,31,36,17,10,0,15,5,35,22,45,28,38,19,40,25,2,12,7,9,30,37,16,42,27,32,21,14,4,11,1,39,18,41,24,34,23,44,29,6,8,3,13,43 },
	{ 8,33,18,44,1,39,12,37,7,5,24,32,19,0,28,36,30,4,43,25,11,16,29,31,20,42,22,10,35,17,46,3,14,21,23,41,26,34,9,2,45,15,38,13,6,40,27 },
	{ 13,30,42,19,39,21,33,44,10,28,7,1,22,34,26,46,8,17,37,2,14,24,41,5,18,38,20,32,12,31,43,29,6,0,45,11,9,16,36,23,35,27,25,40,4,3,15 },
},
{
	/* Frame 4 */
	{ 23,42,8,38,0,15,41,7,37,25,10,17,44,2,30,32,28,22,43,20,9,39,27,1,19,46,12,34,4,11,45,3,33,29,14,21,40,6,26,36,24,18,16,13,35,31,5 },
	{ 28,18,22,29,19,23,24,25,10,2,14,6,11,3,15,7,43,35,39,42,34,46,38,26,20,30,27,21,31,16,17,12,4,40,32,13,5,41,33,45,37,8,0,44,36,9,1 },
	{ 34,45,22,31,19,10,7,37,28,1,25,4,13,41,44,39,30,18,27,6,15,3,33,46,36,43,0,9,21,12,16,40,38,35,26,23,14,2,11,32,42,8,20,29,17,24,5 },
	{ 14,32,10,31,27,36,15,33,11,30,26,37,46,0,42,20,17,4,1,43,21,16,5,8,38,28,34,25,12,9,39,29,35,24,13,40,6,2,23,44,19,41,7,3,22,45,18 },
	{ 38,26,35,31,19,7,2,25,13,36,8,20,45,1,40,27,15,10,6,3,42,22,28,37,9,32,21,16,41,4,14,39,11,34,30,46,18,43,23,29,24,33,12,17,5,44,0 },
	{ 10,36,31,33,18,6,3,24,38,12,35,9,20,17,26,14,11,45,22,40,19,7,28,25,39,5,42,0,21,37,30,32,27,15,2,44,23,41,13,34,8,29,16,46,4,43,1 },
	{ 32,27,42,16,39,13,6,10,1,29,37,31,46,4,34,24,41,18,14,20,44,9,3,17,38,12,22,33,26,43,0,28,36,7,11,25,40,19,30,5,35,8,2,15,21,45,23 },
	{ 7,28,37,0,27,23,33,13,42,16,38,3,44,9,20,14,19,25,5,34,30,40,29,36,1,10,6,12,43,17,39,26,22,32,21,15,2,45,8,4,35,31,41,18,24,46,11 },
	{ 6,35,26,36,3,40,4,33,8,1,22,34,27,2,20,32,29,0,23,15,18,21,28,16,46,25,14,43,19,45,11,13,17,24,39,30,42,7,44,10,37,12,41,5,9,38,31 },
	{ 23,5,21,6,22,4,20,39,37,38,36,3,27,1,25,2,26,0,24,35,33,34,32,15,31,13,29,14,30,12,28,45,46,44,11,19,9,17,10,18,8,16,43,41,42,40,7 },
	{ 22,8,17,6,1,43,37,34,23,40,16,7,26,0,29,10,13,35,41,46,27,32,28,11,18,12,21,2,5,33,38,19,44,20,3,30,4,25,14,9,39,45,42,31,36,24,15 },
	{ 38,16,5,19,35,0,22,3,27,14,12,11,40,42,29,39,4,18,7,32,2,21,15,44,46,25,41,30,43,28,9,36,6,17,33,34,20,1,23,45,26,24,13,31,10,8,37 },
},
{
	/* Frame 5 */
	{ 8,32,9,33,41,22,0,30,40,23,1,31,38,46,39,18,6,26,14,19,7,27,15,34,28,42,35,29,43,2,10,20,3,11,21,24,12,36,25,13,37,45,16,4,44,17,5 },
	{ 37,0,23,25,15,42,12,1,21,24,46,43,13,40,18,20,10,44,41,30,19,6,11,45,8,31,17,7,34,4,9,29,16,38,35,5,32,26,28,39,2,36,33,22,27,14,3 },
	{ 10,18,12,20,43,45,11,19,13,21,42,44,26,2,28,4,35,37,27,3,29,5,34,36,14,22,8,16,41,15,23,9,17,46,40,30,6,24,0,39,33,31,7,25,1,38,32 },
	{ 46,27,43,15,2,37,23,33,18,8,28,44,24,38,5,35,1,10,31,26,6,3,36,22,40,13,9,21,17,39,4,42,14,11,30,32,19,7,29,45,25,41,12,34,0,20,16 },
	{ 43,41,39,37,42,40,38,36,29,21,15,7,13,5,30,22,28,20,14,6,12,4,31,23,35,33,45,34,46,32,44,11,3,9,1,26,18,24,16,10,2,8,0,27,19,25,17 },
	{ 31,45,6,8,42,1,37,28,22,46,34,27,41,18,13,38,21,10,33,24,3,14,4,7,9,43,17,30,44,23,35,26,0,36,29,39,20,11,40,19,12,15,5,32,25,2,16 },
	{ 17,39,3,37,8,27,24,32,20,7,5,42,31,41,29,0,19,16,46,10,44,9,26,34,23,33,21,14,12,43,30,38,2,36,1,18,25,11,45,6,4,35,22,40,28,15,13 },
	{ 41,0,43,22,38,5,24,35,31,29,40,16,42,23,4,37,9,34,11,28,17,3,20,36,8,10,33,13,15,2,21,7,26,32,12,45,14,18,1,6,39,27,25,44,30,46,19 },
	{ 41,20,10,23,32,35,30,1,46,12,17,15,37,24,6,27,40,43,22,9,34,0,29,3,45,16,14,19,36,39,26,5,42,8,21,11,33,28,2,31,44,18,13,38,4,25,7 },
	{ 20,43,22,40,29,14,33,12,17,46,3,44,0,39,26,37,9,21,6,41,4,15,13,34,31,18,45,1,27,24,10,7,5,42,23,28,35,30,32,19,16,2,25,38,11,36,8 },
	{ 33,8,36,13,1,4,16,35,10,38,31,3,6,18,9,12,24,20,40,17,45,11,39,14,26,7,42,19,22,28,32,25,37,21,41,0,44,5,15,34,27,30,43,2,46,23,29 },
	{ 20,41,28,35,43,0,21,8,29,2,7,10,15,1,36,9,16,44,3,24,6,11,18,14,23,26,37,31,17,45,25,38,19,46,22,27,4,30,32,12,40,39,34,42,5,33,13 },
},
{
	/* Frame 6 */
	{ 22,26,31,34,13,43,4,3,28,17,46,9,6,0,15,30,19,12,42,37,2,44,11,25,16,21,8,39,33,14,40,18,23,27,36,35,45,10,5,24,29,20,38,32,41,7,1 },
	{ 42,34,44,36,43,35,45,37,14,2,24,20,31,19,8,4,15,3,25,21,30,18,9,5,46,38,40,32,39,41,33,10,6,28,16,27,23,12,0,11,7,29,17,26,22,13,1 },
	{ 14,38,26,15,39,27,31,10,34,30,11,35,46,6,18,7,19,23,42,2,22,43,3,8,32,12,36,9,33,13,37,25,29,24,28,40,0,44,4,41,1,45,5,17,21,16,20 },
	{ 46,13,24,21,37,1,4,14,41,26,44,30,38,3,7,29,43,9,12,17,33,20,36,0,11,15,40,19,35,23,39,2,25,28,42,8,5,16,32,27,45,31,10,6,18,34,22 },
	{ 15,37,28,38,31,21,45,22,46,4,11,33,24,34,27,41,18,42,0,13,14,36,7,20,44,23,9,10,32,25,3,16,40,19,29,39,30,12,5,6,35,26,8,43,1,2,17 },
	{ 37,14,21,9,18,42,30,38,4,25,33,10,0,29,44,7,26,34,16,40,12,23,20,8,3,36,15,5,24,32,19,43,31,39,28,45,6,11,1,13,22,46,27,35,17,41,2 },
	{ 33,2,37,22,11,14,27,35,1,38,5,17,28,24,3,6,19,15,40,26,44,31,39,20,16,29,42,8,12,7,32,18,36,23,41,10,45,30,21,34,0,4,43,9,46,13,25 },
	{ 40,27,9,41,26,24,10,42,25,11,43,12,31,13,30,28,38,14,36,29,39,15,37,19,17,18,16,2,34,0,32,3,35,1,33,23,44,21,22,45,20,6,4,46,7,5,8 },
	{ 33,20,6,19,40,26,9,34,4,17,3,45,24,10,31,32,39,18,1,46,8,29,15,37,16,2,23,44,43,30,13,38,0,21,7,41,28,14,27,36,35,22,5,42,12,25,11 },
	{ 12,45,16,9,31,19,26,28,44,17,42,8,35,14,7,27,33,29,5,43,24,34,15,46,6,39,10,32,3,4,37,25,1,22,38,11,2,41,20,36,13,0,23,30,18,40,21 },
	{ 19,10,40,3,24,33,34,21,12,22,5,31,6,36,11,16,41,42,25,0,26,35,13,23,14,44,7,28,37,38,17,8,18,43,1,27,2,32,15,20,45,46,29,4,30,39,9 },
	{ 42,46,10,18,14,22,11,19,15,23,5,33,4,32,26,37,30,0,27,36,31,1,13,21,41,12,20,40,45,8,16,44,9,17,29,35,39,28,34,38,2,24,6,3,25,7,43 },
},
{
	/* Frame 7 */
	{ 39,40,20,1,15,19,8,36,26,23,46,35,29,16,30,4,42,3,45,32,10,7,25,13,0,14,18,38,41,21,22,34,28,9,37,27,2,44,17,31,5,43,6,24,12,33,11 },
	{ 30,42,12,1,7,4,10,24,32,19,37,16,28,40,15,23,35,20,38,8,27,45,3,0,6,31,43,13,46,33,18,5,11,25,14,22,34,36,17,29,41,26,44,2,21,39,9 },
	{ 8,20,46,41,14,18,9,21,40,15,19,24,4,34,37,30,2,25,5,35,36,31,3,12,16,42,45,10,22,13,17,43,44,11,23,28,0,38,33,26,6,29,1,39,32,27,7 },
	{ 29,32,8,37,13,25,28,33,9,36,12,24,21,40,0,45,5,17,20,41,1,44,4,16,34,10,38,14,27,31,35,11,39,15,26,30,42,2,46,6,19,23,43,3,7,18,22 },
	{ 15,28,40,30,42,12,14,29,41,31,43,13,39,7,20,22,36,4,38,6,21,23,37,5,24,26,8,44,10,46,25,27,9,45,11,16,18,32,0,34,2,17,19,33,1,35,3 },
	{ 26,38,2,13,32,41,20,39,14,3,42,33,8,17,15,34,43,22,9,29,16,35,10,23,19,28,4,11,18,25,5,44,30,6,24,36,45,0,31,27,7,46,37,12,1,40,21 },
	{ 36,22,29,34,1,40,27,23,28,0,33,18,24,21,15,32,19,25,20,14,13,16,11,7,46,12,45,17,10,43,6,39,5,44,30,3,42,9,38,4,37,31,2,35,8,41,26 },
	{ 4,43,9,1,6,27,3,20,42,8,45,0,37,22,15,2,39,21,29,44,16,36,23,41,14,33,18,38,11,28,35,17,25,40,30,32,19,10,13,34,5,24,31,7,26,46,12 },
	{ 0,17,46,22,5,2,19,45,7,32,16,4,29,34,18,9,6,31,33,11,36,28,35,8,25,38,30,13,10,27,37,15,40,24,39,12,21,42,26,1,14,23,41,3,44,20,43 },
	{ 6,1,28,15,18,40,21,31,37,34,4,10,13,16,7,26,32,29,39,19,41,46,8,2,5,24,11,22,44,17,43,27,33,38,0,14,9,20,3,30,36,25,35,23,45,42,12 },
	{ 38,30,3,8,4,41,14,35,18,25,36,21,1,11,23,12,33,16,45,26,7,42,29,9,5,39,31,2,24,37,20,40,15,34,19,46,22,13,0,10,6,43,28,32,17,44,27 },
	{ 15,4,17,41,3,32,46,28,6,9,27,0,20,44,39,30,19,43,24,34,12,22,37,11,16,40,2,14,5,7,8,26,33,29,38,31,18,42,1,21,45,23,36,10,25,35,13 },
},
{
	/* Frame 8 */
	{ 28,33,30,18,45,25,37,8,29,0,31,19,12,14,4,6,9,42,1,34,13,16,15,5,26,7,20,43,22,35,17,27,39,21,10,23,40,2,32,46,44,38,24,36,11,41,3 },
	{ 28,20,24,16,29,21,25,17,10,36,46,32,11,37,33,43,4,14,0,42,5,15,1,26,18,27,19,30,22,31,23,44,2,40,38,45,3,41,39,12,35,8,6,13,34,9,7 },
	{ 30,32,26,31,33,27,14,10,36,15,11,37,0,20,1,21,46,17,42,4,16,43,5,8,28,9,29,25,38,12,34,24,39,13,35,40,22,18,41,23,19,6,44,2,7,45,3 },
	{ 27,14,37,11,33,31,26,15,36,10,32,30,19,6,45,3,41,23,18,7,44,2,40,22,29,38,25,35,13,9,28,39,24,34,12,8,21,46,17,43,5,1,20,16,42,4,0 },
	{ 30,38,29,37,7,4,23,26,34,25,33,11,0,19,43,15,12,31,20,44,6,5,8,27,35,16,40,2,1,39,28,36,14,13,22,46,21,45,24,32,10,9,18,42,17,41,3 },
	{ 32,29,17,27,6,28,16,26,15,46,3,25,4,14,39,2,43,24,5,44,1,38,11,42,23,12,45,0,41,10,35,22,13,36,9,40,21,34,31,19,37,8,33,20,30,18,7 },
	{ 32,4,24,39,18,43,14,20,36,9,3,23,46,27,16,41,13,35,6,10,1,29,45,25,38,19,42,30,33,5,8,2,15,21,37,17,40,12,34,22,26,0,28,44,7,11,31 },
	{ 31,22,30,6,34,14,42,7,35,15,43,19,44,27,18,45,26,2,10,36,3,11,37,12,40,21,13,41,20,28,4,32,29,5,33,8,17,9,16,24,38,0,46,25,39,1,23 },
	{ 4,17,34,30,1,14,27,41,11,36,16,35,0,29,46,26,13,10,23,37,7,32,28,12,25,42,22,9,6,19,33,3,44,24,43,8,21,38,18,5,2,31,45,15,40,20,39 },
	{ 40,16,42,23,4,21,3,26,1,14,41,43,36,20,38,27,0,25,15,30,13,10,37,39,32,24,34,31,12,29,11,18,9,6,33,35,44,28,46,19,8,17,7,22,5,2,45 },
	{ 13,30,38,8,27,35,25,44,6,28,41,3,1,22,46,4,19,43,17,32,14,20,37,11,9,26,34,12,31,39,29,40,2,24,45,7,5,18,42,0,23,21,36,10,16,33,15 },
	{ 40,18,11,17,34,26,0,25,21,12,14,29,39,37,7,41,10,16,9,35,32,24,3,13,46,44,23,4,6,31,42,8,19,33,2,27,1,20,45,22,15,5,28,38,30,36,43 },
},
{
	/* Frame 9 */
	{ 2,38,8,44,19,25,3,39,9,45,18,24,42,6,32,12,23,29,43,7,33,13,22,28,10,46,0,36,27,17,11,1,37,26,16,34,14,40,4,31,21,35,15,41,5,30,20 },
	{ 13,19,14,33,34,22,25,4,40,28,3,31,37,38,9,21,10,44,18,15,0,35,24,5,27,6,41,42,30,17,12,39,32,20,11,23,45,46,1,29,2,36,26,7,8,43,16 },
	{ 13,42,26,37,17,3,4,31,40,24,14,1,38,18,45,29,11,12,35,23,36,16,2,9,46,30,33,21,7,0,43,27,44,28,10,5,34,22,41,25,15,8,39,19,32,20,6 },
	{ 43,33,40,19,28,16,30,2,39,46,37,44,25,20,11,22,8,41,34,29,17,14,3,12,0,45,21,26,6,9,4,35,42,32,15,18,13,1,31,38,36,27,7,24,5,10,23 },
	{ 41,45,20,31,16,42,35,6,29,19,40,33,44,37,15,17,26,34,28,3,24,32,36,14,1,27,5,2,25,22,0,11,4,46,39,9,23,13,10,21,30,38,43,8,7,12,18 },
	{ 32,43,46,10,5,31,17,26,34,40,22,13,19,25,7,42,37,4,30,1,27,20,15,45,39,12,3,9,6,28,36,33,0,11,21,14,16,44,35,41,38,2,8,23,29,18,24 },
	{ 1,22,21,42,25,40,14,12,34,16,33,6,45,5,9,27,36,29,0,19,20,24,41,11,13,39,31,32,3,4,23,26,43,28,15,18,35,17,46,7,44,10,8,38,30,37,2 },
	{ 43,18,8,17,34,33,24,3,44,14,23,13,39,30,4,29,42,41,16,11,32,2,27,1,22,12,21,38,37,28,7,40,10,19,9,35,26,0,25,46,45,20,15,36,6,31,5 },
	{ 32,27,44,6,28,43,0,10,22,13,25,21,36,14,41,18,35,8,39,4,30,3,7,29,42,16,33,26,45,23,12,1,46,11,15,40,19,34,24,20,37,31,2,9,38,5,17 },
	{ 5,9,12,6,11,32,30,20,17,34,13,7,19,33,14,36,21,40,16,35,28,25,42,18,15,37,27,41,0,44,29,38,24,43,2,23,26,1,45,4,39,8,3,46,22,10,31 },
	{ 13,41,30,12,40,14,42,29,15,43,28,1,45,3,0,44,2,46,17,19,16,18,5,33,7,35,4,32,6,34,21,23,20,22,37,27,39,9,36,26,38,8,10,25,11,24,31 },
	{ 15,32,29,43,18,13,2,41,16,46,27,0,11,44,25,39,30,9,14,37,28,42,23,12,7,40,21,35,26,5,10,33,24,38,19,8,3,36,17,22,1,6,45,20,34,31,4 },
},
{
	/* Frame 10 */
	{ 36,41,2,23,25,13,18,38,32,43,4,27,15,1,20,34,37,6,8,29,3,22,24,44,39,33,10,31,17,5,26,46,40,35,12,19,7,9,28,42,45,14,0,21,11,30,16 },
	{ 14,9,39,30,0,23,16,12,34,27,37,28,42,21,45,3,32,25,15,40,6,1,22,10,13,35,26,4,19,43,20,8,38,31,33,24,46,17,41,7,36,29,11,44,2,5,18 },
	{ 26,43,15,46,19,22,2,8,41,13,44,24,20,35,17,38,27,30,10,23,33,3,36,6,40,28,45,25,21,1,39,4,31,11,42,14,32,18,37,7,29,9,12,0,5,34,16 },
	{ 41,21,28,6,30,4,33,46,44,9,2,26,16,25,42,38,36,29,7,14,5,12,23,34,45,3,10,0,24,19,43,39,40,37,15,20,13,22,31,35,32,11,1,8,18,27,17 },
	{ 29,41,19,10,46,21,39,24,2,44,32,31,37,43,16,9,23,14,26,1,34,12,6,18,11,4,28,40,3,45,33,30,20,38,25,22,15,36,42,17,8,35,13,7,27,0,5 },
	{ 16,39,21,34,25,13,43,8,19,37,7,32,2,44,30,41,11,17,5,35,0,12,9,46,28,36,22,33,3,31,26,14,4,1,38,20,24,29,42,23,18,6,27,45,15,40,10 },
	{ 32,8,41,4,13,35,27,7,30,33,24,40,5,46,12,10,18,31,25,16,28,11,42,19,14,22,17,29,38,20,43,2,15,36,23,45,0,9,39,21,3,34,26,37,6,44,1 },
	{ 15,4,10,33,29,19,36,24,42,22,9,3,12,6,41,21,35,31,44,16,38,26,5,11,0,14,37,25,43,23,32,28,46,18,13,7,8,2,45,17,39,27,40,20,34,30,1 },
	{ 32,21,42,14,18,45,8,4,30,3,17,27,34,6,41,28,37,0,39,10,22,13,15,19,44,24,33,20,43,31,2,9,46,5,7,40,29,36,16,26,35,23,12,1,38,11,25 },
	{ 28,30,45,25,42,27,40,9,37,4,38,23,1,35,2,16,29,46,31,44,13,43,10,8,5,39,6,20,3,32,17,18,14,12,11,24,26,41,7,36,21,22,33,0,34,19,15 },
	{ 19,13,25,6,18,12,24,39,45,38,44,23,11,29,1,22,10,28,0,43,33,42,32,15,27,5,17,14,26,4,16,37,46,36,31,3,21,9,30,2,20,8,35,41,34,40,7 },
	{ 26,36,46,5,17,15,27,37,4,16,10,22,32,42,1,29,11,23,33,43,0,28,6,18,44,38,13,25,7,19,45,39,12,24,2,30,40,34,9,21,3,31,41,35,8,20,14 },
},
{
	/* Frame 11 */
	{ 1,8,35,42,20,29,36,9,2,43,28,23,37,44,3,10,22,31,4,45,38,11,17,30,5,12,39,46,16,25,32,13,6,24,19,33,40,7,14,18,27,0,41,34,15,21,26 },
	{ 6,11,4,29,26,46,35,12,7,43,5,27,30,2,13,0,42,37,8,31,3,45,1,14,18,16,36,9,38,24,44,33,15,19,22,17,20,41,39,10,25,28,32,34,23,21,40 },
	{ 24,11,13,35,19,37,21,2,8,46,26,40,16,7,1,43,31,45,25,10,4,34,18,36,28,15,9,39,23,33,17,6,12,42,30,44,20,3,5,27,41,29,14,0,38,22,32 },
	{ 27,25,26,24,11,35,9,33,10,34,8,32,19,17,18,16,43,3,41,1,42,2,40,0,29,15,39,28,14,38,13,37,30,12,36,31,21,7,20,46,6,45,5,22,44,4,23 },
	{ 11,6,37,2,24,44,21,39,1,26,30,3,32,25,45,12,38,16,34,27,31,18,33,22,13,40,17,35,4,46,15,42,19,23,28,41,8,5,14,43,10,7,36,29,9,20,0 },
	{ 35,32,44,31,16,28,2,14,43,40,38,5,24,22,10,21,34,46,1,13,18,30,17,29,37,42,9,7,26,4,25,33,45,3,15,0,12,19,41,39,36,23,11,20,8,6,27 },
	{ 34,10,32,9,26,25,35,11,33,8,27,28,14,46,13,45,30,29,15,12,44,31,2,0,42,18,41,16,3,1,43,19,40,17,6,38,4,36,22,20,7,39,5,37,23,21,24 },
	{ 39,22,0,17,46,41,24,15,36,2,19,5,43,26,12,29,38,33,16,7,40,14,31,9,35,18,4,21,42,45,28,11,32,6,23,1,30,8,25,34,37,20,3,44,10,27,13 },
	{ 32,2,34,1,33,3,35,16,18,17,19,4,6,44,5,7,45,20,46,22,21,23,27,8,40,26,9,41,10,42,24,11,43,25,31,36,12,38,30,37,13,39,14,28,15,29,0 },
	{ 28,36,15,45,27,2,9,22,42,29,4,39,16,44,3,33,23,10,5,30,38,17,12,24,32,11,41,31,6,13,18,46,25,0,35,20,40,7,37,19,14,1,26,34,21,8,43 },
	{ 6,35,10,39,41,14,43,45,18,22,34,26,38,24,30,42,28,19,46,1,23,5,27,25,31,29,0,4,33,8,37,12,16,3,20,32,7,9,36,11,13,40,15,17,44,2,21 },
	{ 39,33,26,15,28,9,38,32,23,14,25,8,43,37,22,3,24,13,42,36,19,2,21,12,41,18,7,20,1,46,40,31,6,17,0,35,45,30,11,16,5,34,44,27,10,29,4 },
},
{
	/* Frame 12 */
	{ 43,17,40,35,27,32,23,46,13,38,1,11,8,7,4,28,14,16,41,2,26,33,25,22,21,44,39,31,36,19,42,9,34,5,15,12,3,0,24,10,20,45,6,30,37,29,18 },
	{ 40,21,45,16,9,4,29,33,24,36,10,22,15,42,30,3,39,20,13,8,28,32,37,1,14,19,43,46,2,27,7,34,12,41,44,17,5,0,25,18,11,23,26,6,31,35,38 },
	{ 46,13,43,25,4,37,1,20,44,14,41,11,30,38,18,35,23,12,9,28,36,0,33,21,16,40,26,31,19,7,2,8,29,42,24,32,5,17,27,45,15,10,6,39,3,34,22 },
	{ 11,9,39,10,8,38,26,37,24,27,36,25,43,21,41,7,42,20,40,6,5,22,4,23,29,35,15,33,28,34,14,32,13,30,12,31,3,1,2,46,0,45,18,16,44,19,17 },
	{ 39,12,1,11,7,40,28,34,17,27,37,30,2,9,46,5,15,32,18,44,25,21,43,0,10,23,38,13,16,26,36,6,41,29,35,8,4,31,3,24,20,42,14,33,19,45,22 },
	{ 20,23,33,13,42,14,29,37,16,38,19,1,10,44,25,5,34,6,21,30,40,12,43,15,2,36,17,39,26,8,11,22,32,4,35,7,28,31,41,18,0,3,45,24,46,27,9 },
	{ 33,3,10,32,2,27,19,40,26,18,41,15,7,39,14,46,6,38,31,23,30,22,1,43,25,35,0,42,24,34,17,8,16,9,5,37,29,4,36,28,21,12,44,20,13,45,11 },
	{ 3,12,6,41,29,35,23,44,24,38,18,1,15,4,10,33,21,27,36,16,42,30,13,7,8,2,45,25,39,19,40,28,34,22,5,11,0,14,37,17,43,31,32,20,46,26,9 },
	{ 32,12,40,5,33,13,41,20,28,21,29,0,8,38,1,9,39,16,46,24,17,25,31,6,34,30,7,35,14,42,22,15,43,23,27,36,2,44,26,37,3,45,10,18,11,19,4 },
	{ 29,12,38,9,18,35,40,31,14,20,37,11,17,0,42,13,22,39,44,19,2,24,41,15,21,4,46,1,26,43,32,23,6,28,45,3,25,8,34,5,30,36,27,10,16,33,7 },
	{ 24,6,19,28,33,23,37,34,25,38,18,29,0,22,11,4,15,35,40,39,44,1,10,5,16,14,27,20,41,31,45,42,17,46,26,21,8,30,3,12,7,43,32,36,9,2,13 },
	{ 13,27,24,40,11,8,18,38,17,37,2,1,23,35,20,44,15,12,30,42,29,41,6,5,19,39,16,32,3,0,26,46,25,45,10,9,31,43,28,36,7,4,22,34,21,33,14 },
},
{
	/* Frame 13 */
	{ 8,28,0,20,9,29,1,21,41,33,40,32,18,12,4,19,13,5,45,26,37,44,27,36,2,22,42,3,23,43,35,10,30,34,11,31,24,6,16,46,25,7,17,39,14,38,15 },
	{ 31,25,12,38,40,20,2,22,45,15,9,29,43,36,19,6,0,34,24,13,26,39,41,3,23,17,4,46,32,28,10,30,37,7,1,21,35,44,27,14,8,42,16,5,18,33,11 },
	{ 41,17,9,23,15,40,46,16,8,22,14,33,39,25,1,31,7,32,38,24,0,30,6,45,43,21,13,19,11,44,42,20,12,18,10,37,35,29,5,27,3,36,34,28,4,26,2 },
	{ 43,8,26,1,38,2,36,17,28,30,13,35,6,4,9,40,10,25,39,3,16,19,14,12,45,7,32,21,23,41,11,42,24,27,0,18,37,15,46,29,44,31,33,20,34,22,5 },
	{ 34,1,28,19,44,21,24,6,43,40,13,2,31,39,36,9,22,27,35,32,29,18,14,17,45,7,10,4,41,3,30,0,37,46,26,20,25,33,42,15,16,12,38,11,5,8,23 },
	{ 33,5,25,2,31,7,45,8,17,42,23,26,37,0,29,34,39,11,18,40,12,21,24,3,14,32,4,9,16,43,30,6,44,1,28,35,46,22,27,36,41,13,20,38,10,19,15 },
	{ 41,5,9,39,17,42,7,10,19,20,33,24,1,22,35,31,36,3,44,4,12,38,16,6,15,18,27,32,29,40,0,8,34,30,43,2,45,11,13,21,46,25,14,23,26,37,28 },
	{ 2,27,44,28,7,0,25,5,34,26,45,6,23,32,24,11,4,21,35,9,38,22,33,10,19,36,20,15,8,17,39,13,42,18,37,14,31,40,16,3,12,29,43,1,46,30,41 },
	{ 16,15,36,21,10,0,19,5,42,22,41,28,3,44,25,6,8,35,31,13,38,26,37,20,11,32,17,14,4,43,23,1,46,18,45,24,7,40,29,2,12,39,27,9,34,30,33 },
	{ 19,7,18,46,6,43,3,22,42,2,23,27,15,26,14,37,11,33,30,36,10,32,31,21,17,20,16,45,5,41,1,44,4,40,0,29,39,25,28,38,24,35,13,9,34,12,8 },
	{ 35,6,42,15,39,26,46,19,33,4,40,29,37,9,44,17,24,7,14,22,27,2,11,5,41,12,20,45,0,25,30,34,23,43,3,38,10,18,13,32,21,28,1,36,8,16,31 },
	{ 13,7,16,15,24,36,18,44,21,26,38,29,33,46,23,41,4,31,35,12,43,6,1,14,9,3,20,11,28,32,22,40,17,30,34,25,37,42,19,45,0,27,39,8,2,5,10 },
},
{
	/* Frame 14 */
	{ 25,31,8,13,1,37,40,28,21,27,46,3,39,10,15,24,23,17,30,12,0,5,41,44,32,20,19,26,2,7,43,14,34,22,16,4,9,45,33,36,18,29,6,42,35,38,11 },
	{ 28,11,13,6,0,22,14,8,35,30,37,19,21,41,38,27,32,29,42,16,44,7,1,24,15,9,2,4,18,10,12,39,26,33,23,43,17,45,34,31,36,25,46,20,40,3,5 },
	{ 29,32,8,28,33,9,37,13,25,36,12,24,21,40,0,20,41,1,45,5,17,44,4,16,27,31,26,30,35,11,39,15,34,10,38,14,19,23,18,22,43,3,7,42,2,46,6 },
	{ 14,40,12,43,7,38,21,36,23,26,8,11,17,32,2,35,15,29,42,31,39,20,22,5,25,10,45,16,19,34,1,28,30,41,13,6,4,37,24,46,27,44,9,18,0,33,3 },
	{ 30,45,0,9,43,22,12,1,46,10,4,13,32,2,11,25,5,33,14,3,17,24,36,6,15,34,16,37,27,7,40,35,28,19,26,38,41,20,29,31,18,44,39,8,21,42,23 },
	{ 6,11,36,1,13,22,38,27,43,17,33,20,45,8,3,15,5,24,40,19,35,31,10,37,0,29,7,26,42,16,32,12,23,39,2,14,21,44,9,18,34,30,46,4,25,41,28 },
	{ 32,23,0,18,31,25,38,26,33,6,1,46,19,45,14,13,39,27,7,34,20,2,44,15,42,12,41,10,9,35,21,3,16,43,28,40,11,36,8,4,22,17,29,30,37,24,5 },
	{ 43,32,42,0,16,10,26,1,17,11,27,37,36,46,4,28,14,22,5,29,15,23,41,35,40,34,8,24,2,18,9,25,3,19,45,39,44,38,12,20,6,30,13,21,7,31,33 },
	{ 20,7,40,17,2,12,39,19,9,34,22,37,24,11,32,29,14,4,43,31,1,46,26,41,16,3,44,21,6,8,35,23,13,38,18,33,28,15,36,25,10,0,27,5,42,30,45 },
	{ 7,1,12,43,27,41,22,37,16,34,29,11,9,5,2,31,45,24,20,38,19,32,15,13,42,26,6,0,35,28,10,40,23,36,17,3,46,30,8,4,39,18,33,14,44,25,21 },
	{ 17,4,38,21,2,33,27,14,24,45,31,9,28,43,40,5,18,39,36,3,22,0,34,15,25,12,46,29,10,41,19,6,16,37,23,1,20,35,32,13,26,44,11,30,8,42,7 },
	{ 20,42,44,11,19,13,21,43,45,10,18,28,0,38,32,27,7,29,1,39,33,26,6,8,16,46,40,15,23,9,17,41,14,22,24,4,34,36,31,3,25,5,35,37,30,2,12 },
},
{
	/* Frame 15 */
	{ 39,14,20,32,9,27,16,36,28,23,40,3,24,4,44,31,34,11,0,18,12,7,42,33,8,26,38,15,21,22,41,2,17,46,37,29,30,35,10,25,5,45,6,43,1,19,13 },
	{ 6,1,4,18,16,15,41,44,27,7,33,5,19,28,17,8,45,42,32,37,34,29,9,12,43,46,24,36,35,38,30,13,10,25,22,20,2,39,0,31,11,14,40,23,26,21,3 },
	{ 20,8,19,15,41,46,21,9,18,14,40,39,28,0,27,7,33,38,29,1,26,6,32,43,16,12,23,11,45,42,17,13,22,10,44,35,24,4,31,3,37,34,25,5,30,2,36 },
	{ 33,9,35,11,32,8,34,10,24,26,25,27,41,1,43,3,40,0,42,2,16,18,17,19,39,15,28,38,14,29,30,36,12,31,37,13,7,20,46,6,21,22,44,4,23,45,5 },
	{ 40,25,43,18,38,1,12,7,34,21,8,11,17,37,28,46,31,4,33,24,42,27,39,0,3,14,45,20,23,10,41,16,36,19,30,13,32,6,35,26,9,2,15,44,29,22,5 },
	{ 16,10,37,23,28,21,11,2,20,14,42,3,8,15,6,43,34,9,0,27,46,7,12,35,40,1,26,19,38,13,4,41,32,18,25,39,44,5,30,33,24,17,45,36,31,22,29 },
	{ 14,32,22,41,30,7,15,33,23,40,31,2,38,10,46,18,26,3,39,11,19,27,28,34,4,42,13,20,29,35,5,43,12,21,24,0,36,9,45,16,25,1,37,8,44,17,6 },
	{ 14,19,40,28,11,4,25,35,1,46,18,41,10,31,36,24,7,0,21,13,42,30,37,6,27,32,20,3,12,17,43,9,38,26,33,2,23,44,16,15,8,29,39,5,34,22,45 },
	{ 16,43,1,17,42,32,10,26,33,11,27,4,28,5,29,46,36,14,22,37,15,23,8,24,35,9,25,34,40,2,18,41,3,19,12,20,39,13,21,38,44,6,30,45,7,31,0 },
	{ 27,3,33,26,2,32,34,25,1,35,24,0,23,11,41,22,10,40,42,21,9,43,20,8,31,7,37,30,6,36,38,29,5,39,28,4,19,15,45,18,14,44,46,17,13,16,12 },
	{ 40,28,16,37,6,27,46,3,12,33,25,23,42,18,39,5,9,14,35,11,20,45,0,31,7,26,41,29,17,36,24,22,43,2,13,32,8,15,19,38,4,44,1,30,34,10,21 },
	{ 41,34,20,13,6,31,37,40,1,12,23,30,36,43,0,25,22,15,39,42,17,24,3,14,45,38,16,9,2,27,33,44,5,8,19,26,32,4,29,18,11,35,46,21,28,7,10 },
},
{
	/* Frame 16 */
	{ 28,7,30,20,45,22,3,26,41,18,29,39,31,21,12,23,14,35,27,0,40,19,10,38,36,13,15,34,1,24,11,16,37,33,25,43,17,8,4,6,46,44,32,2,42,9,5 },
	{ 40,19,12,22,9,2,39,24,34,10,20,42,17,37,0,31,18,45,8,38,35,29,7,46,43,16,15,36,27,33,30,5,44,41,13,23,3,28,6,25,11,14,21,26,32,4,1 },
	{ 36,27,32,14,37,26,33,15,11,31,10,30,44,19,40,6,45,18,41,7,3,23,2,22,12,38,8,13,39,9,35,29,25,34,28,24,4,46,0,5,1,43,21,17,42,20,16 },
	{ 15,28,14,29,32,30,34,12,33,31,35,13,7,20,6,21,40,22,42,4,41,23,43,5,39,24,26,38,25,27,8,36,10,9,37,11,16,18,46,17,19,0,44,2,1,45,3 },
	{ 36,9,19,14,4,43,8,18,15,13,42,23,27,17,12,35,22,41,26,16,46,3,34,31,40,21,25,2,45,30,33,20,24,38,11,44,1,32,29,6,39,10,37,0,28,7,5 },
	{ 32,3,42,25,4,45,14,2,35,24,5,36,7,46,29,34,17,27,37,6,39,28,16,26,9,38,21,31,19,8,41,20,30,18,1,40,11,23,12,0,33,10,43,22,13,44,15 },
	{ 33,29,35,14,32,28,34,31,12,30,13,11,25,10,46,24,27,8,44,26,9,45,5,43,7,4,42,6,21,23,40,20,22,41,1,37,3,39,0,36,2,38,17,19,16,18,15 },
	{ 39,36,38,4,16,6,18,5,17,7,19,33,35,32,34,0,28,2,30,1,29,3,31,45,44,46,12,24,14,26,13,25,15,27,41,43,40,42,8,20,10,22,9,21,11,23,37 },
	{ 24,13,25,46,44,14,26,45,15,27,8,20,43,9,21,42,40,10,22,41,11,23,4,16,39,5,17,38,36,6,18,37,7,19,0,28,35,1,29,34,32,2,30,33,3,31,12 },
	{ 22,38,9,31,0,6,29,40,15,20,33,26,42,13,19,35,4,10,17,44,3,24,37,30,46,1,23,39,8,14,21,32,7,28,41,18,34,5,27,43,12,2,25,36,11,16,45 },
	{ 15,8,6,1,3,46,28,10,39,21,34,23,24,44,43,30,17,37,19,32,12,26,41,5,7,0,14,9,11,38,20,2,29,42,31,16,36,35,22,25,45,27,40,4,18,33,13 },
	{ 15,21,45,22,36,29,39,30,16,40,19,43,24,34,27,1,2,46,13,14,4,7,37,8,11,17,41,18,32,25,35,26,20,44,23,28,38,31,5,6,42,9,10,0,3,33,12 },
},
{
	/* Frame 17 */
	{ 32,36,42,46,33,37,43,0,4,26,30,17,21,10,14,1,5,27,31,16,20,11,15,40,44,34,38,41,45,35,39,8,12,18,22,25,29,2,6,9,13,19,23,24,28,3,7 },
	{ 27,29,46,3,40,5,26,28,35,2,45,4,23,25,34,15,44,1,22,24,39,14,33,0,19,21,38,11,32,13,18,20,43,10,37,12,31,17,42,7,36,9,30,16,6,41,8 },
	{ 31,28,22,5,40,38,10,37,25,19,16,15,32,12,2,21,30,9,7,42,4,41,39,27,24,18,1,44,34,14,33,29,23,20,11,36,8,6,43,17,26,13,3,46,0,45,35 },
	{ 42,8,19,14,4,11,18,29,37,10,1,28,7,36,45,0,30,6,25,3,44,33,31,21,39,24,2,13,32,41,20,27,38,35,12,22,40,26,17,46,34,43,23,9,16,15,5 },
	{ 0,46,20,42,1,21,43,17,4,16,5,38,14,34,10,39,15,35,11,31,27,30,26,6,40,2,7,41,3,23,19,44,22,18,45,32,8,28,33,9,29,25,36,12,24,37,13 },
	{ 14,3,6,42,37,34,28,1,4,32,15,19,7,43,35,44,17,5,8,33,18,23,26,45,16,21,9,12,40,22,27,30,20,25,13,46,41,38,10,31,2,36,24,29,0,39,11 },
	{ 22,45,17,11,4,35,31,36,20,14,9,46,26,33,29,7,12,43,23,44,24,2,5,34,18,41,21,15,0,39,27,32,16,10,13,42,30,37,25,3,8,19,40,28,6,1,38 },
	{ 35,31,38,26,22,2,7,33,13,36,24,29,45,0,20,30,10,15,3,42,6,19,37,8,28,1,40,4,17,11,34,14,39,27,43,23,46,18,9,32,12,25,41,5,44,16,21 },
	{ 26,24,27,25,42,10,40,8,43,11,41,9,37,18,16,36,19,17,2,38,0,3,39,1,45,13,30,44,12,31,28,46,14,29,15,5,22,4,23,34,20,32,6,35,21,33,7 },
	{ 4,26,3,33,12,40,6,11,16,34,14,22,37,24,1,44,19,30,43,20,9,39,27,2,46,32,28,5,10,17,13,41,7,36,25,0,35,15,23,42,21,8,38,45,18,31,29 },
	{ 14,38,13,37,30,29,15,39,12,36,31,20,42,6,40,5,22,21,43,7,41,4,23,10,34,8,32,26,24,11,35,9,33,27,25,2,0,46,18,45,16,3,1,19,44,17,28 },
	{ 26,12,0,9,3,22,42,27,44,1,20,8,29,14,38,23,43,45,18,36,21,40,28,15,16,39,25,10,34,19,37,41,32,17,6,24,11,30,35,4,13,33,7,46,31,2,5 },
},
{
	/* Frame 18 */
	{ 30,5,15,0,10,16,12,6,41,28,35,25,45,19,39,32,21,42,31,36,26,46,1,11,22,13,7,8,2,24,4,14,33,20,43,17,37,27,40,29,34,23,44,18,38,9,3 },
	{ 29,27,41,13,11,28,26,40,12,46,10,21,19,37,5,35,3,20,18,36,4,34,2,25,31,45,9,43,15,24,30,44,8,42,14,17,23,33,1,39,7,16,22,32,0,38,6 },
	{ 41,43,19,12,0,30,2,45,39,46,9,4,11,22,25,32,34,13,1,14,3,29,17,36,5,26,6,24,21,33,40,35,42,15,18,28,16,31,37,44,38,27,7,8,20,10,23 },
	{ 25,21,39,14,19,26,20,29,38,41,27,22,28,1,40,45,23,30,43,0,9,5,44,31,3,42,33,8,4,13,2,11,32,37,12,16,35,10,7,46,36,17,24,34,6,15,18 },
	{ 41,44,37,8,1,29,4,24,38,42,35,2,15,23,27,18,40,33,36,0,28,21,25,16,13,34,14,7,11,19,30,32,45,20,9,17,12,5,46,39,43,6,10,3,31,22,26 },
	{ 16,29,21,42,18,14,37,23,1,28,39,20,3,27,36,22,44,0,33,8,38,5,2,35,26,7,45,31,32,9,40,4,12,34,11,6,30,25,41,17,46,13,10,43,19,15,24 },
	{ 21,10,40,3,30,0,35,19,13,16,46,45,25,6,36,11,22,8,43,31,1,28,34,33,17,14,44,7,26,4,39,23,9,20,42,41,29,2,32,15,18,12,27,5,24,38,37 },
	{ 34,25,20,37,14,41,2,8,39,5,30,27,44,7,28,43,16,33,10,23,13,1,46,21,36,15,40,18,35,24,4,31,3,9,38,29,42,17,32,26,45,6,12,0,11,22,19 },
	{ 45,5,16,44,4,17,20,40,0,21,41,1,13,24,12,25,34,28,38,8,35,29,39,9,18,22,19,23,42,2,46,6,43,3,7,37,26,30,36,27,31,10,32,14,11,33,15 },
	{ 9,5,1,12,8,4,0,29,25,21,17,28,24,20,16,45,35,37,44,34,36,42,43,7,3,31,27,6,2,30,26,23,19,14,10,22,18,15,11,39,41,33,38,40,32,46,13 },
	{ 16,14,22,40,46,9,17,15,23,41,0,28,6,26,32,38,1,29,7,27,33,39,12,20,10,18,44,42,13,21,11,19,45,43,4,24,2,30,36,34,5,25,3,31,37,35,8 },
	{ 39,14,38,16,6,24,46,17,7,25,11,31,35,10,30,34,43,2,22,42,3,23,37,27,45,36,26,44,4,12,18,5,13,19,33,41,32,40,0,20,8,28,1,21,9,29,15 },
},
{
	/* Frame 19 */
	{ 35,10,21,31,1,44,2,11,23,30,36,45,3,46,24,22,37,12,38,16,25,4,13,39,14,17,27,5,40,6,15,19,26,32,41,7,42,28,18,33,8,34,43,20,29,0,9 },
	{ 31,33,25,6,20,42,44,1,39,10,23,12,17,29,2,26,36,40,15,18,35,4,8,21,43,45,30,32,24,7,11,22,13,0,38,27,37,41,16,46,28,3,5,9,14,19,34 },
	{ 29,19,16,35,11,32,8,2,21,26,13,7,46,4,45,31,28,18,43,1,40,34,10,33,25,23,20,39,15,36,12,6,17,30,9,3,42,0,41,27,24,22,5,44,38,14,37 },
	{ 8,13,20,1,26,34,30,6,42,19,24,32,29,37,40,17,45,15,2,12,0,5,31,39,11,18,22,28,36,9,16,44,21,14,27,35,7,43,25,33,4,41,38,10,46,23,3 },
	{ 21,46,17,20,16,43,5,1,42,4,0,29,25,28,24,37,13,33,9,36,12,32,8,19,6,18,7,45,3,41,23,44,2,40,22,27,38,14,26,39,15,35,11,31,34,10,30 },
	{ 6,16,5,34,33,14,24,13,42,36,41,23,0,20,44,8,28,27,39,17,4,3,32,25,12,11,31,40,21,18,7,35,29,26,15,38,43,37,2,22,1,46,45,10,30,9,19 },
	{ 40,7,18,13,28,35,41,6,31,12,21,42,36,15,30,1,20,43,37,14,23,0,25,38,44,3,22,9,24,39,45,2,27,8,17,46,32,11,26,5,16,33,10,19,4,29,34 },
	{ 37,23,38,20,30,12,15,33,3,34,16,19,43,8,26,22,4,7,13,44,14,29,35,0,18,9,40,10,25,5,36,6,39,21,45,31,46,28,1,32,2,17,41,11,42,24,27 },
	{ 3,15,44,24,4,18,30,34,8,36,21,41,29,11,6,0,13,33,26,38,23,42,17,45,25,5,2,14,35,9,37,20,19,46,31,7,1,40,28,10,39,22,43,16,12,32,27 },
	{ 0,22,44,5,19,8,26,39,13,31,34,20,6,17,42,3,24,37,14,29,32,11,45,4,18,40,1,23,12,30,35,9,27,38,16,43,2,21,46,7,28,33,10,25,36,15,41 },
	{ 35,25,32,3,0,38,29,36,6,41,4,9,18,45,17,13,31,21,42,24,33,10,1,28,37,15,5,23,27,34,16,2,30,39,20,43,7,40,11,8,46,19,44,14,12,22,26 },
	{ 38,30,32,19,12,21,43,6,0,28,45,11,22,9,26,36,35,17,40,4,24,3,15,18,13,20,42,39,31,33,29,44,10,7,1,34,16,46,23,8,27,37,25,2,14,41,5 },
},
{
	/* Frame 20 */
	{ 29,19,14,40,34,26,4,24,13,3,31,33,42,21,8,6,36,18,15,16,41,35,5,25,23,10,44,38,30,0,28,43,9,7,27,37,46,17,12,2,32,22,11,20,45,39,1 },
	{ 43,24,42,25,46,29,11,15,28,10,14,35,39,34,38,19,3,23,7,18,2,22,6,45,8,44,9,27,13,31,41,26,12,30,40,37,16,0,36,17,1,21,5,33,20,4,32 },
	{ 41,43,39,21,28,22,15,4,33,35,44,9,18,11,16,25,36,29,23,30,5,12,6,45,46,19,26,0,24,2,40,37,42,38,31,20,13,7,14,32,34,27,1,8,3,10,17 },
	{ 25,39,13,2,41,22,10,36,30,0,21,8,29,7,45,15,42,4,38,12,35,40,23,18,31,33,26,20,16,28,24,6,44,3,14,11,37,1,34,9,19,32,27,46,17,43,5 },
	{ 38,18,35,23,27,15,10,17,5,36,0,28,45,9,40,19,7,2,14,11,42,30,20,37,1,32,29,24,41,12,6,39,3,34,22,46,26,43,31,21,16,33,4,25,13,44,8 },
	{ 2,21,46,22,10,29,30,33,19,34,5,6,45,27,42,9,39,14,3,16,23,11,24,41,31,36,13,35,0,7,44,20,43,8,15,28,17,32,18,4,25,40,26,37,12,38,1 },
	{ 20,30,36,17,42,27,0,14,5,11,41,24,35,22,44,29,38,19,8,2,13,7,37,16,43,26,32,21,46,31,4,10,1,15,45,28,39,18,40,25,34,23,12,6,9,3,33 },
	{ 36,17,26,35,6,41,12,0,39,11,22,21,42,15,18,45,24,33,4,31,3,9,46,27,34,7,40,28,37,16,10,23,13,1,38,19,44,25,32,20,43,14,2,8,5,30,29 },
	{ 45,29,11,6,0,35,13,26,23,36,17,3,15,40,24,4,39,18,33,30,8,42,21,7,1,44,28,10,22,37,16,34,12,46,27,41,25,5,2,14,9,43,20,38,19,32,31 },
	{ 1,7,3,4,0,6,2,37,33,39,35,36,32,38,34,21,25,23,27,20,24,22,26,13,9,15,11,12,8,14,10,45,41,43,44,40,46,42,29,17,31,19,28,16,30,18,5 },
	{ 41,16,38,27,0,11,36,25,35,22,9,6,33,28,42,19,12,3,40,17,26,1,10,45,20,34,31,4,15,32,29,39,18,13,2,37,24,46,23,8,7,44,21,43,30,5,14 },
	{ 44,16,46,19,41,43,22,9,27,36,6,33,34,1,29,45,18,13,10,8,21,37,38,5,25,35,30,0,28,3,14,12,17,11,40,20,42,23,39,26,4,24,7,31,32,2,15 },
},
{
	/* Frame 21 */
	{ 24,28,25,29,16,20,17,21,8,12,32,36,9,13,33,37,41,45,0,4,40,44,1,5,18,22,26,30,19,23,27,31,34,38,42,46,35,39,43,2,6,10,14,3,7,11,15 },
	{ 17,35,6,44,9,31,16,38,7,33,8,30,29,39,2,32,5,27,28,42,3,37,4,26,25,43,14,36,1,23,24,46,15,41,0,22,21,10,40,13,19,20,34,11,45,12,18 },
	{ 13,21,15,23,44,46,12,20,14,22,45,29,5,31,7,36,38,28,4,30,6,37,39,9,17,11,19,40,42,8,16,10,18,41,43,25,1,27,3,32,34,24,0,26,2,33,35 },
	{ 12,1,46,11,23,13,44,0,39,10,43,30,18,45,9,38,20,42,31,19,36,8,41,21,35,16,26,37,7,40,28,34,17,27,6,33,29,24,4,15,32,3,25,5,14,2,22 },
	{ 3,1,18,45,16,2,0,46,19,44,17,29,39,15,37,13,30,28,38,14,36,12,31,21,43,7,41,5,22,20,42,6,40,4,23,35,11,33,9,26,24,34,10,32,8,27,25 },
	{ 15,24,22,17,14,25,23,1,31,9,7,0,30,8,6,33,37,41,45,32,36,40,44,11,20,18,28,10,21,19,29,27,5,3,13,26,4,2,12,43,42,46,35,39,34,38,16 },
	{ 18,37,17,7,12,27,44,20,2,1,34,30,41,29,11,4,39,19,36,24,14,13,46,22,33,21,3,8,43,31,40,16,6,5,38,26,45,25,15,0,35,23,32,28,10,9,42 },
	{ 35,10,13,15,18,4,37,23,34,26,12,45,14,3,17,36,22,27,33,25,44,30,46,2,41,16,43,7,21,32,24,31,29,40,1,42,6,39,20,9,11,28,0,19,38,5,8 },
	{ 44,42,45,43,28,12,26,10,29,13,27,11,36,34,37,35,16,4,22,2,17,5,23,3,40,46,41,24,8,30,14,25,9,31,15,32,38,33,39,20,0,18,6,21,1,19,7 },
	{ 19,1,2,31,12,35,14,23,4,41,6,42,37,24,39,11,16,44,3,46,13,15,32,29,5,7,43,21,25,26,8,17,45,18,0,30,33,28,34,22,20,40,27,36,9,38,10 },
	{ 32,24,12,0,45,21,41,17,34,26,15,2,46,22,43,19,8,37,29,33,25,5,1,44,10,38,30,35,27,6,3,23,13,9,36,20,40,16,4,14,11,39,31,42,18,7,28 },
	{ 20,14,26,35,31,45,25,0,21,46,27,2,30,7,12,40,1,36,16,42,3,6,13,18,41,23,28,37,17,43,38,19,8,22,29,4,32,10,15,39,34,9,44,5,24,33,11 },
},
{
	/* Frame 22 */
	{ 36,25,45,16,5,8,29,33,20,40,38,18,7,27,35,22,10,31,24,13,4,28,32,41,1,46,6,26,15,34,43,30,3,12,37,44,17,9,0,21,39,14,19,42,2,23,11 },
	{ 27,44,12,43,11,29,26,45,13,42,10,28,19,32,4,39,3,21,18,33,5,38,2,20,31,40,8,15,25,30,41,9,46,14,24,23,36,0,35,7,17,22,37,1,34,6,16 },
	{ 27,9,33,26,8,32,11,35,24,10,34,25,19,41,1,18,40,0,43,3,16,42,2,17,13,37,15,39,12,36,14,38,28,30,29,31,45,5,7,44,4,46,6,20,22,21,23 },
	{ 41,10,35,7,46,28,1,32,11,44,6,39,29,8,33,4,45,15,38,18,9,5,36,14,19,22,12,37,16,26,23,13,42,17,27,30,2,43,24,20,31,40,3,34,25,21,0 },
	{ 39,45,46,29,5,30,6,12,35,41,42,1,26,2,8,17,37,38,44,21,15,22,28,4,31,33,34,40,11,18,24,0,27,36,7,13,20,14,23,43,32,3,9,16,10,19,25 },
	{ 10,32,3,11,33,18,41,26,19,40,27,6,38,14,46,7,39,15,22,30,23,31,24,34,0,42,25,35,1,43,9,16,8,17,28,4,36,29,5,37,13,45,20,12,44,21,2 },
	{ 21,6,32,15,26,8,23,5,16,34,37,25,10,44,7,18,0,39,27,9,28,46,41,17,2,36,11,30,12,43,19,1,20,38,33,29,14,40,3,22,4,35,31,13,24,42,45 },
	{ 34,0,32,3,35,1,33,18,16,19,17,6,44,4,7,45,5,22,20,46,23,21,8,40,27,9,41,26,24,10,42,25,11,43,12,38,31,36,13,39,30,37,28,14,29,15,2 },
	{ 36,38,37,39,28,4,30,6,29,5,31,7,44,46,45,16,12,18,14,17,13,19,15,32,34,33,35,24,0,26,2,25,1,27,3,40,42,41,43,20,8,22,10,21,9,23,11 },
	{ 18,14,11,17,29,24,19,30,10,40,46,33,12,25,5,35,31,26,7,41,32,13,8,4,1,44,34,37,27,6,3,39,9,20,0,45,36,43,22,2,15,38,21,16,28,42,23 },
	{ 18,42,17,41,2,1,27,35,20,44,15,4,30,38,29,37,10,9,19,43,24,32,3,12,22,46,21,45,6,5,31,39,16,40,11,0,26,34,25,33,14,13,23,28,36,7,8 },
	{ 41,12,40,45,18,8,22,44,19,9,23,29,5,33,28,4,32,37,24,0,36,25,1,43,21,42,20,46,10,14,16,11,15,17,35,39,34,38,26,2,30,6,27,3,31,7,13 },
},
{
	/* Frame 23 */
	{ 14,2,17,41,5,6,28,33,9,27,39,20,44,1,31,19,43,24,36,12,23,35,11,16,40,4,15,3,32,8,26,7,46,29,0,30,18,42,38,21,45,22,34,10,25,37,13 },
	{ 10,12,20,32,7,43,28,45,27,0,23,38,17,37,8,15,3,5,18,41,31,46,25,34,21,33,6,11,13,26,1,22,39,42,29,44,14,2,16,36,9,30,24,35,4,19,40 },
	{ 13,17,15,19,44,46,12,16,14,18,45,35,29,1,31,3,32,34,28,0,30,2,33,43,9,21,11,23,40,42,8,20,10,22,41,39,25,5,27,7,36,38,24,4,26,6,37 },
	{ 11,6,43,18,32,25,36,21,1,34,27,39,30,3,8,12,40,17,44,10,15,42,19,22,37,28,0,4,38,31,2,7,13,33,24,45,20,14,35,26,46,23,29,9,5,41,16 },
	{ 7,20,40,22,42,4,6,21,41,23,43,5,39,15,28,30,36,12,38,14,29,31,37,13,16,18,0,44,2,46,17,19,1,45,3,24,26,32,8,34,10,25,27,33,9,35,11 },
	{ 23,10,21,8,6,26,4,24,22,11,20,9,7,27,5,42,46,40,44,43,41,45,19,29,17,14,2,12,0,30,18,28,16,15,3,13,1,31,34,38,32,36,35,39,33,37,25 },
	{ 32,11,22,5,28,33,10,27,4,21,38,44,3,26,9,20,39,45,2,19,8,25,42,36,15,18,1,24,43,37,14,31,0,17,34,40,7,30,13,16,35,41,6,23,12,29,46 },
	{ 41,14,3,11,28,0,37,25,40,30,2,39,10,13,21,36,24,31,33,23,38,26,46,12,35,20,43,9,17,32,22,27,19,34,5,42,8,45,16,7,15,18,4,29,44,1,6 },
	{ 9,15,0,6,17,40,31,46,24,33,22,39,5,11,12,2,21,36,19,42,28,45,26,35,1,7,8,14,25,32,23,38,16,41,30,13,3,4,10,29,44,27,34,20,37,18,43 },
	{ 39,28,32,27,6,13,16,42,23,45,5,34,37,30,8,15,18,29,0,7,17,43,44,10,35,24,36,31,2,9,20,46,19,41,1,38,33,26,12,11,22,25,4,3,21,40,14 },
	{ 31,43,2,25,21,40,30,34,3,24,20,41,0,35,10,46,7,29,32,1,44,11,39,6,28,33,8,45,4,38,15,19,9,36,5,14,18,23,37,12,17,27,22,42,13,16,26 },
	{ 40,4,17,14,3,32,8,26,6,29,0,31,20,42,39,19,45,34,10,22,25,37,13,16,15,2,41,5,7,46,28,33,9,27,38,18,44,1,30,21,43,23,24,36,12,35,11 },
},
{
	/* Frame 24 */
	{ 10,7,40,20,22,46,35,44,17,24,11,39,41,21,28,23,30,2,45,32,25,38,8,36,29,31,3,12,33,14,18,9,37,42,13,0,15,19,26,4,43,6,1,34,27,16,5 },
	{ 28,12,24,8,29,13,25,9,45,41,44,40,4,22,0,5,23,1,19,37,33,18,36,32,43,30,14,42,31,15,27,11,26,10,46,20,35,16,6,21,34,17,7,3,39,2,38 },
	{ 27,9,26,8,11,37,24,39,10,36,25,38,21,41,23,20,40,22,43,5,7,42,4,6,29,31,33,28,30,32,13,35,15,12,34,14,19,1,18,0,45,3,16,44,2,46,17 },
	{ 35,28,17,4,31,36,19,41,7,13,39,8,43,20,14,10,23,44,29,24,5,0,37,26,32,6,2,38,9,34,21,16,11,30,45,18,40,25,12,46,1,42,27,33,15,3,22 },
	{ 22,38,21,37,15,12,31,18,34,17,33,3,8,27,43,7,4,23,28,44,14,13,0,19,35,24,40,10,9,39,20,36,6,5,30,46,29,45,16,32,2,1,26,42,25,41,11 },
	{ 33,25,35,27,8,10,32,24,34,26,9,15,29,31,12,44,14,46,28,30,13,45,1,43,3,17,19,40,0,42,2,16,18,41,5,37,7,39,21,23,4,36,6,38,20,22,11 },
	{ 20,35,26,44,17,38,31,8,2,13,7,33,24,18,36,29,42,23,0,14,5,11,45,16,39,30,40,21,34,27,12,6,9,3,37,28,43,22,32,25,46,19,4,10,1,15,41 },
	{ 40,4,32,13,41,5,33,28,20,29,21,8,38,0,9,39,1,24,16,46,25,17,6,34,31,7,35,30,22,14,42,23,15,43,2,44,27,36,3,45,26,37,18,10,19,11,12 },
	{ 13,3,4,10,17,44,23,34,24,37,30,43,1,7,8,14,21,32,27,38,28,41,18,5,11,12,2,25,36,31,42,16,45,22,35,9,15,0,6,29,40,19,46,20,33,26,39 },
	{ 42,45,40,18,1,6,3,21,24,23,43,12,41,38,2,36,25,22,27,13,8,15,28,39,34,37,32,26,9,14,11,29,16,31,35,4,33,46,10,44,17,30,19,5,0,7,20 },
	{ 21,12,39,41,26,3,24,13,38,40,19,2,25,0,37,18,11,16,1,46,36,31,10,17,8,35,45,30,7,28,9,34,44,23,6,29,4,43,33,22,15,20,5,42,32,27,14 },
	{ 46,18,44,17,34,0,31,21,42,8,39,37,27,7,45,16,15,35,28,32,30,3,43,40,11,23,4,26,6,25,12,14,19,29,33,2,1,41,20,10,22,9,5,38,24,36,13 },
},
{
	/* Frame 25 */
	{ 34,46,40,36,35,41,37,2,14,8,4,19,31,25,21,3,15,9,5,18,30,24,20,42,38,32,44,43,39,33,45,10,6,0,12,27,23,17,29,11,7,1,13,26,22,16,28 },
	{ 3,20,37,23,34,9,14,29,40,18,43,4,7,24,33,27,46,13,2,17,36,22,39,8,11,28,45,31,42,1,6,21,32,26,35,12,15,16,41,19,38,5,10,25,44,30,0 },
	{ 14,45,29,38,18,4,7,40,24,43,27,9,2,33,21,46,30,12,15,36,16,39,19,5,10,41,25,34,22,0,3,44,28,31,13,6,37,17,42,26,8,11,32,20,35,23,1 },
	{ 46,36,26,22,35,29,16,31,44,7,9,43,32,14,2,25,5,40,18,12,39,21,11,23,34,28,1,37,27,6,8,42,17,30,45,24,4,33,15,3,38,20,10,41,19,13,0 },
	{ 1,5,28,24,2,43,22,14,27,0,41,4,45,39,25,42,23,11,40,21,44,38,9,13,7,18,10,30,20,16,8,35,12,6,19,33,31,37,17,34,29,46,3,32,15,36,26 },
	{ 7,34,27,38,31,19,23,35,10,39,8,14,12,18,0,22,4,11,9,15,42,13,40,46,1,44,5,32,25,36,43,29,41,17,45,2,21,33,6,24,37,26,28,30,16,3,20 },
	{ 9,46,23,45,16,3,4,39,26,40,25,14,13,34,19,33,28,7,8,43,22,44,21,2,1,38,31,37,24,11,12,18,32,17,6,5,42,27,41,20,15,0,35,30,36,29,10 },
	{ 12,14,23,5,28,39,30,37,17,42,40,11,0,2,27,13,20,22,45,29,38,36,7,8,10,19,1,24,35,26,33,21,46,44,15,4,6,31,9,16,43,18,41,25,34,32,3 },
	{ 44,28,22,21,41,8,3,16,45,12,46,15,34,20,9,27,0,13,14,35,4,7,42,26,1,19,31,5,32,6,43,10,25,36,18,39,30,29,33,23,11,40,24,37,2,38,17 },
	{ 22,19,11,14,5,44,17,9,34,28,23,18,32,15,45,16,35,12,38,2,33,30,27,0,21,13,39,25,3,42,6,31,36,26,1,40,20,24,43,7,46,37,10,41,4,8,29 },
	{ 12,40,15,43,28,31,13,41,14,42,29,0,44,2,16,18,1,45,3,46,17,19,4,32,6,34,20,22,5,33,7,35,21,23,36,26,38,8,11,24,37,27,39,9,10,25,30 },
	{ 7,40,29,35,18,5,10,33,16,38,27,8,3,36,25,30,1,6,45,28,34,23,4,15,32,21,43,26,13,2,41,24,46,19,0,11,44,17,39,22,9,14,37,20,42,31,12 },
},
{
	/* Frame 26 */
	{ 12,7,33,28,10,17,45,26,14,40,21,35,30,36,19,9,42,23,13,38,0,11,16,4,15,41,20,2,25,37,18,6,32,29,43,22,44,27,39,1,34,31,5,46,8,3,24 },
	{ 9,30,38,17,41,7,0,27,35,28,36,10,5,18,42,25,33,15,8,23,16,40,6,13,26,34,21,45,3,4,31,39,24,32,14,1,22,46,29,37,11,12,19,43,20,44,2 },
	{ 8,10,43,1,19,36,17,28,14,13,23,4,35,9,40,27,42,25,18,16,39,3,31,46,12,45,22,32,21,34,7,41,26,24,11,0,38,2,37,30,29,44,15,33,20,6,5 },
	{ 46,10,16,41,37,29,6,31,34,44,1,24,14,4,9,18,43,38,20,12,33,3,26,17,40,36,28,22,11,0,25,7,30,35,45,8,19,42,15,5,32,2,27,39,21,13,23 },
	{ 1,27,34,6,29,18,10,4,40,45,3,24,33,20,31,38,9,22,42,36,14,17,26,35,7,12,0,11,5,41,28,19,46,21,30,39,44,2,25,32,43,37,15,16,8,23,13 },
	{ 35,20,3,45,17,42,13,40,10,37,8,34,5,2,16,29,41,31,36,9,4,33,23,1,28,30,25,27,32,22,0,19,15,24,39,26,7,21,46,18,44,14,43,12,38,11,6 },
	{ 24,35,12,38,27,33,15,22,36,25,2,13,20,39,0,42,23,37,3,18,40,21,6,1,16,43,4,46,19,41,7,30,44,17,10,5,28,8,34,31,45,11,26,32,29,14,9 },
	{ 41,28,2,44,25,39,27,8,34,30,13,15,37,20,10,32,17,19,4,42,22,1,3,45,24,6,40,29,35,31,12,38,26,9,11,33,16,14,36,21,43,23,0,46,18,5,7 },
	{ 42,18,30,27,41,0,13,24,43,2,46,7,36,26,1,21,8,3,6,37,10,15,44,20,9,29,23,11,32,14,45,4,17,34,28,39,22,19,33,31,5,40,16,35,12,38,25 },
	{ 27,30,25,28,11,40,42,3,6,0,21,18,39,33,36,31,8,29,10,15,41,44,46,7,1,4,19,22,16,37,34,9,12,26,14,24,45,43,5,2,23,17,20,35,38,32,13 },
	{ 18,12,24,38,44,7,19,13,25,39,45,22,10,28,0,42,32,23,11,29,1,43,33,14,26,4,16,46,36,15,27,5,17,37,30,2,20,8,34,40,31,3,21,9,35,41,6 },
	{ 26,44,38,13,17,7,27,45,39,12,16,2,22,40,34,9,29,3,23,41,35,8,28,14,18,36,46,5,25,15,19,37,4,24,10,30,32,42,1,21,11,31,33,43,0,20,6 },
},
{
	/* Frame 27 */
	{ 33,12,7,46,25,18,0,13,34,21,24,1,40,35,14,20,27,36,41,2,15,23,26,37,8,3,42,29,22,4,9,38,43,17,28,5,44,39,10,16,31,32,45,6,11,19,30 },
	{ 42,13,26,3,4,21,6,11,12,29,46,35,33,20,7,22,10,17,41,28,15,34,25,32,39,23,37,16,40,18,14,31,45,24,1,38,36,9,19,43,30,44,0,27,2,5,8 },
	{ 40,28,43,31,1,2,33,25,46,26,12,15,36,20,39,23,9,10,41,17,34,18,0,3,44,24,27,5,6,37,29,42,30,8,11,32,16,35,19,13,14,45,21,38,22,4,7 },
	{ 28,37,31,7,45,4,25,10,19,1,29,30,5,11,34,16,42,14,20,23,26,35,8,17,43,2,15,38,12,21,46,22,27,9,32,3,40,39,13,36,6,44,24,33,18,41,0 },
	{ 3,14,37,10,16,44,29,39,9,18,22,11,32,17,45,4,38,24,34,19,23,26,33,30,5,40,25,35,12,46,7,42,27,31,20,41,0,13,6,43,2,15,36,21,1,28,8 },
	{ 34,15,38,24,28,41,26,45,30,43,8,1,12,5,10,3,14,7,25,16,29,40,20,33,44,18,37,42,22,35,46,0,39,4,2,27,6,31,17,9,21,32,13,19,36,11,23 },
	{ 26,0,24,34,32,3,27,1,25,35,33,6,22,4,20,38,36,7,23,5,21,39,37,10,18,8,16,42,40,11,19,9,17,43,41,14,30,12,28,46,44,15,31,13,29,45,2 },
	{ 0,6,23,9,24,30,41,21,34,36,3,12,10,27,1,16,39,22,33,25,46,40,15,4,2,19,13,28,43,26,45,17,38,32,7,8,14,31,5,20,35,18,37,29,42,44,11 },
	{ 44,9,17,12,33,20,29,26,39,18,31,34,7,42,15,8,37,16,25,32,5,41,28,27,38,3,46,11,6,14,23,36,1,45,24,4,40,13,21,2,10,19,30,35,22,43,0 },
	{ 6,37,13,1,24,35,11,20,40,7,30,36,18,46,25,34,21,8,31,4,19,14,45,2,33,9,43,5,28,39,15,16,44,3,26,32,22,42,29,38,17,12,27,0,23,10,41 },
	{ 33,23,34,37,27,38,40,31,42,44,3,46,7,11,25,15,29,18,0,22,35,4,26,39,9,30,43,13,17,21,32,24,36,28,41,1,45,2,5,6,8,10,12,14,16,19,20 },
	{ 41,26,7,28,1,46,40,23,6,25,0,35,45,22,11,24,5,34,44,19,10,21,4,39,33,18,15,20,9,38,32,31,14,17,8,43,37,30,3,16,13,42,36,27,2,29,12 },
},
{
	/* Frame 28 */
	{ 15,21,12,39,36,24,19,10,45,34,30,5,29,43,40,3,27,0,46,20,13,6,37,18,11,17,8,35,32,28,23,14,41,38,26,1,25,44,7,31,4,42,16,9,2,33,22 },
	{ 16,44,21,41,37,1,4,11,18,14,34,27,7,30,45,9,12,0,25,5,28,32,42,19,15,22,35,38,31,2,8,17,13,20,40,24,36,29,33,43,46,23,10,39,3,26,6 },
	{ 14,28,43,7,38,4,23,26,44,24,11,0,2,35,15,40,12,42,31,39,5,36,22,21,45,8,10,1,32,19,34,17,41,13,30,29,37,6,20,9,46,27,25,33,18,16,3 },
	{ 28,31,1,45,19,9,38,27,21,40,22,29,34,30,18,39,26,36,41,6,35,14,2,17,10,37,25,7,4,15,32,12,3,46,16,11,24,42,5,33,13,0,44,8,43,20,23 },
	{ 39,4,9,3,15,40,20,34,25,19,37,22,10,1,46,13,7,32,26,44,17,29,43,8,2,31,38,5,24,18,36,14,41,21,35,0,12,23,11,16,28,42,6,33,27,45,30 },
	{ 28,41,17,46,9,35,14,3,44,26,33,12,1,24,31,42,22,10,29,40,20,8,38,15,6,27,36,18,4,25,16,43,23,34,11,2,45,21,32,13,39,0,7,30,37,19,5 },
	{ 25,11,19,0,24,10,18,33,43,32,42,5,21,15,31,4,20,14,30,37,36,46,9,17,3,27,8,16,2,26,41,35,40,34,13,29,7,23,12,28,6,22,45,39,44,38,1 },
	{ 37,24,10,32,29,27,4,42,30,1,7,41,16,2,44,21,39,19,8,34,22,13,11,33,28,14,36,25,43,31,0,46,26,5,3,45,20,6,40,17,35,23,12,38,18,9,15 },
	{ 38,7,21,2,33,16,19,30,45,28,27,40,9,42,11,6,37,20,23,32,1,35,18,31,44,13,46,15,8,10,25,36,5,39,22,0,34,3,17,12,14,29,26,41,24,43,4 },
	{ 11,14,33,36,42,31,16,9,12,2,39,40,29,19,22,15,0,37,43,46,17,20,26,13,3,6,41,44,34,23,24,1,4,10,32,21,27,30,7,8,45,35,38,25,28,18,5 },
	{ 39,18,1,22,5,3,24,7,28,32,10,36,17,14,34,21,41,38,19,45,0,23,43,4,26,9,30,13,11,16,15,20,40,2,44,25,6,42,29,33,46,27,37,8,31,35,12 },
	{ 5,27,39,24,32,3,0,18,46,17,45,10,9,23,43,20,36,7,4,30,34,29,33,14,13,19,16,40,11,8,26,38,25,37,2,1,31,35,28,44,15,12,22,42,21,41,6 },
},
{
	/* Frame 29 */
	{ 24,22,16,25,23,17,30,31,8,6,0,46,9,7,1,41,39,33,14,40,38,32,15,18,28,20,19,29,21,26,27,2,12,42,4,3,13,43,5,35,45,10,37,34,44,11,36 },
	{ 43,9,15,29,32,19,34,4,6,24,41,30,39,13,3,17,44,23,46,8,10,28,37,18,35,1,7,21,40,27,42,12,14,16,33,22,5,11,25,36,31,38,0,2,20,45,26 },
	{ 46,44,22,14,20,12,45,23,15,21,13,38,36,30,6,28,4,39,37,31,7,29,5,42,40,18,10,16,8,43,41,19,11,17,9,34,32,26,2,24,0,35,33,27,3,25,1 },
	{ 31,32,4,43,24,39,2,37,14,20,9,27,17,46,12,35,22,41,10,0,28,44,7,5,42,25,38,18,30,33,21,8,3,36,15,13,34,23,40,26,16,29,45,6,11,1,19 },
	{ 18,42,17,9,27,7,4,29,14,3,0,37,10,20,44,33,30,43,16,40,26,38,25,5,23,15,34,12,1,19,11,8,21,45,6,28,41,2,39,24,36,22,46,35,13,32,31 },
	{ 28,14,29,31,33,13,35,30,32,12,34,11,24,46,10,25,27,45,9,26,44,8,20,43,22,21,42,23,5,7,41,4,6,40,16,18,17,19,37,1,39,3,36,0,38,2,15 },
	{ 13,34,31,41,16,15,0,43,18,44,25,2,9,46,27,37,28,11,12,39,30,40,21,14,5,42,23,33,24,7,8,35,26,36,17,10,1,38,19,45,20,3,4,22,32,29,6 },
	{ 40,38,22,45,24,10,19,4,21,15,9,39,44,42,18,33,20,14,31,8,17,3,13,43,32,46,30,37,16,2,27,12,29,7,1,36,34,26,41,28,6,23,0,25,11,5,35 },
	{ 10,5,22,3,25,8,31,38,20,32,43,45,2,9,30,15,21,0,19,42,28,44,35,37,14,1,18,7,29,12,27,34,16,36,41,6,13,26,11,17,4,23,46,24,40,39,33 },
	{ 17,5,45,16,4,44,1,41,20,0,40,21,25,13,24,12,39,9,35,28,38,8,34,29,23,19,22,18,7,3,43,6,46,2,42,31,37,27,30,36,26,33,15,11,32,14,10 },
	{ 34,22,14,38,11,3,32,20,13,36,8,1,25,6,43,31,35,23,26,18,39,10,4,40,28,33,21,44,16,37,9,15,7,42,2,27,46,19,12,5,41,29,0,24,45,17,30 },
	{ 9,7,16,11,28,36,18,40,21,30,38,25,33,42,23,45,4,27,35,8,6,1,10,13,3,20,15,24,32,22,44,17,26,34,29,37,46,19,41,0,31,39,12,43,2,5,14 },
},
{
	/* Frame 30 */
	{ 4,19,45,26,36,2,29,43,34,6,16,38,9,33,31,18,13,37,28,42,21,35,11,46,25,39,15,8,23,1,30,40,12,5,44,27,20,3,10,24,7,17,14,22,0,41,32 },
	{ 36,15,9,23,43,17,45,6,12,26,38,28,40,3,5,31,35,25,37,14,0,22,42,16,32,11,13,19,21,41,2,8,30,34,24,44,7,1,27,39,29,33,10,4,18,46,20 },
	{ 33,9,26,32,8,27,24,34,10,25,35,11,41,1,18,40,0,19,16,42,2,17,43,3,30,28,31,29,38,14,36,12,39,15,37,13,22,20,23,21,46,6,44,4,7,45,5 },
	{ 9,2,30,39,21,37,25,18,34,15,40,13,23,46,10,0,29,43,6,26,44,16,32,3,31,38,4,8,19,35,14,41,20,36,24,11,1,12,22,27,45,17,33,28,42,7,5 },
	{ 5,8,33,3,30,17,36,9,6,34,16,12,37,40,7,10,35,13,19,41,38,11,20,25,44,18,14,39,42,21,24,23,45,15,0,43,22,27,46,1,28,26,4,32,29,2,31 },
	{ 34,14,32,29,35,15,33,13,30,12,31,24,10,46,25,11,9,45,26,8,44,27,6,4,42,7,5,43,22,41,20,23,40,21,2,38,0,36,3,39,1,37,18,16,19,17,28 },
	{ 24,8,42,19,37,3,30,32,25,14,9,20,43,4,38,31,33,15,26,44,21,10,5,16,39,0,34,27,45,11,22,40,17,6,1,28,35,12,46,23,41,7,18,36,29,2,13 },
	{ 0,16,42,1,17,10,26,32,11,27,33,4,28,46,5,29,14,22,36,15,23,37,35,8,24,34,9,25,2,18,40,3,19,41,39,12,20,38,13,21,6,30,44,7,31,45,43 },
	{ 2,9,22,11,29,4,31,46,16,44,35,33,10,5,30,7,17,12,19,34,24,32,43,41,6,13,18,15,25,0,27,42,20,40,39,37,14,1,26,3,21,8,23,38,28,36,45 },
	{ 16,5,39,27,14,41,43,20,3,32,31,25,45,18,7,36,9,29,11,22,0,34,13,26,15,40,17,4,38,33,30,24,44,42,21,2,37,8,28,46,19,6,1,35,12,10,23 },
	{ 16,36,19,39,20,34,23,1,26,46,13,30,8,11,41,4,7,17,37,2,32,21,35,14,24,44,27,28,42,31,9,18,38,5,22,0,3,33,12,15,25,45,10,40,29,43,6 },
	{ 20,46,40,15,19,9,21,41,14,18,24,0,38,32,31,7,25,1,39,33,30,6,12,16,42,44,11,23,13,17,43,45,10,22,28,4,34,36,27,3,29,5,35,37,26,2,8 },
},
{
	/* Frame 31 */
	{ 8,35,26,15,5,6,41,1,46,19,29,39,30,20,10,32,25,45,16,36,43,23,3,13,14,4,9,34,27,0,18,28,7,40,33,24,44,38,31,21,11,22,2,12,17,37,42 },
	{ 32,39,29,37,9,24,46,21,12,1,38,36,30,41,25,10,20,13,22,0,17,2,5,31,40,11,26,45,23,14,16,3,18,4,6,43,27,44,15,35,19,33,7,28,42,8,34 },
	{ 21,9,42,40,22,10,20,8,43,41,23,11,29,1,34,32,30,2,28,0,35,33,31,3,17,13,46,44,18,14,16,12,45,19,15,25,5,38,36,26,6,24,4,39,37,27,7 },
	{ 38,30,37,20,23,35,10,1,42,18,39,14,36,13,46,22,45,11,25,43,2,15,12,6,44,5,32,24,3,17,29,7,4,33,8,27,40,16,28,31,21,9,34,26,41,0,19 },
	{ 40,17,43,26,38,9,4,15,34,29,0,3,25,37,20,46,23,12,33,16,42,19,39,8,11,6,45,28,31,2,41,24,36,27,22,5,32,14,35,18,1,10,7,44,21,30,13 },
	{ 21,42,12,34,4,28,20,43,13,35,5,25,17,44,8,36,0,24,16,45,9,37,1,23,14,6,40,30,32,22,15,7,41,31,33,19,46,10,38,2,26,18,11,39,3,27,29 },
	{ 18,4,24,46,36,15,19,5,25,37,10,30,0,20,42,32,11,31,1,21,43,33,6,26,12,16,38,44,7,27,13,17,39,45,2,22,8,28,34,40,3,23,9,29,35,41,14 },
	{ 36,34,22,33,16,14,19,8,29,11,5,35,32,46,18,45,28,10,31,4,25,7,1,44,42,30,41,24,6,27,0,21,3,13,43,40,38,26,37,20,2,23,12,17,15,9,39 },
	{ 34,33,23,39,17,36,18,7,28,9,10,12,46,45,27,35,21,32,22,3,16,5,6,8,42,41,31,25,44,26,15,20,1,2,4,38,37,19,43,29,40,30,11,24,13,14,0 },
	{ 1,25,35,0,24,34,32,3,27,33,2,26,21,9,43,20,8,42,40,23,11,41,22,10,5,29,39,4,28,38,36,7,31,37,6,30,17,13,16,12,46,44,19,15,45,18,14 },
	{ 29,1,36,23,26,2,28,32,37,9,22,3,38,33,4,8,45,31,34,39,10,5,41,44,17,30,35,6,11,46,40,13,16,25,7,42,19,12,24,43,14,18,21,0,15,27,20 },
	{ 45,34,20,9,6,27,37,44,1,8,23,26,36,0,29,22,11,39,46,17,28,3,10,41,38,16,13,2,31,33,40,5,12,19,30,32,43,4,25,18,15,35,42,21,24,7,14 },
},
{
	/* Frame 32 */
	{ 43,1,8,16,46,37,44,42,33,9,28,17,30,4,45,6,26,32,41,2,29,31,5,12,7,14,20,27,22,40,3,10,18,13,39,15,21,23,24,35,11,0,19,38,36,25,34 },
	{ 16,42,35,29,7,2,8,23,45,18,40,30,5,27,33,43,21,15,10,28,6,25,3,38,22,13,19,41,4,1,36,20,14,17,11,46,24,34,39,12,9,44,0,31,37,26,32 },
	{ 33,15,13,32,14,12,30,34,28,31,35,29,41,7,5,40,6,4,22,42,20,23,43,21,39,9,37,26,38,8,36,27,24,10,25,11,1,45,18,46,0,44,19,16,2,17,3 },
	{ 38,8,37,18,1,29,33,7,4,39,25,36,11,46,0,45,28,32,31,21,41,24,10,17,44,3,30,35,20,40,23,27,16,2,14,34,13,22,43,26,9,19,15,12,6,42,5 },
	{ 36,1,27,6,12,43,0,26,7,5,42,31,19,25,4,35,30,41,18,24,46,11,34,23,40,29,17,10,45,22,33,28,16,38,3,44,9,32,21,14,39,2,37,8,20,15,13 },
	{ 33,7,31,23,40,14,32,6,30,22,41,11,3,39,27,19,10,46,2,38,26,18,5,43,29,35,21,12,4,42,28,34,20,13,1,37,25,17,8,44,0,36,24,16,9,45,15 },
	{ 25,7,27,4,24,6,26,37,39,36,38,1,21,3,23,0,20,2,22,33,35,32,34,13,17,15,19,12,16,14,18,45,44,46,9,29,11,31,8,28,10,30,41,43,40,42,5 },
	{ 12,24,46,13,25,14,26,44,15,27,45,43,8,20,42,9,21,10,22,40,11,23,41,39,4,16,38,5,17,6,18,36,7,19,37,35,0,28,34,1,29,2,30,32,3,31,33 },
	{ 38,45,23,35,25,40,18,3,20,5,14,0,42,33,27,39,29,44,22,7,24,9,2,4,46,37,31,43,17,32,26,11,28,13,6,8,34,41,19,21,36,30,15,16,1,10,12 },
	{ 0,36,31,9,45,22,4,11,13,2,24,42,15,17,35,6,40,28,19,46,33,21,26,39,8,44,23,1,37,30,12,3,5,10,16,34,7,25,43,14,32,20,27,38,41,29,18 },
	{ 27,14,40,39,0,21,2,15,43,38,17,20,3,22,45,42,16,5,18,23,33,44,9,4,19,6,32,8,29,10,7,35,46,25,28,11,30,37,34,24,13,26,31,41,36,1,12 },
	{ 11,21,41,22,36,25,39,26,16,44,19,28,34,31,1,2,42,9,10,4,7,37,12,15,17,45,18,32,29,35,30,20,40,23,43,24,38,27,5,6,46,13,14,0,3,33,8 },
},
{
	/* Frame 33 */
	{ 25,46,2,37,9,19,24,3,36,8,18,29,34,6,41,13,23,28,35,7,40,12,22,17,38,10,45,1,27,16,39,11,44,0,26,21,42,14,33,5,31,20,43,15,32,4,30 },
	{ 36,9,14,35,16,23,13,8,34,20,17,12,33,46,3,21,26,45,32,7,2,30,27,44,1,6,43,24,31,5,0,39,42,28,25,4,41,38,11,29,18,37,40,15,10,22,19 },
	{ 5,24,23,10,33,44,4,9,22,31,45,38,21,8,3,30,39,42,20,29,2,15,36,43,1,28,19,14,37,40,0,13,18,27,41,34,17,12,7,26,35,46,16,25,6,11,32 },
	{ 20,40,17,5,24,12,9,6,2,22,43,31,27,37,0,44,21,41,38,28,34,25,13,18,7,3,14,32,10,30,16,4,1,45,8,39,29,35,46,23,42,19,26,36,15,33,11 },
	{ 10,23,1,13,35,14,27,38,40,5,16,31,32,24,20,43,45,3,46,28,8,37,7,18,0,12,34,11,22,4,17,15,26,39,41,21,42,44,2,30,33,25,36,6,19,29,9 },
	{ 8,23,43,40,6,27,5,38,14,16,13,46,28,3,33,22,11,21,41,26,4,25,39,36,12,19,44,2,31,1,34,10,20,9,42,24,7,37,18,15,17,45,30,0,29,35,32 },
	{ 31,27,37,6,40,2,22,38,28,34,25,13,0,21,43,14,32,10,30,18,44,7,41,3,8,39,29,35,16,4,1,26,36,15,33,11,23,19,45,24,12,9,46,20,42,17,5 },
	{ 30,13,31,12,40,14,42,28,41,15,43,29,22,37,5,23,36,4,38,6,20,39,7,21,24,45,26,25,44,27,46,8,10,9,11,16,18,17,19,32,0,34,2,33,1,35,3 },
	{ 28,38,8,34,13,7,19,44,23,15,27,32,31,37,17,4,43,39,25,12,18,22,41,3,26,30,36,11,16,46,21,42,1,24,29,9,35,6,40,2,45,14,10,33,20,0,5 },
	{ 18,36,9,40,21,34,31,19,45,8,39,20,43,22,13,44,1,38,11,42,23,12,0,10,24,5,15,46,3,25,4,14,33,2,16,26,7,32,29,17,27,37,6,41,28,35,30 },
	{ 9,39,10,8,38,27,36,25,26,37,24,3,43,1,41,2,42,0,40,19,17,18,16,29,35,15,33,28,34,14,32,12,31,13,30,21,7,20,6,46,4,44,23,5,45,22,11 },
	{ 30,8,29,14,13,23,33,7,36,31,40,28,15,16,12,0,34,37,41,42,17,44,1,20,35,4,38,43,45,18,46,21,2,5,26,39,25,10,9,19,3,22,32,27,6,24,11 },
},
{
	/* Frame 34 */
	{ 38,13,7,25,33,19,43,8,14,20,36,30,34,1,11,29,45,23,39,12,2,24,32,18,46,5,15,17,41,27,35,0,6,28,44,22,42,9,3,21,37,31,4,10,16,40,26 },
	{ 43,39,41,37,42,38,40,36,15,7,13,5,30,22,28,20,14,6,12,4,31,23,29,21,35,45,33,46,34,44,32,11,3,9,1,26,18,24,16,10,2,8,0,27,19,25,17 },
	{ 9,2,44,14,5,11,39,18,29,32,27,16,34,12,23,40,37,1,30,42,6,25,3,45,15,21,8,19,28,33,4,10,38,35,13,22,41,26,17,46,43,7,24,36,0,31,20 },
	{ 20,1,43,5,14,27,35,30,6,19,41,22,45,25,33,29,37,46,17,21,38,10,15,26,2,7,18,8,12,24,0,42,4,16,34,31,39,11,40,23,44,3,32,28,36,9,13 },
	{ 12,1,14,39,32,20,25,6,13,17,15,33,36,8,7,10,16,31,2,37,9,23,11,4,40,42,30,3,28,34,22,27,5,41,44,43,46,19,29,0,35,38,26,21,24,45,18 },
	{ 44,17,15,18,37,38,27,4,43,9,20,10,32,29,3,30,45,46,19,12,39,5,24,6,40,21,11,22,33,34,31,0,13,16,14,36,25,7,26,41,42,23,8,35,1,28,2 },
	{ 39,26,37,9,19,16,2,15,13,34,31,20,43,22,40,27,24,10,17,46,3,44,0,28,35,30,32,21,6,41,4,25,38,11,36,8,18,45,1,29,14,33,12,7,5,42,23 },
	{ 8,43,18,38,1,45,12,22,20,25,42,11,0,13,46,15,4,33,24,10,17,3,14,5,32,7,27,41,16,36,2,31,29,6,35,26,40,9,37,19,39,30,44,28,23,34,21 },
	{ 42,37,24,6,27,4,9,33,45,18,14,0,12,3,38,36,41,7,26,21,8,23,11,46,32,44,35,15,17,29,2,31,39,40,43,20,25,22,10,5,34,16,28,19,30,1,13 },
	{ 46,6,38,30,22,15,7,39,31,23,10,32,2,26,18,41,11,33,3,27,19,40,4,36,28,20,13,45,5,37,29,21,12,44,0,42,24,34,16,9,1,43,25,35,17,8,14 },
	{ 17,11,23,12,16,10,22,45,43,44,42,5,29,3,27,4,28,2,26,37,35,36,34,9,21,15,19,8,20,14,18,41,40,46,1,25,7,31,0,24,6,30,33,39,32,38,13 },
	{ 35,32,34,0,20,2,22,1,21,3,23,37,27,39,36,26,38,4,6,24,5,7,25,11,31,41,10,30,40,43,8,28,42,9,29,15,45,14,44,16,12,18,46,17,13,19,33 },
},
{
	/* Frame 35 */
	{ 31,33,4,46,11,17,30,40,5,35,10,16,19,41,12,34,7,25,18,36,13,43,6,24,27,37,0,42,15,21,26,44,1,39,14,20,23,45,8,38,3,29,22,32,9,2,28 },
	{ 35,36,27,22,8,16,39,3,21,12,41,30,7,25,11,45,0,15,42,28,18,4,33,23,9,46,17,34,37,26,13,40,31,38,2,20,44,1,6,24,10,29,19,5,32,14,43 },
	{ 30,45,35,17,8,6,15,34,43,16,29,23,14,32,42,5,28,22,27,33,40,4,13,3,26,41,39,21,12,2,11,38,20,25,19,10,36,46,1,24,18,31,37,44,0,9,7 },
	{ 38,46,34,42,39,35,43,6,14,18,26,23,31,2,10,7,15,19,27,22,30,3,11,32,40,36,44,33,41,37,45,16,24,20,28,0,8,4,12,17,25,21,29,1,9,5,13 },
	{ 39,25,33,14,44,18,20,9,31,2,4,41,23,37,10,34,28,16,7,42,27,12,0,45,19,21,38,24,32,15,3,46,5,8,30,35,29,17,40,22,36,11,13,1,6,43,26 },
	{ 15,8,18,5,34,30,37,13,23,42,16,45,27,32,28,6,21,40,14,25,3,4,35,11,12,22,43,1,38,26,33,9,19,46,20,41,31,36,24,2,17,44,10,29,7,0,39 },
	{ 36,9,40,21,15,46,2,43,8,33,20,14,39,11,42,22,32,29,17,38,10,35,23,28,16,5,34,30,19,25,4,45,31,18,24,13,44,1,27,7,12,37,0,41,26,6,3 },
	{ 22,45,18,23,44,19,40,6,2,41,7,3,30,26,31,27,38,14,34,10,39,15,35,11,16,5,17,4,46,0,42,20,1,43,21,24,37,13,25,36,12,32,8,28,33,9,29 },
	{ 28,26,31,38,21,2,7,35,29,11,30,37,18,6,1,46,34,45,10,15,9,43,36,19,22,0,5,44,33,14,8,13,42,41,23,16,4,32,24,12,27,40,39,17,20,3,25 },
	{ 32,15,30,5,16,43,33,14,19,4,25,34,44,7,18,9,24,35,45,6,27,8,21,46,36,11,26,1,20,37,10,23,0,29,38,40,3,22,13,28,39,41,2,31,12,17,42 },
	{ 31,33,20,44,22,39,10,37,17,3,14,32,21,23,26,36,9,2,43,15,13,6,27,8,18,42,1,12,35,7,46,5,24,19,0,41,28,34,30,4,45,25,38,11,16,40,29 },
	{ 22,34,26,46,8,17,37,25,2,14,41,5,13,30,42,19,39,21,33,29,44,10,7,1,9,16,36,23,35,27,40,4,24,3,15,18,38,20,32,12,31,43,6,0,28,45,11 },
},
{
	/* Frame 36 */
	{ 41,7,13,31,46,17,44,10,8,22,43,28,33,15,1,19,38,25,36,6,4,30,35,16,45,3,9,27,42,21,40,14,12,18,24,37,11,5,23,34,29,32,2,0,26,39,20 },
	{ 31,29,19,30,28,18,17,16,41,33,11,3,40,32,10,2,9,1,42,34,8,0,43,35,23,27,21,22,26,20,25,24,15,7,13,5,14,6,12,4,46,38,44,36,39,45,37 },
	{ 9,4,38,30,19,11,33,20,12,35,27,7,36,28,17,40,45,23,15,42,0,25,5,39,31,2,8,21,13,18,10,32,46,37,29,16,41,34,26,6,43,1,24,44,22,14,3 },
	{ 38,40,34,44,39,41,35,45,6,8,2,28,23,25,19,12,7,9,3,29,22,24,18,13,32,46,42,36,33,43,37,0,14,20,10,17,31,4,27,1,15,21,11,16,30,5,26 },
	{ 18,5,23,34,11,12,45,14,3,4,37,22,27,25,44,15,46,2,41,17,36,7,26,33,24,31,29,40,16,42,6,39,21,32,9,30,28,1,43,19,38,20,8,35,10,13,0 },
	{ 14,41,21,38,26,0,7,44,16,43,23,13,2,37,25,46,18,8,15,32,28,39,27,1,10,45,17,34,30,4,3,40,20,19,9,6,33,29,42,22,12,11,36,24,35,31,5 },
	{ 38,12,22,11,16,40,28,36,7,27,35,8,2,30,5,24,32,18,42,15,21,45,23,10,1,39,13,6,26,34,17,41,29,37,31,46,4,9,3,14,20,44,25,33,19,43,0 },
	{ 0,13,38,9,19,30,36,10,17,21,8,35,18,46,7,37,27,33,16,44,20,25,34,29,6,43,26,32,15,45,4,41,24,28,23,42,3,14,5,40,1,12,39,22,2,31,11 },
	{ 4,33,2,37,42,6,35,46,16,39,20,32,18,36,27,22,34,31,17,38,9,21,13,19,26,23,30,8,12,41,11,45,15,24,1,28,40,5,10,44,3,14,43,7,25,0,29 },
	{ 22,4,20,38,36,7,23,5,21,39,37,2,26,0,24,34,32,3,27,1,25,35,33,14,30,12,28,46,44,15,31,13,29,45,10,18,8,16,42,40,11,19,9,17,43,41,6 },
	{ 22,12,17,2,5,33,38,23,44,16,3,26,4,29,14,9,39,45,42,27,36,28,15,18,8,21,6,1,43,37,34,19,40,20,7,30,0,25,10,13,35,41,46,31,32,24,11 },
	{ 40,20,1,29,45,4,24,13,31,10,2,15,38,46,19,41,0,28,9,36,12,17,11,34,42,23,39,26,18,7,32,8,21,37,44,16,5,25,35,30,43,22,3,27,14,6,33 },
},
{
	/* Frame 37 */
	{ 2,20,10,3,21,11,29,35,43,28,34,42,18,6,26,14,19,7,27,15,39,38,46,22,41,30,0,23,40,31,1,9,33,8,32,45,16,4,44,17,5,25,13,37,24,12,36 },
	{ 19,12,41,46,11,21,31,18,45,40,7,10,30,44,9,6,35,16,5,8,39,34,28,17,27,4,33,38,3,29,23,26,37,32,15,2,22,36,1,14,43,24,13,0,42,20,25 },
	{ 23,40,0,31,38,12,42,2,5,14,9,7,20,11,28,37,22,41,17,30,39,25,32,43,19,44,4,27,34,8,46,6,1,10,13,3,16,15,24,33,18,45,21,26,35,29,36 },
	{ 46,19,43,7,10,37,31,33,26,0,20,44,16,38,13,35,9,2,23,18,14,11,36,30,40,5,1,29,25,39,12,42,6,3,22,32,27,15,21,45,17,41,4,34,8,28,24 },
	{ 38,25,14,33,44,18,21,29,24,32,22,19,28,35,46,1,23,41,26,34,5,0,40,30,27,3,4,43,9,31,7,2,37,42,13,8,6,36,11,12,16,39,15,10,45,20,17 },
	{ 9,27,33,12,30,5,19,42,0,22,29,38,11,24,35,14,21,44,7,16,41,2,32,13,31,37,8,26,1,23,46,4,18,43,25,34,15,28,39,10,17,40,3,20,45,6,36 },
	{ 23,21,35,14,40,12,30,38,18,36,17,3,8,27,45,6,32,4,22,28,42,15,41,13,0,39,19,37,24,10,9,20,34,7,33,5,31,29,43,16,2,1,46,26,44,25,11 },
	{ 11,41,7,0,28,43,26,22,32,17,38,12,5,45,3,14,24,20,35,18,36,31,8,1,29,10,40,6,33,16,39,13,42,27,23,15,25,4,44,2,37,30,9,46,21,34,19 },
	{ 44,14,16,13,34,33,28,3,42,41,22,11,21,39,26,4,25,12,19,32,2,31,1,40,10,20,9,38,37,24,7,46,45,18,15,17,35,30,0,29,43,8,23,36,6,27,5 },
	{ 4,7,41,28,34,31,13,16,19,45,1,38,10,25,20,42,23,5,14,32,29,35,30,46,2,17,26,36,8,39,11,6,40,21,43,22,12,15,33,18,44,0,3,24,27,37,9 },
	{ 33,14,36,26,7,19,22,35,28,38,25,21,0,5,15,27,30,2,40,23,45,29,39,8,13,1,42,4,16,10,32,31,37,3,41,6,44,18,9,34,12,24,43,20,46,17,11 },
	{ 28,6,31,20,43,23,25,35,17,46,29,38,30,21,10,22,40,2,32,44,39,36,11,41,3,26,33,18,45,37,8,27,0,19,12,15,4,7,9,42,1,24,34,13,16,14,5 },
},
{
	/* Frame 38 */
	{ 30,7,2,11,34,4,21,13,28,36,26,40,33,6,23,15,38,10,17,35,24,42,20,44,29,37,41,19,1,8,22,14,31,39,46,16,3,25,43,45,5,12,18,0,27,9,32 },
	{ 43,35,41,33,42,34,40,32,29,17,15,3,13,1,30,18,28,16,14,2,12,0,31,19,39,45,37,46,38,44,36,25,21,11,7,9,5,26,22,24,20,10,6,8,4,27,23 },
	{ 9,28,4,16,26,30,6,2,8,33,29,41,17,31,19,32,13,40,1,20,15,11,18,22,12,37,24,0,45,21,14,39,10,35,23,43,36,25,44,5,38,27,34,46,7,42,3 },
	{ 46,5,16,29,37,9,12,6,41,18,44,22,38,11,15,21,43,1,4,25,33,28,36,8,3,7,40,27,35,31,39,10,17,20,42,0,13,24,32,19,45,23,2,14,26,34,30 },
	{ 14,9,7,32,12,26,5,38,43,31,24,22,36,41,10,20,3,8,6,1,45,27,4,18,29,42,35,23,16,15,40,33,21,2,13,46,39,0,30,25,44,37,19,28,11,34,17 },
	{ 8,3,13,38,30,40,16,35,27,45,21,14,4,11,1,46,22,36,28,43,19,33,25,2,12,7,9,34,26,44,20,39,31,41,17,10,0,15,5,42,18,32,24,23,37,29,6 },
	{ 39,20,35,1,29,24,12,7,3,36,23,26,45,30,40,21,16,4,25,46,13,42,8,18,37,22,32,27,14,41,10,17,38,5,34,0,28,43,9,19,6,33,2,15,11,44,31 },
	{ 16,25,37,21,41,28,32,5,18,10,39,23,30,34,7,43,17,45,24,36,1,40,13,4,19,26,38,3,31,6,42,15,44,9,0,12,20,29,33,27,2,46,11,22,14,35,8 },
	{ 22,28,17,42,39,45,0,11,30,19,25,36,2,8,5,16,27,38,44,33,10,7,13,18,24,21,46,35,41,4,15,26,23,29,32,43,6,12,1,20,31,34,40,37,14,3,9 },
	{ 37,29,44,1,43,8,15,18,41,27,13,16,25,34,30,6,11,32,28,45,4,42,9,14,23,38,26,2,21,36,24,35,0,46,7,10,33,19,40,5,12,17,22,39,31,3,20 },
	{ 19,14,44,7,24,37,38,21,8,22,43,1,31,2,32,15,16,45,46,25,4,26,39,9,23,10,40,3,28,33,34,17,12,18,5,27,6,36,11,20,41,42,29,0,30,35,13 },
	{ 33,34,32,2,26,0,24,3,27,1,25,13,12,46,18,45,16,14,19,44,17,15,5,29,39,4,28,38,37,6,30,36,7,31,21,43,41,20,42,40,10,22,8,11,23,9,35 },
},
{
	/* Frame 39 */
	{ 31,8,2,46,5,16,41,28,35,14,27,36,39,10,22,1,13,24,7,18,43,32,21,44,4,30,9,3,15,26,37,17,40,29,34,23,0,12,38,11,33,20,45,25,6,19,42 },
	{ 29,41,36,17,22,34,14,39,9,21,44,2,26,7,1,12,30,42,19,32,24,4,10,23,35,15,28,40,37,16,45,3,27,38,8,20,13,31,43,6,0,25,5,11,18,46,33 },
	{ 45,17,11,38,29,32,46,18,40,4,30,35,12,43,23,1,27,9,2,16,10,28,33,7,41,21,15,34,25,36,42,22,44,0,26,39,8,19,5,31,13,6,20,14,24,37,3 },
	{ 21,32,0,37,5,17,20,33,1,36,4,16,29,40,8,45,13,25,28,41,9,44,12,24,34,2,38,6,19,23,35,3,39,7,18,22,42,10,46,14,27,31,43,11,15,26,30 },
	{ 11,22,0,35,12,43,10,23,32,1,38,13,42,20,18,33,30,39,8,21,19,36,31,40,9,46,16,28,37,26,41,6,17,29,27,44,7,15,24,4,45,2,14,25,5,34,3 },
	{ 46,6,11,20,29,34,41,7,30,21,12,37,40,22,31,0,13,43,36,23,14,1,24,39,42,2,15,16,25,38,45,3,26,17,8,33,44,18,27,4,9,32,19,10,5,28,35 },
	{ 34,1,40,27,7,46,12,45,0,33,26,6,39,5,44,30,32,19,25,38,4,37,31,18,24,11,36,22,29,17,10,43,23,28,16,3,42,9,21,15,2,35,8,41,20,14,13 },
	{ 15,25,4,40,2,43,30,39,9,32,21,19,1,29,10,44,6,16,13,36,27,34,23,5,41,3,14,24,33,20,18,42,31,38,8,11,45,7,0,28,37,26,35,22,46,17,12 },
	{ 44,2,7,20,19,0,5,17,45,34,6,18,31,32,4,11,16,29,35,38,9,30,33,36,10,15,28,27,39,8,13,25,37,42,14,26,23,40,12,3,24,21,43,46,1,22,41 },
	{ 39,27,33,29,14,8,46,30,36,24,3,5,43,23,45,17,6,0,38,18,40,20,15,9,35,31,37,25,10,12,42,26,32,28,7,1,19,41,21,2,4,34,22,44,16,11,13 },
	{ 38,9,5,31,2,41,24,35,20,15,36,19,22,13,0,10,33,6,45,28,17,42,27,30,3,39,8,4,14,37,18,40,25,34,21,46,1,11,23,12,16,43,26,32,7,44,29 },
	{ 24,32,12,6,11,15,0,20,41,39,19,46,23,28,36,9,27,35,31,42,4,17,45,3,7,10,25,33,13,40,38,18,14,1,21,8,26,34,22,29,37,16,44,2,30,43,5 },
},
{
	/* Frame 40 */
	{ 1,43,21,8,5,26,14,12,33,42,9,37,27,39,13,18,32,31,2,41,36,38,24,45,19,30,3,28,40,23,10,7,25,44,46,16,35,29,0,22,11,20,6,4,15,17,34 },
	{ 31,23,29,21,30,22,28,20,41,39,11,37,40,38,10,36,9,7,42,5,8,6,43,4,27,19,26,18,25,17,24,16,33,45,3,46,32,44,2,15,1,13,34,14,0,12,35 },
	{ 9,38,13,18,7,26,15,0,4,8,12,35,41,6,45,14,21,29,34,40,23,44,3,31,11,20,46,16,28,24,22,2,30,33,10,37,17,43,25,39,19,32,27,36,1,42,5 },
	{ 19,6,37,3,33,23,18,7,36,2,32,22,27,14,45,11,41,31,26,15,44,10,40,30,21,38,17,35,5,1,20,39,16,34,4,0,29,46,25,43,13,9,28,24,42,12,8 },
	{ 26,23,38,15,8,5,28,41,10,32,7,30,25,34,16,37,12,27,18,39,14,9,0,43,29,44,20,33,2,31,46,22,35,17,13,4,19,40,11,6,1,42,24,45,21,36,3 },
	{ 20,11,26,37,0,25,10,19,36,46,9,24,7,18,45,35,8,17,6,31,44,34,5,16,15,30,33,43,4,29,14,23,32,42,13,28,3,22,41,39,12,21,2,27,40,38,1 },
	{ 38,2,30,5,24,40,18,34,15,21,37,0,12,22,11,16,32,28,44,7,27,43,31,4,9,39,3,14,20,36,25,41,19,35,23,46,10,1,13,6,26,42,17,33,29,45,8 },
	{ 20,38,7,37,17,2,32,1,44,13,14,8,26,25,43,21,6,36,5,18,0,35,12,30,29,27,41,24,42,11,22,4,39,19,16,34,3,33,31,45,28,46,15,40,9,10,23 },
	{ 6,19,8,23,12,25,34,29,38,18,40,22,11,44,24,15,35,28,1,39,5,41,10,45,14,27,0,31,4,17,42,21,46,26,32,30,3,36,16,7,43,20,9,13,33,2,37 },
	{ 29,15,9,43,22,37,20,2,0,46,31,40,17,11,5,39,26,33,24,14,12,42,19,36,21,7,1,35,30,45,28,10,8,38,23,32,25,3,13,18,41,16,6,4,34,27,44 },
	{ 9,30,34,12,27,39,25,40,2,28,45,7,5,22,42,0,19,17,36,10,20,33,15,13,26,38,8,31,35,29,44,6,24,41,3,1,18,46,4,23,43,21,32,14,16,37,11 },
	{ 38,26,3,31,42,18,14,23,29,4,0,21,41,45,9,39,2,30,7,43,46,22,11,5,32,36,25,12,8,17,34,6,27,10,19,15,33,28,37,24,1,13,20,40,16,44,35 },
},
{
	/* Frame 41 */
	{ 19,25,39,3,45,9,18,24,38,2,44,8,23,29,43,7,33,13,22,28,42,6,32,12,27,17,11,37,1,26,16,46,10,36,0,31,21,35,15,41,5,30,20,34,14,40,4 },
	{ 14,24,5,34,41,29,26,7,36,43,31,8,20,38,45,10,22,1,25,4,3,40,27,6,16,13,42,33,21,18,15,44,35,23,0,28,46,37,2,30,9,39,17,12,11,32,19 },
	{ 31,8,21,38,44,3,22,9,24,39,45,10,23,4,25,46,32,11,26,5,16,33,6,27,12,17,34,40,7,18,13,28,35,41,14,19,0,29,42,36,15,30,1,20,43,37,2 },
	{ 17,3,41,0,27,24,10,21,6,45,4,28,35,30,32,18,1,42,25,38,11,36,8,7,5,23,29,14,33,12,19,16,43,2,40,39,26,37,9,20,46,22,44,15,13,34,31 },
	{ 17,39,2,36,23,35,5,32,45,8,11,41,30,29,14,16,3,37,0,22,21,33,6,9,27,24,46,12,15,42,19,1,38,20,7,34,4,26,44,25,10,13,40,31,43,28,18 },
	{ 20,31,14,3,9,37,46,22,28,17,0,11,39,45,32,30,19,25,2,8,5,34,40,16,27,10,7,13,33,42,18,24,21,4,15,35,41,36,26,23,29,6,12,1,43,38,44 },
	{ 41,11,13,31,19,34,20,6,26,43,28,39,15,36,3,0,46,23,44,10,8,30,18,35,17,32,7,4,42,25,40,14,37,12,1,22,45,21,9,27,29,38,16,33,2,5,24 },
	{ 46,40,41,26,14,28,8,27,15,29,9,38,32,39,33,22,6,16,0,23,7,17,1,42,44,43,45,30,10,24,12,31,11,25,13,34,36,35,37,18,2,20,4,19,3,21,5 },
	{ 10,46,4,28,41,2,45,32,31,20,39,24,23,14,36,43,16,9,34,13,6,26,1,5,29,40,18,11,21,38,25,3,44,33,30,37,42,17,8,22,15,27,0,35,12,7,19 },
	{ 44,21,8,35,13,46,23,10,15,4,41,16,29,6,43,18,32,31,37,20,1,34,12,39,24,3,14,26,40,17,45,28,9,42,19,22,36,11,0,5,38,25,2,7,27,33,30 },
	{ 7,41,4,6,40,21,42,23,20,43,22,37,1,39,3,36,0,38,2,17,19,16,18,31,33,13,35,30,32,12,34,14,29,15,28,27,45,9,26,44,8,46,10,25,11,24,5 },
	{ 3,36,25,39,30,9,14,45,20,34,23,4,7,40,29,43,18,13,2,33,24,38,27,8,11,44,17,22,1,6,37,28,42,31,12,15,32,21,35,26,5,10,41,16,46,19,0 },
},
{
	/* Frame 42 */
	{ 7,28,36,19,35,9,2,21,45,30,38,4,11,16,32,23,13,6,25,41,18,34,8,15,20,44,27,43,1,10,29,37,22,46,12,3,24,40,31,39,5,14,17,33,26,42,0 },
	{ 13,14,36,29,7,20,44,23,11,33,24,34,27,41,18,42,0,39,30,12,5,6,21,9,10,32,25,3,16,40,19,15,37,28,38,31,45,22,46,4,35,26,8,43,1,2,17 },
	{ 41,12,17,11,22,28,44,0,39,27,43,14,33,2,25,5,30,46,18,36,8,21,35,16,10,7,40,13,1,38,26,42,23,29,45,24,4,15,32,3,9,20,34,31,19,37,6 },
	{ 1,18,17,29,14,12,21,41,6,4,33,10,24,2,46,16,44,15,38,13,36,31,7,42,5,23,11,34,8,27,3,0,45,19,39,28,37,30,43,20,40,22,35,9,32,26,25 },
	{ 13,26,30,8,12,27,31,25,29,11,15,24,28,10,14,41,40,39,43,37,38,42,36,18,22,16,20,19,23,17,21,3,7,1,5,2,6,0,4,45,44,35,33,34,32,46,9 },
	{ 36,17,3,22,45,42,31,12,39,1,20,6,40,29,15,26,37,34,23,4,43,13,24,10,32,21,7,18,41,46,27,8,35,5,16,2,44,25,11,30,33,38,19,0,9,28,14 },
	{ 42,2,35,14,36,7,0,33,29,5,43,18,34,15,6,45,16,32,9,4,19,26,22,44,17,8,41,20,13,27,23,30,24,40,21,46,12,39,10,3,31,37,25,1,28,38,11 },
	{ 10,29,36,22,3,41,31,38,0,43,28,13,2,17,40,30,15,33,19,42,12,35,16,5,14,25,32,18,7,45,27,34,4,24,9,6,21,44,26,11,37,23,46,8,39,20,1 },
	{ 34,0,12,7,10,5,46,28,18,41,21,25,32,44,3,30,39,42,37,8,23,15,16,13,6,26,35,1,29,19,40,11,4,45,2,31,38,20,24,33,14,17,43,36,9,22,27 },
	{ 13,31,44,24,11,8,36,20,7,0,34,18,33,17,28,15,12,42,26,41,25,4,38,22,37,21,2,1,35,19,46,30,45,29,10,9,43,27,40,6,5,39,23,32,16,3,14 },
	{ 19,5,25,14,18,4,24,37,46,36,31,11,21,1,30,10,20,0,43,33,42,32,7,27,13,17,6,26,12,16,39,45,38,44,23,3,29,9,22,2,28,8,35,41,34,40,15 },
	{ 30,40,42,9,29,11,31,41,43,8,28,14,18,44,46,13,17,15,19,45,12,16,2,22,32,34,1,21,3,23,33,35,0,20,6,26,36,38,5,25,7,27,37,39,4,24,10 },
},
{
	/* Frame 43 */
	{ 25,19,44,13,38,7,24,18,33,12,6,21,27,32,1,46,15,20,26,41,0,35,14,29,23,40,9,34,3,28,22,37,8,43,2,17,31,36,5,42,11,16,30,45,4,39,10 },
	{ 36,34,13,30,6,0,15,17,37,3,12,32,14,9,16,21,2,44,11,19,33,46,8,39,20,25,45,10,5,18,23,27,40,38,24,29,42,4,35,22,26,31,41,7,1,28,43 },
	{ 14,23,1,24,42,37,15,26,0,17,43,44,2,27,9,16,38,45,3,18,8,29,39,32,10,19,5,28,46,33,11,30,4,21,40,6,31,13,20,34,41,7,22,12,25,35,36 },
	{ 35,43,33,41,34,42,32,40,19,27,17,25,18,26,16,24,3,11,1,9,2,10,0,8,39,38,46,37,45,36,44,21,29,7,15,20,28,6,14,5,13,22,30,4,12,23,31 },
	{ 38,3,17,6,33,20,23,27,45,24,46,30,40,13,43,14,2,37,16,19,32,5,35,22,26,44,9,10,12,15,29,36,1,39,18,4,34,7,21,8,11,25,31,41,28,42,0 },
	{ 23,20,26,9,36,42,6,41,17,31,28,3,44,0,14,35,25,22,5,11,38,8,37,43,19,16,30,13,32,46,2,45,21,27,24,7,40,4,10,39,29,18,1,15,34,12,33 },
	{ 16,42,3,41,1,19,17,43,2,40,0,22,20,7,39,5,37,23,21,6,38,4,36,24,10,9,35,26,33,25,11,8,34,27,32,28,14,46,13,45,30,29,15,12,44,31,18 },
	{ 34,32,35,33,30,2,28,0,31,3,29,1,42,40,43,41,18,10,16,8,19,11,17,9,38,36,39,37,26,6,24,4,27,7,25,5,46,44,45,22,14,20,12,23,15,21,13 },
	{ 6,0,4,3,7,1,5,18,22,16,20,19,23,17,21,34,32,46,35,33,44,45,25,29,10,14,24,28,11,15,8,12,26,30,9,13,27,31,38,42,36,39,43,37,40,41,2 },
	{ 5,14,17,44,26,35,8,11,28,37,31,38,13,2,25,32,22,43,4,7,16,45,19,46,1,10,21,40,30,39,12,15,24,33,27,34,9,6,29,36,18,0,3,20,41,23,42 },
	{ 29,35,10,41,4,43,18,37,12,34,26,24,20,42,7,19,36,1,13,15,27,44,25,21,6,0,39,14,33,45,8,22,16,38,3,30,32,28,9,46,11,23,40,5,17,2,31 },
	{ 43,37,22,3,24,13,42,36,27,2,29,12,39,33,26,15,28,9,38,32,31,14,17,8,35,45,30,11,16,5,34,44,19,10,21,4,41,18,7,20,1,46,40,23,6,25,0 },
},
{
	/* Frame 44 */
	{ 1,26,35,25,44,7,12,31,42,16,41,10,9,22,21,36,15,0,19,34,24,33,6,5,30,39,29,40,3,8,27,46,20,45,14,13,18,43,17,32,11,4,23,38,28,37,2 },
	{ 11,9,43,33,2,0,15,21,12,29,6,36,40,18,42,16,3,26,1,24,35,13,22,46,45,7,30,4,39,41,19,10,17,8,27,32,25,34,23,14,20,44,31,5,28,38,37 },
	{ 41,10,23,46,29,36,1,26,6,12,43,24,33,20,45,31,38,3,9,5,14,19,35,22,28,37,17,40,11,7,13,42,0,27,30,39,2,25,32,21,44,15,18,34,8,4,16 },
	{ 35,33,34,32,46,45,44,3,29,1,15,2,28,0,14,18,13,16,30,19,12,17,31,43,39,41,42,38,40,37,36,21,11,7,9,20,10,6,8,5,26,22,24,4,27,23,25 },
	{ 8,40,27,9,41,11,43,24,10,42,25,30,36,12,38,31,37,13,39,15,28,14,29,0,32,2,34,1,33,3,35,16,18,17,19,4,6,44,5,7,45,20,22,21,46,23,26 },
	{ 2,33,21,42,30,8,11,36,16,39,19,5,14,45,25,34,22,0,3,40,28,43,31,9,6,37,17,46,26,12,15,32,20,35,23,1,10,41,29,38,18,4,7,44,24,27,13 },
	{ 43,25,16,42,24,0,8,34,1,9,35,21,29,20,28,4,36,12,44,5,37,13,45,11,19,10,18,27,32,2,40,26,33,3,41,15,23,14,46,22,31,6,38,30,7,39,17 },
	{ 6,29,44,18,15,33,27,42,8,39,28,5,14,17,32,26,3,41,23,38,4,16,13,2,25,40,22,11,37,31,46,12,35,24,1,10,21,36,30,7,45,19,34,0,43,20,9 },
	{ 34,14,42,7,35,15,43,22,30,23,31,38,25,46,0,39,24,1,8,16,9,17,29,4,32,28,5,33,12,40,20,13,41,21,2,36,10,3,37,11,44,18,26,45,19,27,6 },
	{ 28,44,23,39,8,3,25,41,30,46,5,10,16,32,27,43,12,7,29,45,18,34,9,14,20,36,31,0,11,17,33,22,38,13,2,24,40,19,35,4,15,21,37,26,42,1,6 },
	{ 24,14,19,20,33,31,45,34,25,46,18,21,0,30,11,12,7,35,40,36,1,10,13,16,6,27,28,41,23,37,42,17,38,26,29,8,22,3,4,15,43,32,39,44,9,2,5 },
	{ 1,31,43,20,36,15,4,22,34,29,41,6,13,19,39,24,32,11,0,26,46,17,37,2,9,23,35,28,44,7,12,30,42,21,33,14,5,27,16,40,3,8,18,38,25,45,10 },
},
{
	/* Frame 45 */
	{ 41,33,40,32,29,9,21,1,28,8,20,0,45,26,37,44,27,36,19,13,5,18,12,4,35,30,10,34,31,11,23,3,43,22,2,42,39,14,38,15,25,7,17,24,6,16,46 },
	{ 12,3,23,40,14,16,5,42,33,29,18,7,36,35,0,20,27,38,45,2,22,9,17,4,11,31,32,6,24,13,34,41,21,26,15,44,43,8,28,19,46,37,10,30,1,39,25 },
	{ 21,44,18,35,4,15,16,33,31,38,13,10,29,36,26,8,7,24,45,19,42,5,2,17,40,22,39,0,11,20,37,27,34,9,14,25,32,30,43,12,3,28,41,23,46,1,6 },
	{ 43,0,18,9,38,10,36,25,20,22,5,35,14,12,1,40,2,17,39,11,24,27,6,4,45,15,32,29,31,41,3,42,16,19,8,26,37,7,46,21,44,23,33,28,34,30,13 },
	{ 2,11,39,14,22,35,0,9,37,12,20,33,29,19,46,26,3,31,42,6,15,17,44,24,1,40,4,13,10,38,18,23,34,30,43,7,8,36,16,45,25,21,32,28,41,5,27 },
	{ 21,3,45,16,6,9,32,27,12,37,30,1,46,19,4,43,22,25,15,38,28,10,35,44,17,7,41,20,2,13,36,31,8,33,26,5,42,23,0,18,29,11,34,24,14,39,40 },
	{ 35,15,3,27,29,40,16,8,30,43,18,45,11,36,13,4,46,25,38,14,6,26,28,41,21,32,9,0,42,23,34,10,37,2,5,24,39,17,7,31,19,44,20,33,12,1,22 },
	{ 11,13,2,4,27,42,21,44,18,35,28,37,7,9,14,0,31,38,25,40,22,16,33,3,5,10,12,19,34,29,36,26,43,20,45,15,1,6,8,23,46,17,32,30,39,24,41 },
	{ 10,21,38,15,16,2,9,7,12,30,1,41,27,4,44,18,33,29,23,42,36,24,39,14,17,34,11,20,6,13,3,8,26,5,45,31,0,40,22,43,37,25,19,46,32,28,35 },
	{ 18,46,6,42,2,23,19,7,43,3,22,26,14,36,10,32,31,27,15,37,11,33,30,20,16,44,4,40,0,21,17,45,5,41,1,28,38,24,34,12,8,29,39,25,35,13,9 },
	{ 35,12,42,20,45,26,19,33,30,40,23,9,38,17,24,13,21,28,27,36,2,11,31,41,6,15,39,0,46,25,4,34,29,43,37,3,44,10,18,7,32,14,22,1,8,16,5 },
	{ 1,15,28,7,20,40,26,32,25,18,46,17,45,38,31,37,8,23,43,0,35,14,13,6,5,11,24,3,16,44,30,36,29,22,42,21,41,34,27,33,12,19,4,39,10,9,2 },
},
{
	/* Frame 46 */
	{ 30,44,23,5,41,32,17,8,14,7,28,46,26,34,19,43,45,36,12,33,9,24,0,38,29,20,35,11,2,37,31,13,22,4,40,25,1,16,39,15,21,6,10,27,3,18,42 },
	{ 15,33,28,34,31,17,45,18,46,0,25,39,26,8,43,5,6,13,14,32,3,16,44,19,11,37,24,38,27,21,41,22,42,4,29,35,30,12,1,2,9,10,36,7,20,40,23 },
	{ 11,38,23,43,2,32,9,36,21,41,17,26,39,14,3,46,8,37,12,40,1,44,27,15,18,6,13,0,45,4,30,34,19,7,28,24,5,31,35,10,22,42,29,33,25,20,16 },
	{ 6,40,4,43,15,38,29,36,31,18,0,3,25,32,10,35,7,21,42,23,39,28,30,13,17,2,45,24,27,34,9,20,22,41,5,14,12,37,16,46,19,44,1,26,8,33,11 },
	{ 31,19,23,10,14,2,6,26,30,18,22,11,15,3,7,44,42,36,34,45,43,37,35,17,21,8,12,0,4,24,28,16,20,9,13,1,5,25,29,40,32,46,38,41,33,39,27 },
	{ 0,15,5,42,26,32,16,31,37,21,2,12,7,9,34,18,44,28,39,23,41,25,14,4,11,1,46,30,36,20,43,27,33,17,6,8,3,13,38,22,40,24,35,19,45,29,10 },
	{ 42,12,41,10,36,9,4,33,19,1,43,28,40,11,8,39,20,32,7,0,29,30,24,38,21,6,35,16,3,31,25,26,22,34,17,46,2,45,14,13,27,37,23,5,18,44,15 },
	{ 34,20,1,23,39,4,18,7,40,10,29,45,46,24,13,27,35,0,22,3,36,6,17,41,42,28,9,31,12,26,15,32,2,21,37,38,16,5,19,43,8,30,11,44,14,25,33 },
	{ 22,29,33,42,19,24,36,14,35,17,11,38,20,2,9,7,12,30,41,5,27,44,0,43,18,25,37,46,23,28,32,10,39,21,15,34,16,6,13,3,8,26,45,1,31,40,4 },
	{ 39,6,33,0,29,42,11,40,7,36,1,28,10,41,8,37,4,19,46,15,44,9,5,18,14,45,12,27,23,17,34,13,26,22,16,35,2,31,25,21,38,3,32,30,24,43,20 },
	{ 17,12,46,29,2,33,27,6,24,37,23,9,20,43,40,13,18,44,3,30,0,34,7,25,4,38,21,10,41,19,14,16,45,31,1,28,35,32,5,26,39,36,11,22,8,42,15 },
	{ 28,38,36,7,31,5,29,39,37,6,30,20,8,42,40,23,11,21,9,43,41,22,10,0,24,34,32,3,27,1,25,35,33,2,26,16,12,46,44,19,15,17,13,45,18,14,4 },
},
{
	/* Frame 47 */
	{ 31,4,24,40,18,34,15,28,37,8,2,17,33,12,22,38,26,42,1,45,6,21,10,25,41,19,35,30,46,5,9,3,14,29,36,23,39,27,43,16,32,13,7,20,11,0,44 },
	{ 36,40,45,6,42,18,29,37,9,44,31,11,46,35,28,21,8,13,1,30,25,10,15,34,39,27,20,12,0,5,24,23,17,14,3,38,26,32,4,41,22,16,2,7,43,19,33 },
	{ 23,42,4,2,20,41,18,39,1,11,17,44,31,34,8,14,28,33,26,43,13,3,25,36,19,46,0,6,16,45,22,35,5,15,21,40,27,38,12,10,24,37,30,9,7,29,32 },
	{ 33,1,35,3,32,0,34,2,16,18,17,19,41,9,43,11,40,8,42,10,24,26,25,27,39,7,20,38,6,21,22,36,4,23,37,5,15,28,46,14,29,30,44,12,31,45,13 },
	{ 37,17,44,24,5,12,32,20,39,19,46,26,7,14,34,22,43,1,8,36,16,41,29,4,3,10,38,18,31,6,15,45,25,0,13,33,21,40,28,27,2,11,35,23,42,30,9 },
	{ 36,14,19,24,1,42,35,15,6,25,16,34,41,30,7,12,17,40,33,31,22,13,4,32,10,23,28,5,46,39,11,2,29,20,38,45,26,3,8,21,44,37,27,18,9,0,43 },
	{ 20,42,13,35,5,29,21,43,12,34,4,24,16,9,45,1,37,25,17,8,44,0,36,22,14,7,41,30,33,23,15,6,40,31,32,18,10,46,3,39,26,19,11,2,38,27,28 },
	{ 7,9,14,0,19,38,21,40,26,28,33,11,13,2,4,23,42,25,44,30,35,16,37,15,1,6,8,27,46,29,32,18,39,20,41,3,5,10,12,31,34,17,36,22,43,24,45 },
	{ 6,41,45,3,7,40,44,34,38,8,12,35,39,9,13,18,30,19,31,24,20,25,21,10,14,33,37,11,15,32,36,42,46,0,4,43,1,5,26,22,27,23,16,28,17,29,2 },
	{ 26,2,32,35,24,0,27,3,33,34,25,1,22,10,40,43,20,8,23,11,41,42,21,9,30,6,36,39,28,4,31,7,37,38,29,5,18,14,44,16,12,19,15,45,46,17,13 },
	{ 40,7,16,29,27,36,3,22,33,25,13,42,18,15,9,38,4,35,44,11,30,0,21,28,26,37,41,6,17,46,24,12,43,2,23,32,8,39,5,19,14,1,20,34,45,10,31 },
	{ 37,42,24,1,14,23,41,36,13,0,31,22,40,35,12,21,30,7,34,29,20,11,6,33,46,28,5,10,19,45,32,9,4,27,18,44,39,8,17,26,3,43,38,25,16,15,2 },
},
{
	/* Frame 48 */
	{ 38,45,21,24,34,8,17,43,7,44,46,3,33,16,42,6,31,4,15,2,27,32,11,41,30,5,28,14,23,12,26,1,10,19,40,37,29,39,22,13,20,0,25,35,18,9,36 },
	{ 11,9,21,43,39,36,6,19,44,17,14,32,31,34,28,40,42,22,37,26,7,24,4,45,15,12,33,2,29,0,41,10,23,8,20,27,38,25,5,46,18,13,16,3,1,30,35 },
	{ 29,0,43,20,32,15,19,41,23,13,24,21,14,10,40,7,12,39,25,5,16,37,11,6,2,38,9,34,4,17,36,26,30,45,3,8,35,28,46,1,42,27,33,31,44,18,22 },
	{ 7,20,6,21,32,22,34,4,33,23,35,5,15,28,14,29,40,30,42,12,41,31,43,13,39,16,18,38,17,19,0,36,2,1,37,3,24,26,46,25,27,8,44,10,9,45,11 },
	{ 41,1,33,25,17,8,40,0,32,24,16,13,39,5,29,21,46,12,38,4,28,20,3,35,27,19,10,42,2,34,26,18,11,43,7,45,31,37,23,14,6,44,30,36,22,15,9 },
	{ 20,7,30,45,35,8,25,6,23,44,34,1,24,11,22,37,0,17,10,27,36,46,13,16,3,26,41,39,12,29,2,19,40,38,5,28,15,18,33,43,4,21,14,31,32,42,9 },
	{ 43,23,20,42,22,4,6,40,5,7,41,17,19,16,18,0,36,2,38,1,37,3,39,15,29,14,28,31,32,12,34,30,33,13,35,11,25,10,46,24,27,8,44,26,9,45,21 },
	{ 46,20,5,31,43,0,26,11,44,6,29,41,34,24,9,19,4,30,15,32,10,17,45,38,28,13,23,35,8,18,3,36,14,21,33,42,16,1,27,39,12,22,7,40,2,25,37 },
	{ 26,45,15,27,44,46,12,24,13,25,30,2,33,31,3,32,34,28,0,35,29,1,6,18,37,7,19,36,38,4,16,39,5,17,22,10,41,23,11,40,42,20,8,43,21,9,14 },
	{ 39,25,8,30,15,33,38,28,9,19,14,32,43,29,12,18,3,37,42,16,13,23,2,36,17,0,22,7,41,46,20,1,27,6,40,35,21,4,26,11,45,34,24,5,31,10,44 },
	{ 7,8,14,1,3,38,20,10,29,34,31,24,36,43,22,17,45,19,32,4,26,41,13,15,0,6,9,11,46,28,2,39,21,42,23,16,44,35,30,25,37,27,40,12,18,33,5 },
	{ 3,29,37,26,44,21,43,18,24,32,31,39,16,46,23,9,14,34,5,2,12,11,45,0,7,25,33,30,40,17,22,28,36,27,35,20,42,19,13,10,38,1,6,8,15,41,4 },
},
{
	/* Frame 49 */
	{ 17,42,10,33,1,27,16,43,11,32,0,26,21,46,14,37,5,31,20,15,36,4,30,25,34,2,41,9,19,24,35,3,40,8,18,29,38,6,45,13,23,28,39,7,44,12,22 },
	{ 24,22,45,0,35,14,25,23,32,1,38,15,20,18,33,12,39,10,21,19,36,13,42,11,16,30,37,8,43,6,17,31,40,9,46,7,28,26,41,4,2,29,27,44,5,34,3 },
	{ 44,2,31,20,9,38,43,3,14,21,28,42,37,18,15,0,29,36,41,19,26,1,12,35,40,6,27,16,13,34,7,10,17,24,46,33,22,11,4,25,32,45,23,30,5,8,39 },
	{ 2,32,27,20,38,12,35,22,26,17,45,34,9,23,15,16,44,5,8,19,14,11,4,41,29,18,10,37,40,1,28,46,7,43,36,30,0,25,6,42,3,31,33,21,24,39,13 },
	{ 17,14,26,5,41,39,42,31,2,44,33,20,25,36,19,28,9,7,10,12,1,35,22,27,4,40,38,16,15,32,21,24,43,30,3,45,46,8,6,37,18,29,0,34,23,11,13 },
	{ 37,11,14,29,26,38,9,12,24,36,43,15,27,22,41,13,2,25,20,42,0,23,40,45,3,6,21,18,46,1,4,16,44,35,7,19,30,33,5,10,17,28,34,39,8,31,32 },
	{ 43,23,45,17,2,4,34,18,40,20,15,9,39,27,33,29,10,12,42,30,36,24,3,5,19,41,21,6,0,38,22,44,16,11,13,35,31,37,25,14,8,46,26,32,28,7,1 },
	{ 9,45,11,8,44,10,46,24,26,25,27,33,1,35,3,32,0,34,2,16,18,17,19,41,30,43,13,40,31,42,12,14,28,15,29,22,37,5,23,36,4,38,6,20,39,7,21 },
	{ 40,32,42,34,41,33,43,35,15,16,28,18,14,17,29,19,30,0,12,2,31,1,13,3,39,46,38,44,36,45,37,24,7,26,20,25,6,27,21,8,22,10,4,9,23,11,5 },
	{ 21,38,11,2,32,29,7,10,37,1,15,6,43,36,9,0,18,14,42,5,8,26,19,13,4,41,27,46,16,12,35,40,23,24,17,45,34,31,22,20,25,39,44,3,30,33,28 },
	{ 8,38,26,37,24,11,9,39,27,36,25,2,42,0,40,18,16,3,43,1,41,19,17,28,34,14,32,13,30,29,35,15,33,12,31,20,6,46,5,45,22,21,7,4,44,23,10 },
	{ 30,35,29,4,38,23,43,45,46,31,2,28,5,16,39,10,9,3,32,17,6,11,20,8,14,13,33,7,18,36,21,40,15,26,12,25,0,34,19,37,41,22,42,27,44,24,1 },
},
{
	/* Frame 50 */
	{ 42,5,15,17,37,27,0,6,28,40,22,38,9,3,21,33,31,43,4,10,16,36,26,34,13,7,25,45,19,39,8,14,20,32,30,46,1,11,29,41,23,35,12,2,24,44,18 },
	{ 30,28,42,14,40,12,31,29,43,15,41,13,22,20,38,6,36,4,23,21,39,7,37,5,26,24,46,10,44,8,27,25,11,45,9,18,16,34,2,32,0,19,17,35,3,33,1 },
	{ 46,26,22,41,35,13,0,31,36,7,24,43,14,2,44,9,20,32,18,29,39,5,11,23,40,34,12,16,27,6,25,42,1,30,37,8,21,15,3,45,38,4,10,33,19,28,17 },
	{ 19,29,20,38,27,22,28,46,1,30,23,9,0,5,31,3,8,33,13,4,11,2,41,32,12,37,16,10,35,40,7,45,36,24,17,43,34,15,6,44,18,25,42,21,14,39,26 },
	{ 40,5,42,3,36,29,34,27,41,21,43,19,37,0,12,35,14,26,24,20,6,18,1,13,15,32,44,25,46,7,17,38,31,33,45,8,10,23,4,16,39,2,30,28,9,11,22 },
	{ 19,40,7,45,16,42,4,29,18,9,6,31,44,11,33,28,46,8,25,35,30,13,10,27,32,15,37,24,34,12,21,39,26,1,14,23,36,3,41,20,38,0,17,43,22,5,2 },
	{ 19,44,17,46,37,6,4,11,22,9,20,43,31,32,29,34,45,14,12,7,26,5,24,39,23,40,21,42,33,2,0,15,18,13,16,27,36,25,38,41,10,8,3,30,1,28,35 },
	{ 14,5,7,43,10,1,36,18,31,29,32,6,11,25,37,2,39,30,44,28,33,23,21,40,24,3,38,17,45,12,22,34,20,41,8,27,16,13,46,15,35,4,9,42,26,0,19 },
	{ 7,18,6,46,19,22,2,42,23,3,43,15,26,14,27,32,30,36,10,33,31,37,11,16,20,17,21,0,40,4,44,1,41,5,45,39,24,28,38,25,29,8,34,12,9,35,13 },
	{ 8,4,0,28,24,20,16,13,9,5,1,29,25,21,17,44,34,36,43,45,35,37,42,6,2,30,26,22,18,15,11,7,3,31,27,23,19,14,10,38,40,32,39,41,33,46,12 },
	{ 16,10,22,44,42,13,17,11,23,45,43,4,28,2,26,36,34,5,29,3,27,37,35,8,20,14,18,40,46,9,21,15,19,41,0,24,6,30,32,38,1,25,7,31,33,39,12 },
	{ 41,10,40,43,20,8,22,42,21,9,23,15,27,45,14,26,44,12,24,46,13,25,33,31,35,32,30,34,0,2,28,1,3,29,37,39,36,38,4,16,6,18,5,17,7,19,11 },
},
{
	/* Frame 51 */
	{ 27,45,0,38,15,21,26,32,1,14,20,23,33,8,46,3,29,22,40,9,35,2,28,31,41,4,34,11,17,30,36,5,43,10,16,19,37,12,42,7,25,18,44,13,39,6,24 },
	{ 28,3,16,46,41,27,37,19,34,14,9,5,44,20,42,25,6,31,33,23,12,10,39,1,40,26,36,29,2,17,8,4,18,35,15,24,7,30,32,45,21,43,38,0,22,13,11 },
	{ 22,15,4,29,43,32,41,23,26,5,12,40,2,27,20,13,38,3,10,21,24,39,46,37,18,11,0,25,36,45,19,30,1,8,44,6,31,16,9,34,7,14,17,28,35,42,33 },
	{ 32,37,28,17,9,42,14,2,27,40,45,0,25,5,39,18,10,22,36,16,8,21,13,35,26,7,30,44,33,24,4,29,38,43,23,15,3,41,20,12,1,46,34,6,31,19,11 },
	{ 39,29,33,10,44,22,16,13,27,6,0,41,19,37,14,34,24,20,3,42,31,8,4,45,23,17,38,28,32,11,7,46,1,12,26,35,25,21,40,18,36,15,9,5,2,43,30 },
	{ 14,40,13,26,25,37,34,7,28,19,8,44,22,21,2,38,1,31,41,12,11,24,35,6,32,5,18,17,45,42,15,20,27,39,0,36,30,29,10,46,9,23,33,4,3,16,43 },
	{ 16,46,33,11,26,4,29,32,10,19,13,28,34,41,7,18,12,21,35,40,6,31,1,20,42,37,15,30,0,25,43,36,14,23,9,24,38,45,3,22,8,17,39,44,2,27,5 },
	{ 1,43,5,0,42,4,46,16,20,17,21,33,9,37,13,32,8,36,12,24,28,25,29,41,22,45,3,40,23,44,2,6,18,7,19,30,35,11,31,34,10,38,14,26,39,15,27 },
	{ 1,28,41,46,26,23,34,31,16,45,4,10,38,15,9,21,32,2,43,7,24,36,12,19,27,22,35,0,29,40,5,11,39,30,17,44,20,33,3,14,8,37,13,18,42,6,25 },
	{ 33,13,4,31,18,41,38,12,17,30,3,46,39,29,16,11,2,36,28,1,10,23,44,37,9,0,27,22,45,34,8,21,26,7,42,35,25,20,15,6,32,43,24,5,14,19,40 },
	{ 35,15,32,5,23,38,27,36,16,41,2,30,20,45,7,11,8,19,42,14,33,12,22,26,37,25,3,0,29,34,6,4,9,39,18,43,17,40,13,31,46,21,44,24,10,1,28 },
	{ 22,9,26,36,35,17,25,40,4,3,15,38,30,32,19,12,21,43,29,6,0,45,11,34,16,46,23,8,27,37,2,14,24,41,5,18,13,20,42,39,31,33,44,10,28,7,1 },
},
{
	/* Frame 52 */
	{ 37,3,9,27,34,21,32,14,12,18,39,24,41,11,5,23,46,29,44,2,0,26,43,20,33,7,13,31,38,17,36,10,8,22,35,28,45,15,1,19,42,25,40,6,4,30,16 },
	{ 9,42,8,43,30,40,28,10,31,41,29,11,17,1,34,16,0,35,32,18,2,33,19,3,25,46,44,24,45,14,26,12,15,27,13,38,36,39,37,22,6,20,4,23,7,21,5 },
	{ 34,26,16,41,37,29,22,14,44,1,24,43,38,30,4,9,3,20,12,33,19,11,17,40,36,28,7,35,27,0,25,42,23,15,45,8,2,39,31,5,32,46,18,10,21,13,6 },
	{ 37,10,1,30,34,44,8,19,29,32,17,15,5,39,2,12,22,46,36,43,0,31,21,26,41,28,7,24,14,4,11,38,35,45,23,9,18,42,33,20,27,16,40,6,25,3,13 },
	{ 22,1,19,34,15,8,45,10,7,0,37,18,31,29,44,11,46,6,41,21,36,3,30,33,28,27,25,40,20,42,2,39,17,32,13,26,24,5,43,23,38,16,12,35,14,9,4 },
	{ 10,45,20,46,19,0,7,36,25,43,26,13,14,33,16,34,31,4,11,40,21,22,1,2,37,28,38,27,8,15,44,17,35,18,5,6,41,24,42,23,12,3,32,29,39,30,9 },
	{ 18,8,34,23,13,6,40,16,3,45,21,30,4,42,27,1,14,36,28,11,33,25,35,22,12,38,19,9,2,44,20,7,41,17,43,26,0,46,31,5,10,32,24,15,37,29,39 },
	{ 6,11,15,45,4,9,34,28,23,19,32,14,5,17,35,12,39,22,42,18,33,31,27,40,16,13,38,25,43,2,30,36,26,41,0,21,24,3,46,7,37,10,1,44,20,8,29 },
	{ 11,31,45,17,4,38,33,15,9,21,2,37,24,13,42,19,6,1,35,28,26,46,40,23,16,5,39,10,30,44,20,3,32,14,8,43,18,7,36,25,12,27,41,22,0,34,29 },
	{ 0,6,2,36,32,38,34,5,1,7,3,37,33,39,35,20,24,22,26,21,25,23,27,12,8,14,10,44,40,46,42,13,9,15,11,45,41,43,28,16,30,18,29,17,31,19,4 },
	{ 45,16,34,27,4,15,32,25,39,22,13,2,37,28,46,19,8,7,44,17,43,26,5,14,41,20,38,31,0,11,36,29,35,18,9,6,33,24,42,23,12,3,40,21,30,1,10 },
	{ 34,20,42,29,39,24,7,31,32,8,37,44,5,19,35,43,28,3,14,6,17,33,40,1,23,45,26,4,18,13,10,2,21,15,38,16,46,25,41,30,0,22,9,27,36,12,11 },
},
{
	/* Frame 53 */
	{ 41,16,0,40,17,1,25,9,33,24,8,32,45,20,4,44,21,5,29,13,37,28,12,36,18,2,26,10,19,3,27,11,35,43,34,42,22,6,30,14,23,7,31,15,39,38,46 },
	{ 38,3,28,26,33,4,43,2,29,27,36,5,42,15,24,22,37,0,14,25,23,40,1,46,11,20,18,41,12,35,10,21,19,44,13,34,7,16,30,45,8,39,6,17,31,32,9 },
	{ 40,16,43,3,24,33,15,45,5,6,9,10,0,23,12,31,38,17,42,18,25,32,26,35,44,20,7,28,37,11,41,1,2,13,14,4,19,8,27,34,21,46,22,29,36,30,39 },
	{ 4,9,46,3,31,5,44,8,39,2,43,22,26,45,1,38,28,42,23,27,36,0,41,29,35,24,18,37,15,40,20,34,25,19,14,33,21,16,12,7,32,11,17,13,6,10,30 },
	{ 2,29,42,37,8,22,28,11,36,23,16,39,10,5,45,17,30,25,38,33,4,18,44,31,24,7,32,19,13,35,6,1,46,41,12,26,34,0,15,40,27,20,3,43,14,9,21 },
	{ 36,34,46,41,37,35,9,5,3,15,8,4,2,14,25,29,19,23,24,28,18,22,32,44,42,38,33,45,43,39,1,13,11,7,0,12,10,6,17,21,27,31,16,20,26,30,40 },
	{ 35,23,33,21,10,8,42,18,36,16,7,5,27,45,25,2,0,34,30,40,28,11,9,39,19,37,17,14,12,46,22,32,20,3,1,43,31,41,29,6,4,38,26,44,24,15,13 },
	{ 17,35,29,36,10,40,22,1,13,42,27,6,33,15,39,25,20,44,18,30,9,46,4,2,37,11,41,23,16,34,28,43,26,7,0,12,21,45,19,32,14,38,24,5,3,31,8 },
	{ 30,22,24,16,31,23,25,17,42,38,44,32,43,39,45,33,10,6,12,0,11,7,13,1,26,18,28,20,27,19,29,21,46,34,40,36,35,41,37,14,2,8,4,15,3,9,5 },
	{ 18,46,17,45,3,30,32,29,15,22,21,7,43,36,8,27,0,19,12,34,31,33,28,4,40,23,20,24,38,10,37,9,16,44,2,1,14,13,35,6,42,5,41,26,25,39,11 },
	{ 32,30,27,6,45,3,41,23,34,13,9,20,46,16,43,4,14,37,11,33,31,18,7,44,28,38,24,35,12,0,21,17,26,15,36,2,40,22,19,8,29,39,25,42,5,1,10 },
	{ 28,33,31,18,43,25,37,46,29,0,30,19,10,40,4,7,44,1,34,11,16,41,5,26,6,20,45,23,35,17,8,27,38,21,12,22,15,2,32,9,42,39,24,36,13,14,3 },
},
{
	/* Frame 54 */
	{ 16,44,25,37,41,1,8,18,14,27,39,46,30,3,43,45,5,12,0,21,9,28,32,26,7,2,23,11,34,4,17,13,24,36,20,40,29,33,6,19,15,38,22,10,31,35,42 },
	{ 41,9,26,24,42,10,40,8,27,25,43,11,37,1,18,16,38,2,36,0,19,17,39,3,45,13,30,28,46,14,44,12,31,29,15,33,5,22,20,34,6,32,4,23,21,35,7 },
	{ 12,31,7,21,9,32,10,19,40,16,13,36,30,44,20,33,11,34,41,0,42,37,14,45,4,23,26,35,25,1,43,2,15,38,29,5,46,22,27,24,3,39,28,6,8,18,17 },
	{ 41,2,35,15,46,20,9,32,3,44,14,39,21,0,33,12,45,7,38,26,1,13,36,6,27,30,4,37,24,18,31,5,42,25,19,22,10,43,16,28,23,40,11,34,17,29,8 },
	{ 42,13,35,36,16,40,30,33,2,28,0,45,25,14,7,19,11,12,34,5,17,9,31,32,22,46,26,39,20,43,44,24,37,6,41,10,3,4,29,8,1,23,15,27,38,18,21 },
	{ 18,0,24,11,19,1,25,42,32,43,33,14,30,4,20,15,31,5,21,46,36,37,2,26,8,16,3,27,9,17,34,40,35,41,6,22,12,28,7,23,13,29,38,44,39,45,10 },
	{ 19,32,21,38,41,14,8,3,22,5,16,35,31,44,25,42,33,6,0,15,26,9,28,23,36,17,34,45,10,12,7,18,1,20,39,27,40,29,46,37,2,4,11,30,13,24,43 },
	{ 26,19,31,35,22,42,15,44,9,37,16,12,32,5,29,27,39,18,46,11,34,7,14,8,36,1,25,4,41,28,21,38,3,10,6,30,23,43,0,45,24,17,40,13,33,20,2 },
	{ 38,36,39,37,6,30,4,28,7,31,5,29,46,44,45,18,14,16,12,19,15,17,13,34,32,35,33,2,26,0,24,3,27,1,25,42,40,43,41,22,10,20,8,23,11,21,9 },
	{ 3,31,10,39,41,46,16,13,25,43,18,15,27,32,28,9,4,45,34,30,11,6,40,12,24,21,0,36,26,23,2,33,38,8,5,17,44,35,42,7,19,14,20,1,29,37,22 },
	{ 18,46,17,45,6,5,27,39,20,40,11,0,30,34,29,33,14,13,19,24,36,7,8,22,42,21,41,2,1,31,35,16,44,15,4,26,38,25,37,10,9,23,43,28,32,3,12 },
	{ 39,4,38,37,26,6,24,36,27,7,25,21,13,20,12,46,45,22,14,44,23,15,35,29,33,34,28,32,2,0,30,3,1,31,43,41,42,40,18,10,16,8,19,11,17,9,5 },
},
{
	/* Frame 55 */
	{ 23,4,9,3,15,20,37,25,40,19,34,31,0,12,38,11,16,33,28,45,6,27,42,8,2,22,46,5,24,41,18,35,14,21,36,39,10,30,1,13,7,26,43,17,32,29,44 },
	{ 9,16,36,2,14,19,40,4,24,35,30,7,20,32,12,10,23,38,27,0,28,45,43,3,15,8,17,37,25,34,31,46,18,41,5,13,11,6,21,33,29,44,42,22,39,26,1 },
	{ 11,41,5,6,13,14,35,0,43,23,8,27,38,17,46,18,29,32,30,40,20,7,24,37,15,45,1,2,9,10,39,4,19,12,31,34,21,42,22,25,36,26,44,16,3,28,33 },
	{ 3,14,43,26,32,17,36,29,9,34,19,39,22,11,0,4,40,25,44,2,7,42,27,30,37,20,8,12,38,23,10,15,5,33,16,45,28,6,35,18,46,31,21,1,13,41,24 },
	{ 15,18,4,35,8,43,14,19,32,5,38,9,42,16,22,33,26,39,12,17,23,36,27,40,13,46,20,24,37,30,41,2,21,25,31,44,3,11,28,0,45,6,10,29,1,34,7 },
	{ 33,45,2,14,0,12,34,46,32,44,3,15,1,13,18,22,16,20,19,23,17,21,43,39,41,37,10,6,8,4,42,38,40,36,11,7,9,5,26,30,24,28,27,31,25,29,35 },
	{ 20,38,45,3,26,8,25,39,44,2,19,1,24,42,37,15,18,0,17,43,36,14,31,13,16,34,41,7,30,12,29,35,40,6,23,5,28,46,33,11,22,4,21,32,10,27,9 },
	{ 21,41,19,36,14,34,24,5,3,42,31,8,33,11,45,23,16,38,28,26,7,46,0,12,37,15,35,25,20,40,18,43,30,9,4,2,17,39,29,32,10,44,22,1,13,27,6 },
	{ 11,44,25,2,37,16,7,42,29,14,35,20,38,19,9,26,0,23,5,40,30,12,33,3,36,17,10,45,24,15,34,21,6,43,28,46,27,1,39,18,8,31,13,32,22,4,41 },
	{ 38,1,7,12,10,44,4,2,25,36,31,41,21,19,28,33,26,39,16,42,22,13,11,34,5,3,8,14,40,0,6,29,32,27,45,17,43,23,24,37,30,35,20,46,18,9,15 },
	{ 8,43,4,15,19,40,9,34,5,14,18,41,23,35,12,46,17,27,32,22,44,13,39,16,26,33,31,45,2,38,25,21,30,36,3,24,20,0,37,10,7,29,1,42,11,6,28 },
	{ 24,7,12,33,11,15,38,18,41,1,21,46,28,34,9,22,27,37,31,16,42,2,45,5,32,10,25,6,13,40,0,20,14,39,19,8,23,26,36,29,35,44,4,30,17,43,3 },
},
{
	/* Frame 56 */
	{ 38,16,45,29,22,3,20,40,10,7,17,44,46,35,21,0,11,26,6,4,15,34,1,43,27,8,5,18,14,31,12,33,42,9,24,37,19,39,30,13,28,32,23,2,41,25,36 },
	{ 31,15,29,13,30,14,28,12,46,44,45,17,7,5,16,6,4,38,18,36,39,19,37,25,9,42,24,8,43,40,26,10,41,27,11,23,1,21,34,22,0,20,35,32,2,33,3 },
	{ 28,35,14,1,45,2,9,10,21,40,7,29,15,3,46,11,36,41,22,42,30,18,17,26,37,25,23,43,4,31,32,12,19,16,27,24,38,5,33,13,34,0,44,8,39,20,6 },
	{ 35,20,25,12,23,36,27,41,15,5,39,0,43,28,6,2,31,44,21,16,13,8,37,18,32,14,10,38,1,34,29,24,3,22,45,26,40,17,4,46,9,42,19,33,7,11,30 },
	{ 30,19,38,11,12,1,24,41,14,32,3,26,29,34,20,37,8,31,22,39,10,13,4,43,25,44,16,33,6,27,46,18,35,21,9,0,23,40,15,2,5,42,28,45,17,36,7 },
	{ 25,3,27,33,35,0,24,2,26,32,34,5,21,7,23,37,39,4,20,6,22,36,38,9,17,11,19,41,43,8,16,10,18,40,42,13,29,15,31,45,12,28,14,30,44,46,1 },
	{ 18,4,42,23,1,14,36,20,11,33,17,39,30,8,34,27,13,6,40,24,3,45,29,43,22,0,46,19,5,10,32,16,15,37,21,35,26,12,38,31,9,2,44,28,7,41,25 },
	{ 30,29,27,41,24,42,11,38,7,37,20,2,32,1,19,31,45,28,46,15,40,9,10,6,36,5,23,0,35,18,17,44,13,14,8,26,25,43,4,39,22,21,34,3,33,16,12 },
	{ 42,15,21,35,6,28,19,46,1,26,39,8,23,32,5,30,41,12,3,25,36,10,16,45,34,7,29,43,14,20,27,38,9,18,0,31,40,13,22,33,4,11,17,44,2,24,37 },
	{ 11,13,41,31,0,39,2,20,22,42,44,9,19,29,7,35,37,24,26,12,40,14,17,38,3,5,33,23,8,10,28,30,34,36,1,27,21,15,43,45,16,18,4,32,6,25,46 },
	{ 21,8,35,45,26,7,24,9,34,44,19,6,25,4,43,33,18,15,16,5,42,32,31,14,17,12,39,41,30,3,28,13,38,40,23,2,29,0,37,22,11,20,1,46,36,27,10 },
	{ 32,26,36,31,42,14,17,29,34,6,41,45,19,9,33,37,30,1,43,20,46,16,11,35,38,3,25,12,18,8,23,4,0,27,21,10,15,39,28,2,24,7,13,40,22,44,5 },
},
{
	/* Frame 57 */
	{ 27,17,35,11,41,1,26,16,34,10,40,0,31,21,39,15,45,5,30,20,38,14,44,4,19,25,43,3,33,9,18,24,42,2,32,8,23,29,7,37,13,22,28,46,6,36,12 },
	{ 8,23,38,28,41,10,5,30,43,25,32,7,12,27,34,16,37,14,9,18,39,29,44,11,0,31,46,20,33,2,13,22,35,17,40,15,4,19,42,24,45,6,1,26,21,36,3 },
	{ 24,11,22,33,4,17,10,27,32,46,13,16,7,26,41,35,12,29,6,19,40,34,1,28,15,18,37,43,0,21,14,31,36,42,9,20,3,30,45,39,8,25,2,23,44,38,5 },
	{ 6,44,30,17,43,24,4,15,33,3,40,38,10,20,13,19,0,26,36,22,29,35,31,16,42,9,7,45,14,32,2,25,5,12,18,41,39,11,21,46,23,28,34,1,27,37,8 },
	{ 16,21,3,6,0,39,33,36,9,12,27,15,24,45,42,20,19,7,1,4,37,34,13,26,31,25,28,10,40,43,46,18,23,17,5,2,35,38,32,30,8,29,11,14,41,44,22 },
	{ 15,26,1,30,5,16,43,20,27,33,31,2,37,17,6,42,21,8,46,12,32,3,36,7,18,9,22,13,24,35,28,39,19,41,23,10,45,25,14,34,29,0,38,4,40,11,44 },
	{ 17,3,5,39,26,41,24,14,12,34,19,36,29,7,9,43,22,45,20,2,0,38,31,40,25,11,13,18,33,16,6,4,42,27,44,21,15,1,35,30,37,28,10,8,46,23,32 },
	{ 29,9,46,28,8,40,26,14,41,27,15,17,1,38,16,0,39,32,22,6,33,23,7,25,13,42,24,12,43,44,30,10,45,31,11,21,5,34,20,4,35,36,18,2,37,19,3 },
	{ 46,45,20,24,23,43,34,1,29,18,38,44,37,8,22,27,35,28,2,31,39,36,9,6,26,5,40,3,30,17,7,10,4,41,32,14,16,13,11,21,25,33,42,15,0,12,19 },
	{ 6,18,10,33,15,4,16,8,13,22,46,3,31,44,1,34,29,39,19,43,32,14,37,26,17,41,20,12,24,2,7,30,11,0,5,38,9,42,23,36,27,40,21,45,25,35,28 },
	{ 6,40,20,43,22,5,7,41,21,42,23,36,0,38,2,16,18,37,1,39,3,17,19,30,32,12,34,15,28,31,33,13,35,14,29,26,44,8,11,24,27,45,9,46,10,25,4 },
	{ 11,44,25,30,1,6,37,20,42,23,12,15,32,29,35,18,5,10,41,24,46,27,0,3,36,17,39,22,9,14,45,28,34,31,4,7,40,21,43,26,13,2,33,16,38,19,8 },
},
{
	/* Frame 58 */
	{ 15,20,40,27,39,1,10,29,33,22,42,12,3,24,36,31,35,5,14,17,45,26,38,0,7,28,32,19,9,2,21,41,30,34,4,11,16,44,23,43,13,6,25,37,18,46,8 },
	{ 14,29,37,22,46,4,7,24,32,27,35,9,2,17,41,30,38,12,15,20,44,23,5,10,25,33,18,42,0,3,28,36,31,39,13,6,21,45,26,34,8,11,16,40,19,43,1 },
	{ 15,32,4,24,19,37,31,20,34,9,11,17,12,6,41,27,43,0,39,28,44,22,5,25,2,14,33,21,35,8,18,36,30,46,13,7,40,10,16,29,45,23,26,42,1,38,3 },
	{ 6,34,24,1,45,14,42,4,9,18,38,12,20,33,26,3,46,17,28,36,41,22,11,25,0,44,30,7,35,8,19,15,43,5,32,27,2,39,13,21,40,23,10,16,29,37,31 },
	{ 41,30,12,40,31,29,15,43,28,14,42,45,18,16,44,19,17,3,1,2,46,0,22,20,23,21,7,35,5,33,6,34,4,32,9,26,8,27,39,25,37,11,38,24,36,10,13 },
	{ 27,44,11,41,16,38,0,29,35,26,13,10,23,40,7,37,28,34,12,25,22,9,6,19,36,3,33,24,46,8,21,43,18,5,2,31,32,15,45,20,42,4,17,39,30,1,14 },
	{ 18,8,25,6,13,43,37,46,19,40,24,7,30,12,21,10,1,41,34,31,44,20,11,26,0,17,14,5,35,45,38,27,32,16,15,22,4,29,2,9,39,33,42,23,36,28,3 },
	{ 28,44,27,34,37,1,6,29,12,26,11,16,36,23,46,41,39,13,10,17,4,22,3,24,40,31,38,33,43,5,2,25,8,30,15,20,32,19,42,45,35,9,14,21,0,18,7 },
	{ 0,5,28,25,3,42,23,15,26,1,40,4,45,38,24,43,22,10,41,21,44,39,8,13,6,19,11,31,20,17,9,34,12,7,46,18,32,30,37,16,35,29,2,33,14,36,27 },
	{ 26,15,9,29,10,45,46,2,22,16,5,19,38,32,35,30,24,13,27,14,40,43,6,0,20,3,23,17,36,39,33,8,28,11,31,25,44,41,42,4,18,7,1,21,34,37,12 },
	{ 18,4,24,46,36,15,19,5,25,37,30,10,20,0,42,32,31,11,21,1,43,33,6,26,12,16,38,44,7,27,13,17,39,45,22,2,28,8,34,40,23,3,29,9,35,41,14 },
	{ 30,32,34,1,29,3,31,33,35,0,28,6,18,36,38,5,17,7,19,37,39,4,16,10,22,40,42,9,21,11,23,41,43,8,20,14,26,44,46,13,25,15,27,45,12,24,2 },
},
{
	/* Frame 59 */
	{ 29,23,36,9,42,3,28,22,45,8,39,2,17,31,44,5,38,11,16,30,33,4,10,25,19,32,13,46,7,24,18,41,12,35,6,21,27,40,1,34,15,20,26,37,0,43,14 },
	{ 16,2,14,7,33,13,28,36,17,34,15,30,6,23,0,40,29,37,35,24,42,31,38,22,1,26,41,19,4,44,25,43,39,46,27,8,18,5,20,45,10,3,9,32,21,12,11 },
	{ 26,45,39,8,17,2,19,44,38,9,28,11,18,33,4,29,10,31,32,46,5,20,7,30,41,35,12,21,6,23,40,34,13,24,15,22,37,43,0,25,14,27,36,42,1,16,3 },
	{ 45,15,5,12,34,27,16,9,20,13,23,35,42,17,24,2,38,21,28,22,31,43,32,25,3,10,39,46,36,29,6,30,33,40,18,11,0,37,44,7,14,4,41,19,26,1,8 },
	{ 38,7,21,2,33,16,19,31,45,28,46,26,40,9,43,10,6,37,20,23,32,1,35,18,30,44,13,14,8,11,25,36,5,39,22,0,34,3,17,12,15,29,27,41,24,42,4 },
	{ 26,36,17,30,34,21,38,19,0,23,4,2,9,6,13,33,11,37,16,15,35,20,40,39,18,44,25,22,42,29,46,27,8,31,12,10,1,14,5,41,3,45,24,7,43,28,32 },
	{ 10,18,9,17,42,41,11,19,8,16,43,44,14,30,13,29,46,45,15,31,12,28,32,2,26,1,25,34,33,3,27,0,24,35,36,6,22,5,21,38,37,7,23,4,20,39,40 },
	{ 25,5,38,24,4,39,36,26,6,37,27,7,21,13,46,20,12,44,22,14,45,23,15,29,1,34,28,0,35,32,30,2,33,31,3,17,9,42,16,8,43,40,18,10,41,19,11 },
	{ 46,11,19,42,7,30,24,37,16,45,4,33,12,41,21,10,39,18,27,6,35,15,23,25,36,1,44,9,32,28,40,20,38,3,26,34,14,43,22,31,0,8,17,29,5,13,2 },
	{ 39,31,36,12,19,46,0,34,10,9,6,5,15,24,3,20,41,30,37,29,18,17,44,35,27,32,8,23,42,4,38,14,13,2,1,11,28,7,16,45,26,33,25,22,43,21,40 },
	{ 33,13,34,27,40,21,42,3,36,28,11,45,25,5,6,18,0,12,35,14,26,9,20,43,23,37,17,38,31,32,44,24,46,7,41,1,2,15,29,8,10,22,4,16,39,19,30 },
	{ 35,45,22,11,24,5,34,44,27,10,29,4,41,26,7,28,1,46,40,31,6,17,0,43,37,30,3,16,13,42,36,19,2,21,12,39,33,18,15,20,9,38,32,23,14,25,8 },
},
{
	/* Frame 60 */
	{ 5,30,43,29,32,3,8,27,38,20,37,14,13,18,35,17,44,11,4,23,42,28,41,2,1,26,25,36,7,12,31,34,16,33,10,9,22,39,21,40,15,0,19,46,24,45,6 },
	{ 8,10,19,1,24,35,26,33,44,14,23,13,39,30,4,29,9,16,43,18,41,25,34,32,3,22,12,21,38,37,28,7,17,42,40,11,0,2,27,46,45,20,15,36,6,31,5 },
	{ 44,25,32,2,30,39,4,8,18,34,15,29,36,23,46,10,16,41,12,43,6,26,1,3,31,38,20,45,24,33,19,35,14,5,9,11,17,40,28,37,22,27,0,13,42,7,21 },
	{ 9,5,27,33,46,29,0,30,42,20,26,23,44,1,14,19,43,38,21,10,22,25,34,45,15,18,12,39,40,36,11,6,24,35,2,13,17,41,37,7,8,4,32,3,28,16,31 },
	{ 12,40,31,13,41,15,43,28,14,42,29,26,36,8,38,27,37,9,39,11,24,10,25,4,32,6,34,5,33,7,35,20,22,21,23,0,2,44,1,3,45,16,18,17,46,19,30 },
	{ 6,41,20,34,27,4,11,32,25,39,18,9,2,37,16,46,23,0,7,44,21,35,30,5,14,33,28,42,19,12,3,40,17,26,1,10,45,24,38,31,8,15,36,29,43,22,13 },
	{ 19,33,10,18,32,43,0,24,42,1,25,15,31,37,14,30,36,4,20,46,5,21,3,27,41,2,26,40,35,8,16,34,9,17,7,23,45,6,22,44,39,12,28,38,13,29,11 },
	{ 24,32,27,42,41,39,13,14,25,0,26,3,20,40,23,38,37,1,2,21,8,22,11,28,36,31,46,45,35,9,10,29,4,30,7,16,44,19,34,33,43,5,6,17,12,18,15 },
	{ 0,5,18,23,17,36,35,25,28,11,30,9,42,40,45,4,3,22,16,21,34,39,33,29,10,15,8,13,27,46,44,2,7,1,20,19,38,32,37,14,24,12,26,31,43,41,6 },
	{ 10,46,1,37,43,30,21,27,8,44,34,7,41,28,18,25,14,32,5,11,16,31,12,2,38,9,45,35,22,29,19,0,36,42,15,33,20,26,17,6,40,13,3,39,24,23,4 },
	{ 18,1,30,13,3,24,15,20,32,10,44,17,6,34,29,41,46,19,37,0,31,43,12,39,26,9,22,5,11,16,7,28,40,2,36,25,14,42,21,33,38,27,45,8,23,35,4 },
	{ 9,31,35,20,44,7,12,22,42,29,33,14,5,19,24,40,3,8,26,38,17,45,10,1,23,43,28,36,15,4,30,34,21,41,6,13,27,39,16,32,11,0,18,46,25,37,2 },
},
{
	/* Frame 61 */
	{ 35,10,34,11,25,3,17,43,24,2,16,42,39,14,38,15,29,7,21,28,6,20,46,41,26,33,40,27,32,19,9,1,18,8,0,45,30,37,44,31,36,23,13,5,22,12,4 },
	{ 18,35,29,36,7,0,31,38,20,41,2,13,22,17,32,11,4,19,34,24,37,6,1,26,43,21,44,15,8,23,46,28,33,10,5,30,39,25,40,3,12,27,42,16,45,14,9 },
	{ 18,43,17,32,3,12,23,38,28,37,10,9,26,35,25,44,15,4,31,42,16,41,2,1,22,21,36,7,8,19,34,24,33,14,13,30,39,29,40,11,0,27,46,20,45,6,5 },
	{ 23,32,12,43,16,39,10,37,6,28,1,19,25,46,4,35,30,41,2,8,20,44,15,13,42,17,38,26,22,33,29,0,11,36,7,5,34,31,40,18,24,21,45,14,3,9,27 },
	{ 19,6,26,15,3,42,39,17,4,24,13,1,40,37,23,10,30,18,7,46,34,43,21,8,28,16,5,25,44,32,41,27,14,2,22,11,38,35,12,0,20,9,29,36,45,33,31 },
	{ 38,37,39,5,25,7,27,4,24,6,26,32,34,33,35,21,1,23,3,20,0,22,2,44,46,45,13,17,15,19,12,16,14,18,40,42,41,43,29,9,31,11,28,8,30,10,36 },
	{ 25,7,9,35,26,37,16,10,0,38,19,40,21,3,5,22,33,28,6,12,34,31,36,17,15,1,43,18,45,24,2,8,46,27,32,29,11,13,39,30,41,20,14,4,42,23,44 },
	{ 29,33,7,20,40,14,1,31,38,8,22,17,45,3,24,36,10,13,19,34,4,26,43,21,41,15,28,32,6,9,23,46,0,30,39,25,37,11,16,44,2,5,27,42,12,18,35 },
	{ 16,7,12,1,27,18,29,36,14,34,45,0,43,19,28,21,15,2,9,30,44,33,42,39,20,3,8,5,31,22,25,32,10,38,41,4,23,24,17,11,6,13,26,40,37,46,35 },
	{ 16,4,44,0,40,21,17,5,45,1,41,20,24,12,38,8,34,29,25,13,39,9,35,28,22,18,6,46,2,42,23,19,7,3,43,30,36,26,32,14,10,31,37,27,33,15,11 },
	{ 34,28,21,44,11,37,3,32,15,7,8,1,46,25,12,43,5,35,29,26,18,45,10,30,40,22,33,14,38,16,9,20,13,42,36,2,27,19,6,31,41,23,0,24,39,17,4 },
	{ 5,15,28,3,16,40,26,36,25,22,46,21,45,34,31,33,8,19,43,4,39,14,13,2,1,11,24,7,20,44,30,32,29,18,42,17,41,38,27,37,12,23,0,35,10,9,6 },
},
{
	/* Frame 62 */
	{ 38,25,16,35,11,21,2,37,27,13,18,4,30,40,23,1,39,15,17,6,10,3,28,42,26,44,19,5,41,32,8,14,7,24,46,34,29,43,20,45,36,12,33,31,9,22,0 },
	{ 24,36,27,39,1,2,17,33,30,34,12,15,20,40,23,43,9,10,25,45,18,46,0,3,28,32,31,35,5,6,21,37,26,38,8,11,16,44,19,13,14,29,41,22,42,4,7 },
	{ 14,37,20,46,7,27,1,2,31,36,13,6,45,26,25,19,30,12,23,44,5,32,24,35,18,17,29,39,22,4,33,8,34,11,40,16,43,28,38,15,21,9,10,41,0,42,3 },
	{ 1,10,22,39,29,37,17,26,34,7,40,5,31,46,2,8,21,43,14,18,44,24,32,11,23,38,12,0,27,35,6,41,28,36,16,3,9,4,30,19,45,25,33,20,42,15,13 },
	{ 23,14,42,6,34,30,22,15,43,7,35,17,8,46,0,38,24,16,9,1,39,25,21,12,40,4,32,28,20,13,41,5,33,29,27,44,19,36,10,2,26,45,18,37,11,3,31 },
	{ 26,4,24,7,27,5,25,38,36,39,37,2,22,0,20,3,23,1,21,34,32,35,33,14,18,12,16,15,19,13,17,46,44,45,10,30,8,28,11,31,9,29,42,40,43,41,6 },
	{ 18,4,17,2,1,41,42,19,36,16,3,30,0,29,14,13,43,37,38,31,32,28,15,26,12,25,10,9,39,33,34,27,44,24,11,22,8,21,6,5,35,45,46,23,40,20,7 },
	{ 28,9,30,11,12,14,45,34,21,32,23,39,16,5,18,7,8,10,41,46,25,44,27,35,20,1,22,3,4,6,37,42,29,40,31,24,13,26,15,0,2,33,38,17,36,19,43 },
	{ 33,24,35,11,20,9,7,30,5,44,18,46,32,34,8,31,4,29,19,14,17,2,41,43,37,28,39,15,16,13,3,26,1,40,22,42,36,38,12,27,0,25,23,10,21,6,45 },
	{ 1,4,35,38,26,31,40,45,42,5,2,39,30,9,44,43,46,3,6,8,13,10,7,17,12,11,14,16,21,32,15,25,20,19,33,36,24,29,18,23,0,37,34,28,27,41,22 },
	{ 16,44,19,28,34,31,1,26,38,5,22,8,11,41,12,15,17,45,2,32,29,35,6,24,36,27,39,20,42,23,9,18,46,13,30,0,3,33,4,7,25,37,10,40,21,43,14 },
	{ 28,34,32,3,31,1,29,35,33,2,30,16,8,42,40,19,11,17,9,43,41,18,10,4,24,38,36,7,27,5,25,39,37,6,26,20,12,46,44,23,15,21,13,45,22,14,0 },
},
{
	/* Frame 63 */
	{ 23,41,27,35,16,46,5,9,20,3,14,36,31,39,43,24,32,18,13,7,28,11,0,44,17,4,22,40,26,34,15,37,8,21,2,25,33,19,12,30,38,42,1,45,6,29,10 },
	{ 16,8,25,4,30,13,10,27,39,15,17,40,24,5,12,23,42,26,3,14,41,32,44,22,43,2,19,46,7,33,45,36,34,18,20,6,29,0,9,37,31,35,11,21,38,28,1 },
	{ 12,19,38,24,37,10,1,30,35,17,44,15,4,27,42,20,41,2,13,18,25,36,7,8,23,34,28,33,14,5,26,39,21,40,11,0,31,46,16,45,6,9,22,43,29,32,3 },
	{ 38,22,37,28,31,35,2,9,42,26,39,6,36,5,46,30,45,3,17,43,10,7,4,14,44,13,32,16,11,25,21,15,12,33,0,19,40,24,20,23,29,1,34,18,41,8,27 },
	{ 37,21,44,28,1,8,32,16,39,23,46,30,3,10,34,18,43,5,12,36,20,41,25,0,7,14,38,22,27,2,11,45,29,4,9,33,17,40,24,31,6,15,35,19,42,26,13 },
	{ 45,6,26,12,16,38,44,7,27,13,17,35,41,22,2,28,8,34,40,23,3,29,9,37,14,18,4,24,46,36,15,19,5,25,43,33,30,10,20,0,42,32,31,11,21,1,39 },
	{ 14,18,5,25,46,37,15,19,4,24,32,10,30,1,21,42,33,11,31,0,20,43,44,6,26,13,17,38,45,7,27,12,16,39,40,2,22,9,29,34,41,3,23,8,28,35,36 },
	{ 21,45,3,28,36,10,13,31,34,4,22,43,25,33,7,16,40,14,1,19,38,8,26,29,37,11,20,44,2,5,23,42,12,30,35,17,41,15,24,32,6,9,27,46,0,18,39 },
	{ 32,35,21,7,4,17,30,11,8,26,45,46,13,33,23,34,20,1,6,19,36,16,39,10,40,43,29,15,12,25,22,3,0,18,37,38,5,41,31,42,28,9,14,27,44,24,2 },
	{ 0,24,34,33,2,26,1,25,35,32,3,27,20,8,42,41,22,10,21,9,43,40,23,11,4,28,38,37,6,30,5,29,39,36,7,31,16,12,46,45,18,14,17,13,44,19,15 },
	{ 6,1,46,13,26,2,7,32,9,12,3,33,14,8,21,34,10,15,41,17,20,35,29,11,36,40,23,16,25,28,42,37,19,22,24,38,43,4,18,45,31,39,0,5,44,27,30 },
	{ 33,42,24,5,14,19,41,32,13,4,31,18,40,39,12,17,30,3,38,29,16,11,2,37,46,28,1,10,23,45,36,9,0,27,22,44,35,8,21,26,7,43,34,25,20,15,6 },
},
{
	/* Frame 64 */
	{ 19,32,11,29,41,22,5,20,14,25,12,18,1,10,40,37,21,39,24,13,0,17,35,9,36,38,45,16,34,8,31,43,7,44,27,46,3,33,30,42,28,6,23,4,26,15,2 },
	{ 14,44,19,7,24,4,26,39,23,42,20,40,11,29,0,2,15,16,12,18,25,5,38,37,21,8,10,1,30,35,33,17,13,46,45,6,36,27,9,22,43,41,31,34,28,32,3 },
	{ 38,24,18,17,12,7,20,39,8,11,46,16,13,31,4,9,36,10,0,3,32,30,35,5,23,37,27,1,44,2,33,14,34,29,40,22,43,26,25,45,19,15,28,41,6,42,21 },
	{ 38,0,37,26,9,21,33,15,12,39,17,36,3,46,8,45,20,32,23,29,41,16,2,25,44,11,22,35,28,40,31,19,24,10,6,34,5,30,43,18,1,27,7,4,14,42,13 },
	{ 41,5,33,29,21,12,40,4,32,28,20,9,39,1,25,17,46,8,38,0,24,16,7,35,31,23,14,42,6,34,30,22,15,43,3,45,27,37,19,10,2,44,26,36,18,11,13 },
	{ 25,15,19,37,4,24,14,18,36,46,1,21,11,31,33,43,0,20,10,30,32,42,13,17,7,27,45,39,12,16,6,26,44,38,9,29,3,23,41,35,8,28,2,22,40,34,5 },
	{ 19,45,14,18,44,12,16,46,13,17,11,31,41,10,30,40,43,8,28,42,9,29,7,27,37,6,26,36,39,4,24,38,5,25,3,23,33,2,22,32,35,0,20,34,1,21,15 },
	{ 20,5,30,15,0,10,33,38,29,44,23,35,24,9,18,3,4,14,37,42,17,32,27,39,28,13,22,7,8,2,41,46,21,36,31,43,16,1,26,11,12,6,45,34,25,40,19 },
	{ 33,36,42,1,27,16,21,2,7,40,12,35,22,25,37,11,46,0,5,26,31,20,6,41,44,34,39,9,19,24,29,10,15,32,4,43,30,17,45,3,38,8,13,18,23,28,14 },
	{ 32,37,27,30,8,13,36,10,31,17,12,35,11,14,16,21,34,39,41,18,15,1,20,38,40,45,19,22,0,5,44,2,23,25,4,43,3,6,24,29,42,33,26,7,9,28,46 },
	{ 27,6,40,0,29,2,7,43,46,17,28,3,30,37,42,16,13,18,31,33,36,9,12,19,14,32,39,8,21,10,15,35,38,25,20,11,22,45,34,24,5,26,23,41,44,1,4 },
	{ 7,29,33,26,44,17,43,22,24,36,31,35,20,46,19,9,14,38,1,6,12,11,45,4,3,25,37,30,40,21,18,28,32,27,39,16,42,23,13,10,34,5,2,8,15,41,0 },
},
{
	/* Frame 65 */
	{ 19,1,45,3,16,18,0,44,2,46,17,31,41,13,43,15,28,30,40,12,42,14,29,27,9,37,11,39,24,26,8,36,10,38,25,23,33,5,35,7,20,22,32,4,34,6,21 },
	{ 3,0,46,13,31,34,9,39,27,36,22,43,21,40,6,18,45,17,2,28,33,15,12,24,11,8,38,5,23,42,1,19,44,30,35,29,32,14,26,37,25,10,20,41,7,4,16 },
	{ 0,7,25,32,14,41,21,46,2,28,37,27,34,16,43,23,13,30,39,1,18,8,15,40,4,3,29,36,10,45,17,42,6,24,33,31,38,20,19,9,26,35,5,22,12,11,44 },
	{ 0,46,12,37,8,21,45,17,35,29,32,14,25,38,10,5,40,22,1,18,13,31,9,27,6,42,2,33,15,39,11,36,41,23,20,19,44,16,30,34,28,26,24,7,43,4,3 },
	{ 28,16,26,22,29,17,27,23,8,0,14,6,9,1,15,7,41,33,39,40,32,46,38,24,20,30,18,25,21,31,19,12,4,10,2,13,5,11,3,45,37,43,35,44,36,42,34 },
	{ 24,37,10,38,9,4,23,40,20,12,31,34,28,33,19,0,36,27,8,22,21,43,7,30,29,32,15,18,45,17,46,3,26,25,11,39,5,42,6,41,13,14,35,44,16,2,1 },
	{ 46,14,28,31,44,12,15,29,30,45,13,32,6,34,20,23,4,33,7,35,21,22,5,40,8,42,10,25,27,41,9,43,11,24,26,38,0,2,17,36,19,39,1,3,16,37,18 },
	{ 15,10,31,18,6,3,28,25,36,13,33,21,44,0,41,27,38,30,35,7,46,2,43,23,24,12,32,9,20,17,40,5,26,39,14,34,11,19,42,22,29,8,37,16,4,45,1 },
	{ 29,24,38,4,43,1,20,36,31,33,26,14,3,45,22,40,12,35,9,28,17,5,42,0,11,37,30,32,19,7,2,25,39,13,34,8,21,16,46,27,15,10,44,23,41,18,6 },
	{ 46,4,30,41,18,35,8,20,44,15,3,17,32,27,22,39,13,43,0,10,7,29,37,31,40,19,34,24,5,14,2,9,21,45,23,38,12,42,16,33,26,6,28,36,1,11,25 },
	{ 43,7,2,42,6,46,19,23,18,22,11,15,33,10,14,32,27,36,31,26,37,30,21,1,41,20,0,40,4,44,17,5,45,16,29,35,9,39,28,34,8,38,12,25,13,24,3 },
	{ 27,2,25,32,7,4,39,19,11,16,9,43,21,44,46,3,0,35,5,30,38,28,37,17,40,42,45,22,14,12,1,26,34,24,33,31,6,29,36,41,18,10,8,23,15,20,13 },
},
{
	/* Frame 66 */
	{ 45,43,40,27,7,24,4,10,33,38,13,3,30,0,29,44,42,23,9,20,26,6,25,37,35,32,19,15,16,12,2,41,46,5,11,22,8,21,39,36,34,31,1,28,18,14,17 },
	{ 33,6,9,16,46,4,27,3,44,43,25,1,30,34,41,10,19,28,32,39,8,17,15,22,37,2,13,20,42,0,31,7,40,29,5,26,38,45,14,23,24,36,35,12,21,11,18 },
	{ 4,41,17,20,8,39,13,34,24,6,19,22,43,36,15,10,40,1,45,21,38,12,25,28,18,23,42,3,14,33,27,30,0,44,5,16,9,29,35,46,7,2,32,26,37,31,11 },
	{ 27,46,12,42,19,38,5,34,45,11,41,29,14,3,0,20,6,26,24,13,43,31,18,39,17,36,35,23,32,8,15,1,7,4,25,44,10,30,40,28,16,37,2,22,33,21,9 },
	{ 10,21,45,42,4,29,3,36,8,22,15,40,30,1,39,20,13,19,43,28,2,27,37,34,14,17,41,46,0,25,7,32,12,18,11,44,26,5,35,16,9,23,24,6,31,33,38 },
	{ 34,30,29,23,41,5,6,10,37,25,38,26,44,1,19,31,33,13,14,40,4,43,7,20,36,9,39,27,0,3,16,32,12,35,15,28,42,22,21,8,11,24,2,45,17,46,18 },
	{ 43,11,15,42,10,46,14,26,30,27,31,3,33,7,2,32,6,37,18,22,36,19,23,29,41,9,28,40,8,45,13,24,44,12,25,35,21,39,1,34,20,38,0,5,16,4,17 },
	{ 14,37,0,24,34,6,41,11,16,12,3,27,32,4,28,38,9,19,45,30,20,42,1,25,35,22,15,36,17,13,7,40,10,33,46,5,29,2,26,31,21,43,39,8,18,44,23 },
	{ 3,37,16,38,27,9,10,23,33,5,34,6,29,30,40,19,1,2,44,25,26,8,21,22,32,12,43,15,28,36,17,39,18,0,11,45,24,46,4,35,7,20,31,41,13,42,14 },
	{ 29,39,4,46,28,38,21,12,20,13,1,33,25,0,32,24,17,8,40,16,9,41,15,37,7,14,36,6,31,23,44,30,22,45,11,43,3,35,10,42,2,34,27,19,26,18,5 },
	{ 25,3,27,0,24,2,26,33,35,32,34,9,21,11,23,8,20,10,22,41,43,40,42,5,29,7,31,4,28,6,30,37,39,36,38,13,17,15,19,12,16,14,18,45,44,46,1 },
	{ 8,46,27,3,36,40,18,15,21,35,25,0,30,6,42,13,32,38,28,11,17,45,23,26,2,5,9,14,20,34,24,37,41,19,43,12,1,31,7,10,16,44,22,33,39,29,4 },
},
{
	/* Frame 67 */
	{ 16,29,38,43,4,9,28,7,42,33,8,18,6,11,32,45,19,30,21,35,10,1,44,31,20,25,34,0,13,24,3,46,37,12,22,2,15,36,41,23,26,17,39,14,5,40,27 },
	{ 43,8,20,6,25,5,26,2,1,28,19,46,13,14,42,22,9,21,10,7,37,27,38,3,33,29,34,30,45,15,16,23,41,11,36,39,24,4,32,35,31,0,44,18,17,12,40 },
	{ 34,5,3,8,14,40,0,6,29,32,27,45,21,43,19,24,37,30,35,16,46,22,9,15,38,1,7,12,10,44,4,2,25,36,31,41,17,23,28,33,26,39,20,42,18,13,11 },
	{ 15,10,5,0,45,34,46,11,28,36,1,6,35,29,24,37,7,2,20,25,31,38,3,21,16,30,27,39,40,17,22,26,12,41,42,23,18,32,13,8,14,43,19,4,33,44,9 },
	{ 43,45,42,44,31,11,25,13,30,10,24,12,35,37,34,36,19,3,21,5,18,2,20,4,41,46,40,27,15,29,9,26,14,28,8,39,33,38,32,23,7,17,1,22,6,16,0 },
	{ 13,39,24,29,23,41,3,44,6,31,37,11,14,1,4,42,9,35,12,38,19,22,40,2,27,33,30,36,10,17,20,0,25,28,8,34,45,7,18,15,26,32,5,43,16,46,21 },
	{ 9,45,2,33,16,42,12,6,36,21,46,25,26,1,28,41,30,4,8,44,11,32,17,35,18,15,20,39,22,27,0,3,40,31,43,13,7,37,10,24,34,19,14,29,38,23,5 },
	{ 34,40,33,26,19,25,0,11,38,44,37,7,29,4,30,23,32,43,18,24,17,10,3,9,39,36,28,21,14,22,13,42,35,41,16,27,2,8,1,46,45,20,15,6,12,5,31 },
	{ 43,8,15,28,17,32,22,4,25,40,30,37,12,38,1,2,45,21,46,9,10,29,16,33,19,34,5,6,41,27,42,13,39,14,3,20,23,11,24,31,36,18,35,0,7,44,26 },
	{ 26,37,20,42,31,32,17,14,4,11,1,39,22,41,28,34,19,44,25,6,8,3,13,43,30,33,16,46,27,36,21,10,0,15,5,35,18,45,24,38,23,40,29,2,12,7,9 },
	{ 0,41,28,34,9,2,43,15,11,16,40,29,8,18,42,22,10,37,17,5,24,19,23,26,36,30,4,45,25,38,13,6,27,31,33,20,44,1,39,12,35,7,46,3,14,32,21 },
	{ 41,17,1,40,16,0,25,9,32,24,8,33,23,45,31,5,22,44,30,4,13,36,12,37,19,3,27,11,18,2,26,10,34,42,35,43,7,21,15,6,20,14,29,38,46,28,39 },
},
{
	/* Frame 68 */
	{ 46,5,34,30,44,22,43,32,28,39,20,41,14,37,25,6,17,12,11,4,3,31,9,23,42,1,38,26,40,18,36,24,35,16,45,10,33,29,2,21,8,15,0,7,27,13,19 },
	{ 27,32,45,36,23,2,15,39,26,21,17,13,37,9,22,14,7,42,20,31,16,12,5,8,1,29,25,6,43,34,30,4,41,0,28,19,24,11,35,46,40,33,44,18,10,3,38 },
	{ 20,17,42,5,30,27,34,15,22,19,7,45,9,12,37,1,4,26,14,39,11,18,41,6,44,3,8,33,29,36,24,0,21,46,16,43,31,38,10,35,40,23,2,32,28,25,13 },
	{ 15,0,39,34,20,27,45,40,46,1,28,35,26,23,41,42,29,2,22,8,4,43,3,31,9,5,10,30,17,36,11,6,16,12,37,32,7,24,13,19,14,33,38,25,21,44,18 },
	{ 46,23,9,16,39,32,25,6,45,11,18,12,34,27,5,28,40,17,14,33,7,30,0,42,19,13,20,35,36,29,2,41,15,22,8,38,31,1,24,43,44,21,10,37,3,26,4 },
	{ 28,34,8,39,5,16,21,37,30,10,15,41,18,44,23,13,24,29,43,1,46,4,17,33,26,36,31,3,6,40,19,35,9,38,12,25,20,42,0,11,14,32,27,45,22,2,7 },
	{ 42,13,1,37,4,41,14,44,3,38,22,43,28,25,5,15,45,27,39,6,29,46,24,20,17,26,7,19,8,21,32,16,10,31,34,18,9,12,33,0,36,11,40,30,35,2,23 },
	{ 45,19,30,39,42,20,25,23,35,15,0,36,41,6,11,16,12,27,5,32,28,2,31,38,43,21,8,44,18,14,1,37,24,22,34,17,13,40,7,10,46,33,29,3,26,4,9 },
	{ 43,23,34,11,2,41,21,32,9,39,0,7,26,37,19,5,28,17,46,22,35,14,3,44,20,33,12,1,24,31,42,18,10,29,40,16,8,38,15,6,45,27,36,13,4,25,30 },
	{ 23,13,21,14,22,12,20,45,46,44,11,27,9,25,10,26,8,24,43,41,42,40,7,31,5,29,6,30,4,28,39,37,38,36,3,19,1,17,2,18,0,16,35,33,34,32,15 },
	{ 30,4,29,14,13,35,41,42,31,36,28,15,18,12,17,2,1,43,37,38,19,44,16,3,26,0,25,10,9,39,45,46,27,32,24,11,22,8,21,6,5,33,34,23,40,20,7 },
	{ 3,15,29,6,32,24,45,30,5,34,43,7,20,33,25,8,31,36,22,35,26,42,38,21,9,16,37,23,12,27,10,18,39,46,40,17,0,13,11,19,2,14,28,41,1,44,4 },
},
{
	/* Frame 69 */
	{ 43,9,42,8,11,21,40,23,10,20,41,22,37,39,36,38,17,5,19,7,16,4,18,6,33,35,29,32,34,28,1,31,3,0,30,2,25,13,46,24,12,27,15,44,26,14,45 },
	{ 9,46,26,44,31,42,29,40,39,19,37,17,35,20,33,6,4,24,10,8,15,13,30,3,1,38,18,36,23,34,21,32,27,45,25,43,28,41,14,12,16,2,0,7,5,22,11 },
	{ 18,26,20,28,19,27,21,29,2,10,4,12,35,43,37,45,3,11,5,13,34,42,36,44,22,30,16,24,23,31,17,25,6,14,0,8,39,33,41,7,15,1,9,38,46,32,40 },
	{ 19,5,6,27,36,12,35,14,3,45,20,43,23,11,25,31,32,18,0,7,41,26,37,9,38,15,29,44,17,46,22,4,24,30,33,13,34,1,2,40,21,42,8,39,10,28,16 },
	{ 31,19,29,17,30,18,28,16,11,3,9,1,42,34,40,32,10,2,8,0,43,35,41,33,27,23,25,21,26,22,24,20,15,7,13,5,46,38,44,36,14,6,12,4,39,45,37 },
	{ 25,35,0,30,44,23,11,16,40,36,29,39,20,27,32,2,12,15,5,8,18,42,1,31,45,6,24,34,17,41,37,28,22,46,10,33,3,13,38,21,26,9,19,43,14,4,7 },
	{ 46,6,42,2,23,19,7,43,3,22,18,32,14,10,31,36,27,33,15,11,30,37,26,40,0,20,17,44,4,41,1,21,16,45,5,38,8,34,28,25,12,39,9,35,29,24,13 },
	{ 15,2,13,36,35,23,26,5,14,18,12,34,39,11,4,9,19,28,1,38,10,20,8,7,43,41,29,0,31,33,21,24,6,42,40,45,16,30,3,32,37,25,22,27,46,44,17 },
	{ 9,42,22,33,29,3,0,19,44,16,14,5,38,26,41,21,11,8,35,31,32,28,2,13,46,18,37,25,7,4,43,23,40,20,10,1,34,30,45,17,15,12,39,27,36,24,6 },
	{ 18,43,1,40,27,24,33,10,7,46,5,44,23,39,28,37,30,19,16,41,2,25,11,34,8,20,45,22,29,14,12,17,3,42,0,26,35,9,32,21,6,4,15,38,13,36,31 },
	{ 41,0,18,9,34,27,24,20,46,23,45,29,39,14,36,13,1,42,19,16,35,10,32,25,21,6,44,5,15,12,30,43,2,40,17,11,33,8,26,7,4,22,28,38,31,37,3 },
	{ 21,24,23,9,38,10,36,41,17,29,18,31,3,46,32,44,35,25,26,39,11,4,40,6,43,19,0,12,34,14,27,20,22,5,8,7,42,37,16,28,30,1,13,2,15,33,45 },
},
{
	/* Frame 70 */
	{ 21,19,22,33,46,34,44,0,25,28,27,30,39,42,5,40,6,23,16,35,12,1,14,2,29,31,43,36,8,7,10,17,20,18,13,32,15,3,45,24,26,37,9,38,11,4,41 },
	{ 39,41,16,11,22,36,2,8,21,46,33,27,7,13,43,24,4,30,38,40,10,23,29,1,35,45,20,15,18,32,6,12,17,42,37,31,3,9,28,0,26,34,44,14,19,25,5 },
	{ 38,46,39,34,42,35,43,6,14,18,26,7,15,19,27,23,31,2,10,22,30,3,11,32,40,36,44,33,41,37,45,0,8,4,12,1,9,5,13,17,25,21,29,16,24,20,28 },
	{ 9,15,29,38,1,6,21,24,45,30,43,13,16,37,19,34,5,8,10,28,41,0,3,20,33,23,44,27,46,12,14,36,18,39,4,7,11,25,40,31,42,2,17,32,22,35,26 },
	{ 9,10,16,41,3,32,24,35,15,21,44,22,29,38,30,4,19,42,8,27,1,2,33,13,14,20,45,7,36,28,39,11,17,40,18,43,25,34,26,0,23,46,12,31,5,6,37 },
	{ 35,24,41,19,36,15,5,9,2,31,39,28,45,6,33,27,42,17,13,22,46,10,0,18,37,14,21,34,25,40,3,30,38,4,8,26,43,16,29,44,7,32,11,1,12,23,20 },
	{ 21,7,20,46,6,45,5,22,44,4,23,35,29,33,15,34,28,32,14,13,30,12,31,43,3,41,1,42,2,40,0,18,16,19,17,11,39,9,10,38,8,37,26,24,36,27,25 },
	{ 14,25,29,11,15,24,28,26,30,8,12,27,31,9,13,42,43,36,40,38,37,41,39,17,21,19,23,16,20,18,22,0,4,2,6,1,5,3,7,46,32,34,44,33,35,45,10 },
	{ 1,38,18,41,29,15,8,35,23,36,16,2,13,42,30,33,21,7,0,27,40,28,14,5,34,22,45,25,11,12,39,19,32,20,6,9,46,26,37,17,3,4,43,31,44,24,10 },
	{ 6,45,10,3,4,25,1,22,44,11,42,2,35,20,13,0,33,23,30,43,18,34,21,46,12,39,16,32,9,31,37,19,26,28,38,17,8,41,14,36,7,27,29,5,24,40,15 },
	{ 31,6,32,15,16,41,46,29,4,26,35,13,19,10,44,7,24,33,38,17,8,22,5,27,2,36,11,20,45,42,25,0,30,39,9,23,14,40,3,28,37,34,21,12,18,43,1 },
	{ 30,32,44,21,25,39,42,37,16,13,3,23,26,4,8,35,15,40,6,29,19,1,45,20,24,38,11,31,33,12,2,22,43,36,17,34,14,27,5,9,28,18,46,0,41,7,10 },
},
{
	/* Frame 71 */
	{ 5,43,17,31,2,44,11,33,12,6,24,19,1,15,20,39,40,35,29,23,46,36,26,8,3,45,4,42,16,30,13,7,25,10,32,21,38,41,18,0,14,37,27,9,34,28,22 },
	{ 33,34,20,6,5,16,29,8,30,43,25,15,26,45,46,32,22,35,21,0,7,18,37,17,38,9,31,10,40,27,12,23,2,1,19,36,39,4,11,28,41,42,13,24,14,44,3 },
	{ 16,28,22,26,17,29,23,27,0,12,38,42,33,45,6,10,1,13,39,43,32,44,7,11,20,24,18,30,21,25,19,31,4,8,34,46,37,41,2,14,5,9,35,36,40,3,15 },
	{ 25,37,14,19,21,24,42,15,18,20,6,43,10,13,17,34,7,46,11,41,12,16,35,2,4,40,9,31,38,3,32,5,45,8,30,39,29,33,0,44,23,27,28,36,1,22,26 },
	{ 40,42,28,8,30,10,41,43,29,9,31,11,32,34,16,0,18,2,33,35,17,1,19,3,44,46,24,12,26,14,45,25,13,27,15,36,38,20,4,22,6,37,39,21,5,23,7 },
	{ 28,32,41,4,27,3,42,33,8,5,44,30,34,43,6,9,36,45,16,31,35,10,7,46,37,12,17,21,11,38,18,13,20,39,14,19,24,0,15,22,25,29,1,40,26,23,2 },
	{ 1,28,33,24,19,14,11,46,17,43,5,9,37,2,41,22,34,27,0,21,32,25,13,7,45,10,39,30,42,4,8,36,29,40,23,18,15,20,16,12,6,44,3,38,31,35,26 },
	{ 6,41,26,39,4,24,37,22,40,46,11,38,3,20,13,25,36,1,23,31,10,2,21,43,12,35,0,45,30,33,18,42,28,34,16,44,9,15,32,7,19,27,29,5,17,8,14 },
	{ 27,33,16,15,4,35,18,44,21,6,1,46,23,37,28,3,8,39,30,32,17,10,5,34,19,41,24,7,12,43,26,36,29,14,9,38,31,45,20,11,0,22,40,25,2,13,42 },
	{ 2,5,28,11,18,44,21,43,31,33,38,0,14,9,16,3,26,36,29,35,19,45,42,12,6,1,24,15,22,40,17,27,37,34,4,10,13,20,7,30,32,25,39,23,41,46,8 },
	{ 46,22,13,0,10,33,6,45,28,17,42,27,9,5,39,31,2,41,24,35,20,15,36,19,1,11,23,12,16,43,26,32,7,44,29,38,30,3,8,4,14,37,18,40,25,34,21 },
	{ 19,27,18,26,23,31,22,30,1,5,11,0,46,4,10,32,15,36,42,33,14,37,43,17,25,21,29,16,24,20,28,39,9,3,13,38,8,2,12,7,40,34,44,6,41,35,45 },
},
{
	/* Frame 72 */
	{ 25,34,40,26,32,31,20,11,24,3,9,45,1,30,37,10,15,2,29,7,8,19,44,0,36,17,14,28,6,18,13,23,5,16,46,43,38,35,12,22,41,4,27,33,21,42,39 },
	{ 27,31,38,12,34,29,36,0,26,19,30,23,45,35,9,28,21,46,33,42,18,22,44,3,8,7,20,25,32,43,5,2,41,6,24,17,11,4,15,40,39,13,16,10,37,14,1 },
	{ 40,41,38,34,44,39,35,45,22,8,18,28,23,9,19,29,6,25,2,12,7,24,3,13,32,33,46,36,42,37,43,0,30,20,26,1,31,21,27,17,14,4,10,16,15,5,11 },
	{ 19,21,34,9,31,18,42,20,39,8,33,30,29,43,17,38,7,32,27,28,46,16,41,6,37,26,25,14,40,3,36,5,24,15,45,2,4,23,10,44,13,1,22,11,35,12,0 },
	{ 8,43,19,32,24,2,1,46,22,45,21,15,4,39,31,40,16,10,9,34,26,33,25,3,12,23,36,28,6,5,42,18,41,17,11,0,35,27,44,20,14,13,38,30,37,29,7 },
	{ 38,27,23,33,12,45,16,26,22,13,36,25,21,31,2,37,24,20,30,3,42,7,29,0,10,43,6,28,1,40,11,34,15,46,19,8,41,4,35,14,39,18,9,32,5,44,17 },
	{ 18,9,27,41,6,29,38,30,2,17,34,26,7,4,39,14,36,3,46,16,35,10,25,42,5,15,37,12,0,44,11,32,24,43,20,23,13,1,45,19,33,8,21,40,22,28,31 },
	{ 29,20,28,4,32,12,40,5,33,13,41,10,19,11,18,36,26,44,2,37,27,45,3,14,42,23,15,43,22,30,6,34,31,7,35,46,17,25,16,24,0,38,8,1,39,9,21 },
	{ 19,37,16,3,0,26,40,21,10,5,34,31,33,28,15,12,43,22,36,17,6,1,46,27,45,24,11,8,39,18,32,29,2,13,42,23,41,20,7,4,35,30,44,25,14,9,38 },
	{ 39,32,16,34,23,12,21,11,26,9,6,33,35,44,20,46,27,8,25,7,30,5,2,45,40,24,42,31,4,29,3,18,1,14,41,43,36,28,38,19,0,17,15,22,13,10,37 },
	{ 1,22,46,4,19,43,21,32,14,16,37,11,13,30,38,8,27,35,29,44,6,24,41,3,5,18,42,0,23,17,36,10,20,33,15,9,26,34,12,31,39,25,40,2,28,45,7 },
	{ 25,13,7,8,22,4,11,38,9,2,23,30,5,42,0,20,39,40,3,45,31,18,43,1,14,21,28,16,41,34,44,19,26,32,15,37,29,17,24,35,12,6,27,33,46,36,10 },
},
{
	/* Frame 73 */
	{ 1,37,3,39,16,18,0,36,2,38,17,19,41,5,43,7,20,22,40,4,42,6,21,23,9,45,11,24,26,8,44,10,46,25,27,33,13,35,15,28,30,32,12,34,14,29,31 },
	{ 20,26,22,9,5,11,7,25,21,27,23,8,4,10,6,41,45,43,40,44,42,46,16,28,18,30,1,13,3,15,17,29,19,31,0,12,2,14,33,37,35,39,32,36,34,38,24 },
	{ 5,34,26,45,17,11,12,39,31,32,24,6,9,46,18,37,29,3,4,43,23,44,16,10,1,38,30,41,21,15,8,35,27,36,28,2,13,42,22,33,25,7,0,19,40,20,14 },
	{ 37,18,20,38,16,40,7,36,3,5,29,1,46,25,6,15,2,45,11,4,35,28,0,24,33,14,44,10,34,13,43,9,32,30,23,26,19,12,42,21,8,39,17,31,41,22,27 },
	{ 29,2,41,36,30,23,0,11,39,28,21,9,37,46,22,10,7,44,20,27,8,5,34,25,6,45,32,26,19,4,15,35,24,17,13,33,42,18,14,3,40,16,31,12,1,43,38 },
	{ 45,34,40,39,12,19,25,6,28,36,42,16,27,21,14,1,44,38,18,24,23,29,3,9,46,33,26,5,31,0,11,35,41,22,13,2,8,7,37,32,43,4,30,17,10,20,15 },
	{ 27,23,36,1,29,26,22,43,0,28,21,19,42,15,25,20,40,18,14,35,24,17,41,12,46,11,34,7,16,44,13,33,10,39,6,31,45,8,32,5,38,3,30,9,37,4,2 },
	{ 42,8,18,11,32,35,26,1,44,20,13,23,37,28,6,31,41,10,17,34,0,25,3,46,12,22,15,36,39,30,5,40,43,16,9,19,33,24,2,27,45,14,21,38,4,29,7 },
	{ 26,22,13,42,17,46,27,23,41,12,35,24,20,30,40,3,34,25,38,21,31,33,2,45,6,39,28,1,32,11,44,7,29,0,10,37,14,18,9,5,36,15,19,8,4,43,16 },
	{ 18,15,27,0,29,32,24,2,23,34,26,1,4,33,8,36,3,40,22,35,10,31,42,5,9,37,12,41,6,44,11,38,30,43,20,17,13,7,45,19,39,14,21,46,16,28,25 },
	{ 37,9,45,0,36,8,44,17,25,16,24,33,31,41,7,32,30,40,6,14,23,15,22,27,3,39,26,2,38,10,46,19,11,18,5,35,13,4,34,12,42,21,29,43,20,28,1 },
	{ 16,43,19,9,14,45,21,46,26,0,3,32,28,39,31,5,10,41,17,42,22,12,15,44,24,35,27,1,6,37,29,38,18,8,11,40,20,23,13,2,33,25,34,30,4,7,36 },
},
{
	/* Frame 74 */
	{ 44,34,1,20,18,6,17,37,43,40,15,24,12,10,31,33,46,5,3,22,0,21,19,39,36,42,9,28,26,14,25,45,35,32,7,16,4,2,23,41,38,13,11,30,8,29,27 },
	{ 27,3,14,33,40,23,28,2,43,32,9,16,29,35,42,5,8,30,17,34,11,4,45,18,31,7,10,37,44,19,24,6,36,13,20,25,39,46,1,12,26,21,38,15,0,41,22 },
	{ 18,43,7,46,27,30,10,0,41,5,44,16,28,35,25,38,19,22,2,31,33,11,36,14,40,20,45,17,29,9,39,12,23,3,42,6,32,26,37,15,21,1,4,8,13,34,24 },
	{ 24,4,10,22,43,9,20,29,26,46,3,23,42,15,8,45,1,21,41,28,27,2,39,14,35,44,0,37,40,13,33,18,38,30,34,7,16,36,25,12,32,5,19,11,31,6,17 },
	{ 11,29,39,14,24,3,17,44,6,20,41,31,36,13,26,33,8,19,46,5,22,43,0,38,15,25,35,10,28,7,21,40,2,16,45,27,32,9,30,37,12,23,42,1,18,4,34 },
	{ 36,22,19,31,41,11,14,4,35,17,38,20,42,9,29,23,33,3,6,40,10,45,15,26,34,1,39,21,8,13,24,32,2,37,7,18,44,30,27,0,5,16,12,43,25,46,28 },
	{ 38,18,32,20,8,43,31,41,2,4,25,15,13,36,16,35,23,27,45,28,0,7,11,9,42,30,39,19,33,21,24,14,40,3,5,34,22,46,26,12,37,17,6,10,44,29,1 },
	{ 43,21,6,46,16,35,31,9,38,26,12,19,1,41,22,4,44,15,33,29,10,36,24,7,17,2,42,20,39,27,13,34,30,8,23,5,45,18,0,40,11,37,25,14,32,28,3 },
	{ 20,30,3,44,25,46,21,31,41,2,37,16,26,22,40,13,36,17,38,27,23,33,12,43,14,39,18,9,32,5,42,15,19,8,4,35,6,28,1,11,34,7,29,0,10,45,24 },
	{ 6,20,45,3,42,17,40,18,37,14,38,12,11,35,24,26,7,46,21,44,22,43,0,19,15,39,28,30,25,32,27,9,4,23,1,2,16,41,29,36,31,13,33,10,34,8,5 },
	{ 23,1,21,2,22,0,20,35,33,34,32,19,15,17,13,18,14,16,12,45,46,44,11,31,9,29,10,30,8,28,43,41,42,40,27,7,25,5,26,6,24,4,39,37,38,36,3 },
	{ 1,28,7,18,41,0,25,6,31,40,42,13,24,3,30,37,43,12,21,2,27,36,38,9,20,15,26,33,39,8,17,14,23,32,34,5,16,11,22,45,35,4,29,10,19,44,46 },
},
{
	/* Frame 75 */
	{ 2,11,36,45,23,30,39,10,5,44,31,16,38,4,13,17,24,7,46,33,12,18,25,6,15,32,41,19,26,35,14,1,40,27,20,34,43,0,9,21,28,3,42,37,8,22,29 },
	{ 44,32,46,2,45,33,35,13,1,15,34,12,0,14,19,23,18,22,17,21,16,20,40,7,42,36,41,6,43,37,9,39,11,5,8,38,10,4,25,29,27,31,24,28,26,30,3 },
	{ 24,3,5,43,19,45,21,10,0,38,26,32,16,15,9,35,31,37,25,2,12,42,18,44,28,7,1,23,41,17,14,4,34,30,36,20,11,13,39,27,33,29,6,8,46,22,40 },
	{ 7,19,37,43,12,24,3,15,8,20,32,39,30,11,44,4,16,29,41,26,22,34,0,13,25,6,18,36,42,9,21,33,2,14,45,5,17,38,31,10,23,35,1,28,40,46,27 },
	{ 15,24,33,19,6,44,26,35,5,46,25,8,7,20,45,27,10,36,22,9,38,21,0,11,28,37,23,2,40,30,39,1,42,29,12,3,16,41,31,14,32,18,43,13,34,17,4 },
	{ 37,41,25,7,11,4,8,45,35,32,19,15,16,12,2,39,43,36,40,23,27,20,24,6,10,44,34,31,1,28,18,14,38,42,5,9,22,26,21,33,46,17,13,3,30,0,29 },
	{ 46,16,39,8,4,29,43,21,18,11,44,6,32,30,23,0,25,17,34,13,5,2,36,26,19,14,41,7,33,31,38,9,1,28,42,20,35,12,10,45,3,37,27,22,15,40,24 },
	{ 20,26,19,44,37,43,2,13,24,17,31,38,41,0,14,7,18,29,36,42,35,12,5,11,16,30,23,40,33,6,9,28,21,27,34,45,4,10,3,22,25,32,46,39,8,1,15 },
	{ 33,3,35,17,19,0,32,2,34,16,18,5,7,45,21,23,4,6,44,20,46,22,26,9,41,11,43,25,27,8,40,10,42,24,30,37,13,39,15,29,31,36,12,38,14,28,1 },
	{ 28,32,11,41,27,6,13,22,46,29,0,35,16,40,7,37,23,14,1,30,34,17,8,43,24,36,15,45,31,2,9,18,42,25,4,39,20,44,3,33,19,10,5,26,38,21,12 },
	{ 2,39,4,35,45,0,37,41,22,33,18,38,20,34,28,16,36,24,23,32,15,19,11,21,29,17,25,14,10,12,43,8,30,7,26,46,3,13,42,5,9,44,1,31,40,6,27 },
	{ 18,2,24,8,35,41,19,3,25,9,34,40,30,6,20,12,39,45,31,7,21,13,38,44,26,10,16,0,43,33,27,11,17,1,42,32,22,14,28,4,37,23,15,29,5,46,36 },
},
{
	/* Frame 76 */
	{ 44,18,43,36,28,35,16,41,14,33,2,12,11,0,7,31,9,19,42,5,29,34,26,17,40,22,32,24,39,20,45,10,37,6,8,15,4,3,27,13,23,46,1,25,38,30,21 },
	{ 15,27,39,40,28,33,25,19,42,6,20,45,17,36,11,30,35,12,9,5,22,2,38,41,29,0,14,26,7,21,44,32,24,18,43,31,34,13,16,37,10,23,46,3,8,4,1 },
	{ 46,5,43,17,12,37,9,28,44,6,41,3,22,38,26,35,31,4,1,20,36,8,33,29,24,40,18,23,27,15,10,0,21,42,16,32,13,25,19,45,7,2,14,39,11,34,30 },
	{ 22,25,33,12,2,42,39,9,15,19,4,35,30,1,44,21,10,29,16,6,40,36,27,13,3,43,23,24,32,18,5,38,8,14,45,20,11,34,31,0,7,41,37,26,28,46,17 },
	{ 10,5,15,32,28,42,22,37,25,19,8,6,13,3,40,20,38,26,45,17,35,31,4,14,1,11,36,24,46,18,33,29,43,23,12,2,9,7,44,16,34,30,41,21,39,27,0 },
	{ 18,36,0,39,11,24,27,35,22,4,7,41,28,42,31,3,16,19,45,9,46,10,25,33,20,34,23,13,14,40,29,37,1,38,2,17,26,44,8,5,6,32,21,43,30,12,15 },
	{ 39,24,26,29,32,31,13,0,19,5,6,20,41,25,36,27,9,33,14,34,12,1,2,16,45,7,42,21,40,22,37,10,38,8,15,35,28,30,3,46,17,44,18,43,4,23,11 },
	{ 25,37,14,28,32,43,7,21,46,2,16,27,39,13,30,34,8,23,45,1,18,40,4,15,29,33,10,24,36,3,17,42,6,20,31,35,9,26,38,12,19,41,5,22,44,0,11 },
	{ 33,13,41,21,29,4,32,12,40,20,28,1,9,39,17,25,0,8,38,16,46,24,30,7,35,15,43,23,31,6,34,14,42,22,26,37,3,45,11,19,27,36,2,44,10,18,5 },
	{ 29,4,46,1,18,43,32,31,6,20,45,3,17,8,34,5,22,36,19,10,24,33,7,21,12,38,9,26,35,40,23,14,28,37,11,25,0,42,13,30,39,44,27,2,16,41,15 },
	{ 28,10,31,24,37,27,33,46,29,42,30,25,4,26,7,0,3,44,43,40,5,6,1,20,2,23,16,45,19,41,38,21,34,22,17,12,18,15,8,11,39,36,35,32,13,14,9 },
	{ 24,41,6,13,26,43,17,36,15,8,19,34,20,45,10,1,22,29,40,3,12,31,38,16,33,14,5,18,35,25,44,7,0,27,42,28,37,2,9,30,39,21,32,11,4,23,46 },
},
{
	/* Frame 77 */
	{ 43,9,29,42,8,28,11,31,40,10,30,41,17,19,13,16,46,18,12,15,44,14,45,1,21,3,23,0,20,2,22,32,34,33,35,5,25,7,4,24,6,27,36,38,26,37,39 },
	{ 7,16,20,19,23,1,5,2,6,17,21,18,22,0,4,35,33,45,34,46,32,44,11,15,24,28,27,31,9,13,10,14,25,29,26,30,8,12,43,39,41,37,42,38,40,36,3 },
	{ 33,39,17,1,23,7,32,38,16,0,22,6,41,25,9,31,15,40,46,24,8,30,14,37,35,21,5,19,3,36,34,20,4,18,2,45,43,29,13,27,11,44,42,28,12,26,10 },
	{ 0,12,34,5,2,31,7,16,46,13,4,43,18,11,6,17,24,20,42,19,44,10,37,22,15,25,39,21,28,45,26,36,23,40,14,33,8,38,1,29,35,27,3,41,30,32,9 },
	{ 22,5,10,39,25,3,44,0,31,28,42,6,41,17,26,13,32,23,20,11,38,8,37,18,1,14,35,29,7,40,4,27,24,46,2,45,21,30,9,36,43,19,16,15,34,12,33 },
	{ 43,19,14,4,25,1,35,30,6,44,41,17,28,46,22,10,36,33,13,20,38,26,2,15,5,8,42,18,31,7,45,24,0,34,23,11,37,40,16,29,39,27,3,32,12,21,9 },
	{ 31,41,8,36,5,34,3,30,44,9,43,4,39,2,17,45,12,42,11,38,7,16,13,10,6,21,19,46,15,25,20,18,33,14,24,27,23,32,1,29,26,40,22,37,0,35,28 },
	{ 38,0,13,30,17,37,2,15,19,39,32,12,16,21,34,14,9,18,23,33,44,11,20,35,46,8,5,22,25,45,10,7,27,40,4,24,29,42,6,1,26,31,41,36,3,28,43 },
	{ 14,27,5,20,42,33,15,18,4,25,43,40,2,19,13,24,38,41,3,30,12,17,39,36,10,31,1,16,46,37,11,22,0,29,44,6,23,9,28,34,45,7,26,8,21,35,32 },
	{ 21,17,20,46,16,43,5,1,42,4,0,29,25,28,24,37,13,33,9,36,12,32,8,19,7,18,6,45,3,41,22,44,2,40,23,27,39,15,26,38,14,35,11,30,34,10,31 },
	{ 39,2,16,35,4,23,26,44,25,13,40,14,43,28,3,36,17,18,5,32,6,20,27,45,8,46,11,41,30,42,29,37,0,38,19,33,7,34,21,22,9,10,24,31,12,15,1 },
	{ 18,17,31,12,33,3,44,20,26,25,6,41,5,11,38,28,19,0,14,35,13,32,46,22,21,27,8,37,43,7,40,16,30,29,2,45,1,15,34,24,23,4,10,39,9,36,42 },
},
{
	/* Frame 78 */
	{ 23,43,46,8,44,10,19,28,30,7,0,36,34,39,20,24,26,9,12,11,14,41,29,16,31,1,4,2,38,33,21,25,22,27,13,42,15,40,45,17,18,5,3,6,32,37,35 },
	{ 8,21,28,39,42,0,45,30,20,38,11,33,44,22,31,3,10,32,13,23,25,2,5,12,17,24,35,46,4,41,26,16,34,15,37,40,18,27,7,14,36,9,19,29,6,43,1 },
	{ 21,32,0,20,33,1,37,5,17,36,4,16,29,40,8,28,41,9,45,13,25,44,12,24,19,23,18,22,35,3,39,7,34,2,38,6,27,31,26,30,43,11,15,42,10,46,14 },
	{ 38,10,6,15,37,25,5,32,28,39,26,46,7,34,14,43,8,16,33,29,27,18,35,30,42,9,44,17,12,20,19,31,22,45,0,13,40,21,2,11,23,1,36,24,41,4,3 },
	{ 40,4,13,18,31,32,43,5,24,19,14,35,42,20,25,6,15,45,34,21,8,7,26,37,44,0,9,22,27,36,1,28,23,10,39,46,16,29,2,11,41,38,17,12,3,30,33 },
	{ 37,16,41,29,34,7,11,1,12,23,39,18,43,14,33,21,44,25,3,30,46,4,8,28,35,6,27,36,17,40,13,22,38,10,0,20,45,24,19,42,15,32,5,9,2,31,26 },
	{ 13,32,16,39,23,43,27,28,0,40,7,11,34,18,36,20,8,31,2,4,44,25,15,38,22,42,26,12,33,17,41,6,10,29,1,9,46,30,35,19,37,21,45,24,14,3,5 },
	{ 39,41,45,34,38,40,44,2,6,8,12,3,7,9,13,18,30,24,20,19,31,25,21,43,33,37,42,46,32,36,10,14,0,4,11,15,1,5,26,22,16,28,27,23,17,29,35 },
	{ 6,27,9,16,34,45,7,18,8,29,35,36,10,19,1,28,46,37,11,30,0,21,40,2,31,13,20,38,41,3,22,12,25,39,32,14,23,5,24,42,33,15,26,4,17,43,44 },
	{ 13,26,6,43,0,41,28,37,10,34,23,17,3,30,8,4,45,18,14,38,25,32,21,7,42,1,12,27,35,22,16,40,29,36,11,9,46,5,2,31,39,24,33,20,44,19,15 },
	{ 29,8,34,25,6,45,31,10,20,33,27,5,16,36,9,22,35,40,7,18,12,38,11,21,0,42,17,14,37,23,2,28,41,19,13,24,39,44,1,30,43,32,15,26,4,46,3 },
	{ 27,6,9,16,34,45,32,26,23,8,5,33,15,22,25,4,43,14,3,24,21,42,39,40,31,2,13,20,38,41,36,30,19,12,1,37,11,18,29,0,10,7,28,17,46,35,44 },
},
{
	/* Frame 79 */
	{ 5,45,25,35,10,30,19,13,1,43,6,27,32,9,20,39,14,3,23,40,36,28,16,34,11,31,4,44,24,42,7,18,12,0,21,38,15,26,33,8,37,29,17,46,2,22,41 },
	{ 13,11,15,8,12,10,14,41,45,43,40,44,42,46,25,23,27,24,22,26,21,20,3,7,32,36,2,6,33,37,35,39,1,5,34,38,0,4,19,29,31,18,28,30,17,16,9 },
	{ 39,20,0,19,7,33,38,21,1,18,6,32,28,8,27,15,41,46,29,9,26,14,40,35,16,4,23,3,37,34,17,5,22,2,36,43,24,12,31,11,45,42,25,13,30,10,44 },
	{ 1,28,10,45,6,37,16,12,46,27,34,23,15,40,24,4,2,43,30,8,32,21,38,19,11,44,7,0,29,26,35,22,36,17,13,5,3,14,41,25,33,20,39,18,42,31,9 },
	{ 28,45,31,38,5,10,25,32,22,35,12,15,16,37,19,42,9,2,21,44,30,4,7,24,41,27,34,1,14,29,36,18,39,8,11,20,33,23,46,13,6,17,40,26,43,0,3 },
	{ 46,7,12,17,11,2,38,13,4,42,3,8,39,44,5,30,43,34,9,0,45,36,31,22,29,35,40,1,26,37,23,28,21,41,32,27,18,20,14,33,19,24,15,6,25,16,10 },
	{ 46,20,23,0,41,3,43,17,38,13,15,24,32,26,35,8,4,45,7,21,18,1,40,28,36,30,39,12,10,25,33,27,22,5,44,2,42,16,19,14,29,37,31,34,9,11,6 },
	{ 12,17,10,29,6,27,32,23,44,16,42,28,9,38,26,5,33,22,3,45,15,43,8,39,4,25,2,21,14,19,40,31,36,24,34,20,1,46,18,13,41,30,11,37,7,35,0 },
	{ 17,42,33,11,27,0,16,43,32,10,26,5,29,46,37,15,23,4,28,36,14,22,9,25,34,41,3,19,8,24,35,40,2,18,13,21,38,45,7,31,12,20,39,44,6,30,1 },
	{ 27,7,37,26,6,36,38,25,5,39,24,4,23,15,45,22,14,44,46,21,13,20,12,31,3,33,30,2,32,34,29,1,35,28,0,19,11,41,18,10,40,42,17,9,43,16,8 },
	{ 44,24,30,43,2,21,32,7,8,29,19,36,22,35,11,13,0,39,5,26,41,14,17,3,20,33,45,25,31,42,28,18,37,6,9,46,12,1,23,34,10,40,15,16,38,4,27 },
	{ 16,24,22,30,17,25,23,31,4,8,2,14,37,41,35,5,9,3,15,36,40,34,46,20,28,18,26,21,29,19,27,0,12,6,10,33,45,39,43,1,13,7,11,32,44,38,42 },
},
{
	/* Frame 80 */
	{ 36,8,6,31,42,23,5,40,45,38,30,3,43,22,15,4,29,1,41,21,44,39,2,27,14,19,28,0,25,20,13,17,34,26,46,18,11,32,24,37,12,16,9,35,7,10,33 },
	{ 21,27,0,40,39,25,42,32,30,18,12,23,34,11,16,4,44,9,3,29,14,36,1,41,6,46,20,26,33,31,19,13,38,24,43,17,5,45,22,35,10,15,37,8,2,28,7 },
	{ 36,19,32,6,37,18,33,7,3,23,2,22,44,27,40,14,45,26,41,15,11,31,10,30,4,38,0,5,39,1,35,21,17,34,20,16,12,46,8,13,9,43,29,25,42,28,24 },
	{ 32,11,38,22,17,45,29,26,6,46,1,13,36,20,40,18,14,35,25,43,4,2,31,9,16,44,28,33,10,39,23,0,12,27,7,15,34,24,37,21,41,19,30,8,42,5,3 },
	{ 18,13,24,39,41,2,31,12,17,38,40,11,30,1,16,37,10,23,0,29,46,36,7,22,9,28,35,45,6,27,8,21,34,44,15,26,5,20,43,33,14,19,4,25,42,32,3 },
	{ 38,21,31,33,2,43,24,20,30,3,34,17,27,23,12,35,16,26,22,13,44,15,19,8,4,45,14,18,9,40,5,36,7,46,29,0,41,10,37,6,39,28,1,32,11,42,25 },
	{ 6,30,45,3,32,27,40,18,4,38,12,1,35,24,16,7,36,31,44,22,33,10,19,5,39,28,20,25,42,17,9,37,14,23,11,2,26,41,29,46,21,13,43,0,34,8,15 },
	{ 37,38,36,6,18,4,16,7,19,5,17,43,41,42,40,22,10,20,8,23,11,21,9,45,46,44,14,26,12,24,15,27,13,25,35,33,34,32,30,2,28,0,31,3,29,1,39 },
	{ 25,46,45,15,27,12,24,44,14,26,9,21,42,41,11,23,8,20,43,40,10,22,5,17,38,37,7,19,4,16,39,36,6,18,1,29,34,33,3,31,0,28,35,32,2,30,13 },
	{ 22,46,1,31,39,8,14,29,32,7,20,41,26,34,5,19,43,12,2,17,36,11,24,45,30,38,9,23,0,6,21,40,15,28,33,18,42,13,27,35,4,10,25,44,3,16,37 },
	{ 3,12,10,5,15,34,24,6,43,17,46,27,28,40,39,18,21,33,31,36,8,22,45,1,11,4,2,13,7,42,16,14,35,25,38,19,20,32,26,29,41,23,44,0,30,37,9 },
	{ 22,8,35,15,20,19,42,33,13,30,17,2,36,28,27,0,45,7,25,34,14,5,40,18,12,39,11,16,23,46,37,9,26,21,6,43,32,24,31,4,41,3,29,38,10,1,44 },
},
{
	/* Frame 81 */
	{ 41,45,43,40,44,42,46,27,31,9,13,11,15,24,28,26,30,8,12,10,14,25,29,33,37,35,39,32,36,34,38,19,23,1,5,3,7,16,20,18,22,0,4,2,6,17,21 },
	{ 46,18,45,17,6,5,43,23,36,24,11,12,34,30,33,29,2,1,19,40,20,7,8,38,26,37,25,14,13,35,31,44,16,3,4,42,22,41,21,10,9,39,27,32,28,15,0 },
	{ 7,4,30,39,13,46,18,45,1,27,34,24,33,23,40,20,10,29,36,6,17,15,12,3,0,26,35,9,42,22,41,5,31,38,28,37,19,44,16,14,25,32,2,21,11,8,43 },
	{ 39,26,37,25,11,8,38,27,36,24,10,41,7,5,23,43,21,40,6,4,22,42,20,3,45,1,19,17,2,44,0,18,16,46,35,13,33,30,29,15,34,12,32,31,28,14,9 },
	{ 4,24,2,30,5,25,3,31,37,35,36,34,16,8,22,14,17,9,23,15,41,40,46,0,28,6,26,1,29,7,27,33,39,32,38,20,12,18,10,21,13,19,11,45,43,44,42 },
	{ 4,9,12,32,40,7,27,30,35,5,25,13,33,46,41,10,31,18,24,29,16,11,14,19,22,42,28,17,20,38,15,2,23,43,36,44,0,21,8,39,3,6,26,37,34,45,1 },
	{ 24,8,26,10,41,43,25,9,27,11,40,42,20,0,22,2,33,35,21,1,23,3,32,34,28,12,30,14,45,29,13,31,15,44,46,16,4,18,6,37,39,17,5,19,7,36,38 },
	{ 9,12,25,20,0,5,11,39,14,27,2,22,29,32,24,37,1,40,4,45,17,15,34,26,31,3,42,6,19,28,33,8,36,13,41,21,44,16,35,10,38,30,43,7,46,18,23 },
	{ 27,25,43,11,41,9,26,24,42,10,40,8,36,19,17,3,39,1,37,18,16,2,38,0,44,12,31,29,15,45,13,30,28,46,14,4,23,35,21,33,7,5,22,34,20,32,6 },
	{ 4,46,28,3,33,10,6,13,41,16,34,25,22,37,15,1,42,19,8,45,20,31,39,29,2,32,26,5,12,40,17,11,7,36,14,0,35,24,23,44,21,30,38,43,18,9,27 },
	{ 42,6,46,18,22,3,43,7,19,23,10,14,32,26,37,30,11,15,33,27,36,31,20,0,40,5,45,16,21,1,41,4,44,17,28,34,8,38,13,24,29,35,9,39,12,25,2 },
	{ 27,40,25,42,45,14,12,19,1,16,34,33,21,6,36,41,10,8,15,30,13,28,17,2,32,7,22,4,39,11,26,9,24,43,31,44,29,46,3,18,0,35,23,5,20,38,37 },
},
{
	/* Frame 82 */
	{ 13,43,30,40,29,27,24,44,10,23,33,20,6,37,3,0,15,12,42,9,26,46,25,5,35,22,32,21,19,39,16,36,2,31,41,28,14,45,11,8,7,4,34,1,18,38,17 },
	{ 45,24,42,23,0,11,40,21,35,18,9,14,33,16,38,27,12,3,36,25,43,30,1,6,41,28,46,19,4,15,44,17,39,22,13,10,37,20,34,31,8,7,32,29,26,5,2 },
	{ 1,3,17,27,36,8,10,5,6,21,33,12,35,30,18,40,16,42,37,9,38,11,25,7,44,20,23,13,14,29,19,41,0,43,2,39,26,24,45,4,46,22,15,32,28,34,31 },
	{ 16,3,39,1,37,19,17,2,38,0,36,22,20,35,7,33,5,23,21,34,6,32,4,9,45,26,25,11,8,44,27,24,10,46,41,13,30,29,43,15,40,12,31,28,42,14,18 },
	{ 18,29,12,5,11,35,44,16,30,23,6,9,33,38,28,21,27,4,10,3,45,36,42,22,25,8,1,15,39,40,20,26,19,2,13,37,43,34,24,17,31,0,14,7,41,32,46 },
	{ 26,23,45,31,9,40,20,12,11,22,30,36,25,41,0,46,13,38,10,43,2,15,37,24,1,32,29,39,4,42,3,34,14,6,17,33,28,5,19,35,27,7,44,16,8,21,18 },
	{ 31,15,25,9,30,14,24,8,46,40,41,19,7,21,1,18,6,20,0,38,32,39,33,27,11,29,13,26,10,28,12,42,44,43,45,23,3,17,5,22,2,16,4,34,36,35,37 },
	{ 8,22,15,36,43,0,34,13,7,26,46,5,29,41,18,11,32,31,21,39,24,3,44,23,14,37,42,16,9,6,27,1,35,12,40,19,10,4,28,38,25,2,45,33,30,20,17 },
	{ 44,4,17,21,41,1,45,5,16,20,40,0,12,25,35,29,39,9,13,24,34,28,38,8,19,23,43,3,7,18,22,42,2,46,6,36,27,31,11,33,15,37,26,30,10,32,14 },
	{ 9,31,1,6,8,30,0,23,25,14,17,22,24,15,16,39,35,38,34,46,42,43,13,3,5,27,12,2,4,26,29,19,21,10,28,18,20,11,45,41,37,33,44,40,36,32,7 },
	{ 24,2,26,32,34,1,25,3,27,33,35,8,20,10,22,40,42,9,21,11,23,41,43,4,28,6,30,36,38,5,29,7,31,37,39,12,16,14,18,44,46,13,17,15,19,45,0 },
	{ 2,5,27,9,14,34,18,37,21,41,25,43,30,12,1,7,10,44,28,33,17,39,23,4,26,8,46,3,36,20,40,24,15,35,19,0,6,42,31,13,32,16,38,22,11,45,29 },
},
{
	/* Frame 83 */
	{ 29,6,43,32,9,19,21,28,35,42,1,8,20,34,11,0,45,30,3,10,37,44,22,31,25,2,36,13,23,17,24,39,46,5,12,16,38,15,4,41,26,7,14,33,40,18,27 },
	{ 20,11,23,41,14,44,28,35,31,32,38,26,5,6,10,40,43,13,17,46,18,34,30,1,2,4,25,7,37,9,21,42,22,12,16,15,19,45,0,29,3,33,24,39,27,36,8 },
	{ 5,27,38,24,37,43,19,40,16,10,35,29,32,2,21,15,12,7,4,26,9,42,18,41,1,31,34,28,33,23,44,20,14,39,25,36,6,17,11,8,3,0,30,13,46,22,45 },
	{ 5,17,6,18,20,33,34,13,25,15,27,28,41,37,43,38,1,23,2,4,16,45,32,9,30,11,12,24,14,40,36,42,7,19,21,0,22,35,44,46,26,29,8,31,10,39,3 },
	{ 35,37,34,36,31,3,25,5,30,2,24,4,43,45,42,44,19,11,21,13,18,10,20,12,39,33,38,32,27,7,29,1,26,6,28,0,41,46,40,23,15,17,9,22,14,16,8 },
	{ 12,11,31,40,39,4,3,23,32,29,26,15,43,18,7,17,46,35,45,10,30,9,38,37,2,22,1,21,14,24,13,42,41,6,16,5,34,44,33,8,28,27,36,0,20,19,25 },
	{ 13,6,21,36,30,43,0,3,24,45,27,46,5,10,29,40,18,35,12,15,20,37,23,38,9,2,17,32,26,4,7,28,41,31,42,1,14,25,44,22,39,8,11,16,33,19,34 },
	{ 39,36,28,21,14,22,13,35,41,32,1,10,18,24,17,46,45,20,15,6,12,5,31,33,42,11,2,8,16,27,38,44,37,7,29,4,30,23,43,34,40,3,9,0,26,19,25 },
	{ 39,2,43,14,45,8,21,3,46,15,9,20,28,10,23,17,29,32,11,22,16,24,33,4,19,31,34,25,36,5,40,18,30,35,6,37,0,41,12,27,38,7,42,1,44,13,26 },
	{ 0,22,40,5,19,12,30,39,9,27,34,20,43,6,17,46,3,28,37,10,25,32,15,41,4,18,44,1,23,8,26,35,13,31,38,16,2,21,42,7,24,33,14,29,36,11,45 },
	{ 45,17,40,13,8,46,19,42,14,33,10,1,28,35,25,3,23,27,36,16,41,4,9,39,18,43,7,11,31,21,44,24,12,22,26,37,15,32,5,0,38,29,34,6,2,30,20 },
	{ 3,17,11,2,16,10,25,34,42,24,35,43,23,7,31,15,22,6,30,14,38,46,39,19,41,27,1,18,40,26,0,9,32,8,33,45,21,5,44,20,4,29,13,36,28,12,37 },
},
{
	/* Frame 84 */
	{ 14,5,25,34,12,22,11,32,39,31,20,9,42,37,6,26,17,40,4,24,3,45,23,10,1,29,38,8,18,15,36,35,27,16,13,46,33,2,30,21,44,43,0,28,7,41,19 },
	{ 13,30,0,21,4,24,46,28,35,7,44,31,40,5,29,10,38,18,45,41,36,32,11,39,19,2,9,26,37,17,33,42,14,3,22,8,27,12,16,1,20,43,25,15,34,23,6 },
	{ 1,3,17,29,30,39,12,21,41,22,43,4,33,26,35,24,18,16,44,31,13,36,14,23,5,6,27,8,10,19,0,45,2,46,28,37,15,38,20,40,7,42,9,32,11,34,25 },
	{ 20,11,23,24,4,40,42,13,3,15,17,28,33,34,36,26,7,8,21,10,45,18,30,1,12,2,14,39,32,22,25,5,27,6,41,43,44,46,16,29,19,31,0,35,37,38,9 },
	{ 38,23,1,16,40,25,14,37,3,18,4,42,27,13,28,39,32,17,6,41,15,30,8,34,19,5,20,43,44,29,10,33,7,22,0,46,31,9,24,35,36,21,2,45,11,26,12 },
	{ 24,41,31,13,16,33,23,44,5,43,8,15,36,28,39,0,3,20,25,40,26,12,17,32,18,35,4,46,7,10,29,38,30,2,21,22,45,27,42,9,14,37,19,34,1,6,11 },
	{ 30,42,5,35,29,8,7,16,32,31,10,45,18,34,9,17,0,11,24,44,19,2,37,26,46,1,39,25,12,3,20,36,27,14,41,22,38,13,43,21,4,15,28,40,23,6,33 },
	{ 38,21,24,33,44,3,14,17,42,37,9,22,0,13,7,26,35,46,29,19,41,11,4,25,32,45,2,30,39,20,8,23,15,16,43,36,6,27,34,1,12,40,10,5,28,18,31 },
	{ 28,43,10,23,17,34,29,46,11,40,22,16,35,2,14,41,8,21,38,3,32,15,44,9,20,39,6,33,0,45,12,27,7,36,1,13,26,24,37,4,19,31,25,42,5,18,30 },
	{ 1,15,3,12,0,14,2,45,33,35,44,32,46,34,29,25,31,27,28,24,30,26,5,9,7,11,4,8,6,10,37,41,39,43,36,40,38,42,21,17,23,19,20,16,22,18,13 },
	{ 37,28,46,19,12,3,40,21,43,30,5,14,45,16,34,27,0,11,36,29,39,18,13,2,33,24,42,23,8,7,44,17,26,1,10,41,20,38,31,4,15,32,25,35,22,9,6 },
	{ 9,37,29,12,10,24,39,30,46,40,0,13,20,11,25,2,31,14,22,41,26,1,44,21,4,3,16,15,23,6,27,32,18,45,5,34,17,43,7,33,19,8,36,28,35,42,38 },
},
{
	/* Frame 85 */
	{ 17,21,19,23,16,20,18,22,33,37,35,39,32,36,34,38,1,5,3,7,0,4,2,6,25,29,24,28,27,31,26,30,43,9,13,42,46,8,12,11,15,40,44,10,14,41,45 },
	{ 44,24,10,12,43,31,41,29,3,1,38,22,32,20,6,8,27,45,25,15,13,42,18,36,16,2,4,35,23,33,21,11,9,46,30,40,28,14,0,39,19,37,17,7,5,34,26 },
	{ 21,29,23,31,20,28,22,30,5,13,7,15,36,44,38,46,4,12,6,14,37,45,39,17,25,19,27,16,24,18,26,1,9,3,11,32,40,34,42,0,8,2,10,33,41,35,43 },
	{ 8,11,37,24,39,27,9,10,36,25,38,30,12,15,33,28,35,31,13,14,32,29,34,16,18,44,1,3,17,19,45,0,46,2,20,22,40,5,43,7,21,23,41,4,42,6,26 },
	{ 7,27,5,25,38,36,6,26,4,24,39,37,19,11,17,9,42,40,18,10,16,8,43,41,3,31,1,29,34,32,2,30,0,28,35,33,23,15,21,13,46,44,22,14,20,12,45 },
	{ 5,3,28,10,4,2,29,27,21,19,13,26,20,18,12,43,35,39,42,46,34,38,1,15,24,7,0,14,25,6,17,31,9,23,16,30,8,22,33,37,32,36,41,45,40,44,11 },
	{ 24,0,30,6,33,39,25,1,31,7,32,38,20,8,18,14,41,21,9,19,15,40,46,28,4,26,2,37,35,29,5,27,3,36,34,16,12,22,10,45,43,17,13,23,11,44,42 },
	{ 5,8,23,43,41,29,16,31,34,39,4,24,22,42,40,45,1,30,19,38,25,7,27,46,44,0,15,18,13,33,6,26,21,14,3,12,32,37,11,20,9,2,28,17,36,35,10 },
	{ 45,43,29,13,27,11,44,42,28,12,26,10,37,35,17,5,23,3,36,34,16,4,22,2,41,25,9,31,15,40,46,24,8,30,14,33,39,21,1,19,7,32,38,20,0,18,6 },
	{ 19,1,43,2,25,26,35,8,23,45,4,6,37,30,39,28,16,3,40,27,9,32,10,5,7,21,31,12,14,17,18,41,0,42,24,33,11,34,22,44,20,46,13,36,15,38,29 },
	{ 40,16,43,19,8,11,33,25,5,7,44,28,38,30,12,0,3,41,17,34,26,9,20,46,22,4,14,37,29,39,31,42,18,1,10,32,24,35,27,6,45,21,23,13,15,36,2 },
	{ 21,23,38,12,36,14,17,27,18,3,8,32,42,35,28,30,39,13,4,15,6,45,19,24,9,0,10,34,41,29,20,31,22,5,46,7,44,37,25,16,26,1,11,2,40,33,43 },
},
{
	/* Frame 86 */
	{ 39,5,19,6,33,34,23,0,25,12,27,14,29,42,31,40,36,7,16,35,1,20,2,13,15,45,43,8,10,37,38,17,4,18,32,21,3,22,46,24,44,26,9,28,11,30,41 },
	{ 30,0,6,44,29,42,19,5,15,41,24,35,22,12,10,32,21,38,31,9,7,37,16,43,26,4,2,40,25,46,23,1,11,45,28,39,18,8,14,36,17,34,27,13,3,33,20 },
	{ 33,41,32,40,35,43,34,42,19,27,1,9,18,26,0,8,3,11,16,24,2,10,17,25,37,45,39,36,44,38,46,5,13,7,15,4,12,6,14,20,28,22,30,21,29,23,31 },
	{ 36,2,38,16,18,1,37,3,39,17,19,4,32,6,34,20,22,5,33,7,35,21,23,26,8,44,11,24,27,9,45,10,46,25,30,12,40,15,43,28,31,13,41,14,42,29,0 },
	{ 17,18,24,11,34,40,0,43,23,29,30,5,46,6,12,37,27,16,3,9,32,10,35,41,21,22,28,15,38,44,4,19,25,26,1,42,2,8,33,31,20,7,13,36,14,39,45 },
	{ 16,42,25,17,43,9,35,1,8,34,0,28,20,29,21,13,45,5,37,12,44,4,36,18,10,19,11,3,41,26,33,2,40,27,32,22,14,46,23,15,7,39,30,6,38,31,24 },
	{ 27,3,25,1,26,2,24,0,34,32,35,33,23,11,21,9,22,10,20,8,42,40,43,41,31,7,29,5,30,6,28,4,38,36,39,37,19,15,17,13,18,14,16,12,46,44,45 },
	{ 4,2,6,1,5,3,7,16,20,18,22,17,21,19,23,32,46,34,33,35,44,45,10,14,25,29,11,15,24,28,26,30,8,12,27,31,9,13,42,36,38,43,37,39,40,41,0 },
	{ 37,39,29,5,31,7,36,38,28,4,30,6,45,17,13,19,15,44,46,16,12,18,14,33,35,25,1,27,3,32,34,24,0,26,2,41,43,21,9,23,11,40,42,20,8,22,10 },
	{ 18,4,11,44,37,17,6,24,39,19,20,10,45,40,36,33,22,25,15,38,35,21,26,28,41,32,23,8,14,1,34,27,29,3,9,30,0,46,43,12,2,5,31,16,7,42,13 },
	{ 30,38,25,33,14,9,23,28,36,3,12,18,42,21,45,6,1,31,39,16,40,15,4,26,34,29,37,10,13,19,43,24,32,7,8,22,46,17,41,2,5,27,35,20,44,11,0 },
	{ 24,32,11,21,31,39,12,37,16,43,3,23,4,14,27,35,9,28,46,6,19,41,1,10,20,30,38,44,25,33,42,2,22,13,36,17,26,34,8,5,15,18,40,0,29,7,45 },
},
{
	/* Frame 87 */
	{ 19,43,1,31,20,44,39,35,11,23,36,12,24,3,15,4,16,40,29,7,46,26,32,8,21,45,38,18,42,0,30,37,13,25,34,10,22,5,17,41,2,14,27,33,9,28,6 },
	{ 20,1,23,2,4,7,37,41,11,28,44,25,12,26,0,3,33,39,17,36,18,40,43,29,8,30,46,13,27,14,35,21,32,22,38,16,5,19,6,42,9,31,10,45,15,24,34 },
	{ 21,25,23,27,20,24,22,26,39,43,5,9,7,11,36,40,38,42,4,8,6,10,37,41,17,29,19,31,16,28,18,30,35,1,13,3,15,32,44,34,46,0,12,2,14,33,45 },
	{ 3,0,34,22,21,45,6,11,9,42,30,28,14,38,18,33,17,2,5,23,46,26,40,24,10,12,37,31,29,1,35,19,32,20,44,7,4,8,43,27,41,25,15,39,13,36,16 },
	{ 32,34,28,0,30,2,33,35,29,1,31,3,40,42,16,8,18,10,41,43,17,9,19,11,36,38,24,4,26,6,37,39,25,5,27,7,44,46,20,12,22,14,45,21,13,23,15 },
	{ 29,0,14,18,12,16,30,3,28,1,15,19,13,17,31,34,38,32,36,35,39,33,37,25,6,10,4,8,22,26,20,24,7,11,5,9,23,27,21,42,46,40,44,43,41,45,2 },
	{ 5,10,21,44,26,39,8,15,24,37,31,34,13,6,29,32,22,4,3,20,45,19,42,1,14,17,40,30,35,12,11,28,33,27,38,9,2,25,36,18,43,0,7,16,41,23,46 },
	{ 43,12,37,16,45,30,38,3,42,28,36,1,44,9,15,23,2,27,29,35,21,0,8,14,33,22,41,26,34,20,24,32,7,40,46,11,19,5,13,25,17,6,31,10,39,18,4 },
	{ 29,8,27,14,33,39,16,9,30,15,32,38,17,4,31,10,45,35,20,5,18,11,44,34,21,0,19,6,41,24,1,22,7,40,46,25,12,23,2,37,43,28,13,26,3,36,42 },
	{ 39,24,32,31,6,9,16,46,23,41,5,34,37,26,12,11,18,25,0,7,17,40,14,35,28,36,27,2,13,20,42,19,45,1,38,33,30,8,15,22,29,4,3,21,43,44,10 },
	{ 23,37,12,17,27,32,22,44,13,39,16,26,33,8,45,4,38,15,19,40,9,34,5,14,18,41,0,35,10,46,7,29,1,42,11,6,28,31,43,2,25,21,30,36,3,24,20 },
	{ 25,19,29,24,18,28,23,22,1,9,5,13,0,8,4,12,32,40,36,44,33,41,37,45,17,21,27,16,20,26,31,30,39,3,11,38,46,2,10,7,15,34,42,6,14,35,43 },
},
{
	/* Frame 88 */
	{ 9,34,45,30,10,32,15,20,29,8,3,44,1,14,37,28,2,13,7,19,0,46,36,43,17,12,6,41,18,27,23,5,42,16,25,38,40,35,26,22,31,4,11,33,24,21,39 },
	{ 11,6,2,24,9,4,23,33,42,46,21,3,8,44,22,1,18,43,31,20,34,38,29,45,0,19,36,30,15,26,35,17,39,28,13,40,37,14,27,10,16,7,12,25,41,5,32 },
	{ 33,32,35,45,34,44,46,19,29,1,31,18,28,0,30,3,13,16,15,2,12,17,14,41,40,37,43,39,36,42,38,21,27,23,9,20,26,22,8,5,11,7,24,4,10,6,25 },
	{ 34,24,33,10,12,31,45,29,16,3,42,4,38,22,37,21,8,27,35,25,15,13,46,0,40,18,17,6,5,39,23,32,11,9,30,44,28,14,2,43,1,41,19,36,20,7,26 },
	{ 0,35,19,40,24,10,9,38,22,37,21,7,12,31,32,16,2,1,42,26,41,25,11,4,39,23,44,28,14,13,34,18,33,17,3,8,43,27,36,20,6,5,46,30,45,29,15 },
	{ 43,19,0,2,40,16,42,18,1,3,41,21,23,4,36,6,38,20,22,5,37,7,39,11,25,27,32,8,34,10,24,26,33,9,35,15,29,31,12,44,14,46,28,30,13,45,17 },
	{ 26,38,13,29,0,11,16,40,27,6,37,22,46,1,35,17,8,7,24,36,23,14,45,30,34,9,43,25,4,15,20,44,31,2,33,18,42,5,39,21,12,3,28,32,19,10,41 },
	{ 42,6,34,15,43,7,35,30,22,31,23,46,0,38,25,1,39,24,16,8,17,9,4,32,29,5,33,28,20,12,40,21,13,41,36,10,2,37,11,3,26,44,18,27,45,19,14 },
	{ 29,12,19,2,37,43,16,13,22,3,36,42,17,0,23,6,41,20,1,26,7,40,46,21,4,27,10,45,35,24,5,30,11,44,34,25,8,31,14,33,39,28,9,18,15,32,38 },
	{ 42,37,40,18,1,14,3,29,24,31,43,4,41,46,2,44,25,30,27,5,8,7,20,34,45,32,26,9,6,11,21,16,23,35,12,33,38,10,36,17,22,19,13,0,15,28,39 },
	{ 25,0,37,18,11,20,1,46,36,27,10,21,12,39,41,26,3,28,13,38,40,23,2,29,4,43,33,22,15,16,5,42,32,31,14,17,8,35,45,30,7,24,9,34,44,19,6 },
	{ 31,43,7,14,28,22,41,4,44,26,38,15,2,29,23,24,5,12,0,20,27,39,46,3,10,25,18,13,1,8,21,16,34,11,19,32,9,37,17,30,35,42,6,33,40,36,45 },
},
{
	/* Frame 89 */
	{ 41,37,43,39,40,36,42,38,9,5,11,7,24,20,26,22,8,4,10,6,25,21,27,23,33,45,35,32,44,34,46,1,13,3,15,16,28,18,30,0,12,2,14,17,29,19,31 },
	{ 32,10,34,24,26,9,33,11,35,25,27,12,44,14,46,28,30,13,45,15,29,31,0,40,2,42,16,18,1,41,3,43,17,19,4,36,6,38,20,22,5,37,7,39,21,23,8 },
	{ 6,37,29,46,18,12,15,32,24,35,27,1,10,41,21,38,30,4,7,44,16,19,13,2,33,25,42,22,8,11,36,28,39,31,5,14,45,17,34,26,0,3,40,20,43,23,9 },
	{ 8,38,1,9,39,16,46,24,17,25,32,31,40,6,33,30,41,7,14,22,15,23,27,36,2,44,26,37,3,45,10,18,11,19,4,34,12,5,35,13,42,20,28,43,21,29,0 },
	{ 5,34,10,44,6,31,32,8,19,4,29,35,17,45,30,33,18,15,28,3,16,13,42,1,38,14,40,2,27,36,12,23,43,0,25,39,21,41,26,37,22,11,24,7,20,9,46 },
	{ 42,13,40,46,17,44,35,21,39,25,43,29,41,0,45,18,4,22,24,26,28,30,1,19,5,32,23,36,27,31,2,33,6,37,10,8,14,12,3,16,7,34,20,11,38,9,15 },
	{ 33,28,9,18,7,32,46,17,8,23,6,45,43,16,5,22,3,44,42,21,4,27,2,41,39,20,1,26,15,40,38,25,0,31,14,37,35,24,13,30,11,36,34,29,12,19,10 },
	{ 44,22,46,20,13,7,30,37,28,39,11,41,43,17,2,0,25,23,14,12,31,36,38,5,40,18,42,16,9,3,26,33,24,35,15,45,21,6,4,29,19,10,8,27,32,34,1 },
	{ 13,46,23,35,20,40,25,2,39,1,44,29,14,5,8,43,26,17,12,30,34,21,33,6,11,0,37,18,15,4,22,42,27,41,24,3,38,31,45,28,32,7,10,9,36,19,16 },
	{ 22,19,13,25,5,42,17,31,34,26,23,40,18,32,24,43,16,46,35,10,38,41,2,33,8,29,0,21,11,39,14,3,44,6,9,36,28,1,20,15,45,7,37,12,4,30,27 },
	{ 36,8,44,16,24,1,37,9,45,17,25,32,30,40,6,15,22,33,31,41,7,14,23,26,2,38,11,18,27,3,39,10,46,19,4,34,12,43,20,28,5,35,13,42,21,29,0 },
	{ 16,35,19,1,6,37,21,38,26,8,11,40,28,31,13,2,33,17,34,22,4,7,36,24,43,27,9,14,45,29,46,18,0,3,32,20,39,23,5,10,41,25,42,30,12,15,44 },
},
{
	/* Frame 90 */
	{ 15,12,34,31,1,18,46,17,5,43,22,40,21,39,24,36,10,33,28,14,45,3,0,19,7,4,42,23,9,26,38,25,13,35,30,32,29,16,44,2,41,20,6,37,11,8,27 },
	{ 35,12,45,18,24,7,46,13,36,19,25,14,0,37,26,20,15,38,1,40,27,21,2,39,8,41,22,28,3,42,9,32,23,29,10,43,4,33,30,16,11,34,5,44,31,17,6 },
	{ 0,2,43,9,27,36,25,20,6,5,31,12,35,1,40,19,42,17,26,24,39,11,23,46,4,45,30,32,29,34,15,41,18,16,3,8,38,10,37,22,21,44,7,33,28,14,13 },
	{ 19,26,18,10,46,2,38,11,3,39,31,23,30,22,42,14,34,6,43,15,35,7,17,8,44,16,9,45,0,36,24,1,37,25,21,40,12,20,41,13,32,4,28,33,5,29,27 },
	{ 19,5,22,0,11,38,25,14,35,28,7,44,21,2,41,16,27,13,32,30,8,37,46,23,1,43,18,4,15,34,29,10,39,24,3,40,17,6,45,20,31,9,36,26,12,33,42 },
	{ 30,25,39,27,7,34,16,2,15,24,26,36,23,35,4,46,3,44,14,43,12,11,37,22,5,32,19,45,0,42,13,40,10,8,21,33,18,1,29,41,31,9,38,20,6,17,28 },
	{ 30,42,24,44,23,35,17,37,10,12,3,5,18,38,28,40,27,21,33,6,8,15,1,22,34,16,36,31,43,25,45,2,4,11,13,26,46,20,32,19,39,29,41,14,0,7,9 },
	{ 45,30,0,40,27,37,25,18,32,28,23,42,21,39,14,16,34,11,9,6,12,3,1,41,26,4,44,31,33,29,22,43,36,24,19,46,17,35,10,20,38,15,13,2,8,7,5 },
	{ 3,46,31,37,26,40,17,12,39,9,42,19,6,11,0,45,20,25,2,22,36,27,33,14,5,8,35,28,7,10,30,44,21,41,16,13,38,23,43,18,32,15,4,1,34,29,24 },
	{ 27,4,25,22,11,37,40,42,3,12,0,14,18,45,33,5,8,23,10,20,41,38,13,1,30,19,28,16,34,9,6,26,21,24,39,36,43,31,2,29,17,15,35,44,32,46,7 },
	{ 22,0,20,34,32,3,23,1,21,35,33,18,14,16,12,46,44,19,15,17,13,45,10,30,8,28,42,40,11,31,9,29,43,41,26,6,24,4,38,36,27,7,25,5,39,37,2 },
	{ 9,28,15,18,33,39,8,25,14,31,32,34,5,24,11,30,45,35,4,21,10,27,44,46,1,20,7,26,41,0,17,6,23,40,42,13,16,3,22,37,43,12,29,2,19,36,38 },
},
{
	/* Frame 91 */
	{ 38,11,4,45,30,17,7,10,33,44,18,31,6,32,13,19,24,35,46,1,12,20,25,34,15,0,41,26,21,3,14,37,40,22,27,2,43,36,9,23,28,39,42,5,8,16,29 },
	{ 24,0,26,35,25,1,27,3,32,2,33,38,4,20,39,5,21,7,23,36,6,22,37,8,10,16,9,11,17,40,19,42,41,18,43,12,28,14,30,13,29,15,31,44,46,45,34 },
	{ 32,28,35,31,9,10,41,25,38,26,4,7,44,20,23,1,2,33,17,42,18,8,11,36,24,39,27,13,14,45,29,34,30,0,3,40,16,43,19,5,6,37,21,46,22,12,15 },
	{ 12,9,20,17,29,40,31,26,7,18,15,44,35,43,8,5,16,28,25,33,39,27,6,3,14,11,23,34,37,42,4,1,13,24,21,32,38,41,46,2,30,10,22,19,36,45,0 },
	{ 7,24,41,19,14,36,26,43,13,38,25,0,15,20,37,27,2,44,22,39,1,46,21,8,3,28,45,23,10,32,30,9,34,29,4,11,16,33,31,6,40,18,35,5,42,17,12 },
	{ 40,5,44,3,42,7,46,16,20,33,18,37,27,22,35,31,0,39,9,4,13,2,11,6,15,24,32,28,41,36,26,45,34,30,43,38,8,17,12,21,10,19,14,23,25,1,29 },
	{ 20,40,31,35,12,7,17,45,22,42,1,14,24,36,19,8,3,21,41,26,38,13,10,28,32,23,43,4,15,25,37,30,34,9,6,16,44,27,39,0,11,29,33,18,46,5,2 },
	{ 26,28,21,11,2,45,4,43,23,25,32,14,38,8,1,27,18,20,3,44,37,42,35,13,30,24,17,15,6,41,0,19,29,36,10,34,12,5,31,22,16,7,40,33,46,39,9 },
	{ 45,25,36,16,13,4,40,28,11,2,46,30,35,23,14,9,0,44,24,33,21,12,26,39,19,10,7,43,31,34,22,37,17,8,5,41,29,32,20,3,27,38,18,15,6,42,1 },
	{ 6,37,9,43,1,28,35,15,20,44,7,26,36,18,42,29,34,21,12,27,4,19,10,41,2,33,13,5,24,39,11,16,40,3,30,32,22,46,25,38,17,8,31,0,23,14,45 },
	{ 19,38,43,21,34,44,17,36,40,7,32,3,5,29,1,25,22,14,18,39,10,20,35,13,16,37,9,33,31,27,46,28,42,24,45,15,41,6,11,2,12,4,8,0,30,23,26 },
	{ 18,10,24,0,43,33,19,11,25,1,42,32,30,14,20,4,37,31,15,21,5,46,36,26,2,16,8,35,41,27,3,17,9,34,40,22,6,28,12,39,45,23,7,29,13,38,44 },
},
{
	/* Frame 92 */
	{ 12,18,11,36,35,31,16,9,42,33,29,2,26,40,0,24,7,45,19,10,5,34,17,8,22,15,32,39,27,20,13,46,37,25,6,30,44,43,4,28,3,41,23,14,1,38,21 },
	{ 10,7,16,13,1,42,18,39,31,45,21,40,25,4,15,3,9,36,28,23,35,27,6,17,12,33,11,38,30,44,20,0,43,19,14,2,41,24,5,46,22,34,26,8,37,29,32 },
	{ 6,20,43,15,38,12,31,18,44,16,3,8,10,35,7,40,4,42,23,39,13,36,30,29,45,0,2,9,32,27,34,25,41,5,22,21,37,14,28,1,46,19,17,33,26,24,11 },
	{ 12,18,4,11,29,42,38,35,31,16,22,24,15,44,41,36,33,19,20,10,28,3,34,17,23,9,14,1,7,40,32,21,26,13,2,5,46,43,39,8,30,0,6,25,45,37,27 },
	{ 2,13,7,40,28,34,22,45,25,39,19,0,14,5,11,32,20,46,26,37,17,43,31,12,6,9,3,44,24,38,18,41,29,35,23,4,10,1,15,36,16,42,30,33,21,27,8 },
	{ 22,35,27,3,20,33,25,38,1,43,6,11,36,18,45,4,13,16,23,34,30,2,21,32,28,41,0,46,9,14,19,44,26,12,17,24,39,31,42,7,10,37,29,40,5,8,15 },
	{ 31,2,32,7,24,37,38,21,8,22,43,13,19,14,44,3,28,33,34,25,4,26,39,9,23,10,40,15,16,45,46,29,0,30,35,5,27,6,36,11,20,41,42,17,12,18,1 },
	{ 2,8,7,45,1,30,40,4,27,29,33,43,18,24,36,46,23,17,10,39,20,15,34,9,6,12,3,41,5,26,44,0,31,25,37,22,28,32,42,19,21,14,35,16,11,38,13 },
	{ 39,23,36,20,3,0,34,18,15,12,46,26,41,25,10,7,4,38,22,33,17,2,30,45,29,14,9,43,27,40,24,37,21,6,1,35,19,32,16,13,31,44,28,11,8,42,5 },
	{ 11,6,33,44,42,23,16,9,4,2,40,21,19,30,7,0,45,43,38,17,28,26,5,3,14,41,36,34,31,24,1,12,10,39,32,29,27,22,15,8,37,35,46,25,20,18,13 },
	{ 43,30,5,26,1,15,28,11,24,36,6,32,21,2,46,17,45,42,31,41,4,27,39,0,35,22,13,18,9,7,20,3,16,44,14,40,29,10,38,25,37,34,23,33,12,19,8 },
	{ 24,33,14,5,26,35,17,44,7,0,19,42,20,37,2,9,22,39,29,32,11,4,31,46,16,41,6,13,18,43,25,36,15,8,27,34,28,45,10,1,30,21,40,3,12,23,38 },
},
{
	/* Frame 93 */
	{ 17,19,29,16,18,28,31,30,1,3,13,0,46,2,12,32,15,34,44,33,14,35,45,21,25,23,20,24,22,27,26,43,5,9,7,42,4,8,6,11,36,40,38,10,37,41,39 },
	{ 0,32,3,35,16,19,1,33,2,34,17,22,4,44,7,20,23,5,45,6,46,21,26,8,40,11,43,24,27,9,41,10,42,25,30,12,36,15,39,28,31,13,37,14,38,29,18 },
	{ 38,36,22,6,20,4,39,37,23,7,21,5,46,44,30,14,28,12,45,31,15,29,13,34,32,18,2,16,0,35,33,19,3,17,1,42,40,26,10,24,8,43,41,27,11,25,9 },
	{ 45,27,18,44,26,2,10,36,3,11,37,23,41,31,22,40,30,6,14,32,7,15,33,9,17,8,16,25,38,0,46,24,39,1,13,21,12,20,29,34,4,42,28,35,5,43,19 },
	{ 38,30,37,13,18,1,35,11,8,7,4,14,25,2,21,40,31,36,28,19,46,16,45,34,26,33,9,22,43,5,39,15,12,3,0,10,29,6,17,44,27,32,24,23,42,20,41 },
	{ 43,7,4,42,6,21,23,41,20,22,40,37,1,39,3,36,0,38,2,17,19,16,18,15,33,28,35,14,32,29,34,31,13,30,12,11,24,46,10,25,27,45,9,26,44,8,5 },
	{ 37,35,28,13,26,11,36,34,17,12,31,10,41,39,16,1,30,15,40,38,21,0,19,14,45,43,20,5,18,3,44,42,25,4,23,2,33,24,9,22,7,32,46,29,8,27,6 },
	{ 44,42,39,20,14,8,5,18,23,25,45,11,38,40,4,35,22,24,29,10,7,1,27,41,36,34,28,6,0,13,26,31,17,37,3,46,32,12,43,30,16,21,2,15,9,19,33 },
	{ 27,42,4,2,24,41,30,39,1,11,29,44,23,34,8,14,20,33,18,43,13,3,17,36,31,46,0,6,28,45,26,35,5,15,25,40,19,38,12,10,16,37,22,9,7,21,32 },
	{ 17,5,16,4,1,20,43,0,46,21,42,31,27,30,26,39,15,35,11,38,14,34,10,23,19,45,22,18,44,7,41,3,6,40,2,25,37,13,24,36,12,33,9,28,32,8,29 },
	{ 38,18,37,17,34,20,33,7,11,9,46,12,31,42,29,2,1,39,19,4,22,35,21,26,44,24,10,40,15,13,36,16,3,32,6,5,23,8,27,45,25,30,43,28,41,14,0 },
	{ 18,17,27,8,33,43,3,40,20,30,29,6,45,5,15,38,24,19,0,10,35,9,32,42,22,21,31,12,37,7,44,16,26,25,2,41,1,11,34,28,23,4,14,39,13,36,46 },
},
{
	/* Frame 94 */
	{ 7,36,39,43,20,8,10,19,12,14,29,0,31,34,4,24,38,26,21,9,22,11,41,13,16,15,45,1,2,33,5,25,6,27,37,23,42,40,17,46,18,44,3,28,32,30,35 },
	{ 10,5,36,30,17,11,38,4,41,31,24,6,39,13,40,18,25,7,42,12,33,19,20,14,43,1,32,26,21,15,34,0,45,27,28,2,35,9,44,22,29,3,46,8,37,23,16 },
	{ 33,1,18,32,0,19,16,34,2,17,35,3,41,9,26,40,8,27,24,42,10,25,43,11,22,20,23,21,38,6,36,4,39,7,37,5,30,28,31,29,46,14,44,12,15,45,13 },
	{ 45,1,37,8,44,0,36,25,17,24,16,13,41,5,33,12,40,4,32,29,21,28,20,3,39,27,2,38,26,19,10,46,18,11,7,35,31,6,34,30,23,14,42,22,15,43,9 },
	{ 34,12,21,26,7,40,37,13,0,27,22,36,43,28,1,14,23,42,39,29,16,15,2,45,38,8,17,30,3,44,33,9,4,31,18,32,24,5,10,19,46,35,25,20,11,6,41 },
	{ 20,42,23,21,43,7,41,5,6,40,4,18,16,19,17,3,39,1,37,2,38,0,36,28,14,29,15,13,35,30,33,12,34,31,32,24,10,46,25,11,9,45,26,8,44,27,22 },
	{ 22,38,24,40,31,17,33,6,8,15,1,26,42,28,44,19,35,21,37,10,12,3,5,30,46,16,32,23,39,25,41,14,0,7,9,18,34,20,36,27,43,29,45,2,4,11,13 },
	{ 45,2,6,40,44,3,7,8,12,34,38,9,13,35,39,18,30,19,31,24,20,25,21,33,37,10,14,32,36,11,15,0,4,42,46,1,5,43,26,22,27,23,16,28,17,29,41 },
	{ 27,34,8,10,28,37,30,13,3,25,32,23,42,4,6,16,45,18,35,1,11,21,40,31,38,12,14,24,33,26,43,9,7,29,36,19,46,0,2,20,41,22,39,5,15,17,44 },
	{ 16,15,27,4,41,38,43,30,3,44,32,21,25,37,18,28,46,9,6,11,12,0,34,23,26,5,40,39,17,14,33,20,24,42,31,2,45,8,7,36,19,29,1,35,22,10,13 },
	{ 28,40,23,35,24,38,19,13,30,42,1,26,4,15,37,8,3,29,41,6,44,25,39,10,20,32,31,43,16,46,27,5,22,34,9,18,12,7,45,0,11,21,33,14,36,17,2 },
	{ 31,6,13,16,34,41,32,30,23,12,5,33,11,22,29,4,10,3,28,21,46,39,44,27,2,9,20,38,45,36,26,19,8,1,37,15,18,25,0,43,14,7,24,17,42,35,40 },
},
{
	/* Frame 95 */
	{ 45,32,25,20,10,39,30,3,13,23,36,43,16,34,27,9,4,14,7,40,18,28,0,21,11,38,31,44,33,24,37,42,17,2,12,22,5,15,35,26,8,19,29,1,46,6,41 },
	{ 42,41,43,9,25,11,27,8,24,10,26,44,46,20,45,21,13,23,15,12,22,14,34,0,16,35,1,17,3,19,32,2,18,33,38,4,39,5,7,29,36,31,6,28,37,30,40 },
	{ 21,1,34,32,22,2,20,0,35,33,23,3,29,9,42,40,30,10,28,8,43,41,31,11,17,5,38,36,18,6,16,4,39,37,19,7,25,13,46,44,26,14,24,12,45,27,15 },
	{ 26,34,3,43,31,44,6,36,15,41,8,0,13,20,38,28,27,2,42,11,45,22,14,9,16,24,33,21,29,46,5,18,10,35,23,30,7,37,17,40,25,32,1,12,4,39,19 },
	{ 28,37,31,46,13,2,25,40,22,43,4,7,16,45,19,34,1,10,21,36,30,39,12,15,24,33,27,42,9,6,29,44,18,0,3,20,41,23,38,5,14,17,32,26,35,8,11 },
	{ 14,32,22,40,30,7,15,33,23,41,31,38,2,46,10,18,26,39,3,11,19,27,29,34,4,42,12,20,28,35,5,43,13,21,25,36,0,44,8,16,24,37,1,45,9,17,6 },
	{ 20,44,23,8,11,17,41,30,38,5,2,24,32,27,35,12,15,21,45,18,42,9,6,28,36,31,39,0,3,25,33,22,46,13,10,16,40,19,43,4,7,29,37,26,34,1,14 },
	{ 38,0,18,12,17,30,11,29,7,32,35,44,16,10,28,9,6,27,5,33,23,34,45,46,8,26,4,25,22,3,21,15,40,43,36,24,39,2,20,1,14,19,13,41,31,42,37 },
	{ 3,20,32,22,38,4,6,29,41,31,43,13,15,24,44,26,34,0,2,17,37,19,39,9,11,28,40,30,46,12,14,21,33,23,35,5,7,16,36,18,42,8,10,25,45,27,1 },
	{ 1,29,35,0,28,34,32,3,31,33,2,30,21,13,20,12,46,44,23,15,45,22,14,5,25,39,4,24,38,36,7,27,37,6,26,17,9,43,16,8,42,40,19,11,41,18,10 },
	{ 25,15,42,19,20,6,24,46,43,13,18,7,34,10,12,41,17,38,35,4,11,45,40,31,16,39,2,5,32,44,9,30,29,3,36,33,23,8,28,37,0,22,27,14,1,21,26 },
	{ 16,28,22,26,17,29,23,27,4,12,2,10,37,45,35,43,5,13,3,11,36,44,34,42,20,24,18,30,21,25,19,31,0,8,6,14,33,41,39,1,9,7,15,32,40,38,46 },
},
{
	/* Frame 96 */
	{ 40,36,45,30,43,6,15,29,23,41,5,44,27,38,14,3,28,22,25,4,13,1,21,26,39,46,2,11,24,19,12,0,9,20,17,34,10,18,32,8,37,16,31,35,42,7,33 },
	{ 23,44,33,16,11,28,7,13,18,0,43,46,25,2,41,30,37,20,15,34,8,4,27,32,17,10,29,39,22,45,1,42,6,12,19,40,31,36,21,24,3,9,5,26,14,35,38 },
	{ 33,7,5,32,6,4,22,34,20,23,35,21,41,15,13,40,14,12,30,42,28,31,43,29,39,1,37,18,38,0,36,19,16,2,17,3,9,45,26,46,8,44,27,24,10,25,11 },
	{ 0,24,43,5,44,29,20,41,2,32,10,7,30,22,1,34,25,42,16,45,12,36,21,3,33,26,18,31,38,23,46,15,35,8,17,13,37,4,28,27,40,19,11,39,6,14,9 },
	{ 18,5,24,33,10,31,4,17,46,32,3,30,9,16,39,45,2,23,8,29,38,44,15,22,1,28,43,37,14,27,0,21,42,36,7,26,13,20,35,41,6,19,12,25,34,40,11 },
	{ 43,29,4,12,34,20,42,28,5,13,35,17,25,0,36,8,44,16,24,1,37,9,45,15,23,31,32,6,40,14,22,30,33,7,41,11,19,27,2,38,10,46,18,26,3,39,21 },
	{ 23,14,36,11,24,33,42,21,12,30,39,9,27,2,40,15,28,37,46,25,0,18,43,13,31,6,44,3,16,41,34,29,4,22,1,19,10,32,7,20,45,38,17,8,26,35,5 },
	{ 14,26,44,15,27,12,24,46,13,25,33,30,2,32,31,3,28,0,34,29,1,35,37,6,18,36,7,19,4,16,38,5,17,39,41,22,10,40,23,11,20,8,42,21,9,43,45 },
	{ 7,28,44,22,34,8,2,21,37,31,1,11,16,32,26,38,12,6,25,41,19,35,5,15,20,36,30,42,0,10,29,45,23,39,9,3,24,40,18,46,4,14,17,33,27,43,13 },
	{ 0,44,23,9,37,30,12,11,5,2,24,42,7,17,35,14,40,20,19,38,33,29,26,8,36,31,1,45,22,4,3,13,10,16,34,15,25,43,6,32,28,27,46,41,21,18,39 },
	{ 23,2,44,43,4,17,14,3,39,42,21,16,15,26,41,38,20,1,30,27,37,40,13,0,31,10,36,35,12,25,6,11,34,29,24,7,18,33,46,28,9,22,19,45,32,5,8 },
	{ 22,12,35,11,20,19,46,33,9,26,17,2,43,36,24,31,0,41,7,29,34,10,5,44,18,8,39,15,16,23,42,37,13,30,21,6,32,28,27,4,45,3,25,38,14,1,40 },
},
{
	/* Frame 97 */
	{ 39,11,24,26,36,8,38,10,25,27,37,9,43,15,28,30,40,12,42,14,29,31,41,13,3,16,18,44,0,46,2,17,19,45,1,35,7,20,22,32,4,34,6,21,23,33,5 },
	{ 0,11,45,6,28,33,2,36,24,21,40,30,35,5,17,38,26,1,23,42,12,7,19,8,3,37,14,20,41,10,44,16,39,29,32,22,43,13,25,46,18,9,31,34,4,15,27 },
	{ 37,13,0,31,18,41,34,12,17,30,7,46,35,29,16,11,6,32,28,5,10,23,44,33,9,4,27,22,45,38,8,21,26,3,42,39,25,20,15,2,36,43,24,1,14,19,40 },
	{ 25,4,10,40,1,12,18,9,21,27,39,36,42,29,2,14,33,44,5,11,22,41,13,19,31,16,34,46,26,6,24,37,43,3,15,0,45,23,8,20,38,30,17,28,35,32,7 },
	{ 0,18,9,38,27,4,33,30,13,40,23,37,24,2,44,17,11,20,6,35,29,15,42,8,39,26,1,46,19,12,41,22,5,32,31,45,16,10,36,25,3,28,14,43,21,7,34 },
	{ 46,17,45,18,15,0,29,35,30,32,8,43,40,23,5,6,27,16,13,14,28,34,33,3,42,21,41,22,11,4,25,39,26,36,12,44,19,1,2,31,20,9,10,24,38,37,7 },
	{ 24,26,40,8,42,10,25,27,41,9,43,11,38,16,18,0,36,2,39,17,19,1,37,3,46,14,28,31,44,12,15,29,30,45,13,6,20,32,23,34,4,7,21,33,22,35,5 },
	{ 39,38,42,36,40,43,37,41,28,20,15,7,29,21,14,6,12,4,30,22,13,5,31,23,46,44,34,32,45,35,33,26,18,24,16,27,19,25,17,10,2,8,0,11,3,9,1 },
	{ 29,24,12,6,41,3,22,14,11,30,36,1,20,42,38,9,35,28,19,45,7,40,2,27,33,15,10,17,5,0,25,13,39,8,34,23,18,44,31,37,26,32,46,21,43,16,4 },
	{ 5,36,15,40,3,34,25,4,45,14,39,2,43,16,26,44,7,38,29,42,17,27,6,28,30,18,9,46,21,31,19,8,33,20,22,13,1,32,11,23,12,37,0,41,10,35,24 },
	{ 43,1,20,42,0,46,4,17,5,16,29,9,33,28,8,32,12,36,25,13,37,24,3,7,41,2,6,40,19,44,23,18,45,22,11,35,15,39,10,34,14,38,27,31,26,30,21 },
	{ 31,44,36,41,18,0,8,15,20,38,28,17,2,25,42,45,22,4,12,19,1,26,9,33,21,6,29,46,3,10,35,23,5,30,13,37,27,40,32,7,14,39,11,16,34,24,43 },
},
{
	/* Frame 98 */
	{ 30,46,29,45,11,8,27,39,20,36,6,5,18,42,17,41,15,12,31,35,24,32,10,9,22,38,21,37,3,0,19,28,44,14,13,26,34,25,33,7,4,23,43,16,40,2,1 },
	{ 34,1,10,19,41,7,28,4,44,26,2,25,37,42,13,20,31,35,32,11,18,8,17,38,5,14,23,45,3,24,0,43,40,30,6,29,33,46,9,16,27,39,36,15,22,12,21 },
	{ 19,33,10,4,38,13,35,22,26,40,17,24,7,42,36,31,0,45,20,9,2,14,11,5,39,29,18,32,27,41,16,12,34,46,23,43,37,30,1,25,6,3,15,44,21,8,28 },
	{ 25,31,10,40,46,16,23,2,33,38,9,15,27,45,42,7,19,4,34,30,11,28,41,22,3,21,0,39,36,26,12,24,43,18,5,17,35,32,29,8,14,44,20,1,6,37,13 },
	{ 39,9,4,31,24,44,3,14,18,38,41,5,25,28,35,15,0,19,22,40,37,10,29,34,1,12,23,16,36,11,6,26,46,33,13,17,20,43,7,8,27,30,32,45,2,21,42 },
	{ 20,42,23,41,35,1,2,12,17,15,18,44,24,38,27,37,43,9,10,0,29,3,30,32,16,46,19,45,39,5,6,8,21,11,22,40,28,34,31,33,13,14,4,25,7,26,36 },
	{ 29,25,28,24,45,13,41,9,44,12,40,8,21,39,17,20,38,16,35,5,1,34,4,0,27,15,26,46,14,43,11,30,42,10,31,19,7,18,6,37,3,33,22,36,2,32,23 },
	{ 34,41,16,12,3,38,45,20,25,22,40,33,29,2,31,39,44,37,24,6,11,32,28,19,30,1,36,7,10,5,43,18,14,0,27,4,9,42,35,15,17,13,46,26,21,8,23 },
	{ 41,39,36,25,23,11,20,8,35,32,44,19,31,16,28,2,43,40,6,27,5,24,22,10,34,14,1,13,18,30,38,37,42,21,9,7,26,4,46,33,45,17,29,3,15,0,12 },
	{ 46,28,38,20,13,5,29,39,21,12,0,32,24,16,9,41,1,33,25,17,8,40,14,36,6,30,22,45,15,37,7,31,23,44,10,42,2,34,26,18,11,43,3,35,27,19,4 },
	{ 25,7,27,4,24,6,26,37,39,36,38,13,21,15,23,12,20,14,22,45,44,46,1,29,3,31,0,28,2,30,33,35,32,34,9,17,11,19,8,16,10,18,41,43,40,42,5 },
	{ 6,42,31,13,32,38,28,11,17,45,23,4,26,8,46,3,36,40,18,15,21,35,25,43,30,12,1,7,10,16,44,22,33,39,29,2,5,27,9,14,20,34,24,37,41,19,0 },
},
{
	/* Frame 99 */
	{ 40,13,18,24,35,6,37,12,19,25,42,7,36,1,26,20,43,14,45,0,27,21,38,15,44,9,22,28,39,2,33,8,23,29,46,3,32,5,30,16,10,41,4,31,17,34,11 },
	{ 22,40,30,1,46,16,38,25,42,34,21,45,19,4,27,13,41,0,9,7,24,15,43,3,20,11,29,18,36,26,12,32,23,8,31,6,14,17,39,2,10,28,35,37,44,5,33 },
	{ 6,43,34,25,16,14,23,32,42,24,5,31,22,40,33,13,4,30,3,41,39,12,21,11,2,38,29,20,10,19,36,46,28,1,27,18,44,37,9,0,26,7,45,35,8,17,15 },
	{ 43,14,19,33,4,9,38,10,15,0,5,34,39,11,28,1,35,6,24,29,2,7,20,25,31,3,44,16,21,27,30,40,45,17,46,22,26,36,41,12,42,18,23,32,37,8,13 },
	{ 31,35,25,37,22,42,16,44,3,5,10,12,19,29,33,26,38,20,40,15,1,6,8,23,43,17,45,30,34,24,36,11,13,2,4,27,39,21,41,18,46,28,32,7,9,14,0 },
	{ 9,19,46,20,41,35,31,36,24,2,43,17,44,10,29,7,0,15,8,18,5,34,30,37,13,23,42,16,45,39,27,32,28,6,21,40,14,25,3,4,11,12,22,1,38,26,33 },
	{ 40,15,43,20,39,22,10,16,34,19,31,13,7,37,26,9,2,33,14,42,29,38,23,5,25,45,18,1,12,41,6,36,21,46,8,11,32,17,35,28,30,4,24,44,27,0,3 },
	{ 18,7,19,6,2,44,22,40,3,45,23,41,28,24,29,25,36,12,32,8,37,13,33,9,20,16,21,17,46,4,42,0,5,43,1,26,39,15,27,38,14,34,10,30,35,11,31 },
	{ 13,10,30,41,20,19,6,34,28,27,14,39,42,36,3,23,0,44,11,31,8,18,7,17,4,35,32,15,25,12,43,37,40,22,1,21,45,9,29,26,38,16,5,2,33,46,24 },
	{ 36,11,30,1,16,37,10,19,0,25,38,40,3,18,13,24,39,41,2,27,12,21,42,32,15,26,5,20,43,33,14,23,4,29,34,44,7,22,9,28,35,45,6,31,8,17,46 },
	{ 23,41,26,34,30,4,43,25,13,6,40,27,31,20,42,1,12,37,7,3,14,21,0,28,36,9,2,45,15,38,11,16,29,8,33,18,44,22,39,10,35,17,46,5,24,32,19 },
	{ 23,7,21,5,22,6,20,4,38,36,39,37,3,27,1,2,26,0,25,34,32,24,35,33,45,31,15,44,30,14,29,13,46,28,12,19,41,17,11,18,40,16,10,9,42,8,43 },
},
{
	/* Frame 100 */
	{ 20,41,27,38,13,6,25,36,30,4,11,28,33,23,42,1,14,21,40,18,39,12,7,16,45,31,34,9,2,29,32,26,43,0,15,24,37,19,46,5,10,17,44,22,35,8,3 },
	{ 5,46,39,29,18,33,10,34,22,14,38,45,19,16,11,2,8,23,26,15,6,44,37,30,17,3,9,0,27,20,24,7,12,36,31,40,1,43,21,25,13,4,28,41,32,42,35 },
	{ 19,33,12,20,46,27,35,41,7,28,36,17,43,15,23,44,25,0,5,31,39,2,8,13,21,10,18,32,29,37,16,26,34,40,6,45,24,1,42,14,22,3,9,4,30,38,11 },
	{ 43,4,3,38,31,9,44,10,5,39,17,30,45,11,46,6,16,12,32,24,7,19,13,33,14,25,21,18,0,15,34,27,20,40,1,36,35,28,26,41,23,42,37,2,29,8,22 },
	{ 17,42,13,26,32,6,23,37,16,11,12,29,46,1,35,22,36,10,19,41,28,15,0,25,34,5,39,18,40,14,31,45,24,3,4,21,38,9,43,30,44,2,27,33,20,7,8 },
	{ 40,20,19,1,6,33,17,42,22,12,11,36,24,35,31,9,14,41,29,38,26,0,7,44,16,43,23,5,2,37,21,46,18,8,15,32,28,39,27,13,10,45,25,34,30,4,3 },
	{ 11,40,7,35,2,24,42,21,1,26,41,31,3,25,43,12,16,36,27,30,18,23,13,17,37,4,14,44,19,38,22,28,8,5,32,15,45,10,39,6,34,29,46,9,20,33,0 },
	{ 19,42,23,15,36,11,16,5,28,38,8,18,22,10,33,4,45,39,25,35,6,27,32,31,21,44,1,24,34,13,7,46,3,26,30,20,0,41,12,2,43,14,37,17,40,29,9 },
	{ 41,21,32,45,19,36,43,23,34,1,38,5,3,26,7,30,16,8,20,33,12,18,37,10,22,35,14,39,25,29,40,27,44,31,42,9,46,0,13,4,11,2,15,6,24,17,28 },
	{ 22,12,20,46,44,15,23,13,21,45,10,26,8,24,42,40,11,27,9,25,43,41,6,30,4,28,38,36,7,31,5,29,39,37,2,18,0,16,34,32,3,19,1,17,35,33,14 },
	{ 30,0,29,10,9,39,45,46,31,32,28,11,18,8,17,6,5,33,34,19,40,16,7,26,4,25,14,13,35,41,42,27,36,24,15,22,12,21,2,1,43,37,38,23,44,20,3 },
	{ 13,11,19,8,36,22,35,26,1,44,9,16,37,23,6,27,32,24,45,30,46,40,17,43,7,20,33,25,2,31,14,28,41,42,38,21,4,3,15,29,12,10,18,39,5,34,0 },
},
{
	/* Frame 101 */
	{ 31,1,3,30,0,2,32,28,34,33,29,35,17,5,19,7,16,4,18,6,36,38,37,39,21,11,23,40,20,10,22,41,42,8,43,9,27,15,44,26,14,45,46,24,12,25,13 },
	{ 46,26,1,42,4,15,8,3,45,6,28,41,23,10,36,16,27,21,32,30,43,5,25,38,18,9,34,12,7,0,11,37,14,20,33,31,2,44,24,39,19,29,40,22,35,13,17 },
	{ 31,8,7,46,20,10,37,13,22,17,39,15,32,28,19,4,45,34,30,25,6,1,40,27,12,3,42,16,14,33,9,18,21,35,11,36,24,23,0,41,38,26,29,2,43,5,44 },
	{ 23,1,2,31,36,8,35,10,7,45,16,43,19,15,29,27,32,22,4,3,41,30,37,13,38,11,25,44,21,46,18,0,28,26,33,9,34,5,6,40,17,42,12,39,14,24,20 },
	{ 30,3,4,25,42,45,7,2,21,24,46,43,6,27,20,9,32,23,26,13,8,36,33,22,11,12,17,34,37,15,10,29,16,38,35,14,19,28,1,39,40,31,18,5,0,44,41 },
	{ 29,6,42,24,35,27,21,44,38,30,16,41,19,32,13,22,37,8,11,1,14,4,7,43,25,2,46,28,39,31,17,40,34,26,20,45,23,36,9,18,33,12,15,5,10,0,3 },
	{ 16,20,40,0,44,4,17,21,41,1,45,5,38,24,28,8,34,12,39,25,29,9,35,13,46,6,18,23,42,2,7,19,22,43,3,14,26,32,31,36,10,15,27,33,30,37,11 },
	{ 9,15,33,2,21,13,24,6,19,36,42,28,35,1,23,40,26,45,5,16,38,30,10,3,20,8,14,32,7,18,37,43,12,25,22,41,27,29,34,46,0,39,31,11,44,4,17 },
	{ 45,19,46,12,35,31,1,2,43,9,10,20,7,36,24,15,17,44,18,33,29,34,30,0,41,23,42,8,39,27,5,6,13,14,16,3,32,28,11,21,40,22,37,25,38,26,4 },
	{ 2,17,41,26,34,8,11,6,21,45,22,38,12,15,18,42,0,3,24,32,27,35,9,46,4,7,28,36,31,39,13,16,40,19,43,1,10,25,33,20,44,23,5,14,29,37,30 },
	{ 41,6,5,15,34,12,30,2,46,17,45,11,39,8,36,26,7,42,4,22,35,28,32,31,3,0,44,18,9,27,24,43,20,40,23,29,33,14,13,1,19,16,10,38,25,37,21 },
	{ 29,39,8,2,44,6,21,26,30,11,0,15,36,43,24,18,22,9,3,12,7,41,35,27,16,31,1,46,4,42,33,25,19,28,23,13,38,40,34,45,17,20,5,10,32,14,37 },
},
{
	/* Frame 102 */
	{ 23,4,38,1,26,2,24,33,31,44,46,13,19,10,8,5,20,6,37,27,3,32,35,14,12,29,11,16,41,43,21,7,22,36,39,0,34,25,15,30,45,28,17,40,18,42,9 },
	{ 45,7,24,4,43,40,17,30,2,37,46,9,20,27,35,32,15,18,12,38,25,5,10,23,41,3,28,0,44,21,26,6,33,42,13,16,31,39,36,11,22,8,34,29,1,14,19 },
	{ 33,12,17,24,14,19,10,32,41,1,25,20,18,27,22,40,37,0,9,21,28,39,35,26,23,30,36,45,8,5,29,38,34,43,7,31,3,44,4,13,16,46,42,6,15,2,11 },
	{ 13,11,25,38,5,2,17,28,45,26,43,9,20,37,23,34,1,12,14,24,41,4,7,16,33,19,44,31,46,8,10,36,22,39,0,3,15,29,40,27,42,6,21,32,18,35,30 },
	{ 4,34,15,24,19,39,32,13,30,17,37,2,46,28,23,0,44,11,21,35,14,9,18,33,12,42,7,16,27,40,5,22,25,45,10,38,20,31,8,36,3,29,43,6,1,26,41 },
	{ 21,14,37,16,11,1,46,22,4,43,19,40,25,2,45,28,7,9,34,26,12,39,31,36,17,10,33,20,15,5,42,18,0,23,44,29,6,41,24,3,13,38,30,8,35,27,32 },
	{ 19,17,18,16,43,3,41,1,42,2,40,0,27,39,25,26,38,24,37,11,9,36,10,8,21,7,20,46,6,45,5,22,44,4,23,29,15,28,14,35,13,33,30,34,12,32,31 },
	{ 18,27,39,15,6,35,16,8,37,29,4,33,13,19,26,38,3,14,43,22,34,31,17,24,36,1,45,20,32,12,41,46,11,2,42,23,30,7,25,0,44,9,21,28,40,5,10 },
	{ 27,16,43,7,13,32,10,21,18,24,37,15,34,40,4,23,29,26,39,45,1,42,6,12,31,20,3,9,36,14,17,22,28,33,11,38,44,0,19,25,30,35,41,5,46,2,8 },
	{ 37,23,44,26,43,2,21,24,41,0,7,10,19,34,5,12,17,32,22,45,31,42,3,20,29,38,1,8,15,36,18,35,27,46,13,16,33,25,40,30,6,11,28,39,4,9,14 },
	{ 31,2,36,11,16,45,42,29,0,26,39,9,19,14,40,3,24,37,34,17,12,22,43,1,27,6,32,15,20,41,46,25,4,30,35,13,23,10,44,7,28,33,38,21,8,18,5 },
	{ 16,46,36,29,23,41,34,45,30,5,11,25,18,12,6,43,1,38,8,21,27,33,15,37,28,22,40,3,17,4,10,24,35,44,31,42,0,19,13,7,20,26,32,14,39,9,2 },
},
{
	/* Frame 103 */
	{ 11,38,12,23,0,19,42,25,6,20,45,33,5,46,2,31,8,27,36,14,28,35,16,41,13,22,1,10,39,21,44,32,18,43,24,7,3,30,9,4,29,34,17,40,26,37,15 },
	{ 22,3,43,18,15,38,32,29,40,21,12,25,4,17,45,2,31,42,35,14,27,7,33,28,9,20,1,24,36,16,44,30,11,23,34,26,6,19,46,39,8,0,41,37,13,5,10 },
	{ 25,19,46,5,40,26,12,6,43,20,31,37,9,3,17,38,10,32,24,18,4,41,35,15,29,23,42,1,44,30,8,2,16,27,33,13,7,21,34,14,36,28,22,0,45,39,11 },
	{ 29,37,10,23,17,28,42,11,22,16,2,43,14,9,21,34,3,46,15,41,8,20,35,6,0,40,13,27,38,7,32,1,45,12,26,39,25,33,4,44,19,31,24,36,5,18,30 },
	{ 32,46,21,8,27,6,33,24,9,30,7,44,42,25,4,31,2,45,43,28,5,18,3,40,38,29,0,19,14,41,39,16,1,22,15,36,34,17,12,23,10,37,35,20,13,26,11 },
	{ 40,22,31,0,13,36,23,14,1,24,42,2,15,16,25,38,43,45,3,26,17,8,39,33,44,18,27,4,9,32,19,10,5,28,46,6,11,20,29,34,41,7,30,21,12,35,37 },
	{ 40,7,45,26,39,30,4,24,36,29,23,3,15,35,20,1,12,33,6,44,19,38,31,11,17,43,28,9,2,41,14,34,27,46,0,5,32,25,37,18,22,10,16,42,21,8,13 },
	{ 18,13,25,6,42,36,41,28,1,34,23,26,39,16,31,44,10,4,9,15,2,32,21,24,7,43,37,19,12,35,22,27,40,29,0,46,45,11,5,38,17,30,3,33,20,8,14 },
	{ 13,35,6,25,18,46,33,4,23,16,44,3,39,21,30,1,37,10,28,34,7,8,19,32,5,43,14,17,26,38,41,12,31,24,36,11,29,22,9,45,2,20,42,15,0,27,40 },
	{ 35,27,37,29,10,12,42,30,32,24,7,1,23,41,17,2,4,34,18,44,20,11,13,39,31,33,25,14,8,46,26,36,28,3,5,43,19,45,21,6,0,38,22,40,16,15,9 },
	{ 46,1,11,23,12,33,16,45,26,7,42,29,30,3,39,8,4,41,14,35,18,25,36,21,22,13,0,10,6,43,28,32,17,44,27,38,9,5,31,2,24,37,20,40,15,34,19 },
	{ 25,17,27,19,24,16,26,18,1,13,3,46,0,12,2,15,32,44,34,14,33,45,35,29,21,28,20,31,23,30,22,9,39,11,5,8,38,10,4,40,7,42,36,41,6,43,37 },
},
{
	/* Frame 104 */
	{ 2,29,14,16,11,0,45,9,34,28,15,10,21,32,5,8,35,38,42,20,33,30,4,27,40,13,39,25,43,46,31,36,26,41,22,12,19,6,24,3,17,37,1,23,44,18,7 },
	{ 17,3,15,0,30,39,10,5,46,1,12,31,22,11,36,8,26,32,13,35,23,28,37,9,6,27,18,24,33,44,34,29,20,40,7,43,19,25,16,45,2,14,21,41,38,42,4 },
	{ 33,46,37,26,17,15,39,8,19,12,32,36,43,1,14,5,38,18,29,7,42,0,31,4,11,35,28,6,24,30,21,10,41,34,45,23,25,3,20,27,16,40,44,22,9,2,13 },
	{ 23,17,34,13,27,22,42,16,39,12,33,26,25,43,21,38,3,32,31,24,46,20,41,2,37,30,29,10,40,7,36,1,28,11,45,6,0,19,14,44,9,5,18,15,35,8,4 },
	{ 0,30,36,17,2,13,38,19,33,24,15,4,35,26,40,29,6,1,42,31,37,20,3,8,39,22,44,25,10,5,46,27,41,16,7,12,43,18,32,21,14,9,34,23,45,28,11 },
	{ 18,45,35,8,25,6,31,44,34,9,16,15,30,33,43,4,17,14,23,32,42,5,28,3,22,41,39,12,29,2,27,40,38,13,20,11,26,37,0,21,10,19,36,46,1,24,7 },
	{ 5,40,15,37,12,16,44,27,9,20,41,23,13,17,45,2,24,34,21,22,28,31,3,25,35,10,6,42,29,38,30,18,0,11,32,7,43,4,39,14,36,19,46,1,26,33,8 },
	{ 19,22,0,5,3,36,34,39,10,15,24,12,27,46,41,23,16,4,2,7,38,33,14,25,28,26,31,9,43,40,45,17,20,18,6,1,32,37,35,29,11,30,8,13,42,44,21 },
	{ 17,39,18,21,41,22,45,24,3,28,7,9,10,13,14,34,0,38,19,4,40,23,43,44,25,26,29,33,30,37,16,11,20,15,1,2,5,6,42,8,46,27,12,32,31,35,36 },
	{ 29,7,1,35,22,45,20,10,8,38,31,32,17,3,13,26,41,24,6,4,34,19,44,21,15,9,43,30,37,28,2,0,46,23,40,25,11,5,39,18,33,16,14,12,42,27,36 },
	{ 5,22,42,0,19,21,36,10,16,33,15,9,30,34,12,27,39,29,40,2,24,45,7,1,18,46,4,23,43,17,32,14,20,37,11,13,26,38,8,31,35,25,44,6,28,41,3 },
	{ 23,5,9,6,24,33,12,3,40,7,10,25,16,13,34,14,28,41,38,11,37,17,26,35,15,0,29,20,30,39,42,36,27,18,46,1,45,21,31,22,43,4,8,19,32,44,2 },
},
{
	/* Frame 105 */
	{ 16,18,36,0,38,2,17,19,37,1,39,3,20,22,40,4,42,6,21,23,41,5,43,7,24,26,44,8,46,10,25,27,45,9,11,28,30,32,12,34,14,29,31,33,13,35,15 },
	{ 23,17,29,10,6,0,12,26,22,16,28,11,7,1,13,42,46,32,36,43,33,37,19,31,25,21,2,14,8,4,18,30,24,20,3,15,9,5,34,38,40,44,35,39,41,45,27 },
	{ 31,0,21,46,36,11,22,1,24,37,2,23,12,25,38,40,3,26,13,16,39,41,14,27,4,17,42,32,15,18,5,28,43,33,6,19,8,29,34,44,7,30,9,20,35,45,10 },
	{ 1,22,25,2,20,11,44,35,0,7,24,33,5,10,29,34,43,6,9,15,32,39,4,26,28,19,37,42,8,14,17,38,41,27,13,18,36,30,16,23,40,46,12,3,21,45,31 },
	{ 41,31,10,28,27,13,24,35,1,22,36,7,18,4,40,11,29,8,46,45,25,14,34,33,23,2,20,39,19,5,16,43,9,30,44,15,26,12,32,3,21,0,38,37,17,6,42 },
	{ 25,30,19,8,5,2,40,16,27,38,13,33,10,7,24,21,18,4,46,35,41,36,15,29,26,23,12,1,43,6,44,20,31,34,9,37,14,3,28,17,22,0,42,39,45,32,11 },
	{ 37,0,41,12,46,11,23,1,44,13,10,22,31,45,8,21,19,30,34,9,20,18,27,35,6,17,29,32,26,38,7,43,16,28,33,4,39,2,42,15,25,36,5,40,3,14,24 },
	{ 24,20,30,18,25,21,31,19,44,36,42,34,45,37,43,35,12,4,10,2,13,5,11,3,28,16,26,22,29,17,27,23,40,32,46,38,41,33,39,8,0,14,6,9,1,15,7 },
	{ 27,20,29,39,40,19,44,30,21,43,38,9,45,22,31,42,1,8,12,23,11,0,4,13,3,10,33,46,5,24,2,32,15,36,16,25,35,7,14,37,26,17,34,28,6,41,18 },
	{ 44,3,14,35,26,46,17,28,9,19,41,22,11,0,43,5,32,25,37,2,7,34,27,39,30,21,8,13,40,23,45,10,15,42,4,16,36,29,6,18,38,31,20,1,12,33,24 },
	{ 37,3,45,26,36,2,44,10,19,11,18,31,35,7,30,34,6,42,14,23,43,15,22,1,9,39,0,8,38,17,46,25,16,24,33,5,41,13,32,4,40,12,21,29,20,28,27 },
	{ 20,39,31,13,2,41,17,34,22,4,15,36,24,43,19,1,6,45,21,38,26,8,3,40,28,23,5,10,33,25,42,30,12,7,44,16,35,27,9,14,37,29,46,18,0,11,32 },
},
{
	/* Frame 106 */
	{ 4,23,16,32,2,1,30,38,29,37,15,8,27,43,20,44,6,5,18,34,17,33,3,12,31,39,24,40,10,9,22,46,21,45,7,0,19,35,28,36,14,13,26,42,25,41,11 },
	{ 24,0,13,38,20,27,1,40,39,14,23,26,32,41,2,15,29,22,33,8,3,42,17,28,4,9,34,43,16,31,5,44,35,10,19,30,36,45,6,11,25,18,37,12,7,46,21 },
	{ 41,4,25,3,30,20,44,8,39,19,43,6,33,10,17,13,22,46,26,36,0,29,35,24,2,15,40,5,9,38,18,42,31,21,45,16,12,7,32,11,1,28,34,23,27,37,14 },
	{ 16,28,25,32,19,14,11,17,13,24,30,10,7,46,43,12,9,5,45,31,26,6,3,42,39,8,4,1,44,41,37,27,22,2,38,35,20,0,29,40,36,33,23,18,15,34,21 },
	{ 38,32,36,35,39,33,37,3,7,1,5,2,6,0,4,19,31,17,29,18,30,16,28,42,46,40,44,43,41,45,11,15,9,13,10,14,8,12,27,23,25,21,26,22,24,20,34 },
	{ 16,34,23,37,43,13,10,0,21,7,18,32,28,46,27,41,35,5,2,12,25,11,30,44,20,38,19,33,9,14,4,17,3,22,36,24,42,31,45,39,1,6,8,29,15,26,40 },
	{ 9,42,30,2,4,35,24,14,40,19,36,21,7,46,26,12,0,39,22,33,10,44,29,17,3,5,8,43,31,41,18,37,20,34,25,15,13,1,6,27,45,28,16,38,23,32,11 },
	{ 16,31,38,12,1,29,36,2,30,23,45,0,11,28,21,46,35,9,22,44,33,10,7,20,27,34,8,5,25,32,43,6,26,19,41,4,15,24,17,42,39,13,18,40,37,14,3 },
	{ 17,28,41,6,27,4,29,3,40,39,5,24,2,15,38,36,25,22,35,14,1,12,37,23,11,34,0,13,18,10,20,46,33,44,19,30,43,21,9,32,45,31,16,42,8,7,26 },
	{ 22,21,44,2,1,19,36,30,29,10,34,9,33,27,6,5,23,42,16,41,3,14,38,13,37,31,24,11,35,8,46,20,45,7,0,18,43,17,40,28,15,39,12,32,26,25,4 },
	{ 23,9,21,10,22,8,20,43,41,42,40,27,15,25,13,26,14,24,12,45,46,44,3,31,1,29,2,30,0,28,35,33,34,32,19,7,17,5,18,6,16,4,39,37,38,36,11 },
	{ 13,16,3,22,37,43,12,21,2,27,36,46,1,20,7,26,41,0,25,6,31,40,34,5,24,11,30,45,35,4,29,10,19,44,38,9,28,15,18,33,39,8,17,14,23,32,42 },
},
{
	/* Frame 107 */
	{ 26,20,14,33,0,27,21,34,15,40,1,22,28,35,2,41,8,23,29,42,3,36,9,30,16,43,10,37,4,31,17,38,11,44,5,18,24,39,6,45,12,19,25,46,7,32,13 },
	{ 41,6,32,46,40,7,0,14,8,38,1,15,9,39,16,20,24,28,17,21,25,29,43,37,2,45,42,36,3,44,10,4,34,12,11,5,35,13,18,22,19,23,26,30,27,31,33 },
	{ 6,23,9,24,34,45,7,26,8,17,35,36,10,27,1,16,46,37,11,18,0,29,40,2,19,13,28,38,41,3,30,12,21,39,32,14,31,5,20,42,33,15,22,4,25,43,44 },
	{ 35,23,1,40,28,27,19,7,43,24,12,36,3,15,8,32,20,45,11,30,38,16,4,41,29,26,34,22,0,46,25,13,37,18,6,42,9,33,21,2,14,39,17,5,44,10,31 },
	{ 30,11,41,14,25,44,20,1,23,34,4,18,7,37,10,29,40,43,24,13,27,46,0,22,3,33,6,17,36,39,28,9,31,42,12,26,15,45,2,21,32,35,16,5,19,38,8 },
	{ 17,31,28,3,44,0,14,25,22,5,11,38,8,37,19,16,30,35,13,32,46,2,45,21,27,24,43,7,40,4,10,29,18,1,15,34,12,33,23,20,26,39,9,36,42,6,41 },
	{ 26,2,36,14,41,23,31,9,17,38,28,42,5,12,10,45,19,27,7,33,15,40,24,46,1,8,20,35,29,43,4,3,37,11,44,22,30,6,32,16,39,25,0,13,21,34,18 },
	{ 36,38,37,39,4,24,6,26,5,25,7,27,40,42,41,43,16,8,18,10,17,9,19,11,32,34,33,35,0,28,2,30,1,29,3,31,44,46,45,20,12,22,14,21,13,23,15 },
	{ 7,1,5,19,23,17,21,2,6,0,4,18,22,16,20,35,33,45,34,32,46,44,24,28,11,15,9,13,27,31,25,29,10,14,8,12,26,30,39,43,37,41,38,42,36,40,3 },
	{ 1,10,17,40,26,39,12,15,28,33,31,34,9,6,25,36,22,0,3,16,41,19,42,5,14,21,44,30,35,8,11,24,37,27,38,13,2,29,32,18,43,4,7,20,45,23,46 },
	{ 25,39,4,45,10,37,22,43,8,38,20,28,26,36,3,23,42,15,9,1,21,40,29,27,2,14,35,0,41,12,33,18,30,34,7,16,46,24,13,32,5,19,44,11,31,6,17 },
	{ 30,14,28,12,45,31,15,29,13,46,44,18,10,16,8,43,41,19,11,17,9,42,40,22,6,20,4,39,37,23,7,21,5,38,36,26,2,24,0,35,33,27,3,25,1,34,32 },
},
{
	/* Frame 108 */
	{ 2,29,36,26,0,15,24,45,19,42,13,10,17,40,22,39,8,3,20,37,27,34,1,6,25,32,30,43,4,11,28,41,23,46,9,14,21,44,18,35,12,7,16,33,31,38,5 },
	{ 12,30,36,11,17,2,22,5,9,26,0,14,29,38,41,18,43,32,24,21,44,7,37,10,16,34,13,31,4,8,3,23,46,28,39,40,27,1,15,20,45,6,19,42,33,25,35 },
	{ 41,2,31,46,21,36,9,18,14,4,43,16,33,28,45,23,38,11,1,13,6,27,35,30,20,37,25,40,3,15,5,42,8,19,22,39,10,17,32,29,44,7,26,34,0,12,24 },
	{ 29,16,37,40,6,27,46,3,13,43,24,23,32,18,39,5,8,14,11,20,34,44,0,31,41,7,26,28,17,36,25,22,33,2,12,42,9,15,19,38,4,35,45,1,30,10,21 },
	{ 16,2,18,1,17,3,19,32,34,33,35,4,28,6,30,5,29,7,31,36,38,37,39,8,24,10,26,9,25,11,27,40,42,41,43,12,20,14,22,13,21,15,23,44,46,45,0 },
	{ 36,16,39,19,13,14,45,21,34,22,0,3,40,28,43,31,5,6,37,25,46,26,12,15,32,20,35,23,9,10,41,17,38,18,4,7,44,24,27,1,2,33,29,42,30,8,11 },
	{ 18,1,45,23,42,4,40,7,10,8,37,15,28,32,30,35,19,46,0,44,3,43,20,6,11,24,36,26,39,29,31,34,13,16,2,21,22,5,41,25,27,38,9,14,12,33,17 },
	{ 37,28,7,46,16,13,34,1,40,10,36,6,31,12,19,0,25,43,21,39,30,45,18,15,33,24,3,42,20,9,38,5,44,14,32,2,27,8,23,4,29,17,35,26,41,22,11 },
	{ 35,15,43,23,31,6,34,14,42,22,30,39,24,1,9,17,38,25,46,0,8,16,28,5,33,13,41,21,29,4,32,12,40,20,3,37,11,45,19,27,2,36,10,44,18,26,7 },
	{ 28,36,23,0,11,25,33,30,38,13,2,16,40,27,35,4,15,29,37,18,42,1,6,20,44,31,39,8,3,17,41,22,46,5,10,24,32,19,43,12,7,21,45,26,34,9,14 },
	{ 28,2,31,16,37,19,41,46,29,34,30,17,4,18,7,8,11,44,35,32,5,6,9,20,10,23,24,45,27,33,38,21,42,22,25,12,26,15,0,3,39,36,43,40,13,14,1 },
	{ 20,37,2,1,30,29,40,11,4,23,38,24,33,14,13,18,43,17,36,7,0,27,34,28,45,10,9,22,39,21,32,3,12,31,46,16,41,6,5,26,35,25,44,15,8,19,42 },
},
{
	/* Frame 109 */
	{ 31,11,40,30,10,41,42,28,8,43,29,9,15,44,14,45,16,46,18,12,17,19,13,32,34,33,35,20,0,22,2,21,1,23,3,27,36,38,26,37,39,4,24,6,5,25,7 },
	{ 21,10,14,0,4,26,30,16,20,11,15,1,5,27,31,42,38,32,44,43,39,33,45,25,29,2,6,8,12,18,22,24,28,3,7,9,13,19,23,34,46,40,36,35,41,37,17 },
	{ 21,36,18,43,12,7,16,41,31,46,5,2,29,44,26,39,0,15,24,37,19,34,13,10,17,32,22,8,3,20,45,27,42,1,6,25,40,30,35,4,11,28,33,23,38,9,14 },
	{ 4,8,34,1,6,27,3,20,46,9,0,43,22,15,2,21,28,16,42,23,44,14,37,18,11,29,39,17,24,45,30,36,19,40,10,33,12,38,5,25,35,31,7,41,26,32,13 },
	{ 10,1,31,4,46,27,8,22,34,29,39,18,44,25,7,43,20,32,11,37,16,14,5,41,2,9,23,12,38,19,0,30,42,21,26,36,17,15,35,28,40,3,45,24,6,13,33 },
	{ 5,10,0,7,29,42,2,24,31,39,40,21,26,34,45,16,23,9,32,18,12,37,11,1,14,4,43,3,25,46,6,28,27,35,44,17,30,38,41,20,19,13,36,22,8,33,15 },
	{ 37,4,35,2,46,15,25,5,38,3,14,24,27,39,6,17,29,26,40,7,16,28,31,41,8,21,19,32,30,44,9,43,20,18,33,0,45,12,42,11,23,36,1,34,13,10,22 },
	{ 9,38,27,0,18,13,40,23,4,33,30,44,17,11,37,24,2,29,15,42,20,6,35,1,46,19,8,39,26,5,32,31,12,41,22,36,25,3,45,16,10,21,7,34,28,14,43 },
	{ 43,20,25,7,14,35,21,8,6,27,44,0,9,23,26,36,45,46,1,28,22,11,37,38,16,29,3,10,39,17,12,2,31,40,4,13,19,30,32,41,42,5,24,18,15,33,34 },
	{ 20,46,16,42,4,0,21,17,43,5,1,28,24,36,12,32,8,29,25,37,13,33,9,18,6,44,2,40,23,19,7,45,3,41,22,26,38,14,34,10,31,27,39,15,35,11,30 },
	{ 39,8,11,41,4,42,23,0,44,19,33,13,34,14,28,9,36,10,24,5,6,20,1,45,2,46,16,35,30,29,37,26,38,25,7,40,21,43,22,3,17,18,31,32,12,15,27 },
	{ 26,29,23,0,45,39,11,32,24,18,21,14,37,9,3,46,16,27,12,6,43,1,44,38,30,25,19,4,41,35,15,36,28,22,17,10,33,13,7,42,20,31,8,2,5,40,34 },
},
{
	/* Frame 110 */
	{ 14,20,12,23,11,26,41,24,43,31,38,4,7,33,16,2,19,15,45,22,27,40,42,9,37,6,29,32,35,18,1,44,46,21,13,10,8,25,36,30,39,28,5,34,0,17,3 },
	{ 26,36,41,6,15,18,37,8,7,42,28,0,9,38,43,20,29,31,1,44,39,10,21,23,30,32,45,2,11,22,33,12,3,46,24,4,13,34,16,25,27,5,40,35,14,17,19 },
	{ 3,38,31,43,10,32,1,36,29,41,25,18,39,6,11,46,0,37,4,40,9,44,19,7,26,14,5,8,45,12,22,34,27,15,20,16,13,23,35,2,30,42,21,33,17,28,24 },
	{ 38,14,2,11,37,29,1,32,24,39,30,46,3,34,10,43,12,20,33,25,31,22,35,26,42,13,44,21,8,16,23,27,18,45,4,9,40,17,6,15,19,5,36,28,41,0,7 },
	{ 37,43,0,4,10,14,32,36,42,46,1,5,11,15,16,28,26,22,17,29,27,23,41,45,35,39,8,12,2,6,40,44,34,38,9,13,3,7,24,20,18,30,25,21,19,31,33 },
	{ 17,6,41,20,3,13,38,22,8,35,19,36,29,10,33,24,15,5,42,26,0,31,40,21,2,45,16,7,9,34,18,12,39,23,32,25,14,37,28,11,1,46,30,4,43,27,44 },
	{ 7,42,26,12,0,41,22,10,34,29,36,17,9,46,30,2,4,45,24,33,14,38,19,21,13,1,6,43,27,35,28,37,16,40,23,11,3,5,8,31,39,18,20,44,25,32,15 },
	{ 32,22,3,21,38,18,4,17,42,8,31,45,14,27,13,33,2,20,1,39,36,16,7,43,40,30,11,29,46,26,12,25,34,0,23,37,6,19,5,41,10,28,9,44,24,15,35 },
	{ 28,1,11,18,37,34,29,16,10,7,35,8,17,27,6,44,9,4,26,23,45,32,42,24,5,15,22,33,43,38,25,20,14,3,39,12,21,31,2,40,13,0,30,19,41,36,46 },
	{ 39,12,33,27,23,42,17,40,13,36,26,22,16,41,2,37,31,25,46,21,44,3,30,24,20,45,6,0,29,11,34,7,1,28,10,35,8,4,19,15,38,9,32,5,18,43,14 },
	{ 29,0,42,17,6,45,31,2,20,41,19,5,24,36,1,22,43,32,7,26,12,38,3,21,8,34,25,14,37,23,10,28,33,27,13,16,39,44,9,30,35,40,15,18,4,46,11 },
	{ 23,10,1,24,46,37,40,22,27,0,13,41,3,26,17,12,39,2,15,16,29,38,43,32,19,14,5,28,42,33,44,18,31,4,9,45,7,30,21,8,35,6,11,20,25,34,36 },
},
{
	/* Frame 111 */
	{ 13,16,32,27,43,23,39,44,0,20,11,7,18,34,24,40,4,31,2,8,28,37,15,26,42,22,38,12,17,33,21,10,6,45,1,5,30,46,19,35,25,41,29,36,14,3,9 },
	{ 14,2,6,11,15,3,7,42,46,34,38,43,35,39,26,18,28,27,19,29,20,21,33,37,8,12,32,36,9,13,0,4,40,44,1,5,41,45,30,24,22,31,25,23,16,17,10 },
	{ 23,34,12,10,20,33,18,9,3,17,36,31,42,0,6,28,41,26,35,5,11,25,44,19,38,8,14,16,37,22,43,13,7,21,32,27,46,4,2,24,45,30,39,1,15,29,40 },
	{ 5,24,14,45,2,37,20,8,46,31,34,19,11,40,28,0,6,43,26,12,32,17,38,23,15,44,3,4,25,30,35,18,36,21,9,1,7,10,41,29,33,16,39,22,42,27,13 },
	{ 29,41,22,34,13,6,24,44,31,43,0,15,17,37,26,46,9,2,28,40,19,39,12,11,21,33,30,42,5,14,16,36,23,35,8,7,25,45,18,38,1,10,20,32,27,4,3 },
	{ 26,3,8,21,39,44,37,27,18,9,0,36,14,19,24,1,42,15,6,25,16,43,34,41,30,7,12,17,35,40,33,31,22,13,4,32,10,23,28,5,46,11,2,29,20,38,45 },
	{ 30,12,36,10,35,25,27,7,21,44,18,42,1,2,14,39,29,31,9,33,11,34,22,46,5,6,16,41,19,43,0,13,37,15,38,24,26,8,32,20,45,23,4,3,17,40,28 },
	{ 40,5,31,33,12,22,17,36,3,24,45,10,29,34,15,20,43,6,1,27,46,8,18,39,32,13,23,41,4,30,25,44,11,16,37,2,21,42,7,28,35,14,9,19,38,0,26 },
	{ 7,40,44,35,39,9,13,2,6,41,45,34,38,8,12,19,31,25,21,18,30,24,20,11,15,32,36,43,1,5,10,14,33,37,42,46,0,4,27,23,17,29,26,22,16,28,3 },
	{ 26,6,36,39,24,4,27,7,37,38,25,5,22,14,44,20,12,23,15,45,46,21,13,30,2,32,35,28,0,31,3,33,34,29,1,18,10,40,43,16,8,19,11,41,42,17,9 },
	{ 44,3,30,33,25,21,42,7,18,29,9,36,22,1,13,34,10,39,40,5,16,14,27,24,20,43,45,2,31,32,28,8,37,6,19,46,12,35,11,23,0,15,26,38,41,4,17 },
	{ 28,20,30,22,29,21,31,23,8,4,10,6,41,37,43,39,9,5,11,7,40,36,42,38,24,16,26,18,25,17,27,19,12,0,14,2,45,33,35,13,1,15,3,44,32,46,34 },
},
{
	/* Frame 112 */
	{ 24,4,29,8,13,27,39,11,18,46,25,36,28,9,16,12,21,6,34,19,37,32,17,44,20,7,30,35,14,42,33,45,40,31,2,15,22,43,0,5,41,3,26,38,23,10,1 },
	{ 44,16,34,11,23,36,14,3,29,9,20,26,6,46,1,41,43,38,24,19,13,33,31,35,10,22,5,45,17,2,28,8,37,15,0,40,21,27,7,18,12,32,30,42,39,25,4 },
	{ 21,8,43,28,32,7,27,41,31,5,16,29,6,2,40,15,4,39,17,13,24,37,3,14,10,38,1,34,12,25,36,18,22,45,11,0,35,20,46,9,42,19,33,23,44,26,30 },
	{ 32,15,38,18,21,45,25,30,2,46,5,9,36,16,40,22,10,35,29,43,0,6,27,13,20,44,24,33,14,39,19,4,8,31,3,11,34,28,37,17,41,23,26,12,42,1,7 },
	{ 19,9,25,35,41,2,18,8,24,34,40,7,31,13,21,39,45,6,30,12,20,38,44,11,27,1,17,43,33,10,26,0,16,42,32,15,23,5,29,37,14,22,4,28,46,36,3 },
	{ 18,33,43,4,29,14,31,32,42,5,20,7,30,45,35,8,21,6,23,44,34,9,24,11,22,37,0,25,10,27,36,46,1,16,3,26,41,39,12,17,2,19,40,38,13,28,15 },
	{ 28,5,39,25,42,0,34,9,14,6,37,11,18,32,26,41,29,46,4,38,13,43,16,8,15,22,36,30,45,19,27,40,3,20,12,17,24,1,35,23,31,44,7,10,2,33,21 },
	{ 41,44,2,7,9,22,24,29,43,46,32,4,11,26,31,17,45,34,6,8,13,28,19,33,36,10,15,1,30,16,21,35,38,40,12,3,18,23,25,37,42,14,0,5,20,27,39 },
	{ 27,44,13,25,14,26,45,46,12,24,31,3,32,35,29,1,30,2,33,34,28,0,7,19,36,39,5,17,6,18,37,38,4,16,23,11,40,43,21,9,22,10,41,42,20,8,15 },
	{ 25,0,30,7,41,46,28,1,19,6,40,35,29,4,18,11,45,34,16,5,23,10,44,39,17,8,22,15,33,38,20,9,27,14,32,43,21,12,26,3,37,42,24,13,31,2,36 },
	{ 11,12,2,5,15,42,16,6,35,25,46,19,28,32,39,26,21,41,31,36,0,22,45,9,3,4,10,13,7,34,24,14,43,17,38,27,20,40,18,29,33,23,44,8,30,37,1 },
	{ 26,0,3,28,31,38,41,5,18,25,14,35,44,20,23,8,37,11,17,46,2,13,32,30,4,43,7,24,27,34,45,1,22,29,10,39,40,16,19,12,33,15,21,42,6,9,36 },
},
{
	/* Frame 113 */
	{ 43,11,24,26,40,8,42,10,25,27,41,9,15,28,30,44,12,46,14,29,31,45,13,35,3,16,18,32,0,34,2,17,19,33,1,39,7,20,22,36,4,38,6,21,23,37,5 },
	{ 45,17,38,26,5,14,40,20,19,8,7,33,29,42,22,1,10,44,16,35,31,4,3,37,25,46,18,13,6,32,28,39,27,0,15,41,21,34,30,9,2,36,24,43,23,12,11 },
	{ 34,10,7,28,17,46,33,11,22,29,4,45,32,26,23,8,5,39,44,27,2,9,20,43,38,14,3,24,21,42,37,15,18,25,0,41,36,30,19,12,1,35,40,31,6,13,16 },
	{ 3,30,1,29,19,15,17,12,2,31,0,28,18,14,16,45,35,33,44,34,32,46,7,9,5,26,23,25,21,11,6,8,4,27,22,24,20,10,39,41,37,43,38,40,36,42,13 },
	{ 41,4,22,32,13,31,16,37,10,25,44,3,28,43,6,21,34,15,0,18,39,9,27,46,33,12,30,40,5,23,24,45,2,17,36,11,20,35,14,29,42,7,8,26,1,19,38 },
	{ 14,1,4,26,16,44,35,38,15,33,5,27,22,17,28,2,39,8,32,37,42,23,29,3,6,9,12,18,24,36,43,46,7,41,13,19,30,25,20,10,0,40,45,34,31,21,11 },
	{ 30,14,44,28,12,31,15,45,46,29,13,18,6,36,39,16,4,19,7,37,38,17,5,26,10,40,43,24,8,27,11,41,42,25,9,22,2,32,35,20,0,23,3,33,34,21,1 },
	{ 35,33,34,46,32,44,45,11,3,9,1,10,2,8,0,26,18,24,16,27,19,25,17,43,41,39,42,40,38,36,37,28,20,15,7,29,21,14,6,12,4,30,22,13,5,31,23 },
	{ 41,33,43,35,40,32,42,34,14,17,29,19,31,1,13,3,15,16,28,18,30,0,12,2,46,38,45,37,39,44,36,25,6,27,21,9,23,11,5,24,7,26,20,8,22,10,4 },
	{ 21,38,13,2,41,32,27,46,7,12,37,40,1,24,6,45,36,31,0,18,25,44,5,30,28,19,11,4,29,16,10,35,23,15,17,43,34,9,22,20,14,39,42,3,8,33,26 },
	{ 42,0,46,5,16,21,43,1,4,17,28,8,32,13,37,24,29,9,33,12,36,25,2,6,40,18,45,22,3,7,41,19,44,23,10,34,14,38,26,30,11,35,15,39,27,31,20 },
	{ 31,6,46,3,18,10,35,5,20,13,28,37,17,40,25,32,7,22,14,39,19,11,26,34,43,21,44,29,36,41,0,8,23,15,30,38,27,2,42,45,4,12,1,16,9,24,33 },
},
{
	/* Frame 114 */
	{ 30,42,29,41,11,8,27,35,20,32,6,5,18,38,17,37,15,12,31,24,44,10,9,22,34,21,33,3,0,19,43,28,40,14,13,26,46,25,45,7,4,23,39,16,36,2,1 },
	{ 46,27,45,16,3,12,43,22,36,21,10,9,34,19,33,28,15,4,39,26,44,25,2,1,42,31,41,20,7,8,18,32,17,14,13,38,23,37,24,11,0,35,30,40,29,6,5 },
	{ 6,30,1,43,37,8,44,21,15,3,38,10,4,33,28,19,40,17,26,22,13,35,31,0,42,36,24,7,14,2,9,45,20,32,29,18,39,11,5,46,23,12,34,41,16,27,25 },
	{ 18,20,16,7,3,5,1,23,19,21,17,6,2,4,0,39,35,37,33,38,34,36,32,13,9,30,26,29,25,15,11,12,8,31,27,28,24,14,10,45,41,43,44,40,46,42,22 },
	{ 13,16,11,28,7,26,33,22,45,17,43,29,8,39,27,4,32,23,2,44,14,42,9,38,5,24,3,20,15,18,41,30,37,25,35,21,0,19,12,40,31,10,36,6,34,1,46 },
	{ 34,45,21,39,26,1,16,14,23,4,3,44,38,33,17,43,22,5,28,2,19,8,7,32,42,37,29,18,9,24,6,31,12,11,36,46,41,25,35,30,13,20,10,27,0,15,40 },
	{ 41,31,15,40,30,14,25,9,46,24,8,33,19,7,32,18,6,21,1,38,20,0,39,45,27,11,44,26,10,29,13,42,28,12,43,37,23,3,36,22,2,17,5,34,16,4,35 },
	{ 36,7,26,5,41,32,3,14,16,10,4,25,33,15,0,13,46,11,21,24,23,42,1,12,19,38,45,20,8,22,43,34,29,18,31,39,44,37,9,6,27,35,40,28,2,30,17 },
	{ 6,46,19,23,3,43,7,18,22,2,42,14,27,33,31,37,11,15,26,32,30,36,10,17,21,1,41,5,45,16,20,0,40,4,44,38,25,29,9,35,13,39,24,28,8,34,12 },
	{ 8,30,0,22,24,15,16,7,9,31,1,23,25,14,17,38,34,43,39,35,46,42,12,2,4,26,28,18,20,11,13,3,5,27,29,19,21,10,44,40,36,32,45,41,37,33,6 },
	{ 24,6,26,36,38,5,25,7,27,37,39,12,20,14,22,44,46,13,21,15,23,45,0,28,2,30,32,34,1,29,3,31,33,35,8,16,10,18,40,42,9,17,11,19,41,43,4 },
	{ 12,1,31,7,10,44,28,33,17,39,23,26,2,5,9,14,34,18,37,21,41,25,0,30,6,42,13,32,16,38,22,11,45,29,4,8,46,27,3,36,20,40,24,15,35,19,43 },
},
{
	/* Frame 115 */
	{ 36,13,18,24,43,6,45,12,19,25,38,7,44,1,26,20,39,14,33,0,27,21,46,15,32,9,22,28,2,41,8,23,29,34,3,40,5,30,16,35,10,37,4,31,17,42,11 },
	{ 8,32,23,13,26,37,18,44,21,10,28,2,15,25,38,46,9,30,33,22,40,27,4,45,11,29,34,42,39,16,7,31,0,41,5,12,36,19,35,20,43,3,17,14,24,6,1 },
	{ 32,30,23,12,5,40,31,2,13,20,38,10,3,28,21,46,39,37,11,18,29,0,45,36,26,19,8,1,44,27,6,9,16,34,14,7,24,17,42,35,33,15,22,25,4,43,41 },
	{ 33,21,34,22,37,25,38,27,41,29,43,31,45,1,2,16,5,6,32,20,9,11,36,24,13,15,40,28,42,19,44,0,46,35,23,4,39,26,8,10,30,12,14,3,17,18,7 },
	{ 31,39,25,33,22,46,16,40,7,1,14,8,19,43,29,37,26,34,20,44,11,5,2,12,23,17,41,30,38,24,32,15,9,6,0,27,35,21,45,18,42,28,36,3,13,10,4 },
	{ 4,3,39,16,14,40,13,26,25,37,34,7,28,19,8,44,43,22,21,2,38,1,31,41,12,11,24,6,32,5,18,17,45,42,15,20,27,0,36,35,30,29,10,46,9,23,33 },
	{ 11,29,32,19,34,12,6,20,37,30,43,9,3,17,44,27,46,4,10,28,41,18,35,1,15,25,36,23,38,8,2,16,33,26,13,7,21,40,31,42,0,14,24,45,22,39,5 },
	{ 20,43,1,21,42,0,46,4,16,5,17,35,11,39,15,34,10,38,14,26,30,27,31,3,7,41,2,6,40,18,44,22,19,45,23,28,33,9,29,32,8,36,12,24,37,13,25 },
	{ 37,0,13,40,10,22,30,1,44,41,21,11,31,45,8,20,19,6,9,29,18,26,7,34,17,28,4,27,38,35,14,16,5,32,39,2,15,42,25,36,33,12,3,46,43,23,24 },
	{ 33,9,4,27,18,45,38,8,17,26,3,42,39,25,16,15,2,36,43,24,1,14,23,40,37,13,0,31,22,41,34,12,21,30,7,46,35,29,20,11,6,32,28,5,10,19,44 },
	{ 45,7,40,11,31,46,21,42,24,33,12,22,26,35,15,5,0,29,36,6,41,2,30,39,20,43,17,13,8,19,44,14,10,1,28,37,25,32,3,23,38,27,34,16,4,9,18 },
	{ 23,45,21,15,22,44,20,14,13,46,12,41,27,11,40,26,10,25,9,42,24,8,43,7,31,5,6,30,4,29,38,36,28,39,37,19,3,17,1,18,2,16,0,34,32,35,33 },
},
{
	/* Frame 116 */
	{ 20,33,27,42,13,6,25,40,30,39,4,11,28,45,23,34,1,14,21,32,18,43,12,7,16,37,31,46,9,2,29,44,26,35,0,15,24,41,19,38,5,10,17,36,22,8,3 },
	{ 24,14,27,36,22,7,43,31,1,2,25,26,13,6,21,42,30,41,35,46,12,39,20,5,40,29,34,33,45,38,4,8,28,11,16,32,19,44,15,37,23,9,10,17,0,18,3 },
	{ 22,42,24,1,45,30,38,4,9,3,46,12,20,33,11,19,17,28,36,41,7,27,35,25,0,44,15,23,43,8,2,31,39,5,32,10,18,13,21,40,6,26,34,16,29,37,14 },
	{ 15,28,32,25,44,27,46,41,7,43,21,16,37,19,38,0,30,35,12,14,9,11,24,22,5,40,6,42,3,17,36,29,33,31,34,45,26,8,10,20,23,4,18,39,1,2,13 },
	{ 17,46,9,43,26,36,2,23,33,16,15,8,29,42,5,39,22,32,14,19,45,28,11,4,25,38,1,35,18,44,10,31,41,24,7,0,21,34,13,30,40,6,27,37,20,3,12 },
	{ 32,17,39,30,5,10,45,20,46,19,0,7,36,29,43,26,9,14,33,16,34,31,4,11,40,25,22,13,2,37,28,38,27,8,15,44,21,35,18,1,6,41,24,42,23,12,3 },
	{ 13,3,21,4,27,14,28,33,22,38,44,43,5,15,29,8,23,6,16,45,30,42,36,35,9,7,17,0,31,10,24,37,18,34,40,1,11,25,12,19,2,20,41,26,46,32,39 },
	{ 21,44,17,9,13,7,46,19,11,32,30,20,16,34,12,18,33,14,37,0,35,29,25,2,23,15,36,27,1,40,5,28,38,24,3,42,22,26,41,4,45,39,8,43,6,10,31 },
	{ 27,30,41,44,16,21,32,31,8,45,42,20,19,33,36,9,12,43,46,18,23,0,37,34,13,10,22,1,4,35,38,11,14,5,2,39,15,25,3,6,24,29,26,40,7,17,28 },
	{ 0,14,2,44,32,46,34,13,1,15,3,45,33,35,28,24,30,26,29,25,31,27,4,8,6,10,36,40,38,42,5,9,7,11,37,41,39,43,20,16,22,18,21,17,23,19,12 },
	{ 33,28,42,19,8,7,44,21,30,1,10,41,16,38,27,4,15,32,29,35,18,9,6,37,24,46,23,12,3,40,17,43,26,5,14,45,20,34,31,0,11,36,25,39,22,13,2 },
	{ 7,33,19,2,14,22,41,26,42,38,4,3,16,15,23,12,27,10,24,39,30,5,34,17,0,13,20,11,25,8,31,36,28,35,1,44,21,9,37,29,6,32,18,45,46,40,43 },
},
{
	/* Frame 117 */
	{ 17,1,19,3,16,0,18,2,32,34,33,35,21,5,23,7,20,4,22,6,36,38,37,39,27,11,40,26,10,41,42,24,8,43,25,9,31,15,44,30,14,45,46,28,12,29,13 },
	{ 10,36,16,31,4,15,45,25,38,18,13,6,40,28,35,27,0,11,33,21,42,30,9,2,44,24,39,23,12,7,37,17,46,26,5,14,32,20,43,19,8,3,41,29,34,22,1 },
	{ 24,11,0,41,23,13,38,14,17,18,32,8,35,31,20,7,46,37,25,26,1,40,2,43,28,15,4,45,19,9,34,10,21,22,36,12,39,27,16,3,42,33,29,30,5,44,6 },
	{ 12,15,37,28,39,31,13,14,36,29,38,26,8,11,33,24,35,27,9,10,32,25,34,20,22,44,5,7,21,23,45,4,46,6,16,18,40,1,43,3,17,19,41,0,42,2,30 },
	{ 10,7,16,29,35,46,19,6,1,28,40,18,31,0,13,41,36,3,30,25,12,42,37,2,15,24,21,43,38,27,14,9,20,39,32,26,23,8,5,33,44,11,22,17,4,34,45 },
	{ 15,40,36,2,14,41,37,35,9,5,34,46,8,4,19,23,18,22,25,29,24,28,11,7,32,44,10,6,33,45,43,39,1,13,42,38,0,12,27,31,26,30,17,21,16,20,3 },
	{ 30,6,32,39,24,0,31,7,33,38,25,1,18,14,40,20,8,19,15,41,46,21,9,26,2,36,35,28,4,27,3,37,34,29,5,22,10,44,43,16,12,23,11,45,42,17,13 },
	{ 19,5,38,8,14,23,3,43,12,25,32,7,41,37,27,29,46,16,31,11,44,34,20,0,39,9,15,18,4,13,24,33,22,2,42,28,17,6,40,36,26,45,35,21,1,30,10 },
	{ 31,23,25,17,30,22,24,16,43,39,45,33,11,7,13,1,42,38,44,32,10,6,12,0,27,19,29,21,26,18,28,20,35,41,37,15,3,9,5,46,34,40,36,14,2,8,4 },
	{ 18,40,17,3,24,32,10,9,22,44,21,7,36,14,13,0,42,19,41,26,34,25,33,11,4,46,23,45,20,30,38,29,37,15,16,2,1,43,8,27,35,6,5,12,31,39,28 },
	{ 40,22,43,4,14,29,33,31,18,1,44,10,38,24,27,6,21,41,23,34,13,15,2,46,16,19,8,37,11,39,25,42,5,7,28,32,30,35,12,0,45,3,17,26,9,36,20 },
	{ 29,16,1,8,4,44,33,19,26,23,30,11,38,15,34,43,17,24,20,9,5,12,32,41,37,27,31,39,46,2,42,6,25,21,28,13,0,40,36,45,18,22,3,10,7,14,35 },
},
{
	/* Frame 118 */
	{ 19,4,38,1,20,2,33,27,44,46,13,10,8,29,5,16,6,37,21,3,22,32,35,14,12,25,11,30,41,28,43,17,7,18,36,39,23,0,34,15,26,45,24,31,40,42,9 },
	{ 12,22,32,21,10,1,38,19,45,28,15,4,35,26,40,25,2,13,46,31,33,20,7,8,43,18,36,17,14,5,34,23,41,24,11,0,39,30,44,29,6,9,42,27,37,16,3 },
	{ 36,15,20,29,33,40,34,27,0,24,37,44,4,28,23,41,35,42,1,8,2,45,38,5,12,22,31,43,9,3,10,39,46,13,6,30,18,11,17,7,14,21,32,19,26,16,25 },
	{ 36,6,38,20,22,5,37,7,39,21,23,0,32,2,34,16,18,1,33,3,35,17,19,30,12,44,15,28,31,13,45,14,46,29,26,8,40,11,43,24,27,9,41,10,42,25,4 },
	{ 16,38,27,28,40,23,36,25,10,21,6,8,3,4,15,43,1,39,26,13,41,22,34,37,24,46,19,20,32,31,44,17,2,29,14,0,11,12,7,35,9,18,5,33,30,42,45 },
	{ 10,18,33,11,19,1,25,42,0,24,43,36,14,30,37,15,31,5,21,46,4,20,40,2,26,41,3,27,9,17,34,8,16,35,44,6,22,45,7,23,13,29,38,12,28,39,32 },
	{ 37,31,7,36,30,6,29,5,38,28,4,39,45,19,15,44,18,14,17,13,46,16,12,33,27,3,32,26,2,25,1,34,24,0,35,41,23,11,40,22,10,21,9,42,20,8,43 },
	{ 24,17,45,5,12,41,46,11,39,18,42,6,35,30,23,25,37,16,44,9,4,33,28,40,21,10,38,3,27,34,15,22,36,1,8,32,29,20,13,2,26,19,14,43,7,31,0 },
	{ 39,37,7,31,5,29,38,36,6,30,4,28,45,19,15,17,13,46,44,18,14,16,12,35,33,3,27,1,25,34,32,2,26,0,24,43,41,23,11,21,9,42,40,22,10,20,8 },
	{ 3,21,10,41,36,16,23,25,43,38,18,5,27,44,32,7,9,14,34,20,11,29,40,37,22,24,31,0,39,46,26,13,2,33,8,15,17,35,42,28,19,4,45,30,1,6,12 },
	{ 30,34,25,37,10,13,23,43,28,32,7,8,18,46,21,41,2,5,31,35,16,44,11,0,26,38,29,33,14,9,19,24,36,3,12,22,42,17,45,6,1,27,39,20,40,15,4 },
	{ 22,46,3,29,17,41,4,45,30,35,11,25,12,0,19,43,7,20,32,8,27,39,15,2,28,16,40,36,23,34,10,24,5,44,31,18,42,6,13,1,26,38,14,21,33,9,37 },
},
{
	/* Frame 119 */
	{ 11,38,12,31,0,27,42,6,28,45,16,33,5,22,46,2,8,21,36,14,18,35,24,41,13,30,1,10,39,29,44,17,32,26,43,7,3,9,4,23,19,34,25,40,20,37,15 },
	{ 34,30,11,23,39,14,18,7,21,0,8,5,44,36,25,35,10,22,3,46,6,27,1,40,32,29,45,16,37,24,13,42,2,31,38,26,15,19,41,20,33,28,9,17,4,12,43 },
	{ 19,13,34,14,21,22,43,36,8,31,16,3,46,33,25,26,5,40,6,28,35,15,0,45,23,9,38,10,17,18,32,12,27,20,7,42,37,29,30,1,44,2,24,39,11,4,41 },
	{ 7,4,34,18,17,45,2,15,13,42,26,24,10,38,22,33,21,6,1,19,46,30,40,28,14,8,37,27,25,5,35,23,32,16,44,3,0,12,43,31,41,29,11,39,9,36,20 },
	{ 36,42,21,12,27,2,37,43,24,13,30,3,40,46,25,0,31,6,41,28,1,18,7,44,34,29,4,19,10,45,35,16,5,22,11,32,38,17,8,23,14,33,39,20,9,26,15 },
	{ 37,10,6,8,4,42,38,40,36,11,7,9,5,43,39,26,30,24,28,27,31,25,29,33,45,2,14,0,12,34,46,32,44,3,15,1,13,35,18,22,16,20,19,23,17,21,41 },
	{ 3,25,44,19,42,0,14,16,41,30,35,5,11,21,32,27,38,8,2,24,37,18,43,13,7,29,40,23,46,4,10,20,45,26,39,1,15,17,36,31,34,12,6,28,33,22,9 },
	{ 24,23,43,2,12,32,7,27,37,40,29,16,46,35,45,11,21,0,30,19,5,8,38,14,3,13,33,25,22,42,41,28,17,6,26,36,1,31,34,44,10,20,9,39,15,18,4 },
	{ 31,10,13,24,35,36,6,11,28,25,34,7,18,29,8,46,33,22,19,4,9,45,32,23,2,5,16,43,44,14,3,20,17,39,42,15,26,21,0,38,41,30,27,12,1,37,40 },
	{ 38,1,7,8,14,40,4,2,29,36,27,45,21,43,19,24,33,30,39,16,46,22,9,15,34,5,3,12,10,44,0,6,25,32,31,41,17,23,28,37,26,35,20,42,18,13,11 },
	{ 0,37,10,7,29,32,1,44,11,39,6,28,33,31,45,2,38,25,21,40,30,34,3,24,20,41,23,35,12,46,17,27,22,42,13,16,26,8,43,4,15,19,9,36,5,14,18 },
	{ 25,27,21,24,26,20,23,22,39,13,5,46,38,12,4,15,7,44,36,14,6,45,37,17,29,19,16,28,18,31,30,9,1,11,3,8,0,10,2,40,32,42,34,41,33,43,35 },
},
{
	/* Frame 120 */
	{ 2,21,14,11,0,45,9,34,20,15,30,10,27,32,5,8,25,35,38,31,42,26,33,22,4,19,40,24,13,39,17,43,46,23,36,18,41,12,29,6,16,3,37,1,44,28,7 },
	{ 24,40,27,34,33,29,12,7,36,25,8,26,11,22,32,13,4,9,10,23,0,3,30,46,5,39,43,1,20,2,31,14,45,16,38,19,42,41,21,35,15,28,44,17,6,18,37 },
	{ 43,38,9,5,10,33,34,29,0,15,39,20,11,6,35,44,1,30,2,21,26,7,25,45,31,3,12,40,36,27,22,24,46,18,13,17,41,37,42,23,8,4,32,19,28,16,14 },
	{ 34,28,33,14,8,27,45,25,20,7,42,0,38,18,37,17,12,31,35,29,11,9,46,4,40,22,21,2,1,39,19,32,15,13,26,44,24,10,6,43,5,41,23,36,16,3,30 },
	{ 4,43,30,32,17,6,9,34,19,37,24,11,0,39,26,44,29,2,5,46,31,33,20,7,12,35,22,40,25,14,1,42,27,45,16,3,8,18,36,21,10,13,38,23,41,28,15 },
	{ 19,41,43,8,16,10,18,40,42,9,17,15,31,45,12,28,14,30,44,46,13,29,3,27,33,35,0,24,2,26,32,34,1,25,7,23,37,39,4,20,6,22,36,38,5,21,11 },
	{ 1,11,17,8,27,6,24,45,22,46,32,35,9,7,25,4,23,14,20,33,30,34,40,43,5,15,21,12,31,2,28,41,18,42,36,39,13,3,29,0,19,10,16,37,26,38,44 },
	{ 25,28,26,31,9,43,40,45,0,5,3,22,17,36,34,39,29,11,30,8,13,42,44,4,2,7,16,21,19,38,33,10,15,24,12,27,46,41,6,1,20,18,23,32,37,35,14 },
	{ 11,14,17,20,34,39,18,15,0,21,38,41,19,22,1,4,40,45,2,23,24,5,43,44,3,6,25,28,42,26,7,8,29,46,33,27,30,9,12,32,37,10,31,16,13,35,36 },
	{ 11,5,41,23,0,2,28,30,42,36,9,19,21,15,35,45,24,26,4,40,6,17,46,3,13,33,31,8,39,10,20,22,34,44,1,27,29,7,43,37,16,18,12,32,14,25,38 },
	{ 25,4,43,33,18,15,20,5,42,32,27,14,21,8,35,45,26,7,28,9,34,44,23,6,29,0,37,22,11,16,1,46,36,31,10,17,12,39,41,30,3,24,13,38,40,19,2 },
	{ 17,35,9,0,20,24,39,12,36,18,40,1,10,21,25,22,13,4,14,28,19,41,32,11,2,23,26,5,15,6,29,30,33,42,3,27,46,7,45,31,16,43,34,8,38,44,37 },
},
{
	/* Frame 121 */
	{ 16,18,40,0,42,2,17,19,41,1,43,3,20,22,44,4,46,6,21,23,45,5,7,24,26,32,8,34,10,25,27,33,9,35,11,28,30,36,12,38,14,29,31,37,13,39,15 },
	{ 35,1,41,27,17,10,34,0,40,26,16,15,5,37,31,21,14,46,4,36,30,20,3,43,9,33,19,25,2,42,8,32,18,24,7,39,13,45,23,29,6,38,12,44,22,28,11 },
	{ 24,3,22,41,39,12,17,2,27,40,38,5,16,15,26,33,43,4,29,14,19,32,42,9,28,7,18,45,35,8,21,6,31,44,34,1,20,11,30,37,0,25,10,23,36,46,13 },
	{ 27,12,2,5,26,13,3,20,10,28,18,21,11,29,19,36,44,34,37,45,35,42,43,31,0,6,8,30,1,7,9,14,16,22,24,15,17,23,25,32,38,40,33,39,41,46,4 },
	{ 40,45,11,14,8,31,25,28,34,39,33,5,2,19,22,16,44,43,15,9,12,29,26,38,32,37,3,6,0,23,17,20,42,41,13,10,27,30,24,36,35,7,1,4,21,18,46 },
	{ 18,5,16,22,43,20,33,19,37,17,23,10,21,8,14,12,32,34,36,38,11,9,15,26,13,24,30,35,28,39,41,27,45,25,31,2,29,0,6,4,40,42,44,46,3,1,7 },
	{ 43,17,4,22,3,45,42,20,5,27,2,44,39,21,0,26,15,41,38,24,1,31,14,40,35,25,12,30,11,37,34,28,13,19,10,36,29,8,18,7,33,46,16,9,23,6,32 },
	{ 31,19,30,18,24,20,25,21,11,3,44,36,10,2,45,37,42,34,12,4,43,35,13,5,27,23,26,22,28,16,29,17,15,7,40,32,14,6,41,33,46,38,8,0,39,9,1 },
	{ 39,44,21,9,22,42,0,13,3,46,36,25,7,26,34,41,29,19,30,38,45,8,23,11,4,33,2,15,16,37,6,27,20,40,43,31,1,12,10,5,24,32,35,14,17,28,18 },
	{ 6,41,18,12,33,24,4,16,30,11,22,3,9,42,1,34,27,39,40,19,45,32,25,37,28,17,20,10,15,2,7,8,13,0,46,5,38,31,44,23,36,29,21,43,14,35,26 },
	{ 36,2,44,11,18,27,37,3,45,10,19,30,34,6,43,15,22,31,35,7,42,14,23,0,8,38,16,24,1,9,39,17,46,25,32,4,40,12,20,28,33,5,41,13,21,29,26 },
	{ 20,31,5,10,33,17,42,22,12,7,44,24,35,19,9,14,37,21,46,26,0,11,32,28,39,23,13,2,41,25,34,30,4,15,36,16,43,27,1,6,45,29,38,18,8,3,40 },
},
{
	/* Frame 122 */
	{ 4,23,43,16,44,2,1,30,34,29,33,15,8,27,39,20,40,6,5,18,46,17,45,3,12,31,35,24,36,10,9,22,42,21,41,7,0,19,28,32,14,13,26,38,25,37,11 },
	{ 32,11,42,17,31,4,45,10,35,16,30,13,44,7,34,25,19,12,37,6,24,18,1,36,15,46,21,27,0,41,14,39,20,26,9,40,3,38,29,23,8,33,2,43,28,22,5 },
	{ 7,32,12,16,27,37,23,28,34,1,3,25,4,14,41,19,43,8,39,20,44,30,13,17,10,6,33,29,35,0,26,36,22,46,5,15,40,2,24,21,45,31,18,42,9,38,11 },
	{ 27,23,19,30,26,22,18,14,10,6,2,15,11,7,3,46,42,38,34,43,39,35,21,17,12,8,20,16,13,9,4,0,28,24,5,1,29,25,44,40,45,41,36,32,37,33,31 },
	{ 36,39,37,7,19,5,17,6,18,4,16,42,40,43,41,23,11,21,9,22,10,20,8,46,44,45,15,27,13,25,14,26,12,24,34,32,35,33,31,3,29,1,30,2,28,0,38 },
	{ 38,33,29,35,26,13,24,10,23,8,7,32,34,45,25,22,9,20,6,19,4,3,44,46,41,21,43,18,5,16,2,31,0,15,40,42,37,17,39,30,1,28,14,27,12,11,36 },
	{ 1,18,38,8,27,25,32,6,16,41,15,13,22,34,4,31,43,29,44,2,20,37,11,9,26,46,0,19,39,17,40,14,24,33,7,5,30,42,12,23,35,21,36,10,28,45,3 },
	{ 30,25,32,42,39,3,41,4,31,22,24,17,10,38,13,40,37,23,16,11,6,12,1,26,29,36,46,35,7,45,0,27,18,28,21,14,34,9,44,33,43,19,20,15,2,8,5 },
	{ 17,41,4,29,39,24,2,22,14,37,11,0,20,44,9,42,7,27,40,5,38,25,35,12,23,18,10,33,30,21,45,16,8,28,6,3,15,36,1,34,13,46,19,43,32,31,26 },
	{ 26,20,9,23,10,36,39,2,28,16,31,19,44,32,35,4,24,7,27,21,40,43,37,12,0,15,3,29,17,45,33,46,8,22,11,5,25,38,41,42,30,18,13,1,14,34,6 },
	{ 22,8,20,42,40,11,23,9,21,43,41,26,14,24,12,46,44,27,15,25,13,45,2,30,0,28,34,32,3,31,1,29,35,33,18,6,16,4,38,36,19,7,17,5,39,37,10 },
	{ 5,16,11,22,45,35,4,21,10,27,44,38,9,20,15,26,33,39,8,25,14,31,32,42,13,24,3,30,37,43,12,29,2,19,36,46,1,28,7,18,41,0,17,6,23,40,34 },
},
{
	/* Frame 123 */
	{ 26,20,35,14,41,0,27,21,42,15,36,1,22,28,43,2,37,8,23,29,38,3,44,9,30,16,39,10,45,4,31,17,46,11,32,5,18,24,6,33,12,19,25,34,7,40,13 },
	{ 27,9,0,26,8,33,41,18,32,40,19,5,21,13,29,4,20,12,28,37,45,36,44,11,17,35,25,10,16,34,24,43,2,42,3,15,31,39,14,30,38,6,22,46,7,23,1 },
	{ 26,37,0,17,10,19,36,46,1,28,3,18,41,39,12,29,2,31,40,38,13,20,15,30,33,43,4,21,14,23,32,42,5,24,7,22,45,35,8,25,6,27,44,34,9,16,11 },
	{ 40,13,21,44,26,18,30,35,22,43,8,39,16,25,12,33,20,29,27,37,3,11,31,34,7,42,15,38,1,46,24,32,5,41,28,36,2,45,10,19,6,14,23,0,9,17,4 },
	{ 30,15,45,10,25,40,43,20,5,23,38,0,18,3,33,14,29,44,24,9,27,42,4,22,7,37,2,17,32,35,28,13,31,46,8,26,11,41,6,21,36,39,16,1,19,34,12 },
	{ 16,15,20,40,18,44,25,22,42,29,46,27,8,31,35,12,39,10,1,14,5,41,3,45,24,7,28,32,26,36,17,30,34,21,38,19,0,23,43,4,2,9,6,13,33,11,37 },
	{ 30,34,8,6,17,45,27,39,1,11,28,36,18,46,4,2,21,41,31,35,13,7,16,32,22,42,0,14,25,37,19,9,3,20,44,26,38,12,10,29,33,23,43,5,15,24,40 },
	{ 3,31,32,2,30,33,34,0,28,35,1,29,23,15,44,22,14,45,46,20,12,21,13,7,27,36,6,26,37,38,4,24,39,5,25,19,11,40,18,10,41,42,16,8,43,17,9 },
	{ 27,38,18,43,23,34,14,9,0,44,5,29,40,20,11,2,46,26,7,31,42,22,24,37,17,8,33,13,4,39,19,10,35,15,6,30,1,45,25,36,16,28,41,21,32,12,3 },
	{ 39,27,36,8,19,42,0,34,14,13,6,5,11,28,3,20,45,26,37,25,18,43,17,40,35,31,32,12,23,46,4,38,10,9,2,1,15,24,7,16,41,30,33,29,22,21,44 },
	{ 9,38,33,21,44,27,36,7,42,24,5,41,29,11,2,22,14,8,39,0,20,13,26,37,19,43,31,34,17,46,40,28,32,3,45,15,6,1,25,12,4,18,10,30,35,23,16 },
	{ 30,6,28,4,39,37,31,7,29,5,38,36,18,2,16,0,35,33,19,3,17,1,34,32,22,14,20,12,45,23,15,21,13,46,44,26,10,24,8,43,41,27,11,25,9,42,40 },
},
{
	/* Frame 124 */
	{ 2,29,40,26,39,0,15,24,37,19,34,13,10,17,32,22,43,8,3,20,41,27,46,1,6,25,44,30,35,4,11,28,33,23,38,9,14,21,36,18,12,7,16,45,31,42,5 },
	{ 15,4,40,25,35,27,23,36,28,9,11,33,12,6,17,43,19,0,44,20,38,30,5,41,24,2,14,37,29,8,34,26,46,22,13,7,16,10,32,45,21,39,31,42,18,1,3 },
	{ 44,17,32,10,22,39,12,0,26,34,7,21,36,31,46,2,24,41,4,43,14,18,9,11,23,38,28,45,16,33,27,35,6,13,1,3,25,40,20,37,30,19,8,5,42,15,29 },
	{ 40,22,32,15,26,46,2,39,20,28,43,8,45,0,37,25,23,14,7,27,18,38,11,21,13,42,5,35,44,16,36,24,30,41,6,33,19,10,3,12,4,34,29,17,9,1,31 },
	{ 16,6,18,5,17,7,19,36,38,37,39,0,28,2,30,1,29,3,31,32,34,33,35,12,24,14,26,13,25,15,27,44,46,45,8,20,10,22,9,21,11,23,40,42,41,43,4 },
	{ 44,25,35,30,9,14,33,28,42,19,12,3,40,21,26,5,10,45,24,38,31,8,15,36,17,43,22,1,6,41,20,34,27,4,11,32,29,39,18,13,2,37,16,46,23,0,7 },
	{ 40,42,21,45,18,16,13,31,2,0,7,36,38,25,41,22,43,20,9,19,14,12,3,32,34,29,37,26,39,24,5,23,10,8,15,44,46,17,33,30,35,28,1,27,6,4,11 },
	{ 2,1,40,43,36,39,15,12,3,26,0,25,22,42,21,38,45,27,33,24,23,10,20,9,6,5,44,32,35,11,8,7,30,4,29,18,46,17,34,41,31,37,28,19,14,16,13 },
	{ 1,21,2,22,16,37,38,32,24,13,27,14,8,43,44,5,19,6,0,20,35,36,28,11,31,25,12,26,41,42,3,23,17,4,18,39,33,34,15,9,29,10,30,45,46,40,7 },
	{ 10,38,1,45,43,22,29,27,8,36,34,15,41,20,18,25,6,32,13,11,39,16,23,4,2,46,9,37,35,30,21,19,0,44,42,7,33,28,26,17,14,40,5,3,24,31,12 },
	{ 35,30,5,18,9,15,28,3,16,36,6,40,21,10,46,25,45,34,31,33,4,19,39,8,43,22,13,26,1,7,20,11,24,44,14,32,29,2,38,17,37,42,23,41,12,27,0 },
	{ 20,45,10,9,30,39,29,32,3,12,23,46,24,41,6,5,18,35,17,44,15,8,27,42,28,37,2,1,22,21,40,11,4,31,38,16,33,14,13,26,43,25,36,7,0,19,34 },
},
{
	/* Frame 125 */
	{ 11,40,10,41,16,42,18,8,17,43,19,9,15,44,14,45,20,46,22,12,21,23,13,27,32,34,26,33,35,0,24,2,1,25,3,31,36,38,30,37,39,4,28,6,5,29,7 },
	{ 33,27,17,10,42,0,32,26,16,11,43,5,45,31,21,14,38,4,44,30,20,15,39,9,41,19,25,2,34,8,40,18,24,3,35,13,37,23,29,6,46,12,36,22,28,7,1 },
	{ 18,35,17,40,11,4,23,46,28,45,2,1,26,43,25,36,7,12,31,34,16,33,10,9,22,39,21,44,15,0,19,42,24,41,6,5,30,29,32,3,8,27,38,20,37,14,13 },
	{ 45,31,22,44,30,6,14,36,7,15,37,19,41,27,18,40,26,2,10,32,3,11,33,13,21,12,20,29,38,4,46,28,39,5,9,17,8,16,25,34,0,42,24,35,1,43,23 },
	{ 43,14,32,5,11,16,31,41,12,2,38,9,22,29,19,0,36,42,15,20,26,17,45,35,6,40,13,3,24,23,33,4,10,46,1,30,21,27,39,8,44,34,7,28,18,25,37 },
	{ 19,44,14,18,45,13,17,46,12,16,31,11,40,30,10,41,43,29,9,42,28,8,7,27,36,6,26,37,39,5,25,38,4,24,23,3,32,22,2,33,35,21,1,34,20,0,15 },
	{ 25,8,22,7,33,46,28,9,27,6,32,35,29,12,26,11,37,34,16,13,31,10,36,39,17,0,30,15,41,38,20,1,19,14,40,43,21,4,18,3,45,42,24,5,23,2,44 },
	{ 31,35,44,17,22,42,37,24,39,3,29,46,10,20,7,1,14,8,27,5,32,18,12,41,23,43,36,25,30,34,45,16,11,21,38,2,28,15,9,6,0,19,13,40,26,4,33 },
	{ 25,6,44,0,26,28,37,3,17,31,13,32,42,18,20,14,35,8,23,45,1,11,38,29,2,40,4,30,24,33,43,7,21,27,9,36,46,22,16,10,39,12,19,41,5,15,34 },
	{ 16,4,0,46,21,42,17,5,1,20,43,30,26,38,14,34,10,31,27,39,15,35,11,22,18,44,6,40,2,23,19,45,7,41,3,24,36,12,32,8,29,25,37,13,33,9,28 },
	{ 38,24,37,10,40,20,7,16,3,46,32,12,31,29,8,27,39,25,4,43,22,41,21,0,44,18,17,34,15,33,13,36,11,9,6,5,42,23,2,1,45,19,30,28,35,14,26 },
	{ 26,29,19,4,45,35,11,36,24,22,17,14,33,9,7,46,20,27,12,2,43,5,44,34,30,25,23,0,41,39,15,32,28,18,21,10,37,13,3,42,16,31,8,6,1,40,38 },
},
{
	/* Frame 126 */
	{ 14,16,12,19,11,41,22,43,27,38,4,7,33,2,29,15,45,18,40,42,21,9,37,6,25,32,30,35,28,1,44,46,17,13,10,20,8,23,36,26,39,24,5,31,34,0,3 },
	{ 34,29,23,8,45,2,28,22,9,36,11,46,17,31,4,37,10,39,16,30,5,40,7,38,25,19,12,41,6,43,24,18,13,32,15,42,21,27,0,33,14,35,20,26,1,44,3 },
	{ 6,37,28,46,15,19,9,10,23,36,5,14,45,18,17,27,22,4,31,44,13,32,16,35,26,25,21,39,30,12,33,0,34,3,40,24,43,20,38,7,29,1,2,41,8,42,11 },
	{ 45,5,37,12,44,4,36,29,21,28,20,9,41,1,33,8,40,0,32,25,17,24,16,7,39,31,6,38,30,23,14,46,22,15,3,35,27,2,34,26,19,10,42,18,11,43,13 },
	{ 4,16,14,26,36,46,5,17,15,27,41,35,20,8,30,2,40,34,21,9,31,3,45,39,12,24,6,18,44,38,13,25,7,19,33,43,28,0,22,10,32,42,29,1,23,11,37 },
	{ 14,18,45,15,19,13,17,46,12,16,40,10,30,41,11,31,9,29,42,8,28,43,36,6,26,37,7,27,5,25,38,4,24,39,32,2,22,33,3,23,1,21,34,0,20,35,44 },
	{ 13,18,34,4,27,43,17,44,2,24,37,11,1,22,38,8,31,21,32,6,28,41,15,5,26,42,12,19,35,25,36,10,16,45,3,9,30,46,0,23,39,29,40,14,20,33,7 },
	{ 30,11,28,9,26,44,24,46,32,23,34,21,6,19,4,17,39,10,8,43,45,15,13,33,22,3,20,1,18,36,16,38,40,31,42,29,14,27,12,25,2,0,35,37,7,5,41 },
	{ 1,34,10,8,6,4,45,15,33,25,3,21,40,30,36,28,18,16,35,27,9,23,42,5,38,14,12,2,0,41,11,37,29,7,17,44,26,32,24,22,43,20,39,31,13,19,46 },
	{ 1,14,35,26,21,40,42,15,2,20,9,43,36,3,29,8,23,10,37,28,17,22,11,4,38,16,31,45,32,5,25,39,30,19,44,33,46,24,6,18,13,0,34,7,27,41,12 },
	{ 28,32,23,43,16,38,27,13,30,34,9,18,4,15,37,0,11,29,33,6,44,17,39,2,20,40,31,35,24,46,19,5,22,42,1,26,12,7,45,8,3,21,41,14,36,25,10 },
	{ 19,10,5,24,46,33,40,18,27,4,13,41,7,26,21,12,35,6,15,20,29,34,43,36,23,14,1,28,42,37,44,22,31,0,9,45,3,30,17,8,39,2,11,16,25,38,32 },
},
{
	/* Frame 127 */
	{ 18,13,24,32,43,31,39,44,0,28,11,7,26,34,22,40,4,17,21,2,8,37,15,42,30,38,19,12,25,33,29,10,6,45,1,5,16,46,27,35,23,41,36,14,20,3,9 },
	{ 35,42,34,10,26,2,18,11,27,3,19,21,39,46,20,38,14,6,28,15,7,29,1,17,41,0,16,40,33,8,24,32,9,25,5,45,4,44,37,30,12,22,36,31,13,23,43 },
	{ 4,19,46,24,45,2,9,30,43,17,36,7,12,27,34,20,33,10,5,18,39,25,44,15,0,23,42,28,41,6,13,26,21,32,3,8,31,38,16,37,14,1,22,35,29,40,11 },
	{ 30,34,7,43,27,44,2,36,11,41,12,4,9,16,38,24,31,6,42,15,45,18,10,13,20,28,33,17,25,46,1,22,14,35,19,26,3,37,21,40,29,32,5,8,0,39,23 },
	{ 29,45,22,38,9,2,24,40,31,4,11,17,33,26,42,13,6,28,44,19,35,8,15,21,37,30,46,1,10,16,32,23,39,12,3,25,41,18,34,5,14,20,36,27,43,0,7 },
	{ 6,26,12,16,38,44,7,27,13,17,39,41,22,2,28,8,34,40,23,3,29,9,35,37,14,18,4,24,46,36,15,19,5,25,33,30,10,20,0,42,32,31,11,21,1,43,45 },
	{ 30,38,4,2,25,33,27,35,13,15,20,40,18,42,8,6,29,37,31,39,1,3,24,44,22,46,12,10,17,41,19,43,5,7,28,32,26,34,0,14,21,45,23,9,11,16,36 },
	{ 3,21,10,38,28,15,9,6,0,27,40,5,18,33,12,43,23,17,36,34,30,24,45,11,39,29,2,46,20,7,1,14,8,19,32,13,26,41,4,35,31,25,44,42,22,16,37 },
	{ 1,22,34,20,39,18,37,16,31,43,29,41,27,44,25,14,12,32,2,0,7,5,38,11,9,30,42,28,26,45,24,23,35,21,33,19,36,17,6,4,40,10,8,15,13,46,3 },
	{ 0,28,34,33,2,30,1,29,35,32,3,31,20,12,46,45,22,14,21,13,44,23,15,4,24,38,37,6,26,5,25,39,36,7,27,16,8,42,41,18,10,17,9,43,40,19,11 },
	{ 2,15,32,9,20,6,3,46,33,13,8,7,0,12,27,38,4,1,45,31,26,39,25,5,42,44,19,30,29,24,36,43,23,18,28,34,37,10,22,41,17,35,14,11,40,21,16 },
	{ 28,16,30,18,29,17,31,19,8,0,10,2,41,33,43,35,9,1,11,3,40,32,42,34,24,20,26,22,25,21,27,23,12,4,14,6,45,37,39,13,5,15,7,44,36,46,38 },
},
{
	/* Frame 128 */
	{ 16,4,21,8,13,19,39,11,46,17,36,20,9,30,12,6,34,37,32,31,44,7,22,35,14,42,33,45,26,40,23,2,15,24,43,29,0,5,27,41,3,18,38,25,10,28,1 },
	{ 20,41,30,2,46,25,4,27,8,34,15,45,39,22,10,29,32,17,12,19,6,42,1,3,24,36,21,40,31,35,14,5,26,9,11,28,33,16,44,38,23,43,0,13,18,7,37 },
	{ 38,16,26,25,4,15,28,39,0,3,46,24,5,23,12,1,36,2,8,11,32,22,35,13,31,37,19,9,44,10,33,6,34,21,40,30,43,18,17,45,27,7,20,41,14,42,29 },
	{ 4,28,43,1,44,25,16,41,6,32,14,3,26,18,5,34,29,42,20,45,8,36,17,7,33,30,22,27,38,19,46,11,35,12,21,9,37,0,24,31,40,23,15,39,2,10,13 },
	{ 19,13,25,39,45,6,18,12,24,38,44,3,31,9,21,35,41,2,30,8,20,34,40,15,27,5,17,37,14,26,4,16,46,36,11,23,1,29,43,33,10,22,0,28,42,32,7 },
	{ 19,37,4,24,14,18,36,46,5,25,11,31,33,43,0,20,10,30,32,42,1,21,7,27,45,39,12,16,6,26,44,38,13,17,3,23,41,35,8,28,2,22,40,34,9,29,15 },
	{ 36,46,29,33,18,43,24,1,31,6,12,3,40,34,17,37,22,28,5,19,10,0,7,44,38,21,41,26,35,16,9,23,14,4,11,32,42,25,45,30,39,20,13,27,2,8,15 },
	{ 2,7,8,13,35,22,28,33,36,11,46,1,26,31,16,21,6,40,12,34,39,19,25,37,10,15,0,5,43,30,20,41,44,3,38,9,18,23,24,29,14,32,4,42,27,17,45 },
	{ 32,5,10,46,0,30,20,3,39,9,45,34,23,29,18,24,36,43,14,33,4,27,17,7,40,13,2,38,8,22,28,11,1,37,42,31,21,26,16,44,35,6,41,12,19,25,15 },
	{ 32,45,27,22,8,5,44,10,23,17,4,35,11,6,16,29,34,41,18,7,1,28,46,40,37,19,30,0,13,36,2,31,25,12,43,3,14,24,21,42,39,33,26,15,9,20,38 },
	{ 23,10,44,35,4,25,14,11,39,34,21,24,15,18,33,38,20,9,30,19,37,32,13,8,31,2,36,43,12,17,6,3,42,29,16,7,26,41,46,28,1,22,27,45,40,5,0 },
	{ 26,4,7,28,31,34,41,1,22,25,14,39,44,16,19,8,33,11,21,46,6,13,36,30,0,43,3,24,27,38,45,5,18,29,10,35,40,20,23,12,37,15,17,42,2,9,32 },
},
{
	/* Frame 129 */
	{ 25,37,3,30,33,20,26,38,16,12,34,23,8,19,5,43,1,6,36,2,32,21,15,17,45,11,22,41,28,18,46,24,4,42,31,0,27,39,13,35,9,14,44,10,40,29,7 },
	{ 3,14,33,44,26,23,42,15,0,45,22,25,43,38,1,12,24,21,10,39,40,13,19,20,11,6,41,36,18,31,34,7,8,37,30,17,35,46,9,4,16,29,2,32,5,27,28 },
	{ 21,43,22,25,37,26,33,28,15,16,11,5,6,1,2,46,12,42,23,8,36,27,39,32,29,35,30,17,45,18,41,20,7,24,3,13,14,9,10,38,4,34,31,0,44,19,40 },
	{ 31,25,6,43,0,45,38,26,28,19,21,40,35,15,37,9,22,16,10,32,12,7,42,1,27,29,2,4,41,34,30,24,23,17,44,39,11,33,13,18,20,14,36,8,3,46,5 },
	{ 46,32,42,36,33,43,37,24,16,28,20,25,17,29,21,8,0,12,4,9,1,13,5,38,39,40,44,34,41,45,35,14,6,26,18,15,7,27,19,31,23,10,2,30,22,11,3 },
	{ 44,36,40,32,45,37,41,33,10,4,30,0,11,5,31,1,27,21,14,17,26,20,15,16,42,34,43,35,46,38,39,12,2,8,22,13,3,9,23,29,19,25,6,28,18,24,7 },
	{ 8,13,24,2,6,41,18,10,32,14,37,26,21,43,1,34,29,38,9,44,22,3,7,30,11,33,15,4,17,20,12,25,35,28,39,40,19,45,23,36,27,31,42,0,46,5,16 },
	{ 36,9,13,17,41,21,45,0,27,35,30,38,10,7,18,42,25,33,29,37,8,4,16,40,20,15,26,34,23,3,6,12,24,32,28,44,1,5,31,39,11,14,19,43,22,46,2 },
	{ 27,34,14,39,18,23,46,3,37,24,28,9,4,0,41,26,31,38,11,22,2,43,7,12,8,33,5,44,17,40,21,30,10,35,15,19,42,6,13,36,25,32,29,45,16,20,1 },
	{ 38,12,42,16,33,26,6,28,1,11,37,31,40,19,34,24,5,14,2,44,9,21,17,32,27,22,39,13,43,0,10,36,7,29,25,46,4,30,41,18,35,8,20,15,3,45,23 },
	{ 23,40,26,35,16,28,6,11,45,1,4,42,25,32,18,30,39,20,8,3,37,15,27,34,17,46,13,22,41,10,44,0,29,7,19,31,38,5,43,24,33,2,36,14,21,9,12 },
	{ 31,24,26,33,23,1,46,18,14,25,38,27,6,20,19,45,15,42,13,39,10,7,34,21,2,44,16,43,12,41,11,36,9,35,4,3,17,28,40,30,37,8,5,32,22,0,29 },
},
{
	/* Frame 130 */
	{ 46,29,27,41,4,2,15,26,23,40,45,35,14,24,22,1,44,34,39,25,20,0,13,11,38,21,19,33,12,10,7,18,31,32,37,43,6,16,30,9,36,42,17,28,8,5,3 },
	{ 0,44,6,42,17,23,1,45,7,43,16,22,36,12,34,10,29,27,37,13,35,11,28,26,4,40,2,46,21,19,5,41,3,20,18,32,8,38,14,25,31,33,9,39,15,24,30 },
	{ 1,46,34,13,32,9,21,40,17,35,29,33,14,25,10,20,41,22,16,18,28,15,24,38,11,36,23,42,19,44,31,39,27,37,6,43,4,2,45,0,30,12,26,8,7,5,3 },
	{ 26,29,23,0,41,39,15,32,24,18,21,10,37,13,3,42,16,27,8,6,1,40,38,30,25,19,4,45,35,11,36,28,22,17,14,33,9,7,46,20,31,12,2,43,5,44,34 },
	{ 26,39,31,34,11,6,19,42,22,24,29,32,9,37,17,40,4,45,38,15,10,46,18,23,3,28,8,36,13,16,21,44,1,14,27,30,35,7,2,43,25,12,33,20,0,41,5 },
	{ 31,27,30,26,15,43,11,46,14,42,10,23,36,19,22,37,18,33,7,3,32,6,2,25,44,12,24,45,13,41,9,29,40,8,28,17,4,16,5,39,1,35,21,38,0,34,20 },
	{ 11,24,27,23,40,4,6,31,35,12,14,45,0,18,8,36,26,38,41,5,42,7,21,13,32,15,29,1,2,17,9,37,10,39,25,43,22,20,33,30,34,28,3,44,16,46,19 },
	{ 14,41,18,24,21,42,15,32,19,45,25,28,43,0,33,26,44,22,29,34,1,46,27,37,23,2,35,8,5,36,30,3,9,38,4,31,10,6,39,13,16,11,7,40,12,17,20 },
	{ 4,6,39,13,44,31,46,29,16,2,35,1,27,42,8,41,5,36,23,38,21,45,30,28,15,19,34,0,33,26,25,40,11,37,22,20,7,12,14,18,17,32,3,24,10,43,9 },
	{ 43,25,10,42,24,27,8,40,26,9,41,15,37,29,39,14,36,28,38,31,12,30,13,1,33,3,35,0,32,2,34,17,19,16,18,5,7,4,46,6,21,23,44,20,22,45,11 },
	{ 16,39,26,44,21,34,31,8,6,13,3,33,28,43,18,36,25,46,23,0,10,5,15,45,20,35,30,40,17,38,27,12,2,9,7,37,24,22,32,29,42,19,4,14,1,11,41 },
	{ 21,22,20,6,34,4,32,7,35,5,33,19,17,18,16,46,2,44,0,3,45,1,29,15,43,28,14,42,12,40,31,13,41,30,25,11,24,10,8,38,27,36,9,39,26,37,23 },
},
{
	/* Frame 131 */
	{ 22,11,4,24,6,40,42,1,29,3,31,16,45,32,34,26,21,8,23,10,37,39,13,18,15,0,28,2,44,46,5,25,7,27,20,41,43,36,38,30,17,12,19,14,33,35,9 },
	{ 43,4,32,15,19,29,16,37,8,22,27,46,35,30,41,38,21,3,13,0,6,11,25,44,33,14,18,28,42,5,26,34,17,36,9,23,20,2,12,31,40,39,10,24,45,1,7 },
	{ 33,20,6,16,10,13,23,1,19,39,4,43,30,8,44,26,46,32,21,34,7,17,37,11,41,28,14,24,2,5,31,9,27,12,35,22,0,36,18,38,40,29,42,15,25,45,3 },
	{ 10,18,44,43,12,20,11,19,45,42,13,21,26,2,36,35,28,4,27,3,37,34,29,5,14,22,40,8,16,15,23,41,46,9,17,30,6,32,39,24,0,31,7,33,38,25,1 },
	{ 10,40,14,11,41,15,45,27,31,44,26,30,34,2,38,6,35,3,39,7,19,23,18,22,42,29,46,8,43,28,9,13,25,12,24,21,32,0,20,33,1,37,5,17,36,4,16 },
	{ 45,37,39,44,36,46,38,9,23,11,5,24,7,26,20,8,22,10,4,25,6,27,21,41,33,43,35,40,32,42,34,31,1,13,3,15,16,28,18,30,0,12,2,14,17,29,19 },
	{ 25,1,30,35,42,6,28,0,41,34,11,39,46,18,29,33,40,5,10,38,15,19,32,9,4,45,16,14,23,8,37,44,17,26,22,36,13,20,27,3,12,24,21,31,2,43,7 },
	{ 1,18,34,25,41,11,8,4,22,38,20,44,15,13,17,33,3,0,27,43,24,40,10,36,7,5,31,29,45,14,19,35,16,32,2,9,26,42,23,39,21,37,6,12,30,46,28 },
	{ 2,20,36,7,10,33,12,45,15,18,21,6,39,26,32,25,44,14,19,41,1,22,38,27,24,35,30,46,29,40,0,43,23,5,9,34,31,28,16,42,3,4,37,8,11,13,17 },
	{ 22,41,28,34,19,44,25,6,8,3,13,26,37,20,42,31,32,17,14,4,11,1,35,18,45,24,38,23,40,29,2,12,7,9,43,30,33,16,46,27,36,21,10,0,15,5,39 },
	{ 16,5,34,25,46,28,43,8,19,22,32,2,14,41,11,44,17,38,20,35,0,29,9,12,6,33,3,36,15,26,45,31,39,21,1,4,24,13,42,7,18,37,23,27,30,40,10 },
	{ 32,20,9,43,31,39,19,4,41,24,15,3,46,26,13,37,17,35,23,10,28,1,44,7,42,30,38,18,33,21,8,14,2,5,40,25,36,16,34,22,27,12,0,45,6,11,29 },
},
{
	/* Frame 132 */
	{ 45,18,17,3,0,44,19,16,2,46,33,13,30,29,35,15,32,12,31,28,34,14,5,41,22,21,7,43,4,40,23,20,6,42,37,9,26,25,39,11,36,8,27,24,38,10,1 },
	{ 4,26,32,30,5,27,33,31,37,0,36,1,18,10,22,14,19,11,23,15,43,42,46,2,28,6,3,29,7,35,39,24,34,38,25,20,12,40,21,13,41,45,16,8,44,17,9 },
	{ 44,27,40,29,19,21,45,10,41,12,30,2,0,20,22,11,46,24,13,42,31,3,38,1,36,34,23,32,25,43,14,39,17,37,35,6,33,4,8,26,15,28,16,18,7,5,9 },
	{ 8,20,14,18,41,9,21,15,19,40,46,24,4,30,2,37,35,25,5,31,3,36,34,12,16,10,22,45,43,13,17,11,23,44,42,28,0,26,6,33,39,29,1,27,7,32,38 },
	{ 32,28,37,25,21,1,4,34,14,39,27,30,46,3,23,29,9,12,0,41,5,44,16,38,11,31,2,43,7,18,8,33,13,36,24,40,20,45,17,10,35,15,26,42,6,19,22 },
	{ 45,13,30,28,46,14,44,12,31,29,15,5,22,34,20,32,6,4,23,35,21,33,7,26,24,42,10,40,8,27,25,43,11,41,9,37,18,16,2,38,0,36,19,17,3,39,1 },
	{ 10,40,18,13,39,4,32,25,3,15,44,6,8,43,16,31,36,29,22,46,35,26,1,19,12,38,20,11,41,2,14,5,33,24,42,17,30,45,7,9,34,27,0,37,28,23,21 },
	{ 35,6,41,13,36,16,11,7,32,12,17,2,8,33,5,30,3,9,46,4,31,28,0,26,22,29,42,1,38,27,45,23,20,43,14,39,18,44,24,21,34,15,40,19,37,25,10 },
	{ 28,35,16,36,25,40,14,33,19,11,13,34,17,24,30,32,7,10,12,5,9,31,6,26,46,3,4,43,8,45,1,22,27,2,39,20,42,29,44,0,37,23,41,15,18,38,21 },
	{ 27,1,17,10,26,0,16,43,33,42,32,15,23,5,29,14,22,4,28,37,46,36,3,19,9,25,2,18,8,24,35,41,34,40,7,31,13,21,6,30,12,20,39,45,38,44,11 },
	{ 23,32,21,34,41,10,8,7,18,5,16,39,27,44,25,46,33,2,0,11,30,9,28,43,19,36,17,38,45,14,12,3,22,1,20,35,31,40,29,42,37,6,4,15,26,13,24 },
	{ 43,14,34,7,11,2,26,28,4,41,25,16,44,9,37,15,6,30,18,46,27,39,29,20,40,13,33,17,8,36,1,22,42,31,35,19,10,38,3,21,12,32,5,24,0,45,23 },
},
{
	/* Frame 133 */
	{ 35,11,36,44,32,40,38,14,34,29,10,21,25,45,17,41,23,19,28,43,20,24,13,16,5,9,22,1,46,18,7,42,3,12,4,8,0,31,6,27,2,37,33,30,39,26,15 },
	{ 1,4,24,29,43,46,40,5,18,28,10,41,44,19,22,11,14,8,45,23,17,34,15,9,12,16,21,35,38,32,13,26,20,2,39,33,36,27,30,3,6,0,37,31,25,42,7 },
	{ 7,2,29,16,46,43,22,3,4,17,42,45,23,26,5,0,44,41,14,27,20,1,39,40,15,10,21,24,38,35,30,11,12,25,34,37,31,18,13,8,36,33,6,19,28,9,32 },
	{ 26,13,11,37,17,35,23,4,14,40,24,46,18,1,7,45,29,43,27,12,2,36,16,34,30,9,15,33,21,39,19,0,10,44,28,42,22,5,3,41,25,31,8,6,32,20,38 },
	{ 45,35,33,46,44,34,32,27,19,25,17,11,3,9,1,26,18,24,16,10,2,8,0,39,43,37,41,38,42,36,40,29,21,15,7,13,5,30,22,28,20,14,6,12,4,31,23 },
	{ 45,22,27,18,33,4,9,17,44,35,39,11,19,15,32,8,1,28,34,41,38,10,3,14,7,43,0,29,20,40,2,31,6,42,37,46,13,21,24,30,23,26,36,12,5,25,16 },
	{ 37,41,39,10,21,25,23,26,34,45,0,29,3,31,16,42,4,8,6,11,20,24,32,35,12,19,14,1,28,36,40,38,43,22,27,5,9,7,44,46,33,2,30,17,13,18,15 },
	{ 17,42,7,4,8,34,30,28,41,1,22,39,21,36,25,10,12,16,43,2,5,9,35,27,32,29,44,14,19,20,37,6,11,13,31,46,3,40,0,23,38,26,33,24,45,15,18 },
	{ 45,20,14,23,36,39,30,5,42,8,17,11,33,24,2,27,44,22,13,38,4,29,7,41,16,10,19,32,35,26,1,46,12,21,15,37,28,6,31,40,43,18,9,34,0,25,3 },
	{ 26,37,30,32,19,6,41,2,25,38,13,34,8,20,43,1,27,14,33,10,7,3,44,23,39,28,35,9,21,16,4,15,11,36,31,18,45,22,40,29,24,12,17,46,5,42,0 },
	{ 32,16,11,25,20,15,42,13,33,0,19,46,24,44,21,23,43,28,1,34,18,8,45,27,38,22,36,29,31,35,2,9,26,39,6,37,4,40,30,3,17,10,7,5,41,14,12 },
	{ 29,17,35,25,43,4,12,0,18,8,26,5,7,13,36,15,1,44,19,9,32,27,40,6,37,14,39,45,2,33,10,41,22,20,30,38,28,3,46,16,11,34,24,23,42,21,31 },
},
{
	/* Frame 134 */
	{ 39,0,18,12,43,5,25,32,14,22,27,37,3,29,16,46,41,31,35,44,20,8,6,1,19,13,10,38,33,15,23,42,4,24,17,40,26,36,2,28,21,9,7,30,34,45,11 },
	{ 2,42,20,19,4,44,3,43,21,18,5,45,38,10,28,27,32,12,39,11,29,26,33,13,6,46,16,23,0,40,7,17,22,1,41,34,14,24,31,36,8,35,15,25,30,37,9 },
	{ 31,10,38,40,20,1,46,27,12,37,16,23,35,32,29,8,43,7,19,4,44,25,15,3,21,0,30,11,39,41,36,17,22,34,26,13,42,6,18,33,28,9,14,2,5,45,24 },
	{ 11,44,24,35,19,5,2,41,29,46,26,8,7,32,16,43,31,13,10,37,21,34,18,4,15,40,28,39,23,1,6,45,25,42,30,12,3,36,20,27,9,14,33,17,38,22,0 },
	{ 25,35,26,8,19,43,1,2,29,39,30,12,5,6,11,33,24,34,17,41,18,42,0,15,37,28,38,31,21,45,22,46,4,27,9,10,32,3,16,40,13,14,36,7,20,44,23 },
	{ 9,42,4,33,0,44,26,40,23,3,24,43,28,1,27,41,14,18,38,25,29,16,20,15,19,39,6,13,46,17,37,21,30,10,7,34,12,8,36,5,32,31,45,11,22,35,2 },
	{ 35,40,39,9,22,12,18,25,33,43,36,5,30,16,26,21,41,44,23,13,2,24,6,29,37,31,0,10,20,14,45,34,38,3,8,7,28,19,32,42,46,1,11,4,15,17,27 },
	{ 41,26,25,11,43,8,40,27,24,10,42,13,30,29,39,15,37,12,31,28,38,14,36,18,16,3,35,1,33,19,17,2,34,0,32,22,45,20,7,5,23,44,21,6,4,46,9 },
	{ 37,20,2,19,44,43,26,13,38,0,17,7,41,24,14,31,36,35,18,5,42,12,29,11,33,16,6,23,40,30,9,34,4,21,3,45,28,10,27,32,39,22,1,46,8,25,15 },
	{ 2,35,20,7,27,29,30,18,34,21,46,6,45,10,9,31,37,19,1,22,44,11,42,8,41,14,36,13,0,33,23,5,43,24,40,15,12,39,16,32,3,4,25,26,28,38,17 },
	{ 18,34,13,43,17,0,15,28,40,19,2,37,30,42,1,39,29,8,3,20,36,31,10,45,22,38,9,21,4,11,24,44,23,6,33,26,46,5,35,25,12,7,16,32,27,14,41 },
	{ 27,24,26,8,32,10,34,9,33,11,35,23,5,22,4,40,6,42,21,41,7,43,20,31,13,37,30,12,36,14,38,29,15,39,28,17,45,19,16,44,18,46,0,2,1,3,25 },
},
{
	/* Frame 135 */
	{ 1,35,44,32,18,30,5,10,39,41,36,27,24,22,46,2,45,33,14,19,28,16,31,11,38,8,37,42,6,25,20,23,3,12,0,15,34,29,17,9,4,43,7,40,21,26,13 },
	{ 10,46,24,32,5,19,16,14,40,28,36,35,23,20,8,44,27,3,39,0,12,43,31,7,33,4,18,11,25,37,34,22,17,15,41,29,26,2,38,21,9,45,42,30,6,1,13 },
	{ 5,8,44,33,23,18,20,9,38,32,14,19,21,16,39,42,15,2,12,17,43,37,30,3,13,0,36,41,31,26,28,1,46,40,6,27,29,24,34,7,10,4,25,35,45,22,11 },
	{ 41,22,14,17,9,40,23,15,16,8,46,33,30,6,25,1,39,32,31,7,24,0,38,45,18,10,21,13,43,44,19,11,20,12,42,37,26,2,29,5,35,36,27,3,28,4,34 },
	{ 9,11,24,44,26,46,8,10,25,45,27,33,1,35,3,16,18,32,0,34,2,17,19,41,15,43,28,30,12,40,14,42,29,31,13,39,7,20,22,36,4,38,6,21,23,37,5 },
	{ 32,3,8,17,43,23,28,4,44,24,0,27,37,40,38,13,20,14,33,34,9,16,10,19,5,30,6,45,46,1,26,2,41,39,42,15,22,29,35,11,18,25,36,31,7,12,21 },
	{ 38,21,31,32,43,2,25,16,30,23,42,35,17,26,22,13,34,27,18,12,5,15,19,9,45,4,14,7,8,1,44,37,6,28,41,0,11,36,46,39,29,20,40,33,10,3,24 },
	{ 35,21,42,25,44,0,23,26,2,5,9,17,36,7,40,14,19,38,20,43,28,45,1,22,31,32,3,10,12,34,16,37,24,41,15,18,39,27,46,29,4,8,30,33,6,11,13 },
	{ 8,17,38,22,13,10,19,37,15,40,16,39,12,29,42,18,1,14,31,41,3,44,28,43,0,25,46,30,5,2,27,45,7,32,24,4,21,34,26,9,6,23,33,11,36,20,35 },
	{ 14,13,16,7,26,36,25,39,23,41,42,8,2,1,28,15,18,44,17,27,37,38,4,10,9,20,3,30,32,29,35,19,45,46,12,6,5,24,11,22,40,21,43,31,33,34,0 },
	{ 39,7,21,38,6,20,22,37,5,23,36,4,15,29,14,28,41,30,43,13,40,31,42,12,17,19,16,18,33,1,35,3,32,0,34,2,25,27,46,24,26,9,45,11,8,44,10 },
	{ 34,26,22,37,29,1,20,10,39,19,13,41,4,15,3,33,25,44,16,30,43,6,9,36,28,0,35,27,23,46,18,12,40,21,11,38,2,32,24,5,14,42,7,8,45,17,31 },
},
{
	/* Frame 136 */
	{ 27,38,25,4,26,39,24,37,7,36,6,21,11,9,20,10,8,43,23,41,42,22,40,3,29,1,2,28,0,35,33,31,34,32,30,19,13,17,46,18,12,16,45,15,44,14,5 },
	{ 36,32,37,33,4,28,0,24,5,29,1,25,18,44,40,19,45,41,12,22,8,13,23,9,2,26,38,3,27,39,35,6,30,34,7,31,10,46,11,20,43,16,14,21,42,17,15 },
	{ 14,0,38,20,27,45,17,28,34,37,11,23,41,46,12,18,33,7,25,4,42,2,31,9,21,26,44,15,1,39,36,10,22,40,16,29,35,32,6,24,13,19,30,8,5,43,3 },
	{ 41,19,15,21,9,46,40,18,14,20,8,39,33,27,7,29,1,38,32,26,6,28,0,43,45,23,11,17,13,42,44,22,10,16,12,35,37,31,3,25,5,34,36,30,2,24,4 },
	{ 35,24,32,10,1,18,42,17,39,28,36,14,13,22,46,21,45,9,26,34,25,41,3,0,19,30,38,29,37,7,4,23,33,11,8,27,43,16,40,2,15,12,31,20,44,6,5 },
	{ 27,16,3,14,43,5,38,23,45,10,9,34,19,33,30,29,6,26,46,25,2,1,42,12,41,22,36,21,8,18,32,17,28,15,4,39,24,44,11,0,35,13,40,31,37,20,7 },
	{ 34,46,22,26,37,1,12,21,38,11,18,41,4,25,3,15,33,44,8,17,43,31,7,27,36,0,28,35,23,10,19,40,13,20,39,2,14,32,5,24,42,30,6,45,9,16,29 },
	{ 30,7,35,15,43,23,31,6,34,14,42,18,45,26,3,11,37,19,44,27,2,10,36,13,41,20,29,5,33,12,40,21,28,4,32,9,16,25,39,1,8,17,24,38,0,46,22 },
	{ 12,17,42,30,9,6,27,33,3,44,16,43,8,29,38,26,5,2,23,45,15,40,28,39,4,25,34,22,1,14,19,41,11,36,24,35,0,21,46,18,13,10,31,37,7,32,20 },
	{ 43,36,28,46,19,8,25,7,30,13,10,37,40,24,34,31,12,21,11,26,1,14,41,35,44,20,38,27,0,17,15,22,5,2,45,39,32,16,42,23,4,29,3,18,9,6,33 },
	{ 37,19,3,36,18,2,21,5,34,20,4,35,45,31,11,44,30,10,25,13,42,24,12,43,33,23,7,32,22,6,17,1,38,16,0,39,41,27,15,40,26,14,29,9,46,28,8 },
	{ 37,12,32,9,45,16,40,21,30,10,39,19,6,3,13,8,28,17,4,1,31,26,38,15,35,22,46,2,43,24,36,29,33,5,44,0,41,20,27,14,34,11,23,18,42,7,25 },
},
{
	/* Frame 137 */
	{ 27,16,4,35,30,8,18,6,13,10,1,15,44,3,32,29,46,17,37,34,31,41,20,19,39,24,12,43,22,0,26,14,5,2,9,7,36,11,40,21,38,25,45,42,23,33,28 },
	{ 41,23,42,37,17,38,29,32,11,44,7,1,2,13,14,26,8,22,43,4,16,39,19,28,33,31,34,45,25,46,21,40,3,36,15,9,10,5,6,18,0,30,35,12,24,27,20 },
	{ 9,46,19,45,28,3,4,39,22,40,21,14,13,34,31,33,24,7,8,43,18,44,17,2,1,38,27,37,20,11,12,30,32,29,6,5,42,23,41,16,15,0,35,26,36,25,10 },
	{ 31,29,37,40,6,42,4,19,26,17,24,15,32,13,34,22,20,41,7,10,5,8,39,27,25,33,44,2,46,0,23,30,21,28,11,36,9,38,43,18,16,45,3,14,1,12,35 },
	{ 43,18,8,22,41,16,27,4,46,39,42,35,25,23,13,40,33,26,21,30,38,34,24,7,12,3,32,45,20,31,1,6,29,2,44,37,15,0,11,28,19,9,36,14,17,10,5 },
	{ 4,44,22,5,45,23,21,6,46,20,7,34,12,32,30,35,13,33,31,29,14,28,15,2,42,0,40,3,43,1,41,19,17,18,16,36,10,8,37,11,9,27,38,25,26,39,24 },
	{ 20,3,23,12,27,14,40,42,4,18,7,32,35,11,31,25,38,2,22,17,45,26,15,9,29,43,37,6,1,21,34,30,24,13,41,16,5,19,44,33,46,8,28,10,36,39,0 },
	{ 11,40,16,35,27,1,2,45,21,46,22,12,7,36,28,43,19,9,10,33,25,34,26,0,15,44,20,39,31,5,6,41,17,42,18,8,3,32,24,23,13,14,37,29,38,30,4 },
	{ 32,29,44,16,26,43,23,12,1,11,15,19,36,24,41,20,35,31,39,2,9,5,17,27,42,6,33,28,45,0,10,22,46,13,25,40,21,34,14,18,37,8,4,30,38,3,7 },
	{ 34,26,1,45,19,39,14,36,21,40,22,35,10,25,18,15,37,12,41,6,11,32,24,2,17,13,7,4,33,8,3,46,16,28,31,42,5,9,27,0,44,29,38,30,43,20,23 },
	{ 2,20,33,9,30,17,44,5,11,39,46,0,23,34,27,28,41,6,25,37,43,13,18,21,32,8,15,3,4,10,38,31,16,45,26,29,40,1,22,35,36,42,12,19,7,24,14 },
	{ 5,18,17,40,15,8,27,34,20,33,2,1,30,43,29,36,11,4,23,46,16,45,14,13,26,39,25,32,7,0,19,42,28,41,10,9,22,35,21,44,3,12,31,38,24,37,6 },
},
{
	/* Frame 138 */
	{ 31,1,36,35,6,25,28,0,5,34,29,18,33,4,11,46,19,22,32,45,10,15,16,23,9,44,43,14,17,20,8,13,42,39,21,26,41,12,3,38,27,30,40,37,2,7,24 },
	{ 38,33,8,17,31,7,24,36,42,45,2,29,5,11,18,40,39,0,14,23,9,16,30,34,37,43,12,21,27,3,28,32,46,41,6,25,1,15,22,44,35,4,10,19,13,20,26 },
	{ 18,21,23,38,26,36,12,35,31,46,3,20,43,22,11,37,25,34,30,32,2,45,0,42,7,10,24,15,33,29,44,1,6,41,4,9,14,28,17,19,40,5,8,39,27,13,16 },
	{ 29,18,3,10,0,40,35,27,21,24,13,6,46,36,45,19,30,16,11,1,8,34,43,33,25,22,7,14,4,44,39,31,17,28,9,2,42,32,41,23,26,20,15,5,12,38,37 },
	{ 27,33,4,28,19,45,30,20,42,38,8,35,22,15,36,0,24,13,7,41,10,16,5,29,2,26,32,46,21,43,39,9,18,44,31,37,1,25,34,23,14,11,17,12,6,40,3 },
	{ 23,44,4,22,45,5,7,21,46,6,20,31,12,30,13,33,15,35,29,32,14,34,28,17,19,16,18,41,1,43,3,40,0,42,2,25,36,27,24,37,26,39,9,11,38,8,10 },
	{ 6,10,15,34,43,5,25,28,33,7,26,14,35,44,42,8,29,16,27,30,18,45,9,12,17,20,40,31,19,22,36,13,0,21,41,38,2,23,11,37,1,4,24,39,32,46,3 },
	{ 17,14,27,36,42,1,28,15,18,37,43,8,29,2,19,44,38,9,20,3,30,45,39,4,21,10,31,32,46,5,24,11,22,33,12,25,6,23,40,34,13,16,7,26,41,35,0 },
	{ 32,19,42,24,20,45,31,2,9,5,7,29,34,16,41,26,37,23,39,12,1,11,25,21,44,14,33,18,43,8,4,30,46,3,17,40,27,36,6,28,35,0,10,22,38,13,15 },
	{ 35,2,26,7,46,31,22,33,0,8,5,28,20,45,3,42,27,18,14,38,23,1,24,16,41,29,36,21,44,13,43,10,34,19,15,39,6,30,25,32,17,40,9,37,4,12,11 },
	{ 18,0,46,27,9,6,43,28,15,34,21,10,37,16,3,44,25,22,4,41,31,13,32,26,8,38,19,1,14,35,20,7,42,29,2,45,24,11,36,17,30,12,33,23,5,40,39 },
	{ 14,42,13,41,30,29,15,43,12,40,31,24,10,38,9,37,26,25,11,39,8,36,27,20,6,34,5,33,22,21,7,35,4,32,23,16,2,46,1,45,18,17,3,0,44,19,28 },
},
{
	/* Frame 139 */
	{ 20,13,23,14,4,39,44,18,11,1,25,2,41,42,32,28,7,31,21,12,37,38,26,16,9,19,10,0,35,40,22,15,5,29,6,45,46,36,24,3,27,17,8,43,33,34,30 },
	{ 18,15,16,9,30,39,24,33,19,17,41,31,10,6,25,4,32,34,46,12,40,11,7,5,26,22,35,20,13,43,28,37,27,23,2,21,0,45,14,42,29,8,36,38,3,1,44 },
	{ 21,3,5,39,30,41,28,14,12,34,23,36,17,7,9,43,26,45,24,2,0,38,19,40,29,11,13,22,33,20,6,4,42,31,44,25,15,1,35,18,37,16,10,8,46,27,32 },
	{ 45,15,23,44,14,22,13,21,46,12,20,37,31,7,36,30,6,29,5,38,28,4,39,41,11,19,40,10,18,9,17,42,8,16,43,33,27,3,32,26,2,25,1,34,24,0,35 },
	{ 13,0,4,46,15,2,33,23,28,24,35,5,14,26,32,7,36,29,41,25,34,20,16,43,27,6,37,18,40,9,44,21,39,17,42,11,30,19,8,45,12,38,1,10,31,3,22 },
	{ 1,41,5,45,16,20,0,40,4,44,17,21,9,35,13,39,24,28,8,34,12,38,25,29,23,3,43,7,18,22,2,42,6,46,19,33,31,37,11,15,26,32,30,36,10,14,27 },
	{ 4,8,6,11,20,24,22,27,5,9,7,10,21,25,23,40,44,43,41,45,42,46,0,30,2,12,16,15,18,28,1,31,3,13,17,14,19,29,32,36,34,38,33,37,35,39,26 },
	{ 7,32,16,31,9,14,37,21,34,18,4,11,44,28,39,23,1,6,41,25,46,30,8,3,36,20,43,27,13,10,33,17,38,22,0,15,40,24,35,19,5,2,45,29,42,26,12 },
	{ 32,8,34,26,33,9,35,10,24,11,25,31,12,44,30,13,45,14,46,28,15,29,0,2,40,1,3,41,16,42,18,17,43,19,4,36,6,38,5,37,7,39,20,22,21,23,27 },
	{ 20,44,3,37,23,14,1,26,38,21,12,43,24,36,15,41,27,6,13,18,42,25,4,35,16,40,7,33,19,10,5,30,34,17,8,28,32,11,45,31,2,9,22,46,29,0,39 },
	{ 32,23,8,30,1,6,34,36,27,12,3,5,10,40,33,38,9,31,16,7,25,14,44,35,37,42,13,18,20,11,29,41,39,46,17,22,24,15,0,45,43,19,21,26,28,2,4 },
	{ 29,19,32,5,46,11,28,18,45,4,43,10,17,23,44,9,42,15,16,22,41,8,39,14,21,27,40,13,38,3,20,26,37,12,35,2,25,31,36,1,34,7,24,30,33,0,6 },
},
{
	/* Frame 140 */
	{ 20,7,5,45,23,21,6,46,4,44,30,28,39,15,37,13,31,29,38,14,36,12,18,16,3,43,1,41,19,17,2,42,0,40,26,24,35,11,33,9,27,25,34,10,32,8,22 },
	{ 29,24,17,12,5,41,0,44,18,30,23,6,11,35,38,28,21,16,4,40,33,45,36,9,22,27,10,3,15,39,42,20,25,32,13,37,8,1,26,19,31,2,14,7,43,34,46 },
	{ 9,44,31,43,12,38,1,36,6,35,4,25,45,30,13,40,17,37,19,34,5,32,24,10,29,41,16,18,21,33,23,11,46,28,14,3,20,22,27,8,15,42,2,39,0,7,26 },
	{ 15,19,13,17,14,18,12,16,46,44,45,31,3,29,1,30,2,28,0,34,32,35,33,11,23,9,21,10,22,8,20,42,40,43,41,27,7,25,5,26,6,24,4,38,36,39,37 },
	{ 33,26,23,38,13,42,1,11,36,6,29,24,4,31,40,19,34,9,20,14,2,45,22,39,12,43,17,32,27,7,28,0,10,37,30,41,18,35,25,46,5,15,3,44,8,21,16 },
	{ 18,22,42,2,46,6,19,23,43,3,7,37,26,30,10,32,14,36,27,31,11,33,15,45,5,16,20,40,0,44,4,17,21,41,1,13,24,34,28,38,8,12,25,35,29,39,9 },
	{ 7,1,31,8,6,0,30,25,23,17,14,24,22,16,15,41,45,33,37,40,44,32,36,3,13,27,5,2,12,26,4,19,29,10,21,18,28,11,20,35,39,34,38,42,46,43,9 },
	{ 17,2,31,44,38,9,28,3,22,45,39,0,29,14,23,36,42,1,20,15,26,37,43,12,21,6,27,40,34,13,24,7,18,41,35,4,25,10,19,32,46,5,16,11,30,33,8 },
	{ 32,6,40,30,33,7,41,14,22,15,23,27,2,38,26,3,39,10,46,18,11,19,4,12,34,5,13,35,20,42,28,21,43,29,0,36,8,44,1,37,9,45,16,24,17,25,31 },
	{ 25,8,42,13,30,44,19,2,16,33,7,21,4,38,9,26,43,40,31,14,28,45,3,17,0,34,5,22,39,36,27,10,24,41,15,29,12,46,1,18,35,32,23,6,20,37,11 },
	{ 25,27,39,42,4,40,6,29,16,31,18,1,46,3,44,33,20,22,43,5,8,7,10,37,17,19,34,12,32,14,21,24,23,26,9,38,11,36,41,28,30,35,13,0,15,2,45 },
	{ 34,22,12,2,45,25,39,19,5,15,32,16,46,26,0,6,41,29,35,23,9,3,44,20,42,30,4,10,37,17,27,13,7,40,24,38,18,8,14,33,21,43,31,1,11,36,28 },
},
{
	/* Frame 141 */
	{ 3,11,46,38,0,21,40,12,37,2,23,10,31,25,39,20,41,5,22,43,30,24,7,15,9,32,4,44,42,34,6,17,14,8,29,33,19,45,27,35,16,28,1,18,13,26,36 },
	{ 29,40,2,44,6,9,43,13,19,0,23,34,4,24,38,26,28,41,30,3,45,17,7,21,32,10,36,14,1,35,5,39,27,8,31,42,12,16,46,18,20,33,22,11,37,25,15 },
	{ 33,39,24,9,22,15,32,38,29,8,27,14,45,35,28,5,26,11,44,34,17,4,31,10,41,16,1,30,7,40,46,21,0,19,6,37,43,20,13,18,3,36,42,25,12,23,2 },
	{ 14,12,29,7,18,37,16,39,27,40,42,9,2,0,21,15,30,45,28,19,36,38,5,10,8,25,3,22,33,20,35,31,44,46,13,6,4,17,11,26,41,24,43,23,32,34,1 },
	{ 45,7,26,4,33,42,19,30,16,37,46,11,20,8,34,15,1,12,38,27,5,24,23,43,40,17,28,2,44,21,9,6,35,32,13,18,31,39,36,25,22,10,41,29,3,14,0 },
	{ 5,7,8,26,0,18,12,14,4,43,6,35,27,19,31,42,23,34,11,24,3,16,30,28,22,41,20,10,33,25,2,45,17,37,29,39,40,21,32,9,44,1,46,36,13,38,15 },
	{ 43,7,1,40,5,44,18,22,35,16,39,25,20,33,29,2,37,10,6,14,0,9,4,13,27,34,31,42,38,24,46,32,28,41,36,11,45,19,15,23,8,17,12,21,26,3,30 },
	{ 17,35,26,13,6,33,24,46,31,4,3,44,29,39,22,1,10,37,20,34,27,8,7,32,25,43,18,5,14,41,16,38,23,12,11,36,21,30,9,2,45,28,42,19,0,15,40 },
	{ 16,11,32,21,14,4,43,19,1,46,22,45,28,7,40,25,2,12,39,31,9,34,26,33,20,15,36,17,10,0,23,5,42,18,41,24,3,44,29,6,8,35,27,13,38,30,37 },
	{ 29,39,15,28,38,14,37,13,30,36,12,31,21,7,20,6,43,5,41,22,42,4,40,23,27,25,26,24,35,11,33,9,34,10,32,8,19,17,18,46,16,45,3,1,44,2,0 },
	{ 34,5,24,23,13,0,15,35,38,8,22,10,1,30,19,39,32,9,6,11,21,40,42,31,18,29,33,36,7,26,20,41,44,43,46,2,28,17,37,27,4,25,45,3,12,16,14 },
	{ 11,5,38,13,46,18,32,26,35,40,20,43,23,28,37,31,2,45,17,10,25,4,7,12,15,1,34,9,42,22,36,30,39,44,16,19,24,33,27,6,41,21,14,29,0,3,8 },
},
{
	/* Frame 142 */
	{ 21,7,10,12,1,36,19,42,14,24,5,40,29,26,46,35,22,17,31,9,44,2,39,11,13,33,20,6,43,15,25,0,37,18,27,34,23,4,41,28,3,38,16,30,8,45,32 },
	{ 35,37,14,19,8,21,30,38,32,43,45,16,27,7,29,1,46,40,2,24,4,15,18,9,39,33,10,23,12,17,26,34,36,41,20,31,3,25,5,42,44,6,28,0,11,22,13 },
	{ 41,25,31,34,18,46,5,9,15,2,33,20,45,23,43,27,38,28,1,7,11,12,37,16,35,19,4,40,24,30,3,32,21,8,14,39,29,0,44,22,42,26,13,36,17,6,10 },
	{ 41,28,10,31,32,35,18,1,46,12,25,15,37,20,6,23,40,43,30,9,34,0,17,3,45,24,14,27,36,39,22,5,42,8,29,11,33,16,2,19,44,26,13,38,4,21,7 },
	{ 9,36,43,6,15,1,37,10,7,28,32,2,11,38,20,29,33,31,3,44,39,24,21,23,30,34,45,16,25,22,40,35,12,17,46,26,41,4,13,18,27,8,5,42,14,19,0 },
	{ 1,27,33,8,5,40,31,37,29,16,2,9,34,4,41,6,36,13,38,17,45,3,24,35,10,7,42,12,39,14,44,18,46,25,11,22,43,20,15,19,0,26,32,23,21,30,28 },
	{ 34,21,38,25,29,0,35,4,39,8,11,12,15,1,18,5,32,22,9,36,10,13,40,14,43,44,19,33,23,37,26,41,30,42,45,2,46,16,6,20,27,24,31,28,3,17,7 },
	{ 42,1,17,11,27,33,43,0,16,10,26,36,46,5,29,15,23,37,4,28,14,22,40,34,9,25,3,19,41,35,8,24,2,18,44,38,13,21,7,31,45,39,12,20,6,30,32 },
	{ 20,3,44,17,6,8,35,19,13,38,22,33,24,15,36,29,10,0,31,5,42,26,45,16,7,40,21,2,12,39,23,9,34,18,37,28,11,32,25,14,4,43,27,1,46,30,41 },
	{ 9,5,2,31,39,24,33,20,44,19,15,7,1,12,43,27,35,22,16,40,29,36,11,3,46,30,8,4,45,18,14,38,25,32,21,13,42,26,6,0,41,28,37,10,34,23,17 },
	{ 16,15,40,37,19,22,13,10,38,17,20,8,36,35,23,11,6,33,21,26,9,4,34,24,7,32,45,27,30,5,2,46,25,28,0,44,43,31,3,14,41,29,18,1,12,42,39 },
	{ 12,36,15,39,28,31,13,37,14,38,29,18,44,0,3,16,19,45,1,46,2,17,26,8,32,11,35,24,27,9,33,10,34,25,22,40,4,43,7,20,23,41,5,42,6,21,30 },
},
{
	/* Frame 143 */
	{ 32,41,3,10,0,27,17,24,5,12,39,15,36,29,22,40,35,11,1,8,25,18,13,38,37,44,6,20,23,30,34,43,33,9,2,19,26,16,46,4,45,7,14,21,28,31,42 },
	{ 18,5,16,22,41,20,27,45,31,33,19,37,17,23,8,21,42,12,46,32,34,36,38,9,43,13,24,28,35,39,10,25,14,29,2,0,6,4,11,40,15,26,44,3,30,1,7 },
	{ 43,29,12,26,3,37,42,16,13,31,2,36,39,17,8,30,15,33,38,20,9,19,14,32,35,21,4,18,11,45,34,24,5,23,10,44,25,0,22,7,41,46,28,1,27,6,40 },
	{ 23,15,44,22,14,45,46,20,12,21,13,31,7,36,30,6,37,38,28,4,39,29,5,19,11,40,18,10,41,42,16,8,43,17,9,27,3,32,26,2,33,34,24,0,35,25,1 },
	{ 14,45,20,32,23,43,26,1,36,2,30,13,6,11,40,25,18,15,44,29,33,22,34,5,8,3,38,17,12,7,21,41,24,42,27,0,37,28,46,31,35,4,9,10,39,16,19 },
	{ 16,21,11,14,3,6,9,12,1,4,39,30,45,22,37,28,20,42,15,34,27,7,40,19,13,32,25,5,17,31,10,23,2,8,43,0,46,35,26,38,41,18,44,33,24,36,29 },
	{ 12,34,20,43,28,5,13,35,21,42,29,36,0,44,8,16,24,37,1,45,9,17,25,30,32,6,40,15,22,31,33,7,41,14,23,26,38,2,11,18,27,39,3,46,10,19,4 },
	{ 17,18,9,10,37,24,34,23,0,15,40,29,43,30,5,6,33,20,46,19,12,11,36,25,39,26,1,2,45,16,42,31,8,7,32,21,35,22,13,14,41,28,38,27,4,3,44 },
	{ 16,35,9,17,34,40,2,26,41,3,27,12,28,39,13,29,38,44,6,22,45,7,23,0,24,43,1,25,42,32,10,18,33,11,19,4,20,5,21,46,36,14,30,37,15,31,8 },
	{ 19,11,45,18,10,44,42,21,13,43,20,12,31,3,37,30,2,36,34,25,5,35,24,4,23,15,41,22,14,40,46,17,9,16,8,27,7,33,26,6,32,38,29,1,39,28,0 },
	{ 41,45,40,44,43,42,46,19,13,17,31,18,12,16,30,3,28,1,15,2,29,0,14,35,39,33,37,34,38,32,36,9,23,27,21,8,22,26,20,24,7,11,5,25,6,10,4 },
	{ 31,16,34,11,4,45,19,30,7,10,37,44,18,25,6,36,13,21,24,39,46,1,12,27,20,38,15,0,41,23,26,3,14,33,40,22,29,2,43,32,9,17,28,35,42,5,8 },
},
{
	/* Frame 144 */
	{ 32,35,33,3,27,1,25,2,26,0,24,42,40,43,41,19,11,17,9,18,10,16,8,5,29,38,4,28,39,37,7,31,36,6,30,21,13,46,20,12,45,23,15,44,22,14,34 },
	{ 27,20,30,17,10,37,0,42,18,28,25,38,45,35,8,7,26,16,36,46,33,43,5,15,24,23,44,3,41,6,13,21,31,32,11,4,14,1,19,22,29,2,40,39,12,34,9 },
	{ 19,4,34,9,15,44,3,42,21,24,33,30,12,0,38,22,11,29,46,17,41,6,37,26,35,8,14,18,5,25,32,31,45,2,43,20,39,23,10,13,1,40,7,36,27,28,16 },
	{ 40,42,41,43,20,8,22,10,21,9,23,11,32,34,33,35,28,0,30,2,29,1,31,3,44,46,45,16,12,18,14,17,13,19,15,36,38,37,39,24,4,26,6,25,5,27,7 },
	{ 31,21,8,18,45,30,20,42,9,38,27,44,17,29,43,6,39,26,37,16,28,34,7,40,5,36,25,2,35,14,41,4,24,3,15,32,13,23,10,0,33,12,22,11,1,46,19 },
	{ 42,4,24,36,29,6,26,38,31,20,1,12,33,22,44,3,14,35,5,46,17,37,28,9,19,41,30,11,0,43,13,32,25,45,2,7,34,27,39,16,21,8,18,40,23,10,15 },
	{ 35,31,33,12,34,30,32,29,14,28,15,45,9,27,44,8,26,25,46,10,24,11,7,41,5,6,40,4,23,21,42,22,20,43,39,3,37,1,38,2,36,0,19,17,18,16,13 },
	{ 38,5,17,7,19,37,39,4,16,6,18,32,34,1,29,3,31,33,35,0,28,2,30,44,46,13,25,15,27,45,12,24,14,26,40,42,9,21,11,23,41,43,8,20,10,22,36 },
	{ 24,39,5,25,38,36,6,26,37,7,27,0,20,35,1,21,34,32,2,22,33,3,23,12,16,13,17,46,44,14,18,45,15,19,8,28,43,9,29,42,40,10,30,41,11,31,4 },
	{ 18,34,5,27,43,12,2,17,36,11,24,45,30,46,1,23,39,8,14,29,32,7,20,41,26,42,13,19,35,4,10,25,44,3,16,37,22,38,9,31,0,6,21,40,15,28,33 },
	{ 17,21,16,20,27,31,26,30,35,9,5,34,46,8,4,3,15,40,36,2,14,41,37,25,29,24,28,19,23,18,22,43,39,1,13,42,38,0,12,11,7,32,44,10,6,33,45 },
	{ 32,24,14,40,7,1,11,13,34,4,19,42,21,8,39,31,33,25,22,16,41,6,26,36,28,10,44,3,5,15,9,38,0,23,46,17,12,35,27,37,29,18,43,20,45,2,30 },
},
{
	/* Frame 145 */
	{ 45,35,22,9,28,46,4,10,31,40,39,25,13,3,33,26,14,16,44,34,8,29,19,7,37,43,30,1,20,38,12,2,23,32,17,5,11,41,18,6,24,36,42,0,21,27,15 },
	{ 31,25,46,7,40,1,30,24,35,6,45,0,19,29,34,11,44,5,18,28,39,10,33,4,23,17,38,15,32,9,22,16,43,14,37,8,27,21,42,3,36,13,26,20,2,41,12 },
	{ 30,40,21,18,46,25,42,23,12,27,8,14,5,10,1,45,7,41,20,3,24,36,43,22,32,29,26,38,17,34,31,4,19,0,6,13,2,9,37,15,33,28,11,39,16,44,35 },
	{ 28,37,23,10,0,13,36,41,22,31,17,12,38,40,3,30,16,25,39,42,2,15,5,24,43,33,19,14,4,9,32,45,18,27,21,8,34,44,7,26,20,29,35,46,6,11,1 },
	{ 6,18,7,19,23,40,2,44,22,41,3,45,24,28,25,29,32,8,36,12,33,9,37,13,16,46,20,17,21,0,4,42,1,5,43,38,14,26,39,15,27,31,34,10,30,35,11 },
	{ 8,14,3,20,33,6,25,42,13,18,37,23,34,46,26,28,41,1,38,4,10,45,31,16,2,21,32,9,15,12,19,36,7,24,43,29,40,0,22,35,27,44,30,17,39,5,11 },
	{ 12,11,17,44,6,33,29,38,14,20,41,19,46,24,35,31,5,22,43,13,26,0,7,32,8,15,21,40,2,37,25,34,10,16,45,23,42,28,39,27,1,18,9,30,4,3,36 },
	{ 34,15,11,23,19,43,6,32,12,9,28,44,17,41,5,31,39,27,35,14,2,22,46,18,36,25,33,13,0,21,45,16,10,30,38,26,42,7,3,8,29,37,24,40,4,1,20 },
	{ 13,30,12,31,42,28,40,14,43,29,41,15,37,5,22,36,4,23,20,38,6,21,39,7,45,26,24,44,27,25,10,46,8,11,9,18,16,19,17,34,2,32,0,35,3,33,1 },
	{ 12,38,40,18,11,4,25,3,33,15,42,17,8,45,7,31,36,27,0,46,35,28,23,19,10,20,13,39,41,2,32,14,5,24,44,6,30,43,16,9,34,29,22,37,26,1,21 },
	{ 36,22,11,34,1,46,12,23,10,0,39,5,24,3,15,38,4,25,2,14,41,26,16,29,7,40,27,45,17,28,43,6,33,18,44,30,21,42,9,32,19,37,31,20,35,8,13 },
	{ 21,2,16,33,12,11,46,9,4,3,38,17,28,30,8,45,5,42,22,39,0,29,34,31,24,44,26,43,23,41,1,36,18,35,14,25,27,6,40,20,37,19,15,32,13,10,7 },
},
{
	/* Frame 146 */
	{ 6,19,30,33,36,10,28,18,32,5,43,46,16,29,9,4,42,15,17,23,8,45,3,14,27,22,41,44,2,39,20,26,40,13,35,38,24,21,1,12,34,7,25,31,0,37,11 },
	{ 21,19,41,5,3,20,18,40,4,46,2,29,27,37,13,35,11,28,26,36,12,34,10,17,23,45,1,43,7,16,22,44,0,42,6,25,31,33,9,39,15,24,30,32,8,38,14 },
	{ 18,45,4,38,0,7,33,3,44,20,13,16,46,9,6,32,15,2,11,21,35,12,17,8,14,41,10,37,34,28,43,24,30,40,23,26,36,19,29,42,5,25,39,1,31,22,27 },
	{ 45,3,26,17,8,39,46,2,11,16,29,32,19,10,5,28,33,40,18,31,4,13,34,41,7,30,21,12,35,42,6,15,20,25,43,36,23,14,1,24,37,44,22,27,0,9,38 },
	{ 42,35,14,7,27,2,30,40,33,45,20,25,0,12,5,46,39,34,6,26,19,31,22,11,32,44,37,24,17,29,4,9,38,43,18,15,23,10,3,36,41,16,28,21,8,1,13 },
	{ 27,12,36,16,34,22,11,44,29,0,6,33,21,8,42,30,38,18,5,25,14,41,2,37,17,35,23,46,26,13,1,7,10,45,28,43,31,39,19,32,20,9,15,40,3,4,24 },
	{ 15,16,44,1,28,2,33,9,23,10,41,27,4,38,17,12,18,46,29,3,30,32,35,11,20,40,43,5,24,6,37,13,19,14,45,31,0,34,21,8,22,42,25,7,26,36,39 },
	{ 24,5,36,30,40,19,25,38,4,43,31,33,26,6,39,13,42,1,32,27,7,12,35,0,20,14,3,34,9,21,15,2,45,8,28,16,11,44,22,29,17,46,10,37,23,41,18 },
	{ 45,18,22,44,19,23,2,40,6,3,41,7,26,30,27,31,34,10,38,14,35,11,39,15,5,16,4,17,42,20,46,0,43,21,1,37,13,24,36,12,25,28,32,8,29,33,9 },
	{ 13,27,31,8,12,26,30,25,29,10,14,24,28,11,15,41,39,37,40,38,36,42,43,3,7,1,5,2,6,0,4,19,23,17,21,18,22,16,20,35,45,33,34,44,32,46,9 },
	{ 38,13,20,3,30,41,39,12,25,2,23,32,42,5,24,15,22,33,43,4,17,14,27,44,34,9,16,7,26,45,35,8,29,6,19,36,46,1,28,11,18,37,0,21,10,31,40 },
	{ 15,28,14,12,34,31,32,13,35,30,33,25,11,24,10,46,8,44,27,9,45,26,23,21,43,22,20,42,6,40,4,7,41,5,19,17,18,16,2,38,0,36,3,39,1,37,29 },
},
{
	/* Frame 147 */
	{ 15,36,28,38,17,44,19,46,33,25,35,27,41,22,43,4,6,30,12,14,1,3,16,9,11,32,24,34,21,40,23,42,37,29,39,31,45,18,0,2,26,8,10,5,7,20,13 },
	{ 31,37,25,2,20,46,40,5,35,14,23,8,17,43,29,6,26,32,44,11,18,39,0,12,21,41,30,36,24,3,15,22,9,4,34,27,33,45,16,42,28,7,1,13,10,19,38 },
	{ 28,3,24,44,30,32,21,26,46,17,34,23,12,19,39,0,43,14,5,2,9,45,7,33,20,11,16,36,22,40,29,18,38,25,42,31,4,27,8,35,6,13,10,1,37,15,41 },
	{ 23,9,32,31,38,44,20,42,2,28,37,14,41,17,7,25,11,4,22,8,30,39,1,43,19,13,36,27,34,40,16,46,6,24,33,10,45,21,3,29,15,0,18,12,26,35,5 },
	{ 2,40,6,3,41,7,45,19,23,44,18,22,34,10,38,14,35,11,39,15,27,31,26,30,42,21,46,0,43,20,1,5,17,4,16,29,32,8,28,33,9,37,13,25,36,12,24 },
	{ 27,6,35,16,29,5,26,39,34,15,17,4,33,38,3,14,43,24,37,32,13,2,42,22,25,36,1,12,41,46,11,23,31,0,45,40,20,10,30,44,9,21,18,7,8,28,19 },
	{ 45,5,8,23,30,33,42,4,29,22,15,38,43,21,28,3,14,40,39,20,13,2,27,36,41,1,12,19,26,37,46,0,25,18,11,34,17,24,7,10,44,35,16,9,6,31,32 },
	{ 36,7,5,31,29,45,14,32,2,1,18,42,25,41,11,23,39,21,37,6,12,30,46,28,34,17,33,3,8,27,43,24,4,22,38,20,44,15,13,0,19,35,16,40,10,9,26 },
	{ 25,5,44,2,14,9,20,34,19,36,31,41,7,1,28,10,22,33,16,38,12,42,27,45,3,15,24,4,35,18,37,30,8,46,21,29,11,40,6,0,39,13,43,26,23,32,17 },
	{ 12,30,32,9,27,4,18,1,23,42,24,39,14,29,34,11,20,41,6,17,44,3,33,8,26,36,13,31,0,22,43,5,19,46,28,35,10,25,38,15,16,45,2,21,40,7,37 },
	{ 0,39,21,35,24,12,9,18,36,7,33,3,31,27,45,16,4,1,46,28,42,25,13,23,19,37,14,40,10,30,38,20,34,17,5,8,29,43,6,32,2,22,26,44,15,41,11 },
	{ 32,30,18,43,21,39,8,14,41,2,5,25,46,16,22,37,27,35,12,0,6,11,44,29,42,20,38,9,33,31,19,4,24,15,40,3,36,26,34,13,17,23,10,45,28,1,7 },
},
{
	/* Frame 148 */
	{ 9,22,26,21,25,7,11,4,8,23,27,20,24,6,10,37,45,39,36,44,38,46,1,13,18,30,17,29,3,15,0,12,19,31,16,28,2,14,33,41,35,43,32,40,34,42,5 },
	{ 35,24,39,34,25,38,29,3,7,28,2,6,43,42,46,19,11,23,15,18,10,22,14,37,0,36,1,27,5,31,33,26,4,30,32,45,16,8,44,17,9,21,13,41,20,12,40 },
	{ 24,4,38,26,34,7,9,20,29,11,19,6,31,8,45,1,21,41,28,10,18,43,30,44,0,37,40,13,33,46,3,42,15,23,16,36,25,12,32,5,2,39,27,14,35,22,17 },
	{ 45,17,42,6,29,32,14,40,4,3,12,11,1,18,9,30,35,16,43,23,28,33,27,38,41,21,46,2,25,36,10,44,0,7,8,15,5,22,13,26,39,20,19,24,37,31,34 },
	{ 32,20,37,17,29,9,12,34,6,39,19,22,46,11,31,21,1,4,8,41,13,44,24,38,3,23,10,43,15,26,0,33,5,36,16,40,28,45,25,2,35,7,18,42,14,27,30 },
	{ 44,9,20,39,2,43,14,8,21,3,46,15,22,16,28,10,23,17,29,32,11,18,30,24,33,4,41,19,31,34,25,36,5,40,13,26,35,6,37,0,45,12,27,38,7,42,1 },
	{ 14,28,38,11,25,2,20,45,7,17,40,26,33,12,31,36,9,18,43,0,23,46,5,39,10,24,34,15,29,6,16,41,3,21,44,30,37,8,27,32,13,22,4,19,42,1,35 },
	{ 16,11,34,22,40,29,17,38,10,45,23,33,20,14,39,3,44,9,32,21,15,2,37,8,26,6,13,36,1,27,7,12,43,0,18,24,5,42,30,19,25,46,4,35,31,41,28 },
	{ 45,7,1,28,10,35,22,16,12,36,27,25,5,40,2,14,39,9,33,20,19,42,31,29,11,44,6,0,13,37,26,34,23,46,17,41,3,15,24,4,18,43,30,38,8,32,21 },
	{ 13,3,7,8,12,2,6,41,45,35,39,40,44,34,38,25,21,19,31,24,20,18,30,1,5,11,15,0,4,10,14,33,37,43,32,36,42,46,17,29,27,23,16,28,26,22,9 },
	{ 22,0,3,40,28,43,31,9,6,37,17,38,26,12,15,32,20,35,23,1,10,41,29,42,18,4,7,44,24,27,13,2,33,21,34,30,8,11,36,16,39,19,5,14,45,25,46 },
	{ 43,20,34,13,17,8,1,22,31,41,19,10,44,3,37,21,12,5,24,46,0,39,23,14,40,7,33,11,2,36,26,28,42,4,35,25,16,38,9,15,6,32,30,18,27,45,29 },
},
{
	/* Frame 149 */
	{ 22,27,46,2,7,12,33,4,26,31,35,6,11,32,37,40,30,34,39,10,15,25,17,36,41,44,19,38,43,14,24,29,16,21,9,45,1,18,23,42,3,28,20,8,13,0,5 },
	{ 21,35,2,44,13,27,20,38,3,33,12,26,25,39,6,32,1,31,24,42,7,37,0,30,29,43,10,36,5,19,28,46,11,41,4,18,17,14,40,9,23,16,34,15,45,8,22 },
	{ 12,9,30,19,37,32,29,8,7,18,33,46,28,17,6,3,42,5,16,23,2,44,43,4,1,22,27,45,40,21,0,15,26,41,38,20,25,14,11,39,34,13,24,31,10,36,35 },
	{ 8,21,7,26,44,35,9,24,6,19,45,42,4,25,15,18,32,43,5,16,14,31,33,38,12,17,3,30,40,39,13,28,2,23,41,46,0,29,11,22,36,1,20,10,27,37,34 },
	{ 21,7,5,43,22,41,20,6,4,42,23,40,27,25,35,11,33,9,26,24,34,10,32,8,19,17,3,45,1,18,16,46,2,44,0,29,39,15,37,13,30,28,38,14,36,12,31 },
	{ 19,0,44,14,33,13,34,10,9,36,43,22,5,6,18,46,1,45,2,15,29,35,30,11,25,37,26,38,21,7,40,17,3,28,31,32,12,24,27,39,8,20,42,23,41,4,16 },
	{ 16,19,29,14,35,45,1,46,22,24,27,4,43,7,9,36,30,17,2,12,33,15,34,44,20,23,25,10,39,41,5,42,18,28,31,0,3,13,32,26,21,6,8,37,11,38,40 },
	{ 27,29,44,14,2,5,22,35,11,32,13,31,46,19,40,16,37,6,26,24,45,15,3,0,42,23,38,20,33,8,30,28,41,17,7,4,25,34,10,12,1,43,18,39,21,36,9 },
	{ 40,46,41,28,8,26,14,29,9,27,15,32,38,33,39,16,0,22,6,17,1,23,7,44,42,45,43,24,12,30,10,25,13,31,11,36,34,37,35,20,4,18,2,21,5,19,3 },
	{ 27,15,10,17,4,43,0,25,12,39,8,34,45,22,41,3,30,36,11,32,5,1,46,21,13,9,35,29,23,18,6,31,37,26,33,14,16,20,42,24,28,38,19,44,7,40,2 },
	{ 1,10,24,4,14,29,32,17,35,18,9,45,20,39,22,42,12,0,3,46,25,26,7,37,28,41,30,34,19,8,44,11,38,23,5,15,2,33,16,27,6,36,21,40,31,43,13 },
	{ 27,40,17,35,14,45,4,10,41,0,18,30,28,5,46,7,11,36,24,1,42,19,31,32,29,6,37,25,39,43,2,33,12,22,20,8,38,26,3,16,13,34,15,23,44,21,9 },
},
{
	/* Frame 150 */
	{ 19,10,36,28,33,21,7,42,30,24,45,17,40,39,26,2,12,5,9,14,34,22,11,37,29,0,46,18,43,31,25,44,32,20,6,27,3,13,16,41,38,15,35,23,4,8,1 },
	{ 19,44,4,43,3,21,18,45,5,42,2,20,27,32,12,39,11,29,26,33,13,38,10,28,23,40,0,7,17,22,41,1,46,6,16,31,36,8,35,15,25,30,37,9,34,14,24 },
	{ 7,19,43,29,8,32,3,15,44,25,4,39,41,30,11,21,0,13,26,22,34,36,17,28,9,33,6,18,42,45,24,5,2,14,20,1,38,40,31,10,23,35,37,16,12,46,27 },
	{ 29,14,23,32,42,5,20,15,26,33,43,12,21,2,27,40,38,13,24,3,18,41,39,0,25,10,19,36,46,1,16,11,30,37,8,17,6,31,44,34,9,28,7,22,45,35,4 },
	{ 43,32,27,3,9,16,10,36,7,13,20,14,23,35,41,42,19,25,1,26,2,8,39,45,46,29,5,30,6,12,33,34,40,17,11,18,24,0,37,38,44,21,15,22,28,4,31 },
	{ 46,1,45,19,4,22,21,38,25,37,26,28,32,15,12,0,18,17,7,43,20,40,24,36,11,8,14,35,13,31,3,16,44,6,42,5,41,23,10,39,9,27,34,29,33,30,2 },
	{ 23,28,13,0,10,38,45,21,31,18,3,8,36,46,35,29,16,26,1,11,6,44,33,43,19,24,9,4,14,34,41,17,27,22,7,12,32,42,39,25,20,30,5,15,2,40,37 },
	{ 35,1,33,19,17,2,34,0,32,18,16,7,45,5,23,21,6,44,4,22,20,46,9,41,26,25,11,43,8,40,27,24,10,42,13,39,30,37,29,15,12,38,31,36,28,14,3 },
	{ 32,34,33,35,28,0,30,2,29,1,31,3,40,42,41,43,16,8,18,10,17,9,19,11,36,38,37,39,24,4,26,6,25,5,27,7,44,46,45,20,12,22,14,21,13,23,15 },
	{ 22,0,5,33,31,25,28,23,16,4,44,32,8,29,11,39,17,20,3,45,46,9,12,10,15,40,38,43,21,2,7,35,13,26,14,41,42,37,18,6,1,34,27,30,24,36,19 },
	{ 3,12,31,42,16,33,14,9,18,35,21,36,11,0,23,38,28,41,2,5,30,43,25,44,7,8,27,46,20,37,10,13,22,39,17,32,15,4,19,34,24,45,6,1,26,29,40 },
	{ 13,30,12,14,32,29,34,15,33,28,35,23,45,5,22,44,4,46,6,21,7,20,25,27,37,24,26,36,8,38,10,9,39,11,17,19,16,18,40,0,42,2,41,1,43,3,31 },
},
{
	/* Frame 151 */
	{ 17,8,42,25,4,7,21,12,15,29,1,35,32,9,18,43,40,5,26,39,36,13,44,22,2,33,30,19,10,16,41,27,38,24,37,6,46,20,45,23,14,3,28,0,31,34,11 },
	{ 14,8,20,36,3,28,41,27,4,23,34,17,33,12,11,7,1,18,45,31,42,25,38,21,37,2,15,9,26,5,22,35,46,29,40,10,6,16,32,13,30,43,24,39,0,19,44 },
	{ 46,35,28,25,6,11,34,5,24,23,10,44,4,9,22,19,45,32,39,21,8,15,18,33,38,43,20,17,14,3,42,13,16,31,2,36,12,1,30,27,37,40,29,0,7,26,41 },
	{ 21,44,2,4,22,16,33,7,13,19,42,29,36,14,8,30,39,24,45,11,5,27,34,17,40,6,0,18,43,20,37,3,9,23,46,25,32,10,12,26,35,28,41,15,1,31,38 },
	{ 1,3,16,44,18,46,0,2,17,45,19,33,9,35,11,24,26,32,8,34,10,25,27,41,7,43,20,22,4,40,6,42,21,23,5,39,15,28,30,36,12,38,14,29,31,37,13 },
	{ 46,0,9,6,15,33,2,36,11,45,21,28,35,5,17,38,24,1,23,40,30,7,19,26,3,37,42,12,20,8,16,39,14,32,22,41,31,10,44,18,27,29,34,4,43,13,25 },
	{ 35,9,20,31,6,45,36,8,1,30,23,37,46,25,0,11,22,38,24,17,10,3,40,39,13,16,27,2,41,32,12,5,26,19,33,42,29,4,15,18,43,34,28,21,14,7,44 },
	{ 31,19,38,10,12,1,24,41,15,32,3,27,46,29,34,20,37,8,30,22,39,11,13,4,42,25,44,16,33,6,26,18,35,21,9,0,23,40,14,2,5,43,28,45,17,36,7 },
	{ 1,7,8,14,17,32,31,38,24,41,22,13,3,4,10,21,44,19,34,28,37,26,43,9,15,0,6,25,40,23,46,16,33,30,39,5,11,12,2,29,36,27,42,20,45,18,35 },
	{ 43,20,40,23,10,5,24,38,27,37,13,46,45,18,0,3,30,21,8,11,25,39,36,6,16,44,19,14,1,28,34,31,33,9,42,41,22,4,7,26,17,12,15,29,35,32,2 },
	{ 38,6,20,23,36,4,39,7,21,22,37,5,14,28,40,31,42,12,15,29,41,30,43,13,16,18,32,0,34,2,17,19,33,1,35,3,46,24,26,8,44,10,25,27,9,45,11 },
	{ 34,28,22,37,27,1,46,20,12,39,40,19,11,4,24,3,33,14,42,16,8,45,6,31,36,26,0,35,29,23,18,10,21,13,38,41,2,32,15,5,25,44,7,30,43,17,9 },
},
{
	/* Frame 152 */
	{ 13,1,46,2,12,0,35,45,33,15,34,44,32,14,19,27,17,25,18,26,16,24,5,11,38,9,4,10,39,8,37,43,7,41,36,42,6,40,21,29,20,28,23,31,22,30,3 },
	{ 28,4,24,0,29,5,25,1,37,33,36,32,12,22,8,13,23,9,19,45,41,18,44,40,35,30,6,34,31,7,27,3,39,26,2,38,20,43,16,14,21,42,17,15,11,10,46 },
	{ 7,25,33,12,18,46,9,31,2,4,42,39,15,1,44,21,26,29,35,16,22,40,36,10,13,19,6,24,32,3,5,43,8,30,45,20,27,38,14,0,23,41,37,11,28,34,17 },
	{ 23,42,16,37,2,9,18,39,29,32,11,12,31,34,24,41,14,1,26,43,17,44,3,4,19,46,20,33,6,13,22,35,25,36,15,8,27,38,28,45,10,5,30,21,40,7,0 },
	{ 35,16,32,2,9,26,42,25,39,20,36,6,5,30,46,29,45,1,18,34,17,41,11,8,27,22,38,21,37,15,12,31,33,3,0,19,43,24,40,10,7,4,23,28,44,14,13 },
	{ 19,36,26,45,7,14,22,17,24,5,35,12,42,20,3,10,18,33,31,40,6,1,39,8,46,16,29,4,34,13,37,27,44,2,15,23,32,30,41,25,0,38,9,43,21,28,11 },
	{ 22,0,46,19,5,10,35,24,15,38,29,2,45,16,7,40,21,26,12,37,31,9,32,18,4,42,23,1,14,39,28,11,34,25,6,41,20,3,44,17,30,8,33,27,13,36,43 },
	{ 41,5,33,29,21,12,40,4,32,28,20,9,39,1,25,17,8,38,0,24,16,46,7,35,30,23,15,43,6,34,31,22,14,42,3,45,26,37,19,11,2,44,27,36,18,10,13 },
	{ 5,11,12,2,17,36,23,42,24,45,30,35,9,15,0,6,21,40,27,46,28,33,18,39,13,3,4,10,25,44,31,34,16,37,22,43,1,7,8,14,29,32,19,38,20,41,26 },
	{ 38,41,44,30,5,10,15,17,28,27,39,8,45,42,14,32,29,26,23,9,12,3,24,43,46,33,36,22,13,2,7,25,20,19,0,37,34,6,40,21,18,31,1,4,11,16,35 },
	{ 36,18,2,20,4,35,37,19,3,21,5,34,44,30,10,24,12,43,45,31,11,25,13,42,32,22,6,16,0,39,33,23,7,17,1,38,40,26,14,28,8,41,27,15,29,9,46 },
	{ 37,26,32,15,16,46,21,43,24,29,39,19,44,6,41,3,27,14,11,17,4,42,1,25,12,38,9,35,45,22,40,2,30,36,10,33,5,0,20,13,8,34,28,23,18,7,31 },
},
{
	/* Frame 153 */
	{ 39,12,11,22,40,14,25,5,42,33,27,7,16,36,35,8,21,18,38,45,10,23,1,28,4,3,30,32,6,17,13,34,41,19,15,24,44,43,0,29,26,46,37,2,31,9,20 },
	{ 7,16,37,19,34,13,10,25,40,22,43,0,3,28,33,31,46,9,6,21,36,18,39,12,15,24,45,27,42,5,2,17,32,30,35,8,11,20,41,23,38,1,14,29,44,26,4 },
	{ 10,37,24,46,31,8,7,44,29,43,22,5,14,41,20,34,27,12,11,32,25,18,9,2,45,16,38,23,0,15,36,21,35,30,13,6,33,28,42,19,4,3,40,17,39,26,1 },
	{ 26,16,44,34,31,21,41,6,43,24,3,46,29,10,4,15,1,22,36,8,19,33,13,35,30,20,40,38,27,17,45,2,28,7,42,25,14,0,11,5,18,32,12,23,37,9,39 },
	{ 7,3,26,32,30,20,1,24,12,6,2,43,31,37,0,41,29,46,19,42,15,36,11,17,40,5,28,9,18,22,14,10,16,4,45,39,8,35,23,27,33,21,44,38,25,34,13 },
	{ 25,12,36,18,7,43,34,29,0,41,22,27,38,17,4,45,11,31,2,21,9,33,15,19,6,42,24,13,37,40,23,26,46,35,28,1,44,10,30,39,16,5,8,32,14,3,20 },
	{ 44,11,21,6,1,37,18,12,42,15,24,27,32,5,35,30,17,10,46,41,20,23,0,36,3,39,29,14,9,45,26,4,34,7,16,19,40,13,43,22,25,2,38,33,28,31,8 },
	{ 45,21,46,22,4,7,36,16,43,19,9,10,33,25,34,26,12,15,44,28,39,31,5,6,41,17,42,18,0,3,32,20,23,13,14,37,29,38,30,8,11,40,24,35,27,1,2 },
	{ 44,26,1,19,41,31,5,6,45,10,46,25,34,18,30,29,23,11,24,35,2,17,42,28,22,21,8,3,32,16,43,12,15,36,20,39,9,27,33,0,13,40,14,37,4,38,7 },
	{ 8,27,3,17,13,36,14,23,42,20,9,32,26,16,37,15,38,43,4,33,10,0,19,30,39,29,5,6,11,34,25,1,44,18,31,28,40,7,35,24,45,2,46,12,41,22,21 },
	{ 42,19,5,32,39,8,14,16,4,27,38,41,17,22,37,26,13,40,46,23,24,36,12,3,20,25,31,45,2,21,11,30,1,44,35,10,28,0,7,34,43,29,18,33,6,9,15 },
	{ 13,26,25,40,7,0,19,34,28,33,10,9,22,43,21,36,3,12,31,46,24,45,6,5,18,39,17,32,15,8,27,42,20,41,2,1,30,35,29,44,11,4,23,38,16,37,14 },
},
{
	/* Frame 154 */
	{ 21,9,12,43,38,17,30,8,37,42,7,26,31,41,36,3,6,28,27,40,5,2,24,29,1,4,35,46,25,22,0,45,34,15,18,23,33,44,11,14,20,19,32,13,10,39,16 },
	{ 1,22,38,25,41,15,8,19,35,20,36,2,13,26,42,17,33,7,0,31,24,40,14,5,18,34,29,45,11,12,23,39,16,32,6,9,30,46,21,37,3,4,27,43,28,44,10 },
	{ 38,0,12,5,19,15,22,39,16,13,34,4,2,26,23,17,46,24,35,20,3,44,27,37,6,30,25,21,42,28,45,10,36,7,40,31,33,8,1,43,29,11,18,41,14,32,9 },
	{ 24,14,36,29,11,0,41,22,5,44,19,8,35,26,13,38,31,16,2,43,21,7,46,37,28,10,32,25,15,4,45,18,1,40,23,12,39,30,9,34,27,20,6,17,3,42,33 },
	{ 41,7,12,16,27,5,28,2,46,32,43,21,30,39,44,18,8,37,15,1,34,24,23,13,17,10,40,6,29,3,33,26,4,45,19,9,42,20,31,38,35,25,22,36,14,0,11 },
	{ 31,35,19,36,20,9,15,3,4,45,24,33,17,39,23,42,26,13,1,40,7,10,28,37,21,8,46,30,34,18,5,44,25,14,2,43,27,12,32,16,38,22,11,29,0,41,6 },
	{ 14,33,36,26,13,35,38,25,20,15,0,37,27,22,2,39,40,21,1,4,42,23,16,3,6,41,44,18,5,43,46,17,28,7,8,45,19,30,10,32,29,9,12,34,31,24,11 },
	{ 23,40,34,13,24,7,26,41,35,12,17,14,27,36,42,1,16,15,18,37,43,0,29,2,19,44,38,9,28,3,30,45,39,8,21,10,31,32,46,5,20,11,22,33,4,25,6 },
	{ 42,20,9,29,41,23,11,14,43,4,46,17,36,28,22,19,31,5,16,37,12,25,44,18,30,27,0,13,32,24,45,2,7,34,26,39,1,21,33,8,3,40,6,35,10,38,15 },
	{ 5,0,29,24,20,33,44,7,2,30,10,22,35,1,12,25,21,16,45,40,36,3,31,26,23,18,15,38,46,43,13,8,4,17,28,41,37,32,27,6,19,14,11,39,34,42,9 },
	{ 33,15,26,21,8,39,42,14,3,20,25,43,36,31,2,13,24,37,40,30,19,12,1,46,41,7,18,29,0,34,6,11,28,17,35,44,23,10,5,16,45,32,22,27,4,9,38 },
	{ 6,42,5,41,22,21,7,43,4,40,23,16,2,38,1,37,18,17,3,39,0,36,19,28,14,34,13,33,30,29,15,35,12,32,31,24,10,46,9,45,26,25,11,8,44,27,20 },
},
{
	/* Frame 155 */
	{ 9,10,36,3,17,40,15,33,29,34,20,45,23,46,4,24,39,27,8,18,43,1,2,30,13,14,32,7,21,44,11,37,25,38,16,41,19,42,0,28,35,31,12,22,5,6,26 },
	{ 46,9,43,26,7,0,21,2,15,8,29,42,39,37,20,3,22,14,17,45,28,11,38,25,36,35,23,33,16,44,18,10,31,41,24,5,34,32,13,19,30,40,4,27,6,1,12 },
	{ 32,21,26,5,2,45,24,38,31,0,15,36,17,35,22,9,6,33,20,42,27,4,3,40,29,39,18,13,10,37,16,46,23,8,7,44,25,43,30,1,14,41,28,34,19,12,11 },
	{ 40,17,43,3,25,0,15,22,12,37,30,38,41,42,1,23,13,20,31,6,28,10,32,35,44,21,7,29,4,11,18,8,33,26,34,45,46,5,19,9,16,27,2,24,14,36,39 },
	{ 5,8,12,46,7,10,33,31,20,16,35,13,6,18,32,15,36,21,41,17,34,28,24,43,19,14,37,26,40,1,44,29,39,25,42,3,22,27,0,45,4,38,9,2,23,11,30 },
	{ 0,5,34,39,10,15,4,3,38,14,24,2,7,25,28,27,41,6,16,29,26,31,40,45,17,20,33,30,9,44,43,21,18,32,37,8,13,42,19,22,1,36,35,12,11,46,23 },
	{ 12,2,14,32,44,34,46,1,13,3,15,33,45,35,16,20,18,22,17,21,19,23,8,4,10,6,40,36,42,38,9,5,11,7,41,37,43,39,24,28,26,30,25,29,27,31,0 },
	{ 33,17,38,22,8,15,40,20,35,19,5,2,45,29,42,26,0,7,32,24,31,9,14,37,21,34,18,12,11,44,16,39,23,1,6,41,25,46,30,4,3,36,28,43,27,13,10 },
	{ 44,3,11,6,33,14,23,1,39,24,4,34,13,42,21,2,37,10,19,32,30,41,22,0,38,9,46,17,12,20,29,36,26,45,18,31,40,7,15,8,16,25,5,35,28,43,27 },
	{ 14,41,1,39,13,20,43,3,24,36,15,22,40,26,38,21,42,25,4,23,8,27,6,33,10,45,5,35,9,16,7,28,32,11,18,44,30,34,17,46,29,0,19,12,31,2,37 },
	{ 38,41,33,22,25,14,17,7,42,45,35,37,26,29,19,21,11,46,39,8,30,0,23,24,15,43,12,2,4,27,28,40,32,16,6,9,31,1,44,34,36,18,20,10,13,3,5 },
	{ 21,27,32,13,46,3,20,26,45,12,43,2,25,31,44,1,42,7,24,30,41,0,39,6,29,19,40,5,38,11,28,18,37,4,35,10,17,23,36,9,34,15,16,22,33,8,14 },
},
{
	/* Frame 156 */
	{ 26,16,24,3,11,1,9,19,27,17,25,2,10,0,8,35,33,45,34,46,32,44,22,30,20,28,7,15,5,13,23,31,21,29,6,14,4,12,39,43,37,41,38,42,36,40,18 },
	{ 16,36,21,33,45,9,12,39,3,18,6,42,27,15,30,37,1,4,8,25,13,28,40,34,19,7,22,43,46,31,10,0,17,5,20,32,24,44,29,41,35,38,23,2,11,26,14 },
	{ 38,10,6,15,8,45,21,13,39,26,46,7,34,14,43,24,44,1,12,41,27,18,35,30,42,25,0,37,28,40,5,19,31,22,16,36,29,4,33,2,11,23,17,9,20,32,3 },
	{ 10,41,5,39,13,16,3,28,32,11,22,40,26,38,17,46,29,0,23,8,27,6,37,14,45,1,35,9,20,43,7,24,36,15,18,44,30,34,21,42,25,4,19,12,31,2,33 },
	{ 33,18,31,38,5,42,9,3,36,14,21,16,12,23,40,27,34,1,28,6,10,45,30,39,4,43,25,32,19,15,20,8,2,37,22,41,26,35,17,46,13,7,11,44,0,29,24 },
	{ 22,16,28,43,10,41,23,17,34,29,46,11,40,9,20,35,2,14,45,8,21,38,3,32,15,44,13,26,39,6,33,0,12,27,7,36,1,18,30,24,37,4,19,31,25,42,5 },
	{ 15,9,5,2,14,8,4,35,41,37,34,46,40,36,19,23,25,29,18,22,24,28,11,7,1,13,10,6,0,12,43,39,33,45,42,38,32,44,27,31,17,21,26,30,16,20,3 },
	{ 23,36,42,1,28,15,26,37,43,0,21,6,27,40,34,13,20,7,18,41,35,12,25,10,19,32,46,5,24,11,30,33,4,17,2,31,44,38,9,16,3,22,45,39,8,29,14 },
	{ 38,13,15,8,33,10,25,5,45,22,0,40,3,42,17,12,37,14,29,32,26,35,24,4,44,7,46,21,2,16,19,36,30,39,28,27,34,9,11,6,20,23,1,41,18,43,31 },
	{ 15,10,45,40,46,27,28,5,0,6,35,36,17,23,18,11,12,41,42,29,24,30,1,7,2,37,32,38,19,20,13,8,14,43,44,25,31,26,3,4,33,39,34,21,16,22,9 },
	{ 24,22,21,38,10,37,9,7,28,19,0,14,35,13,32,26,25,23,42,4,41,39,11,36,16,30,29,46,2,45,1,15,20,27,8,6,43,5,40,18,17,31,34,12,33,3,44 },
	{ 34,30,4,10,45,17,39,27,13,7,32,24,46,18,8,14,41,21,35,31,1,11,44,28,42,22,12,2,37,25,19,5,15,40,16,38,26,0,6,33,29,43,23,9,3,36,20 },
},
{
	/* Frame 157 */
	{ 19,27,4,35,44,16,6,1,14,18,29,26,3,45,11,0,40,28,2,13,10,36,25,46,41,38,21,12,43,37,24,23,31,9,39,32,20,42,5,34,22,17,30,8,7,33,15 },
	{ 43,13,11,25,32,23,34,0,2,28,41,26,39,9,7,21,44,19,46,12,14,24,37,22,35,5,3,17,40,31,42,8,10,20,33,18,1,15,29,36,27,38,4,6,16,45,30 },
	{ 42,36,19,2,21,12,43,37,22,3,24,13,38,32,23,14,25,8,39,33,26,15,28,9,34,44,27,10,29,4,35,45,30,11,16,5,46,40,31,6,17,0,41,18,7,20,1 },
	{ 43,22,0,46,19,37,17,10,32,20,15,13,39,26,8,34,31,45,29,6,40,24,3,1,18,4,42,23,33,21,14,36,16,11,9,35,30,12,38,27,41,25,2,44,28,7,5 },
	{ 5,23,15,12,17,41,2,27,24,21,45,6,35,28,32,18,42,39,9,36,22,46,13,31,3,0,25,10,7,4,29,33,14,19,43,16,40,37,26,20,44,30,34,1,11,38,8 },
	{ 24,23,1,30,8,41,38,11,21,19,13,26,36,34,22,17,31,9,6,46,39,32,20,18,29,27,4,2,42,37,35,44,16,14,25,7,0,33,40,28,10,5,3,12,43,45,15 },
	{ 15,9,18,13,22,42,16,46,27,20,40,31,35,44,25,39,10,29,33,14,37,8,3,12,7,1,26,5,30,34,24,38,19,28,32,23,43,36,17,2,21,41,6,45,0,11,4 },
	{ 27,8,7,44,25,43,18,5,14,41,16,38,23,12,11,32,21,30,9,2,45,28,42,19,0,15,36,17,35,26,13,6,33,24,46,31,4,3,40,29,39,22,1,10,37,20,34 },
	{ 14,1,22,7,25,12,31,34,20,36,41,6,13,30,11,21,4,19,46,28,40,39,33,10,5,18,3,29,8,27,38,16,32,43,45,2,9,26,15,17,0,23,42,24,44,35,37 },
	{ 31,13,37,30,12,36,15,39,28,14,38,29,23,5,22,4,41,7,43,20,40,6,42,21,25,27,24,26,9,33,11,35,8,32,10,34,17,45,19,16,44,18,1,3,46,0,2 },
	{ 39,4,9,22,46,12,17,31,34,33,25,7,11,41,0,14,18,38,37,8,23,27,20,45,43,30,3,28,32,6,10,5,40,19,13,16,36,35,26,21,24,44,42,2,29,1,15 },
	{ 15,5,38,9,42,18,32,30,35,44,20,23,24,37,27,2,41,17,14,29,4,7,8,11,1,34,13,46,22,36,26,39,40,16,43,19,28,33,31,6,45,21,10,25,0,3,12 },
},
{
	/* Frame 158 */
	{ 23,33,4,28,43,25,38,0,30,18,45,27,21,34,7,41,12,36,3,16,14,8,32,5,29,10,46,22,1,31,19,44,42,24,39,40,13,26,20,35,6,17,15,9,37,2,11 },
	{ 36,7,1,31,43,25,45,14,4,18,38,20,40,11,13,23,35,17,37,6,8,30,42,24,32,3,5,27,29,41,10,0,22,34,16,44,15,9,19,39,21,33,2,12,26,46,28 },
	{ 1,38,28,43,27,45,23,37,16,12,11,7,30,40,24,4,35,19,14,8,32,21,3,42,26,44,22,0,39,29,10,6,36,17,13,46,5,34,18,31,41,25,33,20,2,15,9 },
	{ 13,6,8,35,19,45,25,38,22,40,28,11,1,14,4,43,31,33,17,46,26,36,20,7,9,2,12,39,23,41,29,34,18,44,24,15,5,10,0,27,37,21,42,30,32,16,3 },
	{ 33,44,3,14,39,21,9,23,45,34,15,16,40,22,10,35,46,17,28,41,11,4,29,18,31,42,5,24,19,30,0,43,36,25,6,1,12,37,7,26,32,13,2,38,27,20,8 },
	{ 46,5,12,0,35,9,17,7,37,30,44,2,32,11,41,19,4,39,13,21,34,25,43,16,6,36,15,45,23,10,18,27,38,29,20,24,42,1,8,14,22,31,3,33,26,40,28 },
	{ 26,45,30,35,17,39,21,8,27,12,31,2,32,6,36,9,42,13,24,46,3,28,33,7,18,37,22,43,25,29,0,19,4,23,10,40,14,44,1,34,5,16,38,11,20,41,15 },
	{ 1,17,11,27,33,43,0,16,10,26,32,46,5,29,15,23,37,4,28,14,22,36,34,9,25,3,19,41,35,8,24,2,18,40,38,13,21,7,31,45,39,12,20,6,30,44,42 },
	{ 6,13,22,15,29,0,31,42,16,40,39,37,14,1,30,3,17,8,19,38,24,36,45,2,9,18,11,25,4,27,46,20,44,35,33,10,5,26,7,21,12,23,34,28,32,43,41 },
	{ 30,11,35,21,0,45,37,26,7,46,17,29,41,33,22,3,42,13,25,5,18,14,38,9,20,1,44,31,10,34,16,28,40,36,27,6,43,12,24,32,23,2,15,39,8,4,19 },
	{ 21,14,9,36,18,12,43,7,16,27,41,5,34,22,25,10,39,32,20,31,8,37,3,46,29,6,1,44,26,4,35,15,24,19,33,13,42,30,17,2,40,28,23,0,45,11,38 },
	{ 8,36,11,39,24,27,9,37,10,38,25,18,40,0,43,3,16,19,41,1,42,2,17,30,12,32,15,35,28,31,13,33,14,34,29,22,44,4,7,20,23,45,5,46,6,21,26 },
},
{
	/* Frame 159 */
	{ 19,44,16,4,7,30,21,43,9,32,3,26,0,46,45,17,14,5,28,39,31,36,42,41,10,22,35,27,1,24,12,15,18,29,38,37,6,40,20,11,23,8,34,33,25,2,13 },
	{ 36,35,29,33,13,24,42,21,8,5,34,32,30,45,25,14,20,9,22,4,17,6,1,31,44,15,26,41,23,10,16,7,18,0,2,27,40,11,39,19,37,3,28,46,12,43,38 },
	{ 24,1,46,40,23,6,29,0,41,26,7,28,13,42,36,27,2,17,12,43,37,30,3,16,9,38,32,31,14,21,8,39,33,18,15,20,5,34,44,19,10,25,4,35,45,22,11 },
	{ 18,42,17,32,35,45,7,4,19,10,16,9,26,34,25,44,37,11,8,27,2,24,1,22,46,21,36,39,41,3,0,23,14,20,13,30,38,29,40,43,33,15,12,31,6,28,5 },
	{ 6,45,28,32,31,43,18,9,36,10,22,5,14,3,40,17,26,7,44,21,33,30,34,13,0,11,38,25,4,15,29,41,16,42,19,8,37,20,46,23,35,12,1,2,39,24,27 },
	{ 17,30,18,13,1,46,34,25,6,26,20,9,42,36,39,14,2,28,16,31,44,32,35,23,10,4,24,7,27,40,43,37,19,12,0,15,3,45,33,21,8,22,11,5,38,41,29 },
	{ 16,6,26,44,38,13,17,7,27,45,39,28,8,22,2,40,34,29,9,23,3,41,35,4,24,14,18,36,46,5,25,15,19,37,20,0,30,10,32,42,21,1,31,11,33,43,12 },
	{ 27,4,3,32,17,18,9,10,37,24,34,23,0,15,44,29,43,30,5,6,33,20,46,19,12,11,40,25,39,26,1,2,45,16,42,31,8,7,36,21,35,22,13,14,41,28,38 },
	{ 42,41,23,17,44,18,15,28,1,2,4,38,37,27,43,21,40,22,11,16,13,14,0,34,33,31,39,25,36,26,7,20,9,10,12,46,45,19,35,29,32,30,3,24,5,6,8 },
	{ 9,17,8,16,46,40,15,23,41,14,22,29,1,39,28,0,38,32,27,7,33,26,6,13,21,43,12,20,42,44,11,19,45,10,18,25,5,35,24,4,34,36,31,3,37,30,2 },
	{ 40,44,42,46,41,45,43,18,12,16,30,2,29,0,14,19,13,17,31,3,28,1,15,34,38,32,36,35,39,33,37,8,22,26,20,25,6,10,4,9,23,27,21,24,7,11,5 },
	{ 27,16,34,15,4,41,19,26,7,14,37,40,18,29,6,43,36,9,21,28,39,42,1,8,31,20,38,11,0,45,23,30,3,10,33,44,22,25,2,32,13,17,24,35,46,5,12 },
},
{
	/* Frame 160 */
	{ 13,38,46,4,12,39,37,45,7,15,36,44,6,14,21,20,27,23,25,26,22,24,34,42,32,40,35,43,33,41,3,11,1,9,2,10,0,8,29,28,19,17,31,18,16,30,5 },
	{ 16,34,39,43,29,15,10,0,23,37,18,32,30,13,27,41,35,21,7,2,28,14,25,11,46,22,5,19,33,12,9,44,20,6,17,3,38,24,42,4,1,36,8,31,45,26,40 },
	{ 11,38,22,0,12,37,26,41,6,46,17,29,5,18,14,35,8,43,20,45,2,32,31,25,1,13,10,39,23,16,28,36,27,40,7,15,34,9,4,19,33,30,24,42,21,44,3 },
	{ 12,19,38,24,5,43,21,32,2,45,18,15,4,27,42,20,9,35,29,44,14,37,26,7,8,23,34,28,1,17,36,6,41,22,11,0,31,46,16,13,39,25,40,10,33,30,3 },
	{ 23,29,0,26,45,22,28,42,1,38,19,44,25,21,43,14,39,18,37,24,20,34,15,40,13,36,17,10,35,6,41,12,16,11,7,32,5,31,2,8,33,4,30,3,9,46,27 },
	{ 39,12,36,30,25,10,34,9,21,44,6,1,19,42,16,41,29,14,38,13,33,27,24,5,23,46,20,45,3,0,18,37,31,28,11,35,8,32,26,7,4,22,43,17,40,2,15 },
	{ 27,5,25,6,26,4,24,39,37,38,36,23,3,21,1,22,2,20,0,35,33,34,32,15,19,13,17,14,18,12,16,45,46,44,31,11,29,9,30,10,28,8,43,41,42,40,7 },
	{ 13,25,15,27,45,12,24,14,26,44,42,9,21,11,23,41,43,8,20,10,22,40,38,5,17,7,19,37,39,4,16,6,18,36,34,1,29,3,31,33,35,0,28,2,30,32,46 },
	{ 46,37,23,43,25,32,18,11,20,13,6,8,34,41,27,29,36,22,15,24,1,10,12,38,45,31,35,17,40,26,3,28,5,14,0,42,33,19,39,21,44,30,7,16,9,2,4 },
	{ 4,32,19,13,41,26,0,7,9,14,28,38,3,21,10,44,24,31,34,37,17,22,43,12,40,27,5,33,18,8,15,1,6,20,46,11,29,39,2,36,16,23,42,45,25,30,35 },
	{ 16,20,26,30,17,21,27,31,34,46,8,4,2,14,41,37,35,9,5,3,15,40,36,24,28,18,22,25,29,19,23,42,38,0,12,10,6,33,45,43,39,1,13,11,7,32,44 },
	{ 32,28,10,44,7,1,15,9,34,4,19,46,21,12,39,27,33,29,22,43,16,45,6,30,36,24,14,40,3,5,11,13,38,0,23,42,17,8,35,31,37,25,18,20,41,2,26 },
},
{
	/* Frame 161 */
	{ 45,16,14,4,46,19,36,29,7,1,39,26,33,20,2,8,34,23,40,17,11,5,43,30,37,24,6,12,38,27,44,21,15,9,18,41,28,10,0,42,31,32,25,3,13,35,22 },
	{ 0,13,42,39,25,20,41,12,11,38,21,18,40,37,10,7,19,30,9,36,35,6,16,31,8,5,34,17,28,33,4,3,46,29,26,32,45,2,15,27,22,1,44,43,14,24,23 },
	{ 34,1,29,3,31,33,35,0,28,2,30,44,46,17,13,19,15,45,16,12,18,14,40,42,9,21,11,23,41,43,8,20,10,22,36,38,25,5,27,7,37,39,24,4,26,6,32 },
	{ 32,7,1,14,8,46,2,4,27,34,29,43,23,45,17,30,39,24,33,18,40,20,15,9,36,3,5,10,12,42,6,0,31,38,25,19,41,21,26,35,28,37,22,44,16,11,13 },
	{ 16,12,37,11,7,20,0,34,15,26,41,4,42,44,18,30,39,25,22,2,33,29,9,36,10,6,17,13,14,27,40,21,1,35,31,38,24,5,43,45,19,46,32,28,8,23,3 },
	{ 26,18,28,20,27,19,29,21,14,2,8,4,15,3,9,5,35,41,37,46,34,40,36,30,22,24,16,31,23,25,17,10,6,12,0,11,7,13,1,43,39,45,33,42,38,44,32 },
	{ 30,27,15,4,42,0,20,12,8,28,39,2,45,23,41,36,10,32,31,16,46,5,43,1,24,34,13,9,18,6,3,26,14,37,11,33,21,17,29,38,25,35,44,22,40,19,7 },
	{ 31,12,41,15,43,29,30,13,40,14,42,28,23,36,4,39,7,21,22,37,5,38,6,20,25,44,27,9,11,24,45,26,46,8,10,17,19,33,1,35,3,16,18,32,0,34,2 },
	{ 28,8,36,13,16,21,44,1,15,27,31,35,6,2,43,25,12,33,20,0,41,5,26,38,30,34,11,7,46,19,42,23,24,29,32,9,37,17,40,4,45,39,14,10,18,22,3 },
	{ 13,1,32,11,23,12,0,10,30,18,9,46,21,31,19,45,8,39,20,43,16,26,44,7,38,29,42,17,27,37,6,41,28,35,24,5,36,15,40,3,34,25,4,14,33,2,22 },
	{ 17,40,13,35,22,10,0,29,45,7,19,42,31,32,5,24,39,2,14,21,37,9,12,34,23,46,26,16,41,28,44,6,11,1,4,25,38,18,43,30,33,20,36,8,3,15,27 },
	{ 38,27,6,40,30,37,8,45,5,42,13,39,10,7,31,24,44,16,43,12,11,46,18,14,25,17,28,20,19,15,32,22,0,29,34,21,2,26,33,23,41,1,36,9,35,4,3 },
},
{
	/* Frame 162 */
	{ 4,41,11,38,28,19,5,36,10,35,29,22,8,37,15,34,16,23,9,32,14,17,26,12,33,3,46,20,27,13,44,2,43,21,30,0,45,7,42,24,31,1,40,6,39,25,18 },
	{ 3,1,45,18,16,2,46,0,44,19,17,39,15,37,13,30,28,38,14,36,12,31,29,7,43,5,41,22,20,6,42,4,40,23,21,35,11,33,9,26,24,34,10,32,8,27,25 },
	{ 39,26,25,38,27,9,11,37,8,10,36,7,20,6,21,41,23,43,5,40,22,42,4,3,16,2,17,19,45,1,18,44,0,46,35,28,30,34,29,31,13,33,15,12,32,14,24 },
	{ 2,5,31,34,8,23,40,0,26,39,29,32,18,45,21,11,24,37,3,16,14,9,46,6,1,27,38,12,43,19,44,4,30,35,25,36,22,41,17,15,28,33,7,20,10,13,42 },
	{ 6,11,20,40,42,30,19,28,33,36,7,27,21,41,44,43,46,2,29,16,37,26,4,24,45,3,12,17,14,34,5,25,22,13,0,15,35,38,8,23,10,1,31,18,39,32,9 },
	{ 41,40,46,25,9,31,15,24,8,30,14,33,39,32,38,21,1,19,7,20,0,18,6,45,43,44,42,29,13,27,11,28,12,26,10,37,35,36,34,17,5,23,3,16,4,22,2 },
	{ 13,15,35,29,17,18,0,25,37,26,39,8,22,41,20,42,30,28,32,19,44,1,46,2,27,9,10,23,4,43,6,31,12,33,14,34,45,16,3,24,36,11,38,5,7,40,21 },
	{ 41,24,42,19,0,44,29,46,23,35,5,9,10,39,16,12,14,21,32,25,43,26,1,37,2,30,4,6,11,40,17,18,15,45,28,33,22,34,27,8,36,3,38,31,13,7,20 },
	{ 46,44,37,15,6,29,4,31,40,33,43,18,25,0,10,3,38,36,7,28,21,30,23,13,32,42,35,24,17,27,2,9,39,45,20,14,22,12,5,34,41,16,26,19,8,1,11 },
	{ 42,24,26,9,41,11,43,25,27,8,40,14,36,28,38,30,13,15,37,29,39,31,12,0,32,2,34,16,18,1,33,3,35,17,19,4,46,6,20,22,45,5,7,21,23,44,10 },
	{ 16,35,26,40,21,38,31,12,2,9,7,37,28,18,32,25,42,23,4,14,1,11,41,20,39,30,44,17,34,27,8,6,13,3,33,24,43,22,36,29,46,19,0,10,5,15,45 },
	{ 17,24,16,8,44,0,36,9,45,1,37,29,21,43,28,20,42,12,34,4,13,35,5,19,11,18,10,46,2,38,27,3,39,26,23,15,22,14,6,40,31,32,7,41,30,33,25 },
},
{
	/* Frame 163 */
	{ 46,26,8,2,37,17,39,19,13,15,40,20,34,22,4,10,45,25,27,1,3,36,28,42,30,12,6,33,21,35,23,9,11,44,16,38,18,0,14,41,29,43,31,5,7,32,24 },
	{ 40,39,31,2,12,20,7,1,24,45,10,19,29,32,15,43,4,35,27,46,8,22,16,37,3,13,21,41,38,30,25,44,11,6,0,42,5,18,28,33,14,9,23,17,36,34,26 },
	{ 31,40,43,9,29,10,30,41,42,8,28,27,15,44,25,13,26,14,45,46,24,12,3,23,32,35,1,21,2,22,33,34,0,20,19,7,36,39,17,5,18,6,37,38,16,4,11 },
	{ 18,26,20,28,19,27,21,29,2,10,36,44,35,43,4,12,3,11,37,45,34,42,5,13,22,30,16,24,23,31,17,25,6,14,32,40,39,0,8,7,15,33,41,38,46,1,9 },
	{ 45,2,4,24,15,34,19,46,21,8,37,30,29,0,40,7,11,38,13,32,17,22,43,26,25,14,44,3,5,9,36,31,35,18,20,41,6,10,28,1,23,42,27,39,12,33,16 },
	{ 25,17,27,19,24,16,26,18,13,1,15,3,44,32,46,34,12,0,14,2,45,33,35,29,21,31,23,28,20,30,22,9,5,11,7,40,36,42,38,8,4,10,6,41,37,43,39 },
	{ 14,35,42,23,24,37,44,0,41,34,11,22,36,13,33,40,20,10,19,12,32,9,21,31,18,7,8,17,30,6,28,16,27,39,46,3,29,5,26,38,15,2,43,25,4,45,1 },
	{ 23,44,19,41,7,3,22,45,18,40,6,2,31,27,39,15,35,11,30,26,38,14,34,10,17,4,1,43,21,16,5,46,0,42,20,25,36,12,33,9,29,24,37,13,32,8,28 },
	{ 28,0,31,38,33,21,8,7,42,41,29,16,30,32,37,24,6,27,46,40,45,17,15,3,36,25,22,26,5,44,14,2,13,35,23,11,4,18,12,1,34,39,10,20,9,43,19 },
	{ 40,3,18,13,24,39,41,2,31,12,17,46,36,11,30,1,16,37,10,23,0,29,34,44,7,22,9,28,35,45,6,27,8,21,42,32,15,26,5,20,43,33,14,19,4,25,38 },
	{ 6,3,34,15,46,26,43,31,21,1,32,4,24,41,13,44,7,38,18,35,23,27,30,10,16,33,5,36,25,28,45,8,39,19,22,2,14,11,42,17,20,37,0,29,9,40,12 },
	{ 36,16,34,22,27,12,0,6,11,44,29,42,30,38,18,33,21,8,14,41,2,5,25,46,26,13,37,17,35,23,10,45,28,1,7,32,20,9,43,31,39,19,4,24,15,40,3 },
},
{
	/* Frame 164 */
	{ 2,46,1,45,18,17,3,0,44,19,24,10,38,9,37,26,25,11,39,8,36,27,20,6,42,5,41,22,21,7,43,4,40,23,28,14,34,13,33,30,29,15,35,12,32,31,16 },
	{ 7,5,27,6,4,26,38,25,36,39,24,37,41,19,11,40,18,10,17,9,42,16,8,43,33,31,3,29,32,30,2,28,1,34,0,35,23,15,21,13,22,14,20,12,46,44,45 },
	{ 39,16,2,38,17,19,1,37,18,0,36,35,7,20,34,6,21,23,33,5,22,32,4,9,45,11,8,44,10,46,25,27,24,26,41,13,43,15,40,12,42,14,29,31,28,30,3 },
	{ 16,28,22,26,17,29,23,27,0,12,6,10,33,45,39,43,1,13,7,11,32,44,38,42,20,24,18,30,21,25,19,31,4,8,2,14,37,41,35,5,9,3,15,36,40,34,46 },
	{ 24,34,31,29,40,1,42,22,4,9,35,30,28,17,43,2,5,36,8,10,13,16,3,21,37,6,11,32,12,45,14,19,20,7,38,27,33,25,44,15,46,18,41,0,23,39,26 },
	{ 42,40,26,10,24,8,43,41,27,11,25,9,34,32,22,2,20,0,35,33,23,3,21,1,46,44,30,14,28,12,45,31,15,29,13,38,36,18,6,16,4,39,37,19,7,17,5 },
	{ 12,38,20,27,33,18,42,14,5,9,34,0,30,45,7,25,10,16,40,37,28,23,21,26,32,3,13,39,4,8,19,43,15,44,6,24,35,1,31,36,29,22,46,11,17,41,2 },
	{ 41,16,12,8,3,46,31,26,1,45,20,39,24,34,19,6,36,11,32,17,5,9,28,22,42,27,14,44,21,40,25,35,13,7,2,33,30,4,0,29,38,23,43,18,15,37,10 },
	{ 30,33,2,42,12,35,16,45,15,32,18,27,28,34,5,17,44,9,14,7,19,26,29,4,8,37,6,41,46,11,39,20,24,36,1,22,40,31,10,38,3,21,43,13,25,0,23 },
	{ 26,0,16,42,32,11,27,1,17,43,33,14,22,4,28,46,36,15,23,5,29,37,2,18,8,24,34,40,3,19,9,25,35,41,6,30,12,20,38,44,7,31,13,21,39,45,10 },
	{ 23,36,21,38,45,14,12,3,18,1,16,35,27,40,25,42,37,6,4,15,30,13,28,19,32,17,34,41,10,8,7,22,5,20,39,31,44,29,46,33,2,0,11,26,9,24,43 },
	{ 10,44,9,15,12,30,18,0,39,23,20,34,7,33,11,8,26,28,42,31,41,19,16,38,3,37,21,6,32,5,24,46,27,45,29,43,14,40,13,17,2,36,1,22,4,35,25 },
},
{
	/* Frame 165 */
	{ 23,9,4,25,12,20,11,28,6,27,22,40,32,13,10,29,34,26,15,41,31,33,44,36,35,14,38,30,1,45,17,37,3,42,19,39,0,8,16,5,24,2,21,43,18,7,46 },
	{ 18,23,40,45,10,15,22,9,44,35,14,16,8,13,34,39,17,20,27,33,12,3,38,21,26,31,32,37,2,7,30,1,36,43,6,24,0,5,42,25,28,19,41,4,11,46,29 },
	{ 46,11,45,8,14,21,26,36,1,7,35,4,19,16,30,42,13,41,10,25,23,20,32,38,3,37,0,6,29,18,44,9,15,43,12,27,24,22,34,5,33,39,2,17,31,28,40 },
	{ 26,5,3,45,17,43,23,12,6,32,24,38,18,9,15,37,29,35,27,4,10,44,16,42,30,1,7,41,21,19,8,2,36,28,34,22,13,11,33,25,39,31,0,14,40,20,46 },
	{ 19,20,43,38,9,31,33,23,18,42,13,8,32,22,11,12,35,1,15,10,45,34,5,0,25,14,44,3,4,29,24,7,2,37,28,46,17,6,41,36,26,21,16,39,40,30,27 },
	{ 27,0,38,24,21,2,13,37,26,23,15,39,40,20,12,5,42,22,29,14,7,41,32,31,4,43,34,28,17,6,9,33,30,19,11,35,44,16,8,1,46,18,25,10,3,45,36 },
	{ 33,12,2,14,17,28,36,38,41,22,10,5,25,7,44,34,46,18,30,0,13,3,15,42,37,39,26,21,8,23,11,32,45,35,16,29,19,31,1,40,43,4,24,6,27,20,9 },
	{ 37,10,6,17,12,42,11,7,16,13,43,4,2,31,8,46,5,34,3,30,40,9,0,35,28,27,41,23,32,1,38,29,26,44,22,33,14,39,24,21,45,19,36,15,25,20,18 },
	{ 44,14,20,13,38,37,28,7,42,41,18,11,17,35,26,0,25,12,23,36,6,31,5,40,10,16,9,34,33,24,3,46,45,22,15,21,39,30,4,29,43,8,19,32,2,27,1 },
	{ 10,15,33,18,44,23,3,24,29,35,9,46,4,17,26,36,31,11,6,40,19,45,22,38,12,25,20,42,0,5,14,32,27,37,30,2,7,41,28,34,8,39,13,16,21,43,1 },
	{ 32,22,29,31,2,9,42,26,33,6,4,46,30,44,3,17,43,10,7,34,5,14,45,12,38,16,36,11,25,35,20,15,13,39,0,37,19,40,24,21,23,28,1,18,41,8,27 },
	{ 40,21,32,14,43,6,35,12,39,41,4,33,30,26,22,46,18,13,38,24,5,44,16,31,36,27,23,19,25,45,17,37,10,2,8,28,0,20,11,15,3,42,7,9,34,29,1 },
},
{
	/* Frame 166 */
	{ 21,12,19,33,30,39,11,44,28,0,6,46,17,34,37,26,9,22,15,3,24,4,41,32,31,38,43,20,13,18,1,7,10,45,29,36,27,8,23,16,35,5,40,14,2,25,42 },
	{ 17,3,43,1,41,18,16,2,42,0,40,19,25,39,11,37,9,26,24,38,10,36,8,27,21,7,5,45,22,20,6,46,4,44,23,29,35,15,33,13,30,28,34,14,32,12,31 },
	{ 20,17,23,18,4,32,28,25,31,11,12,40,36,16,6,19,5,0,34,33,44,24,30,27,13,8,14,38,41,37,42,7,2,21,1,22,35,45,46,26,29,9,15,10,39,43,3 },
	{ 3,36,24,43,19,13,10,33,29,38,26,0,15,40,16,35,31,5,2,45,21,42,18,12,7,32,28,23,9,14,37,25,34,30,4,11,44,20,39,27,1,6,41,17,46,22,8 },
	{ 20,3,29,42,6,1,15,40,4,18,13,46,35,16,30,25,44,33,2,28,11,39,0,14,9,23,37,12,26,21,34,43,31,24,7,32,41,10,5,19,38,8,22,17,36,45,27 },
	{ 13,30,35,21,4,46,28,33,7,44,31,10,5,18,29,8,38,16,45,11,36,19,2,9,26,39,17,0,42,24,37,3,40,27,14,1,22,43,25,12,34,20,41,15,32,23,6 },
	{ 37,33,43,31,16,26,20,14,45,41,38,19,24,7,28,2,46,17,27,4,15,0,10,39,34,25,22,12,3,8,36,32,42,5,30,1,11,21,44,35,40,23,13,18,9,6,29 },
	{ 1,44,24,36,20,12,4,3,27,38,22,15,6,42,16,8,0,41,29,33,21,18,11,2,46,30,35,23,14,45,25,37,17,13,5,40,28,32,26,39,19,10,7,43,31,34,9 },
	{ 22,24,17,46,39,41,0,15,26,19,29,36,43,2,12,5,16,31,38,40,33,14,7,9,18,28,21,42,35,45,4,11,30,23,25,32,6,8,1,20,27,34,44,37,10,3,13 },
	{ 33,19,34,5,6,11,28,39,31,3,20,23,44,26,43,8,15,36,18,35,0,46,7,10,25,40,30,12,17,32,22,45,4,42,9,14,37,29,38,1,2,21,24,41,27,13,16 },
	{ 18,38,9,17,4,11,28,44,19,6,33,30,46,5,35,29,12,7,20,32,31,14,41,22,34,13,43,21,0,15,24,40,23,2,37,26,42,1,39,25,8,3,16,36,27,10,45 },
	{ 19,22,18,6,46,2,42,7,3,43,25,13,24,12,38,8,34,29,39,9,35,28,17,5,45,16,4,44,0,40,21,1,41,20,31,37,27,30,36,26,32,14,10,33,15,11,23 },
},
{
	/* Frame 167 */
	{ 15,27,12,24,6,5,17,39,43,31,9,28,34,22,33,21,2,14,13,25,37,38,18,42,30,41,29,10,32,3,0,45,46,26,36,7,19,4,16,40,11,8,35,23,1,20,44 },
	{ 9,45,21,2,38,26,13,1,6,42,30,19,32,5,24,10,46,35,23,36,40,28,16,14,3,39,27,8,44,20,7,43,31,12,0,25,11,18,33,4,41,29,17,15,34,22,37 },
	{ 44,1,14,34,12,18,16,7,43,5,41,38,27,25,30,28,32,2,45,0,23,21,11,36,9,6,42,4,26,24,15,35,13,33,46,19,17,22,20,40,39,10,37,8,31,29,3 },
	{ 33,22,6,17,1,39,32,23,7,16,0,38,41,30,14,25,9,40,31,15,24,8,46,37,18,2,21,5,35,36,19,3,20,4,34,45,26,10,29,13,43,44,27,11,28,12,42 },
	{ 46,1,34,28,26,41,22,33,0,39,29,27,44,23,32,15,38,24,20,45,18,37,14,25,21,19,36,11,7,16,12,43,10,6,17,13,42,5,3,30,8,4,35,2,31,40,9 },
	{ 20,7,12,37,31,1,42,2,25,26,44,4,19,28,11,34,41,21,22,13,36,14,39,16,3,8,33,27,5,46,6,29,30,40,0,43,23,24,15,38,45,17,18,9,32,10,35 },
	{ 32,43,2,25,45,4,14,7,42,35,24,17,44,37,6,28,34,16,27,36,46,39,29,20,26,19,9,38,21,31,18,8,1,30,23,41,0,11,22,13,40,33,10,3,12,5,15 },
	{ 37,14,35,24,21,41,19,42,15,38,25,20,44,18,43,0,39,28,27,45,23,46,1,29,26,22,4,2,31,8,32,5,3,30,9,33,10,6,17,12,36,11,34,7,16,40,13 },
	{ 44,10,7,20,27,8,5,25,45,42,6,26,31,40,4,3,24,29,43,38,1,30,41,36,2,15,28,19,39,0,13,17,37,34,14,18,23,32,12,11,16,21,35,46,9,22,33 },
	{ 19,45,17,6,4,38,22,40,20,11,9,35,31,33,29,14,12,46,26,36,24,7,5,43,23,41,21,2,0,34,18,44,16,15,13,39,27,37,25,10,8,42,30,32,28,3,1 },
	{ 39,17,19,38,16,18,1,37,3,0,36,2,25,27,24,26,41,9,43,11,40,8,42,10,7,21,6,20,33,22,35,5,32,23,34,4,15,29,46,14,28,30,45,13,31,44,12 },
	{ 42,18,8,45,21,31,38,28,2,32,27,5,46,12,40,16,11,6,36,15,0,35,25,23,44,20,30,39,43,19,9,26,4,29,3,33,10,7,13,41,17,34,24,22,37,14,1 },
},
{
	/* Frame 168 */
	{ 6,37,7,5,27,38,25,4,26,39,24,44,14,45,15,13,19,46,17,12,18,16,34,32,30,35,33,31,3,29,1,2,28,0,42,40,22,43,41,23,11,21,9,10,20,8,36 },
	{ 39,37,38,36,7,31,5,29,6,30,4,28,19,45,46,18,44,17,15,13,16,14,12,33,3,27,32,2,26,1,25,34,0,24,35,41,11,40,10,23,9,21,42,22,8,20,43 },
	{ 20,10,23,24,4,43,44,13,2,14,1,28,35,36,11,6,25,5,26,45,40,46,3,15,17,29,18,30,38,37,32,7,8,21,27,22,41,42,16,12,19,31,0,39,34,33,9 },
	{ 39,33,19,7,21,1,38,32,18,6,20,0,41,27,15,29,9,46,40,26,14,28,8,35,37,23,3,17,5,34,36,22,2,16,4,43,45,31,11,25,13,42,44,30,10,24,12 },
	{ 34,16,43,29,44,5,18,31,46,7,0,13,20,37,2,40,11,22,39,17,42,24,45,4,19,26,33,6,15,8,35,21,36,28,41,10,23,38,30,25,1,12,27,32,3,14,9 },
	{ 26,25,36,7,8,31,34,16,33,14,13,22,39,21,40,11,0,19,46,24,45,6,5,30,43,29,32,3,12,27,38,20,37,10,9,18,35,17,44,15,4,23,42,28,41,2,1 },
	{ 36,40,16,28,23,26,2,32,13,20,39,42,18,14,5,9,34,30,6,45,25,1,29,46,22,11,37,41,17,12,21,38,27,3,33,4,8,43,19,15,44,24,0,35,31,7,10 },
	{ 5,6,36,16,35,19,0,45,29,31,9,11,40,24,42,20,39,23,4,3,33,17,34,13,15,44,28,46,26,8,10,7,37,21,38,18,1,2,32,30,12,14,41,25,43,27,22 },
	{ 14,19,8,31,4,25,34,21,46,18,40,30,11,36,24,7,35,20,1,13,41,10,37,6,27,0,23,12,17,42,29,38,26,32,22,3,44,16,15,43,28,9,39,5,33,2,45 },
	{ 17,11,5,18,41,24,6,12,42,27,36,29,15,9,35,30,45,20,10,0,46,23,40,25,3,13,39,26,33,16,14,4,34,19,44,21,7,1,43,22,37,28,2,8,38,31,32 },
	{ 33,19,7,32,18,6,21,1,38,20,0,39,41,31,15,40,30,14,25,9,46,24,8,37,23,3,36,22,2,17,5,34,16,4,35,45,27,11,44,26,10,29,13,42,28,12,43 },
	{ 45,4,46,7,37,30,38,29,16,2,41,27,8,33,11,5,6,20,31,12,15,17,18,40,1,43,24,32,10,35,22,44,21,13,36,14,39,28,19,0,42,3,25,26,34,9,23 },
},
{
	/* Frame 169 */
	{ 26,36,21,14,9,38,23,33,28,11,0,35,30,40,25,2,13,42,27,37,16,15,4,39,18,44,29,6,1,46,31,41,20,3,8,43,22,32,17,10,5,34,19,45,24,7,12 },
	{ 42,28,33,38,18,45,30,35,0,12,2,9,14,5,17,11,29,32,7,19,44,24,31,34,20,41,46,26,37,22,43,8,39,4,10,1,6,13,25,3,21,40,15,27,36,16,23 },
	{ 30,0,28,34,32,3,31,1,29,35,33,6,26,4,24,38,36,7,27,5,25,39,37,10,22,8,20,42,40,11,23,9,21,43,41,14,18,12,16,46,44,15,19,13,17,45,2 },
	{ 7,5,39,45,14,12,33,27,2,25,0,23,40,21,42,36,30,38,28,15,18,13,16,3,1,35,41,10,8,37,31,6,29,4,19,44,17,46,32,26,34,24,11,22,9,20,43 },
	{ 27,24,46,12,15,42,39,2,36,17,35,5,32,23,20,26,44,25,10,13,40,31,43,28,3,37,0,18,33,6,21,45,8,11,41,30,29,14,1,38,19,16,7,34,4,22,9 },
	{ 2,26,0,24,3,27,1,25,35,33,34,32,22,10,20,8,23,11,21,9,43,41,42,40,6,30,4,28,7,31,5,29,39,37,38,36,18,14,16,12,19,15,17,13,45,46,44 },
	{ 15,9,29,43,22,17,4,32,30,24,13,37,41,38,1,21,2,44,46,8,28,10,16,5,19,6,33,34,12,27,14,40,39,42,20,3,23,11,31,25,36,18,7,0,35,45,26 },
	{ 41,27,15,29,9,46,40,26,14,28,8,39,33,23,7,17,1,38,32,22,6,16,0,43,45,31,11,25,13,42,44,30,10,24,12,35,37,19,3,21,5,34,36,18,2,20,4 },
	{ 10,46,18,28,41,21,45,38,31,3,33,24,37,17,14,43,22,9,13,0,35,26,7,19,29,40,4,11,2,32,25,20,44,39,30,42,23,8,36,16,15,34,27,6,12,1,5 },
	{ 11,0,18,38,31,37,20,7,34,27,33,24,44,3,14,13,40,23,10,9,19,16,36,29,6,43,5,32,25,2,1,12,39,30,21,8,35,26,46,17,45,28,15,42,4,41,22 },
	{ 2,15,33,9,4,17,38,31,11,45,0,29,34,27,22,41,36,12,25,43,7,18,14,32,8,20,3,30,10,44,5,16,39,46,26,23,40,1,28,35,42,6,19,37,13,24,21 },
	{ 1,30,35,21,44,3,12,23,46,16,37,14,5,18,39,25,32,7,0,27,34,20,41,2,9,22,43,29,36,11,4,31,38,24,45,6,13,26,17,40,15,8,19,42,28,33,10 },
},
{
	/* Frame 170 */
	{ 45,14,43,16,22,9,40,15,38,17,23,12,41,2,39,20,26,13,36,3,34,21,27,0,37,6,35,24,30,1,32,7,46,25,31,4,33,10,28,18,5,44,11,42,29,19,8 },
	{ 37,38,44,15,22,28,4,31,35,41,42,1,26,2,8,17,36,7,13,20,14,23,29,33,34,40,11,18,24,0,27,39,45,46,5,30,6,12,21,43,32,3,9,16,10,19,25 },
	{ 8,38,11,9,39,26,37,24,27,36,25,14,12,34,15,13,35,30,33,28,31,32,29,16,46,2,44,17,3,45,1,18,0,19,20,42,6,40,21,43,7,41,5,22,4,23,10 },
	{ 5,26,38,37,11,18,8,43,3,29,0,35,21,14,44,27,6,24,36,19,9,16,42,41,1,30,34,33,15,22,12,7,25,4,39,17,10,40,31,2,28,32,23,13,20,46,45 },
	{ 7,1,5,2,6,0,4,19,23,17,21,18,22,16,20,35,45,33,34,44,32,46,9,13,26,30,8,12,27,31,25,29,11,15,24,28,10,14,41,39,37,40,38,36,43,42,3 },
	{ 33,35,32,34,25,1,27,3,24,0,26,2,41,43,40,42,21,9,23,11,20,8,22,10,37,39,36,38,29,5,31,7,28,4,30,6,45,44,46,17,13,19,15,16,12,18,14 },
	{ 12,0,5,40,38,33,31,2,7,35,13,16,4,41,32,18,6,11,34,17,20,24,46,19,22,10,15,43,21,25,28,23,26,14,44,42,37,8,29,1,39,27,30,3,45,36,9 },
	{ 27,42,28,37,2,9,30,39,21,32,11,12,23,34,16,41,14,1,18,43,29,44,3,4,31,46,24,33,6,13,26,35,17,36,15,8,19,38,20,45,10,5,22,25,40,7,0 },
	{ 34,0,26,7,29,5,40,11,18,45,21,31,32,3,24,39,37,14,23,43,9,16,27,6,12,35,1,10,19,46,28,4,41,2,25,38,44,20,30,33,42,8,17,36,15,22,13 },
	{ 34,18,43,27,6,15,39,23,32,16,41,25,4,13,37,21,44,2,11,35,19,46,30,7,0,9,33,17,40,28,5,12,42,26,3,14,38,22,31,24,1,8,36,20,45,29,10 },
	{ 18,0,38,27,9,14,43,20,7,34,29,10,45,16,3,36,25,30,12,41,23,5,32,39,26,8,46,19,1,6,35,28,15,42,21,2,37,24,11,44,17,22,4,33,31,13,40 },
	{ 10,46,1,37,26,17,11,0,36,27,20,14,34,5,41,30,21,15,35,4,40,31,24,2,38,9,45,18,25,3,39,8,44,19,28,6,42,13,33,22,29,7,43,12,32,23,16 },
},
{
	/* Frame 171 */
	{ 44,28,31,4,7,37,21,42,26,9,2,32,16,35,19,12,15,45,29,38,22,5,10,40,24,43,27,0,3,33,17,46,30,13,6,36,20,39,23,8,11,41,25,34,18,1,14 },
	{ 38,25,10,18,4,27,40,21,7,24,42,35,36,26,13,41,20,1,6,15,43,23,34,37,12,0,29,14,17,22,3,31,44,32,28,9,46,16,39,2,30,11,45,19,5,33,8 },
	{ 10,30,9,29,42,41,11,31,8,28,43,44,14,26,13,25,46,45,15,27,12,24,32,2,22,1,21,34,33,3,23,0,20,35,36,6,18,5,17,38,37,7,19,4,16,39,40 },
	{ 23,31,22,30,21,29,20,28,37,45,7,15,36,44,6,14,5,13,38,46,4,12,39,19,27,18,26,17,25,16,24,33,41,3,11,32,40,2,10,1,9,34,42,0,8,35,43 },
	{ 44,9,10,12,15,29,17,3,36,20,23,33,4,34,8,11,25,31,41,28,42,16,19,37,0,38,22,5,35,6,27,45,24,46,30,40,13,43,14,18,1,39,2,21,7,32,26 },
	{ 5,29,3,27,36,34,4,28,2,26,37,35,17,13,23,11,44,42,16,12,22,10,45,43,1,25,7,31,32,38,0,24,6,30,33,39,21,9,19,15,40,46,20,8,18,14,41 },
	{ 30,18,12,1,15,3,28,17,31,19,13,0,14,2,29,33,37,35,39,32,36,34,38,26,20,8,22,11,5,24,7,27,21,9,23,10,4,25,6,40,44,43,41,45,42,46,16 },
	{ 35,33,31,3,29,1,34,32,30,2,28,0,43,41,19,11,17,9,42,40,18,10,16,8,39,37,27,7,25,5,38,36,26,6,24,4,45,23,15,21,13,46,44,22,14,20,12 },
	{ 6,10,4,24,7,11,5,8,22,26,20,9,23,27,21,42,46,43,40,44,41,45,2,29,0,14,3,28,1,15,18,12,16,30,19,13,17,31,34,38,32,36,35,39,33,37,25 },
	{ 13,2,25,36,22,0,7,20,45,19,42,5,14,17,40,26,39,12,11,24,37,31,34,9,6,29,32,18,43,4,3,16,41,23,46,1,10,21,44,30,35,8,15,28,33,27,38 },
	{ 44,37,32,13,8,20,1,29,39,34,46,27,22,3,15,10,45,40,33,9,21,16,28,25,4,35,42,23,18,30,11,6,41,36,17,12,24,5,0,43,38,19,31,26,7,2,14 },
	{ 25,31,36,1,34,7,24,30,41,0,39,6,21,27,40,13,38,3,20,26,45,12,43,2,17,23,44,9,42,15,16,22,33,8,14,29,19,32,5,46,11,28,18,37,4,35,10 },
},
{
	/* Frame 172 */
	{ 46,4,44,22,20,7,5,45,23,21,14,38,12,36,30,28,15,39,13,37,31,29,2,42,0,40,18,16,3,43,1,41,19,17,10,34,8,32,26,24,11,35,9,33,27,25,6 },
	{ 19,17,41,32,10,34,8,23,29,20,5,14,38,44,37,26,24,33,11,2,9,0,43,21,30,15,6,12,36,27,18,25,16,3,40,1,42,35,31,22,28,7,13,4,46,39,45 },
	{ 2,38,17,3,39,1,37,18,0,36,19,20,6,34,21,7,35,5,33,22,4,32,23,26,24,27,25,11,9,45,10,46,8,44,30,28,31,29,15,43,13,41,14,42,12,40,16 },
	{ 23,27,21,25,22,26,20,24,7,11,5,9,6,10,4,8,38,42,36,40,39,43,37,41,19,31,17,29,18,30,16,28,3,15,1,13,2,14,0,12,34,46,32,44,35,33,45 },
	{ 18,17,19,1,33,3,35,0,32,2,34,20,22,44,21,23,45,5,7,4,46,6,26,8,40,27,9,41,11,43,24,10,42,25,30,12,31,13,15,37,28,39,14,36,29,38,16 },
	{ 38,32,30,6,24,0,39,33,31,7,25,1,46,40,18,14,20,8,41,19,15,21,9,34,36,26,2,28,4,35,37,27,3,29,5,42,44,22,10,16,12,43,45,23,11,17,13 },
	{ 13,27,21,18,12,26,20,2,29,10,4,3,28,11,5,34,38,42,46,35,39,43,9,23,17,31,8,22,16,30,25,6,0,14,24,7,1,15,41,45,40,44,32,36,33,37,19 },
	{ 31,38,28,45,14,1,26,43,21,40,7,4,19,46,16,33,2,9,22,39,29,36,15,12,27,34,24,41,10,5,30,17,44,3,0,23,42,20,37,6,13,18,35,25,32,11,8 },
	{ 34,4,42,28,35,5,43,12,20,13,21,25,36,0,24,37,1,44,8,16,45,9,17,6,14,32,7,15,33,22,40,30,23,41,31,38,2,46,10,39,3,11,18,26,19,27,29 },
	{ 24,40,27,43,12,15,29,45,18,34,1,6,20,36,23,39,8,11,25,41,30,46,13,2,16,32,19,35,4,7,21,37,26,42,9,14,28,44,31,0,3,17,33,22,38,5,10 },
	{ 25,27,42,12,40,14,21,16,23,18,1,38,3,36,33,28,30,43,13,8,15,10,45,17,19,39,34,4,32,6,29,24,31,26,9,46,11,44,41,20,22,35,5,0,7,2,37 },
	{ 38,18,0,6,33,21,35,23,9,11,44,28,42,30,12,2,37,17,39,19,5,7,32,24,46,26,8,14,41,29,43,31,1,3,36,20,34,22,4,10,45,25,27,13,15,40,16 },
},
{
	/* Frame 173 */
	{ 3,14,25,6,32,28,45,27,5,34,42,7,16,33,29,8,26,36,18,35,31,43,38,17,46,9,20,37,19,12,30,11,22,39,40,21,0,13,10,23,2,15,24,41,1,44,4 },
	{ 40,7,44,16,42,20,33,46,18,37,22,35,0,39,27,4,31,2,9,6,13,17,11,21,32,15,36,24,34,28,41,38,26,45,30,43,8,19,12,23,10,1,14,5,25,3,29 },
	{ 24,40,27,43,12,15,21,45,18,34,1,6,28,36,31,39,8,11,25,41,22,46,13,2,16,32,19,35,4,7,29,37,26,42,9,14,20,44,23,0,3,17,33,30,38,5,10 },
	{ 6,4,29,15,18,45,16,27,32,34,1,10,8,21,7,30,37,28,39,19,44,46,13,2,0,25,11,22,41,20,43,31,36,38,5,14,12,17,3,26,33,24,35,23,40,42,9 },
	{ 44,24,37,17,40,20,33,13,10,3,6,30,43,23,8,1,45,25,4,28,41,21,27,38,18,11,34,14,7,36,16,9,32,12,5,29,2,46,26,39,19,31,42,22,35,15,0 },
	{ 3,32,12,46,4,25,38,10,17,41,2,31,33,23,24,39,16,9,30,1,22,15,44,7,36,8,42,0,29,34,14,21,45,6,27,37,19,43,28,35,20,13,26,5,18,11,40 },
	{ 33,13,37,27,31,42,24,46,28,41,11,45,2,15,6,8,0,12,4,26,19,30,43,23,34,17,38,40,21,32,44,3,36,7,1,25,5,29,18,10,22,35,14,16,39,9,20 },
	{ 23,10,17,12,35,37,26,11,20,13,34,36,27,6,21,8,33,30,7,24,9,46,32,31,2,25,4,43,45,18,3,28,5,42,44,19,14,29,0,39,41,22,15,16,1,38,40 },
	{ 10,17,34,15,20,6,9,3,12,30,5,41,27,0,44,22,37,29,19,42,32,24,35,14,21,38,11,16,2,13,7,8,26,1,45,31,4,40,18,43,33,25,23,46,36,28,39 },
	{ 28,38,14,36,12,31,29,39,15,37,13,30,20,6,42,4,40,23,21,7,43,5,41,22,26,24,34,10,32,8,27,25,35,11,33,9,18,46,16,44,2,0,19,17,45,3,1 },
	{ 34,31,24,29,36,7,0,20,35,44,46,8,28,10,37,1,4,19,45,32,9,12,11,14,40,42,5,18,23,33,13,26,15,41,38,43,2,22,17,27,30,25,39,3,6,16,21 },
	{ 3,9,46,1,38,26,44,18,43,36,24,35,31,16,41,23,10,33,29,2,21,8,15,0,7,13,42,5,34,30,40,22,32,28,39,27,20,45,19,14,37,25,6,17,12,11,4 },
},
{
	/* Frame 174 */
	{ 6,43,30,13,32,16,38,28,10,45,23,4,8,26,3,36,40,24,14,21,35,19,42,31,12,1,7,11,44,22,33,17,39,29,46,27,2,5,9,15,20,34,18,37,41,25,0 },
	{ 39,41,42,25,5,26,6,8,32,3,13,16,14,19,37,38,40,21,11,22,24,4,27,35,45,46,29,1,30,2,12,43,36,7,9,20,10,23,33,34,44,17,15,18,28,0,31 },
	{ 34,3,33,0,6,5,23,42,11,41,24,14,38,13,37,31,2,1,19,46,21,45,22,10,40,9,27,12,30,29,17,35,18,32,20,44,7,4,8,43,26,25,15,39,28,36,16 },
	{ 33,28,2,31,40,43,18,9,38,4,25,7,45,20,14,23,32,35,30,1,42,8,17,11,37,24,6,27,44,22,13,34,0,29,3,41,16,10,19,36,39,26,5,46,12,21,15 },
	{ 4,8,12,16,20,24,28,1,5,9,13,17,21,25,29,32,40,38,46,33,41,39,27,31,2,6,10,14,18,22,26,30,3,7,11,15,19,23,36,34,44,42,37,35,45,43,0 },
	{ 5,26,21,12,34,28,41,11,36,27,6,13,22,35,29,0,42,16,37,7,44,23,14,1,30,43,17,8,38,24,45,15,32,31,2,9,18,39,25,4,46,20,33,3,40,19,10 },
	{ 40,14,43,44,2,6,35,26,39,41,30,42,45,18,46,1,22,34,5,27,38,24,31,28,19,0,23,4,33,25,37,29,16,20,32,8,36,11,12,15,17,3,21,7,9,10,13 },
	{ 3,0,22,38,17,37,6,9,31,43,28,44,15,12,26,34,21,33,2,5,19,39,16,40,11,8,30,46,25,45,14,1,23,35,20,36,7,4,18,42,29,41,10,13,27,24,32 },
	{ 22,25,33,46,19,28,36,10,35,17,15,38,20,2,13,7,8,26,45,5,31,40,0,18,29,37,42,23,24,32,14,39,21,11,34,16,6,9,3,12,30,41,1,27,44,4,43 },
	{ 41,8,37,4,19,46,15,38,9,32,5,18,43,14,39,6,33,0,29,42,11,34,7,1,28,10,35,2,31,25,21,44,3,30,24,20,45,12,27,23,17,40,13,36,26,22,16 },
	{ 16,7,40,45,19,30,5,10,46,17,28,8,44,35,31,11,14,33,29,26,9,12,34,39,24,15,32,37,27,22,13,2,38,25,20,0,36,43,23,3,6,41,21,18,1,4,42 },
	{ 4,44,3,43,20,19,5,45,2,42,21,30,36,8,35,15,24,31,37,9,34,14,25,22,0,40,7,16,23,1,41,6,46,17,26,32,12,39,11,28,27,33,13,38,10,29,18 },
},
{
	/* Frame 175 */
	{ 24,9,43,0,19,34,33,45,31,46,28,36,22,7,21,4,8,27,42,41,18,3,17,32,44,30,15,29,12,6,5,39,26,11,25,40,2,16,1,35,14,13,37,23,38,20,10 },
	{ 44,42,18,46,22,9,13,11,35,15,39,8,1,12,25,5,10,29,34,14,27,38,31,0,24,4,17,28,3,21,26,7,30,32,41,36,16,45,2,20,43,6,19,33,23,40,37 },
	{ 26,34,0,6,21,37,23,39,9,11,16,44,30,46,12,2,25,33,27,35,5,7,20,40,18,42,8,14,29,45,31,1,3,24,36,22,38,4,10,17,41,19,43,13,15,28,32 },
	{ 23,7,36,22,6,37,38,20,4,39,21,5,31,15,44,30,14,45,46,28,12,29,13,19,3,32,18,2,33,34,16,0,35,17,1,27,11,40,26,10,41,42,24,8,43,25,9 },
	{ 10,3,31,34,22,15,45,25,36,16,13,4,40,28,33,27,38,18,11,6,42,30,35,9,0,44,24,37,21,12,5,2,46,26,39,23,14,7,43,17,8,1,41,29,32,20,19 },
	{ 36,24,35,15,16,41,7,33,13,10,5,2,8,27,0,19,42,25,34,30,17,40,22,32,28,39,11,20,45,3,37,9,14,1,6,12,31,4,23,46,29,38,26,21,44,18,43 },
	{ 22,40,15,33,7,31,23,41,14,32,6,26,18,11,39,3,27,19,46,10,38,2,20,12,5,43,28,35,21,13,4,42,29,34,16,44,8,37,1,24,17,45,9,36,0,25,30 },
	{ 31,6,17,8,33,18,7,20,9,46,32,19,10,21,12,35,37,22,11,24,13,34,36,23,14,25,0,39,41,26,15,28,1,38,40,27,2,29,4,43,45,30,3,16,5,42,44 },
	{ 6,33,45,11,7,32,44,42,38,0,12,43,39,1,13,26,30,27,31,16,20,17,21,2,14,41,37,3,15,40,36,34,46,8,4,35,9,5,18,22,19,23,24,28,25,29,10 },
	{ 18,10,44,43,20,12,19,11,45,42,21,13,30,2,36,35,24,4,31,3,37,34,25,5,22,14,40,16,8,23,15,41,46,17,9,26,6,32,39,28,0,27,7,33,38,29,1 },
	{ 41,40,39,43,37,38,42,36,19,23,17,21,18,22,16,20,3,7,1,5,2,6,0,4,45,44,35,33,34,32,46,9,13,27,31,8,12,26,30,24,28,11,15,25,29,10,14 },
	{ 23,28,42,3,8,33,27,22,15,2,41,32,26,21,14,39,40,1,25,20,38,13,0,19,24,46,7,12,37,31,18,11,6,45,36,30,17,10,35,44,5,29,16,43,34,9,4 },
},
{
	/* Frame 176 */
	{ 26,0,24,3,27,1,25,34,32,35,33,10,18,8,16,11,19,9,17,42,40,43,41,36,6,30,37,7,31,5,29,38,4,28,39,44,14,22,45,15,23,13,21,46,12,20,2 },
	{ 19,17,29,32,44,34,14,27,25,22,37,40,7,42,4,30,33,45,2,15,0,12,23,20,41,38,10,5,8,18,31,16,28,3,46,1,13,35,26,21,24,39,11,36,9,6,43 },
	{ 34,25,33,10,28,15,45,12,17,18,42,20,38,7,37,4,24,11,8,31,13,46,16,3,43,0,40,6,5,23,27,35,9,32,30,29,14,44,2,1,41,19,21,39,22,36,26 },
	{ 32,34,33,35,20,0,22,2,21,1,23,3,40,42,41,43,28,8,30,10,29,9,31,11,36,38,37,39,16,4,18,6,17,5,19,7,44,46,45,24,12,26,14,25,13,27,15 },
	{ 27,2,34,10,42,18,26,3,35,11,43,23,45,31,6,14,36,22,44,30,7,15,37,9,41,17,25,0,32,8,40,16,24,1,33,13,21,29,38,4,46,12,20,28,39,5,19 },
	{ 30,35,25,44,11,0,27,46,16,41,2,5,18,43,21,32,7,8,23,34,24,37,10,13,26,39,29,40,15,4,31,42,20,45,6,1,22,17,36,3,12,19,38,28,33,14,9 },
	{ 41,21,22,40,20,6,4,42,7,5,43,19,17,18,16,38,2,36,0,39,3,37,1,13,31,12,30,29,34,14,32,28,35,15,33,45,9,27,44,8,26,25,46,10,24,11,23 },
	{ 15,4,30,42,17,33,10,13,23,39,28,40,3,8,18,46,21,37,14,1,27,43,16,44,7,12,22,34,25,41,2,5,31,20,32,11,0,26,38,29,45,6,9,19,35,24,36 },
	{ 26,37,7,27,36,38,4,24,39,5,25,22,2,33,23,3,32,34,20,0,35,21,1,14,18,45,15,19,44,46,12,16,13,17,30,10,41,31,11,40,42,28,8,43,29,9,6 },
	{ 35,21,4,26,11,45,34,16,5,23,10,44,17,0,22,7,41,46,28,1,19,6,40,43,29,12,18,3,37,42,24,13,31,2,36,39,25,8,30,15,33,38,20,9,27,14,32 },
	{ 17,29,16,28,27,23,26,22,35,39,9,13,34,38,8,12,3,7,40,44,2,6,41,45,25,21,24,20,19,31,18,30,43,1,5,42,46,0,4,11,15,32,36,10,14,33,37 },
	{ 40,16,2,32,11,9,7,5,46,12,31,38,29,0,43,19,41,17,26,35,24,33,10,22,44,20,6,36,15,13,3,1,42,8,27,34,25,4,23,45,21,30,39,28,37,14,18 },
},
{
	/* Frame 177 */
	{ 41,24,6,12,42,27,32,21,15,9,35,18,45,28,10,0,46,31,36,25,3,13,39,22,33,16,14,4,34,19,40,29,7,1,43,26,37,20,2,8,38,23,44,17,11,5,30 },
	{ 28,18,45,4,35,10,29,19,32,5,38,11,16,22,33,8,39,14,17,23,36,9,42,15,20,26,37,12,43,2,21,27,40,13,46,3,24,30,41,0,6,25,31,44,1,34,7 },
	{ 33,10,22,0,28,42,32,11,23,1,29,39,45,26,6,16,12,38,44,27,7,17,13,35,41,2,30,8,20,34,40,3,31,9,21,37,18,14,24,4,46,36,19,15,25,5,43 },
	{ 4,45,32,31,18,8,21,34,44,30,7,25,20,46,35,11,6,24,1,37,10,23,13,0,41,36,27,22,12,17,38,40,26,3,29,16,42,39,15,2,28,5,43,33,14,19,9 },
	{ 27,20,40,1,15,35,4,24,38,43,30,19,45,32,46,8,22,3,29,16,6,11,37,13,0,14,34,26,21,41,42,31,18,44,5,25,39,2,28,33,9,23,10,36,12,17,7 },
	{ 2,37,16,11,44,25,14,35,20,7,42,29,26,0,38,19,9,30,12,33,23,5,40,10,45,24,3,36,17,6,43,28,15,34,21,39,18,8,46,27,1,22,4,41,31,13,32 },
	{ 42,13,11,0,6,32,8,14,21,40,19,37,25,35,31,16,45,22,43,28,38,26,1,7,46,9,15,4,2,36,12,10,17,44,23,33,29,39,27,20,41,18,24,34,30,5,3 },
	{ 8,44,10,25,27,9,45,11,46,24,26,32,0,34,2,17,19,33,1,35,3,16,18,40,31,42,12,15,29,41,30,43,13,14,28,23,36,4,39,7,21,22,37,5,38,6,20 },
	{ 39,38,40,42,36,41,43,37,15,7,28,20,14,6,29,21,30,22,12,4,31,23,13,5,46,32,44,34,33,45,35,24,16,26,18,25,17,27,19,8,0,10,2,9,1,11,3 },
	{ 29,39,3,10,33,21,38,24,2,45,32,31,16,25,35,44,23,30,26,17,34,13,22,41,18,27,46,5,12,40,19,15,4,43,9,7,14,37,42,1,8,28,6,36,11,0,20 },
	{ 36,16,29,34,7,46,27,17,28,6,39,18,30,21,9,38,19,31,20,8,41,13,22,11,1,40,12,45,23,10,43,0,33,5,44,24,3,42,15,32,4,37,25,2,35,14,26 },
	{ 38,17,28,40,20,37,19,45,15,42,22,39,0,29,21,2,44,26,43,23,1,46,9,4,3,27,6,30,8,5,32,13,10,7,34,31,24,16,33,12,41,11,36,18,35,14,25 },
},
{
	/* Frame 178 */
	{ 12,45,3,42,20,27,13,40,2,39,21,30,0,41,7,38,24,31,1,36,6,35,25,18,4,37,11,34,28,19,5,32,10,29,22,8,33,15,46,16,23,9,44,14,43,17,26 },
	{ 22,20,42,6,40,4,23,21,43,7,41,5,30,28,38,14,36,12,31,29,39,15,37,13,18,16,46,2,44,0,19,17,3,45,1,26,24,34,10,32,8,27,25,35,11,33,9 },
	{ 25,38,16,24,39,0,46,8,1,9,31,6,30,7,32,14,40,22,33,15,41,23,27,2,26,3,10,36,18,44,11,37,19,45,21,34,29,20,35,28,42,4,12,43,5,13,17 },
	{ 39,11,2,25,16,32,10,19,24,5,40,33,27,18,13,4,34,41,26,7,12,21,42,35,15,6,29,20,43,36,14,23,28,1,44,37,31,22,9,0,38,45,30,3,8,17,46 },
	{ 34,15,44,25,46,23,37,0,35,31,45,8,10,6,20,1,18,30,32,28,9,11,7,40,21,42,38,19,33,29,27,41,4,43,39,2,16,12,14,26,24,5,22,3,36,17,13 },
	{ 21,33,19,39,28,40,26,46,1,7,8,14,25,45,23,35,16,36,30,42,13,3,4,10,29,41,27,20,32,18,38,9,15,0,6,17,37,31,43,24,44,22,34,5,11,12,2 },
	{ 9,11,41,39,4,6,17,12,19,14,29,34,31,32,42,20,40,22,5,24,7,26,37,13,15,45,35,0,2,43,21,8,23,10,25,38,27,36,46,16,44,18,1,28,3,30,33 },
	{ 30,4,33,6,42,27,0,3,15,45,28,22,10,41,24,36,19,38,31,13,32,7,35,20,9,2,16,44,29,46,23,5,40,25,43,26,39,1,12,14,34,21,8,11,17,37,18 },
	{ 7,18,6,19,22,40,2,44,23,41,3,45,24,28,25,29,32,8,36,12,33,9,37,13,16,20,17,46,21,0,4,42,1,5,43,39,15,26,38,14,27,30,34,10,31,35,11 },
	{ 12,26,30,24,28,11,15,9,13,27,31,25,29,10,14,40,38,36,43,41,39,37,42,2,6,0,4,18,22,16,20,3,7,1,5,19,23,17,21,34,44,32,35,45,33,46,8 },
	{ 34,9,20,7,30,45,35,8,25,6,23,36,46,1,24,11,22,37,0,17,10,27,40,38,13,16,3,26,41,39,12,29,2,19,32,42,5,28,15,18,33,43,4,21,14,31,44 },
	{ 11,18,10,2,44,27,36,3,45,26,37,23,15,43,22,14,42,6,34,31,7,35,30,25,17,24,16,46,8,38,0,9,39,1,29,21,28,20,12,40,4,32,13,41,5,33,19 },
},
{
	/* Frame 179 */
	{ 38,30,12,6,41,21,43,23,9,11,32,16,46,18,0,14,37,29,39,31,5,7,40,24,34,26,8,2,45,17,19,13,15,36,20,42,22,4,10,33,25,35,27,1,3,44,28 },
	{ 28,7,16,42,45,27,33,19,38,10,13,1,40,20,46,25,2,31,37,23,8,14,35,5,44,26,32,29,6,17,43,12,0,18,39,11,24,3,30,36,41,21,34,4,22,9,15 },
	{ 10,30,0,20,42,32,11,31,1,21,43,37,26,14,16,4,46,36,27,15,17,5,41,2,22,8,28,34,40,3,23,9,29,35,45,18,6,24,12,38,44,19,7,25,13,39,33 },
	{ 31,17,40,7,46,28,10,4,45,22,25,39,15,1,19,36,12,34,30,16,6,33,9,27,21,44,3,42,24,14,0,41,18,29,35,11,5,23,32,8,38,26,20,2,43,37,13 },
	{ 45,6,0,28,11,34,23,46,17,12,37,26,25,4,40,3,15,38,9,32,21,18,43,30,29,10,44,7,1,13,36,27,35,22,16,41,2,14,24,5,19,42,31,39,8,33,20 },
	{ 20,1,14,27,40,39,13,0,31,26,36,41,12,25,30,11,37,34,29,24,7,10,46,35,28,9,6,19,32,5,8,23,18,44,33,4,17,22,3,45,42,21,16,15,2,38,43 },
	{ 10,35,46,17,24,6,31,44,34,16,9,23,30,32,45,5,8,22,15,33,43,4,29,3,14,39,42,21,28,2,27,40,38,20,13,19,26,36,41,1,12,18,11,37,0,25,7 },
	{ 0,42,4,17,21,1,43,5,46,16,20,32,8,36,12,25,29,33,9,37,13,24,28,40,23,44,2,7,19,41,22,45,3,6,18,31,34,10,39,15,27,30,35,11,38,14,26 },
	{ 27,28,35,46,0,23,40,31,11,45,4,17,38,15,33,3,21,8,7,18,36,42,12,25,1,22,41,26,29,34,5,16,39,30,10,44,20,9,14,32,2,37,43,13,24,6,19 },
	{ 45,1,8,23,26,37,46,0,29,22,11,38,17,28,3,10,40,39,16,13,2,31,32,41,5,12,19,30,33,42,4,25,18,15,34,43,21,24,7,14,44,35,20,9,6,27,36 },
	{ 23,39,19,35,14,10,30,20,36,17,33,5,8,29,45,6,2,22,46,26,42,15,11,0,21,37,24,40,12,9,38,18,34,7,3,31,27,43,16,32,4,1,28,44,25,41,13 },
	{ 36,26,34,13,17,23,10,28,1,44,7,42,20,38,9,33,31,19,4,41,24,15,3,46,16,22,37,27,35,12,0,45,6,11,29,32,30,18,43,21,39,8,14,2,5,40,25 },
},
{
	/* Frame 180 */
	{ 6,34,5,33,22,21,7,35,4,32,23,28,14,46,13,45,30,29,15,12,44,31,16,2,38,1,37,18,17,3,39,0,36,19,24,10,42,9,41,26,25,11,43,8,40,27,20 },
	{ 1,34,0,35,30,32,28,2,31,33,29,3,17,9,42,16,8,43,40,18,10,41,19,11,25,38,36,24,39,37,6,26,4,7,27,5,46,44,45,22,14,20,12,23,15,21,13 },
	{ 46,2,38,11,3,39,26,18,27,19,42,14,34,6,43,15,35,7,30,22,31,23,17,8,44,16,9,45,0,36,24,1,37,25,21,40,12,20,41,13,32,4,28,33,5,29,10 },
	{ 25,14,5,40,22,12,39,11,20,19,37,9,34,26,17,6,43,32,24,31,4,41,3,46,29,10,1,44,18,8,35,15,16,23,33,13,38,30,21,2,36,28,27,0,45,7,42 },
	{ 28,34,27,25,40,5,42,18,0,13,35,26,24,21,43,6,1,36,12,14,9,20,7,17,37,2,15,32,8,45,10,23,16,3,38,31,33,29,44,11,46,22,41,4,19,39,30 },
	{ 34,44,31,10,17,4,35,45,18,11,20,5,46,40,19,6,21,0,41,22,7,24,1,42,36,23,2,25,12,43,37,26,3,28,13,38,32,27,14,29,8,39,33,30,15,16,9 },
	{ 8,18,32,13,23,4,10,1,15,28,6,42,25,3,20,45,38,30,17,40,35,27,33,12,22,36,9,19,0,14,5,11,24,2,46,29,7,43,16,41,34,26,21,44,39,31,37 },
	{ 22,10,33,14,44,21,8,13,7,43,18,30,4,41,16,34,29,38,23,3,32,15,37,26,1,12,24,42,19,46,31,11,40,17,45,20,39,9,2,6,36,27,0,5,25,35,28 },
	{ 11,5,39,17,30,44,33,20,9,14,2,24,7,42,36,19,12,1,35,22,26,40,29,16,31,45,10,4,38,15,3,32,21,8,43,37,18,13,25,6,27,41,28,0,46,34,23 },
	{ 12,2,6,40,44,34,38,9,13,3,7,41,45,35,39,24,20,18,30,25,21,19,31,0,4,10,14,32,36,42,46,1,5,11,15,33,37,43,16,28,26,22,17,29,27,23,8 },
	{ 22,4,7,44,28,31,13,2,33,17,34,26,8,11,36,20,39,23,5,14,45,29,46,18,0,3,40,24,43,27,9,6,37,21,38,30,12,15,32,16,35,19,1,10,41,25,42 },
	{ 16,44,3,21,6,5,24,27,39,29,14,34,13,33,17,2,1,22,42,4,41,25,10,38,9,37,15,12,32,30,18,46,0,45,23,43,20,40,7,11,8,36,26,28,31,35,19 },
},
{
	/* Frame 181 */
	{ 19,35,14,38,16,1,24,45,21,37,18,3,42,23,39,0,25,8,20,5,28,2,27,43,22,7,46,9,4,29,12,26,11,6,31,40,32,13,10,34,30,15,41,17,33,44,36 },
	{ 38,7,24,30,33,0,43,6,25,31,36,1,42,11,28,18,37,4,10,29,19,40,5,46,15,16,22,41,8,35,14,17,23,44,9,34,3,20,26,45,12,39,2,21,27,32,13 },
	{ 37,0,46,11,5,22,17,39,2,12,40,7,24,19,21,33,14,42,36,1,26,28,23,35,45,8,38,3,13,30,25,10,4,32,15,16,27,29,41,6,34,44,9,18,20,31,43 },
	{ 0,21,15,26,36,43,1,24,14,19,37,34,12,25,7,18,40,35,13,16,6,31,41,46,4,17,11,30,32,5,28,10,23,33,38,8,29,3,22,44,39,9,20,2,27,45,42 },
	{ 24,23,2,13,37,22,17,46,41,12,26,36,16,15,40,39,27,5,19,43,14,9,38,33,4,18,29,42,8,7,32,28,11,35,6,1,10,21,34,45,0,30,25,20,3,44,31 },
	{ 43,21,8,22,37,25,7,26,33,3,28,46,13,16,14,42,9,23,10,36,39,27,4,32,35,29,0,30,45,17,15,18,41,11,20,38,5,24,6,34,1,31,2,44,19,12,40 },
	{ 21,23,8,37,10,39,40,16,18,29,31,34,45,1,3,24,26,4,42,6,9,36,11,17,19,12,33,14,35,44,20,22,25,27,38,41,5,43,7,28,30,0,46,2,13,32,15 },
	{ 16,28,37,27,41,6,17,29,26,44,7,14,24,4,45,2,15,25,5,34,3,10,22,0,35,12,42,11,23,32,1,38,13,43,20,18,33,31,39,8,46,21,19,36,30,40,9 },
	{ 30,18,24,20,31,19,25,21,42,34,44,36,43,35,45,37,10,2,12,4,11,3,13,5,26,22,28,16,27,23,29,17,46,38,40,32,39,41,33,14,6,8,0,15,7,9,1 },
	{ 26,32,31,37,11,16,46,21,1,24,29,9,35,44,6,19,14,27,33,4,42,17,20,12,38,25,28,22,40,2,45,7,30,36,10,15,0,5,43,8,34,13,39,18,23,41,3 },
	{ 7,28,30,19,8,11,32,23,35,5,15,45,2,39,16,42,27,6,21,46,31,13,1,37,10,41,24,34,4,14,44,29,38,17,18,9,20,33,22,12,0,36,3,40,25,43,26 },
	{ 40,19,14,43,17,37,12,41,2,30,26,0,46,20,13,24,3,44,7,31,34,27,1,21,32,25,45,6,35,10,39,4,33,8,28,22,18,11,38,15,5,42,16,9,36,29,23 },
},
{
	/* Frame 182 */
	{ 27,38,23,43,16,13,1,7,10,45,25,36,21,8,19,30,35,5,40,28,14,2,42,17,12,33,26,39,22,11,44,24,0,6,46,31,34,37,20,9,18,15,3,4,41,29,32 },
	{ 41,1,18,16,42,2,40,0,19,17,43,3,37,9,26,24,38,10,36,8,27,25,39,11,45,5,22,20,46,6,44,4,23,21,7,33,13,30,28,34,14,32,12,31,29,35,15 },
	{ 29,24,4,1,13,32,41,31,26,7,18,15,35,36,43,45,25,20,0,12,9,39,40,27,6,3,14,11,23,34,42,44,21,16,28,8,5,38,46,33,2,30,10,22,19,37,17 },
	{ 29,6,23,40,34,13,20,7,26,41,35,4,21,10,27,32,46,5,24,11,18,33,8,25,2,19,44,38,9,16,3,30,45,39,0,17,14,31,36,42,1,28,15,22,37,43,12 },
	{ 7,46,26,34,5,43,44,24,32,22,41,10,39,19,20,29,8,37,17,6,15,27,3,4,42,13,1,40,30,38,18,28,35,36,16,45,25,14,33,23,2,11,12,21,0,9,31 },
	{ 20,9,43,12,19,46,45,30,3,29,32,6,24,5,39,8,23,42,41,18,15,17,44,2,28,1,35,4,27,38,37,22,11,21,40,14,16,13,0,31,34,33,26,7,25,36,10 },
	{ 17,23,43,38,12,32,10,25,20,31,18,5,46,3,40,37,28,26,39,13,0,11,6,45,21,19,34,8,36,14,29,16,27,22,1,42,7,44,33,24,30,35,9,4,15,2,41 },
	{ 11,38,18,46,30,6,14,45,25,0,13,33,21,40,28,26,2,10,35,23,43,31,9,37,17,44,24,5,12,32,20,39,19,27,7,15,34,22,42,1,8,36,16,41,29,4,3 },
	{ 38,36,39,37,6,26,4,24,7,27,5,25,42,40,43,41,18,10,16,8,19,11,17,9,34,32,35,33,2,30,0,28,3,31,1,29,46,44,45,22,14,20,12,23,15,21,13 },
	{ 7,17,4,35,45,32,30,9,29,37,22,1,21,46,24,13,10,41,38,16,5,2,44,33,8,28,27,14,42,20,19,6,34,12,11,31,40,39,36,3,23,0,26,15,25,43,18 },
	{ 7,8,31,46,16,37,10,13,18,39,21,32,15,4,23,34,28,45,6,1,30,25,40,3,12,27,42,20,33,14,9,22,35,17,36,11,0,19,38,24,41,2,5,26,43,29,44 },
	{ 5,16,4,0,46,21,42,1,20,43,25,37,13,24,36,12,32,8,29,33,9,28,23,19,45,22,18,44,6,40,2,7,41,3,31,27,30,26,38,14,34,10,39,15,35,11,17 },
},
{
	/* Frame 183 */
	{ 41,19,10,16,32,3,0,45,23,46,20,36,7,27,4,24,40,11,17,8,35,31,1,28,44,22,15,21,12,6,5,25,39,43,9,18,34,30,33,29,2,14,13,37,38,26,42 },
	{ 13,16,32,6,10,19,44,0,24,39,30,43,3,20,36,8,14,23,34,27,4,28,41,7,11,12,17,33,25,38,31,42,18,45,1,9,15,2,21,37,29,40,46,22,35,26,5 },
	{ 6,42,44,1,39,26,20,31,37,8,46,3,5,22,25,10,12,32,7,43,16,27,21,41,14,34,36,9,18,28,23,45,0,38,11,13,30,17,2,4,40,15,35,24,19,29,33 },
	{ 21,36,10,12,22,39,16,41,15,5,19,34,29,44,6,0,30,24,37,3,13,27,42,17,32,14,8,18,35,20,45,11,1,23,38,25,40,2,4,26,43,28,33,7,9,31,46 },
	{ 46,5,34,24,30,41,18,33,4,39,25,31,44,19,32,11,38,28,16,45,22,37,10,29,17,23,36,15,3,20,8,43,14,2,21,9,42,1,7,26,12,0,35,6,27,40,13 },
	{ 8,3,21,14,36,25,10,28,32,23,45,16,38,27,13,41,30,34,9,18,4,15,43,0,11,29,6,44,17,2,20,40,31,37,24,46,19,5,33,22,42,1,39,26,12,7,35 },
	{ 22,37,25,0,10,3,46,39,24,17,27,2,40,38,13,16,26,19,41,32,12,5,15,18,33,43,29,4,14,7,42,35,28,21,31,6,44,34,9,20,30,23,45,36,8,1,11 },
	{ 20,18,37,31,35,8,21,19,30,38,9,10,22,0,39,12,11,23,1,40,13,14,24,4,41,2,42,15,25,32,5,44,3,43,16,28,33,27,45,6,46,17,29,36,26,34,7 },
	{ 3,44,17,10,37,24,7,34,29,14,43,20,38,27,1,18,8,23,5,32,30,12,41,11,36,25,2,45,16,15,42,21,6,35,28,46,19,9,39,26,0,31,13,40,22,4,33 },
	{ 42,9,11,4,6,36,12,14,17,44,19,33,29,35,31,20,41,22,43,24,38,26,5,7,46,13,15,0,2,32,8,10,21,40,23,37,25,39,27,16,45,18,28,34,30,1,3 },
	{ 38,16,18,0,36,2,39,17,19,1,37,3,24,26,40,8,42,10,25,27,41,9,43,11,6,20,32,23,34,4,7,21,33,22,35,5,46,14,28,31,44,12,15,29,30,45,13 },
	{ 42,20,8,39,45,19,31,28,4,27,3,46,33,12,40,7,11,17,34,15,22,37,25,1,44,18,30,43,21,9,38,26,2,32,29,5,10,16,13,41,6,36,24,0,35,14,23 },
},
{
	/* Frame 184 */
	{ 32,22,35,33,23,3,21,1,2,20,0,42,40,43,41,11,27,9,25,10,26,8,24,36,6,37,7,5,19,38,17,4,18,39,16,44,14,30,45,15,31,13,29,46,12,28,34 },
	{ 31,7,29,5,30,6,28,4,38,36,39,37,17,15,13,16,14,12,46,18,44,19,45,25,1,34,24,0,35,32,26,2,33,27,3,23,9,21,42,22,8,20,43,40,10,41,11 },
	{ 12,3,4,27,29,34,14,16,7,24,31,44,41,36,33,2,20,26,28,19,46,43,39,17,6,9,30,1,23,40,32,21,11,13,18,5,42,38,35,8,15,0,22,25,45,37,10 },
	{ 23,34,16,45,10,1,18,29,40,3,4,31,42,24,33,6,9,26,35,17,36,11,12,19,38,20,41,14,5,22,43,25,44,7,0,27,46,28,37,2,13,30,39,21,32,15,8 },
	{ 34,20,43,25,44,1,22,27,46,3,4,9,16,37,6,40,15,18,39,21,42,28,45,0,23,30,33,2,11,12,35,17,36,24,41,14,19,38,26,29,5,8,31,32,7,10,13 },
	{ 23,43,28,32,15,4,18,46,21,41,2,13,27,39,16,44,11,0,22,42,25,37,14,9,31,35,20,40,7,12,26,38,29,33,10,5,19,24,36,3,8,30,34,17,45,6,1 },
	{ 16,30,38,40,21,27,35,12,37,22,9,32,19,4,10,1,15,28,42,2,25,7,41,20,26,34,44,17,31,39,8,33,18,13,36,23,0,14,5,11,24,46,6,29,43,3,45 },
	{ 15,44,28,46,26,8,10,39,23,4,3,33,17,34,18,30,12,14,41,25,43,27,7,37,21,38,22,1,2,32,16,45,29,31,9,11,40,24,42,5,6,36,20,35,19,0,13 },
	{ 42,7,29,35,14,20,19,38,1,26,8,31,32,13,22,41,4,3,25,44,10,16,37,34,15,21,43,6,28,27,46,9,18,39,0,23,40,5,30,33,12,11,17,36,2,24,45 },
	{ 7,9,45,19,4,43,14,16,26,38,40,13,31,25,11,33,28,22,8,44,2,21,42,15,1,37,27,12,35,6,24,18,46,32,5,23,17,3,39,41,20,30,0,36,10,29,34 },
	{ 32,18,6,20,0,39,33,19,7,21,1,38,40,30,14,24,8,41,31,15,25,9,46,36,22,2,16,4,35,37,23,3,17,5,34,44,26,10,28,12,43,45,27,11,29,13,42 },
	{ 45,18,46,1,30,32,29,35,22,21,41,27,36,8,39,11,19,0,3,31,12,34,15,23,4,40,7,43,37,24,38,10,16,44,2,13,14,33,28,5,6,42,20,25,26,9,17 },
},
{
	/* Frame 185 */
	{ 43,18,32,29,6,1,34,31,45,20,3,8,22,36,17,10,5,38,19,33,24,7,12,35,26,40,21,14,9,42,23,37,28,11,0,39,30,44,25,2,13,46,27,41,16,15,4 },
	{ 12,19,38,24,41,14,1,26,43,29,32,3,8,31,34,20,37,10,13,22,39,25,44,15,4,27,46,16,33,6,9,18,35,21,40,11,0,23,42,28,45,2,5,30,17,36,7 },
	{ 21,3,31,41,35,8,20,2,30,40,34,13,17,7,27,45,39,12,16,6,26,44,38,1,29,11,23,33,43,0,28,10,22,32,42,5,25,15,19,37,4,24,14,18,36,46,9 },
	{ 2,24,42,7,29,14,0,11,5,18,12,32,23,9,37,30,39,44,16,27,34,41,21,43,6,28,46,3,25,10,4,15,1,22,8,36,19,13,33,26,35,40,20,31,38,45,17 },
	{ 26,31,25,28,10,40,43,46,3,6,0,21,18,39,33,36,30,8,29,11,14,41,44,7,1,4,19,22,16,37,34,9,12,27,15,24,45,42,5,2,23,17,20,35,38,32,13 },
	{ 35,6,28,42,15,21,26,39,8,19,46,1,30,41,12,23,32,5,10,16,45,3,25,36,43,14,20,34,7,29,18,0,27,38,9,22,33,4,31,40,13,2,24,37,11,17,44 },
	{ 7,1,37,19,12,43,14,24,26,38,32,5,31,17,11,41,20,22,0,36,2,29,42,15,9,45,27,4,35,6,16,18,46,40,13,23,25,3,39,33,28,30,8,44,10,21,34 },
	{ 28,8,41,27,15,29,9,46,40,26,14,16,0,39,33,23,7,17,1,38,32,22,6,24,12,43,45,31,11,25,13,42,44,30,10,20,4,35,37,19,3,21,5,34,36,18,2 },
	{ 46,45,3,24,17,43,7,29,4,32,44,8,16,27,28,21,31,33,9,0,26,19,40,20,30,23,34,1,10,18,41,38,37,14,22,13,35,11,2,25,39,42,36,15,6,12,5 },
	{ 25,33,26,2,16,12,15,22,5,8,11,46,1,36,31,39,42,21,32,27,35,17,45,18,14,28,4,41,7,10,24,0,3,30,38,13,23,34,9,44,19,29,37,40,6,43,20 },
	{ 42,19,31,32,45,8,21,16,30,27,44,41,17,28,26,7,40,29,24,6,3,15,25,5,39,2,14,11,4,1,38,35,10,22,37,0,13,34,46,43,23,18,36,33,12,9,20 },
	{ 9,22,35,29,44,11,4,31,46,24,37,6,13,26,39,17,32,15,8,19,34,28,41,10,1,30,43,21,36,3,12,23,38,16,45,14,5,18,25,40,7,0,27,42,20,33,2 },
},
{
	/* Frame 186 */
	{ 33,6,24,30,1,44,7,42,25,31,4,45,10,43,28,18,5,40,11,38,29,19,8,41,14,39,16,22,9,36,15,34,17,23,12,37,2,35,20,26,13,32,3,46,21,27,0 },
	{ 6,21,37,30,46,12,15,16,32,19,35,1,10,25,41,22,38,4,7,28,44,31,13,2,17,33,26,42,8,11,20,36,23,39,5,14,29,45,18,34,0,3,24,40,27,43,9 },
	{ 45,11,2,44,10,19,27,36,18,26,37,7,41,15,6,40,14,23,31,32,22,30,33,9,39,17,8,38,16,46,25,0,24,1,13,35,21,43,12,34,20,42,29,4,28,5,3 },
	{ 0,22,44,5,19,8,30,35,13,27,38,16,43,2,21,46,7,24,37,10,29,32,15,45,4,18,40,1,23,12,26,39,9,31,34,20,6,17,42,3,28,33,14,25,36,11,41 },
	{ 35,5,33,6,34,4,32,23,21,22,20,39,9,37,26,38,8,36,27,25,11,24,10,13,41,30,12,40,31,29,15,43,28,14,42,45,3,1,44,2,0,19,17,18,46,16,7 },
	{ 21,37,27,43,28,44,18,34,5,11,12,2,25,41,31,16,32,22,38,9,15,0,6,29,45,19,35,20,36,26,42,13,3,4,10,17,33,23,39,24,40,30,46,1,7,8,14 },
	{ 4,10,15,16,27,39,41,44,5,42,14,17,28,26,23,8,45,3,43,46,32,29,22,9,12,2,7,24,19,33,36,13,34,6,25,20,18,31,0,37,11,35,38,40,21,30,1 },
	{ 13,26,35,17,36,15,0,19,38,28,45,10,5,22,25,40,7,12,27,42,16,37,2,9,30,39,21,32,11,4,23,34,24,41,14,1,18,43,29,44,3,8,31,46,20,33,6 },
	{ 0,5,11,31,3,23,9,12,1,46,4,38,30,22,29,21,39,14,27,6,19,28,25,20,42,17,15,34,26,7,40,18,45,32,24,37,43,16,35,10,41,2,44,33,8,36,13 },
	{ 4,16,13,25,21,32,41,37,6,18,15,27,23,34,43,39,46,0,28,9,5,17,44,33,2,30,11,7,19,14,35,42,12,24,20,1,29,40,36,45,26,22,3,31,10,38,8 },
	{ 33,7,26,29,8,42,6,3,28,25,43,44,23,2,5,24,45,40,22,19,4,1,38,41,15,18,21,0,39,34,14,11,20,17,35,36,31,10,13,16,37,32,30,27,12,9,46 },
	{ 2,46,9,37,18,25,3,8,36,19,28,6,34,13,41,22,29,7,35,12,40,23,16,10,38,1,45,26,17,11,39,0,44,27,20,14,42,5,33,30,21,15,43,4,32,31,24 },
},
{
	/* Frame 187 */
	{ 36,24,39,27,0,3,41,17,34,30,13,6,44,20,23,8,11,37,25,42,18,1,14,32,28,35,31,4,7,45,21,38,26,9,2,40,16,43,19,12,15,33,29,46,22,5,10 },
	{ 16,6,10,3,37,9,28,32,17,38,11,30,2,23,4,44,29,33,39,24,46,31,34,22,5,26,45,19,0,40,25,35,42,27,12,18,1,20,41,14,7,43,13,36,21,8,15 },
	{ 23,41,35,8,28,2,22,40,34,9,29,7,19,45,39,12,24,6,18,44,38,13,25,11,31,33,43,0,20,10,30,32,42,1,21,15,27,37,4,16,14,26,36,46,5,17,3 },
	{ 25,11,1,8,23,30,20,45,6,46,32,9,35,31,21,28,7,14,4,18,33,40,34,43,29,15,5,12,19,26,16,41,2,42,36,13,39,27,17,24,3,10,0,22,37,44,38 },
	{ 44,13,14,8,11,25,21,7,36,16,19,33,0,34,12,15,29,27,41,24,42,20,23,37,4,38,18,1,35,2,31,45,28,46,26,40,9,43,10,22,5,39,6,17,3,32,30 },
	{ 8,13,26,31,33,36,17,12,11,30,37,34,16,21,10,15,35,38,1,20,19,14,40,39,0,5,18,23,41,44,25,4,3,22,45,42,24,29,2,7,43,46,9,28,27,6,32 },
	{ 38,8,4,11,7,40,36,43,39,9,5,10,6,41,37,24,28,27,31,25,29,26,30,34,46,0,12,3,15,32,44,35,1,13,2,14,33,45,16,20,19,23,17,21,18,22,42 },
	{ 24,4,39,37,27,7,25,5,38,36,26,6,20,12,45,23,15,21,13,46,44,22,14,28,0,35,33,31,3,29,1,34,32,30,2,16,8,43,41,19,11,17,9,42,40,18,10 },
	{ 46,1,9,32,7,40,30,3,37,26,45,34,4,43,12,21,0,39,8,17,6,15,23,2,36,11,44,19,42,28,20,38,24,16,14,33,22,41,31,10,18,27,29,35,5,13,25 },
	{ 23,40,0,27,38,12,42,2,5,14,9,7,20,11,24,37,22,41,17,26,39,29,32,43,19,44,4,31,34,8,46,6,1,10,13,3,16,15,28,33,18,45,21,30,35,25,36 },
	{ 41,33,12,25,4,17,28,42,35,26,6,19,31,11,44,36,8,20,0,13,24,5,38,43,22,2,14,27,7,40,32,45,37,16,29,9,21,1,34,46,39,18,30,10,23,3,15 },
	{ 17,23,36,9,34,15,16,22,41,8,39,14,29,19,40,5,38,11,28,18,45,4,43,10,25,31,44,1,42,7,24,30,33,0,6,21,27,32,13,46,3,20,26,37,12,35,2 },
},
{
	/* Frame 188 */
	{ 34,0,32,18,16,3,35,1,33,19,17,10,46,8,44,26,24,11,9,45,27,25,6,38,4,36,22,20,7,39,5,37,23,21,14,42,12,40,30,28,15,43,13,41,31,29,2 },
	{ 0,2,19,9,24,43,26,41,36,6,23,5,30,12,29,1,16,35,18,33,25,42,40,11,39,22,4,21,46,45,28,15,17,34,32,3,8,10,27,38,37,20,7,44,14,31,13 },
	{ 17,24,16,8,44,0,36,9,45,1,37,29,21,28,20,12,40,4,32,13,41,5,33,3,39,27,2,38,26,19,10,46,18,11,7,35,31,6,34,30,23,14,42,22,15,43,25 },
	{ 18,13,34,21,24,11,4,40,19,30,2,46,33,25,5,8,39,31,16,3,14,32,45,22,9,38,43,17,28,15,0,44,23,26,6,42,37,29,1,12,35,27,20,7,10,36,41 },
	{ 22,21,23,5,33,7,35,4,32,6,34,16,18,44,17,19,45,1,3,0,46,2,30,12,40,31,13,41,15,43,28,14,42,29,26,8,27,9,11,37,24,39,10,36,25,38,20 },
	{ 46,40,23,6,17,0,41,26,7,20,1,34,44,27,10,21,4,35,45,30,11,24,5,38,32,31,14,25,8,39,33,18,15,28,9,42,36,19,2,29,12,43,37,22,3,16,13 },
	{ 5,35,8,4,34,46,41,37,2,14,40,36,3,15,25,29,24,28,18,22,19,23,1,13,43,39,0,12,42,38,33,45,10,6,32,44,11,7,17,21,16,20,26,30,27,31,9 },
	{ 1,26,43,21,40,7,12,19,46,24,33,2,9,22,39,29,36,15,0,27,34,20,41,10,5,30,17,44,3,8,23,42,28,37,6,13,18,35,25,32,11,4,31,38,16,45,14 },
	{ 0,15,18,13,17,46,35,44,25,7,11,20,9,38,42,37,40,14,3,12,16,31,34,33,6,10,5,8,23,27,36,2,28,1,30,19,32,45,4,24,22,26,21,39,43,41,29 },
	{ 14,42,13,41,26,25,31,4,32,38,3,37,16,22,21,10,44,9,15,43,28,27,0,6,34,5,33,39,18,17,23,12,40,46,11,45,24,30,29,2,36,1,7,35,20,19,8 },
	{ 24,30,29,46,10,45,9,15,20,19,0,6,35,5,32,26,25,31,42,12,41,11,44,16,22,21,38,2,37,1,7,28,27,8,14,43,13,40,18,17,23,34,4,33,39,3,36 },
	{ 38,26,8,14,33,29,35,31,1,3,44,20,42,22,4,10,37,25,39,27,13,15,32,16,46,18,0,6,41,21,43,23,9,11,36,28,34,30,12,2,45,17,19,5,7,40,24 },
},
{
	/* Frame 189 */
	{ 9,37,23,12,11,24,39,40,0,13,10,25,2,15,28,41,27,1,44,4,3,16,14,29,6,26,32,18,45,31,5,34,17,42,7,20,33,19,8,30,36,22,35,43,38,21,46 },
	{ 22,35,25,36,3,4,27,38,16,41,6,9,18,21,32,15,0,23,34,28,37,2,5,30,43,17,44,11,12,19,46,24,33,14,1,26,39,29,40,7,8,31,42,20,45,10,13 },
	{ 19,35,24,40,7,12,30,38,17,33,10,5,23,28,36,3,8,18,34,21,45,6,1,27,43,16,32,15,4,22,46,25,41,2,13,31,39,20,44,11,0,26,42,29,37,14,9 },
	{ 35,22,8,38,19,45,17,2,40,20,7,5,26,0,42,31,37,29,14,32,24,11,9,39,18,12,34,23,41,21,6,44,16,3,1,43,30,4,46,27,33,25,10,36,28,15,13 },
	{ 8,28,1,21,25,44,37,41,27,14,18,7,11,34,12,16,5,9,29,32,45,31,2,22,26,15,19,38,42,35,0,20,24,13,17,36,40,33,6,10,30,3,23,46,39,43,4 },
	{ 34,9,4,2,21,19,30,32,45,43,7,0,17,28,26,46,41,5,3,14,31,24,44,42,39,1,12,10,29,27,22,40,37,35,15,8,25,20,18,38,33,13,11,6,23,16,36 },
	{ 27,5,31,35,24,39,18,28,32,22,36,17,3,21,41,7,45,0,10,4,14,34,9,38,19,13,23,43,16,26,20,40,30,44,25,11,29,33,15,37,8,2,12,6,42,1,46 },
	{ 32,27,6,21,8,33,30,7,24,9,46,44,31,2,25,4,43,45,18,3,28,5,42,40,19,14,29,0,39,41,22,15,16,1,38,36,23,10,17,12,35,37,26,11,20,13,34 },
	{ 20,3,12,5,27,22,29,32,14,38,45,4,43,23,28,17,15,6,9,30,44,37,42,35,16,7,8,1,31,18,25,36,10,34,41,0,19,24,21,11,2,13,26,40,33,46,39 },
	{ 30,12,36,14,38,29,31,13,37,15,39,28,22,4,40,6,42,21,23,5,41,7,43,20,24,26,8,32,10,34,25,27,9,33,11,35,16,44,18,46,0,2,17,45,19,1,3 },
	{ 45,30,9,28,6,17,5,34,33,25,13,11,36,41,0,21,18,44,8,29,27,15,39,43,4,3,22,32,46,12,10,31,40,19,7,16,35,26,14,24,38,42,37,2,23,1,20 },
	{ 7,9,46,5,34,26,44,22,43,32,24,39,31,20,41,19,10,37,29,6,17,8,15,4,3,13,42,1,38,30,40,18,36,28,35,27,16,45,23,14,33,25,2,21,12,11,0 },
},
{
	/* Frame 190 */
	{ 27,12,1,7,11,20,44,18,33,39,25,46,2,5,30,9,15,16,34,28,37,41,23,0,6,43,26,13,32,38,24,10,21,45,19,4,31,8,3,36,40,22,14,17,35,29,42 },
	{ 16,36,19,39,9,10,25,33,22,34,4,7,28,40,31,43,1,2,17,45,26,46,8,11,20,32,23,35,13,14,29,37,18,38,0,3,24,44,27,5,6,21,41,30,42,12,15 },
	{ 43,10,18,15,44,23,36,30,41,8,0,13,20,28,11,34,19,26,45,6,31,9,16,24,33,21,38,29,5,35,2,42,27,7,14,22,37,17,40,25,32,1,39,12,46,4,3 },
	{ 5,14,0,43,19,37,25,46,22,32,28,3,9,6,12,35,31,41,17,38,26,44,20,15,1,10,4,23,33,29,42,18,36,24,7,13,2,8,39,27,45,21,34,30,40,16,11 },
	{ 32,12,40,20,28,5,33,13,41,21,29,36,27,44,2,10,18,37,26,45,3,11,19,31,6,34,14,42,22,30,7,35,15,43,23,0,38,8,46,16,24,1,39,9,17,25,4 },
	{ 20,13,39,8,27,34,41,22,15,29,36,10,24,1,43,12,31,38,45,26,3,17,40,14,28,5,0,19,42,33,30,7,21,44,2,16,9,35,4,23,46,37,18,11,25,32,6 },
	{ 16,6,19,20,41,23,45,34,17,38,18,21,8,22,11,12,15,35,32,39,36,9,10,13,24,14,27,28,33,31,37,42,25,46,26,29,0,30,3,4,7,43,40,44,1,2,5 },
	{ 29,41,10,13,27,24,44,3,0,22,38,17,37,6,9,31,43,28,40,15,12,26,34,21,33,2,5,19,39,16,36,11,8,30,46,25,45,14,1,23,35,20,32,7,4,18,42 },
	{ 33,28,35,15,20,13,7,26,5,40,18,42,32,34,12,27,4,25,19,10,17,2,45,37,24,39,11,16,9,3,30,1,44,22,46,36,38,8,31,0,29,23,14,21,6,41,43 },
	{ 15,10,39,34,20,17,44,41,36,11,6,35,16,13,40,37,32,7,2,12,9,4,33,3,31,8,5,0,30,27,46,1,29,26,23,42,28,25,22,19,14,43,38,24,21,45,18 },
	{ 29,6,9,44,18,4,43,15,16,27,41,13,34,30,25,10,32,28,23,8,45,3,38,21,14,1,36,26,12,35,7,24,19,33,5,42,22,17,2,39,40,20,31,0,37,11,46 },
	{ 0,44,7,43,16,23,1,45,6,42,17,30,32,8,39,15,24,31,33,9,38,14,25,18,4,40,3,20,19,5,41,2,46,21,26,36,12,35,11,28,27,37,13,34,10,29,22 },
},
{
	/* Frame 191 */
	{ 16,15,12,6,5,39,11,23,40,20,2,24,1,35,14,19,13,37,31,38,28,10,22,9,21,43,0,27,34,33,18,45,17,46,36,30,7,29,4,8,42,41,26,3,25,32,44 },
	{ 16,12,25,0,30,9,14,27,35,11,17,44,24,1,8,23,46,26,7,10,45,36,40,22,6,19,42,3,37,41,32,38,18,43,20,2,29,4,13,33,31,39,15,21,34,28,5 },
	{ 8,26,34,17,45,6,13,19,43,24,32,15,4,30,46,21,41,2,9,23,39,28,44,11,0,18,42,25,37,14,5,27,35,16,40,7,12,22,38,29,33,10,1,31,20,36,3 },
	{ 18,34,17,40,43,37,15,12,19,2,16,1,26,42,25,36,39,45,3,0,27,10,24,9,22,38,21,44,33,11,8,23,6,20,5,30,46,29,32,35,41,7,4,31,14,28,13 },
	{ 14,7,27,34,18,11,45,29,36,20,9,0,40,24,33,31,38,22,15,2,42,26,35,13,4,44,28,37,17,8,1,6,46,30,39,19,10,3,43,21,12,5,41,25,32,16,23 },
	{ 41,4,42,7,9,26,21,35,14,0,44,3,28,31,17,37,10,38,40,5,22,24,27,33,12,34,15,1,18,29,43,6,8,36,11,20,23,25,45,2,46,32,13,30,16,19,39 },
	{ 12,16,7,27,44,39,13,17,6,26,45,34,28,8,23,3,40,35,29,9,22,2,41,46,4,24,15,19,36,5,25,14,18,37,42,20,0,31,11,32,43,21,1,30,10,33,38 },
	{ 44,27,2,29,4,43,45,30,3,16,5,42,32,31,6,17,8,33,18,7,20,9,46,36,19,10,21,12,35,37,22,11,24,13,34,40,23,14,25,0,39,41,26,15,28,1,38 },
	{ 40,43,21,7,4,25,30,3,0,18,45,46,13,41,23,42,20,9,6,27,36,24,39,2,32,35,29,15,12,17,22,11,8,26,37,38,5,33,31,34,28,1,14,19,44,16,10 },
	{ 8,16,46,41,14,22,9,17,40,15,23,28,0,38,33,26,6,29,1,39,32,27,7,12,20,42,45,10,18,13,21,43,44,11,19,24,4,34,37,30,2,25,5,35,36,31,3 },
	{ 40,38,42,36,41,39,43,37,18,22,16,20,2,6,0,4,19,23,17,21,3,7,1,5,44,34,32,46,45,35,33,8,12,26,30,25,29,10,14,9,13,27,31,24,28,11,15 },
	{ 19,28,42,7,8,37,27,18,15,6,41,36,26,17,14,35,40,5,25,16,34,13,4,23,24,46,3,12,33,31,22,11,2,45,32,30,21,10,39,44,1,29,20,43,38,9,0 },
},
{
	/* Frame 192 */
	{ 6,22,37,7,23,5,21,38,4,20,39,44,26,14,24,45,27,15,25,13,46,12,2,18,0,16,3,19,1,17,34,32,35,33,10,8,30,11,9,31,42,29,40,43,28,41,36 },
	{ 6,36,19,15,24,12,26,23,34,20,32,3,29,8,10,7,16,4,18,39,25,13,46,45,21,0,2,9,30,43,41,17,5,38,37,14,44,27,1,22,35,33,31,42,28,40,11 },
	{ 16,9,43,21,12,36,5,2,10,41,7,30,22,17,34,8,42,1,28,4,45,3,26,40,18,33,31,38,23,46,15,35,24,0,29,20,44,13,37,27,19,32,11,39,6,14,25 },
	{ 4,19,46,24,13,35,21,40,10,37,18,7,12,27,34,20,1,43,29,36,6,45,26,15,0,23,42,28,9,39,17,44,14,33,22,3,8,31,38,16,5,25,32,2,41,30,11 },
	{ 31,6,34,14,42,22,30,7,35,15,43,19,45,27,2,10,36,18,44,26,3,11,37,13,41,21,29,4,32,12,40,20,28,5,33,9,17,25,38,0,46,8,16,24,39,1,23 },
	{ 31,39,28,36,3,0,26,34,21,45,14,9,19,43,16,40,7,4,30,38,25,33,2,13,23,20,44,11,8,18,42,29,37,6,1,27,35,24,32,15,12,22,46,17,41,10,5 },
	{ 17,12,16,46,45,14,18,44,15,19,29,9,43,28,8,42,41,30,10,40,31,11,5,25,39,4,24,38,37,6,26,36,7,27,21,1,35,20,0,34,33,22,2,32,23,3,13 },
	{ 21,37,14,1,27,43,16,32,7,12,22,34,25,41,2,5,31,20,36,11,0,26,38,29,45,6,9,19,35,24,40,15,4,30,42,17,33,10,13,23,39,28,44,3,8,18,46 },
	{ 33,44,42,39,1,27,16,29,2,15,40,4,35,30,25,45,11,38,0,13,26,23,28,14,41,36,34,9,19,24,21,10,7,32,12,43,22,17,37,3,46,8,5,18,31,20,6 },
	{ 36,33,23,18,12,9,32,6,19,21,8,7,2,20,17,46,43,45,30,3,5,16,42,44,41,31,26,4,1,40,14,27,29,0,39,15,10,28,25,38,35,37,22,11,13,24,34 },
	{ 16,28,26,22,17,29,27,23,34,38,8,12,2,6,41,45,35,39,9,13,3,7,40,44,24,20,18,30,25,21,19,31,42,46,0,4,10,14,33,37,43,1,5,11,15,32,36 },
	{ 40,20,6,36,11,9,3,1,46,12,31,34,29,4,43,23,41,21,26,39,24,37,10,18,44,16,2,32,15,13,7,5,42,8,27,38,25,0,19,45,17,30,35,28,33,14,22 },
},
{
	/* Frame 193 */
	{ 11,25,5,6,1,2,31,12,27,39,8,35,22,45,18,46,41,28,42,24,36,7,32,21,3,17,13,14,9,10,23,4,19,0,43,30,37,26,38,33,20,34,16,44,15,40,29 },
	{ 26,7,25,4,10,41,38,16,13,3,31,0,44,34,22,9,21,27,6,37,43,40,28,18,15,17,12,2,33,46,24,5,11,23,8,39,36,42,30,1,29,19,14,45,35,32,20 },
	{ 1,2,29,30,42,37,8,27,20,32,15,35,17,18,5,41,6,24,46,3,12,31,36,9,39,10,21,22,34,45,0,19,28,40,7,43,25,26,13,33,14,16,38,11,4,23,44 },
	{ 43,22,4,26,0,15,21,11,25,37,6,33,28,2,46,16,44,42,23,40,5,27,39,1,35,30,12,18,8,7,29,3,17,45,14,41,20,10,38,24,36,34,31,32,13,19,9 },
	{ 26,22,27,23,28,16,29,17,14,6,40,32,15,7,41,33,39,8,0,46,38,9,1,30,18,31,19,24,20,25,21,10,2,44,36,11,3,45,37,43,35,12,4,42,34,13,5 },
	{ 42,34,46,38,43,35,39,12,18,24,22,13,19,25,23,29,2,8,6,28,3,9,7,44,36,45,37,40,32,41,33,26,4,30,16,27,5,31,17,10,21,14,0,11,20,15,1 },
	{ 44,36,46,38,45,37,39,10,4,8,22,27,21,25,6,11,5,9,23,26,20,24,7,42,34,40,32,43,35,41,33,12,2,30,0,29,19,14,17,13,3,31,1,28,18,15,16 },
	{ 14,35,26,39,30,19,43,23,2,29,9,12,32,5,16,40,11,15,34,6,18,42,22,25,37,28,8,21,45,1,4,27,38,31,10,46,3,7,13,33,24,36,17,41,20,44,0 },
	{ 11,30,38,19,43,7,2,36,25,33,13,8,21,45,16,40,27,35,15,10,23,18,42,6,29,37,24,32,4,1,20,31,39,26,34,14,3,22,46,12,9,28,44,17,41,5,0 },
	{ 38,27,42,22,33,13,0,10,7,29,37,25,40,4,34,30,18,8,20,44,15,3,23,32,12,16,39,26,43,6,28,36,1,11,31,46,19,24,41,5,35,14,2,9,21,45,17 },
	{ 42,31,32,5,24,39,2,36,14,21,9,27,17,40,13,35,22,10,44,0,29,7,4,25,38,18,43,30,33,20,8,3,37,15,12,34,23,46,26,16,41,28,6,11,45,1,19 },
	{ 10,18,40,15,36,6,45,31,43,25,34,16,8,39,4,13,11,32,2,41,27,37,7,30,23,35,0,9,5,46,28,21,33,3,26,19,14,22,44,1,42,24,17,29,38,20,12 },
},
{
	/* Frame 194 */
	{ 34,15,0,45,23,24,21,35,38,1,12,20,10,39,32,13,18,11,6,33,36,19,30,17,42,7,8,37,31,16,29,43,46,9,4,28,2,40,5,26,3,14,41,44,27,22,25 },
	{ 21,41,18,14,33,24,6,16,12,11,4,3,9,42,1,34,27,40,19,32,25,39,30,17,45,22,10,37,28,2,20,8,15,0,7,13,46,5,38,31,44,23,43,36,29,35,26 },
	{ 25,5,10,38,41,36,16,13,18,44,24,21,11,39,37,42,29,19,14,45,20,27,22,43,28,2,15,0,46,26,23,8,3,31,1,34,32,6,9,4,40,30,17,12,35,33,7 },
	{ 23,33,20,19,39,16,43,30,13,26,1,7,4,11,8,44,14,32,21,2,38,17,37,42,31,41,28,27,24,35,22,5,18,9,15,12,3,0,36,6,40,29,10,46,25,45,34 },
	{ 44,19,43,20,13,2,27,37,28,34,14,41,46,17,7,0,25,18,11,12,26,36,35,5,40,23,16,9,6,31,33,24,38,10,45,42,21,3,4,29,22,15,8,30,32,39,1 },
	{ 40,8,44,12,41,9,45,13,25,29,24,28,0,34,4,1,35,5,39,17,21,38,16,20,31,42,10,30,43,11,15,27,46,14,26,32,23,36,2,33,22,37,3,7,19,6,18 },
	{ 41,33,45,37,40,32,44,36,31,1,11,5,30,0,10,4,15,16,26,20,14,17,27,21,43,35,42,34,39,46,38,9,23,13,3,8,22,12,2,24,7,28,18,25,6,29,19 },
	{ 31,36,43,16,25,23,40,37,10,17,28,41,2,11,46,20,29,8,3,44,15,21,0,9,34,45,7,14,1,35,12,6,26,32,4,13,39,18,27,33,30,5,42,38,24,19,22 },
	{ 21,37,22,38,12,15,28,17,33,18,34,0,11,24,40,4,7,20,44,31,13,14,3,16,32,27,43,9,10,36,23,39,5,6,29,45,30,46,19,35,1,2,25,41,26,42,8 },
	{ 43,3,0,42,2,17,19,40,16,18,41,5,37,7,39,4,36,6,38,21,23,20,22,11,33,25,35,10,32,24,34,27,8,26,9,15,29,14,46,28,31,12,44,30,13,45,1 },
	{ 24,43,22,36,29,46,19,0,10,5,15,41,20,39,30,44,17,34,27,8,6,13,3,37,28,18,32,25,42,23,4,14,1,11,45,16,35,26,40,21,38,31,12,2,9,7,33 },
	{ 0,46,13,26,22,44,16,29,39,11,33,2,31,42,9,5,18,40,14,36,25,35,21,12,27,7,1,28,38,10,32,23,45,17,8,4,3,30,43,24,34,20,19,41,15,37,6 },
},
{
	/* Frame 195 */
	{ 4,24,18,15,21,40,34,37,23,10,16,13,7,32,43,8,2,30,5,25,46,41,35,27,0,28,22,11,17,44,38,33,19,14,20,9,3,36,12,6,26,1,29,42,45,39,31 },
	{ 32,35,12,0,18,29,17,30,40,6,43,5,8,23,25,26,46,2,13,1,14,19,31,7,42,37,9,38,10,27,20,3,45,33,15,34,28,16,36,41,39,11,4,22,21,24,44 },
	{ 35,37,0,18,20,40,14,42,25,3,5,33,23,16,10,12,30,36,1,38,19,21,15,43,45,8,26,28,32,6,34,17,11,13,41,31,24,39,2,4,22,44,9,46,27,29,7 },
	{ 7,2,46,43,21,24,22,3,36,42,12,25,23,26,37,32,13,8,14,27,33,39,28,9,15,10,38,35,29,16,30,11,44,34,4,17,31,18,45,40,5,0,6,19,41,20,1 },
	{ 45,30,10,44,31,11,25,13,43,24,12,42,37,18,2,36,19,3,21,5,35,20,4,34,41,26,14,40,27,15,29,9,28,8,46,33,22,6,32,23,7,17,1,39,16,0,38 },
	{ 41,33,43,35,40,32,42,34,31,17,13,19,15,1,28,3,30,16,12,18,14,0,29,2,45,37,39,44,36,46,38,25,23,27,5,9,7,11,20,24,22,26,4,8,6,10,21 },
	{ 35,0,11,18,40,38,4,14,23,44,27,3,24,43,30,6,28,34,46,33,10,19,9,16,37,22,13,20,2,25,1,42,41,39,29,5,15,32,45,8,17,26,36,12,21,31,7 },
	{ 43,32,27,3,9,16,10,46,36,6,13,20,15,22,35,41,42,19,25,1,26,2,8,38,45,29,5,31,7,12,33,34,40,17,11,18,24,0,37,39,44,21,14,23,28,4,30 },
	{ 43,19,5,6,27,32,13,14,3,40,20,37,23,38,11,24,45,31,46,18,0,7,26,33,8,34,15,28,41,17,42,22,39,4,25,30,12,1,2,21,36,9,35,10,29,44,16 },
	{ 22,45,28,38,19,40,25,2,12,7,9,43,26,33,20,46,31,36,17,10,0,15,5,39,18,41,24,34,23,44,29,6,8,3,13,30,37,16,42,27,32,21,14,4,11,1,35 },
	{ 24,11,44,17,38,18,37,0,29,30,40,12,6,33,5,34,25,46,26,45,8,39,19,1,2,14,41,13,42,7,20,35,23,27,9,10,16,3,36,15,28,43,31,21,22,32,4 },
	{ 33,1,35,3,32,0,34,2,16,18,17,19,5,7,46,4,6,20,45,22,21,44,23,43,11,25,42,10,24,26,41,9,27,40,8,37,15,39,29,36,14,38,28,30,13,31,12 },
},
{
	/* Frame 196 */
	{ 0,44,6,42,16,22,1,45,7,43,17,27,32,12,38,10,28,26,33,13,39,11,29,19,4,40,2,46,20,18,5,41,3,21,31,36,8,34,14,24,30,37,9,35,15,25,23 },
	{ 3,38,40,44,32,31,36,10,23,2,29,39,25,21,45,17,30,37,22,15,28,7,24,20,13,16,9,5,1,14,42,6,34,12,8,4,27,0,19,43,35,41,26,33,18,11,46 },
	{ 8,31,26,44,16,23,18,9,14,27,45,40,6,19,4,15,10,28,41,46,7,2,5,0,38,36,11,29,24,42,3,21,1,39,34,37,32,12,25,30,43,20,17,22,35,33,13 },
	{ 5,8,31,26,44,33,20,9,6,27,32,21,16,7,10,46,35,12,17,22,11,37,34,13,0,23,18,36,41,28,1,14,19,40,39,29,24,15,2,38,43,4,25,30,3,45,42 },
	{ 22,40,17,33,7,0,10,19,13,20,42,26,36,29,35,41,15,8,6,31,1,24,38,18,44,21,43,37,3,4,14,23,9,16,46,30,32,25,39,45,11,12,2,27,5,28,34 },
	{ 43,11,41,9,26,24,42,10,40,8,27,25,37,3,1,18,38,16,36,2,0,19,39,17,45,13,30,28,46,14,44,12,31,29,15,35,5,33,22,20,6,34,4,32,23,21,7 },
	{ 40,39,3,15,6,43,36,46,1,12,20,41,30,7,27,37,13,4,25,44,31,22,26,19,5,24,17,45,34,23,10,18,32,8,16,29,35,38,11,2,14,33,42,9,0,28,21 },
	{ 33,44,3,15,38,21,9,22,45,34,14,16,40,23,10,35,17,28,41,11,4,46,29,18,30,42,5,24,19,31,0,43,36,25,7,1,12,37,6,26,32,13,2,39,27,20,8 },
	{ 43,12,34,1,24,41,31,32,18,39,10,29,16,37,8,15,6,27,46,13,35,4,25,44,30,33,23,11,2,21,42,9,0,7,40,26,19,38,5,28,45,17,36,22,14,3,20 },
	{ 27,9,17,2,26,8,16,35,41,34,40,7,23,13,29,6,22,12,28,39,45,38,44,11,19,1,25,10,18,0,24,43,33,42,32,15,31,5,21,14,30,4,20,37,46,36,3 },
	{ 31,44,25,42,37,2,4,15,26,9,28,19,32,21,38,45,10,12,3,22,5,16,35,27,40,29,46,33,6,0,11,30,13,24,43,23,36,17,34,41,14,8,7,18,1,20,39 },
	{ 42,26,40,29,37,31,18,32,21,7,43,10,41,8,30,38,19,33,0,22,11,9,14,39,12,1,34,23,4,24,15,13,16,35,2,46,5,44,25,27,28,36,17,3,20,45,6 },
},
{
	/* Frame 197 */
	{ 32,31,2,13,27,14,9,10,37,7,33,3,15,11,20,38,16,34,46,45,42,21,41,39,17,4,35,28,0,24,44,43,40,22,5,18,29,1,30,25,12,26,8,23,36,19,6 },
	{ 24,13,10,30,8,46,44,3,23,1,21,18,39,37,34,32,28,27,14,25,12,43,41,7,16,5,2,22,0,38,36,11,31,9,29,26,45,42,40,20,19,6,17,4,35,33,15 },
	{ 19,6,9,20,32,2,7,16,21,43,46,3,30,17,4,42,45,26,31,0,5,41,44,27,14,1,28,39,40,10,15,24,29,35,38,11,22,25,12,34,37,18,23,8,13,33,36 },
	{ 23,9,15,45,28,35,30,4,6,40,21,46,19,13,3,33,24,39,26,8,10,44,17,34,31,1,7,37,20,43,22,12,14,32,29,38,27,5,11,41,16,18,0,2,36,25,42 },
	{ 27,23,25,21,26,22,24,20,45,37,15,7,13,5,46,38,44,36,14,6,12,4,39,31,19,29,17,30,18,28,16,41,33,11,3,9,1,42,34,40,32,10,2,8,0,43,35 },
	{ 16,29,20,18,31,6,37,46,33,13,21,9,35,30,23,11,36,32,12,5,8,1,45,34,41,22,10,3,43,4,25,0,44,40,39,27,2,15,42,24,17,28,38,26,19,14,7 },
	{ 4,44,0,40,21,17,5,45,1,41,20,16,34,12,8,29,38,25,35,13,9,28,39,24,2,42,22,19,6,46,3,43,23,18,7,36,10,32,30,27,14,37,11,33,31,26,15 },
	{ 31,19,12,33,34,22,10,4,45,15,3,29,37,38,27,21,8,42,18,13,0,35,11,5,25,6,46,40,28,17,30,39,32,20,9,23,43,44,1,14,2,36,24,7,26,41,16 },
	{ 13,46,22,37,29,7,4,43,19,40,16,10,1,34,26,45,21,15,12,39,31,36,28,6,9,42,18,33,25,3,0,23,44,20,14,5,38,30,41,17,11,8,35,27,32,24,2 },
	{ 28,37,9,32,21,16,41,4,15,38,11,34,31,18,43,22,29,24,33,12,17,5,44,0,39,26,35,30,19,6,2,25,13,36,8,20,45,1,40,27,14,10,7,46,3,42,23 },
	{ 40,24,44,21,17,43,10,7,18,41,8,45,12,38,16,11,31,2,9,13,39,0,4,46,30,3,23,28,1,34,5,14,27,32,22,36,29,25,35,20,15,42,26,33,6,37,19 },
	{ 44,38,13,2,8,7,29,37,32,46,1,10,20,15,17,45,34,40,39,3,9,22,28,19,25,33,42,11,4,30,16,27,35,41,23,12,18,24,6,43,36,5,31,0,26,21,14 },
},
{
	/* Frame 198 */
	{ 28,26,36,40,17,34,45,30,9,7,21,18,12,0,39,11,22,32,14,25,43,5,41,16,46,3,29,27,37,8,6,20,35,44,31,38,10,19,13,1,24,42,4,23,33,15,2 },
	{ 23,1,24,35,30,20,44,18,10,32,29,6,17,41,15,37,3,12,46,0,34,31,9,19,43,5,28,39,26,16,40,22,14,36,25,2,21,45,11,33,7,8,42,4,38,27,13 },
	{ 14,2,44,5,24,10,31,40,1,20,39,27,36,12,16,35,23,32,8,29,43,19,7,4,25,15,3,45,0,21,38,11,30,41,17,46,34,22,26,37,13,42,18,6,33,9,28 },
	{ 3,36,17,39,30,9,14,45,20,34,23,4,7,40,29,43,26,13,2,33,16,38,19,8,11,44,25,22,1,6,37,28,42,31,12,15,32,21,35,18,5,10,41,24,46,27,0 },
	{ 15,21,44,22,37,29,38,30,4,41,19,42,8,27,1,2,13,14,20,7,36,28,39,11,17,40,18,43,33,25,34,26,0,45,23,46,12,31,5,6,9,10,16,3,32,24,35 },
	{ 41,15,2,39,6,42,13,46,0,37,21,40,30,26,7,12,24,36,5,31,45,27,22,18,25,4,16,44,11,23,35,19,9,28,33,17,10,14,34,3,38,8,43,29,32,1,20 },
	{ 23,5,45,22,4,44,7,20,6,46,21,33,31,35,13,32,30,34,12,15,28,14,29,1,41,3,43,0,40,2,42,16,18,17,19,9,37,11,8,36,10,39,24,26,38,25,27 },
	{ 15,24,28,27,31,9,13,10,14,25,29,26,30,8,12,43,37,41,39,42,36,40,38,16,20,18,22,1,5,3,7,17,21,19,23,0,4,2,6,33,35,45,46,32,34,44,11 },
	{ 5,34,18,45,29,11,12,39,23,32,16,6,9,46,30,37,21,3,4,43,27,44,28,10,1,38,22,41,25,15,8,35,19,36,20,2,13,42,26,33,17,7,0,31,40,24,14 },
	{ 8,35,14,13,0,23,5,24,34,15,46,12,45,16,3,4,37,25,26,28,44,17,42,2,41,20,36,7,27,33,29,30,43,18,40,21,6,39,10,32,9,31,19,1,22,38,11 },
	{ 30,46,5,39,25,8,3,20,32,31,14,45,18,38,9,43,21,0,15,28,44,19,6,37,26,42,1,35,29,12,7,16,36,27,10,41,22,34,13,17,4,11,24,40,23,2,33 },
	{ 42,4,15,19,24,6,31,1,45,35,40,22,29,36,17,11,38,12,2,33,27,20,14,18,9,43,5,30,0,44,34,25,7,46,16,10,41,23,28,37,32,26,21,39,13,3,8 },
},
{
	/* Frame 199 */
	{ 2,13,6,41,35,28,0,46,5,42,33,20,27,31,12,38,40,34,45,25,19,23,4,11,32,15,37,26,17,30,39,9,3,44,7,24,18,29,22,10,1,14,36,43,16,21,8 },
	{ 32,37,35,38,0,18,17,20,9,12,10,40,29,27,30,36,2,39,1,4,19,22,21,13,11,14,41,44,42,31,24,3,6,33,5,34,23,16,15,8,45,43,46,25,28,26,7 },
	{ 17,12,43,37,3,22,0,13,41,36,26,23,1,20,46,40,27,6,24,21,34,10,7,25,4,35,45,11,30,8,5,33,44,18,31,9,28,38,32,19,14,16,29,42,39,2,15 },
	{ 33,31,6,24,9,32,18,7,29,8,46,45,19,2,28,5,43,44,22,3,17,4,42,41,23,14,16,1,39,40,26,15,21,0,38,37,27,10,20,13,35,36,30,11,25,12,34 },
	{ 27,15,44,46,24,12,26,14,45,25,13,23,7,36,38,20,4,22,6,37,39,21,5,31,11,40,42,28,8,30,10,41,43,29,9,19,3,32,34,16,0,18,2,33,35,17,1 },
	{ 41,42,5,30,6,45,35,46,17,11,18,39,15,22,29,32,27,3,8,43,36,31,7,12,21,19,24,0,40,23,28,4,33,44,34,9,16,10,37,38,13,20,14,25,1,26,2 },
	{ 21,43,16,30,35,26,22,18,12,9,4,1,11,39,40,3,32,25,42,17,34,27,15,19,45,7,8,37,28,0,46,20,10,38,31,2,23,13,5,14,44,6,41,36,29,33,24 },
	{ 33,23,40,10,38,21,9,36,7,27,2,5,42,12,24,0,22,41,30,11,39,19,20,29,34,37,17,44,14,32,3,43,13,1,8,31,6,18,46,26,28,35,4,16,45,25,15 },
	{ 27,41,16,7,12,43,18,36,21,14,9,38,23,45,28,11,0,30,40,17,2,13,42,19,33,24,15,4,35,26,44,29,6,1,46,31,37,20,3,8,39,22,32,25,10,5,34 },
	{ 10,9,16,3,26,32,25,35,23,45,46,12,6,5,28,11,18,40,17,43,27,33,34,0,14,13,20,7,30,36,29,39,19,41,42,8,2,1,24,15,22,44,21,31,37,38,4 },
	{ 15,27,46,14,26,30,43,11,31,42,10,7,19,6,18,33,22,37,3,32,23,36,2,25,29,24,28,41,9,45,13,40,8,44,12,39,17,21,38,16,20,1,35,5,0,34,4 },
	{ 35,43,33,41,34,42,32,40,5,11,23,9,4,10,22,8,20,26,7,24,21,27,6,25,37,45,36,44,39,38,46,3,13,1,31,2,12,0,30,18,28,16,15,19,29,17,14 },
},
{
	/* Frame 200 */
	{ 4,26,1,5,27,32,30,36,33,31,37,16,20,10,17,46,21,11,14,42,15,43,39,24,2,28,38,25,3,29,6,34,7,35,8,18,12,9,19,13,22,40,44,23,41,45,0 },
	{ 3,7,46,20,42,32,5,44,8,2,27,6,31,43,17,4,29,41,26,39,30,11,16,15,37,28,1,40,13,38,34,10,14,36,0,25,19,12,23,35,21,33,24,18,45,22,9 },
	{ 42,4,2,31,9,26,21,38,1,15,45,10,40,22,16,37,35,29,32,46,24,6,19,13,30,8,43,5,3,0,14,44,27,20,39,17,36,34,28,11,41,23,18,12,33,25,7 },
	{ 43,45,26,3,20,5,42,44,31,2,25,4,39,41,30,15,24,1,38,40,19,14,29,0,35,37,18,11,28,13,34,36,23,10,17,12,33,22,7,16,9,46,32,27,6,21,8 },
	{ 46,22,45,21,7,4,39,19,40,16,10,9,34,26,33,25,15,12,31,36,28,6,5,42,18,41,17,3,0,35,23,44,20,14,13,38,30,37,29,11,8,43,27,32,24,2,1 },
	{ 12,22,36,21,24,3,0,43,28,40,15,4,39,9,44,27,33,16,13,31,37,20,7,10,1,34,19,41,14,5,38,23,45,26,25,2,30,42,29,6,11,46,8,35,18,32,17 },
	{ 22,21,11,25,3,44,17,31,36,28,23,40,20,32,24,45,16,46,37,12,38,41,4,33,8,27,0,19,13,39,14,5,42,6,9,34,26,1,18,15,43,7,35,10,2,30,29 },
	{ 28,5,33,13,41,21,29,4,32,12,40,11,18,37,27,45,3,10,19,36,26,44,2,15,43,22,31,7,35,14,42,23,30,6,34,16,24,1,39,9,46,17,25,0,38,8,20 },
	{ 19,45,16,11,8,39,26,32,21,2,13,42,31,41,28,7,4,35,22,44,17,14,9,38,27,37,24,3,0,18,40,29,10,5,34,23,33,20,15,12,43,30,36,25,6,1,46 },
	{ 35,44,28,38,19,0,25,15,30,5,2,45,39,32,24,42,31,4,21,3,26,9,6,33,43,36,20,46,27,8,17,7,22,13,10,37,40,16,34,23,12,29,11,18,1,14,41 },
	{ 41,27,11,40,26,10,25,9,42,24,8,43,33,23,3,32,22,2,21,1,34,20,0,35,45,31,15,44,30,14,29,13,46,28,12,37,19,7,36,18,6,17,5,38,16,4,39 },
	{ 36,38,31,3,29,34,27,22,9,37,44,39,46,18,28,0,35,42,23,24,21,45,19,12,1,14,43,32,25,20,10,13,16,15,33,40,4,11,6,17,30,2,41,5,26,7,8 },
},
{
	/* Frame 201 */
	{ 24,44,27,15,32,29,3,17,5,6,9,10,12,39,0,43,22,45,26,46,33,28,34,31,16,36,19,7,40,21,11,25,13,14,1,2,4,8,35,30,37,18,38,41,20,42,23 },
	{ 30,13,33,15,35,29,31,12,32,14,34,24,26,45,9,11,25,27,44,8,46,10,20,22,5,41,7,43,21,23,4,40,6,42,16,18,37,1,39,3,17,19,36,0,38,2,28 },
	{ 13,42,19,41,28,7,0,35,22,44,21,10,9,38,31,37,24,3,12,18,40,17,6,5,34,27,33,20,15,8,43,30,36,29,2,1,46,23,45,16,11,4,39,26,32,25,14 },
	{ 40,14,28,10,23,16,13,27,9,46,37,42,22,33,12,26,7,8,21,3,25,36,43,32,6,20,2,31,24,5,19,1,38,45,34,30,41,4,18,15,0,29,11,39,17,44,35 },
	{ 27,29,36,34,6,45,0,26,19,28,21,15,35,9,44,33,42,18,20,14,3,8,5,31,25,32,43,38,2,41,4,30,23,24,17,11,39,13,40,37,46,22,16,10,7,12,1 },
	{ 18,16,19,17,2,42,0,40,3,43,1,41,36,26,24,37,27,25,10,38,8,11,39,9,4,44,22,5,45,23,21,6,46,20,7,12,30,13,31,34,29,32,14,35,28,33,15 },
	{ 25,20,38,3,30,23,24,13,2,22,17,12,41,27,14,16,45,40,5,26,19,15,42,44,9,4,33,29,18,46,43,7,8,37,32,28,10,6,35,36,1,21,11,39,34,31,0 },
	{ 43,17,40,10,33,25,3,0,45,15,12,22,5,38,30,9,19,42,16,35,27,32,24,2,21,44,14,37,29,7,4,41,11,8,18,1,34,26,13,23,46,20,39,31,36,28,6 },
	{ 28,1,11,42,7,46,29,0,41,10,35,14,18,9,40,5,34,15,38,19,8,33,4,45,16,39,26,22,32,13,44,17,27,23,12,37,24,20,30,3,36,25,21,31,2,43,6 },
	{ 34,13,7,45,4,39,8,36,3,40,16,35,28,31,5,9,37,27,41,0,29,32,30,20,23,26,1,19,33,14,21,46,22,10,25,42,18,15,12,6,44,11,38,24,43,2,17 },
	{ 36,6,11,13,0,14,40,27,20,35,30,19,38,43,5,24,45,32,46,2,29,9,22,10,12,16,37,7,26,21,34,1,15,41,42,4,25,44,31,18,39,8,23,33,3,28,17 },
	{ 34,17,41,11,4,31,39,20,32,2,9,18,46,29,37,7,0,27,35,16,44,14,5,30,42,25,33,3,12,23,28,40,10,1,26,38,21,45,15,8,19,43,24,36,6,13,22 },
},
{
	/* Frame 202 */
	{ 28,10,32,5,18,23,11,14,33,44,22,17,42,15,8,45,16,21,43,38,9,12,27,20,2,39,40,13,26,31,3,6,41,36,30,25,34,7,0,37,24,29,35,46,1,4,19 },
	{ 21,11,38,41,0,31,22,10,3,40,33,23,24,43,2,13,32,25,16,42,35,12,5,26,17,15,34,45,4,27,18,14,7,44,37,19,28,6,9,36,29,20,46,39,8,1,30 },
	{ 22,17,19,38,30,36,8,35,27,46,7,16,43,18,15,37,29,34,26,32,6,45,4,42,3,14,28,11,33,25,44,5,2,41,0,13,10,24,21,23,40,1,12,39,31,9,20 },
	{ 2,23,12,19,0,21,46,17,34,22,44,18,7,32,20,11,16,5,35,9,45,6,33,10,31,4,27,8,29,38,25,42,30,36,26,15,40,28,3,39,24,13,43,1,37,14,41 },
	{ 45,27,0,40,30,37,25,23,42,32,28,18,21,34,11,16,39,14,9,3,12,6,1,41,31,4,44,26,33,29,19,46,36,24,22,43,17,38,15,20,35,10,13,7,8,2,5 },
	{ 40,0,42,2,41,1,43,3,17,19,16,18,8,36,10,9,37,11,39,25,27,38,24,26,23,44,4,22,45,5,7,21,46,6,20,32,31,34,12,33,30,35,13,15,29,14,28 },
	{ 36,16,6,10,13,15,0,34,21,27,41,30,43,38,18,5,45,25,28,2,33,23,9,11,12,37,17,7,20,26,40,14,1,35,4,44,24,31,42,39,19,32,22,8,46,29,3 },
	{ 11,20,25,38,3,30,21,8,39,44,18,31,0,9,36,45,19,14,1,28,42,37,6,15,16,29,34,43,7,26,17,12,35,40,22,27,4,13,32,41,23,10,5,24,46,33,2 },
	{ 18,9,5,44,15,46,19,8,41,4,37,6,28,1,40,11,36,7,38,29,0,33,10,43,24,39,20,30,32,3,42,25,21,31,2,35,16,26,22,13,34,17,27,23,12,45,14 },
	{ 35,24,16,29,46,21,13,33,10,19,15,6,30,45,25,42,17,9,4,38,12,11,2,26,41,7,36,31,44,22,43,0,34,8,5,39,28,20,3,32,27,40,18,37,14,23,1 },
	{ 22,12,42,31,5,2,16,11,38,25,14,41,28,7,32,21,18,8,37,27,1,44,43,30,4,34,23,13,10,39,24,3,46,17,6,33,20,15,40,29,26,0,45,19,9,36,35 },
	{ 40,26,21,3,46,12,37,27,20,2,43,9,36,22,17,15,42,8,33,23,16,14,39,5,32,18,29,11,38,4,45,19,28,10,35,1,44,30,25,7,34,0,41,31,24,6,13 },
},
{
	/* Frame 203 */
	{ 23,14,16,9,7,32,21,12,2,26,5,42,45,35,31,0,24,22,15,40,38,33,29,19,10,20,13,3,36,43,17,8,6,30,1,46,41,39,27,4,28,18,11,44,34,37,25 },
	{ 36,6,37,39,25,5,27,38,24,4,26,23,3,32,22,2,33,35,21,1,34,20,0,44,19,46,45,18,13,15,17,12,14,16,40,42,41,43,29,9,31,11,28,8,30,10,7 },
	{ 21,7,1,35,30,45,28,10,8,38,23,32,17,3,13,26,41,24,6,4,34,19,44,29,15,9,43,22,37,20,2,0,46,31,40,25,11,5,39,18,33,16,14,12,42,27,36 },
	{ 13,41,19,4,32,26,9,7,0,14,29,38,3,20,10,37,17,23,34,44,24,30,43,5,33,27,12,40,18,1,15,8,6,21,46,11,28,39,2,45,25,31,42,36,16,22,35 },
	{ 9,6,21,0,26,11,28,37,23,35,40,46,1,10,29,12,22,3,16,41,31,32,38,13,2,17,4,30,15,24,33,19,39,44,42,5,14,25,8,18,7,20,45,27,43,36,34 },
	{ 23,19,7,3,43,22,18,6,46,2,42,31,37,27,33,15,11,30,36,26,32,14,10,17,5,45,1,41,20,16,4,44,0,40,21,25,13,39,9,35,28,24,12,38,8,34,29 },
	{ 44,18,37,10,34,20,13,16,9,46,32,6,31,23,2,27,45,19,4,43,28,35,21,0,38,24,17,40,15,33,7,36,11,3,12,5,42,29,8,1,39,25,30,22,41,14,26 },
	{ 29,18,45,5,11,34,12,23,16,30,39,9,32,46,6,21,27,28,37,43,3,44,4,10,25,22,41,1,15,38,8,19,20,26,35,13,36,42,2,17,31,24,33,7,40,0,14 },
	{ 33,9,35,11,25,27,32,8,34,10,24,30,13,45,15,29,31,12,44,14,46,28,1,3,41,17,43,19,0,2,40,16,42,18,5,37,7,39,21,23,4,36,6,38,20,22,26 },
	{ 20,40,7,33,23,10,5,26,34,21,8,24,32,11,45,27,2,9,18,46,25,0,39,16,44,3,37,19,14,1,30,38,17,12,43,28,36,15,41,31,6,13,22,42,29,4,35 },
	{ 33,46,19,12,16,15,2,38,42,21,8,7,11,4,44,34,13,17,30,3,29,0,40,39,43,36,9,22,26,5,25,45,35,32,31,18,28,1,14,41,37,23,27,20,24,6,10 },
	{ 40,8,42,10,25,27,41,9,43,11,24,26,36,12,38,14,29,31,37,13,39,15,28,30,32,0,34,2,17,19,33,1,35,3,16,18,44,4,46,6,21,23,45,5,7,20,22 },
},
{
	/* Frame 204 */
	{ 23,0,40,6,46,16,22,1,41,7,25,31,32,8,38,14,24,30,33,9,39,15,21,19,4,44,2,42,20,18,5,45,3,43,29,27,36,12,34,10,28,26,37,13,35,11,17 },
	{ 23,3,4,41,1,27,14,39,28,25,33,44,19,6,43,20,17,13,36,30,10,35,46,5,8,22,2,15,38,29,40,0,26,7,42,21,24,32,45,18,31,11,34,16,12,37,9 },
	{ 13,44,27,43,8,38,5,36,2,35,0,29,45,26,9,40,21,37,23,34,1,32,28,14,25,41,20,22,17,33,19,15,46,24,10,7,16,18,31,12,11,42,6,39,4,3,30 },
	{ 46,3,25,39,10,16,31,34,5,22,43,12,27,36,9,18,45,0,7,21,40,14,28,33,38,11,17,2,24,23,42,13,30,35,4,19,44,1,26,37,8,15,29,32,6,20,41 },
	{ 23,12,35,18,9,7,44,16,2,41,21,46,27,0,43,30,5,15,32,28,10,37,25,34,19,8,39,22,13,3,40,20,6,45,17,42,31,4,26,1,11,36,24,14,33,29,38 },
	{ 45,5,41,1,20,16,44,4,40,0,21,17,35,13,9,28,38,24,34,12,8,29,39,25,43,3,22,18,46,6,42,2,23,19,7,37,11,33,30,26,14,36,10,32,31,27,15 },
	{ 37,26,24,6,21,43,45,2,17,35,31,32,29,15,27,38,25,11,7,40,4,42,22,3,0,18,33,12,14,39,8,36,10,41,5,23,20,1,44,19,46,16,13,34,30,28,9 },
	{ 19,24,5,46,33,11,6,25,20,34,26,7,12,21,35,40,27,22,13,0,41,36,14,23,28,1,42,37,15,2,29,16,43,38,30,3,8,17,39,44,31,18,9,4,45,32,10 },
	{ 33,7,41,15,23,31,32,6,40,14,22,26,3,39,11,19,27,2,38,10,46,18,5,13,35,21,43,29,4,12,34,20,42,28,1,37,9,45,17,25,0,36,8,44,16,24,30 },
	{ 25,0,34,5,30,39,36,19,10,16,41,15,21,12,46,1,26,35,32,31,6,28,37,11,17,8,42,13,22,44,27,2,24,33,7,29,4,38,9,18,43,40,23,14,20,45,3 },
	{ 29,23,43,38,0,44,10,25,20,19,30,5,34,15,40,37,16,26,39,1,12,11,6,33,21,31,35,46,8,36,2,17,28,27,22,13,42,7,32,45,24,18,9,4,3,14,41 },
	{ 3,33,20,22,8,14,36,29,34,19,1,7,45,24,43,26,12,2,32,17,46,23,5,11,41,28,39,30,0,6,44,21,42,27,9,15,37,16,35,18,4,10,40,25,38,31,13 },
},
{
	/* Frame 205 */
	{ 0,35,7,27,37,9,28,10,18,44,1,20,34,36,29,11,30,19,12,21,2,4,39,42,31,41,13,14,3,22,33,5,24,38,43,40,16,15,23,32,25,6,26,8,17,46,45 },
	{ 35,20,23,5,33,6,34,21,22,4,32,39,11,24,27,37,9,38,10,25,26,36,8,15,43,28,31,13,41,14,42,29,30,12,40,3,16,19,45,1,46,2,17,18,44,0,7 },
	{ 37,35,24,13,22,11,36,34,29,12,27,10,41,39,28,1,26,15,40,38,17,0,31,14,45,43,16,5,30,3,44,42,21,4,19,2,33,20,9,18,7,32,46,25,8,23,6 },
	{ 28,10,23,4,15,41,39,44,29,42,22,5,24,14,19,8,3,45,43,32,25,46,18,9,20,2,31,12,7,33,36,21,34,30,13,16,6,27,0,11,37,35,40,17,38,26,1 },
	{ 25,3,44,0,31,28,37,42,6,17,26,13,32,23,20,11,38,8,18,45,1,14,35,29,7,40,4,27,24,33,46,2,21,30,9,36,43,19,16,15,34,12,22,41,5,10,39 },
	{ 19,1,30,28,22,20,26,8,18,45,0,37,29,39,21,43,25,35,44,17,46,36,13,38,15,5,42,7,24,34,11,16,3,12,14,4,6,41,10,33,2,31,23,40,27,32,9 },
	{ 24,29,43,46,2,7,32,37,28,10,41,6,1,36,11,14,40,45,0,5,19,15,9,44,4,18,23,8,13,22,17,35,12,27,16,21,34,39,26,31,25,42,20,3,38,33,30 },
	{ 7,33,12,27,16,36,35,14,29,18,38,1,45,31,20,3,8,22,32,13,10,17,34,15,41,4,19,24,44,43,6,21,26,46,9,37,23,28,11,39,0,30,40,5,2,25,42 },
	{ 10,27,1,20,46,37,11,18,0,25,44,6,19,9,24,34,45,7,30,8,17,35,32,14,31,5,16,42,33,15,22,4,29,43,40,2,23,13,28,38,41,3,26,12,21,39,36 },
	{ 27,39,25,26,38,24,37,11,9,36,10,8,19,17,18,16,43,3,41,1,42,2,40,0,29,15,28,14,35,13,33,30,34,12,32,31,21,7,20,46,6,45,5,22,44,4,23 },
	{ 38,46,27,28,19,37,32,9,30,16,39,34,42,12,18,21,33,31,0,23,35,43,13,2,20,10,44,1,22,25,3,4,11,45,40,6,24,14,5,26,29,41,36,7,8,15,17 },
	{ 32,39,45,10,23,29,1,26,34,40,4,31,3,9,20,42,33,6,12,17,11,22,28,36,35,41,14,19,25,5,30,38,44,43,0,27,7,13,16,46,37,2,8,21,15,18,24 },
},
{
	/* Frame 206 */
	{ 28,4,34,23,27,8,45,16,30,3,38,12,10,7,32,21,24,42,14,19,1,36,35,22,26,46,40,29,5,2,39,9,44,17,31,6,33,20,13,11,18,0,37,25,43,15,41 },
	{ 32,23,29,2,8,5,28,17,46,35,41,4,30,16,11,34,40,37,31,18,10,7,13,36,19,25,43,6,12,1,24,21,42,39,45,0,26,20,15,38,44,33,27,22,14,3,9 },
	{ 41,29,27,34,22,46,1,13,11,6,33,16,45,19,43,31,38,24,5,3,15,8,37,20,35,23,0,40,28,26,7,32,17,12,10,39,25,4,44,18,42,30,9,36,21,2,14 },
	{ 30,33,14,36,29,35,13,24,38,31,0,15,26,37,2,40,25,39,1,20,42,27,4,3,22,41,6,44,21,43,5,16,46,23,8,7,18,45,10,32,17,9,28,34,19,12,11 },
	{ 46,16,29,2,11,38,17,12,3,30,40,4,13,18,31,32,41,43,5,24,19,14,33,35,42,20,25,6,15,34,21,8,7,26,44,0,9,22,27,36,45,1,28,23,10,37,39 },
	{ 41,7,12,39,14,44,3,46,8,35,27,40,22,20,15,2,16,34,11,23,43,21,30,28,17,10,24,42,5,31,37,29,1,18,33,25,4,6,36,13,38,0,45,19,32,9,26 },
	{ 26,15,34,1,21,41,30,18,38,42,5,25,45,32,2,22,46,9,29,16,36,6,10,13,0,20,40,27,14,35,43,4,24,44,31,19,39,8,28,33,3,23,11,12,17,37,7 },
	{ 38,40,44,3,7,9,13,35,39,41,45,2,6,8,12,19,31,25,21,18,30,24,20,42,46,32,36,11,15,1,5,43,33,37,10,14,0,4,27,23,17,29,26,22,16,28,34 },
	{ 2,27,13,16,38,41,3,18,12,29,39,32,14,19,5,28,42,33,15,30,4,21,43,44,6,31,9,20,34,45,7,22,8,25,35,36,10,23,1,24,46,37,11,26,0,17,40 },
	{ 3,30,8,4,39,18,33,14,44,25,21,13,26,6,43,0,35,28,10,40,23,36,17,9,46,5,2,31,45,24,20,38,19,32,15,7,42,1,12,27,41,22,37,16,34,29,11 },
	{ 28,11,36,41,23,18,1,14,34,29,24,4,40,39,19,15,2,45,25,30,5,8,38,43,20,3,44,33,31,26,9,6,42,21,16,12,32,27,7,10,37,17,22,13,0,46,35 },
	{ 38,17,27,41,4,14,3,26,23,40,37,2,24,22,13,36,46,35,25,20,12,1,11,34,21,31,45,0,10,7,30,19,44,33,43,6,28,18,9,32,42,39,29,16,8,5,15 },
},
{
	/* Frame 207 */
	{ 35,42,6,15,3,30,18,27,33,40,5,44,1,20,29,16,25,43,38,14,2,11,26,23,41,4,13,0,9,37,28,24,39,46,34,10,7,22,31,19,12,32,8,36,45,21,17 },
	{ 25,15,27,12,24,14,26,45,44,46,29,3,31,32,28,2,30,33,35,1,34,0,7,19,36,6,18,37,39,5,17,38,4,16,23,9,11,22,8,10,41,21,43,40,20,42,13 },
	{ 29,8,26,7,33,46,16,9,31,6,32,35,17,12,30,11,37,34,20,13,19,10,36,39,21,0,18,15,41,38,24,1,23,14,40,43,25,4,22,3,45,42,28,5,27,2,44 },
	{ 11,28,36,2,21,45,31,42,4,22,35,13,7,16,32,14,25,41,19,38,0,26,9,3,20,44,10,29,37,23,34,12,30,43,5,15,24,40,6,17,33,27,46,8,18,39,1 },
	{ 10,25,32,22,35,12,7,16,37,27,42,9,2,21,44,30,4,11,24,41,23,34,1,14,29,36,18,39,8,3,20,33,31,46,13,6,17,40,26,43,0,15,28,45,19,38,5 },
	{ 7,2,13,8,5,43,0,31,35,26,23,41,18,33,24,16,46,11,38,3,44,9,36,29,1,21,27,14,19,6,25,12,17,4,42,39,30,34,45,22,40,37,28,32,20,15,10 },
	{ 8,22,27,21,25,38,43,37,41,0,15,18,13,17,34,33,46,6,11,5,9,23,39,42,30,2,28,1,14,19,44,35,26,20,24,7,10,36,40,12,16,31,3,29,32,45,4 },
	{ 19,45,16,31,43,28,39,26,1,22,13,11,8,7,4,32,2,44,17,14,42,29,41,38,27,37,24,23,35,20,18,9,30,5,3,0,15,12,40,10,36,25,6,34,21,33,46 },
	{ 17,34,41,3,27,8,16,35,40,2,26,13,29,38,45,7,23,12,28,39,44,6,22,1,25,42,33,11,19,0,24,43,32,10,18,5,21,46,37,15,31,4,20,36,14,30,9 },
	{ 19,15,41,18,14,40,46,21,9,20,8,31,7,33,30,6,32,38,25,1,39,24,0,23,11,45,22,10,44,42,17,13,43,16,12,27,3,37,26,2,36,34,29,5,35,28,4 },
	{ 45,41,44,40,37,33,36,32,23,9,31,17,22,8,30,16,7,24,15,1,6,25,14,0,39,35,43,38,34,46,42,13,19,21,27,12,18,20,26,28,3,5,11,29,2,4,10 },
	{ 38,46,36,44,39,37,45,2,14,0,12,19,31,17,29,3,15,1,13,18,30,16,28,34,42,32,40,35,43,33,41,6,10,4,8,23,27,21,25,7,11,5,9,22,26,20,24 },
},
{
	/* Frame 208 */
	{ 35,38,34,6,30,2,26,7,31,3,27,43,46,42,22,14,18,10,23,15,19,11,33,4,28,32,5,29,0,24,36,1,25,37,41,20,12,40,21,13,16,8,44,17,9,45,39 },
	{ 29,3,8,36,1,40,6,26,20,31,33,42,19,24,38,12,17,11,5,22,44,35,9,37,14,28,2,41,7,27,21,46,0,25,39,13,30,32,43,18,23,45,34,16,10,4,15 },
	{ 23,0,34,13,11,44,7,42,17,28,33,26,8,4,38,18,15,25,46,21,41,2,37,30,35,12,10,22,1,29,32,27,45,6,43,16,39,19,14,9,5,40,3,36,31,24,20 },
	{ 24,32,30,46,17,41,23,39,0,14,9,7,28,44,18,42,21,37,27,35,12,10,5,3,16,40,22,38,25,33,31,8,6,1,15,20,36,26,34,29,45,19,43,4,2,13,11 },
	{ 20,43,33,14,27,4,25,42,32,15,18,13,24,39,41,2,19,12,17,38,40,3,30,1,16,37,10,31,0,29,46,36,11,22,9,28,35,45,6,23,8,21,34,44,7,26,5 },
	{ 2,30,34,27,16,13,8,45,18,40,7,10,39,1,42,21,33,24,3,23,35,26,15,4,9,36,29,41,6,11,38,31,43,20,17,12,22,44,19,14,5,46,0,37,28,32,25 },
	{ 27,4,19,28,11,37,34,42,9,6,0,14,24,39,33,5,2,29,10,20,35,44,7,1,30,25,22,16,40,3,12,26,21,18,45,36,43,31,8,23,17,15,41,38,32,46,13 },
	{ 36,7,19,5,17,39,37,6,18,4,16,42,40,23,11,21,9,43,41,22,10,20,8,46,44,15,27,13,25,45,14,26,12,24,34,32,31,3,29,1,35,33,30,2,28,0,38 },
	{ 25,38,37,7,27,4,24,39,36,6,26,1,21,34,33,3,23,0,20,35,32,2,22,13,17,46,45,15,19,12,16,44,14,18,9,29,42,41,11,31,8,28,43,40,10,30,5 },
	{ 18,42,13,27,35,4,10,17,44,3,24,37,30,38,9,23,0,6,29,40,15,20,33,26,34,5,19,43,12,2,25,36,11,16,45,22,46,1,31,39,8,14,21,32,7,28,41 },
	{ 21,17,20,16,23,19,22,18,35,13,1,46,34,12,0,15,3,44,32,14,2,45,33,29,25,28,24,31,27,30,26,39,43,5,9,38,42,4,8,7,11,36,40,6,10,37,41 },
	{ 41,35,26,5,24,46,12,2,31,32,43,21,9,7,37,18,14,16,40,34,4,25,23,11,45,39,30,1,28,42,8,6,27,36,17,13,3,33,22,10,20,44,38,0,29,19,15 },
},
{
	/* Frame 209 */
	{ 35,5,18,6,41,42,31,24,12,39,32,3,22,17,45,46,9,28,10,36,19,7,0,21,43,13,26,14,33,34,23,16,4,40,11,30,25,37,38,1,20,2,44,27,15,8,29 },
	{ 46,22,45,21,2,1,43,19,36,28,15,8,34,26,33,25,6,5,23,40,16,3,12,38,30,37,29,10,9,35,27,44,20,7,0,42,18,41,17,14,13,39,31,32,24,11,4 },
	{ 10,44,1,22,29,41,46,3,24,31,43,12,32,26,17,14,34,5,19,45,0,7,28,2,36,9,30,21,33,38,11,16,23,35,4,40,18,25,6,42,13,27,37,8,15,20,39 },
	{ 29,34,33,3,31,0,28,35,32,2,30,17,13,46,45,19,15,16,12,44,18,14,9,21,42,41,11,23,8,20,43,40,10,22,25,5,38,37,27,7,24,4,39,36,26,6,1 },
	{ 2,30,36,3,31,37,35,4,24,34,5,25,22,14,40,23,15,41,16,8,46,17,9,6,26,32,7,27,33,39,0,28,38,1,29,18,10,44,19,11,45,43,20,12,42,21,13 },
	{ 38,18,4,9,15,12,2,32,23,24,43,29,40,36,16,7,27,44,30,0,35,21,11,8,14,39,19,5,22,25,42,13,3,33,6,46,26,28,41,37,17,34,20,10,45,31,1 },
	{ 26,18,24,16,27,19,25,17,14,2,12,0,35,45,33,15,3,13,1,46,34,44,32,30,22,28,20,31,23,29,21,10,6,8,4,43,39,41,37,11,7,9,5,42,38,40,36 },
	{ 8,37,28,33,24,21,45,17,41,4,10,38,31,35,26,46,19,43,7,13,9,36,0,20,44,16,14,11,39,30,2,23,18,29,32,25,12,40,5,1,34,27,15,42,6,3,22 },
	{ 12,31,43,29,41,15,13,30,42,28,40,14,36,4,23,21,39,7,37,5,22,20,38,6,44,27,25,11,9,45,26,24,10,46,8,19,17,35,3,33,1,18,16,34,2,32,0 },
	{ 12,40,20,11,39,2,32,25,5,15,42,6,8,45,16,31,34,27,22,46,37,28,1,21,10,38,18,13,41,4,14,3,33,24,44,17,30,43,7,9,36,29,0,35,26,23,19 },
	{ 30,21,9,38,19,37,31,20,35,8,26,36,16,29,34,7,46,27,45,17,28,43,6,33,5,44,24,3,42,15,32,4,25,2,14,41,13,22,11,1,40,12,23,10,0,39,18 },
	{ 0,9,40,5,36,28,45,21,43,3,34,26,19,39,14,22,1,32,24,41,17,37,29,20,12,35,10,18,15,46,6,31,33,25,16,8,4,13,44,11,42,2,27,7,38,30,23 },
},
{
	/* Frame 210 */
	{ 20,34,39,0,13,24,35,6,1,36,30,10,7,32,37,18,31,29,11,46,33,4,19,17,28,42,8,5,16,43,14,9,44,22,2,15,40,45,26,23,21,3,38,41,12,27,25 },
	{ 45,16,42,31,8,3,40,29,35,26,1,6,33,24,38,19,4,11,36,17,43,22,9,14,41,20,46,27,12,7,44,25,39,30,5,2,37,28,34,23,0,15,32,21,18,13,10 },
	{ 16,22,9,32,2,4,11,35,37,17,7,8,41,20,10,13,34,36,43,6,24,15,39,40,21,26,12,19,42,45,25,14,1,38,27,28,18,44,30,0,23,46,33,29,3,5,31 },
	{ 40,11,31,9,29,43,41,10,30,8,28,46,44,27,15,25,13,45,26,14,24,12,34,32,3,23,1,21,35,33,2,22,0,20,38,36,19,7,17,5,39,37,18,6,16,4,42 },
	{ 27,28,21,10,3,45,4,42,22,25,32,15,39,8,1,26,19,20,2,44,37,43,34,13,31,24,17,14,7,41,0,46,18,29,36,11,35,12,5,30,23,16,6,40,33,38,9 },
	{ 0,6,46,26,13,17,38,23,33,10,45,28,43,31,2,5,9,15,40,19,37,20,35,24,27,12,1,7,32,11,44,29,16,39,22,4,8,42,30,3,36,21,34,25,14,41,18 },
	{ 29,21,27,19,28,20,26,18,9,5,15,3,8,4,14,2,40,36,46,34,41,37,35,25,17,31,23,24,16,30,22,13,1,11,7,12,0,10,6,44,32,42,38,45,33,43,39 },
	{ 25,45,7,14,42,17,12,6,41,11,4,13,39,40,3,10,30,5,38,9,2,22,31,36,1,8,35,23,37,26,0,34,28,18,27,33,46,20,29,24,19,44,32,15,21,43,16 },
	{ 44,19,23,3,41,7,45,18,22,2,40,6,27,31,35,11,39,15,26,30,34,10,38,14,4,17,43,21,1,5,16,42,20,46,0,36,12,25,29,33,9,37,13,24,28,32,8 },
	{ 13,1,31,2,12,0,30,19,29,17,14,18,28,16,15,35,39,33,37,34,38,32,36,9,7,27,5,8,6,26,4,25,23,10,21,24,22,11,20,41,45,40,44,42,46,43,3 },
	{ 42,5,28,15,18,33,43,4,17,14,27,40,38,13,16,3,26,41,39,12,25,2,23,36,46,1,24,11,22,37,0,21,10,31,44,34,9,20,7,30,45,35,8,29,6,19,32 },
	{ 27,46,7,1,28,44,10,23,39,17,33,8,4,42,3,30,24,40,20,36,19,35,15,6,0,13,26,22,38,16,32,29,45,11,2,31,9,5,43,18,34,14,25,41,21,37,12 },
},
{
	/* Frame 211 */
	{ 32,24,15,40,2,5,10,13,35,0,22,43,17,8,38,30,33,25,19,46,20,41,3,27,36,28,11,44,6,1,14,9,39,4,18,21,12,34,26,37,29,23,42,16,45,7,31 },
	{ 20,15,23,45,10,40,43,28,39,31,36,34,26,1,2,14,44,9,17,42,18,38,30,5,6,0,25,3,33,13,21,46,22,8,16,11,19,41,4,29,7,37,24,35,27,32,12 },
	{ 8,7,35,28,10,36,1,30,21,41,38,3,24,23,4,32,26,17,6,34,13,19,37,0,15,43,20,2,44,9,22,29,33,46,11,16,31,12,40,39,18,25,14,42,5,27,45 },
	{ 46,11,12,40,14,24,26,5,33,7,35,36,17,19,28,30,42,45,8,10,21,23,1,38,3,4,32,6,16,18,13,41,15,43,44,25,27,20,22,34,37,0,39,2,29,31,9 },
	{ 37,30,2,36,31,3,25,5,35,24,4,34,45,18,10,44,19,11,21,13,43,20,12,42,33,26,6,32,27,7,29,1,39,28,0,38,41,22,14,40,23,15,17,9,16,8,46 },
	{ 17,12,41,46,11,6,35,31,16,45,40,5,10,39,34,30,44,9,4,33,38,3,23,8,37,32,28,2,27,22,36,1,29,21,26,15,0,20,19,14,43,24,13,18,42,7,25 },
	{ 23,4,15,38,28,2,41,1,26,25,7,44,16,31,8,33,42,22,21,14,39,13,36,19,0,11,34,24,6,45,5,30,29,43,3,40,20,27,12,37,46,18,17,10,35,9,32 },
	{ 38,45,29,5,31,7,12,34,40,43,0,27,3,9,16,37,39,44,21,14,23,28,4,30,32,35,41,10,19,25,1,26,46,36,6,13,20,15,22,42,33,2,8,17,11,18,24 },
	{ 39,24,43,4,45,19,31,25,46,5,18,30,6,0,12,27,7,32,1,13,26,2,33,14,8,21,34,3,36,15,40,9,20,35,28,37,10,41,23,17,38,29,42,11,44,22,16 },
	{ 12,30,36,9,27,0,22,5,19,42,24,35,14,29,38,11,16,41,2,21,44,7,37,8,26,32,13,31,4,18,43,1,23,46,28,39,10,25,34,15,20,45,6,17,40,3,33 },
	{ 8,27,45,16,2,1,28,42,15,41,13,23,21,35,24,10,9,38,18,36,17,3,31,29,43,6,32,4,22,46,26,44,25,11,0,39,19,37,14,40,12,30,20,34,7,33,5 },
	{ 33,11,35,25,32,10,34,24,26,9,27,8,15,29,46,14,28,30,45,13,31,44,12,43,1,3,42,0,2,16,41,18,17,40,19,37,5,39,7,36,4,38,6,20,22,21,23 },
},
{
	/* Frame 212 */
	{ 27,0,12,6,10,16,28,22,26,1,13,7,11,17,29,32,40,38,46,33,41,39,19,31,4,8,2,14,20,24,18,30,5,9,3,15,21,25,36,44,34,42,37,45,35,43,23 },
	{ 5,30,8,21,12,24,38,28,43,15,36,31,32,13,39,29,2,46,18,37,33,44,40,3,19,10,1,26,45,17,41,34,6,11,22,0,27,4,16,9,20,35,25,7,42,23,14 },
	{ 16,28,25,32,2,30,27,38,35,17,13,24,15,26,23,34,12,9,5,45,14,11,22,19,8,4,1,44,41,37,10,7,18,46,43,20,0,29,40,36,33,6,3,31,42,39,21 },
	{ 44,1,2,12,23,16,38,11,5,41,6,25,26,28,32,15,35,45,0,19,21,22,42,36,9,39,10,4,31,24,46,3,13,33,14,17,18,20,40,7,43,37,8,27,29,30,34 },
	{ 22,32,17,39,41,15,8,2,19,5,20,34,26,44,29,43,33,7,0,14,31,9,24,46,18,36,21,35,45,11,12,6,23,1,16,38,30,40,25,37,3,4,10,27,13,28,42 },
	{ 38,3,30,24,20,41,2,31,25,21,40,13,26,22,16,45,12,33,27,23,42,17,44,9,32,5,18,43,14,35,8,37,4,19,46,15,34,7,36,1,28,10,39,6,0,29,11 },
	{ 28,7,40,33,31,18,5,10,34,29,16,8,32,19,11,2,45,17,26,9,0,46,39,24,3,44,37,27,22,1,14,38,25,20,12,36,43,23,15,6,41,21,30,13,4,42,35 },
	{ 5,9,32,2,31,16,36,8,7,35,17,12,37,41,6,11,34,13,18,40,39,10,20,24,44,19,15,38,43,21,25,22,45,14,1,42,23,26,0,28,27,4,46,33,29,3,30 },
	{ 6,43,0,12,27,34,7,46,1,40,13,26,35,24,4,41,19,31,38,25,32,5,44,18,30,39,28,33,10,45,23,17,29,36,11,22,16,2,37,14,8,21,3,42,15,9,20 },
	{ 13,11,7,0,12,10,6,33,45,43,39,32,44,42,38,17,21,27,31,16,20,26,30,9,5,3,15,8,4,2,14,41,37,35,40,36,34,46,25,29,19,23,24,28,18,22,1 },
	{ 30,12,11,36,16,35,23,5,14,41,29,46,18,0,7,44,24,43,31,13,2,37,17,34,26,8,15,32,20,39,19,1,10,45,25,42,22,4,3,40,28,27,9,6,33,21,38 },
	{ 42,1,40,23,37,4,24,32,15,13,43,16,41,2,5,38,25,33,27,28,17,3,20,39,6,26,34,29,31,18,21,7,10,35,8,46,30,44,19,0,22,36,11,9,14,45,12 },
},
{
	/* Frame 213 */
	{ 31,13,11,14,16,37,34,7,42,15,41,17,20,35,38,0,24,43,46,40,45,21,18,39,1,4,25,28,26,8,44,19,22,32,5,2,29,27,30,9,12,10,23,33,36,3,6 },
	{ 44,28,14,8,43,27,41,25,7,5,38,18,32,16,2,12,31,45,29,11,9,42,22,36,20,6,0,35,19,33,17,15,13,46,26,40,24,10,4,39,23,37,21,3,1,34,30 },
	{ 24,13,10,23,36,35,9,12,19,22,32,37,8,21,18,7,33,46,17,20,3,6,42,16,5,2,31,44,43,1,4,27,30,40,45,0,29,26,15,41,38,25,28,11,14,34,39 },
	{ 0,28,3,31,32,35,1,29,2,30,33,38,4,24,7,27,36,39,5,25,6,26,37,42,8,20,11,23,40,43,9,21,10,22,41,46,12,16,15,19,44,13,17,14,18,45,34 },
	{ 33,3,31,1,29,34,32,2,30,0,28,35,45,23,15,21,13,46,44,22,14,20,12,37,7,27,5,25,38,36,6,26,4,24,39,41,19,11,17,9,42,40,18,10,16,8,43 },
	{ 39,25,26,4,23,40,0,19,33,28,34,31,12,24,36,27,8,5,42,6,41,20,1,2,16,44,35,14,13,37,10,38,9,43,7,21,22,3,46,17,45,18,15,32,29,30,11 },
	{ 2,26,4,28,35,37,3,27,5,29,34,36,22,10,16,12,43,45,23,11,17,13,42,44,6,30,0,24,39,33,7,31,1,25,38,32,18,14,20,8,41,19,15,21,9,46,40 },
	{ 21,25,22,46,40,28,0,30,35,5,9,6,43,44,17,14,18,39,32,24,23,26,41,1,31,2,12,36,7,10,20,45,15,19,29,33,34,27,4,8,42,3,13,16,37,38,11 },
	{ 41,29,9,27,15,40,46,28,8,26,14,33,39,17,1,23,7,32,38,16,0,22,6,45,43,25,13,31,11,44,42,24,12,30,10,37,35,21,5,19,3,36,34,20,4,18,2 },
	{ 27,15,35,10,23,18,43,6,25,37,12,33,8,45,16,41,20,30,11,38,19,7,46,2,13,9,29,17,4,0,31,26,39,14,34,22,3,42,24,36,28,32,5,44,1,40,21 },
	{ 9,45,20,39,16,42,27,6,36,3,40,25,13,1,10,30,19,8,44,29,38,17,35,5,15,2,33,22,12,0,21,46,31,43,26,7,37,28,41,24,34,4,14,11,32,23,18 },
	{ 42,38,11,2,30,7,27,37,41,32,1,12,20,24,17,43,34,39,3,31,22,26,19,14,33,44,13,4,8,16,29,35,46,23,10,18,15,6,45,36,40,5,9,0,28,21,25 },
},
{
	/* Frame 214 */
	{ 12,26,40,39,17,34,22,14,9,5,18,0,46,29,11,37,6,32,20,25,44,43,31,41,38,16,3,13,27,8,4,35,23,15,28,10,36,19,1,24,45,42,30,7,33,21,2 },
	{ 22,8,14,44,21,42,27,13,7,41,16,35,30,4,2,32,29,38,23,1,15,37,24,43,18,12,10,40,17,46,31,9,3,45,20,39,26,0,6,36,25,34,19,5,11,33,28 },
	{ 35,23,16,12,27,36,19,7,43,8,29,32,3,45,15,25,4,41,11,30,38,0,21,13,26,37,34,22,17,46,9,28,33,18,6,42,24,5,2,44,14,39,1,20,40,10,31 },
	{ 28,10,30,40,42,9,29,11,31,41,43,12,24,14,26,44,46,13,25,15,27,45,0,20,2,22,32,34,1,21,3,23,33,35,4,16,6,18,36,38,5,17,7,19,37,39,8 },
	{ 23,29,30,45,5,46,6,12,27,16,3,9,32,10,35,21,22,28,37,15,38,44,4,19,25,26,41,1,42,2,8,31,20,7,13,36,14,39,17,18,24,33,11,34,40,0,43 },
	{ 11,39,8,36,14,13,33,31,19,1,44,22,42,21,41,6,10,9,37,27,29,30,34,18,46,17,45,2,20,7,4,25,26,38,28,15,35,12,32,16,3,0,23,43,5,40,24 },
	{ 1,25,3,27,0,24,2,26,32,34,33,35,21,9,23,11,20,8,22,10,40,42,41,43,5,29,7,31,4,28,6,30,36,38,37,39,17,13,19,15,16,12,18,14,44,46,45 },
	{ 5,3,7,17,21,19,23,0,4,2,6,16,20,18,22,33,35,45,32,46,34,44,11,15,24,28,27,31,9,13,10,14,25,29,26,30,8,12,43,37,39,41,42,36,38,40,1 },
	{ 33,35,29,1,31,3,32,34,28,0,30,2,41,43,17,9,19,11,40,42,16,8,18,10,37,39,25,5,27,7,36,38,24,4,26,6,45,21,13,23,15,44,46,20,12,22,14 },
	{ 22,10,5,40,43,31,2,28,35,23,26,4,41,44,42,18,29,1,34,39,27,20,24,45,46,19,12,0,15,38,33,21,25,7,13,16,14,32,37,8,6,11,17,30,3,36,9 },
	{ 15,4,19,38,24,41,2,1,30,29,44,7,8,27,42,20,33,14,13,18,39,17,36,11,0,23,34,28,45,6,5,26,43,25,40,3,12,31,46,16,37,10,9,22,35,21,32 },
	{ 4,9,43,19,30,6,44,25,1,35,46,22,10,36,41,17,28,38,26,2,33,13,20,8,42,18,15,5,24,0,34,31,7,45,40,16,29,23,11,37,32,12,21,39,27,3,14 },
},
{
	/* Frame 215 */
	{ 20,13,41,28,38,34,46,19,42,23,4,27,32,31,37,12,17,40,45,39,25,3,7,18,11,22,15,26,1,30,36,16,9,21,44,24,2,29,6,35,10,14,43,0,5,33,8 },
	{ 20,5,23,6,0,3,33,45,15,28,40,43,25,8,26,4,7,37,35,17,32,18,44,29,12,30,42,9,27,10,39,21,36,22,34,16,1,19,2,46,13,31,14,41,11,24,38 },
	{ 39,8,29,18,15,33,43,38,17,28,3,14,42,16,13,2,23,36,1,12,27,22,40,37,0,21,26,7,41,35,46,25,20,11,6,34,24,5,10,31,44,9,4,19,30,32,45 },
	{ 24,40,10,12,23,21,45,3,1,18,38,28,36,6,8,27,43,25,41,15,13,22,34,16,32,2,4,31,39,29,37,11,9,26,46,20,44,14,0,19,35,17,33,7,5,30,42 },
	{ 27,7,36,38,24,4,26,6,37,39,25,5,23,15,44,46,20,12,22,14,45,21,13,31,3,32,34,28,0,30,2,33,35,29,1,19,11,40,42,16,8,18,10,41,43,17,9 },
	{ 36,26,19,42,12,35,5,38,8,1,14,7,41,31,10,44,3,37,27,29,20,43,13,25,46,16,39,9,32,22,15,18,11,45,34,4,28,21,0,24,17,6,40,30,33,23,2 },
	{ 35,31,36,8,23,46,0,38,10,13,2,5,15,28,7,20,45,30,37,25,22,17,40,39,27,32,12,19,42,4,34,14,9,6,1,11,24,3,16,41,26,33,29,18,43,21,44 },
	{ 29,0,44,14,39,19,43,13,34,37,17,8,31,32,22,3,46,26,28,20,1,45,25,15,6,40,10,35,4,9,33,23,27,38,18,21,42,12,24,36,16,7,41,30,11,2,5 },
	{ 29,0,27,6,41,16,1,30,7,40,46,17,12,31,2,37,43,20,13,18,3,36,42,21,8,19,14,33,39,24,9,22,15,32,38,25,4,23,10,45,35,28,5,26,11,44,34 },
	{ 43,16,40,19,10,1,24,34,27,33,13,46,45,22,4,7,30,17,8,11,25,35,32,2,20,44,23,14,5,28,38,31,37,9,42,41,18,0,3,26,21,12,15,29,39,36,6 },
	{ 46,14,26,31,42,10,15,27,30,43,11,6,18,32,23,36,2,7,19,33,22,37,3,24,28,40,8,44,12,25,29,41,9,45,13,38,16,20,0,34,4,39,17,21,1,35,5 },
	{ 35,45,33,34,44,32,46,5,13,23,31,4,12,22,30,20,28,7,15,21,29,6,14,37,43,41,36,42,40,39,38,3,11,1,9,2,10,0,8,18,26,16,24,19,27,17,25 },
},
{
	/* Frame 216 */
	{ 4,10,1,46,5,11,32,14,36,42,33,15,37,43,16,24,20,28,17,25,21,29,39,8,2,12,38,9,3,13,6,40,34,44,7,41,35,45,18,26,19,27,22,30,23,31,0 },
	{ 3,14,10,24,1,12,23,41,34,38,21,11,0,36,22,9,18,35,31,39,20,42,46,29,37,8,19,44,30,7,26,43,17,28,5,32,45,6,27,2,16,15,4,25,33,13,40 },
	{ 35,29,16,37,40,22,10,19,13,24,6,32,46,3,43,5,8,30,39,27,20,44,0,14,41,23,11,34,28,17,36,25,7,33,18,12,9,31,2,42,4,45,1,15,38,26,21 },
	{ 26,34,25,33,6,5,23,39,16,40,11,12,30,46,29,45,2,1,27,35,20,36,7,8,18,42,17,41,14,13,31,24,32,3,4,22,38,21,37,10,9,19,43,28,44,15,0 },
	{ 38,22,37,21,15,12,19,32,16,2,1,42,26,41,25,7,4,39,31,44,28,14,13,34,18,33,17,11,8,43,23,36,20,6,5,46,30,45,29,3,0,35,27,40,24,10,9 },
	{ 8,46,1,39,29,20,13,27,44,18,37,15,6,30,41,25,16,9,43,4,34,28,11,2,26,45,23,32,14,7,0,38,24,21,12,42,5,35,19,36,10,3,31,40,22,33,17 },
	{ 0,35,15,45,7,26,37,9,18,42,1,28,34,20,44,27,36,19,10,29,2,21,12,4,39,11,41,3,30,33,13,22,46,5,24,38,16,40,31,32,23,14,25,6,17,8,43 },
	{ 43,7,35,31,23,14,42,6,34,30,22,1,39,24,17,9,46,0,38,25,16,8,5,33,28,21,13,41,4,32,29,20,12,40,37,11,3,27,45,19,36,10,2,26,44,18,15 },
	{ 29,4,19,10,45,35,16,5,22,11,44,34,17,8,23,14,33,39,20,9,26,15,32,38,21,12,27,2,37,43,24,13,30,3,36,42,25,0,31,6,41,28,1,18,7,40,46 },
	{ 38,33,44,30,5,2,15,25,28,19,39,0,45,34,14,40,29,18,23,1,12,11,16,35,46,41,36,22,13,10,7,17,20,27,8,37,42,6,32,21,26,31,9,4,3,24,43 },
	{ 40,26,10,24,8,43,41,27,11,25,9,42,32,22,2,20,0,35,33,23,3,21,1,34,44,30,14,28,12,45,31,15,29,13,46,36,18,6,16,4,39,37,19,7,17,5,38 },
	{ 36,43,38,25,3,10,34,13,22,15,37,39,40,18,11,0,35,23,30,21,41,19,26,1,8,32,31,20,29,27,16,9,44,33,46,4,28,6,42,17,24,2,45,5,12,7,14 },
},
{
	/* Frame 217 */
	{ 44,15,0,29,43,5,26,6,33,34,16,12,19,39,40,11,22,25,45,46,1,28,2,31,36,7,8,21,35,13,18,14,41,42,24,4,27,32,3,30,17,37,38,9,20,10,23 },
	{ 32,14,34,28,30,13,33,15,35,29,31,8,44,10,46,24,26,9,45,11,25,27,4,40,6,42,20,22,5,41,7,43,21,23,0,36,2,38,16,18,1,37,3,39,17,19,12 },
	{ 14,33,24,42,31,12,3,40,29,22,1,10,45,20,38,27,8,15,36,25,43,18,13,6,41,16,34,23,4,11,32,21,39,30,9,2,37,28,46,19,0,7,44,17,35,26,5 },
	{ 0,28,42,1,29,10,22,32,11,23,33,39,16,12,38,17,13,26,6,44,27,7,45,35,8,20,34,9,21,2,30,40,3,31,41,24,4,46,25,5,18,14,36,19,15,37,43 },
	{ 3,5,44,42,32,38,14,8,2,27,4,29,23,43,17,39,41,26,37,28,22,11,16,13,7,1,40,46,36,34,10,12,6,31,0,25,19,21,35,45,30,33,24,18,15,20,9 },
	{ 2,22,42,24,13,33,40,6,26,46,28,17,37,44,10,30,35,1,21,8,14,19,39,5,25,12,32,3,23,43,29,16,36,41,7,27,34,0,20,45,11,31,18,38,4,9,15 },
	{ 35,44,30,11,4,17,34,7,10,21,16,46,41,6,19,20,1,37,40,23,18,13,0,43,36,22,3,12,25,39,42,15,2,29,24,38,33,14,27,28,9,45,32,31,26,5,8 },
	{ 45,15,12,6,5,38,10,9,19,42,16,35,27,32,24,22,21,44,30,37,29,7,4,41,11,8,2,1,34,14,13,23,46,20,39,31,36,28,18,43,17,40,26,33,25,3,0 },
	{ 11,46,0,35,18,40,15,4,39,22,44,27,24,3,31,43,28,7,10,9,34,19,33,16,13,23,37,20,25,2,1,42,29,41,14,5,38,8,45,26,32,17,12,30,36,21,6 },
	{ 8,39,27,5,6,13,34,14,1,42,18,9,26,7,35,15,43,2,10,22,21,30,29,3,17,11,36,25,23,44,20,31,32,28,40,16,37,24,38,45,4,46,33,12,41,0,19 },
	{ 23,27,35,12,17,15,26,5,34,45,14,18,4,9,44,19,28,37,8,7,11,46,29,1,36,41,6,10,20,0,31,40,39,43,21,24,33,30,3,38,42,25,22,32,2,13,16 },
	{ 34,25,41,3,12,23,39,28,32,10,1,26,46,21,37,15,8,19,35,24,44,6,13,22,42,17,33,11,4,31,20,40,2,9,18,38,29,45,7,0,27,43,16,36,14,5,30 },
},
{
	/* Frame 218 */
	{ 22,10,15,32,45,18,21,11,38,33,12,17,20,42,39,8,13,31,16,43,6,9,36,27,30,2,7,40,37,26,29,3,46,41,4,25,28,34,0,5,23,24,35,14,1,44,19 },
	{ 35,4,45,26,16,15,46,5,36,27,17,6,8,37,18,28,7,38,9,40,19,29,10,39,0,41,30,20,11,42,1,32,31,21,2,43,12,33,22,24,3,34,13,44,23,25,14 },
	{ 38,4,8,1,23,11,18,39,20,9,34,0,6,30,19,21,46,28,35,16,7,44,31,37,2,26,29,17,42,24,45,14,36,3,40,27,33,12,5,43,25,15,22,41,10,32,13 },
	{ 43,32,42,0,20,10,30,1,21,11,31,37,36,46,16,4,26,14,17,5,27,15,41,35,40,34,8,28,2,22,9,29,3,23,45,39,44,38,24,12,18,6,25,13,19,7,33 },
	{ 3,8,6,45,1,31,40,4,26,29,33,42,19,24,36,22,17,11,38,20,14,35,9,7,12,2,41,5,27,44,0,30,25,37,46,23,28,32,43,18,21,15,34,16,10,39,13 },
	{ 4,8,46,30,3,21,44,25,33,14,39,18,43,27,12,1,7,11,34,29,37,16,41,22,31,2,5,9,32,15,38,19,20,45,24,0,6,42,26,13,36,17,40,23,10,35,28 },
	{ 28,40,14,21,33,7,36,8,26,45,1,19,4,30,42,13,23,35,16,38,10,25,3,20,32,6,29,41,15,44,0,18,37,9,27,12,22,34,5,31,43,24,46,2,17,39,11 },
	{ 13,32,41,23,26,5,24,46,33,22,11,20,25,38,3,10,21,8,39,44,2,31,0,9,36,45,19,30,1,28,42,37,18,15,16,29,34,43,7,14,17,12,35,40,6,27,4 },
	{ 5,46,8,37,28,40,7,10,39,30,42,21,16,13,23,45,18,15,4,1,36,29,33,24,3,31,35,26,17,12,9,44,19,41,6,11,38,0,43,20,32,25,2,22,34,27,14 },
	{ 5,26,29,18,20,44,43,7,8,30,17,22,41,32,27,12,19,21,11,45,34,36,42,9,31,0,23,24,15,33,38,46,13,2,4,10,28,35,37,1,6,25,14,16,39,40,3 },
	{ 45,11,30,25,4,35,46,10,7,24,21,40,27,6,1,20,41,36,26,23,0,13,42,37,3,22,17,12,43,38,2,15,16,29,39,32,19,14,9,28,33,44,18,31,8,5,34 },
	{ 40,18,29,11,46,4,37,19,28,10,43,1,36,30,25,7,42,0,33,31,24,6,39,13,32,26,21,3,38,12,45,27,20,2,35,9,44,22,17,15,34,8,41,23,16,14,5 },
},
{
	/* Frame 219 */
	{ 14,9,35,0,22,12,38,26,33,19,42,20,45,3,31,36,24,15,17,40,6,1,29,10,13,39,4,18,43,8,34,30,37,23,46,16,41,7,27,32,28,11,21,44,2,5,25 },
	{ 24,4,26,39,25,5,27,7,36,6,37,34,0,20,35,1,21,3,23,32,2,22,33,12,14,16,13,15,17,44,19,46,45,18,8,28,10,30,9,29,11,31,40,42,41,43,38 },
	{ 36,21,43,26,1,6,41,24,34,31,4,11,32,17,39,22,13,2,37,20,46,27,0,7,44,29,35,18,9,14,33,16,42,23,12,3,40,25,30,5,10,45,28,38,19,8,15 },
	{ 4,1,14,11,37,16,26,39,34,13,40,7,20,25,30,19,0,46,10,36,33,29,23,35,12,9,6,3,45,24,18,42,5,32,15,28,17,22,27,8,38,2,44,41,21,31,43 },
	{ 1,14,21,8,26,3,28,45,23,43,32,38,9,2,29,4,22,11,16,33,31,39,40,46,5,10,17,12,30,7,24,41,19,36,34,13,6,25,0,18,15,20,37,27,35,44,42 },
	{ 26,31,40,45,0,5,34,39,30,9,44,43,4,3,38,8,13,42,2,7,17,12,11,46,6,16,21,10,15,20,19,33,14,24,18,23,32,37,25,28,27,41,22,1,36,35,29 },
	{ 22,42,29,33,26,44,17,7,20,40,3,24,14,5,10,1,23,43,12,38,27,45,8,30,34,21,41,18,36,25,15,28,32,11,16,6,13,39,2,9,31,35,4,46,19,37,0 },
	{ 19,20,10,35,13,36,42,22,17,31,24,33,7,40,0,26,29,2,45,5,11,34,12,23,16,14,39,9,32,46,18,21,27,28,37,43,3,44,4,30,25,6,41,1,15,38,8 },
	{ 45,19,36,10,7,31,40,22,17,8,46,5,35,29,20,3,27,44,18,33,15,6,1,39,25,16,13,43,4,34,28,37,11,2,30,41,23,32,14,9,0,38,24,21,12,42,26 },
	{ 14,41,5,35,13,16,43,7,24,32,15,18,40,26,34,17,42,25,0,19,8,27,2,37,10,45,1,39,9,20,3,28,36,11,22,44,30,38,21,46,29,4,23,12,31,6,33 },
	{ 34,45,18,29,0,31,3,36,41,39,43,20,25,23,27,5,32,35,12,16,14,19,28,1,37,8,6,10,21,24,44,46,33,30,2,13,17,15,40,38,42,22,26,4,9,7,11 },
	{ 40,0,42,2,17,19,41,1,43,3,16,18,36,4,38,6,21,23,37,5,39,7,20,22,32,8,34,10,25,27,33,9,35,11,24,26,44,12,46,14,29,31,45,13,15,28,30 },
},
{
	/* Frame 220 */
	{ 25,23,31,0,8,6,14,16,24,22,30,1,9,7,15,32,44,38,42,33,45,39,43,21,29,19,27,4,12,2,10,20,28,18,26,5,13,3,11,36,40,34,46,37,41,35,17 },
	{ 2,15,16,5,9,34,18,31,37,21,32,25,12,7,11,1,44,28,39,23,43,27,14,17,4,41,3,46,30,36,20,8,35,19,6,10,33,24,13,38,22,42,26,0,45,29,40 },
	{ 38,14,2,11,12,45,17,9,39,30,46,3,34,10,43,28,44,5,8,41,31,22,35,26,42,29,4,37,24,40,1,23,27,18,20,36,25,0,33,6,15,19,21,13,16,32,7 },
	{ 39,42,12,1,7,16,30,27,37,40,46,2,5,28,25,23,43,44,0,6,11,26,21,41,34,4,9,15,24,22,19,45,32,38,10,13,20,17,31,35,36,8,14,3,18,29,33 },
	{ 23,4,43,18,1,15,36,16,10,33,21,38,27,8,35,30,13,7,40,28,2,45,25,42,19,0,22,5,11,32,20,14,37,17,34,31,12,39,26,9,3,44,24,6,41,29,46 },
	{ 44,13,26,22,16,35,12,27,23,17,34,3,30,24,20,39,2,33,31,25,42,21,38,7,32,1,28,43,10,41,6,37,0,29,46,11,40,9,36,5,18,14,45,8,4,19,15 },
	{ 29,0,34,17,14,45,23,10,20,41,27,5,24,39,36,1,30,35,32,15,18,12,46,11,21,8,42,25,6,37,31,2,28,33,19,13,16,44,9,22,43,40,7,26,4,38,3 },
	{ 21,35,40,27,6,13,0,41,36,26,23,28,1,42,37,15,22,29,16,43,38,14,3,8,17,39,44,31,2,9,4,45,32,30,19,24,5,46,33,11,18,25,20,34,10,7,12 },
	{ 39,29,36,14,9,27,34,24,21,6,46,1,41,19,16,13,31,38,28,33,11,8,5,45,23,20,3,43,0,40,18,37,15,12,26,35,25,32,10,7,4,44,22,17,2,42,30 },
	{ 15,2,45,32,46,19,28,5,8,6,43,36,25,23,26,3,12,33,34,29,16,30,9,7,10,37,40,38,27,20,13,0,14,35,44,17,31,18,11,4,41,39,42,21,24,22,1 },
	{ 28,26,17,42,6,33,13,11,24,31,4,2,9,36,22,29,27,38,0,45,43,7,32,20,18,25,34,14,41,5,3,16,23,12,10,39,1,44,30,21,19,46,8,37,35,15,40 },
	{ 11,33,28,30,0,6,36,21,34,27,9,15,45,16,43,18,4,10,32,25,46,31,13,3,41,20,39,22,8,14,44,29,42,19,1,7,37,24,35,26,12,2,40,17,38,23,5 },
},
{
	/* Frame 221 */
	{ 7,11,37,19,28,2,44,20,42,36,41,29,30,3,12,33,21,24,43,4,40,39,16,31,13,32,14,25,22,26,5,8,38,17,0,15,35,23,27,9,6,10,18,1,46,34,45 },
	{ 4,32,7,35,20,23,5,33,6,34,21,18,0,44,3,16,19,1,45,2,46,17,30,12,40,15,43,28,31,13,41,14,42,29,26,8,36,11,39,24,27,9,37,10,38,25,22 },
	{ 46,32,19,6,21,8,33,22,7,24,9,34,36,23,10,25,12,35,37,26,11,28,13,38,40,27,14,29,0,39,41,30,15,16,1,42,44,31,2,17,4,43,45,18,3,20,5 },
	{ 21,35,8,20,34,41,2,30,40,3,31,13,17,39,12,16,38,45,6,26,44,7,27,1,29,43,0,28,42,33,10,22,32,11,23,5,25,4,24,46,37,14,18,36,15,19,9 },
	{ 1,35,11,8,7,4,45,14,33,25,2,21,40,31,36,28,19,46,16,34,26,9,22,43,5,39,15,12,3,0,41,10,37,29,6,17,44,27,32,24,23,42,20,38,30,13,18 },
	{ 3,29,27,20,18,42,44,1,14,25,23,16,38,40,28,10,21,19,12,43,36,34,45,15,24,6,17,30,8,39,32,41,11,4,2,13,26,37,35,7,0,31,9,22,33,46,5 },
	{ 34,39,10,15,24,29,38,33,19,14,9,28,32,37,18,23,8,13,43,36,3,22,17,12,42,2,7,16,21,46,41,27,6,1,20,40,45,26,31,0,5,35,44,11,30,25,4 },
	{ 13,10,38,17,15,41,4,19,24,44,43,6,21,26,9,37,34,23,28,11,39,0,30,40,5,2,46,25,7,33,12,27,16,36,35,14,29,18,1,45,42,31,20,3,8,22,32 },
	{ 27,46,0,6,24,45,30,35,5,15,29,40,23,38,12,10,20,37,18,9,7,17,32,31,42,4,2,28,41,26,39,1,11,25,44,19,34,8,14,16,33,22,43,13,3,21,36 },
	{ 31,13,30,12,15,33,28,35,14,32,29,34,17,19,16,18,41,1,43,3,40,0,42,2,25,27,37,24,26,36,9,39,11,8,38,10,23,45,5,22,44,4,7,20,46,6,21 },
	{ 35,26,13,18,36,8,14,1,38,43,29,3,20,32,45,30,17,22,34,46,12,19,5,11,41,0,7,24,42,2,21,27,44,37,23,9,15,39,4,10,28,40,33,6,25,31,16 },
	{ 32,39,41,14,23,25,1,30,34,44,43,4,27,3,13,20,46,33,6,8,17,15,22,24,36,35,45,10,19,29,5,26,38,40,0,31,7,9,16,42,37,2,12,21,11,18,28 },
},
{
	/* Frame 222 */
	{ 12,34,7,27,21,8,16,14,3,36,22,10,46,29,32,5,24,39,42,19,44,1,31,35,6,26,20,40,13,2,37,9,17,15,28,33,4,23,11,18,45,0,30,25,38,43,41 },
	{ 2,13,36,22,25,3,38,12,41,23,16,14,39,5,40,26,17,15,42,4,33,27,28,6,43,9,32,18,29,7,34,8,45,19,20,10,35,1,44,30,21,11,46,0,37,31,24 },
	{ 5,38,24,43,31,45,19,37,20,8,15,3,26,40,28,0,35,23,10,12,32,17,7,42,30,44,18,4,39,25,14,2,36,21,9,46,1,34,22,27,41,29,33,16,6,11,13 },
	{ 23,9,29,2,22,8,28,35,41,34,40,7,19,13,25,6,18,12,24,39,45,38,44,11,31,1,21,10,30,0,20,43,33,42,32,15,27,5,17,14,26,4,16,37,46,36,3 },
	{ 24,5,10,19,33,46,35,25,20,11,6,34,12,21,26,7,40,13,0,27,22,41,36,43,28,1,14,23,37,42,39,29,16,15,2,38,8,17,30,3,44,9,4,31,18,45,32 },
	{ 15,45,6,36,10,3,33,27,29,5,38,24,42,17,35,8,14,7,37,31,19,26,40,28,46,21,39,12,16,9,0,23,30,44,18,11,41,2,32,20,13,4,25,43,1,34,22 },
	{ 0,36,26,9,45,19,4,42,30,13,35,23,24,10,46,17,3,39,40,28,14,33,21,7,8,44,18,1,37,27,12,34,22,5,43,31,16,2,38,25,11,32,20,6,41,29,15 },
	{ 44,3,7,9,13,35,39,41,45,2,6,8,12,34,38,19,31,25,21,18,30,24,20,32,36,11,15,1,5,43,33,37,10,14,0,4,42,46,27,23,17,29,26,22,16,28,40 },
	{ 27,38,12,14,28,33,30,43,9,7,25,36,23,46,0,2,16,41,18,39,5,15,21,44,31,34,8,10,24,37,26,13,3,29,32,19,42,4,6,20,45,22,35,1,11,17,40 },
	{ 30,1,21,10,45,34,37,16,7,40,46,27,29,43,22,24,32,13,2,5,8,14,38,19,20,11,44,35,31,0,26,28,36,17,6,41,33,12,3,42,23,25,15,39,18,4,9 },
	{ 25,10,5,40,22,0,3,28,31,37,9,38,18,21,14,35,44,24,27,4,41,7,42,17,2,13,32,30,8,39,11,20,23,45,1,46,26,29,6,43,36,16,19,12,33,15,34 },
	{ 38,17,31,45,4,10,3,30,23,44,37,43,2,28,22,9,36,42,35,29,20,8,1,15,34,21,27,41,0,14,7,26,19,40,33,6,24,18,13,32,46,39,25,16,12,5,11 },
},
{
	/* Frame 223 */
	{ 20,42,16,15,38,30,2,27,40,44,23,4,29,0,25,37,43,14,11,39,34,26,7,41,13,22,9,19,28,32,24,36,46,21,10,17,35,6,31,3,12,8,18,45,33,5,1 },
	{ 46,45,13,25,15,27,12,24,14,26,40,42,20,41,43,21,9,23,11,8,22,10,38,4,16,39,5,17,7,19,36,6,18,37,34,0,35,1,3,29,32,31,2,28,33,30,44 },
	{ 24,5,42,44,23,2,29,4,43,45,26,3,28,9,46,32,27,6,17,8,33,30,7,16,13,34,36,31,10,21,12,35,37,18,11,20,1,38,40,19,14,25,0,39,41,22,15 },
	{ 34,40,19,39,20,45,30,7,17,0,10,5,46,36,23,35,24,41,18,3,21,12,6,1,42,32,27,28,37,22,15,25,8,2,13,38,44,31,43,16,33,26,11,29,4,14,9 },
	{ 2,25,40,22,43,4,15,16,45,27,34,1,10,21,36,30,39,12,3,24,33,23,42,9,6,29,44,18,0,11,20,41,31,38,5,14,17,32,26,35,8,7,28,37,19,46,13 },
	{ 10,20,24,23,27,36,40,39,43,2,12,16,15,19,32,35,45,4,8,7,11,21,37,41,29,0,30,3,13,17,46,33,25,22,26,5,9,38,42,14,18,28,1,31,34,44,6 },
	{ 2,46,1,45,35,30,29,19,8,36,42,7,41,20,26,25,14,32,13,3,16,31,4,10,38,9,37,43,22,21,27,0,44,34,15,33,28,18,17,6,40,5,11,39,24,23,12 },
	{ 25,6,21,33,19,45,16,31,43,28,39,26,1,22,34,13,46,11,8,7,4,32,2,44,17,14,29,41,27,37,24,23,35,20,18,9,30,42,5,38,3,0,15,12,40,10,36 },
	{ 11,20,40,22,46,12,14,29,33,31,35,5,7,24,36,26,42,8,10,17,45,19,1,3,28,32,30,38,4,6,21,41,23,43,13,15,16,44,18,34,0,2,25,37,27,39,9 },
	{ 9,21,8,20,46,40,15,19,41,14,18,29,5,35,28,4,34,36,27,3,37,26,2,13,17,43,12,16,42,44,11,23,45,10,22,25,1,39,24,0,38,32,31,7,33,30,6 },
	{ 44,40,36,32,45,41,37,33,22,8,30,16,6,25,14,0,23,9,31,17,7,24,15,1,38,34,46,42,39,35,43,12,18,20,26,29,2,4,10,13,19,21,27,28,3,5,11 },
	{ 38,42,36,40,39,43,37,41,2,10,0,8,19,27,17,25,3,11,1,9,18,26,16,24,34,46,32,44,35,33,45,6,14,4,12,23,31,21,29,7,15,5,13,22,30,20,28 },
},
{
	/* Frame 224 */
	{ 35,43,38,46,34,42,6,14,2,10,7,15,3,11,28,29,22,24,18,23,25,19,33,41,4,12,32,40,5,13,0,8,36,44,1,9,37,45,20,21,16,30,26,17,31,27,39 },
	{ 23,36,41,16,3,28,15,5,18,8,35,38,25,10,33,30,45,20,7,42,0,12,27,40,17,2,29,22,37,9,34,14,4,19,32,31,44,21,39,24,11,1,13,26,6,43,46 },
	{ 15,38,18,4,8,37,30,41,2,46,21,25,1,22,10,35,12,43,16,45,6,32,27,29,5,9,14,39,19,20,24,36,31,40,3,11,34,13,0,23,33,26,28,42,17,44,7 },
	{ 17,8,34,13,22,39,44,19,10,24,33,15,21,4,46,9,26,35,40,23,6,28,45,11,25,0,42,5,30,36,27,2,16,41,7,29,12,38,1,18,43,32,31,14,20,37,3 },
	{ 20,35,41,6,27,12,25,34,40,7,18,5,24,33,10,19,4,17,46,32,11,30,9,16,39,45,2,31,8,29,38,44,3,22,1,28,43,37,14,23,0,21,42,36,15,26,13 },
	{ 6,46,5,45,19,16,3,31,38,28,37,11,8,26,35,23,20,7,43,0,40,18,15,12,30,39,25,32,10,9,4,44,22,17,2,42,1,41,29,36,14,13,27,34,24,33,21 },
	{ 1,12,43,38,32,29,26,3,14,8,37,34,31,25,20,13,10,39,33,44,27,22,16,15,9,4,35,46,40,21,18,11,6,0,45,42,23,17,28,5,2,41,36,19,30,24,7 },
	{ 15,27,13,25,45,14,26,12,24,46,32,31,3,29,1,35,33,30,2,28,0,34,36,7,19,5,17,39,37,6,18,4,16,38,40,23,11,21,9,43,41,22,10,20,8,42,44 },
	{ 15,28,36,22,42,0,10,21,45,31,39,9,3,16,40,26,46,4,14,25,33,19,43,13,7,20,44,30,34,8,2,29,37,23,1,11,24,32,18,38,12,6,17,41,27,35,5 },
	{ 4,40,27,13,33,18,8,7,1,14,28,38,11,21,2,44,16,31,42,37,25,22,35,12,32,19,5,41,26,0,15,9,6,20,46,3,29,39,10,36,24,23,34,45,17,30,43 },
	{ 20,16,22,18,21,17,23,19,46,34,12,0,14,2,45,33,35,13,1,15,3,44,32,28,24,30,26,29,25,31,27,38,42,4,8,6,10,37,41,39,43,5,9,7,11,36,40 },
	{ 45,35,30,5,28,42,8,2,27,32,21,13,7,37,18,10,16,44,34,4,29,23,15,41,39,26,1,24,46,12,6,31,36,43,17,9,3,33,22,14,20,40,38,0,25,19,11 },
},
{
	/* Frame 225 */
	{ 2,45,20,34,23,8,15,40,29,18,1,6,33,24,38,27,12,3,44,17,35,22,5,10,37,28,42,31,0,7,32,21,39,26,9,14,41,16,46,19,4,11,36,25,43,30,13 },
	{ 25,4,18,15,9,34,37,27,6,0,28,11,44,39,33,21,2,30,24,5,46,40,35,23,17,12,26,7,1,42,45,19,14,8,20,3,36,41,29,10,22,16,13,38,32,43,31 },
	{ 40,38,42,5,9,7,11,37,41,39,43,4,8,6,10,21,25,23,27,20,24,22,26,44,32,46,34,13,1,15,3,45,33,35,12,0,14,2,29,17,31,19,28,16,30,18,36 },
	{ 33,2,16,30,42,4,40,27,1,15,35,29,18,37,8,6,20,46,3,44,17,31,5,41,39,10,24,22,34,12,32,19,9,7,43,21,26,45,0,14,28,38,11,36,25,23,13 },
	{ 10,4,3,13,14,43,24,7,34,17,18,20,40,38,27,29,33,30,44,8,23,37,1,2,12,11,5,6,35,16,15,42,25,39,26,28,32,46,19,21,41,22,36,0,31,45,9 },
	{ 28,20,29,21,26,18,27,19,8,4,46,34,9,5,35,41,37,14,2,40,36,15,3,24,16,25,17,30,22,31,23,12,0,42,38,13,1,43,39,45,33,10,6,44,32,11,7 },
	{ 42,34,40,32,43,35,41,33,12,18,30,16,29,2,14,0,13,19,31,17,28,3,15,1,44,36,46,38,45,37,39,26,4,24,22,10,21,8,6,27,5,25,23,11,20,9,7 },
	{ 38,43,37,41,39,42,36,40,29,21,14,6,13,5,31,23,28,20,15,7,12,4,30,22,46,45,35,33,44,34,32,27,19,25,17,11,3,9,1,26,18,24,16,10,2,8,0 },
	{ 29,33,24,12,17,41,5,0,14,11,39,30,34,23,18,42,9,37,28,32,21,45,16,40,4,27,15,10,6,3,22,25,13,8,36,1,20,44,38,31,35,26,46,19,43,7,2 },
	{ 26,7,32,29,17,27,6,28,24,5,15,46,3,25,4,45,14,39,2,43,22,13,44,1,38,11,42,23,12,37,0,41,10,35,30,18,36,9,40,21,34,31,19,8,33,20,16 },
	{ 42,25,32,18,30,39,20,36,8,3,15,12,23,40,26,35,16,28,44,6,11,1,19,31,38,5,43,24,33,2,14,21,37,9,27,34,17,46,13,22,41,10,0,29,45,7,4 },
	{ 39,14,13,11,32,24,27,7,20,23,0,18,40,15,36,28,31,33,25,34,26,8,4,22,44,1,42,2,41,17,37,29,38,30,12,35,10,9,5,46,6,45,21,43,3,16,19 },
},
{
	/* Frame 226 */
	{ 36,23,17,14,35,8,33,22,16,15,46,13,32,27,21,2,12,45,26,20,3,42,1,44,31,25,6,43,0,41,30,24,7,38,5,40,19,29,10,39,4,37,18,28,11,34,9 },
	{ 22,42,21,9,34,27,1,19,15,12,7,4,10,45,2,37,28,43,20,40,35,26,32,25,18,46,17,13,38,31,5,23,11,8,3,0,14,41,6,33,24,16,44,39,30,36,29 },
	{ 3,30,16,29,2,31,17,13,19,15,1,12,18,14,0,35,34,45,33,44,46,32,7,24,20,26,6,25,21,27,23,9,5,11,22,8,4,10,39,38,41,37,43,40,36,42,28 },
	{ 3,37,0,23,20,40,10,25,30,34,5,33,19,16,15,43,12,26,36,1,6,21,46,11,45,8,31,28,32,39,2,17,22,42,13,41,27,24,7,35,4,18,44,9,14,29,38 },
	{ 12,3,14,16,18,38,41,36,13,35,15,17,20,19,22,8,37,10,34,32,21,23,9,4,11,6,24,26,46,33,44,5,43,7,25,28,27,30,0,45,2,42,39,40,29,31,1 },
	{ 24,8,46,25,9,31,15,41,30,14,40,39,20,0,38,21,1,19,7,33,18,6,32,43,28,12,42,29,13,27,11,45,26,10,44,35,16,4,34,17,5,23,3,37,22,2,36 },
	{ 39,43,35,46,38,42,34,25,23,13,19,24,22,12,18,9,7,28,3,8,6,29,2,45,37,44,36,41,33,40,32,31,17,27,5,30,16,26,4,15,1,11,20,14,0,10,21 },
	{ 43,40,17,28,2,46,44,21,9,7,35,32,13,18,30,38,36,25,23,10,41,29,3,15,0,45,6,26,4,33,42,19,31,16,37,11,20,8,34,14,1,12,39,27,5,24,22 },
	{ 39,36,14,23,13,20,30,35,32,42,19,9,16,26,2,46,45,6,29,5,15,22,12,41,34,25,1,11,18,8,38,37,44,21,31,7,28,4,33,43,40,17,27,3,24,0,10 },
	{ 42,2,16,18,41,1,43,3,17,19,40,4,36,6,38,20,22,5,37,7,39,21,23,10,32,24,34,26,9,11,33,25,35,27,8,14,46,28,30,13,45,15,29,31,12,44,0 },
	{ 24,22,32,29,42,19,4,14,1,11,45,20,35,30,40,17,38,27,12,2,9,7,33,28,43,18,36,25,46,23,0,10,5,15,41,16,39,26,44,21,34,31,8,6,13,3,37 },
	{ 4,42,3,30,24,34,20,19,41,15,37,12,27,46,7,1,28,38,10,32,23,45,17,2,31,9,5,43,18,40,14,36,25,35,21,6,0,13,26,22,44,16,29,39,11,33,8 },
},
{
	/* Frame 227 */
	{ 8,42,30,45,17,6,1,27,40,28,3,4,38,18,33,25,14,9,35,23,36,16,11,12,46,26,41,21,2,5,43,31,44,24,7,0,34,22,37,29,10,13,39,19,32,20,15 },
	{ 2,44,10,5,35,20,29,33,46,40,38,1,23,16,31,25,45,42,4,34,13,19,28,27,41,7,0,15,9,22,30,24,43,36,3,12,11,18,26,21,6,32,14,8,39,17,37 },
	{ 11,44,40,43,13,9,14,10,45,41,46,42,12,8,31,27,29,25,30,26,28,24,7,3,36,32,39,35,5,1,6,2,37,33,38,34,4,0,23,19,21,17,22,18,20,16,15 },
	{ 19,6,41,1,28,2,7,43,46,24,29,3,30,36,42,25,12,26,31,32,37,8,13,27,14,33,39,9,20,10,15,35,38,16,21,11,22,44,34,17,4,18,23,40,45,0,5 },
	{ 21,41,14,28,32,7,9,22,0,31,38,25,37,10,16,44,3,5,26,43,12,19,34,29,33,6,20,40,15,1,30,39,8,23,46,17,45,2,24,36,11,13,18,35,4,27,42 },
	{ 29,21,31,23,28,20,30,22,43,39,9,5,11,7,40,36,42,38,8,4,10,6,41,37,25,17,27,19,24,16,26,18,35,13,1,15,3,44,32,46,34,12,0,14,2,45,33 },
	{ 42,37,41,22,13,20,32,18,8,17,39,29,5,15,45,35,24,0,11,36,40,12,21,31,7,16,27,3,38,43,4,14,23,44,34,33,10,19,9,30,6,28,46,26,2,25,1 },
	{ 19,6,3,45,23,41,18,7,2,44,22,40,29,25,37,13,33,9,28,24,36,12,32,8,21,17,46,5,43,1,20,16,4,42,0,27,38,14,35,11,31,26,39,15,34,10,30 },
	{ 13,17,30,35,32,20,25,6,43,40,28,1,14,39,36,9,23,26,44,16,31,2,33,24,7,10,4,41,15,19,12,37,34,22,27,21,45,42,3,29,0,38,11,5,8,46,18 },
	{ 44,7,18,9,24,35,45,6,31,8,17,42,32,15,30,5,16,43,33,14,23,4,29,38,40,3,22,13,28,39,41,2,27,12,21,46,36,11,26,1,20,37,10,19,0,25,34 },
	{ 14,13,44,7,38,20,37,23,27,9,40,10,16,33,3,34,15,46,28,45,31,39,21,22,4,24,41,11,42,17,18,35,0,29,30,12,6,5,36,25,26,43,8,19,1,32,2 },
	{ 37,5,29,36,4,28,20,45,13,21,44,12,43,1,35,25,42,0,34,24,16,9,17,8,15,39,7,46,14,38,6,30,22,31,23,33,11,3,32,10,2,26,41,18,27,40,19 },
},
{
	/* Frame 228 */
	{ 43,17,23,0,44,6,42,16,22,1,45,15,35,25,31,8,36,14,34,24,30,9,37,3,21,19,4,40,2,46,20,18,5,41,11,39,29,27,12,32,10,38,28,26,13,33,7 },
	{ 32,35,13,5,26,39,41,18,42,33,30,34,22,46,27,38,24,19,10,16,31,2,23,14,45,6,25,37,11,17,8,3,28,0,15,20,44,7,36,9,29,1,21,12,4,40,43 },
	{ 3,20,16,6,2,21,17,23,19,5,1,22,18,4,0,39,35,38,34,37,33,36,32,13,9,15,11,12,8,14,10,29,25,31,27,28,24,30,26,45,41,43,44,40,46,42,7 },
	{ 17,12,11,30,37,34,0,13,18,31,41,36,1,20,19,14,40,39,24,21,2,15,43,38,25,4,3,22,45,42,8,5,26,23,33,44,9,28,27,6,32,16,29,10,7,35,46 },
	{ 32,39,23,37,16,11,18,12,29,14,1,38,36,43,19,41,28,15,30,0,25,2,5,42,40,31,45,24,3,26,4,21,6,9,46,44,35,27,33,20,7,22,8,17,10,13,34 },
	{ 29,13,46,44,30,14,28,12,45,31,15,17,5,38,36,18,6,16,4,39,37,19,7,25,9,42,40,26,10,24,8,43,41,27,11,21,1,34,32,22,2,20,0,35,33,23,3 },
	{ 33,42,5,9,0,45,40,23,26,3,43,24,1,29,41,38,27,18,14,25,16,28,21,39,19,15,6,36,46,17,12,20,34,30,7,10,37,32,13,4,8,44,35,31,22,11,2 },
	{ 3,22,14,10,17,41,4,29,24,19,43,7,37,26,32,20,44,38,9,34,23,11,30,5,0,25,12,6,2,27,33,15,21,45,16,40,35,28,46,18,42,31,36,1,13,39,8 },
	{ 41,14,32,39,19,43,29,34,1,44,31,3,46,26,13,4,16,8,15,33,6,18,10,28,35,21,45,25,36,23,40,27,38,5,42,9,0,7,30,11,2,20,12,24,37,17,22 },
	{ 26,8,16,34,40,3,27,9,17,35,41,6,22,12,28,38,44,7,23,13,29,39,45,10,18,0,24,42,32,11,19,1,25,43,33,14,30,4,20,46,36,15,31,5,21,37,2 },
	{ 31,40,25,46,33,6,0,11,26,13,28,43,19,36,21,34,41,14,8,7,22,1,16,39,27,44,29,42,37,2,4,15,30,9,24,23,32,17,38,45,10,12,3,18,5,20,35 },
	{ 46,30,38,19,33,27,28,36,17,9,14,39,6,26,40,29,37,4,24,15,7,10,41,2,5,44,25,0,22,11,3,20,45,12,42,1,34,23,31,18,32,21,13,43,16,35,8 },
},
{
	/* Frame 229 */
	{ 20,42,44,2,5,18,38,21,10,9,26,46,25,3,33,19,6,11,22,8,27,14,24,13,30,32,29,7,37,23,41,15,12,31,0,28,35,16,36,40,43,45,1,34,17,4,39 },
	{ 10,30,16,5,27,46,32,43,25,12,18,7,9,34,45,14,0,20,11,31,36,33,29,2,22,24,13,19,38,40,35,17,4,26,15,1,42,37,6,8,28,3,23,44,39,41,21 },
	{ 15,12,26,1,35,30,5,19,39,16,42,23,41,20,10,46,25,45,14,32,29,3,0,36,7,4,18,9,43,22,13,27,24,34,31,33,28,2,38,17,37,6,40,21,11,8,44 },
	{ 23,13,11,41,28,39,30,0,2,44,21,42,19,9,7,37,24,35,26,12,14,40,17,38,31,5,3,33,20,22,8,10,36,29,34,27,1,15,45,16,43,18,4,6,32,25,46 },
	{ 41,14,19,28,1,39,45,40,31,18,5,0,44,30,3,4,25,42,7,2,21,24,46,43,33,6,27,20,9,37,32,23,26,13,8,36,22,11,12,17,34,15,10,29,16,38,35 },
	{ 29,27,38,41,32,4,43,2,28,17,26,23,9,33,15,42,35,44,16,22,8,1,14,7,25,31,34,45,36,0,6,24,21,30,19,13,37,11,46,39,40,20,18,12,5,10,3 },
	{ 18,22,2,42,6,46,19,23,3,43,7,36,26,30,10,32,14,37,27,31,11,33,15,4,44,16,21,0,40,5,45,17,20,1,41,12,24,34,29,38,8,13,25,35,28,39,9 },
	{ 39,8,31,32,19,20,42,12,9,33,23,18,43,13,34,0,22,10,44,35,4,1,14,11,45,2,5,25,15,6,3,36,29,24,46,7,40,37,26,28,17,38,41,30,27,21,16 },
	{ 45,23,46,12,39,31,5,6,43,9,10,16,3,32,24,15,21,44,22,37,29,38,30,4,41,19,42,8,35,27,1,2,13,14,20,7,36,28,11,17,40,18,33,25,34,26,0 },
	{ 12,25,33,20,44,0,5,14,27,35,30,46,2,7,28,36,8,13,16,40,21,45,1,38,10,15,18,42,23,3,24,32,29,37,9,4,17,41,26,34,31,39,11,6,19,43,22 },
	{ 40,30,44,3,23,43,28,1,5,41,14,45,27,38,22,29,25,20,15,26,39,6,19,46,24,21,17,10,7,34,18,8,12,32,16,36,11,31,35,2,9,42,13,33,0,37,4 },
	{ 41,36,39,5,10,22,24,21,45,33,31,2,28,16,14,37,42,11,23,8,20,27,6,34,46,3,12,0,15,19,43,40,38,9,4,26,7,25,35,44,32,13,1,30,18,29,17 },
},
{
	/* Frame 230 */
	{ 16,8,23,36,27,2,25,14,40,5,39,33,30,12,19,42,21,6,0,44,28,11,9,22,37,26,34,46,17,41,4,3,24,15,13,18,43,20,38,32,31,45,29,10,7,1,35 },
	{ 5,23,15,12,3,0,25,10,21,45,6,33,28,43,16,40,39,26,36,22,46,13,34,31,1,19,11,8,7,4,29,14,17,41,2,37,24,20,44,35,30,32,18,42,9,38,27 },
	{ 21,22,32,25,11,36,29,15,40,16,19,44,0,20,34,23,33,4,24,38,27,37,8,28,31,41,12,42,2,45,1,46,35,6,5,39,26,9,10,30,13,43,14,3,17,18,7 },
	{ 7,32,17,35,30,13,10,41,20,38,23,0,3,44,29,26,9,6,37,16,34,19,12,15,40,25,43,22,5,2,33,28,46,31,8,11,36,21,39,18,1,14,45,24,42,27,4 },
	{ 14,9,37,18,12,42,7,16,27,40,5,22,25,10,38,33,20,31,8,36,3,29,43,6,1,45,26,4,34,15,24,19,39,32,13,30,17,2,46,41,28,23,0,44,11,21,35 },
	{ 11,4,19,2,28,9,26,39,17,33,42,44,3,8,27,14,16,1,22,43,25,45,34,36,15,0,23,6,24,13,30,35,21,37,46,40,7,12,31,10,20,5,18,29,41,38,32 },
	{ 17,19,16,18,1,41,3,43,0,40,2,42,25,37,27,24,36,26,39,9,11,38,8,10,23,5,45,22,4,44,7,20,6,46,21,31,13,30,12,33,15,35,28,32,14,34,29 },
	{ 3,46,26,38,31,42,23,34,1,45,25,36,28,41,21,32,12,18,10,2,15,7,30,16,9,0,44,5,29,40,27,39,19,43,22,35,14,6,24,37,17,8,20,33,13,4,11 },
	{ 31,16,7,9,32,14,21,18,28,37,11,34,44,4,23,25,30,39,41,1,46,6,8,27,20,43,3,13,36,10,17,22,24,33,15,38,40,0,19,29,26,35,45,5,42,2,12 },
	{ 33,25,34,30,12,17,22,39,4,9,14,29,44,1,43,2,21,36,24,35,27,46,13,16,19,40,5,6,11,32,28,45,31,42,3,20,37,23,38,26,8,15,18,41,0,7,10 },
	{ 30,42,1,35,25,12,7,20,36,31,10,41,18,34,13,21,4,11,28,40,19,2,33,26,46,5,39,29,8,3,16,32,27,14,45,22,38,9,43,17,0,15,24,44,23,6,37 },
	{ 34,12,1,27,22,8,17,15,37,43,38,24,21,44,33,31,3,40,4,10,19,28,0,26,7,35,13,16,14,36,42,23,9,32,30,2,39,25,20,45,46,18,29,41,5,11,6 },
},
{
	/* Frame 231 */
	{ 44,9,27,37,22,0,18,5,14,10,25,7,34,16,38,21,45,30,8,26,13,23,32,4,15,42,24,46,29,35,39,20,3,31,40,12,33,36,1,19,43,28,11,6,2,17,41 },
	{ 2,7,42,35,22,27,33,36,9,44,1,24,29,16,21,6,11,46,34,39,26,31,19,37,8,13,0,5,41,28,20,10,15,3,38,43,30,18,23,12,32,4,40,45,25,17,14 },
	{ 5,26,38,24,35,22,33,20,19,17,45,31,40,29,10,8,36,6,4,3,1,34,15,13,18,46,16,43,30,41,28,27,39,25,37,23,32,21,2,0,44,14,12,11,9,42,7 },
	{ 37,31,2,24,13,43,36,18,3,29,12,42,41,19,6,28,1,40,22,7,17,0,46,45,23,10,16,5,35,44,26,11,21,4,34,33,27,14,20,9,39,32,30,15,25,8,38 },
	{ 22,11,36,34,17,12,27,10,37,35,20,13,26,7,32,46,21,8,31,6,33,24,9,30,3,44,42,25,4,19,2,45,43,28,5,18,15,40,38,29,0,23,14,41,39,16,1 },
	{ 31,1,42,2,25,26,39,44,4,19,28,11,34,41,21,22,13,36,14,16,43,3,8,33,27,5,46,6,29,30,35,40,0,23,24,15,38,45,17,18,9,32,10,20,7,12,37 },
	{ 2,45,7,24,37,28,16,46,20,26,38,31,18,23,41,13,33,5,43,14,35,44,6,36,29,9,21,1,30,11,22,40,3,12,32,25,4,42,17,34,27,39,19,8,0,10,15 },
	{ 3,12,33,24,23,43,40,13,0,22,10,41,38,1,30,11,21,8,39,31,19,20,9,6,36,18,29,46,34,7,26,37,28,17,35,44,27,4,16,14,2,45,32,5,25,42,15 },
	{ 13,43,6,17,26,46,41,4,23,24,44,11,39,21,30,9,37,2,28,42,7,0,27,40,5,35,14,25,18,38,33,12,31,16,36,3,29,22,1,45,10,20,34,15,8,19,32 },
	{ 43,19,41,17,2,0,34,22,44,20,15,13,39,31,37,29,10,8,42,26,32,24,3,1,23,45,21,6,4,38,18,40,16,11,9,35,27,33,25,14,12,46,30,36,28,7,5 },
	{ 25,29,46,24,28,9,43,13,8,42,12,17,21,16,20,33,1,37,5,32,0,36,4,15,27,14,26,41,30,45,11,40,31,44,10,39,7,19,38,6,18,22,35,3,23,34,2 },
	{ 43,35,42,34,39,46,38,13,3,9,23,12,2,8,22,28,18,24,7,29,19,25,6,45,37,41,33,44,36,40,32,11,5,31,1,10,4,30,0,26,20,15,16,27,21,14,17 },
},
{
	/* Frame 232 */
	{ 31,37,32,30,36,0,4,26,1,5,27,41,23,45,40,22,44,8,12,18,9,13,19,7,35,6,34,39,24,2,28,38,25,3,29,15,43,14,42,16,10,20,46,17,11,21,33 },
	{ 32,25,35,11,23,8,37,6,18,13,33,34,9,20,7,30,19,44,16,2,40,21,43,38,31,4,45,17,14,3,26,0,41,42,39,5,28,15,27,1,24,10,22,36,29,46,12 },
	{ 14,28,32,8,27,41,6,42,5,39,16,19,0,15,34,29,33,30,9,44,10,24,7,43,21,22,2,1,36,35,12,31,45,11,46,25,26,20,40,23,4,3,38,17,37,18,13 },
	{ 41,26,7,20,1,46,40,31,6,25,0,35,45,30,11,24,5,34,44,19,10,29,4,39,33,18,15,28,9,38,32,23,14,17,8,43,37,22,3,16,13,42,36,27,2,21,12 },
	{ 42,19,37,20,15,8,39,22,44,25,10,5,46,31,41,16,3,12,43,18,32,21,14,9,34,27,45,28,7,0,30,36,17,2,13,38,23,33,24,11,4,35,26,40,29,6,1 },
	{ 8,31,34,16,33,14,5,22,39,29,40,11,0,19,46,24,45,6,9,30,43,17,32,3,12,27,38,20,37,10,1,18,35,25,44,15,4,23,42,28,41,2,13,26,21,36,7 },
	{ 16,2,13,39,14,5,6,25,11,17,3,15,7,40,26,32,18,30,29,22,41,21,27,33,8,19,44,0,31,36,28,23,20,42,9,34,45,1,46,37,12,38,4,43,24,35,10 },
	{ 18,7,17,4,2,33,38,11,31,9,29,26,45,42,40,22,1,21,19,6,37,35,32,15,24,13,10,30,8,46,44,16,5,3,23,0,39,36,34,28,27,14,25,12,43,41,20 },
	{ 17,18,29,41,30,37,24,3,20,15,9,10,5,6,34,0,46,19,12,40,31,43,36,25,39,26,21,33,22,45,16,11,28,7,1,2,13,14,42,8,38,27,4,32,23,35,44 },
	{ 17,3,13,39,18,33,24,14,4,34,27,44,29,7,1,43,30,37,20,2,8,38,23,32,25,11,5,26,41,16,6,12,42,19,36,21,15,9,35,22,45,28,10,0,46,31,40 },
	{ 45,27,15,44,26,14,25,13,46,24,12,37,23,7,36,22,6,21,5,38,20,4,39,41,31,11,40,30,10,29,9,42,28,8,43,33,19,3,32,18,2,17,1,34,16,0,35 },
	{ 44,40,17,11,21,42,19,24,7,45,36,41,32,26,20,14,43,34,25,22,29,37,33,27,4,15,0,35,46,23,28,2,5,30,1,38,12,3,8,31,16,10,39,13,18,9,6 },
},
{
	/* Frame 233 */
	{ 44,25,30,13,2,37,20,42,23,8,11,32,29,35,18,1,6,41,24,46,27,12,15,36,17,39,22,5,10,45,28,34,31,0,3,40,21,43,26,9,14,33,16,38,19,4,7 },
	{ 21,14,34,4,40,30,20,15,35,5,41,27,17,46,10,36,0,26,16,11,37,1,23,29,6,42,12,32,22,28,7,43,13,33,19,25,38,2,44,8,18,24,39,3,45,9,31 },
	{ 30,4,28,38,36,7,31,5,29,39,37,2,26,0,24,34,32,3,27,1,25,35,33,14,22,12,20,46,44,15,23,13,21,45,10,18,8,16,42,40,11,19,9,17,43,41,6 },
	{ 42,44,33,26,8,14,3,20,25,31,43,13,32,46,2,37,24,30,19,12,1,7,29,34,36,41,18,0,6,11,28,17,23,35,5,40,38,10,45,16,22,27,4,9,15,21,39 },
	{ 35,32,22,4,7,18,29,8,11,25,46,45,14,34,20,33,23,2,5,16,39,19,36,9,43,40,30,12,15,26,21,0,3,17,38,37,6,42,28,41,31,10,13,24,27,44,1 },
	{ 4,28,38,5,29,39,37,6,30,36,7,31,16,12,46,17,13,45,18,14,44,19,15,0,24,34,1,25,35,33,2,26,32,3,27,20,8,42,21,9,43,41,22,10,40,23,11 },
	{ 39,2,15,42,44,9,20,29,3,46,43,23,8,28,10,22,17,4,11,31,16,25,5,32,19,30,6,24,36,33,13,18,7,34,37,0,12,41,27,38,35,14,1,45,40,21,26 },
	{ 25,21,31,19,24,20,30,18,45,37,43,35,13,5,11,3,44,36,42,34,12,4,10,2,29,17,27,23,28,16,26,22,41,33,39,9,1,15,7,40,32,46,38,8,0,14,6 },
	{ 27,3,29,33,40,5,44,30,2,43,32,9,36,45,16,31,35,42,7,8,37,12,17,34,11,6,18,13,20,10,39,46,19,24,21,38,15,22,25,1,14,26,23,28,0,41,4 },
	{ 29,6,5,38,25,37,2,1,34,12,33,30,44,21,8,26,40,17,28,15,4,22,36,11,0,43,18,32,31,20,7,27,39,24,3,14,35,13,46,23,45,10,9,42,19,41,16 },
	{ 36,6,16,13,26,14,34,1,20,41,42,30,25,38,5,18,45,46,8,29,33,3,22,17,12,11,37,7,0,21,40,27,15,35,4,19,44,43,31,24,39,32,2,23,9,28,10 },
	{ 46,21,45,7,0,19,43,16,36,14,13,30,34,25,33,11,4,23,20,40,2,1,18,38,29,37,15,8,27,35,24,44,6,5,22,42,17,41,3,12,31,39,28,32,10,9,26 },
},
{
	/* Frame 234 */
	{ 38,13,40,27,21,2,35,12,37,26,20,7,34,1,36,31,25,6,0,33,30,24,11,46,5,32,19,29,10,43,4,45,18,28,15,42,9,44,23,17,14,39,8,41,22,16,3 },
	{ 18,8,37,46,7,28,21,9,0,38,20,31,40,1,10,39,30,23,41,32,11,2,25,22,12,33,42,3,24,17,13,4,43,34,16,27,44,5,14,35,26,19,45,36,15,6,29 },
	{ 12,38,15,13,39,30,37,28,31,36,29,10,8,34,11,9,35,26,33,24,27,32,25,20,46,6,44,21,7,45,5,22,4,23,16,42,2,40,17,43,3,41,1,18,0,19,14 },
	{ 40,6,3,24,23,43,4,1,21,41,38,2,22,19,36,0,15,20,17,39,34,13,18,37,32,14,11,16,31,35,12,9,29,33,46,10,30,27,44,8,7,28,25,42,5,26,45 },
	{ 13,42,46,8,12,43,41,45,11,15,40,44,10,14,25,21,24,20,27,23,26,22,1,5,34,38,0,4,35,39,33,37,3,7,32,36,2,6,17,29,16,28,19,31,18,30,9 },
	{ 39,28,4,38,29,5,31,7,37,30,6,36,16,12,46,17,13,19,15,45,18,14,44,35,24,0,34,25,1,27,3,33,26,2,32,43,20,8,42,21,9,23,11,41,22,10,40 },
	{ 11,12,0,23,34,5,26,40,14,17,38,20,33,44,24,31,42,2,37,7,8,46,29,19,1,22,35,10,13,15,16,39,4,27,41,30,43,3,21,32,45,25,28,18,36,6,9 },
	{ 25,30,39,44,0,19,28,37,15,34,17,22,13,32,10,20,3,8,31,45,1,42,6,29,26,35,40,4,23,24,33,11,38,21,18,9,36,14,16,43,7,12,27,41,5,46,2 },
	{ 17,11,6,13,4,10,3,46,39,44,5,30,43,2,9,38,45,36,31,22,42,35,8,1,26,37,23,28,34,41,0,27,18,29,20,40,33,19,24,21,15,32,25,16,14,7,12 },
	{ 34,9,43,17,28,5,39,12,32,26,41,3,14,22,37,31,44,24,1,35,8,46,20,29,10,18,33,27,40,6,15,23,42,16,25,4,38,13,21,2,11,19,36,30,45,7,0 },
	{ 22,12,34,31,5,10,24,3,38,17,14,33,28,7,40,21,26,0,37,19,9,44,35,30,4,42,23,13,2,39,16,11,46,25,6,41,20,15,32,29,18,8,45,27,1,36,43 },
	{ 36,30,25,7,42,0,41,31,24,6,5,40,18,29,11,46,4,45,19,28,10,35,9,44,22,17,15,34,8,33,23,16,14,39,13,32,26,21,3,38,12,37,27,20,2,43,1 },
},
{
	/* Frame 235 */
	{ 31,40,24,7,0,38,22,45,29,10,5,35,19,36,20,15,8,46,30,33,17,6,13,43,27,44,28,3,4,34,18,41,25,14,1,39,23,32,16,11,12,42,26,37,21,2,9 },
	{ 45,18,36,44,19,4,26,12,5,27,13,33,41,32,40,20,0,28,8,21,1,29,9,6,46,7,14,16,38,24,15,17,39,25,43,22,2,42,23,3,30,10,34,31,11,35,37 },
	{ 14,30,13,29,46,45,15,31,12,28,40,10,26,9,25,42,41,11,27,8,24,43,36,6,22,5,21,38,37,7,23,4,20,39,32,2,18,1,17,34,33,3,19,0,16,35,44 },
	{ 25,45,42,23,16,36,35,30,41,13,19,32,4,26,9,7,0,14,21,3,38,28,10,17,37,34,31,24,44,43,22,33,5,27,40,12,18,1,15,8,6,29,11,46,20,2,39 },
	{ 20,1,23,2,4,7,37,43,29,40,30,46,24,13,27,14,0,3,33,39,17,36,18,42,28,9,31,10,12,15,45,35,21,32,22,38,16,5,19,6,8,11,41,25,44,26,34 },
	{ 35,5,29,3,27,36,34,4,28,2,26,37,43,17,13,23,11,44,42,16,12,22,10,45,39,1,25,7,31,32,38,0,24,6,30,33,21,9,19,15,40,46,20,8,18,14,41 },
	{ 24,0,38,40,15,23,11,19,36,12,35,21,42,29,8,17,25,30,33,7,41,14,26,44,3,10,5,13,34,1,39,9,46,22,31,32,6,18,37,27,45,2,20,43,28,4,16 },
	{ 37,39,5,25,7,27,36,38,4,24,6,26,41,43,17,9,19,11,40,42,16,8,18,10,33,35,1,29,3,31,32,34,0,28,2,30,45,21,13,23,15,44,46,20,12,22,14 },
	{ 7,11,5,9,23,27,21,25,6,10,4,8,22,26,20,43,41,45,42,46,40,44,3,28,1,15,19,13,17,31,2,29,0,14,18,12,16,30,35,39,33,37,34,38,32,36,24 },
	{ 9,6,25,32,22,43,4,3,20,41,19,46,1,10,17,44,26,35,8,15,24,33,31,38,13,2,29,36,18,0,7,16,45,23,42,5,14,21,40,30,39,12,11,28,37,27,34 },
	{ 40,43,46,9,12,26,15,25,35,38,32,21,18,7,1,4,41,44,13,27,30,24,29,10,39,33,36,19,22,16,5,2,45,42,31,8,28,11,14,37,34,23,17,20,3,6,0 },
	{ 44,12,38,6,29,23,45,13,39,7,28,22,32,8,42,2,25,19,33,9,43,3,24,18,36,4,46,14,21,31,37,5,15,20,30,40,0,34,10,17,27,41,1,35,11,16,26 },
},
{
	/* Frame 236 */
	{ 41,7,17,23,0,40,6,46,16,22,9,33,15,39,25,31,8,32,14,38,24,30,5,45,3,43,21,19,4,44,2,42,20,18,13,37,11,35,29,27,12,36,10,34,28,26,1 },
	{ 20,6,44,19,25,33,10,35,30,13,36,17,2,8,22,5,46,26,40,0,29,15,38,45,18,24,32,42,21,7,12,37,16,11,34,31,4,3,9,23,28,14,39,27,41,1,43 },
	{ 6,38,21,7,39,5,37,22,4,36,23,16,2,34,17,3,35,1,33,18,0,32,19,30,28,31,29,15,13,45,14,46,12,44,26,24,27,25,11,43,9,41,10,42,8,40,20 },
	{ 7,40,29,14,33,20,11,38,17,2,24,42,31,13,35,22,4,19,1,44,26,8,37,15,32,21,6,41,28,3,46,25,10,39,16,34,23,5,43,30,12,27,9,36,18,0,45 },
	{ 8,24,43,9,25,11,27,40,10,26,41,46,12,20,13,21,15,23,44,14,22,45,34,0,16,35,1,17,3,19,32,2,18,33,38,4,28,39,5,29,7,31,36,6,30,37,42 },
	{ 25,1,38,32,30,6,24,0,39,33,31,7,21,9,46,40,18,14,20,8,41,19,15,29,5,34,36,26,2,28,4,35,37,27,3,17,13,42,44,22,10,16,12,43,45,23,11 },
	{ 16,3,12,34,14,33,8,10,39,41,21,6,5,17,44,2,46,1,13,30,32,28,9,26,38,24,37,22,4,43,45,18,0,31,29,35,15,27,25,36,11,23,40,20,42,7,19 },
	{ 5,6,12,35,27,0,41,23,42,37,29,38,30,17,44,18,32,24,11,20,7,13,14,1,2,43,8,39,31,4,45,19,46,33,25,34,26,21,40,22,36,28,15,16,3,9,10 },
	{ 35,5,43,13,21,29,34,4,42,12,20,24,37,1,45,9,17,25,36,0,44,8,16,7,15,33,23,41,31,6,14,32,22,40,30,39,3,11,19,27,38,2,46,10,18,26,28 },
	{ 24,32,27,35,4,7,29,37,18,42,9,14,20,44,23,0,3,25,33,30,38,5,10,16,40,19,43,12,15,21,45,26,34,1,6,28,36,31,39,8,11,17,41,22,46,13,2 },
	{ 29,23,35,38,8,44,2,17,20,27,30,5,42,15,32,37,24,18,39,9,12,3,6,41,21,31,43,46,0,36,10,25,28,19,22,13,34,7,40,45,16,26,1,4,11,14,33 },
	{ 7,45,24,43,18,4,10,40,17,38,23,13,3,33,20,30,0,6,44,29,42,19,9,15,37,16,35,26,12,2,32,25,46,31,5,11,41,28,39,22,8,14,36,21,34,27,1 },
},
{
	/* Frame 237 */
	{ 0,23,38,5,41,15,12,33,22,3,26,4,25,40,43,45,17,32,2,27,37,24,7,30,42,29,44,16,35,21,36,6,31,10,28,9,46,19,34,20,1,39,11,8,14,18,13 },
	{ 14,42,4,32,30,20,15,43,5,33,31,25,46,2,36,8,18,24,3,37,9,19,29,6,34,12,40,22,28,7,35,13,41,23,17,38,10,44,0,26,16,39,11,45,1,27,21 },
	{ 24,44,27,8,11,21,41,18,38,5,2,28,32,31,35,12,15,25,45,22,42,9,6,16,36,19,39,0,3,29,33,26,46,13,10,20,40,23,43,4,7,17,37,30,34,1,14 },
	{ 28,14,23,0,11,45,35,40,29,46,22,1,24,10,19,12,7,41,36,25,42,18,13,20,6,31,8,3,37,43,32,21,38,30,9,16,2,27,4,15,33,39,44,17,34,26,5 },
	{ 20,32,11,16,14,5,2,9,23,12,38,19,45,0,30,42,21,33,26,36,17,15,35,28,40,3,24,6,13,10,1,31,4,46,27,37,8,22,34,29,41,39,18,44,25,7,43 },
	{ 5,7,42,40,34,32,12,14,4,25,6,27,17,41,19,33,24,39,26,16,9,18,11,1,3,46,44,38,36,8,10,0,29,2,31,21,45,23,37,43,28,35,30,20,13,22,15 },
	{ 3,6,33,36,8,13,7,0,37,12,27,1,4,26,31,25,42,5,19,30,24,29,43,46,18,23,34,28,10,41,22,17,35,38,11,14,40,45,16,21,2,39,32,15,9,44,20 },
	{ 21,8,7,26,33,46,12,9,22,27,37,32,13,16,23,10,36,35,28,17,14,11,39,34,29,0,15,18,41,38,4,1,30,19,45,40,5,24,31,2,44,43,20,25,6,3,42 },
	{ 43,16,25,3,14,39,17,8,2,27,44,4,9,19,26,32,45,46,5,28,18,11,33,34,20,29,7,10,35,21,12,6,31,40,0,13,23,30,36,41,42,1,24,22,15,37,38 },
	{ 26,38,24,36,10,8,27,39,25,37,11,9,18,16,42,2,40,0,19,17,43,3,41,1,28,14,34,12,32,31,29,15,35,13,33,30,20,46,6,44,4,23,21,7,45,5,22 },
	{ 38,46,1,28,25,37,3,30,11,39,40,12,24,21,31,26,23,41,13,8,20,17,44,27,22,19,32,9,4,16,45,34,42,6,18,14,33,5,0,29,35,36,43,7,2,15,10 },
	{ 44,33,2,31,17,13,18,42,36,39,8,23,11,5,24,34,45,14,0,29,3,30,16,40,43,37,6,27,21,9,22,46,32,35,12,19,15,1,28,38,41,10,4,25,7,26,20 },
},
{
	/* Frame 238 */
	{ 5,2,46,27,41,25,37,34,18,15,20,13,43,30,6,0,45,23,10,38,28,32,16,3,26,8,4,35,19,14,21,40,24,36,7,1,12,42,31,39,29,33,17,44,22,11,9 },
	{ 44,1,14,39,21,26,23,45,32,15,2,22,8,33,46,3,28,9,4,34,29,16,31,40,5,10,35,17,30,19,41,36,11,6,18,12,37,42,7,24,13,0,43,38,25,20,27 },
	{ 34,7,33,4,2,1,19,42,15,41,28,10,38,9,37,27,6,5,23,46,17,45,18,14,40,13,31,8,26,25,21,35,22,32,16,44,3,0,12,43,30,29,11,39,24,36,20 },
	{ 30,37,10,32,29,39,9,24,34,31,4,11,26,33,6,44,25,35,5,20,46,27,0,7,22,45,2,40,21,1,16,42,23,12,3,18,41,14,36,17,43,13,28,38,19,8,15 },
	{ 0,4,10,14,32,36,42,46,1,5,11,15,33,37,16,28,26,22,17,29,27,23,35,39,8,12,2,6,40,44,34,38,9,13,3,7,41,45,24,20,18,30,25,21,19,31,43 },
	{ 3,8,19,10,24,5,26,21,45,34,32,11,4,27,6,20,13,22,35,29,33,42,40,7,12,23,14,28,1,30,43,17,41,38,36,15,0,31,2,16,9,18,39,25,37,46,44 },
	{ 16,5,40,27,14,38,43,20,24,44,32,31,2,8,28,36,19,6,11,35,12,0,23,26,15,39,17,4,41,33,30,3,42,21,25,45,37,18,7,46,9,29,1,22,10,34,13 },
	{ 1,2,20,7,37,16,11,29,41,30,44,25,26,12,32,23,35,0,38,19,5,6,42,9,10,28,15,45,24,3,21,33,22,36,17,39,18,4,40,31,43,8,46,27,13,14,34 },
	{ 24,1,15,18,37,43,34,25,16,14,7,35,12,17,31,6,40,13,4,30,23,41,32,46,28,5,11,22,33,38,29,20,10,3,39,8,21,27,2,44,9,0,26,19,45,36,42 },
	{ 41,2,37,31,25,46,21,38,3,32,30,24,43,20,39,12,33,27,23,42,17,34,13,26,22,16,35,8,4,19,15,44,9,5,18,14,45,6,0,29,11,40,7,36,1,28,10 },
	{ 28,3,36,33,23,26,9,14,42,29,16,4,32,39,27,15,10,45,17,30,5,0,38,35,20,11,44,41,31,18,1,6,34,21,24,12,40,19,7,2,37,25,22,13,8,46,43 },
	{ 42,25,23,33,12,2,15,22,27,32,45,35,14,16,26,5,44,34,17,28,4,9,7,46,29,19,37,8,6,11,18,31,36,41,39,10,20,30,1,40,38,43,21,24,0,13,3 },
},
{
	/* Frame 239 */
	{ 27,10,46,3,22,39,34,25,8,12,1,36,32,21,11,30,42,23,6,18,35,9,44,40,29,37,16,33,20,5,31,14,26,43,7,19,2,38,45,24,41,28,13,17,0,4,15 },
	{ 26,6,18,15,27,7,19,46,38,39,30,33,22,8,31,32,23,9,0,40,1,41,37,12,24,36,13,25,4,16,44,5,17,45,10,28,2,11,29,3,20,42,34,21,43,35,14 },
	{ 26,38,4,2,21,33,23,35,13,15,16,40,30,42,8,6,25,37,27,39,1,3,20,44,18,46,12,10,29,41,31,43,5,7,24,32,22,34,0,14,17,45,19,9,11,28,36 },
	{ 15,28,32,6,21,41,31,46,0,22,39,9,3,16,36,10,25,45,19,34,4,26,43,13,7,20,40,14,29,33,23,38,8,30,1,11,24,44,2,17,37,27,42,12,18,35,5 },
	{ 2,28,40,23,39,12,7,21,33,30,42,5,14,16,36,27,35,8,3,25,45,18,38,1,10,20,32,31,4,15,29,41,22,34,13,6,24,44,19,43,0,11,17,37,26,46,9 },
	{ 3,37,9,14,1,6,43,12,35,31,4,23,46,29,38,26,21,44,18,36,24,15,16,41,7,33,13,10,5,2,8,39,27,0,19,42,25,34,30,17,40,22,32,28,11,20,45 },
	{ 18,28,17,14,2,44,33,26,5,24,23,10,40,39,36,12,1,31,19,29,35,45,32,20,8,7,27,4,25,43,41,38,16,15,3,13,0,46,34,22,11,21,9,6,37,42,30 },
	{ 9,4,19,30,32,45,16,5,2,31,44,43,17,28,3,14,42,39,0,29,26,15,41,38,1,12,27,22,40,37,24,13,10,23,36,35,25,20,11,6,34,8,21,18,7,33,46 },
	{ 7,32,44,43,39,1,13,10,6,33,45,42,38,0,12,27,31,17,21,26,30,16,20,3,15,40,36,35,9,5,2,14,41,37,34,46,8,4,19,23,25,29,18,22,24,28,11 },
	{ 18,14,40,20,8,19,15,41,46,21,9,30,6,32,39,24,0,31,7,33,38,25,1,22,10,44,43,16,12,23,11,45,42,17,13,26,2,36,35,28,4,27,3,37,34,29,5 },
	{ 45,44,35,37,43,34,36,42,23,19,31,27,22,18,30,26,7,3,15,11,6,2,14,10,41,40,39,33,38,46,32,13,9,21,17,12,8,20,16,28,24,5,1,29,25,4,0 },
	{ 46,38,40,32,39,41,33,10,6,12,0,27,23,29,17,11,7,13,1,26,22,28,16,42,34,44,36,43,35,45,37,14,2,8,4,31,19,25,21,15,3,9,5,30,18,24,20 },
},
{
	/* Frame 240 */
	{ 31,3,27,6,30,2,26,39,35,38,34,15,23,11,19,14,22,10,18,43,46,42,1,25,37,0,24,36,33,4,28,32,5,29,9,17,45,8,16,44,41,12,20,40,13,21,7 },
	{ 24,38,42,19,31,33,44,35,22,11,5,17,28,2,14,37,9,46,0,27,21,41,7,43,18,30,32,13,25,39,10,4,16,45,34,23,36,8,29,3,15,26,20,40,6,1,12 },
	{ 34,29,33,14,24,11,45,8,21,22,42,16,38,3,37,0,28,15,12,27,9,46,20,7,43,4,40,2,1,19,31,35,13,32,26,25,10,44,6,5,41,23,17,39,18,36,30 },
	{ 24,36,30,42,17,45,23,35,4,10,13,3,28,40,18,46,21,33,27,39,8,14,1,7,16,44,22,34,25,37,31,43,12,2,5,11,20,32,26,38,29,41,19,0,6,9,15 },
	{ 25,35,41,2,18,8,24,34,40,3,19,13,21,39,45,6,30,12,20,38,44,7,31,1,17,43,33,10,26,0,16,42,32,11,27,5,29,37,14,22,4,28,46,36,15,23,9 },
	{ 4,31,42,20,45,6,9,22,25,36,3,12,19,38,28,33,14,5,30,35,21,44,11,0,27,46,16,41,2,13,18,43,29,32,7,8,23,34,24,37,10,1,26,39,17,40,15 },
	{ 17,30,25,7,1,40,38,32,19,12,26,4,3,45,34,43,31,8,6,0,15,41,46,13,27,20,2,28,11,42,37,9,22,16,14,24,39,33,21,18,29,10,5,44,36,35,23 },
	{ 40,13,35,6,8,19,28,42,15,1,37,10,21,30,16,44,3,39,41,12,23,25,18,46,32,5,43,14,0,27,20,34,7,9,45,2,29,22,24,36,11,33,4,31,17,26,38 },
	{ 27,36,39,5,25,6,26,37,38,4,24,23,3,32,35,21,1,22,2,33,34,20,0,15,19,44,13,17,14,18,45,46,12,16,31,11,40,43,29,9,30,10,41,42,28,8,7 },
	{ 43,21,12,26,3,37,42,16,13,23,2,36,39,17,8,22,15,33,38,28,9,19,14,32,35,29,4,18,11,45,34,24,5,31,10,44,25,0,30,7,41,46,20,1,27,6,40 },
	{ 21,25,20,24,23,27,22,26,43,13,9,46,42,12,8,15,11,44,40,14,10,45,41,29,17,28,16,31,19,30,18,39,35,5,1,38,34,4,0,7,3,36,32,6,2,37,33 },
	{ 33,22,13,16,34,4,14,19,40,39,29,1,11,45,30,2,24,32,46,12,17,27,7,37,43,18,9,20,38,0,10,23,44,35,25,5,15,41,26,6,28,36,42,8,21,31,3 },
},
{
	/* Frame 241 */
	{ 2,33,20,38,23,8,15,44,29,35,18,1,6,37,24,42,27,12,3,32,17,39,22,5,10,41,28,46,31,0,7,36,21,43,26,9,14,45,16,34,19,4,11,40,25,30,13 },
	{ 45,21,38,30,1,10,40,16,23,12,3,33,25,42,18,5,14,44,20,35,27,0,7,37,29,46,22,9,2,32,24,39,31,4,11,41,17,34,26,13,6,36,28,43,19,8,15 },
	{ 35,37,41,14,2,4,8,46,34,36,40,15,3,5,9,30,18,20,24,31,19,21,25,39,43,45,33,6,10,12,0,38,42,44,32,7,11,13,1,22,26,28,16,23,27,29,17 },
	{ 9,38,42,37,41,7,11,4,8,39,43,36,40,6,10,21,25,23,27,20,24,22,26,13,1,46,34,45,33,15,3,12,0,35,44,32,14,2,29,17,31,19,28,16,30,18,5 },
	{ 35,14,16,42,7,25,26,32,28,19,38,41,21,22,0,44,31,9,37,10,12,3,5,43,6,24,34,15,17,18,39,40,20,27,46,33,29,30,8,36,23,1,45,2,4,11,13 },
	{ 8,14,1,7,4,41,26,13,32,19,37,16,30,42,44,25,23,35,20,38,10,29,3,0,6,9,15,12,33,18,5,40,27,45,24,22,34,36,17,31,43,28,46,2,21,39,11 },
	{ 28,20,30,22,29,21,31,23,8,4,42,38,41,37,10,6,9,5,43,39,40,36,11,7,24,16,26,18,25,17,27,19,12,0,46,34,45,33,14,2,13,1,35,44,32,15,3 },
	{ 34,46,32,45,35,33,44,10,2,8,0,27,19,25,17,11,3,9,1,26,18,24,16,42,40,38,37,43,41,39,36,29,21,14,6,13,5,31,23,28,20,15,7,12,4,30,22 },
	{ 38,41,43,37,39,40,42,36,14,6,29,21,31,23,13,5,15,7,28,20,30,22,12,4,46,33,45,35,32,44,34,25,17,27,19,9,1,11,3,24,16,26,18,8,0,10,2 },
	{ 29,5,10,19,24,4,45,31,7,25,37,44,1,30,26,6,36,13,0,41,20,27,39,46,3,12,33,40,21,38,15,2,43,32,9,16,14,35,42,23,8,28,17,34,11,22,18 },
	{ 24,3,15,38,4,37,25,2,35,14,13,36,22,11,34,1,46,12,45,23,10,43,0,33,18,44,30,21,42,9,32,19,31,20,8,41,26,16,29,7,40,27,17,28,6,39,5 },
	{ 39,4,22,1,32,2,17,29,30,12,10,9,40,5,36,6,21,33,3,34,16,19,14,13,44,11,42,24,41,27,37,7,38,20,23,35,0,18,15,46,28,45,31,43,25,26,8 },
},
{
	/* Frame 242 */
	{ 32,23,17,14,8,45,22,16,15,42,13,44,27,21,2,43,12,41,26,20,3,38,1,40,31,25,6,39,0,37,30,24,7,34,5,36,19,29,10,35,4,33,18,28,11,46,9 },
	{ 46,19,45,24,11,4,43,30,36,29,2,1,34,27,33,20,7,12,39,18,44,17,10,9,42,23,41,28,15,0,26,32,25,6,5,38,31,37,16,3,8,35,22,40,21,14,13 },
	{ 27,29,2,20,26,28,3,4,10,12,18,5,11,13,19,34,35,36,42,44,37,43,45,31,17,6,25,30,16,7,24,14,0,22,8,15,1,23,9,38,39,46,32,40,33,41,21 },
	{ 42,44,40,15,11,13,9,43,45,41,14,10,12,8,31,27,29,25,30,26,28,24,38,34,36,32,7,3,5,1,39,35,37,33,6,2,4,0,23,19,21,17,22,18,20,16,46 },
	{ 24,7,26,20,33,22,45,43,25,39,27,21,0,23,2,12,14,42,40,38,36,1,3,13,16,15,18,28,41,30,37,35,17,19,29,8,31,10,4,6,34,32,46,44,9,11,5 },
	{ 31,43,12,22,34,5,11,28,45,2,21,36,19,39,8,26,46,1,7,16,41,14,25,32,23,35,4,30,42,13,3,20,37,10,29,44,27,0,18,38,9,15,24,33,6,17,40 },
	{ 29,21,28,20,27,19,26,18,35,9,5,46,34,8,4,15,3,40,36,14,2,41,37,25,17,24,16,31,23,30,22,43,39,13,1,42,38,12,0,11,7,44,32,10,6,45,33 },
	{ 45,6,11,4,40,2,31,1,37,27,20,24,32,43,14,17,12,39,10,5,9,22,35,0,28,18,46,44,21,25,7,42,41,13,3,30,38,36,8,23,26,34,33,29,19,15,16 },
	{ 6,19,23,41,3,45,7,18,22,40,2,44,25,29,33,9,37,13,24,28,32,8,36,12,17,46,21,1,5,43,16,20,0,4,42,38,14,27,31,35,11,39,15,26,30,34,10 },
	{ 12,0,30,18,28,16,15,3,13,1,31,19,29,17,14,34,38,32,36,35,39,33,37,8,6,26,4,24,22,11,20,9,7,27,5,25,23,10,21,40,44,43,41,45,42,46,2 },
	{ 46,1,28,11,18,37,0,17,10,27,44,34,9,16,7,26,45,35,8,25,6,23,32,42,5,24,15,22,33,43,4,21,14,31,40,38,13,20,3,30,41,39,12,29,2,19,36 },
	{ 31,42,9,5,18,34,14,25,41,21,37,6,0,46,13,26,22,38,16,32,29,45,11,8,4,3,30,43,24,40,20,36,19,35,15,12,27,7,1,28,44,10,23,39,17,33,2 },
},
{
	/* Frame 243 */
	{ 8,38,30,33,17,6,1,35,27,36,28,3,4,46,18,41,25,14,9,43,23,44,16,11,12,34,26,37,21,2,5,39,31,32,24,7,0,42,22,45,29,10,13,19,40,20,15 },
	{ 12,36,23,9,26,33,18,40,21,14,28,6,11,25,34,42,13,30,37,22,44,27,0,41,15,29,38,46,35,16,43,3,31,4,45,1,8,32,19,39,20,7,17,10,24,2,5 },
	{ 33,14,10,4,0,46,42,36,32,15,11,5,1,43,30,26,20,16,31,27,21,17,45,41,6,2,12,8,38,34,44,40,7,3,13,9,39,35,22,18,28,24,23,19,29,25,37 },
	{ 15,24,44,26,33,28,35,30,17,37,19,39,21,42,23,8,10,46,12,14,1,3,32,5,7,16,36,18,41,20,43,22,25,45,27,29,34,31,0,2,38,4,6,9,11,40,13 },
	{ 21,45,10,28,36,3,13,22,43,4,31,34,25,33,14,16,40,7,1,26,8,19,38,29,37,2,20,44,11,5,30,35,12,23,42,17,41,6,24,32,15,9,18,39,0,27,46 },
	{ 43,4,17,22,3,45,39,42,21,16,15,2,38,20,1,14,27,40,13,0,31,26,36,41,35,12,25,30,11,37,34,29,24,7,10,46,28,9,6,19,32,5,8,23,18,44,33 },
	{ 17,31,34,9,32,22,4,14,39,28,19,41,1,11,25,46,6,44,16,30,8,33,43,3,21,27,38,13,36,18,0,10,35,24,23,45,5,15,29,42,2,40,20,26,12,37,7 },
	{ 21,42,0,46,5,17,20,43,1,4,16,34,10,38,14,27,31,35,11,39,15,26,30,2,6,40,19,45,23,3,7,41,18,44,22,29,32,8,37,13,25,28,33,9,36,12,24 },
	{ 37,26,13,34,17,22,30,27,44,35,21,16,31,32,45,2,20,42,25,33,6,3,43,29,24,0,7,40,10,28,4,1,38,41,14,11,5,39,8,15,19,36,12,9,46,23,18 },
	{ 45,5,8,19,26,33,46,4,29,18,11,34,21,28,7,10,40,35,20,13,6,31,36,41,1,12,23,30,37,42,0,25,22,15,38,43,17,24,3,14,44,39,16,9,2,27,32 },
	{ 31,29,45,6,4,22,26,42,25,41,11,0,19,35,14,12,30,38,20,36,7,5,8,27,43,16,32,2,1,46,28,44,15,13,23,39,21,37,24,40,10,9,18,34,17,33,3 },
	{ 37,15,7,36,14,6,30,45,22,31,44,23,43,11,35,3,42,10,34,2,26,18,27,19,5,39,29,46,4,38,28,20,13,21,12,33,1,25,32,0,24,16,41,9,17,40,8 },
},
{
	/* Frame 244 */
	{ 35,17,23,0,36,6,34,16,22,1,37,15,25,31,8,40,14,46,24,30,9,41,3,39,21,19,4,32,2,38,20,18,5,33,11,43,29,27,12,44,10,42,28,26,13,45,7 },
	{ 24,6,27,44,22,15,35,31,9,10,25,39,26,5,14,21,34,30,33,43,38,4,20,13,32,29,42,41,37,46,12,0,28,3,16,40,19,36,7,45,23,1,2,17,8,18,11 },
	{ 10,6,2,15,11,7,3,30,26,22,18,31,27,23,19,46,42,38,34,43,39,35,21,17,12,8,20,16,13,9,4,0,28,24,5,1,29,25,44,40,45,41,36,32,37,33,14 },
	{ 5,6,24,3,33,20,15,17,45,18,40,29,43,30,8,36,27,39,4,34,23,1,2,46,13,14,16,11,41,28,7,25,37,26,32,21,35,22,0,44,19,12,42,31,9,10,38 },
	{ 36,35,23,33,16,15,18,8,29,10,5,34,32,19,45,28,11,30,4,25,6,1,46,44,43,31,41,24,7,26,0,21,2,13,42,40,39,27,37,20,3,22,12,17,14,9,38 },
	{ 28,9,38,32,27,14,17,8,39,33,30,15,16,5,34,44,31,10,21,4,35,45,18,11,20,1,46,40,19,6,25,0,41,22,7,24,13,42,36,23,2,29,12,43,37,26,3 },
	{ 23,1,15,6,25,20,30,35,12,36,46,7,41,21,31,18,13,4,10,28,38,40,33,19,5,11,2,29,16,26,39,8,32,42,3,45,17,27,22,9,0,14,24,43,34,44,37 },
	{ 5,16,8,35,12,6,18,10,15,21,45,1,28,46,3,32,31,36,17,41,34,13,39,24,19,43,22,14,26,0,4,29,9,2,7,37,11,40,20,44,38,25,42,23,27,33,30 },
	{ 27,4,41,38,16,14,32,5,8,39,42,15,19,33,9,6,43,18,29,0,34,7,10,28,1,30,35,44,11,21,31,2,45,20,25,36,3,12,46,24,23,26,37,40,13,17,22 },
	{ 12,10,6,32,44,42,38,1,13,11,7,33,45,43,39,16,20,26,30,17,21,27,31,8,4,2,14,40,36,34,46,9,5,3,15,41,37,35,24,28,18,22,25,29,19,23,0 },
	{ 30,8,15,32,16,39,23,1,10,45,29,42,18,4,3,40,24,31,9,6,33,17,38,26,12,11,36,20,35,19,5,14,41,25,46,22,0,7,44,28,43,27,13,2,37,21,34 },
	{ 46,5,38,25,33,0,22,36,11,3,20,39,12,1,40,23,37,31,18,21,13,16,41,8,30,44,19,27,28,17,9,14,45,6,42,26,34,29,4,24,32,15,7,43,10,35,2 },
},
{
	/* Frame 245 */
	{ 26,42,25,44,19,2,5,22,38,27,10,24,9,30,46,29,3,33,23,6,11,8,31,14,28,13,16,32,7,37,41,15,12,17,0,35,20,36,40,43,45,1,18,34,21,4,39 },
	{ 14,36,20,27,0,11,45,29,38,22,9,2,40,24,35,31,4,15,33,17,42,26,13,6,44,28,39,19,8,3,37,21,46,30,1,10,32,16,43,23,12,7,41,25,34,18,5 },
	{ 4,15,17,2,40,21,6,24,44,19,33,28,42,23,1,37,26,46,5,35,30,8,3,39,12,7,25,10,32,29,14,16,36,27,41,20,34,31,9,45,18,38,13,43,22,0,11 },
	{ 4,28,7,31,36,39,5,29,6,30,37,34,0,24,3,27,32,35,1,25,2,26,33,46,12,20,15,23,44,13,21,14,22,45,42,8,16,11,19,40,43,9,17,10,18,41,38 },
	{ 32,45,26,23,8,5,44,11,22,17,4,34,10,7,16,29,35,46,41,19,6,1,28,40,37,18,31,0,13,36,3,30,25,12,42,2,15,24,21,43,38,33,27,14,9,20,39 },
	{ 33,34,28,14,13,16,23,10,9,27,36,39,4,32,30,35,29,0,15,18,45,17,46,11,41,42,20,6,5,24,31,2,1,19,44,12,40,22,43,21,8,7,26,37,25,38,3 },
	{ 4,28,34,37,2,26,5,29,35,36,3,27,16,12,42,45,22,10,17,13,43,44,23,11,0,24,38,33,6,30,1,25,39,32,7,31,20,8,46,41,18,14,21,9,40,19,15 },
	{ 45,18,21,39,25,15,32,22,19,29,24,46,33,23,40,26,28,34,0,41,30,27,35,4,1,8,31,2,5,42,12,9,6,3,36,43,13,16,7,37,10,44,20,17,38,14,11 },
	{ 31,19,25,21,30,18,24,20,43,35,45,37,11,3,13,5,42,34,44,36,10,2,12,4,27,23,29,17,26,22,28,16,39,41,33,15,7,9,1,46,38,40,32,14,6,8,0 },
	{ 26,38,31,11,22,46,2,7,24,36,29,9,44,0,5,14,34,27,39,18,42,23,3,12,32,25,37,28,16,40,21,45,1,30,10,15,35,6,19,43,8,13,33,4,17,41,20 },
	{ 15,45,2,39,22,42,12,0,36,21,40,31,26,7,28,24,4,14,44,11,38,23,35,18,9,20,33,16,27,6,3,46,25,43,13,1,37,10,41,30,34,19,8,29,32,17,5 },
	{ 41,34,3,10,0,24,19,45,38,31,4,28,7,14,35,42,32,11,1,8,18,27,17,36,39,46,5,12,22,15,21,43,33,40,9,2,26,16,25,37,44,13,23,30,20,29,6 },
},
{
	/* Frame 246 */
	{ 30,8,19,36,21,2,14,40,28,5,39,22,33,26,12,42,17,6,0,44,24,11,9,18,37,20,34,46,31,41,29,4,3,15,13,43,16,38,23,32,27,45,25,10,7,1,35 },
	{ 4,30,32,29,2,9,38,27,45,20,7,12,35,18,40,17,10,5,46,23,33,28,15,0,43,26,36,25,6,13,34,31,41,16,3,8,39,22,44,21,14,1,42,19,37,24,11 },
	{ 28,32,5,41,26,36,18,45,30,35,22,43,25,39,0,9,29,4,40,13,27,3,44,11,31,34,7,42,15,38,16,46,8,20,12,33,2,10,37,19,6,14,23,17,24,1,21 },
	{ 28,14,30,44,46,13,29,15,31,45,8,24,10,26,40,42,9,25,11,27,41,43,4,20,6,22,36,38,5,21,7,23,37,39,0,16,2,18,32,34,1,17,3,19,33,35,12 },
	{ 26,13,22,34,24,46,19,20,32,31,44,17,2,29,41,14,37,0,11,12,7,35,9,18,5,30,42,16,38,27,28,40,23,36,25,10,21,33,6,45,8,3,4,15,43,1,39 },
	{ 30,3,29,0,6,5,39,41,23,42,20,44,18,15,17,12,2,1,35,37,27,38,24,40,22,11,21,8,14,13,33,31,34,28,36,26,7,25,4,10,9,43,45,19,46,16,32 },
	{ 39,5,29,38,4,28,7,31,36,6,30,37,17,13,46,16,12,19,15,44,18,14,45,35,1,25,34,0,24,3,27,32,2,26,33,43,21,9,42,20,8,23,11,40,22,10,41 },
	{ 9,36,16,44,21,32,29,40,27,2,43,7,14,22,24,0,8,5,13,20,11,39,19,46,26,35,31,42,6,37,17,45,25,33,28,41,4,12,3,10,38,18,15,23,34,30,1 },
	{ 39,37,7,27,5,25,38,36,6,26,4,24,43,41,19,11,17,9,42,40,18,10,16,8,35,33,3,31,1,29,34,32,2,30,0,28,45,23,15,21,13,46,44,22,14,20,12 },
	{ 7,27,4,45,42,30,19,29,37,34,22,11,21,40,46,3,13,0,38,26,5,25,44,43,18,28,17,14,35,32,20,9,6,12,1,31,39,36,24,23,10,41,16,15,2,33,8 },
	{ 11,0,19,34,24,45,6,5,30,43,29,40,3,12,27,46,20,37,10,9,18,35,17,32,15,4,23,38,28,41,2,1,26,25,44,7,8,31,42,16,33,14,13,22,39,21,36 },
	{ 12,7,35,27,16,8,36,23,15,43,32,24,2,44,39,31,20,40,18,10,5,28,6,34,26,1,13,22,14,42,17,9,37,38,30,21,33,25,3,45,46,4,29,41,19,11,0 },
},
{
	/* Frame 247 */
	{ 44,16,9,21,37,30,0,26,5,23,14,10,7,34,24,38,29,45,8,20,13,31,32,4,15,42,46,19,35,39,28,3,40,12,17,33,36,1,27,43,22,18,11,6,2,25,41 },
	{ 38,30,15,23,35,10,18,3,21,4,12,1,40,32,25,39,14,22,7,42,2,27,5,44,36,29,41,16,33,24,9,46,6,31,43,34,26,11,19,45,20,37,28,13,17,0,8 },
	{ 18,46,5,30,0,11,12,7,17,2,40,29,35,14,24,36,19,33,20,42,31,1,45,26,38,13,22,8,3,4,15,25,10,32,21,43,6,16,44,27,39,41,28,34,23,9,37 },
	{ 24,44,14,8,23,43,21,41,7,5,18,34,28,32,2,12,27,25,45,11,9,22,38,16,36,6,0,31,35,29,33,15,13,26,42,20,40,10,4,19,39,17,37,3,1,30,46 },
	{ 22,15,32,38,17,8,27,14,33,39,20,9,26,3,36,42,21,12,31,2,37,43,24,13,30,7,40,46,25,0,19,6,41,28,1,18,11,44,34,29,4,23,10,45,35,16,5 },
	{ 30,34,9,18,4,15,0,11,29,6,44,17,39,2,20,40,31,35,37,24,46,19,5,33,22,42,1,26,12,7,8,3,21,14,36,25,10,28,32,23,43,45,16,38,27,13,41 },
	{ 37,25,3,46,17,40,38,26,32,12,18,43,4,35,31,9,23,1,10,24,2,16,41,15,33,29,7,42,21,44,34,30,36,8,22,0,39,27,13,19,5,14,28,6,20,45,11 },
	{ 9,22,3,29,33,46,23,26,28,0,44,27,20,38,1,14,18,45,21,25,39,42,15,19,12,24,6,43,36,40,13,16,34,7,10,37,41,17,30,35,11,4,8,31,2,32,5 },
	{ 31,2,13,16,43,36,6,3,28,17,42,7,26,29,0,46,41,22,27,4,1,45,40,23,10,5,24,35,44,14,11,20,25,39,34,15,18,21,8,38,33,30,19,12,9,37,32 },
	{ 42,9,11,0,2,32,12,14,21,44,23,37,29,39,31,16,41,18,43,24,34,26,1,3,46,13,15,4,6,36,8,10,17,40,19,33,25,35,27,20,45,22,28,38,30,5,7 },
	{ 46,24,28,8,42,12,25,29,9,43,13,16,20,32,0,36,4,17,21,33,1,37,5,14,26,40,31,44,10,15,27,41,30,45,11,38,6,18,23,34,2,39,7,19,22,35,3 },
	{ 43,37,33,42,36,32,46,13,5,9,1,12,4,8,0,28,20,24,16,29,21,25,17,45,35,41,44,34,40,39,38,11,3,31,23,10,2,30,22,26,18,15,7,27,19,14,6 },
},
{
	/* Frame 248 */
	{ 23,37,32,22,36,0,4,18,1,5,19,41,45,40,44,8,24,12,28,9,25,13,29,7,35,6,34,39,16,2,20,38,17,3,21,15,31,43,14,30,42,10,26,46,11,27,33 },
	{ 24,32,27,42,41,29,4,15,44,25,0,26,3,22,40,5,39,12,1,2,23,8,11,30,38,13,35,9,20,10,31,6,37,16,46,19,34,33,21,43,7,28,36,17,14,18,45 },
	{ 40,7,32,31,38,11,18,42,20,35,28,8,45,0,37,25,6,30,23,10,3,27,21,34,13,5,44,16,36,24,15,41,22,33,46,2,39,26,19,12,43,4,29,17,9,1,14 },
	{ 26,38,25,37,2,1,23,35,16,44,15,8,30,42,29,41,6,5,27,39,20,32,3,12,18,46,17,45,10,9,31,43,24,36,7,0,22,34,21,33,14,13,19,28,40,11,4 },
	{ 46,19,33,20,11,12,35,22,40,25,14,1,42,31,45,16,7,8,18,36,21,10,13,38,27,41,28,3,4,43,30,32,17,6,9,34,23,37,24,15,0,39,26,44,29,2,5 },
	{ 0,22,42,29,37,14,5,31,35,20,40,7,12,26,38,17,33,10,1,19,24,36,3,8,30,34,21,45,6,13,23,43,28,32,15,4,18,46,25,41,2,9,27,39,16,44,11 },
	{ 38,27,37,9,19,10,1,28,2,20,44,39,36,11,29,3,30,21,12,22,4,42,41,34,31,33,13,23,14,5,24,6,43,16,40,35,32,15,25,7,26,17,8,18,0,46,45 },
	{ 24,13,10,30,8,46,44,1,21,19,6,16,37,35,32,28,27,14,25,12,43,41,5,3,23,0,20,18,39,36,34,11,31,9,29,26,45,42,40,7,17,4,2,22,33,38,15 },
	{ 11,6,17,28,34,18,7,0,29,46,41,19,30,1,12,40,37,2,31,24,13,43,36,3,14,25,20,42,39,26,15,8,21,38,33,27,22,9,4,32,45,10,23,16,5,35,44 },
	{ 7,1,45,27,4,35,14,24,18,38,32,13,31,17,3,41,28,22,0,44,10,21,34,15,9,37,19,12,43,6,16,26,46,40,5,23,25,11,39,33,20,30,8,36,2,29,42 },
	{ 44,26,14,24,12,45,27,15,25,13,46,36,22,6,20,4,39,37,23,7,21,5,38,40,30,10,28,8,43,41,31,11,29,9,42,32,18,2,16,0,35,33,19,3,17,1,34 },
	{ 44,35,40,23,11,2,42,5,24,1,45,41,38,26,3,14,43,25,16,29,39,27,18,15,6,46,17,28,21,19,30,7,36,32,12,20,8,34,31,22,10,37,33,13,4,9,0 },
},
{
	/* Frame 249 */
	{ 32,25,35,30,13,2,41,20,46,23,8,11,36,29,39,18,1,6,45,24,34,27,12,15,40,17,43,22,5,10,33,28,38,31,0,3,44,21,26,9,14,37,16,42,19,4,7 },
	{ 35,5,41,31,21,14,34,4,40,30,20,11,1,37,27,17,10,46,0,36,26,16,7,43,13,33,23,29,6,42,12,32,22,28,3,39,9,45,19,25,2,38,8,44,18,24,15 },
	{ 21,7,31,45,39,12,20,6,30,44,38,9,17,3,27,41,35,8,16,2,26,40,34,5,29,15,23,37,4,28,14,22,36,46,1,25,11,19,33,43,0,24,10,18,32,42,13 },
	{ 35,4,8,46,34,5,9,14,2,36,40,15,3,37,41,20,24,21,25,30,18,31,19,39,43,12,0,38,42,13,1,6,10,44,32,7,11,45,33,28,16,29,17,22,26,23,27 },
	{ 34,39,33,36,2,16,19,22,9,12,43,15,40,29,26,38,0,37,3,6,17,20,23,13,42,41,44,10,24,27,30,1,4,35,7,32,21,18,46,8,45,11,14,25,28,31,5 },
	{ 41,12,18,32,5,27,16,45,34,22,25,36,43,31,20,2,38,29,11,0,6,9,15,33,4,26,40,13,19,24,37,42,30,17,44,35,23,28,10,46,21,3,39,8,14,1,7 },
	{ 41,7,18,20,1,46,37,40,22,19,13,0,36,23,2,12,25,43,14,3,29,24,39,42,33,15,26,28,9,38,45,32,30,27,5,8,44,31,10,4,17,35,6,11,21,16,34 },
	{ 30,18,25,21,31,19,24,20,10,2,45,37,43,35,13,5,11,3,44,36,42,34,12,4,26,22,29,17,27,23,28,16,14,6,41,33,39,9,1,15,7,40,32,46,38,8,0 },
	{ 33,44,2,9,16,42,37,6,13,20,46,25,1,26,41,29,5,30,32,45,35,8,17,11,18,39,21,15,22,0,27,3,40,43,36,31,7,12,34,10,19,24,38,14,23,28,4 },
	{ 25,26,4,7,12,15,0,3,8,38,11,46,23,34,31,42,19,27,37,6,45,20,14,33,28,2,41,16,10,24,22,5,30,13,1,36,9,39,44,21,32,29,35,40,17,43,18 },
	{ 23,1,41,12,10,15,0,5,40,45,43,14,24,33,4,3,44,42,25,28,32,37,2,7,16,46,29,27,36,35,6,17,20,26,31,34,39,21,18,30,9,38,19,22,8,13,11 },
	{ 46,29,45,15,8,27,43,24,36,6,5,22,34,17,33,3,12,31,28,40,10,9,26,38,21,37,7,0,19,35,16,44,14,13,30,42,25,41,11,4,23,39,20,32,2,1,18 },
},
{
	/* Frame 250 */
	{ 34,13,36,27,21,2,12,33,26,20,7,46,1,32,31,25,6,43,0,45,30,24,11,42,5,44,19,29,10,39,4,41,18,28,15,38,9,40,23,17,14,35,8,37,22,16,3 },
	{ 32,3,42,25,23,12,45,2,35,24,22,5,44,15,34,17,27,4,37,14,16,26,9,36,7,46,29,19,8,41,6,39,28,18,1,40,11,38,21,31,0,33,10,43,20,30,13 },
	{ 45,15,6,44,14,23,31,36,22,30,37,3,41,11,2,40,10,19,27,32,18,26,33,13,39,21,12,38,20,46,29,4,28,5,9,35,17,43,8,34,16,42,25,0,24,1,7 },
	{ 33,43,36,32,46,42,4,0,14,10,5,1,15,11,20,16,30,26,21,17,31,27,45,41,39,35,44,40,38,34,12,8,6,2,13,9,7,3,28,24,22,18,29,25,23,19,37 },
	{ 25,46,12,24,45,15,27,44,14,26,29,1,34,28,0,35,33,31,3,32,30,2,5,17,38,4,16,39,37,7,19,36,6,18,21,9,42,20,8,43,41,23,11,40,22,10,13 },
	{ 31,0,22,38,9,15,20,33,6,29,40,19,35,4,26,42,13,3,24,37,10,17,44,23,39,8,30,46,1,7,28,41,14,21,32,27,43,12,18,34,5,11,16,45,2,25,36 },
	{ 3,4,10,13,15,34,16,6,43,25,46,27,20,32,39,18,29,41,31,44,0,22,37,9,11,12,2,5,7,42,24,14,35,17,38,19,28,40,26,21,33,23,36,8,30,45,1 },
	{ 23,24,33,11,38,21,2,9,36,30,16,43,7,12,27,41,5,46,22,25,10,39,44,0,19,28,37,15,34,17,6,13,32,26,20,3,8,31,45,1,42,18,29,14,35,40,4 },
	{ 17,4,10,39,30,2,45,22,8,37,28,0,20,15,7,13,46,5,43,38,31,35,26,23,41,18,29,33,24,21,16,14,11,6,3,44,9,36,42,1,34,27,40,19,32,25,12 },
	{ 4,11,13,19,21,35,37,42,6,24,15,1,23,40,39,46,26,28,3,5,10,44,8,30,16,7,25,14,32,41,12,18,20,27,29,34,36,43,45,0,22,9,31,17,38,33,2 },
	{ 45,3,30,17,4,43,46,2,7,16,21,32,19,6,9,20,33,36,18,23,8,13,34,37,11,22,25,12,35,38,10,15,24,29,39,40,27,14,1,28,41,44,26,31,0,5,42 },
	{ 36,22,17,15,42,8,41,23,16,14,13,40,26,21,3,46,12,45,27,20,2,35,1,44,30,25,7,34,0,33,31,24,6,39,5,32,18,29,11,38,4,37,19,28,10,43,9 },
},
{
	/* Frame 251 */
	{ 35,31,36,24,7,0,46,22,33,29,10,5,43,19,44,20,15,8,34,30,41,17,6,13,39,27,32,28,3,4,42,18,37,25,14,1,23,40,16,11,12,38,26,45,21,2,9 },
	{ 27,13,4,26,12,37,45,18,36,44,19,1,21,9,29,0,20,8,28,33,41,32,40,15,17,39,25,14,16,38,24,6,46,7,11,31,35,10,30,34,43,2,22,42,3,23,5 },
	{ 23,45,39,12,28,6,22,44,38,13,29,3,19,41,35,8,24,2,18,40,34,9,25,15,31,37,4,20,14,30,36,46,5,21,11,27,33,43,0,16,10,26,32,42,1,17,7 },
	{ 16,5,26,15,20,34,30,40,38,25,44,19,0,29,10,23,33,4,14,37,35,9,3,39,24,13,18,7,28,42,22,32,46,17,36,27,8,21,2,31,41,12,6,45,43,1,11 },
	{ 20,5,23,6,0,3,33,29,44,30,42,24,9,27,10,4,7,37,35,17,32,18,46,28,13,31,14,8,11,41,39,21,36,22,34,16,1,19,2,12,15,45,43,25,40,26,38 },
	{ 34,39,16,21,10,15,38,1,20,19,14,40,0,5,18,23,41,44,43,25,4,3,22,45,42,24,29,2,7,46,9,28,27,6,32,8,13,26,31,33,36,35,17,12,11,30,37 },
	{ 28,32,10,16,7,13,3,9,30,4,18,37,0,23,43,29,33,38,27,44,17,6,34,20,40,2,24,15,5,11,1,22,12,39,26,45,8,31,35,21,41,46,19,36,25,14,42 },
	{ 2,30,33,35,1,29,3,31,32,34,0,28,22,14,45,21,13,23,15,44,46,20,12,6,26,37,39,5,25,7,27,36,38,4,24,18,10,41,43,17,9,19,11,40,42,16,8 },
	{ 17,38,8,33,23,14,19,10,44,35,5,29,20,1,25,46,16,7,41,31,32,22,3,37,27,18,43,13,34,4,39,9,0,15,6,40,30,11,45,2,36,26,28,21,42,12,24 },
	{ 19,40,4,27,34,12,42,6,1,14,9,3,16,11,24,33,18,41,21,26,35,29,36,43,23,44,0,31,38,8,46,2,5,10,13,7,20,15,28,37,22,45,17,30,39,25,32 },
	{ 45,8,29,10,31,24,36,39,33,20,2,23,17,5,40,42,12,26,14,9,28,11,34,37,18,6,0,21,3,44,46,41,43,30,25,13,27,15,38,32,35,22,16,4,19,7,1 },
	{ 44,4,38,14,21,31,45,5,39,15,20,30,32,0,42,10,17,27,33,1,43,11,16,26,36,12,46,6,29,23,37,13,7,28,22,40,8,34,2,25,19,41,9,35,3,24,18 },
},
{
	/* Frame 252 */
	{ 33,7,39,17,23,0,32,6,38,16,22,9,45,15,43,25,31,8,44,14,42,24,30,5,37,3,35,21,19,4,36,2,34,20,18,13,41,11,29,27,12,40,10,46,28,26,1 },
	{ 7,12,32,25,43,27,39,23,44,28,1,3,41,4,14,17,35,19,8,36,20,46,30,13,33,24,10,6,45,29,0,42,26,38,22,5,15,16,2,40,37,21,31,34,18,9,11 },
	{ 21,28,20,12,44,4,36,13,45,5,37,25,17,24,16,8,40,0,32,9,41,1,33,7,39,31,6,38,30,23,14,46,22,15,3,35,27,2,34,26,19,10,42,18,11,43,29 },
	{ 46,24,5,19,32,20,10,31,44,6,17,35,8,29,3,4,18,15,33,42,30,1,45,38,16,13,27,40,28,2,23,36,14,25,43,0,21,11,39,12,26,7,41,34,22,9,37 },
	{ 12,24,13,25,15,27,44,14,26,45,42,8,20,43,9,21,11,23,40,10,22,41,38,4,16,39,5,17,7,19,36,6,18,37,34,0,28,35,1,29,3,31,32,2,30,33,46 },
	{ 20,5,34,44,27,10,25,4,35,45,30,11,24,9,38,32,31,14,29,8,39,33,18,15,28,13,42,36,19,2,17,12,43,37,22,3,16,1,46,40,23,6,21,0,41,26,7 },
	{ 42,40,23,4,6,27,29,0,2,17,45,15,43,20,41,22,11,5,24,38,26,36,1,34,32,31,12,14,19,21,8,10,25,39,37,7,35,28,33,30,3,13,16,46,18,44,9 },
	{ 35,27,0,41,23,42,37,29,38,14,17,44,2,32,24,11,20,7,13,26,1,22,43,8,39,31,4,45,19,46,33,25,34,10,21,40,6,36,28,15,16,3,9,30,5,18,12 },
	{ 1,31,2,12,16,32,24,23,27,4,8,39,43,15,19,29,0,30,35,45,46,7,11,21,25,22,26,37,41,38,42,3,13,17,14,18,33,34,44,5,9,6,10,20,36,40,28 },
	{ 14,34,13,33,18,17,31,4,40,38,11,37,24,22,21,2,44,1,15,35,28,19,8,6,42,5,41,39,26,25,23,12,32,46,3,45,16,30,29,10,36,9,7,43,20,27,0 },
	{ 28,18,25,34,6,41,13,3,16,31,4,10,1,36,22,29,19,38,8,45,35,7,40,20,26,17,42,14,33,5,11,24,23,12,2,39,9,44,30,21,27,46,0,37,43,15,32 },
	{ 15,45,16,43,26,12,2,40,25,38,31,5,11,33,28,22,8,14,44,21,42,27,1,7,37,24,35,18,4,10,32,17,46,23,13,3,41,20,39,30,0,6,36,29,34,19,9 },
},
{
	/* Frame 253 */
	{ 26,0,25,38,5,41,17,15,12,27,33,24,3,30,4,29,40,16,43,45,21,32,2,31,37,28,7,42,19,44,20,35,36,6,10,18,9,46,23,34,1,39,11,8,14,22,13 },
	{ 33,31,21,14,42,4,32,30,20,15,43,1,45,27,17,10,38,0,44,26,16,11,39,13,41,23,29,6,34,12,40,22,28,7,35,9,37,19,25,2,46,8,36,18,24,3,5 },
	{ 19,39,24,44,3,8,30,34,17,37,14,1,23,43,28,32,7,12,18,38,21,41,2,5,27,16,36,11,0,22,42,25,45,6,9,31,35,20,40,15,4,26,46,29,33,10,13 },
	{ 21,39,12,20,38,45,6,30,44,7,31,9,17,35,8,16,34,41,2,26,40,3,27,5,29,4,28,46,37,14,22,36,15,23,1,25,43,0,24,42,33,10,18,32,11,19,13 },
	{ 0,36,42,15,33,20,26,17,35,6,40,13,3,24,23,4,10,46,1,37,30,21,27,39,8,44,34,7,41,28,18,25,43,14,32,5,11,16,31,12,2,38,9,45,22,29,19 },
	{ 40,37,35,46,8,18,25,20,11,6,33,13,42,23,16,36,2,9,4,19,30,21,7,32,45,43,38,0,26,17,28,3,14,41,5,34,31,24,44,10,39,1,12,27,22,29,15 },
	{ 40,45,27,30,0,5,44,10,31,25,4,35,11,14,24,29,34,39,33,18,15,9,28,38,32,37,19,22,8,13,36,2,23,17,12,43,3,6,16,21,42,41,26,7,1,20,46 },
	{ 34,13,16,23,10,36,38,35,28,17,14,11,39,29,0,15,18,41,4,1,30,19,45,40,42,5,24,31,2,44,46,43,20,25,6,3,21,8,7,26,33,12,9,22,27,37,32 },
	{ 25,2,44,4,26,28,33,7,21,31,13,36,42,22,16,14,39,8,19,45,5,11,34,29,6,40,0,30,24,37,43,3,17,27,9,32,46,18,20,10,35,12,23,41,1,15,38 },
	{ 30,12,14,32,29,34,31,13,15,33,28,35,16,18,40,0,42,2,17,19,41,1,43,3,24,26,36,8,38,10,25,27,37,9,39,11,22,44,4,46,6,21,23,45,5,7,20 },
	{ 41,0,13,24,36,42,2,14,27,38,29,9,20,45,30,10,22,40,46,33,12,25,5,16,35,26,7,18,8,21,1,44,37,43,23,3,15,32,39,4,17,28,34,6,19,31,11 },
	{ 44,37,6,31,21,13,22,42,32,35,8,19,11,1,24,38,45,14,4,29,7,30,20,40,43,33,2,27,17,9,18,46,36,39,12,23,15,5,28,34,41,10,0,25,3,26,16 },
},
{
	/* Frame 254 */
	{ 5,30,2,46,41,23,37,34,28,15,16,13,43,26,6,0,45,19,10,21,38,24,32,3,8,4,31,35,29,14,17,40,22,36,7,1,12,42,27,39,25,33,44,18,11,20,9 },
	{ 34,21,31,0,45,10,20,30,1,36,3,46,25,23,12,37,2,39,24,22,13,40,15,38,17,27,4,41,14,43,16,26,5,32,7,42,29,19,8,33,6,35,28,18,9,44,11 },
	{ 43,14,22,11,44,19,36,26,41,12,4,9,16,24,15,34,23,30,45,2,27,13,20,28,33,17,38,25,1,35,6,42,31,3,10,18,37,21,40,29,32,5,39,8,46,0,7 },
	{ 23,13,29,6,22,12,28,39,45,38,44,3,19,9,25,2,18,8,24,35,41,34,40,15,31,5,21,14,30,4,20,37,46,36,11,27,1,17,10,26,0,16,43,33,42,32,7 },
	{ 4,16,14,26,36,46,5,17,15,27,37,35,20,8,30,2,40,34,21,9,31,3,41,39,12,24,6,18,44,38,13,25,7,19,45,43,28,0,22,10,32,42,29,1,23,11,33 },
	{ 30,7,21,12,2,9,35,37,23,46,28,32,18,11,25,0,6,13,39,41,27,34,16,36,22,15,29,4,10,1,43,45,31,38,20,40,26,3,17,8,14,5,33,19,42,24,44 },
	{ 42,15,16,35,6,25,19,46,32,20,26,39,41,29,23,0,36,30,9,45,3,4,10,13,34,7,24,43,14,17,27,38,40,28,18,33,21,31,8,44,22,1,37,11,12,2,5 },
	{ 31,43,8,27,13,14,1,2,20,7,37,16,38,11,29,41,30,42,44,25,26,12,32,23,35,0,19,5,6,9,10,28,15,45,24,46,3,21,33,22,34,36,17,39,18,4,40 },
	{ 1,34,14,12,6,4,41,11,33,29,3,21,44,26,36,24,18,43,16,35,31,13,23,46,5,38,10,8,2,0,45,15,37,25,7,17,40,30,32,28,22,20,39,27,9,19,42 },
	{ 15,0,39,20,27,44,36,1,6,26,13,37,42,7,25,12,19,4,43,24,31,18,5,10,34,30,17,41,46,11,29,35,16,23,40,32,28,2,22,9,14,33,38,3,21,45,8 },
	{ 17,2,5,32,22,8,11,28,31,37,1,38,26,21,14,43,44,16,19,4,33,7,34,25,10,13,40,30,0,39,3,20,23,45,9,46,18,29,6,35,36,24,27,12,41,15,42 },
	{ 42,25,19,37,12,6,15,18,27,36,45,39,14,20,26,1,44,38,21,28,0,9,3,46,29,23,33,8,2,11,22,31,32,41,35,10,16,30,5,40,34,43,17,24,4,13,7 },
},
{
	/* Frame 255 */
	{ 10,46,21,3,30,39,34,23,8,18,12,1,36,32,29,11,16,20,42,31,6,26,35,9,19,44,40,37,24,33,28,5,17,14,43,7,27,2,38,45,22,41,13,25,0,4,15 },
	{ 39,46,38,14,26,6,18,15,27,7,19,43,21,35,42,20,34,10,2,28,11,3,29,5,17,45,4,16,44,37,12,24,36,13,25,1,41,0,40,33,30,8,22,32,31,9,23 },
	{ 12,26,38,17,41,2,9,19,24,36,11,0,30,42,21,45,6,13,23,35,28,40,15,4,18,46,25,33,10,1,27,39,16,44,3,8,22,34,29,37,14,5,31,43,20,32,7 },
	{ 38,44,19,35,20,41,30,3,17,4,14,1,42,32,23,39,24,45,18,7,21,8,2,5,46,36,27,43,28,33,22,11,25,12,6,9,34,40,31,16,37,26,15,29,0,10,13 },
	{ 6,28,44,23,35,8,3,21,37,30,46,1,10,16,32,27,39,12,7,25,41,18,34,5,14,20,36,31,43,0,11,29,45,22,38,9,2,24,40,19,4,15,17,33,26,42,13 },
	{ 2,46,32,13,35,30,16,19,41,4,42,7,9,26,21,14,0,44,3,28,31,17,37,10,38,40,5,43,22,24,27,33,12,34,15,1,18,29,6,8,36,11,39,20,23,25,45 },
	{ 8,36,43,6,41,20,27,25,34,15,32,13,2,16,30,4,11,39,9,37,23,21,26,46,0,44,35,14,33,28,19,17,42,7,40,5,10,24,22,12,3,1,45,31,29,18,38 },
	{ 35,46,25,20,11,6,8,21,18,7,33,9,4,19,30,32,45,42,16,5,2,31,44,43,38,17,28,3,14,39,0,29,26,15,41,1,12,27,22,40,37,34,24,13,10,23,36 },
	{ 9,22,42,20,39,26,37,24,31,35,29,33,19,44,17,14,12,40,10,8,7,5,38,3,1,30,34,28,18,45,16,23,43,21,41,27,36,25,6,4,32,2,0,15,13,46,11 },
	{ 8,20,46,41,14,18,9,21,40,15,19,28,4,34,37,26,2,29,5,35,36,27,3,12,16,42,45,10,22,13,17,43,44,11,23,24,0,38,33,30,6,25,1,39,32,31,7 },
	{ 44,34,36,42,45,35,37,43,22,18,30,26,6,2,14,10,23,19,31,27,7,3,15,11,40,38,46,32,41,39,33,12,8,20,16,29,25,4,0,13,9,21,17,28,24,5,1 },
	{ 46,34,40,36,35,41,37,10,2,12,4,27,19,29,21,11,3,13,5,26,18,28,20,42,38,44,32,43,39,45,33,14,6,8,0,31,23,25,17,15,7,9,1,30,22,24,16 },
},
};

