/*
 *	HT Editor
 *	ia64opc.h
 *
 *	Copyright (C) 1999-2002 Sebastian Biallas (sb@biallas.net)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef IA64OPC_H
#define IA64OPC_H

#include "io/types.h"

#define IA64_SLOT_INVALID 0x00
#define IA64_SLOT_M_UNIT  0x01
#define IA64_SLOT_I_UNIT  0x02
#define IA64_SLOT_L_UNIT  0x03
#define IA64_SLOT_X_UNIT  0x04
#define IA64_SLOT_F_UNIT  0x05
#define IA64_SLOT_B_UNIT  0x06

#define IA64_INST_ROLE_INT   0x00
#define IA64_INST_ROLE_MEM   0x10
#define IA64_INST_ROLE_FP    0x20
#define IA64_INST_ROLE_BR    0x30
#define IA64_INST_ROLE_LONG  0x40
#define IA64_INST_ROLE_COUNT 5

enum IA64EnumOpcode1 {
	IA64_OPCODE_INST_NONE = 0,
	IA64_OPCODE_ILLOP = IA64_OPCODE_INST_NONE,
	IA64_OPCODE_IGNOP,
	IA64_OPCODE_ADD_R1_R2_R3,
	IA64_OPCODE_ADD_R1_R2_R3_1,
	IA64_OPCODE_SUB_R1_R2_R3,
	IA64_OPCODE_SUB_R1_R2_R3_1,
	IA64_OPCODE_ADDP4_R1_R2_R3,
	IA64_OPCODE_AND_R1_R2_R3,
	IA64_OPCODE_ANDCM_R1_R2_R3,
	IA64_OPCODE_OR_R1_R2_R3,
	IA64_OPCODE_XOR_R1_R2_R3,
	IA64_OPCODE_SHLADD_R1_R2_COUNT2_R3,
	IA64_OPCODE_SHLADDP4_R1_R2_COUNT2_R3,
	IA64_OPCODE_SUB_R1_IMM8_R3,
	IA64_OPCODE_AND_R1_IMM8_R3,
	IA64_OPCODE_ANDCM_R1_IMM8_R3,
	IA64_OPCODE_OR_R1_IMM8_R3,
	IA64_OPCODE_XOR_R1_IMM8_R3,
	IA64_OPCODE_ADDS_R1_IMM14_R3,
	IA64_OPCODE_ADDP4_R1_IMM14_R3,
	IA64_OPCODE_ADDL_R1_IMM22_R3,
	IA64_OPCODE_CMP_LT_P1_P2_R2_R3,
	IA64_OPCODE_CMP_LTU_P1_P2_R2_R3,
	IA64_OPCODE_CMP_EQ_P1_P2_R2_R3,
	IA64_OPCODE_CMP_LT_UNC_P1_P2_R2_R3,
	IA64_OPCODE_CMP_LTU_UNC_P1_P2_R2_R3,
	IA64_OPCODE_CMP_EQ_UNC_P1_P2_R2_R3,
	IA64_OPCODE_CMP_EQ_AND_P1_P2_R2_R3,
	IA64_OPCODE_CMP_EQ_OR_P1_P2_R2_R3,
	IA64_OPCODE_CMP_EQ_OR_ANDCM_P1_P2_R2_R3,
	IA64_OPCODE_CMP_NE_AND_P1_P2_R2_R3,
	IA64_OPCODE_CMP_NE_OR_P1_P2_R2_R3,
	IA64_OPCODE_CMP_NE_OR_ANDCM_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_LT_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_LTU_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_EQ_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_LT_UNC_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_LTU_UNC_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_EQ_UNC_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_EQ_AND_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_EQ_OR_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_EQ_OR_ANDCM_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_NE_AND_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_NE_OR_P1_P2_R2_R3,
	IA64_OPCODE_CMP4_NE_OR_ANDCM_P1_P2_R2_R3,
	IA64_OPCODE_CMP_GT_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP_GT_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP_GT_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LE_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LE_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LE_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP_GE_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP_GE_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP_GE_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LT_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LT_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LT_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_GT_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_GT_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_GT_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_LE_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_LE_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_LE_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_GE_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_GE_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_GE_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_LT_AND_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_LT_OR_P1_P2_R0_R3,
	IA64_OPCODE_CMP4_LT_OR_ANDCM_P1_P2_R0_R3,
	IA64_OPCODE_CMP_LT_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_LTU_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_EQ_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_LT_UNC_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_LTU_UNC_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_EQ_UNC_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_EQ_AND_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_EQ_OR_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_EQ_OR_ANDCM_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_NE_AND_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_NE_OR_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP_NE_OR_ANDCM_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_LT_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_LTU_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_EQ_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_LT_UNC_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_LTU_UNC_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_EQ_UNC_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_EQ_AND_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_EQ_OR_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_EQ_OR_ANDCM_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_NE_AND_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_NE_OR_P1_P2_IMM8_R3,
	IA64_OPCODE_CMP4_NE_OR_ANDCM_P1_P2_IMM8_R3,
	IA64_OPCODE_PADD1_R1_R2_R3,
	IA64_OPCODE_PADD2_R1_R2_R3,
	IA64_OPCODE_PADD4_R1_R2_R3,
	IA64_OPCODE_PADD1_SSS_R1_R2_R3,
	IA64_OPCODE_PADD2_SSS_R1_R2_R3,
	IA64_OPCODE_PADD1_UUU_R1_R2_R3,
	IA64_OPCODE_PADD2_UUU_R1_R2_R3,
	IA64_OPCODE_PADD1_UUS_R1_R2_R3,
	IA64_OPCODE_PADD2_UUS_R1_R2_R3,
	IA64_OPCODE_PSUB1_R1_R2_R3,
	IA64_OPCODE_PSUB2_R1_R2_R3,
	IA64_OPCODE_PSUB4_R1_R2_R3,
	IA64_OPCODE_PSUB1_SSS_R1_R2_R3,
	IA64_OPCODE_PSUB2_SSS_R1_R2_R3,
	IA64_OPCODE_PSUB1_UUU_R1_R2_R3,
	IA64_OPCODE_PSUB2_UUU_R1_R2_R3,
	IA64_OPCODE_PSUB1_UUS_R1_R2_R3,
	IA64_OPCODE_PSUB2_UUS_R1_R2_R3,
	IA64_OPCODE_PAVG1_R1_R2_R3,
	IA64_OPCODE_PAVG2_R1_R2_R3,
	IA64_OPCODE_PAVG1_RAZ_R1_R2_R3,
	IA64_OPCODE_PAVG2_RAZ_R1_R2_R3,
	IA64_OPCODE_PAVGSUB1_R1_R2_R3,
	IA64_OPCODE_PAVGSUB2_R1_R2_R3,
	IA64_OPCODE_PCMP1_EQ_R1_R2_R3,
	IA64_OPCODE_PCMP2_EQ_R1_R2_R3,
	IA64_OPCODE_PCMP4_EQ_R1_R2_R3,
	IA64_OPCODE_PCMP1_GT_R1_R2_R3,
	IA64_OPCODE_PCMP2_GT_R1_R2_R3,
	IA64_OPCODE_PCMP4_GT_R1_R2_R3,
	IA64_OPCODE_PSHLADD2_R1_R2_COUNT2_R3,
	IA64_OPCODE_PSHRADD2_R1_R2_COUNT2_R3,
	IA64_OPCODE_PMPYSHR2_R1_R2_R3_COUNT2,
	IA64_OPCODE_PMPYSHR2_U_R1_R2_R3_COUNT2,
	IA64_OPCODE_PMPY2_R_R1_R2_R3,
	IA64_OPCODE_PMPY2_L_R1_R2_R3,
	IA64_OPCODE_MIX1_R_R1_R2_R3,
	IA64_OPCODE_MIX2_R_R1_R2_R3,
	IA64_OPCODE_MIX4_R_R1_R2_R3,
	IA64_OPCODE_MIX1_L_R1_R2_R3,
	IA64_OPCODE_MIX2_L_R1_R2_R3,
	IA64_OPCODE_MIX4_L_R1_R2_R3,
	IA64_OPCODE_PACK2_USS_R1_R2_R3,
	IA64_OPCODE_PACK2_SSS_R1_R2_R3,
	IA64_OPCODE_PACK4_SSS_R1_R2_R3,
	IA64_OPCODE_UNPACK1_H_R1_R2_R3,
	IA64_OPCODE_UNPACK2_H_R1_R2_R3,
	IA64_OPCODE_UNPACK4_H_R1_R2_R3,
	IA64_OPCODE_UNPACK1_L_R1_R2_R3,
	IA64_OPCODE_UNPACK2_L_R1_R2_R3,
	IA64_OPCODE_UNPACK4_L_R1_R2_R3,
	IA64_OPCODE_PMIN1_U_R1_R2_R3,
	IA64_OPCODE_PMAX1_U_R1_R2_R3,
	IA64_OPCODE_PMIN2_R1_R2_R3,
	IA64_OPCODE_PMAX2_R1_R2_R3,
	IA64_OPCODE_PSAD1_R1_R2_R3,
	IA64_OPCODE_MUX1_R1_R2_MBTYPE4,
	IA64_OPCODE_MUX2_R1_R2_MHTYPE8,
	IA64_OPCODE_PSHR2_R1_R3_R2,
	IA64_OPCODE_PSHR4_R1_R3_R2,
	IA64_OPCODE_SHR_R1_R3_R2,
	IA64_OPCODE_PSHR2_U_R1_R3_R2,
	IA64_OPCODE_PSHR4_U_R1_R3_R2,
	IA64_OPCODE_SHR_U_R1_R3_R2,
	IA64_OPCODE_PSHR2_R1_R3_COUNT5,
	IA64_OPCODE_PSHR4_R1_R3_COUNT5,
	IA64_OPCODE_PSHR2_U_R1_R3_COUNT5,
	IA64_OPCODE_PSHR4_U_R1_R3_COUNT5,
	IA64_OPCODE_PSHL2_R1_R2_R3,
	IA64_OPCODE_PSHL4_R1_R2_R3,
	IA64_OPCODE_SHL_R1_R2_R3,
	IA64_OPCODE_PSHL2_R1_R2_COUNT5,
	IA64_OPCODE_PSHL4_R1_R2_COUNT5,
	IA64_OPCODE_POPCNT_R1_R3,
	IA64_OPCODE_SHRP_R1_R2_R3_COUNT6,
	IA64_OPCODE_EXTR_U_R1_R3_POS6_LEN6,
	IA64_OPCODE_EXTR_R1_R3_POS6_LEN6,
	IA64_OPCODE_DEP_Z_R1_R2_POS6_LEN6,
	IA64_OPCODE_DEP_Z_R1_IMM8_POS6_LEN6,
	IA64_OPCODE_DEP_R1_IMM1_R3_POS6_LEN6,
	IA64_OPCODE_DEP_R1_R2_R3_POS6_LEN4,
	IA64_OPCODE_TBIT_Z_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_Z_UNC_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_Z_AND_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_NZ_AND_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_Z_OR_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_NZ_OR_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_Z_OR_ANDCM_P1_P2_R3_POS6,
	IA64_OPCODE_TBIT_NZ_OR_ANDCM_P1_P2_R3_POS6,
	IA64_OPCODE_TNAT_Z_P1_P2_R3,
	IA64_OPCODE_TNAT_Z_UNC_P1_P2_R3,
	IA64_OPCODE_TNAT_Z_AND_P1_P2_R3,
	IA64_OPCODE_TNAT_NZ_AND_P1_P2_R3,
	IA64_OPCODE_TNAT_Z_OR_P1_P2_R3,
	IA64_OPCODE_TNAT_NZ_OR_P1_P2_R3,
	IA64_OPCODE_TNAT_Z_OR_ANDCM_P1_P2_R3,
	IA64_OPCODE_TNAT_NZ_OR_ANDCM_P1_P2_R3,
	IA64_OPCODE_BREAK_I_IMM21,
	IA64_OPCODE_NOP_I_IMM21,
	IA64_OPCODE_CHK_S_I_R2_TARGET25,
	IA64_OPCODE_MOV_SPTK_B1_R2_TAG13,
	IA64_OPCODE_MOV_SPTK_IMP_B1_R2_TAG13,
	IA64_OPCODE_MOV_B1_R2_TAG13,
	IA64_OPCODE_MOV_IMP_B1_R2_TAG13,
	IA64_OPCODE_MOV_DPTK_B1_R2_TAG13,
	IA64_OPCODE_MOV_DPTK_IMP_B1_R2_TAG13,
	IA64_OPCODE_MOV_RET_SPTK_B1_R2_TAG13,
	IA64_OPCODE_MOV_RET_SPTK_IMP_B1_R2_TAG13,
	IA64_OPCODE_MOV_RET_B1_R2_TAG13,
	IA64_OPCODE_MOV_RET_IMP_B1_R2_TAG13,
	IA64_OPCODE_MOV_RET_DPTK_B1_R2_TAG13,
	IA64_OPCODE_MOV_RET_DPTK_IMP_B1_R2_TAG13,
	IA64_OPCODE_MOV_R1_B2,
	IA64_OPCODE_MOV_PR_R2_MASK17,
	IA64_OPCODE_MOV_PR_ROT_IMM44,
	IA64_OPCODE_MOV_R1_IP,
	IA64_OPCODE_MOV_R1_PR,
	IA64_OPCODE_MOV_I_AR3_R2,
	IA64_OPCODE_MOV_I_AR3_IMM8,
	IA64_OPCODE_MOV_I_R1_AR3,
	IA64_OPCODE_ZXT1_R1_R3,
	IA64_OPCODE_ZXT2_R1_R3,
	IA64_OPCODE_ZXT4_R1_R3,
	IA64_OPCODE_SXT1_R1_R3,
	IA64_OPCODE_SXT2_R1_R3,
	IA64_OPCODE_SXT4_R1_R3,
	IA64_OPCODE_CZX1_L_R1_R3,
	IA64_OPCODE_CZX2_L_R1_R3,
	IA64_OPCODE_CZX1_R_R1_R3,
	IA64_OPCODE_CZX2_R_R1_R3,
	IA64_OPCODE_LD1_R1_R3,
	IA64_OPCODE_LD1_NT1_R1_R3,
	IA64_OPCODE_LD1_NTA_R1_R3,
	IA64_OPCODE_LD2_R1_R3,
	IA64_OPCODE_LD2_NT1_R1_R3,
	IA64_OPCODE_LD2_NTA_R1_R3,
	IA64_OPCODE_LD4_R1_R3,
	IA64_OPCODE_LD4_NT1_R1_R3,
	IA64_OPCODE_LD4_NTA_R1_R3,
	IA64_OPCODE_LD8_R1_R3,
	IA64_OPCODE_LD8_NT1_R1_R3,
	IA64_OPCODE_LD8_NTA_R1_R3,
	IA64_OPCODE_LD1_S_R1_R3,
	IA64_OPCODE_LD1_S_NT1_R1_R3,
	IA64_OPCODE_LD1_S_NTA_R1_R3,
	IA64_OPCODE_LD2_S_R1_R3,
	IA64_OPCODE_LD2_S_NT1_R1_R3,
	IA64_OPCODE_LD2_S_NTA_R1_R3,
	IA64_OPCODE_LD4_S_R1_R3,
	IA64_OPCODE_LD4_S_NT1_R1_R3,
	IA64_OPCODE_LD4_S_NTA_R1_R3,
	IA64_OPCODE_LD8_S_R1_R3,
	IA64_OPCODE_LD8_S_NT1_R1_R3,
	IA64_OPCODE_LD8_S_NTA_R1_R3,
	IA64_OPCODE_LD1_A_R1_R3,
	IA64_OPCODE_LD1_A_NT1_R1_R3,
	IA64_OPCODE_LD1_A_NTA_R1_R3,
	IA64_OPCODE_LD2_A_R1_R3,
	IA64_OPCODE_LD2_A_NT1_R1_R3,
	IA64_OPCODE_LD2_A_NTA_R1_R3,
	IA64_OPCODE_LD4_A_R1_R3,
	IA64_OPCODE_LD4_A_NT1_R1_R3,
	IA64_OPCODE_LD4_A_NTA_R1_R3,
	IA64_OPCODE_LD8_A_R1_R3,
	IA64_OPCODE_LD8_A_NT1_R1_R3,
	IA64_OPCODE_LD8_A_NTA_R1_R3,
	IA64_OPCODE_LD1_SA_R1_R3,
	IA64_OPCODE_LD1_SA_NT1_R1_R3,
	IA64_OPCODE_LD1_SA_NTA_R1_R3,
	IA64_OPCODE_LD2_SA_R1_R3,
	IA64_OPCODE_LD2_SA_NT1_R1_R3,
	IA64_OPCODE_LD2_SA_NTA_R1_R3,
	IA64_OPCODE_LD4_SA_R1_R3,
	IA64_OPCODE_LD4_SA_NT1_R1_R3,
	IA64_OPCODE_LD4_SA_NTA_R1_R3,
	IA64_OPCODE_LD8_SA_R1_R3,
	IA64_OPCODE_LD8_SA_NT1_R1_R3,
	IA64_OPCODE_LD8_SA_NTA_R1_R3,
	IA64_OPCODE_LD1_BIAS_R1_R3,
	IA64_OPCODE_LD1_BIAS_NT1_R1_R3,
	IA64_OPCODE_LD1_BIAS_NTA_R1_R3,
	IA64_OPCODE_LD2_BIAS_R1_R3,
	IA64_OPCODE_LD2_BIAS_NT1_R1_R3,
	IA64_OPCODE_LD2_BIAS_NTA_R1_R3,
	IA64_OPCODE_LD4_BIAS_R1_R3,
	IA64_OPCODE_LD4_BIAS_NT1_R1_R3,
	IA64_OPCODE_LD4_BIAS_NTA_R1_R3,
	IA64_OPCODE_LD8_BIAS_R1_R3,
	IA64_OPCODE_LD8_BIAS_NT1_R1_R3,
	IA64_OPCODE_LD8_BIAS_NTA_R1_R3,
	IA64_OPCODE_LD1_ACQ_R1_R3,
	IA64_OPCODE_LD1_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD1_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD2_ACQ_R1_R3,
	IA64_OPCODE_LD2_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD2_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD4_ACQ_R1_R3,
	IA64_OPCODE_LD4_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD4_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD8_ACQ_R1_R3,
	IA64_OPCODE_LD8_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD8_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD8_FILL_R1_R3,
	IA64_OPCODE_LD8_FILL_NT1_R1_R3,
	IA64_OPCODE_LD8_FILL_NTA_R1_R3,
	IA64_OPCODE_LD1_C_CLR_R1_R3,
	IA64_OPCODE_LD1_C_CLR_NT1_R1_R3,
	IA64_OPCODE_LD1_C_CLR_NTA_R1_R3,
	IA64_OPCODE_LD2_C_CLR_R1_R3,
	IA64_OPCODE_LD2_C_CLR_NT1_R1_R3,
	IA64_OPCODE_LD2_C_CLR_NTA_R1_R3,
	IA64_OPCODE_LD4_C_CLR_R1_R3,
	IA64_OPCODE_LD4_C_CLR_NT1_R1_R3,
	IA64_OPCODE_LD4_C_CLR_NTA_R1_R3,
	IA64_OPCODE_LD8_C_CLR_R1_R3,
	IA64_OPCODE_LD8_C_CLR_NT1_R1_R3,
	IA64_OPCODE_LD8_C_CLR_NTA_R1_R3,
	IA64_OPCODE_LD1_C_NC_R1_R3,
	IA64_OPCODE_LD1_C_NC_NT1_R1_R3,
	IA64_OPCODE_LD1_C_NC_NTA_R1_R3,
	IA64_OPCODE_LD2_C_NC_R1_R3,
	IA64_OPCODE_LD2_C_NC_NT1_R1_R3,
	IA64_OPCODE_LD2_C_NC_NTA_R1_R3,
	IA64_OPCODE_LD4_C_NC_R1_R3,
	IA64_OPCODE_LD4_C_NC_NT1_R1_R3,
	IA64_OPCODE_LD4_C_NC_NTA_R1_R3,
	IA64_OPCODE_LD8_C_NC_R1_R3,
	IA64_OPCODE_LD8_C_NC_NT1_R1_R3,
	IA64_OPCODE_LD8_C_NC_NTA_R1_R3,
	IA64_OPCODE_LD1_C_CLR_ACQ_R1_R3,
	IA64_OPCODE_LD1_C_CLR_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD1_C_CLR_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD2_C_CLR_ACQ_R1_R3,
	IA64_OPCODE_LD2_C_CLR_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD2_C_CLR_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD4_C_CLR_ACQ_R1_R3,
	IA64_OPCODE_LD4_C_CLR_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD4_C_CLR_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD8_C_CLR_ACQ_R1_R3,
	IA64_OPCODE_LD8_C_CLR_ACQ_NT1_R1_R3,
	IA64_OPCODE_LD8_C_CLR_ACQ_NTA_R1_R3,
	IA64_OPCODE_LD1_R1_R3_R2,
	IA64_OPCODE_LD1_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_R1_R3_R2,
	IA64_OPCODE_LD2_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_R1_R3_R2,
	IA64_OPCODE_LD4_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_R1_R3_R2,
	IA64_OPCODE_LD8_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_S_R1_R3_R2,
	IA64_OPCODE_LD1_S_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_S_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_S_R1_R3_R2,
	IA64_OPCODE_LD2_S_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_S_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_S_R1_R3_R2,
	IA64_OPCODE_LD4_S_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_S_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_S_R1_R3_R2,
	IA64_OPCODE_LD8_S_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_S_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_A_R1_R3_R2,
	IA64_OPCODE_LD1_A_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_A_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_A_R1_R3_R2,
	IA64_OPCODE_LD2_A_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_A_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_A_R1_R3_R2,
	IA64_OPCODE_LD4_A_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_A_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_A_R1_R3_R2,
	IA64_OPCODE_LD8_A_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_A_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_SA_R1_R3_R2,
	IA64_OPCODE_LD1_SA_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_SA_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_SA_R1_R3_R2,
	IA64_OPCODE_LD2_SA_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_SA_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_SA_R1_R3_R2,
	IA64_OPCODE_LD4_SA_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_SA_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_SA_R1_R3_R2,
	IA64_OPCODE_LD8_SA_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_SA_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_BIAS_R1_R3_R2,
	IA64_OPCODE_LD1_BIAS_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_BIAS_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_BIAS_R1_R3_R2,
	IA64_OPCODE_LD2_BIAS_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_BIAS_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_BIAS_R1_R3_R2,
	IA64_OPCODE_LD4_BIAS_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_BIAS_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_BIAS_R1_R3_R2,
	IA64_OPCODE_LD8_BIAS_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_BIAS_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_ACQ_R1_R3_R2,
	IA64_OPCODE_LD1_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_ACQ_R1_R3_R2,
	IA64_OPCODE_LD2_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_ACQ_R1_R3_R2,
	IA64_OPCODE_LD4_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_ACQ_R1_R3_R2,
	IA64_OPCODE_LD8_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_FILL_R1_R3_R2,
	IA64_OPCODE_LD8_FILL_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_FILL_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_C_CLR_R1_R3_R2,
	IA64_OPCODE_LD1_C_CLR_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_C_CLR_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_C_CLR_R1_R3_R2,
	IA64_OPCODE_LD2_C_CLR_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_C_CLR_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_C_CLR_R1_R3_R2,
	IA64_OPCODE_LD4_C_CLR_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_C_CLR_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_C_CLR_R1_R3_R2,
	IA64_OPCODE_LD8_C_CLR_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_C_CLR_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_C_NC_R1_R3_R2,
	IA64_OPCODE_LD1_C_NC_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_C_NC_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_C_NC_R1_R3_R2,
	IA64_OPCODE_LD2_C_NC_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_C_NC_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_C_NC_R1_R3_R2,
	IA64_OPCODE_LD4_C_NC_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_C_NC_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_C_NC_R1_R3_R2,
	IA64_OPCODE_LD8_C_NC_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_C_NC_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_C_CLR_ACQ_R1_R3_R2,
	IA64_OPCODE_LD1_C_CLR_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD1_C_CLR_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD2_C_CLR_ACQ_R1_R3_R2,
	IA64_OPCODE_LD2_C_CLR_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD2_C_CLR_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD4_C_CLR_ACQ_R1_R3_R2,
	IA64_OPCODE_LD4_C_CLR_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD4_C_CLR_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD8_C_CLR_ACQ_R1_R3_R2,
	IA64_OPCODE_LD8_C_CLR_ACQ_NT1_R1_R3_R2,
	IA64_OPCODE_LD8_C_CLR_ACQ_NTA_R1_R3_R2,
	IA64_OPCODE_LD1_R1_R3_IMM9,
	IA64_OPCODE_LD1_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_R1_R3_IMM9,
	IA64_OPCODE_LD2_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_R1_R3_IMM9,
	IA64_OPCODE_LD4_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_R1_R3_IMM9,
	IA64_OPCODE_LD8_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_S_R1_R3_IMM9,
	IA64_OPCODE_LD1_S_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_S_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_S_R1_R3_IMM9,
	IA64_OPCODE_LD2_S_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_S_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_S_R1_R3_IMM9,
	IA64_OPCODE_LD4_S_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_S_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_S_R1_R3_IMM9,
	IA64_OPCODE_LD8_S_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_S_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_A_R1_R3_IMM9,
	IA64_OPCODE_LD1_A_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_A_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_A_R1_R3_IMM9,
	IA64_OPCODE_LD2_A_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_A_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_A_R1_R3_IMM9,
	IA64_OPCODE_LD4_A_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_A_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_A_R1_R3_IMM9,
	IA64_OPCODE_LD8_A_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_A_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_SA_R1_R3_IMM9,
	IA64_OPCODE_LD1_SA_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_SA_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_SA_R1_R3_IMM9,
	IA64_OPCODE_LD2_SA_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_SA_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_SA_R1_R3_IMM9,
	IA64_OPCODE_LD4_SA_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_SA_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_SA_R1_R3_IMM9,
	IA64_OPCODE_LD8_SA_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_SA_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_BIAS_R1_R3_IMM9,
	IA64_OPCODE_LD1_BIAS_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_BIAS_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_BIAS_R1_R3_IMM9,
	IA64_OPCODE_LD2_BIAS_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_BIAS_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_BIAS_R1_R3_IMM9,
	IA64_OPCODE_LD4_BIAS_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_BIAS_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_BIAS_R1_R3_IMM9,
	IA64_OPCODE_LD8_BIAS_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_BIAS_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD1_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD2_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD4_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD8_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_FILL_R1_R3_IMM9,
	IA64_OPCODE_LD8_FILL_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_FILL_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_CLR_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_CLR_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_CLR_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_CLR_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_CLR_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_CLR_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_CLR_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_CLR_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_CLR_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_CLR_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_CLR_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_CLR_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_NC_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_NC_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_NC_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_NC_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_NC_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_NC_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_NC_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_NC_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_NC_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_NC_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_NC_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_NC_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_CLR_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_CLR_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD1_C_CLR_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_CLR_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_CLR_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD2_C_CLR_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_CLR_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_CLR_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD4_C_CLR_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_CLR_ACQ_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_CLR_ACQ_NT1_R1_R3_IMM9,
	IA64_OPCODE_LD8_C_CLR_ACQ_NTA_R1_R3_IMM9,
	IA64_OPCODE_ST1_R3_R2,
	IA64_OPCODE_ST1_NTA_R3_R2,
	IA64_OPCODE_ST2_R3_R2,
	IA64_OPCODE_ST2_NTA_R3_R2,
	IA64_OPCODE_ST4_R3_R2,
	IA64_OPCODE_ST4_NTA_R3_R2,
	IA64_OPCODE_ST8_R3_R2,
	IA64_OPCODE_ST8_NTA_R3_R2,
	IA64_OPCODE_ST1_REL_R3_R2,
	IA64_OPCODE_ST1_REL_NTA_R3_R2,
	IA64_OPCODE_ST2_REL_R3_R2,
	IA64_OPCODE_ST2_REL_NTA_R3_R2,
	IA64_OPCODE_ST4_REL_R3_R2,
	IA64_OPCODE_ST4_REL_NTA_R3_R2,
	IA64_OPCODE_ST8_REL_R3_R2,
	IA64_OPCODE_ST8_REL_NTA_R3_R2,
	IA64_OPCODE_ST8_SPILL_R3_R2,
	IA64_OPCODE_ST8_SPILL_NTA_R3_R2,
	IA64_OPCODE_ST1_R3_R2_IMM9,
	IA64_OPCODE_ST1_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST2_R3_R2_IMM9,
	IA64_OPCODE_ST2_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST4_R3_R2_IMM9,
	IA64_OPCODE_ST4_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST8_R3_R2_IMM9,
	IA64_OPCODE_ST8_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST1_REL_R3_R2_IMM9,
	IA64_OPCODE_ST1_REL_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST2_REL_R3_R2_IMM9,
	IA64_OPCODE_ST2_REL_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST4_REL_R3_R2_IMM9,
	IA64_OPCODE_ST4_REL_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST8_REL_R3_R2_IMM9,
	IA64_OPCODE_ST8_REL_NTA_R3_R2_IMM9,
	IA64_OPCODE_ST8_SPILL_R3_R2_IMM9,
	IA64_OPCODE_ST8_SPILL_NTA_R3_R2_IMM9,
	IA64_OPCODE_LDFS_F1_R3,
	IA64_OPCODE_LDFS_NT1_F1_R3,
	IA64_OPCODE_LDFS_NTA_F1_R3,
	IA64_OPCODE_LDFD_F1_R3,
	IA64_OPCODE_LDFD_NT1_F1_R3,
	IA64_OPCODE_LDFD_NTA_F1_R3,
	IA64_OPCODE_LDF8_F1_R3,
	IA64_OPCODE_LDF8_NT1_F1_R3,
	IA64_OPCODE_LDF8_NTA_F1_R3,
	IA64_OPCODE_LDFE_F1_R3,
	IA64_OPCODE_LDFE_NT1_F1_R3,
	IA64_OPCODE_LDFE_NTA_F1_R3,
	IA64_OPCODE_LDFS_S_F1_R3,
	IA64_OPCODE_LDFS_S_NT1_F1_R3,
	IA64_OPCODE_LDFS_S_NTA_F1_R3,
	IA64_OPCODE_LDFD_S_F1_R3,
	IA64_OPCODE_LDFD_S_NT1_F1_R3,
	IA64_OPCODE_LDFD_S_NTA_F1_R3,
	IA64_OPCODE_LDF8_S_F1_R3,
	IA64_OPCODE_LDF8_S_NT1_F1_R3,
	IA64_OPCODE_LDF8_S_NTA_F1_R3,
	IA64_OPCODE_LDFE_S_F1_R3,
	IA64_OPCODE_LDFE_S_NT1_F1_R3,
	IA64_OPCODE_LDFE_S_NTA_F1_R3,
	IA64_OPCODE_LDFS_A_F1_R3,
	IA64_OPCODE_LDFS_A_NT1_F1_R3,
	IA64_OPCODE_LDFS_A_NTA_F1_R3,
	IA64_OPCODE_LDFD_A_F1_R3,
	IA64_OPCODE_LDFD_A_NT1_F1_R3,
	IA64_OPCODE_LDFD_A_NTA_F1_R3,
	IA64_OPCODE_LDF8_A_F1_R3,
	IA64_OPCODE_LDF8_A_NT1_F1_R3,
	IA64_OPCODE_LDF8_A_NTA_F1_R3,
	IA64_OPCODE_LDFE_A_F1_R3,
	IA64_OPCODE_LDFE_A_NT1_F1_R3,
	IA64_OPCODE_LDFE_A_NTA_F1_R3,
	IA64_OPCODE_LDFS_SA_F1_R3,
	IA64_OPCODE_LDFS_SA_NT1_F1_R3,
	IA64_OPCODE_LDFS_SA_NTA_F1_R3,
	IA64_OPCODE_LDFD_SA_F1_R3,
	IA64_OPCODE_LDFD_SA_NT1_F1_R3,
	IA64_OPCODE_LDFD_SA_NTA_F1_R3,
	IA64_OPCODE_LDF8_SA_F1_R3,
	IA64_OPCODE_LDF8_SA_NT1_F1_R3,
	IA64_OPCODE_LDF8_SA_NTA_F1_R3,
	IA64_OPCODE_LDFE_SA_F1_R3,
	IA64_OPCODE_LDFE_SA_NT1_F1_R3,
	IA64_OPCODE_LDFE_SA_NTA_F1_R3,
	IA64_OPCODE_LDF_FILL_F1_R3,
	IA64_OPCODE_LDF_FILL_NT1_F1_R3,
	IA64_OPCODE_LDF_FILL_NTA_F1_R3,
	IA64_OPCODE_LDFS_C_CLR_F1_R3,
	IA64_OPCODE_LDFS_C_CLR_NT1_F1_R3,
	IA64_OPCODE_LDFS_C_CLR_NTA_F1_R3,
	IA64_OPCODE_LDFD_C_CLR_F1_R3,
	IA64_OPCODE_LDFD_C_CLR_NT1_F1_R3,
	IA64_OPCODE_LDFD_C_CLR_NTA_F1_R3,
	IA64_OPCODE_LDF8_C_CLR_F1_R3,
	IA64_OPCODE_LDF8_C_CLR_NT1_F1_R3,
	IA64_OPCODE_LDF8_C_CLR_NTA_F1_R3,
	IA64_OPCODE_LDFE_C_CLR_F1_R3,
	IA64_OPCODE_LDFE_C_CLR_NT1_F1_R3,
	IA64_OPCODE_LDFE_C_CLR_NTA_F1_R3,
	IA64_OPCODE_LDFS_C_NC_F1_R3,
	IA64_OPCODE_LDFS_C_NC_NT1_F1_R3,
	IA64_OPCODE_LDFS_C_NC_NTA_F1_R3,
	IA64_OPCODE_LDFD_C_NC_F1_R3,
	IA64_OPCODE_LDFD_C_NC_NT1_F1_R3,
	IA64_OPCODE_LDFD_C_NC_NTA_F1_R3,
	IA64_OPCODE_LDF8_C_NC_F1_R3,
	IA64_OPCODE_LDF8_C_NC_NT1_F1_R3,
	IA64_OPCODE_LDF8_C_NC_NTA_F1_R3,
	IA64_OPCODE_LDFE_C_NC_F1_R3,
	IA64_OPCODE_LDFE_C_NC_NT1_F1_R3,
	IA64_OPCODE_LDFE_C_NC_NTA_F1_R3,
	IA64_OPCODE_LDFS_F1_R3_R2,
	IA64_OPCODE_LDFS_NT1_F1_R3_R2,
	IA64_OPCODE_LDFS_NTA_F1_R3_R2,
	IA64_OPCODE_LDFD_F1_R3_R2,
	IA64_OPCODE_LDFD_NT1_F1_R3_R2,
	IA64_OPCODE_LDFD_NTA_F1_R3_R2,
	IA64_OPCODE_LDF8_F1_R3_R2,
	IA64_OPCODE_LDF8_NT1_F1_R3_R2,
	IA64_OPCODE_LDF8_NTA_F1_R3_R2,
	IA64_OPCODE_LDFE_F1_R3_R2,
	IA64_OPCODE_LDFE_NT1_F1_R3_R2,
	IA64_OPCODE_LDFE_NTA_F1_R3_R2,
	IA64_OPCODE_LDFS_S_F1_R3_R2,
	IA64_OPCODE_LDFS_S_NT1_F1_R3_R2,
	IA64_OPCODE_LDFS_S_NTA_F1_R3_R2,
	IA64_OPCODE_LDFD_S_F1_R3_R2,
	IA64_OPCODE_LDFD_S_NT1_F1_R3_R2,
	IA64_OPCODE_LDFD_S_NTA_F1_R3_R2,
	IA64_OPCODE_LDF8_S_F1_R3_R2,
	IA64_OPCODE_LDF8_S_NT1_F1_R3_R2,
	IA64_OPCODE_LDF8_S_NTA_F1_R3_R2,
	IA64_OPCODE_LDFE_S_F1_R3_R2,
	IA64_OPCODE_LDFE_S_NT1_F1_R3_R2,
	IA64_OPCODE_LDFE_S_NTA_F1_R3_R2,
	IA64_OPCODE_LDFS_A_F1_R3_R2,
	IA64_OPCODE_LDFS_A_NT1_F1_R3_R2,
	IA64_OPCODE_LDFS_A_NTA_F1_R3_R2,
	IA64_OPCODE_LDFD_A_F1_R3_R2,
	IA64_OPCODE_LDFD_A_NT1_F1_R3_R2,
	IA64_OPCODE_LDFD_A_NTA_F1_R3_R2,
	IA64_OPCODE_LDF8_A_F1_R3_R2,
	IA64_OPCODE_LDF8_A_NT1_F1_R3_R2,
	IA64_OPCODE_LDF8_A_NTA_F1_R3_R2,
	IA64_OPCODE_LDFE_A_F1_R3_R2,
	IA64_OPCODE_LDFE_A_NT1_F1_R3_R2,
	IA64_OPCODE_LDFE_A_NTA_F1_R3_R2,
	IA64_OPCODE_LDFS_SA_F1_R3_R2,
	IA64_OPCODE_LDFS_SA_NT1_F1_R3_R2,
	IA64_OPCODE_LDFS_SA_NTA_F1_R3_R2,
	IA64_OPCODE_LDFD_SA_F1_R3_R2,
	IA64_OPCODE_LDFD_SA_NT1_F1_R3_R2,
	IA64_OPCODE_LDFD_SA_NTA_F1_R3_R2,
	IA64_OPCODE_LDF8_SA_F1_R3_R2,
	IA64_OPCODE_LDF8_SA_NT1_F1_R3_R2,
	IA64_OPCODE_LDF8_SA_NTA_F1_R3_R2,
	IA64_OPCODE_LDFE_SA_F1_R3_R2,
	IA64_OPCODE_LDFE_SA_NT1_F1_R3_R2,
	IA64_OPCODE_LDFE_SA_NTA_F1_R3_R2,
	IA64_OPCODE_LDF_FILL_F1_R3_R2,
	IA64_OPCODE_LDF_FILL_NT1_F1_R3_R2,
	IA64_OPCODE_LDF_FILL_NTA_F1_R3_R2,
	IA64_OPCODE_LDFS_C_CLR_F1_R3_R2,
	IA64_OPCODE_LDFS_C_CLR_NT1_F1_R3_R2,
	IA64_OPCODE_LDFS_C_CLR_NTA_F1_R3_R2,
	IA64_OPCODE_LDFD_C_CLR_F1_R3_R2,
	IA64_OPCODE_LDFD_C_CLR_NT1_F1_R3_R2,
	IA64_OPCODE_LDFD_C_CLR_NTA_F1_R3_R2,
	IA64_OPCODE_LDF8_C_CLR_F1_R3_R2,
	IA64_OPCODE_LDF8_C_CLR_NT1_F1_R3_R2,
	IA64_OPCODE_LDF8_C_CLR_NTA_F1_R3_R2,
	IA64_OPCODE_LDFE_C_CLR_F1_R3_R2,
	IA64_OPCODE_LDFE_C_CLR_NT1_F1_R3_R2,
	IA64_OPCODE_LDFE_C_CLR_NTA_F1_R3_R2,
	IA64_OPCODE_LDFS_C_NC_F1_R3_R2,
	IA64_OPCODE_LDFS_C_NC_NT1_F1_R3_R2,
	IA64_OPCODE_LDFS_C_NC_NTA_F1_R3_R2,
	IA64_OPCODE_LDFD_C_NC_F1_R3_R2,
	IA64_OPCODE_LDFD_C_NC_NT1_F1_R3_R2,
	IA64_OPCODE_LDFD_C_NC_NTA_F1_R3_R2,
	IA64_OPCODE_LDF8_C_NC_F1_R3_R2,
	IA64_OPCODE_LDF8_C_NC_NT1_F1_R3_R2,
	IA64_OPCODE_LDF8_C_NC_NTA_F1_R3_R2,
	IA64_OPCODE_LDFE_C_NC_F1_R3_R2,
	IA64_OPCODE_LDFE_C_NC_NT1_F1_R3_R2,
	IA64_OPCODE_LDFE_C_NC_NTA_F1_R3_R2,
	IA64_OPCODE_LDFS_F1_R3_IMM9,
	IA64_OPCODE_LDFS_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFS_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_F1_R3_IMM9,
	IA64_OPCODE_LDFD_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFD_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_F1_R3_IMM9,
	IA64_OPCODE_LDF8_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF8_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_F1_R3_IMM9,
	IA64_OPCODE_LDFE_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFE_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFS_S_F1_R3_IMM9,
	IA64_OPCODE_LDFS_S_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFS_S_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_S_F1_R3_IMM9,
	IA64_OPCODE_LDFD_S_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFD_S_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_S_F1_R3_IMM9,
	IA64_OPCODE_LDF8_S_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF8_S_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_S_F1_R3_IMM9,
	IA64_OPCODE_LDFE_S_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFE_S_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFS_A_F1_R3_IMM9,
	IA64_OPCODE_LDFS_A_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFS_A_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_A_F1_R3_IMM9,
	IA64_OPCODE_LDFD_A_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFD_A_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_A_F1_R3_IMM9,
	IA64_OPCODE_LDF8_A_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF8_A_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_A_F1_R3_IMM9,
	IA64_OPCODE_LDFE_A_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFE_A_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFS_SA_F1_R3_IMM9,
	IA64_OPCODE_LDFS_SA_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFS_SA_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_SA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_SA_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFD_SA_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_SA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_SA_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF8_SA_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_SA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_SA_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFE_SA_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF_FILL_F1_R3_IMM9,
	IA64_OPCODE_LDF_FILL_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF_FILL_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFS_C_CLR_F1_R3_IMM9,
	IA64_OPCODE_INST1_LAST
};

enum IA64EnumOpcode2 {
	IA64_OPCODE_LDFS_C_CLR_NT1_F1_R3_IMM9 = 	IA64_OPCODE_INST1_LAST,
	IA64_OPCODE_LDFS_C_CLR_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_C_CLR_F1_R3_IMM9,
	IA64_OPCODE_LDFD_C_CLR_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFD_C_CLR_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_C_CLR_F1_R3_IMM9,
	IA64_OPCODE_LDF8_C_CLR_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF8_C_CLR_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_C_CLR_F1_R3_IMM9,
	IA64_OPCODE_LDFE_C_CLR_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFE_C_CLR_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFS_C_NC_F1_R3_IMM9,
	IA64_OPCODE_LDFS_C_NC_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFS_C_NC_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFD_C_NC_F1_R3_IMM9,
	IA64_OPCODE_LDFD_C_NC_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFD_C_NC_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDF8_C_NC_F1_R3_IMM9,
	IA64_OPCODE_LDF8_C_NC_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDF8_C_NC_NTA_F1_R3_IMM9,
	IA64_OPCODE_LDFE_C_NC_F1_R3_IMM9,
	IA64_OPCODE_LDFE_C_NC_NT1_F1_R3_IMM9,
	IA64_OPCODE_LDFE_C_NC_NTA_F1_R3_IMM9,
	IA64_OPCODE_STFS_R3_F2,
	IA64_OPCODE_STFS_NTA_R3_F2,
	IA64_OPCODE_STFD_R3_F2,
	IA64_OPCODE_STFD_NTA_R3_F2,
	IA64_OPCODE_STF8_R3_F2,
	IA64_OPCODE_STF8_NTA_R3_F2,
	IA64_OPCODE_STFE_R3_F2,
	IA64_OPCODE_STFE_NTA_R3_F2,
	IA64_OPCODE_STF_SPILL_R3_F2,
	IA64_OPCODE_STF_SPILL_NTA_R3_F2,
	IA64_OPCODE_STFS_R3_F2_IMM9,
	IA64_OPCODE_STFS_NTA_R3_F2_IMM9,
	IA64_OPCODE_STFD_R3_F2_IMM9,
	IA64_OPCODE_STFD_NTA_R3_F2_IMM9,
	IA64_OPCODE_STF8_R3_F2_IMM9,
	IA64_OPCODE_STF8_NTA_R3_F2_IMM9,
	IA64_OPCODE_STFE_R3_F2_IMM9,
	IA64_OPCODE_STFE_NTA_R3_F2_IMM9,
	IA64_OPCODE_STF_SPILL_R3_F2_IMM9,
	IA64_OPCODE_STF_SPILL_NTA_R3_F2_IMM9,
	IA64_OPCODE_LDFPS_F1_F2_R3,
	IA64_OPCODE_LDFPS_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPS_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPD_F1_F2_R3,
	IA64_OPCODE_LDFPD_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPD_NTA_F1_F2_R3,
	IA64_OPCODE_LDFP8_F1_F2_R3,
	IA64_OPCODE_LDFP8_NT1_F1_F2_R3,
	IA64_OPCODE_LDFP8_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPS_S_F1_F2_R3,
	IA64_OPCODE_LDFPS_S_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPS_S_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPD_S_F1_F2_R3,
	IA64_OPCODE_LDFPD_S_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPD_S_NTA_F1_F2_R3,
	IA64_OPCODE_LDFP8_S_F1_F2_R3,
	IA64_OPCODE_LDFP8_S_NT1_F1_F2_R3,
	IA64_OPCODE_LDFP8_S_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPS_A_F1_F2_R3,
	IA64_OPCODE_LDFPS_A_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPS_A_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPD_A_F1_F2_R3,
	IA64_OPCODE_LDFPD_A_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPD_A_NTA_F1_F2_R3,
	IA64_OPCODE_LDFP8_A_F1_F2_R3,
	IA64_OPCODE_LDFP8_A_NT1_F1_F2_R3,
	IA64_OPCODE_LDFP8_A_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPS_SA_F1_F2_R3,
	IA64_OPCODE_LDFPS_SA_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPS_SA_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPD_SA_F1_F2_R3,
	IA64_OPCODE_LDFPD_SA_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPD_SA_NTA_F1_F2_R3,
	IA64_OPCODE_LDFP8_SA_F1_F2_R3,
	IA64_OPCODE_LDFP8_SA_NT1_F1_F2_R3,
	IA64_OPCODE_LDFP8_SA_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPS_C_CLR_F1_F2_R3,
	IA64_OPCODE_LDFPS_C_CLR_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPS_C_CLR_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPD_C_CLR_F1_F2_R3,
	IA64_OPCODE_LDFPD_C_CLR_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPD_C_CLR_NTA_F1_F2_R3,
	IA64_OPCODE_LDFP8_C_CLR_F1_F2_R3,
	IA64_OPCODE_LDFP8_C_CLR_NT1_F1_F2_R3,
	IA64_OPCODE_LDFP8_C_CLR_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPS_C_NC_F1_F2_R3,
	IA64_OPCODE_LDFPS_C_NC_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPS_C_NC_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPD_C_NC_F1_F2_R3,
	IA64_OPCODE_LDFPD_C_NC_NT1_F1_F2_R3,
	IA64_OPCODE_LDFPD_C_NC_NTA_F1_F2_R3,
	IA64_OPCODE_LDFP8_C_NC_F1_F2_R3,
	IA64_OPCODE_LDFP8_C_NC_NT1_F1_F2_R3,
	IA64_OPCODE_LDFP8_C_NC_NTA_F1_F2_R3,
	IA64_OPCODE_LDFPS_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_NT1_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_NTA_F1_F2_R3_8,
	IA64_OPCODE_LDFPD_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFPS_S_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_S_NT1_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_S_NTA_F1_F2_R3_8,
	IA64_OPCODE_LDFPD_S_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_S_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_S_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_S_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_S_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_S_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFPS_A_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_A_NT1_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_A_NTA_F1_F2_R3_8,
	IA64_OPCODE_LDFPD_A_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_A_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_A_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_A_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_A_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_A_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFPS_SA_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_SA_NT1_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_SA_NTA_F1_F2_R3_8,
	IA64_OPCODE_LDFPD_SA_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_SA_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_SA_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_SA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_SA_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_SA_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFPS_C_CLR_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_C_CLR_NT1_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_C_CLR_NTA_F1_F2_R3_8,
	IA64_OPCODE_LDFPD_C_CLR_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_C_CLR_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_C_CLR_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_C_CLR_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_C_CLR_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_C_CLR_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFPS_C_NC_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_C_NC_NT1_F1_F2_R3_8,
	IA64_OPCODE_LDFPS_C_NC_NTA_F1_F2_R3_8,
	IA64_OPCODE_LDFPD_C_NC_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_C_NC_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFPD_C_NC_NTA_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_C_NC_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_C_NC_NT1_F1_F2_R3_16,
	IA64_OPCODE_LDFP8_C_NC_NTA_F1_F2_R3_16,
	IA64_OPCODE_LFETCH_R3,
	IA64_OPCODE_LFETCH_NT1_R3,
	IA64_OPCODE_LFETCH_NT2_R3,
	IA64_OPCODE_LFETCH_NTA_R3,
	IA64_OPCODE_LFETCH_EXCL_R3,
	IA64_OPCODE_LFETCH_EXCL_NT1_R3,
	IA64_OPCODE_LFETCH_EXCL_NT2_R3,
	IA64_OPCODE_LFETCH_EXCL_NTA_R3,
	IA64_OPCODE_LFETCH_FAULT_R3,
	IA64_OPCODE_LFETCH_FAULT_NT1_R3,
	IA64_OPCODE_LFETCH_FAULT_NT2_R3,
	IA64_OPCODE_LFETCH_FAULT_NTA_R3,
	IA64_OPCODE_LFETCH_FAULT_EXCL_R3,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NT1_R3,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NT2_R3,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NTA_R3,
	IA64_OPCODE_LFETCH_R3_R2,
	IA64_OPCODE_LFETCH_NT1_R3_R2,
	IA64_OPCODE_LFETCH_NT2_R3_R2,
	IA64_OPCODE_LFETCH_NTA_R3_R2,
	IA64_OPCODE_LFETCH_EXCL_R3_R2,
	IA64_OPCODE_LFETCH_EXCL_NT1_R3_R2,
	IA64_OPCODE_LFETCH_EXCL_NT2_R3_R2,
	IA64_OPCODE_LFETCH_EXCL_NTA_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_NT1_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_NT2_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_NTA_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_EXCL_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NT1_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NT2_R3_R2,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NTA_R3_R2,
	IA64_OPCODE_LFETCH_R3_IMM9,
	IA64_OPCODE_LFETCH_NT1_R3_IMM9,
	IA64_OPCODE_LFETCH_NT2_R3_IMM9,
	IA64_OPCODE_LFETCH_NTA_R3_IMM9,
	IA64_OPCODE_LFETCH_EXCL_R3_IMM9,
	IA64_OPCODE_LFETCH_EXCL_NT1_R3_IMM9,
	IA64_OPCODE_LFETCH_EXCL_NT2_R3_IMM9,
	IA64_OPCODE_LFETCH_EXCL_NTA_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_NT1_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_NT2_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_NTA_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_EXCL_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NT1_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NT2_R3_IMM9,
	IA64_OPCODE_LFETCH_FAULT_EXCL_NTA_R3_IMM9,
	IA64_OPCODE_CMPXCHG1_ACQ_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG1_ACQ_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG1_ACQ_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG2_ACQ_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG2_ACQ_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG2_ACQ_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG4_ACQ_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG4_ACQ_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG4_ACQ_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG8_ACQ_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG8_ACQ_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG8_ACQ_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG1_REL_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG1_REL_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG1_REL_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG2_REL_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG2_REL_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG2_REL_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG4_REL_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG4_REL_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG4_REL_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG8_REL_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG8_REL_NT1_R1_R3_R2_AR_CCV,
	IA64_OPCODE_CMPXCHG8_REL_NTA_R1_R3_R2_AR_CCV,
	IA64_OPCODE_XCHG1_R1_R3_R2,
	IA64_OPCODE_XCHG1_NT1_R1_R3_R2,
	IA64_OPCODE_XCHG1_NTA_R1_R3_R2,
	IA64_OPCODE_XCHG2_R1_R3_R2,
	IA64_OPCODE_XCHG2_NT1_R1_R3_R2,
	IA64_OPCODE_XCHG2_NTA_R1_R3_R2,
	IA64_OPCODE_XCHG4_R1_R3_R2,
	IA64_OPCODE_XCHG4_NT1_R1_R3_R2,
	IA64_OPCODE_XCHG4_NTA_R1_R3_R2,
	IA64_OPCODE_XCHG8_R1_R3_R2,
	IA64_OPCODE_XCHG8_NT1_R1_R3_R2,
	IA64_OPCODE_XCHG8_NTA_R1_R3_R2,
	IA64_OPCODE_FETCHADD4_ACQ_R1_R3_INC3,
	IA64_OPCODE_FETCHADD4_ACQ_NT1_R1_R3_INC3,
	IA64_OPCODE_FETCHADD4_ACQ_NTA_R1_R3_INC3,
	IA64_OPCODE_FETCHADD8_ACQ_R1_R3_INC3,
	IA64_OPCODE_FETCHADD8_ACQ_NT1_R1_R3_INC3,
	IA64_OPCODE_FETCHADD8_ACQ_NTA_R1_R3_INC3,
	IA64_OPCODE_FETCHADD4_REL_R1_R3_INC3,
	IA64_OPCODE_FETCHADD4_REL_NT1_R1_R3_INC3,
	IA64_OPCODE_FETCHADD4_REL_NTA_R1_R3_INC3,
	IA64_OPCODE_FETCHADD8_REL_R1_R3_INC3,
	IA64_OPCODE_FETCHADD8_REL_NT1_R1_R3_INC3,
	IA64_OPCODE_FETCHADD8_REL_NTA_R1_R3_INC3,
	IA64_OPCODE_SETF_SIG_F1_R2,
	IA64_OPCODE_SETF_EXP_F1_R2,
	IA64_OPCODE_SETF_S_F1_R2,
	IA64_OPCODE_SETF_D_F1_R2,
	IA64_OPCODE_GETF_SIG_R1_F2,
	IA64_OPCODE_GETF_EXP_R1_F2,
	IA64_OPCODE_GETF_S_R1_F2,
	IA64_OPCODE_GETF_D_R1_F2,
	IA64_OPCODE_CHK_S_M_R2_TARGET25,
	IA64_OPCODE_CHK_S_F2_TARGET25,
	IA64_OPCODE_CHK_A_NC_R1_TARGET25,
	IA64_OPCODE_CHK_A_CLR_R1_TARGET25,
	IA64_OPCODE_CHK_A_NC_F1_TARGET25,
	IA64_OPCODE_CHK_A_CLR_F1_TARGET25,
	IA64_OPCODE_INVALA,
	IA64_OPCODE_FWB,
	IA64_OPCODE_MF,
	IA64_OPCODE_MF_A,
	IA64_OPCODE_SRLZ_D,
	IA64_OPCODE_SRLZ_I,
	IA64_OPCODE_SYNC_I,
	IA64_OPCODE_FLUSHRS,
	IA64_OPCODE_LOADRS,
	IA64_OPCODE_INVALA_E_R1,
	IA64_OPCODE_INVALA_E_F1,
	IA64_OPCODE_FC_R3,
	IA64_OPCODE_PTC_E_R3,
	IA64_OPCODE_MOV_M_AR3_R2,
	IA64_OPCODE_MOV_M_AR3_IMM8,
	IA64_OPCODE_MOV_M_R1_AR3,
	IA64_OPCODE_MOV_CR3_R2,
	IA64_OPCODE_MOV_R1_CR3,
	IA64_OPCODE_ALLOC_R1_AR_PFS_I_L_O_R,
	IA64_OPCODE_MOV_PSR_L_R2,
	IA64_OPCODE_MOV_PSR_UM_R2,
	IA64_OPCODE_MOV_R1_PSR,
	IA64_OPCODE_MOV_R1_PSR_UM,
	IA64_OPCODE_BREAK_M_IMM21,
	IA64_OPCODE_NOP_M_IMM21,
	IA64_OPCODE_PROBE_R_R1_R3_R2,
	IA64_OPCODE_PROBE_W_R1_R3_R2,
	IA64_OPCODE_PROBE_R_R1_R3_IMM2,
	IA64_OPCODE_PROBE_W_R1_R3_IMM2,
	IA64_OPCODE_PROBE_RW_FAULT_R3_IMM2,
	IA64_OPCODE_PROBE_R_FAULT_R3_IMM2,
	IA64_OPCODE_PROBE_W_FAULT_R3_IMM2,
	IA64_OPCODE_ITC_D_R2,
	IA64_OPCODE_ITC_I_R2,
	IA64_OPCODE_MOV_RR_R3_R2,
	IA64_OPCODE_MOV_DBR_R3_R2,
	IA64_OPCODE_MOV_IBR_R3_R2,
	IA64_OPCODE_MOV_PKR_R3_R2,
	IA64_OPCODE_MOV_PMC_R3_R2,
	IA64_OPCODE_MOV_PMD_R3_R2,
	IA64_OPCODE_MOV_MSR_R3_R2,
	IA64_OPCODE_ITR_D_DTR_R3_R2,
	IA64_OPCODE_ITR_I_ITR_R3_R2,
	IA64_OPCODE_MOV_R1_RR_R3,
	IA64_OPCODE_MOV_R1_DBR_R3,
	IA64_OPCODE_MOV_R1_IBR_R3,
	IA64_OPCODE_MOV_R1_PKR_R3,
	IA64_OPCODE_MOV_R1_PMC_R3,
	IA64_OPCODE_MOV_R1_MSR_R3,
	IA64_OPCODE_MOV_R1_PMD_R3,
	IA64_OPCODE_MOV_R1_CPUID_R3,
	IA64_OPCODE_SUM_IMM24,
	IA64_OPCODE_RUM_IMM24,
	IA64_OPCODE_SSM_IMM24,
	IA64_OPCODE_RSM_IMM24,
	IA64_OPCODE_PTC_L_R3_R2,
	IA64_OPCODE_PTC_G_R3_R2,
	IA64_OPCODE_PTC_GA_R3_R2,
	IA64_OPCODE_PTR_D_R3_R2,
	IA64_OPCODE_PTR_I_R3_R2,
	IA64_OPCODE_THASH_R1_R3,
	IA64_OPCODE_TTAG_R1_R3,
	IA64_OPCODE_TPA_R1_R3,
	IA64_OPCODE_TAK_R1_R3,
	IA64_OPCODE_HALT_R3,
	IA64_OPCODE_BR_COND_SPTK_FEW_TARGET25,
	IA64_OPCODE_BR_COND_SPTK_MANY_TARGET25,
	IA64_OPCODE_BR_COND_SPNT_FEW_TARGET25,
	IA64_OPCODE_BR_COND_SPNT_MANY_TARGET25,
	IA64_OPCODE_BR_COND_DPTK_FEW_TARGET25,
	IA64_OPCODE_BR_COND_DPTK_MANY_TARGET25,
	IA64_OPCODE_BR_COND_DPNT_FEW_TARGET25,
	IA64_OPCODE_BR_COND_DPNT_MANY_TARGET25,
	IA64_OPCODE_BR_COND_SPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_COND_SPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_COND_SPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_COND_SPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_COND_DPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_COND_DPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_COND_DPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_COND_DPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPTK_FEW_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPTK_MANY_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPNT_FEW_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPNT_MANY_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPTK_FEW_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPTK_MANY_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPNT_FEW_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPNT_MANY_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_SPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WEXIT_DPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_SPTK_FEW_TARGET25,
	IA64_OPCODE_BR_WTOP_SPTK_MANY_TARGET25,
	IA64_OPCODE_BR_WTOP_SPNT_FEW_TARGET25,
	IA64_OPCODE_BR_WTOP_SPNT_MANY_TARGET25,
	IA64_OPCODE_BR_WTOP_DPTK_FEW_TARGET25,
	IA64_OPCODE_BR_WTOP_DPTK_MANY_TARGET25,
	IA64_OPCODE_BR_WTOP_DPNT_FEW_TARGET25,
	IA64_OPCODE_BR_WTOP_DPNT_MANY_TARGET25,
	IA64_OPCODE_BR_WTOP_SPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_SPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_SPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_SPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_DPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_DPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_DPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_WTOP_DPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPTK_FEW_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPTK_MANY_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPNT_FEW_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPNT_MANY_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPTK_FEW_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPTK_MANY_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPNT_FEW_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPNT_MANY_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_SPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CLOOP_DPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPTK_FEW_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPTK_MANY_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPNT_FEW_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPNT_MANY_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPTK_FEW_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPTK_MANY_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPNT_FEW_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPNT_MANY_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_SPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CEXIT_DPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_SPTK_FEW_TARGET25,
	IA64_OPCODE_BR_CTOP_SPTK_MANY_TARGET25,
	IA64_OPCODE_BR_CTOP_SPNT_FEW_TARGET25,
	IA64_OPCODE_BR_CTOP_SPNT_MANY_TARGET25,
	IA64_OPCODE_BR_CTOP_DPTK_FEW_TARGET25,
	IA64_OPCODE_BR_CTOP_DPTK_MANY_TARGET25,
	IA64_OPCODE_BR_CTOP_DPNT_FEW_TARGET25,
	IA64_OPCODE_BR_CTOP_DPNT_MANY_TARGET25,
	IA64_OPCODE_BR_CTOP_SPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_SPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_SPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_SPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_DPTK_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_DPTK_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_DPNT_FEW_CLR_TARGET25,
	IA64_OPCODE_BR_CTOP_DPNT_MANY_CLR_TARGET25,
	IA64_OPCODE_BR_CALL_SPTK_FEW_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPTK_MANY_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPNT_FEW_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPNT_MANY_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPTK_FEW_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPTK_MANY_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPNT_FEW_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPNT_MANY_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPTK_FEW_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPTK_MANY_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPNT_FEW_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_SPNT_MANY_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPTK_FEW_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPTK_MANY_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPNT_FEW_CLR_B1_TARGET25,
	IA64_OPCODE_BR_CALL_DPNT_MANY_CLR_B1_TARGET25,
	IA64_OPCODE_BR_COND_SPTK_FEW_B2,
	IA64_OPCODE_BR_COND_SPTK_MANY_B2,
	IA64_OPCODE_BR_COND_SPNT_FEW_B2,
	IA64_OPCODE_BR_COND_SPNT_MANY_B2,
	IA64_OPCODE_BR_COND_DPTK_FEW_B2,
	IA64_OPCODE_BR_COND_DPTK_MANY_B2,
	IA64_OPCODE_BR_COND_DPNT_FEW_B2,
	IA64_OPCODE_BR_COND_DPNT_MANY_B2,
	IA64_OPCODE_BR_COND_SPTK_FEW_CLR_B2,
	IA64_OPCODE_BR_COND_SPTK_MANY_CLR_B2,
	IA64_OPCODE_BR_COND_SPNT_FEW_CLR_B2,
	IA64_OPCODE_BR_COND_SPNT_MANY_CLR_B2,
	IA64_OPCODE_BR_COND_DPTK_FEW_CLR_B2,
	IA64_OPCODE_BR_COND_DPTK_MANY_CLR_B2,
	IA64_OPCODE_BR_COND_DPNT_FEW_CLR_B2,
	IA64_OPCODE_BR_COND_DPNT_MANY_CLR_B2,
	IA64_OPCODE_BR_IA_SPTK_FEW_B2,
	IA64_OPCODE_BR_IA_SPTK_MANY_B2,
	IA64_OPCODE_BR_IA_SPNT_FEW_B2,
	IA64_OPCODE_BR_IA_SPNT_MANY_B2,
	IA64_OPCODE_BR_IA_DPTK_FEW_B2,
	IA64_OPCODE_BR_IA_DPTK_MANY_B2,
	IA64_OPCODE_BR_IA_DPNT_FEW_B2,
	IA64_OPCODE_BR_IA_DPNT_MANY_B2,
	IA64_OPCODE_BR_IA_SPTK_FEW_CLR_B2,
	IA64_OPCODE_BR_IA_SPTK_MANY_CLR_B2,
	IA64_OPCODE_BR_IA_SPNT_FEW_CLR_B2,
	IA64_OPCODE_BR_IA_SPNT_MANY_CLR_B2,
	IA64_OPCODE_BR_IA_DPTK_FEW_CLR_B2,
	IA64_OPCODE_BR_IA_DPTK_MANY_CLR_B2,
	IA64_OPCODE_BR_IA_DPNT_FEW_CLR_B2,
	IA64_OPCODE_BR_IA_DPNT_MANY_CLR_B2,
	IA64_OPCODE_BR_RET_SPTK_FEW_B2,
	IA64_OPCODE_BR_RET_SPTK_MANY_B2,
	IA64_OPCODE_BR_RET_SPNT_FEW_B2,
	IA64_OPCODE_BR_RET_SPNT_MANY_B2,
	IA64_OPCODE_BR_RET_DPTK_FEW_B2,
	IA64_OPCODE_BR_RET_DPTK_MANY_B2,
	IA64_OPCODE_BR_RET_DPNT_FEW_B2,
	IA64_OPCODE_BR_RET_DPNT_MANY_B2,
	IA64_OPCODE_BR_RET_SPTK_FEW_CLR_B2,
	IA64_OPCODE_BR_RET_SPTK_MANY_CLR_B2,
	IA64_OPCODE_BR_RET_SPNT_FEW_CLR_B2,
	IA64_OPCODE_BR_RET_SPNT_MANY_CLR_B2,
	IA64_OPCODE_BR_RET_DPTK_FEW_CLR_B2,
	IA64_OPCODE_BR_RET_DPTK_MANY_CLR_B2,
	IA64_OPCODE_BR_RET_DPNT_FEW_CLR_B2,
	IA64_OPCODE_BR_RET_DPNT_MANY_CLR_B2,
	IA64_OPCODE_BR_CALL_SPTK_FEW_B1_B2,
	IA64_OPCODE_BR_CALL_SPTK_MANY_B1_B2,
	IA64_OPCODE_BR_CALL_SPNT_FEW_B1_B2,
	IA64_OPCODE_BR_CALL_SPNT_MANY_B1_B2,
	IA64_OPCODE_BR_CALL_DPTK_FEW_B1_B2,
	IA64_OPCODE_BR_CALL_DPTK_MANY_B1_B2,
	IA64_OPCODE_BR_CALL_DPNT_FEW_B1_B2,
	IA64_OPCODE_BR_CALL_DPNT_MANY_B1_B2,
	IA64_OPCODE_BR_CALL_SPTK_FEW_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_SPTK_MANY_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_SPNT_FEW_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_SPNT_MANY_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_DPTK_FEW_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_DPTK_MANY_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_DPNT_FEW_CLR_B1_B2,
	IA64_OPCODE_BR_CALL_DPNT_MANY_CLR_B1_B2,
	IA64_OPCODE_BRP_SPTK_TARGET25_TAG13,
	IA64_OPCODE_BRP_SPTK_IMP_TARGET25_TAG13,
	IA64_OPCODE_BRP_LOOP_TARGET25_TAG13,
	IA64_OPCODE_BRP_LOOP_IMP_TARGET25_TAG13,
	IA64_OPCODE_BRP_DPTK_TARGET25_TAG13,
	IA64_OPCODE_BRP_DPTK_IMP_TARGET25_TAG13,
	IA64_OPCODE_BRP_EXIT_TARGET25_TAG13,
	IA64_OPCODE_BRP_EXIT_IMP_TARGET25_TAG13,
	IA64_OPCODE_BRP_SPTK_B2_TAG13,
	IA64_OPCODE_BRP_SPTK_IMP_B2_TAG13,
	IA64_OPCODE_BRP_DPTK_B2_TAG13,
	IA64_OPCODE_BRP_DPTK_IMP_B2_TAG13,
	IA64_OPCODE_BRP_RET_SPTK_B2_TAG13,
	IA64_OPCODE_BRP_RET_SPTK_IMP_B2_TAG13,
	IA64_OPCODE_BRP_RET_DPTK_B2_TAG13,
	IA64_OPCODE_BRP_RET_DPTK_IMP_B2_TAG13,
	IA64_OPCODE_COVER,
	IA64_OPCODE_CLRRRB,
	IA64_OPCODE_CLRRRB_PR,
	IA64_OPCODE_RFI,
	IA64_OPCODE_RFI_X,
	IA64_OPCODE_BSW_0,
	IA64_OPCODE_BSW_1,
	IA64_OPCODE_EPC,
	IA64_OPCODE_BREAK_B_IMM21,
	IA64_OPCODE_NOP_B_IMM21,
	IA64_OPCODE_FMA_S0_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S1_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S2_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S3_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S_S0_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S_S1_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S_S2_F1_F3_F4_F2,
	IA64_OPCODE_FMA_S_S3_F1_F3_F4_F2,
	IA64_OPCODE_FMA_D_S0_F1_F3_F4_F2,
	IA64_OPCODE_FMA_D_S1_F1_F3_F4_F2,
	IA64_OPCODE_FMA_D_S2_F1_F3_F4_F2,
	IA64_OPCODE_FMA_D_S3_F1_F3_F4_F2,
	IA64_OPCODE_FPMA_S0_F1_F3_F4_F2,
	IA64_OPCODE_FPMA_S1_F1_F3_F4_F2,
	IA64_OPCODE_FPMA_S2_F1_F3_F4_F2,
	IA64_OPCODE_FPMA_S3_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S0_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S1_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S2_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S3_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S_S0_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S_S1_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S_S2_F1_F3_F4_F2,
	IA64_OPCODE_FMS_S_S3_F1_F3_F4_F2,
	IA64_OPCODE_FMS_D_S0_F1_F3_F4_F2,
	IA64_OPCODE_FMS_D_S1_F1_F3_F4_F2,
	IA64_OPCODE_FMS_D_S2_F1_F3_F4_F2,
	IA64_OPCODE_FMS_D_S3_F1_F3_F4_F2,
	IA64_OPCODE_FPMS_S0_F1_F3_F4_F2,
	IA64_OPCODE_FPMS_S1_F1_F3_F4_F2,
	IA64_OPCODE_FPMS_S2_F1_F3_F4_F2,
	IA64_OPCODE_FPMS_S3_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S0_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S1_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S2_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S3_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S_S0_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S_S1_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S_S2_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_S_S3_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_D_S0_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_D_S1_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_D_S2_F1_F3_F4_F2,
	IA64_OPCODE_FNMA_D_S3_F1_F3_F4_F2,
	IA64_OPCODE_FPNMA_S0_F1_F3_F4_F2,
	IA64_OPCODE_FPNMA_S1_F1_F3_F4_F2,
	IA64_OPCODE_FPNMA_S2_F1_F3_F4_F2,
	IA64_OPCODE_FPNMA_S3_F1_F3_F4_F2,
	IA64_OPCODE_XMA_L_F1_F3_F4_F2,
	IA64_OPCODE_XMA_H_F1_F3_F4_F2,
	IA64_OPCODE_XMA_HU_F1_F3_F4_F2,
	IA64_OPCODE_FSELECT_F1_F3_F4_F2,
	IA64_OPCODE_FCMP_EQ_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_UNC_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_UNC_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_UNC_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_EQ_UNC_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_UNC_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_UNC_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_UNC_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LT_UNC_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_UNC_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_UNC_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_UNC_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_LE_UNC_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_UNC_S0_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_UNC_S1_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_UNC_S2_P1_P2_F2_F3,
	IA64_OPCODE_FCMP_UNORD_UNC_S3_P1_P2_F2_F3,
	IA64_OPCODE_FCLASS_M_P1_P2_F2_FCLASS9,
	IA64_OPCODE_FCLASS_M_UNC_P1_P2_F2_FCLASS9,
	IA64_OPCODE_FRCPA_S0_F1_P2_F2_F3,
	IA64_OPCODE_FRCPA_S1_F1_P2_F2_F3,
	IA64_OPCODE_FRCPA_S2_F1_P2_F2_F3,
	IA64_OPCODE_FRCPA_S3_F1_P2_F2_F3,
	IA64_OPCODE_FPRCPA_S0_F1_P2_F2_F3,
	IA64_OPCODE_FPRCPA_S1_F1_P2_F2_F3,
	IA64_OPCODE_FPRCPA_S2_F1_P2_F2_F3,
	IA64_OPCODE_FPRCPA_S3_F1_P2_F2_F3,
	IA64_OPCODE_FRSQRTA_S0_F1_P2_F3,
	IA64_OPCODE_FRSQRTA_S1_F1_P2_F3,
	IA64_OPCODE_FRSQRTA_S2_F1_P2_F3,
	IA64_OPCODE_FRSQRTA_S3_F1_P2_F3,
	IA64_OPCODE_FPRSQRTA_S0_F1_P2_F3,
	IA64_OPCODE_FPRSQRTA_S1_F1_P2_F3,
	IA64_OPCODE_FPRSQRTA_S2_F1_P2_F3,
	IA64_OPCODE_FPRSQRTA_S3_F1_P2_F3,
	IA64_OPCODE_FMIN_S0_F1_F2_F3,
	IA64_OPCODE_FMIN_S1_F1_F2_F3,
	IA64_OPCODE_FMIN_S2_F1_F2_F3,
	IA64_OPCODE_FMIN_S3_F1_F2_F3,
	IA64_OPCODE_FMAX_S0_F1_F2_F3,
	IA64_OPCODE_FMAX_S1_F1_F2_F3,
	IA64_OPCODE_FMAX_S2_F1_F2_F3,
	IA64_OPCODE_FMAX_S3_F1_F2_F3,
	IA64_OPCODE_FAMIN_S0_F1_F2_F3,
	IA64_OPCODE_FAMIN_S1_F1_F2_F3,
	IA64_OPCODE_FAMIN_S2_F1_F2_F3,
	IA64_OPCODE_FAMIN_S3_F1_F2_F3,
	IA64_OPCODE_FAMAX_S0_F1_F2_F3,
	IA64_OPCODE_FAMAX_S1_F1_F2_F3,
	IA64_OPCODE_FAMAX_S2_F1_F2_F3,
	IA64_OPCODE_FAMAX_S3_F1_F2_F3,
	IA64_OPCODE_FPMIN_S0_F1_F2_F3,
	IA64_OPCODE_FPMIN_S1_F1_F2_F3,
	IA64_OPCODE_FPMIN_S2_F1_F2_F3,
	IA64_OPCODE_FPMIN_S3_F1_F2_F3,
	IA64_OPCODE_FPMAX_S0_F1_F2_F3,
	IA64_OPCODE_FPMAX_S1_F1_F2_F3,
	IA64_OPCODE_FPMAX_S2_F1_F2_F3,
	IA64_OPCODE_FPMAX_S3_F1_F2_F3,
	IA64_OPCODE_FPAMIN_S0_F1_F2_F3,
	IA64_OPCODE_FPAMIN_S1_F1_F2_F3,
	IA64_OPCODE_FPAMIN_S2_F1_F2_F3,
	IA64_OPCODE_FPAMIN_S3_F1_F2_F3,
	IA64_OPCODE_FPAMAX_S0_F1_F2_F3,
	IA64_OPCODE_FPAMAX_S1_F1_F2_F3,
	IA64_OPCODE_FPAMAX_S2_F1_F2_F3,
	IA64_OPCODE_FPAMAX_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_EQ_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_EQ_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_EQ_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_EQ_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_LT_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_LT_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_LT_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_LT_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_LE_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_LE_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_LE_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_LE_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_UNORD_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_UNORD_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_UNORD_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_UNORD_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_NEQ_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_NEQ_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_NEQ_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_NEQ_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLT_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLT_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLT_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLT_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLE_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLE_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLE_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_NLE_S3_F1_F2_F3,
	IA64_OPCODE_FPCMP_ORD_S0_F1_F2_F3,
	IA64_OPCODE_FPCMP_ORD_S1_F1_F2_F3,
	IA64_OPCODE_FPCMP_ORD_S2_F1_F2_F3,
	IA64_OPCODE_FPCMP_ORD_S3_F1_F2_F3,
	IA64_OPCODE_FMERGE_S_F1_F2_F3,
	IA64_OPCODE_FMERGE_NS_F1_F2_F3,
	IA64_OPCODE_FMERGE_SE_F1_F2_F3,
	IA64_OPCODE_FMIX_LR_F1_F2_F3,
	IA64_OPCODE_FMIX_R_F1_F2_F3,
	IA64_OPCODE_FMIX_L_F1_F2_F3,
	IA64_OPCODE_FSXT_R_F1_F2_F3,
	IA64_OPCODE_FSXT_L_F1_F2_F3,
	IA64_OPCODE_FPACK_F1_F2_F3,
	IA64_OPCODE_FSWAP_F1_F2_F3,
	IA64_OPCODE_FSWAP_NL_F1_F2_F3,
	IA64_OPCODE_FSWAP_NR_F1_F2_F3,
	IA64_OPCODE_FAND_F1_F2_F3,
	IA64_OPCODE_FANDCM_F1_F2_F3,
	IA64_OPCODE_FOR_F1_F2_F3,
	IA64_OPCODE_FXOR_F1_F2_F3,
	IA64_OPCODE_FPMERGE_S_F1_F2_F3,
	IA64_OPCODE_FPMERGE_NS_F1_F2_F3,
	IA64_OPCODE_FPMERGE_SE_F1_F2_F3,
	IA64_OPCODE_FCVT_FX_S0_F1_F2,
	IA64_OPCODE_FCVT_FX_S1_F1_F2,
	IA64_OPCODE_FCVT_FX_S2_F1_F2,
	IA64_OPCODE_FCVT_FX_S3_F1_F2,
	IA64_OPCODE_FCVT_FXU_S0_F1_F2,
	IA64_OPCODE_FCVT_FXU_S1_F1_F2,
	IA64_OPCODE_FCVT_FXU_S2_F1_F2,
	IA64_OPCODE_FCVT_FXU_S3_F1_F2,
	IA64_OPCODE_FCVT_FX_TRUNC_S0_F1_F2,
	IA64_OPCODE_FCVT_FX_TRUNC_S1_F1_F2,
	IA64_OPCODE_FCVT_FX_TRUNC_S2_F1_F2,
	IA64_OPCODE_FCVT_FX_TRUNC_S3_F1_F2,
	IA64_OPCODE_FCVT_FXU_TRUNC_S0_F1_F2,
	IA64_OPCODE_FCVT_FXU_TRUNC_S1_F1_F2,
	IA64_OPCODE_FCVT_FXU_TRUNC_S2_F1_F2,
	IA64_OPCODE_FCVT_FXU_TRUNC_S3_F1_F2,
	IA64_OPCODE_FPCVT_FX_S0_F1_F2,
	IA64_OPCODE_FPCVT_FX_S1_F1_F2,
	IA64_OPCODE_FPCVT_FX_S2_F1_F2,
	IA64_OPCODE_FPCVT_FX_S3_F1_F2,
	IA64_OPCODE_FPCVT_FXU_S0_F1_F2,
	IA64_OPCODE_FPCVT_FXU_S1_F1_F2,
	IA64_OPCODE_FPCVT_FXU_S2_F1_F2,
	IA64_OPCODE_FPCVT_FXU_S3_F1_F2,
	IA64_OPCODE_FPCVT_FX_TRUNC_S0_F1_F2,
	IA64_OPCODE_FPCVT_FX_TRUNC_S1_F1_F2,
	IA64_OPCODE_FPCVT_FX_TRUNC_S2_F1_F2,
	IA64_OPCODE_FPCVT_FX_TRUNC_S3_F1_F2,
	IA64_OPCODE_FPCVT_FXU_TRUNC_S0_F1_F2,
	IA64_OPCODE_FPCVT_FXU_TRUNC_S1_F1_F2,
	IA64_OPCODE_FPCVT_FXU_TRUNC_S2_F1_F2,
	IA64_OPCODE_FPCVT_FXU_TRUNC_S3_F1_F2,
	IA64_OPCODE_FCVT_XF_F1_F2,
	IA64_OPCODE_FSETC_S0_AMASK7_OMASK7,
	IA64_OPCODE_FSETC_S1_AMASK7_OMASK7,
	IA64_OPCODE_FSETC_S2_AMASK7_OMASK7,
	IA64_OPCODE_FSETC_S3_AMASK7_OMASK7,
	IA64_OPCODE_FCLRF_S0,
	IA64_OPCODE_FCLRF_S1,
	IA64_OPCODE_FCLRF_S2,
	IA64_OPCODE_FCLRF_S3,
	IA64_OPCODE_FCHKF_S0_TARGET25,
	IA64_OPCODE_FCHKF_S1_TARGET25,
	IA64_OPCODE_FCHKF_S2_TARGET25,
	IA64_OPCODE_FCHKF_S3_TARGET25,
	IA64_OPCODE_BREAK_F_IMM21,
	IA64_OPCODE_NOP_F_IMM21,
	IA64_OPCODE_BREAK_X_IMM62,
	IA64_OPCODE_NOP_X_IMM62,
	IA64_OPCODE_MOVL_R1_IMM64,
	IA64_OPCODE_BRL_COND_SPTK_FEW_TARGET64,
	IA64_OPCODE_BRL_COND_SPTK_MANY_TARGET64,
	IA64_OPCODE_BRL_COND_SPNT_FEW_TARGET64,
	IA64_OPCODE_BRL_COND_SPNT_MANY_TARGET64,
	IA64_OPCODE_BRL_COND_DPTK_FEW_TARGET64,
	IA64_OPCODE_BRL_COND_DPTK_MANY_TARGET64,
	IA64_OPCODE_BRL_COND_DPNT_FEW_TARGET64,
	IA64_OPCODE_BRL_COND_DPNT_MANY_TARGET64,
	IA64_OPCODE_BRL_COND_SPTK_FEW_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_SPTK_MANY_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_SPNT_FEW_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_SPNT_MANY_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_DPTK_FEW_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_DPTK_MANY_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_DPNT_FEW_CLR_TARGET64,
	IA64_OPCODE_BRL_COND_DPNT_MANY_CLR_TARGET64,
	IA64_OPCODE_BRL_CALL_SPTK_FEW_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPTK_MANY_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPNT_FEW_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPNT_MANY_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPTK_FEW_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPTK_MANY_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPNT_FEW_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPNT_MANY_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPTK_FEW_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPTK_MANY_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPNT_FEW_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_SPNT_MANY_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPTK_FEW_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPTK_MANY_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPNT_FEW_CLR_B1_TARGET64,
	IA64_OPCODE_BRL_CALL_DPNT_MANY_CLR_B1_TARGET64,
	IA64_OPCODE_INST_LAST
};

enum IA64EnumOperandRole {
    IA64_OPROLE_NONE = 0,
    IA64_OPROLE_SRC,
    IA64_OPROLE_DST,
    IA64_OPROLE_SRC_DST,
    IA64_OPROLE_DST_SRC,
    OPROLE_LAST
};

enum IA64EnumOperandType {
IA64_OPTYPE_NONE = 0,
IA64_OPTYPE_REG_FIRST,      /* The following types are registers */
IA64_OPTYPE_IREG,           /* Integer register */
IA64_OPTYPE_IREG_R0_3,      /* r0-r3 */
IA64_OPTYPE_IREG_R0,        /* Integer register R0 */
IA64_OPTYPE_IREG_R1_127,    /* r1-r127 */
IA64_OPTYPE_FREG,           /* FP register */
IA64_OPTYPE_FREG_F2_127,    /* f2-f127 */
IA64_OPTYPE_BR,             /* branch register */
IA64_OPTYPE_IP,             /* instruction pointer, not encoded */
IA64_OPTYPE_PREG,           /* predicate */
IA64_OPTYPE_PREGS_ALL,      /* the predicate register */
IA64_OPTYPE_PREGS_ROT,      /* rotating predicates */
IA64_OPTYPE_APP_REG_GRP_LOW,         /* application registers 0-63*/
IA64_OPTYPE_APP_REG_GRP_HIGH,        /* application registers 64-127*/
IA64_OPTYPE_APP_CCV,        /* ar.ccv */
IA64_OPTYPE_APP_PFS,        /* ar.pfs */
IA64_OPTYPE_CR,             /* control registers */
IA64_OPTYPE_PSR_L,          /* psr.l */
IA64_OPTYPE_PSR_UM,         /* psr.um */
IA64_OPTYPE_FPSR,           /* decoder operand types */
IA64_OPTYPE_CFM,
IA64_OPTYPE_PSR,
IA64_OPTYPE_IFM,
IA64_OPTYPE_REG_LAST,       /* End of register - types */
IA64_OPTYPE_REGFILE_FIRST,  /* The following types are register-files */
IA64_OPTYPE_PMC,
IA64_OPTYPE_PMD,
IA64_OPTYPE_PKR,
IA64_OPTYPE_RR,
IA64_OPTYPE_IBR,
IA64_OPTYPE_DBR,
IA64_OPTYPE_ITR,
IA64_OPTYPE_DTR,
IA64_OPTYPE_MSR,
IA64_OPTYPE_CPUID,
IA64_OPTYPE_REGFILE_LAST,   /* End of register-file types */
IA64_OPTYPE_IMM_FIRST,      /* The following types are immediates */
IA64_OPTYPE_UIMM,           /* unsigned immediate */
IA64_OPTYPE_SIMM,           /* signed immediate */
IA64_OPTYPE_IREG_NUM,       /* ireg in syntax and imm7 in encodings */
IA64_OPTYPE_FREG_NUM,       /* freg in syntax and imm7 in encodings */
IA64_OPTYPE_SSHIFT_REL,     /* pc relative signed immediate
					    which is shifted by 4 */
IA64_OPTYPE_SSHIFT_1,       /* unsigned immediate which has to be
					    shifted 1 bit */
IA64_OPTYPE_SSHIFT_16,      /* unsigned immediate which has to be
					    shifted 16 bits */
IA64_OPTYPE_COUNT_123,      /* immediate which can have the values of
					    1, 2, 3 only */
IA64_OPTYPE_COUNT_PACK,     /* immediate which can have the values of
							 0, 7, 15, 16 only */
IA64_OPTYPE_UDEC,           /* unsigned immediate which has to be
					    decremented by 1 by the assembler */
IA64_OPTYPE_SDEC,           /* signed immediate which has to be
					    decremented by 1 by the assembler */
IA64_OPTYPE_CCOUNT,         /* in pshl[24] - uimm5 in syntax, but encoded
					    as its 2's complement */
IA64_OPTYPE_CPOS,           /* in dep fixed form - uimm6 in syntax, but encoded
					    as its 2's complement */
IA64_OPTYPE_SEMAPHORE_INC,  /* immediate which is a semaphore increment amount
					    can have the values of -16,-8,-4,-1,
					    1,4,8,16 */
IA64_OPTYPE_ONE,            /* the number 1 */
IA64_OPTYPE_FCLASS,         /* immediate of the fclass instruction */
IA64_OPTYPE_CMP_UIMM,       /* unsigned immediate of cmp geu and ltu */
IA64_OPTYPE_CMP_UIMM_DEC,   /* unsigned immediate of cmp gtu and leu */
IA64_OPTYPE_CMP4_UIMM,      /* unsigned immediate of cmp4 geu and ltu */
IA64_OPTYPE_CMP4_UIMM_DEC,  /* unsigned immediate of cmp4 gtu and leu */
IA64_OPTYPE_ALLOC_IOL,      /* for alloc : input, local, and output
					    can be 0-96 */
IA64_OPTYPE_ALLOC_ROT,      /* for alloc : rotating, can be 0-96 */
IA64_OPTYPE_MUX1,           /* immediate of the mux1 instruction */
IA64_OPTYPE_EIGHT,          /* immediate for ldfps base update form can have value 8 */
IA64_OPTYPE_SIXTEEN,        /* immediate for ldfp8 and ldfpd base update form can have value 16 */
IA64_OPTYPE_IMM_LAST,       /* End of immediate types */
IA64_OPTYPE_MEM,            /* memory address */
IA64_OPTYPE_LAST
};

enum IA64EnumOpcodeFormat {
	 IA64_FORMAT_NONE = 0,
	 IA64_FORMAT_A1,
	 IA64_FORMAT_A2,
	 IA64_FORMAT_A3,
	 IA64_FORMAT_A4,
	 IA64_FORMAT_A4_1,
	 IA64_FORMAT_A5,
	 IA64_FORMAT_A6,
	 IA64_FORMAT_A6_1,
	 IA64_FORMAT_A6_2,
	 IA64_FORMAT_A6_3,
	 IA64_FORMAT_A6_4,
	 IA64_FORMAT_A6_5,
	 IA64_FORMAT_A6_6,
	 IA64_FORMAT_A6_7,
	 IA64_FORMAT_A7,
	 IA64_FORMAT_A7_1,
	 IA64_FORMAT_A7_2,
	 IA64_FORMAT_A7_3,
	 IA64_FORMAT_A7_4,
	 IA64_FORMAT_A7_5,
	 IA64_FORMAT_A7_6,
	 IA64_FORMAT_A7_7,
	 IA64_FORMAT_A8,
	 IA64_FORMAT_A8_1,
	 IA64_FORMAT_A8_2,
	 IA64_FORMAT_A8_3,
	 IA64_FORMAT_A9,
	 IA64_FORMAT_A10,
	 IA64_FORMAT_I1,
	 IA64_FORMAT_I2,
	 IA64_FORMAT_I3,
	 IA64_FORMAT_I4,
	 IA64_FORMAT_I5,
	 IA64_FORMAT_I6,
	 IA64_FORMAT_I7,
	 IA64_FORMAT_I8,
	 IA64_FORMAT_I9,
	 IA64_FORMAT_I10,
	 IA64_FORMAT_I11,
	 IA64_FORMAT_I12,
	 IA64_FORMAT_I13,
	 IA64_FORMAT_I14,
	 IA64_FORMAT_I15,
	 IA64_FORMAT_I16,
	 IA64_FORMAT_I16_1,
	 IA64_FORMAT_I16_2,
	 IA64_FORMAT_I16_3,
	 IA64_FORMAT_I17,
	 IA64_FORMAT_I17_1,
	 IA64_FORMAT_I17_2,
	 IA64_FORMAT_I17_3,
	 IA64_FORMAT_I19,
	 IA64_FORMAT_I20,
	 IA64_FORMAT_I21,
	 IA64_FORMAT_I22,
	 IA64_FORMAT_I23,
	 IA64_FORMAT_I24,
	 IA64_FORMAT_I25,
	 IA64_FORMAT_I26,
	 IA64_FORMAT_I27,
	 IA64_FORMAT_I28,
	 IA64_FORMAT_I29,
	 IA64_FORMAT_M1,
	 IA64_FORMAT_M2,
	 IA64_FORMAT_M3,
	 IA64_FORMAT_M4,
	 IA64_FORMAT_M5,
	 IA64_FORMAT_M6,
	 IA64_FORMAT_M7,
	 IA64_FORMAT_M8,
	 IA64_FORMAT_M9,
	 IA64_FORMAT_M10,
	 IA64_FORMAT_M11,
	 IA64_FORMAT_M12,
	 IA64_FORMAT_M13,
	 IA64_FORMAT_M14,
	 IA64_FORMAT_M15,
	 IA64_FORMAT_M16,
	 IA64_FORMAT_M17,
	 IA64_FORMAT_M18,
	 IA64_FORMAT_M19,
	 IA64_FORMAT_M20,
	 IA64_FORMAT_M21,
	 IA64_FORMAT_M22,
	 IA64_FORMAT_M23,
	 IA64_FORMAT_M24,
	 IA64_FORMAT_M25,
	 IA64_FORMAT_M26,
	 IA64_FORMAT_M27,
	 IA64_FORMAT_M28,
	 IA64_FORMAT_M29,
	 IA64_FORMAT_M30,
	 IA64_FORMAT_M31,
	 IA64_FORMAT_M32,
	 IA64_FORMAT_M33,
	 IA64_FORMAT_M34,
	 IA64_FORMAT_M34_1,
	 IA64_FORMAT_M35,
	 IA64_FORMAT_M36,
	 IA64_FORMAT_M37,
	 IA64_FORMAT_M38,
	 IA64_FORMAT_M39,
	 IA64_FORMAT_M40,
	 IA64_FORMAT_M41,
	 IA64_FORMAT_M42,
	 IA64_FORMAT_M43,
	 IA64_FORMAT_M44,
	 IA64_FORMAT_M45,
	 IA64_FORMAT_M46,
	 IA64_FORMAT_M1001,
	 IA64_FORMAT_B1,
	 IA64_FORMAT_B2,
	 IA64_FORMAT_B3,
	 IA64_FORMAT_B4,
	 IA64_FORMAT_B5,
	 IA64_FORMAT_B6,
	 IA64_FORMAT_B7,
	 IA64_FORMAT_B8,
	 IA64_FORMAT_B9,
	 IA64_FORMAT_F1,
	 IA64_FORMAT_F1_1,
	 IA64_FORMAT_F2,
	 IA64_FORMAT_F3,
	 IA64_FORMAT_F4,
	 IA64_FORMAT_F4_1,
	 IA64_FORMAT_F4_2,
	 IA64_FORMAT_F4_3,
	 IA64_FORMAT_F4_4,
	 IA64_FORMAT_F4_5,
	 IA64_FORMAT_F4_6,
	 IA64_FORMAT_F4_7,
	 IA64_FORMAT_F5,
	 IA64_FORMAT_F5_1,
	 IA64_FORMAT_F5_2,
	 IA64_FORMAT_F5_3,
	 IA64_FORMAT_F6,
	 IA64_FORMAT_F7,
	 IA64_FORMAT_F8,
	 IA64_FORMAT_F8_4,
	 IA64_FORMAT_F9,
	 IA64_FORMAT_F9_1,
	 IA64_FORMAT_F10,
	 IA64_FORMAT_F11,
	 IA64_FORMAT_F12,
	 IA64_FORMAT_F13,
	 IA64_FORMAT_F14,
	 IA64_FORMAT_F15,
	 IA64_FORMAT_X1,
	 IA64_FORMAT_X2,
	 IA64_FORMAT_X3,
	 IA64_FORMAT_X4,
	 IA64_FORMAT_X41,
	 IA64_FORMAT_LAST
};

enum IA64EnumOpcodeTemplateRole {
    IA64_TROLE_NONE = 0,
    IA64_TROLE_ALU,
    IA64_TROLE_BR,
    IA64_TROLE_FP,
    IA64_TROLE_INT,
    IA64_TROLE_LONG,
    IA64_TROLE_MEM,
    IA64_TROLE_MIBF,
    IA64_TROLE_LAST
};

#define IA64_DECISION_TREE_LEAF_NODE(node) ((byte)((node).pos) == 0xff)

struct IA64Template {
	byte stop;
	byte slot[3];
};

struct IA64DecisionTreeEntry {
	uint16 next_node;
	char pos;
	char size;
};

struct IA64Operand {
	IA64EnumOperandRole role;
	IA64EnumOperandType type;
};

struct IA64OpcodeEntry {
	const char			*name;
	IA64EnumOpcodeFormat		format;
	IA64EnumOpcodeTemplateRole   	role;
	IA64Operand			op1; // FIXME make array
	IA64Operand			op2;
	IA64Operand			op3;
	IA64Operand			op4;
	IA64Operand			op5;
	IA64Operand			op6;
};
																						  
extern IA64Template IA64Templates[];
extern IA64DecisionTreeEntry IA64DecisionTree[];
extern IA64OpcodeEntry IA64OpcodeTable[];


#endif
