/*=========================================================================

  Program:   Image Guided Surgery Software Toolkit
  Module:    $RCSfile: igstkQuadrantViews.cxx,v $
  Language:  C++
  Date:      $Date: 2009-01-30 20:49:52 $
  Version:   $Revision: 1.1 $

  Copyright (c) ISC  Insight Software Consortium.  All rights reserved.
  See IGSTKCopyright.txt or http://www.igstk.org/copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "igstkQuadrantViews.h"

namespace igstk
{

QuadrantViews::QuadrantViews(int X, int Y, int W, int H, const char *L)
  : Fl_Group(X, Y, W, H, L)
{

  m_Reporter = ::itk::Object::New();
 
  const int N = 15;    // Height of the slider bar
  const int WW = (int) (W-N)/2;
  const int HH = (int) (H- (N*2) )/2;

  // Create widgets
  typedef igstk::FLTKWidget   WidgetType;
  m_Displays.clear();
  m_DisplayAxialWidget    = new WidgetType(X, Y, WW, HH, "Display 0");
  m_Displays.push_back( m_DisplayAxialWidget);    // m_Displays[0]
  m_DisplaySagittalWidget = new WidgetType(X+WW+N, Y, WW, HH, "Display 1");
  m_Displays.push_back( m_DisplaySagittalWidget); // m_Displays[1]
  m_DisplayCoronalWidget  = new WidgetType(X, Y+HH+N, WW, HH, "Display 2");
  m_Displays.push_back( m_DisplayCoronalWidget);  // m_Displays[2]
  m_Display3DWidget       = new WidgetType(X+WW+N, Y+HH+N, WW, HH, "Display 3");
  m_Displays.push_back( m_Display3DWidget);       // m_Displays[3]

  // Create views
  m_Views.clear();
  ViewType::Pointer v;
  v = m_DisplayAxial    = ViewType2D::New();
  m_DisplayAxial->RequestSetOrientation( View2D::Axial );
  m_Views.push_back( v );    // Views[0];
  v = m_DisplaySagittal = ViewType2D::New();
  m_DisplaySagittal->RequestSetOrientation( View2D::Sagittal);
  m_Views.push_back( v );    // Views[1];
  v = m_DisplayCoronal  = ViewType2D::New();
  m_DisplayCoronal->RequestSetOrientation( View2D::Coronal );
  m_Views.push_back( v );    // Views[2];
  v = m_Display3D       = ViewType3D::New();
  m_Views.push_back( v );    // Views[3];

  // Connect views to widgets
  for( int i=0; i<4; i++ )
    {
    m_Displays[i]->RequestSetView( m_Views[i] );
    }
 

  // Create slider bars
  m_Sliders.clear();

    {
    Fl_Value_Slider* o = m_AxialSlider = new Fl_Value_Slider(X, Y+HH, WW, N);
    o->type(5);
    o->box(FL_DOWN_FRAME);
    o->maximum(3);
    o->step(1);
    o->callback((Fl_Callback*)cb_AxialSlider);
    o->deactivate();
    }

  m_Sliders.push_back( m_AxialSlider );

    {
    Fl_Value_Slider* o = m_SagittalSlider =
      new Fl_Value_Slider(X+WW+N, Y+HH, WW, N);
    o->type(5);
    o->box(FL_DOWN_FRAME);
    o->maximum(3);
    o->step(1);
    o->callback((Fl_Callback*)cb_SagittalSlider);
    o->deactivate();
    }

  m_Sliders.push_back( m_SagittalSlider );

    {
    Fl_Value_Slider* o = m_CoronalSlider = 
      new Fl_Value_Slider(X, HH*2+N+Y, WW, N);
    o->type(5);
    o->box(FL_DOWN_FRAME);
    o->maximum(3);
    o->step(1);
    o->callback((Fl_Callback*)cb_CoronalSlider);
    o->deactivate();
    }

  m_Sliders.push_back( m_CoronalSlider );

  end();
}

QuadrantViews::~QuadrantViews()
{
  m_Displays.clear();
  m_Views.clear();
  m_Sliders.clear();

  delete m_DisplayAxialWidget;
  delete m_DisplayCoronalWidget;
  delete m_DisplaySagittalWidget;
  delete m_Display3DWidget;

}
void QuadrantViews::RequestResliceImage(void)
{
  // Call back function for slider bars, to invoke the ReslicingEvent
  IndexType index;

  index[2]  = (int ) m_AxialSlider->value();
  index[0]  = (int ) m_SagittalSlider->value();
  index[1]  = (int ) m_CoronalSlider->value();

  ReslicingEvent reslicingEvent;
  reslicingEvent.Set( index );
  m_Reporter->InvokeEvent( reslicingEvent );

}

void QuadrantViews::cb_AxialSlider_i(Fl_Value_Slider*, void*)
{
  this->redraw();
  this->RequestResliceImage();
}
void QuadrantViews::cb_AxialSlider(Fl_Value_Slider* o, void* v)
{
  ((QuadrantViews*)(o->parent()))->cb_AxialSlider_i(o,v);
}

void QuadrantViews::cb_SagittalSlider_i(Fl_Value_Slider*, void*)
{
  this->redraw();
  this->RequestResliceImage();
}
void QuadrantViews::cb_SagittalSlider(Fl_Value_Slider* o, void* v)
{
  ((QuadrantViews*)(o->parent()))->cb_SagittalSlider_i(o,v);
}

void QuadrantViews::cb_CoronalSlider_i(Fl_Value_Slider*, void*)
{
  this->redraw();
  this->RequestResliceImage();
}
void QuadrantViews::cb_CoronalSlider(Fl_Value_Slider* o, void* v)
{
  ((QuadrantViews*)(o->parent()))->cb_CoronalSlider_i(o,v);
}

unsigned long QuadrantViews::AddObserver(
  const ::itk::EventObject & event, ::itk::Command * observer )
{
  return m_Reporter->AddObserver( event, observer );
}

void QuadrantViews::RemoveObserver( unsigned long tag )
{
  m_Reporter->RemoveObserver( tag );
}

void QuadrantViews::RemoveAllObservers()
{
  m_Reporter->RemoveAllObservers();
}

} // end namespace igstk
