/*************************************************************************
* Copyright (C) 2023 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/
#ifdef MBX_FIPS_MODE

#include <crypto_mb/fips_cert.h>
#include <internal/fips_cert/common.h>
#include <internal/rsa/ifma_rsa_method.h>

#include <crypto_mb/rsa.h>

/* KAT TEST (generated via internal tests) */
/* moduli */
static const int8u moduli[MBX_RSA3K_DATA_BYTE_LEN] = {
  0x2d,0xdd,0xba,0xb9,0x81,0x55,0xf3,0x2e,0x4f,0x5b,0xd8,0x6a,0x9c,0xa0,0x9c,0x37,
  0x7d,0x25,0x6b,0x92,0xc5,0xe2,0x80,0xa9,0xe1,0x72,0xcb,0xbd,0xf8,0xf0,0xde,0x52,
  0x04,0xc4,0xde,0x04,0x9d,0x74,0xa1,0xf0,0xc6,0x89,0x89,0x5e,0xf4,0xf7,0x38,0x03,
  0x9d,0xbd,0xa8,0xaa,0x6e,0x3f,0x68,0x2d,0x80,0x35,0x95,0xf0,0xa4,0xb4,0x23,0xe0,
  0x12,0x33,0x1d,0x73,0xa5,0xea,0xf0,0xa8,0x95,0xd0,0x09,0x34,0x32,0x1a,0xc4,0x35,
  0x16,0xe9,0xf4,0xf9,0x30,0x97,0x1d,0xb5,0xb4,0x39,0x7e,0x00,0xf9,0x16,0x22,0x1b,
  0x69,0x18,0x9a,0x43,0xc0,0xab,0x21,0x34,0x7b,0x66,0xd6,0xee,0x88,0xfd,0x7b,0x77,
  0x22,0x3e,0x58,0xe8,0x39,0x57,0x92,0x54,0xb9,0x21,0x02,0x28,0xdb,0x56,0xcf,0xe1,
  0xe1,0xf6,0xa0,0x79,0x69,0x2f,0x20,0x0f,0xe3,0x18,0x0d,0x72,0xda,0x09,0x79,0x7c,
  0x48,0x23,0x6d,0x7f,0xf3,0x8e,0xb7,0xce,0xad,0xf1,0xba,0xb2,0x76,0x59,0x22,0xd0,
  0xad,0xb1,0x7c,0xae,0x9e,0x86,0xcd,0xb8,0x0d,0x8f,0x4c,0x53,0x8c,0x08,0x07,0xf5,
  0x90,0xa4,0xe8,0x25,0x4d,0x30,0x24,0x0f,0x6f,0x50,0x9b,0x83,0xd1,0x92,0x5d,0xc5,
  0xd5,0xfd,0xec,0x0b,0x88,0x1f,0xfc,0x5a,0x16,0x2a,0x87,0x9d,0x93,0x3f,0xfe,0x3a,
  0x08,0x05,0xd8,0x6d,0x16,0xe1,0x3c,0x86,0x3b,0x65,0x23,0xbc,0xda,0x35,0xb3,0x2b,
  0x43,0x28,0x1e,0x1c,0x3e,0xc8,0xaa,0x37,0x46,0x31,0xa4,0x9c,0x0b,0xc4,0x4c,0x50,
  0xf4,0x0c,0xac,0x2d,0x4d,0xa3,0x43,0x40,0x5a,0xb2,0xb0,0x38,0x22,0xbe,0x42,0x85,
  0x17,0xd9,0xaa,0xc5,0x2f,0xca,0x2d,0xa9,0x1d,0x71,0xc7,0x8f,0x53,0xc4,0xb3,0x73,
  0x03,0xa4,0xbc,0xf3,0x24,0xe7,0x57,0x8f,0x5f,0x08,0x5e,0xe9,0xe8,0xcd,0xfd,0xf9,
  0xc0,0x2f,0x57,0xae,0x46,0xea,0xbb,0xa7,0xc1,0xa5,0xd9,0x5d,0x86,0x1d,0x45,0x39,
  0x92,0x30,0x94,0x11,0xc5,0x48,0x3e,0xde,0x04,0x1a,0xfa,0x4f,0x87,0x7d,0x17,0x96,
  0x89,0x25,0x24,0x3d,0xa7,0x64,0xff,0xc3,0xd1,0x17,0x2f,0xef,0xf2,0x60,0x2f,0xcd,
  0x4c,0xae,0xd9,0x5c,0xb9,0xeb,0x14,0x93,0xe4,0x86,0xa5,0xde,0x1a,0xf6,0xef,0xf6,
  0x66,0x49,0xab,0xae,0xb2,0x01,0x61,0xe9,0x1a,0x76,0xcf,0x75,0xbc,0xcf,0x00,0x30,
  0xff,0x36,0x42,0x28,0xfa,0xdb,0x24,0x67,0x56,0x5c,0x85,0x40,0x0e,0xac,0x7e,0xe7};
/* plaintext */
static const int8u plaintext[MBX_RSA3K_DATA_BYTE_LEN] = {
  0xab,0x58,0x51,0x58,0x18,0x3d,0xff,0x97,0x5c,0x1e,0x73,0x8d,0xce,0x25,0xa4,0x60,
  0x24,0x77,0xdd,0xe4,0x90,0x0b,0x18,0x5b,0x0f,0x93,0xb4,0xfc,0x5e,0x6a,0x07,0xa5,
  0xdd,0x0b,0x2c,0x95,0x5e,0xb3,0xe4,0x10,0xc7,0xe6,0x70,0x78,0x29,0xda,0xe1,0x36,
  0xcc,0xa2,0xa2,0xf7,0xa9,0xcd,0xc6,0x5f,0xfa,0x48,0x4f,0xe6,0x49,0x0d,0xab,0xd6,
  0x2f,0x98,0xda,0xb4,0x83,0x7c,0x1e,0xa8,0xd5,0xd1,0xa3,0x3c,0x25,0x24,0xad,0x17,
  0x1e,0xc1,0x90,0xd3,0xe9,0x43,0x97,0x90,0x98,0xae,0xb6,0x89,0xec,0x43,0x9e,0x0d,
  0x3c,0x34,0xf1,0x47,0x92,0x47,0xbc,0x2d,0xd6,0xa0,0xc2,0xb8,0xf7,0x23,0xdb,0xb9,
  0xa8,0xc5,0xe5,0x68,0xcd,0xcf,0x1d,0xae,0x28,0x65,0xea,0x23,0xdc,0xd9,0xcd,0x91,
  0x62,0x81,0x32,0x52,0x65,0x67,0x53,0xef,0xcb,0x98,0x81,0x80,0xca,0xbf,0x3f,0xad,
  0x36,0xd0,0x44,0xe2,0x99,0x87,0x95,0xd2,0xf3,0xd1,0xa1,0xa5,0x7a,0x22,0x85,0xf9,
  0xf6,0x5e,0x33,0x8c,0x70,0x26,0x3a,0xb9,0x39,0x0b,0x22,0x03,0x35,0xbb,0x8d,0xbb,
  0x5e,0x93,0x90,0xd5,0xd4,0x13,0x6c,0x41,0x91,0xc9,0xce,0x7c,0x22,0x5b,0x97,0xc6,
  0x59,0x9e,0xfc,0xde,0x83,0xb6,0x35,0x8c,0xe1,0xc3,0x17,0x93,0x66,0xf7,0xa3,0x24,
  0xa1,0x34,0x3d,0x13,0x03,0x0f,0xd0,0x27,0x89,0xc4,0xdc,0x39,0x3e,0x67,0xe9,0x8b,
  0x89,0x5f,0x78,0x6c,0x0a,0xaa,0xc0,0x43,0x9e,0x3a,0xb3,0x28,0xe6,0xad,0x93,0xae,
  0xac,0x3a,0x31,0x77,0xf3,0x63,0xa6,0xab,0x65,0xbb,0x1e,0x4b,0x9f,0xa7,0xb8,0xce,
  0x5f,0xc5,0xc9,0xb6,0x0c,0xc6,0xe7,0xec,0xd8,0x00,0x9d,0x4f,0x0b,0x03,0x95,0x0c,
  0x7e,0x0c,0x95,0xc1,0x1d,0x21,0x48,0xf0,0x29,0x0d,0x09,0x8a,0x4d,0xa6,0x3e,0x28,
  0x1e,0x7a,0x6d,0xb3,0x61,0xab,0xff,0x48,0xa5,0x9d,0x9f,0xcf,0xe9,0xc7,0xed,0xb9,
  0xa6,0xcd,0xb6,0xe2,0xb1,0x04,0xfd,0x34,0xd9,0x80,0x9a,0x51,0x9b,0x01,0x12,0x4f,
  0x0c,0xd0,0xe9,0x70,0x54,0x83,0xd4,0xe5,0xc4,0x32,0x4e,0x99,0xd9,0x80,0xd5,0xd7,
  0x3b,0x91,0xc6,0x06,0xf9,0x91,0xc3,0x9b,0xe6,0x89,0x15,0x50,0x42,0x73,0x5d,0xb5,
  0x5f,0xaa,0x10,0x7e,0x74,0xf9,0x9d,0xf7,0x2f,0xd1,0x23,0xf6,0x55,0x9f,0x67,0xe0,
  0x75,0xdc,0xf0,0xfc,0x31,0x63,0x6e,0x97,0x45,0x4c,0x4b,0xc0,0x1a,0x85,0xab,0x67};
/* ciphertext */
static const int8u ciphertext[MBX_RSA3K_DATA_BYTE_LEN] = {
  0x5f,0x90,0x79,0xdb,0x8c,0x83,0xae,0x9d,0x81,0x00,0x79,0x97,0x34,0x9d,0x0e,0x10,
  0x36,0xef,0x23,0xf9,0x8e,0x89,0xc8,0xdc,0x32,0x7c,0xb7,0x75,0x8e,0x6e,0xb6,0x58,
  0xc3,0x3a,0x79,0x52,0x5b,0x0b,0x0d,0x80,0xac,0x34,0x9c,0xa6,0xe0,0x26,0x12,0xf3,
  0xd2,0x3b,0xbd,0xce,0x44,0x2f,0x4c,0xd4,0x9d,0x58,0xdd,0xc0,0xdc,0xaa,0x03,0xe7,
  0x78,0x9b,0x31,0x92,0x1d,0xe6,0xc2,0x39,0xd1,0x9a,0xdf,0x62,0x31,0x5c,0xfd,0xcc,
  0x15,0x90,0x49,0xe6,0xbe,0x77,0x61,0x73,0x08,0x67,0xac,0x2b,0x88,0x1c,0x2e,0x25,
  0xbe,0x30,0x4a,0x29,0x60,0x42,0x84,0xc0,0x62,0xb8,0x21,0xe0,0x03,0x79,0xfc,0x9d,
  0xe8,0x3e,0x72,0xaf,0x3c,0xf1,0xd5,0x0d,0x2f,0x3c,0xe0,0x13,0x75,0xca,0x81,0x73,
  0xf2,0xcd,0xd0,0xf1,0xd3,0x77,0xbb,0x83,0x01,0xc4,0x3f,0x47,0x06,0x4f,0x34,0x20,
  0xd3,0x64,0x69,0xc0,0x80,0xb9,0xf5,0x79,0x2c,0x01,0x40,0xf0,0xd9,0xb8,0x92,0x5b,
  0xbb,0xbf,0x9a,0xf9,0x50,0x48,0x01,0xaf,0xae,0x0a,0x06,0x88,0xbc,0xf0,0xce,0x55,
  0x6d,0x83,0x8c,0x70,0x83,0x74,0xe6,0x0c,0x42,0xdb,0xc0,0x78,0x43,0xa7,0x36,0x6a,
  0xc7,0x74,0xa0,0x76,0x02,0x5e,0xfa,0x7b,0xf5,0xf4,0x6a,0xf2,0xea,0x43,0x58,0xba,
  0x75,0x24,0x9b,0xc8,0xbc,0x06,0xd8,0x16,0x26,0x1a,0xeb,0xad,0x3e,0xc0,0x0d,0xc9,
  0xc3,0xd4,0x7d,0xd1,0xee,0xf0,0x8a,0x1c,0x6a,0x3f,0x94,0x8d,0x9f,0x6e,0xc1,0x0f,
  0xb8,0xd9,0xed,0xe9,0x38,0xfa,0x67,0x28,0x30,0x5a,0xad,0x9c,0x33,0x02,0x64,0xa7,
  0x76,0xb4,0xad,0x56,0xf8,0x0f,0x04,0x9e,0x7b,0x68,0x88,0xeb,0xeb,0x5f,0x12,0x87,
  0xfb,0xe9,0x7a,0x12,0x8f,0x45,0xd3,0x10,0x84,0x59,0x63,0x42,0x69,0x05,0x03,0x9e,
  0xe3,0x30,0x31,0xb2,0x85,0x58,0xf0,0xd3,0x94,0x97,0xc1,0x83,0x14,0xc3,0x95,0x1d,
  0x12,0xfe,0x47,0x26,0x23,0x50,0x0e,0x69,0xcd,0xf3,0xc5,0x63,0x05,0x65,0xda,0xc9,
  0x4d,0x93,0x57,0x44,0x92,0xd3,0xeb,0x4e,0x24,0x05,0x61,0x84,0xec,0x6f,0x2d,0xb6,
  0xd5,0xcc,0xf4,0xa1,0x3e,0x5b,0x2e,0xbc,0x9c,0xdc,0xf9,0xf0,0x36,0xc9,0x2f,0x6c,
  0xaf,0x72,0x44,0x2b,0xa8,0x35,0x18,0x27,0x08,0xa0,0x15,0x69,0x1b,0xef,0xcd,0x87,
  0x31,0xe0,0xe6,0x52,0x05,0xb1,0x50,0x61,0x8b,0xa1,0x34,0x17,0x9e,0x00,0x71,0xd0};

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa3k_public_mb8(void) {
  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output ciphertext */
  int8u out_ciphertext[MBX_LANES][MBX_RSA3K_DATA_BYTE_LEN];
  /* key operation */
  const mbx_RSA_Method* method = mbx_RSA3K_pub65537_Method();

  /* function input parameters */
  // plaintext
  const int8u *pa_plaintext[MBX_LANES] = {
    plaintext, plaintext, plaintext, plaintext,
    plaintext, plaintext, plaintext, plaintext};
  // ciphertext
  int8u *pa_ciphertext[MBX_LANES] = {
    out_ciphertext[0], out_ciphertext[1], out_ciphertext[2], out_ciphertext[3],
    out_ciphertext[4], out_ciphertext[5], out_ciphertext[6], out_ciphertext[7]};
  // moduli
  const int64u *pa_moduli[MBX_LANES] = {
    (int64u *)moduli, (int64u *)moduli, (int64u *)moduli, (int64u *)moduli,
    (int64u *)moduli, (int64u *)moduli, (int64u *)moduli, (int64u *)moduli};

  /* test function */
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);

  mbx_status sts;
  sts = mbx_rsa_public_mb8(pa_plaintext, pa_ciphertext, pa_moduli, MBX_RSA3K_DATA_BIT_LEN, method, NULL);
  if (expected_status_mb8 != sts) {
    if (sts == MBX_SET_STS_ALL(MBX_STATUS_UNSUPPORTED_ISA_ERR)) {
      test_result = MBX_ALGO_SELFTEST_UNSUPPORTED_ISA_ERR;
    }
    else {
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }
  // compare output ciphertext to known answer
  int output_status;
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_ciphertext[i], MBX_RSA3K_DATA_BYTE_LEN, ciphertext, MBX_RSA3K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  return test_result;
}

#ifndef BN_OPENSSL_DISABLE
/* exponent (for ssl function only) */
static const int8u exponent[MBX_RSA_PUB_EXP_BYTE_LEN] = {0x01,0x00,0x01};

// memory free macro
#define MEM_FREE(BN_PTR1, BN_PTR2) { \
  BN_free(BN_PTR1);                  \
  BN_free(BN_PTR2); }

DLL_PUBLIC
fips_test_status fips_selftest_mbx_rsa3k_public_ssl_mb8(void) {

  fips_test_status test_result = MBX_ALGO_SELFTEST_OK;

  /* output ciphertext */
  int8u out_ciphertext[MBX_LANES][MBX_RSA3K_DATA_BYTE_LEN];
  /* ssl exponent */
  BIGNUM* BN_e = BN_new();
  /* ssl moduli */
  BIGNUM* BN_moduli = BN_new();
  /* check if allocated memory is valid */
  if(NULL == BN_e || NULL == BN_moduli) {
    test_result = MBX_ALGO_SELFTEST_BAD_ARGS_ERR;
    MEM_FREE(BN_e, BN_moduli)
    return test_result;
  }

  /* function status and expected status */
  mbx_status sts;
  mbx_status expected_status_mb8 = MBX_SET_STS_ALL(MBX_STATUS_OK);
  /* output validity status */
  int output_status;

  /* set ssl parameters */
  BN_lebin2bn(exponent, MBX_RSA_PUB_EXP_BYTE_LEN, BN_e);
  BN_lebin2bn(moduli, MBX_RSA3K_DATA_BYTE_LEN, BN_moduli);

  /* function input parameters */
  // plaintext
  const int8u *pa_plaintext[MBX_LANES] = {
    plaintext, plaintext, plaintext, plaintext,
    plaintext, plaintext, plaintext, plaintext};
  // ciphertext
  int8u *pa_ciphertext[MBX_LANES] = {
    out_ciphertext[0], out_ciphertext[1], out_ciphertext[2], out_ciphertext[3],
    out_ciphertext[4], out_ciphertext[5], out_ciphertext[6], out_ciphertext[7]};
  // moduli
  const BIGNUM *pa_moduli[MBX_LANES] = {
    (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli,
    (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli, (const BIGNUM *)BN_moduli};
  const BIGNUM *pa_e[MBX_LANES] = {
    (const BIGNUM *)BN_e, (const BIGNUM *)BN_e, (const BIGNUM *)BN_e, (const BIGNUM *)BN_e,
    (const BIGNUM *)BN_e, (const BIGNUM *)BN_e, (const BIGNUM *)BN_e, (const BIGNUM *)BN_e};

  /* test function */
  sts = mbx_rsa_public_ssl_mb8(pa_plaintext, pa_ciphertext, pa_e, pa_moduli, MBX_RSA3K_DATA_BIT_LEN);
  if (expected_status_mb8 != sts) {
    if (sts == MBX_SET_STS_ALL(MBX_STATUS_UNSUPPORTED_ISA_ERR)) {
      test_result = MBX_ALGO_SELFTEST_UNSUPPORTED_ISA_ERR;
    }
    else {
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }
  // compare output signature to known answer
  for (int i = 0; (i < MBX_LANES) && (MBX_ALGO_SELFTEST_OK == test_result); ++i) {
    output_status = mbx_is_mem_eq(pa_ciphertext[i], MBX_RSA3K_DATA_BYTE_LEN, ciphertext, MBX_RSA3K_DATA_BYTE_LEN);
    if (!output_status) { // wrong output
      test_result = MBX_ALGO_SELFTEST_KAT_ERR;
    }
  }

  // memory free
  MEM_FREE(BN_e, BN_moduli)

  return test_result;
}

#endif // BN_OPENSSL_DISABLE
#endif // MBX_FIPS_MODE
