/*
 * Decompiled with CFR 0.152.
 */
package jonelo.jacksum.adapt.gnu.crypto.hash;

import jonelo.jacksum.adapt.gnu.crypto.hash.BaseHash;
import jonelo.jacksum.adapt.gnu.crypto.util.Util;

public class Sha0
extends BaseHash {
    private static final int BLOCK_SIZE = 64;
    private static final String DIGEST0 = "0164B8A914CD2A5E74C4F7FF082C4D97F1EDF880";
    private static final int[] w = new int[80];
    private static Boolean valid;
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;

    public Sha0() {
        super("sha-0", 20, 64);
    }

    private Sha0(Sha0 sha0) {
        this();
        this.h0 = sha0.h0;
        this.h1 = sha0.h1;
        this.h2 = sha0.h2;
        this.h3 = sha0.h3;
        this.h4 = sha0.h4;
        this.count = sha0.count;
        this.buffer = (byte[])sha0.buffer.clone();
    }

    public static final int[] G(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        return Sha0.sha(n, n2, n3, n4, n5, byArray, n6);
    }

    public Object clone() {
        return new Sha0(this);
    }

    protected void transform(byte[] byArray, int n) {
        int[] nArray = Sha0.sha(this.h0, this.h1, this.h2, this.h3, this.h4, byArray, n);
        this.h0 = nArray[0];
        this.h1 = nArray[1];
        this.h2 = nArray[2];
        this.h3 = nArray[3];
        this.h4 = nArray[4];
    }

    protected byte[] padBuffer() {
        int n = (int)(this.count % 64L);
        int n2 = n < 56 ? 56 - n : 120 - n;
        byte[] byArray = new byte[n2 + 8];
        byArray[0] = -128;
        long l = this.count << 3;
        byArray[n2++] = (byte)(l >>> 56);
        byArray[n2++] = (byte)(l >>> 48);
        byArray[n2++] = (byte)(l >>> 40);
        byArray[n2++] = (byte)(l >>> 32);
        byArray[n2++] = (byte)(l >>> 24);
        byArray[n2++] = (byte)(l >>> 16);
        byArray[n2++] = (byte)(l >>> 8);
        byArray[n2] = (byte)l;
        return byArray;
    }

    protected byte[] getResult() {
        byte[] byArray = new byte[]{(byte)(this.h0 >>> 24), (byte)(this.h0 >>> 16), (byte)(this.h0 >>> 8), (byte)this.h0, (byte)(this.h1 >>> 24), (byte)(this.h1 >>> 16), (byte)(this.h1 >>> 8), (byte)this.h1, (byte)(this.h2 >>> 24), (byte)(this.h2 >>> 16), (byte)(this.h2 >>> 8), (byte)this.h2, (byte)(this.h3 >>> 24), (byte)(this.h3 >>> 16), (byte)(this.h3 >>> 8), (byte)this.h3, (byte)(this.h4 >>> 24), (byte)(this.h4 >>> 16), (byte)(this.h4 >>> 8), (byte)this.h4};
        return byArray;
    }

    protected void resetContext() {
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
    }

    public boolean selfTest() {
        if (valid == null) {
            Sha0 sha0 = new Sha0();
            sha0.update((byte)97);
            sha0.update((byte)98);
            sha0.update((byte)99);
            String string = Util.toString(sha0.digest());
            valid = new Boolean(DIGEST0.equals(string));
        }
        return valid;
    }

    private static final synchronized int[] sha(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        int n7;
        int n8;
        int n9 = n;
        int n10 = n2;
        int n11 = n3;
        int n12 = n4;
        int n13 = n5;
        for (n8 = 0; n8 < 16; ++n8) {
            Sha0.w[n8] = byArray[n6++] << 24 | (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
        }
        for (n8 = 16; n8 < 80; ++n8) {
            Sha0.w[n8] = w[n8 - 3] ^ w[n8 - 8] ^ w[n8 - 14] ^ w[n8 - 16];
        }
        for (n8 = 0; n8 < 20; ++n8) {
            n7 = (n9 << 5 | n9 >>> 27) + (n10 & n11 | ~n10 & n12) + n13 + w[n8] + 1518500249;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 30 | n10 >>> 2;
            n10 = n9;
            n9 = n7;
        }
        for (n8 = 20; n8 < 40; ++n8) {
            n7 = (n9 << 5 | n9 >>> 27) + (n10 ^ n11 ^ n12) + n13 + w[n8] + 1859775393;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 30 | n10 >>> 2;
            n10 = n9;
            n9 = n7;
        }
        for (n8 = 40; n8 < 60; ++n8) {
            n7 = (n9 << 5 | n9 >>> 27) + (n10 & n11 | n10 & n12 | n11 & n12) + n13 + w[n8] + -1894007588;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 30 | n10 >>> 2;
            n10 = n9;
            n9 = n7;
        }
        for (n8 = 60; n8 < 80; ++n8) {
            n7 = (n9 << 5 | n9 >>> 27) + (n10 ^ n11 ^ n12) + n13 + w[n8] + -899497514;
            n13 = n12;
            n12 = n11;
            n11 = n10 << 30 | n10 >>> 2;
            n10 = n9;
            n9 = n7;
        }
        return new int[]{n + n9, n2 + n10, n3 + n11, n4 + n12, n5 + n13};
    }
}

