/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.util;

import java.text.MessageFormat;
import java.util.ArrayList;

public class GeneralString {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String specialChars = "=: \t\r\n\f#!";

    public static char nibbleToHexChar(int n) {
        return hexDigits[n & 0xF];
    }

    public static String replaceString(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n > -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, n));
            stringBuffer.append(string3);
            stringBuffer.append(string.substring(n + string2.length()));
            return stringBuffer.toString();
        }
        return string;
    }

    public static String replaceAllStrings(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = string2.length();
        while ((n = stringBuffer.toString().lastIndexOf(string2, n - 1)) > -1) {
            stringBuffer.replace(n, n + n2, string3);
        }
        return stringBuffer.toString();
    }

    public static void replaceAllStrings(StringBuffer stringBuffer, String string, String string2) {
        int n = stringBuffer.length();
        int n2 = string.length();
        while ((n = stringBuffer.toString().lastIndexOf(string, n - 1)) > -1) {
            stringBuffer.replace(n, n + n2, string2);
        }
    }

    public static String removeAllStrings(String string, String string2) {
        return GeneralString.replaceAllStrings(string, string2, "");
    }

    public static String replaceString(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string2.length(); ++i) {
            stringBuffer.setCharAt(n + i, string2.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String translateEscapeSequences(String string) {
        String string2 = string;
        string2 = GeneralString.replaceAllStrings(string2, "\\t", "\t");
        string2 = GeneralString.replaceAllStrings(string2, "\\n", "\n");
        string2 = GeneralString.replaceAllStrings(string2, "\\r", "\r");
        string2 = GeneralString.replaceAllStrings(string2, "\\\"", "\"");
        string2 = GeneralString.replaceAllStrings(string2, "\\'", "'");
        string2 = GeneralString.replaceAllStrings(string2, "\\\\", "\\");
        return string2;
    }

    public static String removeChar(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String removeChar(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length() - 1);
        stringBuffer.append(string.substring(0, n)).append(string.substring(n + 1));
        return stringBuffer.toString();
    }

    public static String replaceChar(String string, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            stringBuffer.setCharAt(i, c2);
        }
        return stringBuffer.toString();
    }

    public static String replaceChar(String string, int n, char c) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(n, c);
        return stringBuffer.toString();
    }

    public static int countChar(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static String message(String string, char c) {
        Character c2 = new Character(c);
        Object[] objectArray = new Object[]{c2.toString()};
        String string2 = MessageFormat.format(string, objectArray);
        return string2;
    }

    public static String message(String string, int n) {
        Integer n2 = new Integer(n);
        Object[] objectArray = new Object[]{n2.toString()};
        String string2 = MessageFormat.format(string, objectArray);
        return string2;
    }

    public static String message(String string, int n, int n2) {
        Integer n3 = new Integer(n);
        Integer n4 = new Integer(n2);
        Object[] objectArray = new Object[]{n3.toString(), n4.toString()};
        String string2 = MessageFormat.format(string, objectArray);
        return string2;
    }

    public static String message(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        String string3 = MessageFormat.format(string, objectArray);
        return string3;
    }

    public static String decodeEncodedUnicode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        block7: while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\') {
                c = string.charAt(n2++);
                switch (c) {
                    case 'u': {
                        int n3 = 0;
                        for (int i = 0; i < 4; ++i) {
                            if ((c = string.charAt(n2++)) >= '0' && c <= '9') {
                                n3 = (n3 << 4) + c - 48;
                                continue;
                            }
                            if (c >= 'a' && c <= 'f') {
                                n3 = (n3 << 4) + 10 + c - 97;
                                continue;
                            }
                            if (c >= 'A' && c <= 'F') {
                                n3 = (n3 << 4) + 10 + c - 65;
                                continue;
                            }
                            throw new IllegalArgumentException("Wrong \\uxxxx encoding");
                        }
                        stringBuffer.append((char)n3);
                        continue block7;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        continue block7;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        continue block7;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        continue block7;
                    }
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String encodeUnicode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(GeneralString.nibbleToHexChar(c >> 12 & 0xF));
                        stringBuffer.append(GeneralString.nibbleToHexChar(c >> 8 & 0xF));
                        stringBuffer.append(GeneralString.nibbleToHexChar(c >> 4 & 0xF));
                        stringBuffer.append(GeneralString.nibbleToHexChar(c & 0xF));
                        continue block8;
                    }
                    if (specialChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String[] split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = -1;
        do {
            if ((n2 = string.substring(n).indexOf(string2)) <= -1) continue;
            arrayList.add(string.substring(n, n + n2));
            n = n + n2 + string2.length();
        } while (n2 > -1);
        if (n < string.length()) {
            arrayList.add(string.substring(n));
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }
}

