INSERT INTO interface_types_fields (id,  description,  name,  pos,  itype,  ftype,  showable,  overwritable,  tracked,  default_value) VALUES (407, 'Ignore Case', 'ignore_case', 30, 15, 8, 1, 1, 0, '0');
--
-- Compaq fixes
--
INSERT INTO interface_types VALUES
(55,'Compaq Power Supply',1,0,'cpqmib','powersupply',55,0,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,1,0,'none',0,1,0);

INSERT INTO interface_types_fields VALUES
(388,'Index','index',5,55,3,0,0,0,''),
(389,'Chassis','chassis',10,55,8,1,0,1,''),
(390,'Bay','bayindex',15,55,8,1,0,1,'');

INSERT INTO pollers VALUES
(216,'power_status','Compaq Power Condition','snmp_status','1.3.6.1.4.1.232.6.2.9.3.1.4.<chassis>.<bayindex>,2=up');

INSERT INTO pollers_groups VALUES
(55,'Compaq Power Supply',55);

INSERT INTO pollers_poller_groups VALUES
(261,55,10,216,20);


--
-- Dell OpenManage fixes for 0.8.4
INSERT INTO graph_types VALUES
(96,'Dell OpenManage Ambient Temp',47,'dell_om_temp','',500,150,0,0,0),
(97,'Dell OpenManage Fan RPM',47,'dell_om_fan','',500,150,0,0,0);

INSERT INTO interface_types_fields VALUES
(352,'Dell OpenManage Fan RPM #2','dell_om_fan_2',51,47,20,0,0,0,'DS:dell_om_fan_2:GAUGE:600:0:100000'),
(353,'Dell OpenManage Fan RPM #3','dell_om_fan_3',52,47,20,0,0,0,'DS:dell_om_fan_3:GAUGE:600:0:100000'),
(354,'Dell OpenManage Fan RPM #4','dell_om_fan_4',53,47,20,0,0,0,'DS:dell_om_fan_4:GAUGE:600:0:100000'),
(355,'Dell OpenManage Fan RPM #5','dell_om_fan_5',54,47,20,0,0,0,'DS:dell_om_fan_5:GAUGE:600:0:100000'),
(356,'Dell OpenManage Fan RPM #6','dell_om_fan_6',55,47,20,0,0,0,'DS:dell_om_fan_6:GAUGE:600:0:100000'),
(357,'Dell OpenManage Fan RPM #7','dell_om_fan_7',56,47,20,0,0,0,'DS:dell_om_fan_7:GAUGE:600:0:100000');

INSERT INTO pollers VALUES
(195,'dell_om_temp','Dell OpenManage Ambient Temp','snmp_counter','1.3.6.1.4.1.674.10892.1.700.20.1.6.1.1'),
(196,'dell_om_fan_1','Dell OpenManage Fan RPM #1','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.1'),
(197,'dell_om_fan_2','Dell OpenManage Fan RPM #2','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.2'),
(198,'dell_om_fan_3','Dell OpenManage Fan RPM #3','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.3'),
(199,'dell_om_fan_4','Dell OpenManage Fan RPM #4','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.4'),
(200,'dell_om_fan_5','Dell OpenManage Fan RPM #5','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.5'),
(201,'dell_om_fan_6','Dell OpenManage Fan RPM #6','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.6'),
(202,'dell_om_fan_7','Dell OpenManage Fan RPM #7','snmp_counter','1.3.6.1.4.1.674.10892.1.700.12.1.6.1.7');

--
-- dot11x support

INSERT INTO interface_types VALUES
(53,'Cisco 802.11X Device',1,0,'simple','.1.3.6.1.4.1.9.9.273.1.1.2.1.1.1,Cisco 802.11X Device',53,1,'RRA:AVERAGE:0.5:1\r\n:<resolution>','103680',300,102,0,'none',0,1,0);

INSERT INTO interface_types_fields VALUES
(380,'Index','index',1,53,3,0,0,0,''),
(381,'Description','description',10,53,7,1,1,0,''),
(382,'Associated','associated',20,53,20,0,0,0,'DS:associated:GAUGE:600:0:2100');

INSERT INTO pollers VALUES
(215,'associated','Client Associated','snmp_counter','.1.3.6.1.4.1.9.9.273.1.1.2.1.1.1');


INSERT INTO pollers_groups VALUES
(53,'Cisco 802.11X Device',53);

INSERT INTO pollers_poller_groups VALUES
(258,53,1,215,32);


--
-- Generic FC support
--

INSERT INTO graph_types VALUES
(105,'FC Frames',52,'frames','',500,175,0,0,0);

INSERT INTO interface_types VALUES
(52,'Generic FC Ports',1,0,'fc_ports','',52,1,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,101,0,'none',0,1,0);


INSERT INTO interface_types_fields VALUES
(374,'Index','index',10,52,3,0,0,0,''),
(375,'Oper Status','oper',30,52,8,1,0,0,''),
(376,'Tx Frames','tx_frames',40,52,20,0,0,0,'DS:tx_frames:COUNTER:600:0:100000000'),
(377,'Rx Frames','rx_frames',50,52,20,0,0,0,'DS:rx_frames:COUNTER:600:0:100000000'),
(378,'FC Port','real_index',11,52,7,1,0,1,''),
(379,'Admin Status','admin',20,52,8,1,0,0,'');

INSERT INTO pollers VALUES
(212,'status','FC Oper Status','snmp_status','.1.3.6.1.2.1.75.1.2.2.1.2.<real_index>,1=up|2=offline|4=linkFailure'),
(213,'rx_frames','FCPort RxFrames','snmp_counter','.1.3.6.1.2.1.75.1.4.3.1.1.<real_index>'),
(214,'tx_frames','FCPort TxFrames','snmp_counter','.1.3.6.1.2.1.75.1.4.3.1.2.<real_index>');


INSERT INTO pollers_groups VALUES
(52,'Fibre Channel Interface',52);

INSERT INTO pollers_poller_groups VALUES
(252,52,1,212,20),
(253,52,5,213,9),
(254,52,10,214,9),
(255,52,20,1,10);


--
-- IBM interface types


INSERT INTO graph_types VALUES
(106,'IBM Blade Temperature',51,'ibm_blade_cpu_temp','',500,150,0,0,0),
(107,'IBM Blade Power',54,'ibm_blade_power','',500,150,0,0,0);

INSERT INTO interface_types VALUES
(50,'IBM Component Health',1,0,'ibm_ComponentHealth','',57,0,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,1,0,'none',0,1,0),
(51,'IBM Blade server',1,0,'ibm_blade_servers','',51,1,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,100,0,'none',0,1,0),
(54,'IBM Blade Power',1,0,'ibm_blade_power','',54,1,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,103,0,'none',0,1,0),
(56,'IBM Storage Controller',0,0,'ibm_ds_storage','storagesubsystem',56,0,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,1,0,'none',0,1,0);

INSERT INTO interface_types_fields VALUES
(394,'Index','index',5,50,3,0,0,0,''),
(368,'Index','index',10,51,3,0,0,0,''),
(369,'Health State','health_state',15,51,7,0,0,1,''),
(370,'Serial Number','serial',20,51,7,1,0,1,''),
(371,'Manuf date','manuf_date',30,51,7,1,0,1,''),
(372,'CPU1 Temperature','temperature',35,51,20,0,0,0,'DS:temperature:GAUGE:600:0:100'),
(373,'CPU2 Temperature','temperature2',40,51,20,0,0,0,'DS:temperature2:GAUGE:600:0:100'),
(383,'Index','index',10,54,3,0,0,0,''),
(384,'Power Module 1','module1',15,54,7,1,0,1,''),
(385,'Power Module 2','module2',20,54,7,1,0,1,''),
(386,'Power Consumption','fuelGaugePowerInUse',35,54,20,2,0,0,'DS:fuelGaugePowerInUse:GAUGE:600:0:10000'),
(387,'Power Capacity','totalpower',30,54,7,1,0,0,''),
(391,'Index','index',1,56,3,0,0,0,''),
(392,'Number of arrays','nb_arrays',10,56,8,1,0,0,'');


INSERT INTO pollers VALUES
(206,'ibm_component_health','IBM Component Health Status','snmp_status','1.3.6.1.4.1.2.6.159.1.1.30.3.1.2.<index>,0=up|1=warning|2=down'),
(207,'status','IBM Blade Server Health Status','snmp_status','.1.3.6.1.4.1.2.3.51.2.22.1.5.1.1.5.<index>,1=up'),
(208,'temperature','IBM Blade Server CPU1 Temp','snmp_counter_ibm','.1.3.6.1.4.1.2.3.51.2.22.1.5.3.1.13.<index>'),
(209,'status','IBM Blade Power Status','snmp_status_ibm','.1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.3.<index>,1=u\r\np|2=warning|3=down'),
(210,'fuelGaugePowerInUse','IBM Blade Power Gauge','snmp_counter_ibm','.1.3.6.1.4.1.2.3.51.2.2.10.1.1.1.10.<index>'),
(211,'temperature2','IBM Blade Server CPU2 Temp','snmp_counter_ibm','.1.3.6.1.4.1.2.3.51.2.22.1.5.\r\n3.1.14.<index>'),
(217,'status','IBM Storage Controller status','ibm_ds_storage','controler'),
(218,'arraystatus','AS 400 System','snmp_array_null','.1.3.6.1.2.1.25.2.3.1.6');

INSERT INTO pollers_backend VALUES
(41,'Alarm IBM','alarm','75',1),
(42,'IBM San Trap','event','77',0),
(43,'Alarm OS/400','alarm','78',1),
(44,'Alarm IBM Storage Controller','alarm','80',1);

INSERT INTO pollers_groups VALUES
(57,'IBM Component Health',50),
(51,'IBM Blade Servers',51),
(54,'IBM Blade Power Module',54),
(56,'IBM Storage Controller',56);

INSERT INTO pollers_poller_groups VALUES
(249,57,1,206,41),
(250,51,1,207,20),
(251,51,5,208,9),
(256,51,10,211,9),
(257,51,15,1,10),
(259,54,1,210,32),
(260,54,2,209,41),
(262,56,1,217,44);

INSERT INTO trap_receivers VALUES
(4,10,'enterprises.1123.4.300.0.1','IBM DS Event','static','warning,state,2',12,1,1);

INSERT INTO types VALUES
(73,'To delete',13,'<info>  <state>  <interface> <user>',0,1,0,2,1),
(74,'IBM error',5,'<info> (id:<interface>)',1,1,0,1,1),
(75,'IBM Warning',127,'<interface> is in <state> state',1,1,0,1,1),
(76,'Disable polling',13,'Polling for host <interface> is disabled (enabling time: <info>)',0,1,0,1,0),
(77,'IBM San Trap',5,'<user>: <state> <info> (<interface>)',1,1,0,1,1),
(78,'OS/400 Error',5,'A subsystem is <state> on the OS/400',1,1,0,1,1),
(79,'Enable polling',13,'Polling for host <interface> is enabled',0,1,0,1,0),
(80,'Storage Controller',4,'<info>',1,1,0,1,1);


--
-- Extra informant disk support

INSERT INTO graph_types VALUES
(102,'Time Usage',57,'inf_ldisk_time','',500,175,0,0,0),
(103,'I/O Byte Rate',57,'inf_ldisk_rate','',500,175,0,0,0),
(104,'I/O Ops Rate',57,'inf_ldisk_opsrate','',500,175,0,0,0);

INSERT INTO interface_types VALUES
(57,'Informant Disks 64',1,1,'informant_adv_ldisks','',58,1,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,102,0,'none',0,1,0);

INSERT INTO interface_types_fields VALUES
(406,'Index','index',5,57,3,0,0,0,''),
(395,'Description','description',10,57,7,1,1,0,'Ldisk 64'),
(396,'Current Queue Length','cur_disk_q',20,57,20,0,0,0,'DS:cur_disk_q:GAUGE:600:0:10000'),
(397,'Average Queue Length','avg_disk_q',25,57,20,0,0,0,'DS:avg_disk_q:GAUGE:600:0:10000'),
(398,'Average Read Queue Length','avg_disk_rdq',30,57,20,0,0,0,'DS:avg_disk_rdq:GAUGE:600:0:10000'),
(399,'Average Write Queue Length','avg_disk_wrq',35,57,20,0,0,0,'DS:avg_disk_wrq:GAUGE:600:0:10000'),
(400,'Percent Read Time','inf_d_read_time',40,57,20,0,0,0,'DS:inf_d_read_time:GAUGE:600:0:100'),
(401,'Percent Write Time','inf_d_write_time',45,57,20,0,0,0,'DS:inf_d_write_time:GAUGE:600:0:100'),
(402,'Reads Per Sec','rd_ops',50,57,20,0,0,0,'DS:rd_ops:GAUGE:600:0:10000'),
(403,'Writes Per Sec','wr_ops',55,57,20,0,0,0,'DS:wr_ops:GAUGE:600:0:10000'),
(404,'Read Bytes Per Sec','inf_d_read_rate',55,57,20,0,0,0,'DS:inf_d_read_rate:GAUGE:600:0:10000'),
(405,'Write Bytes Per Sec','inf_d_write_rate',55,57,20,0,0,0,'DS:inf_d_write_rate:GAUGE:600:0:10000');

INSERT INTO pollers VALUES
(219,'cur_disk_q','Inf-64 Disk CurrentDiskQueue','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.16.<index>'),
(220,'avg_disk_q','Inf-64 Disk AvgDiskQueu','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.10.<index>'),
(221,'avg_disk_rdq','Inf-64 Disk avg Read DiskQueue','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.11.<index>'),
(222,'avg_disk_wrq','Inf-64 Disk avg Write DiskQueue','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.12.<index>'),
(223,'inf_d_read_time','Inf-64 Disk Read Time','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.2.<index>'),
(224,'inf_d_write_time','Inf-64 Disk Write Time','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.4.<index>'),
(225,'rd_ops','Inf-64 Disk Read rate','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.19.<index>'),
(226,'wr_ops','Inf-64 Disk Write rate','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.22.<index>'),
(227,'inf_d_read_rate','Inf-64 Disk Read Bytes','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.18.<index>'),
(228,'inf_d_write_rate','Inf-64 Disk Write Bytes','snmp_counter','.1.3.6.1.4.1.9600.1.2.44.1.21.<index>');

INSERT INTO pollers_groups VALUES
(58,'Informant Disks 64',57);

INSERT INTO pollers_poller_groups VALUES
(264,58,10,219,32),
(265,58,20,220,32),
(266,58,30,221,32),
(267,58,40,222,32),
(268,58,50,223,32),
(269,58,60,224,32),
(270,58,70,225,32),
(271,58,80,226,32),
(272,58,90,227,32),
(273,58,100,228,32);


DROP TABLE IF EXISTS logfiles;
CREATE TABLE logfiles (
id int(10) NOT NULL auto_increment,
filename varchar(60) NOT NULL,
parse_group int(10) NOT NULL default '0',
last_poll_date int(10) NOT NULL default '0',
file_offset int(10) NOT NULL default '0',
PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- Table structure for table logfiles_match_groups
--
DROP TABLE IF EXISTS logfiles_match_groups;
CREATE TABLE logfiles_match_groups (
id int(10) NOT NULL auto_increment,
logfile int(10) NOT NULL,
pos int(10) NOT NULL default '10',
match_item int(10) NOT NULL,
PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table logfiles_match_items
--

DROP TABLE IF EXISTS logfiles_match_items;
CREATE TABLE logfiles_match_items (
id int(10) NOT NULL auto_increment,
description varchar(30) NOT NULL,
match_text varchar(255) NOT NULL,
interface varchar(20) NOT NULL,
username varchar(20) NOT NULL,
state varchar(20) NOT NULL,
info varchar(20) NOT NULL,
type int(10) NOT NULL,
host varchar(20) default NULL,
PRIMARY KEY  (id)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;


--
-- PDU and UPS
INSERT INTO graph_types VALUES
(98,'UPS Power',41,'ups_power','',500,150,0,0,1),
(99,'PDU Load',49,'pdu_load','',500,150,0,0,1);

INSERT INTO interface_types VALUES
(48,'PDU',1,1,'pdu','',49,0,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,1,0,'none',0,1,0),
(49,'PDU Banks',0,1,'pdu_banks','',50,1,'RRA:AVERAGE:0.5:1:<resolution>','103680',300,99,0,'none',0,1,0);

INSERT INTO interface_types_fields VALUES
(358,'UPS Type','upstype',50,41,7,1,0,1,''),
(359,'Power','power',50,41,20,0,0,0,'DS:power:GAUGE:600:0:100000'),
(360,'Description','description',20,48,7,1,0,0,''),
(361,'Index','index',10,48,3,0,0,0,''),
(362,'Index','index',10,49,3,0,0,0,''),
(363,'Banks','banks',50,48,7,1,0,0,''),
(364,'Power Rating (Amps)','powerrating',40,49,7,1,0,0,''),
(365,'Load (Amps)','load',50,49,20,0,0,0,'DS:load:GAUGE:600:0:100'),
(366,'Overload Threshold','threshold',50,49,7,1,0,0,'');

INSERT INTO pollers VALUES
(203,'power','UPS Lines Power','ups_line',''),
(204,'status','PDU Load Status','snmp_status','.1.3.6.1.4.1.318.1.1.12.2.3.1.1.3.<index>,1=load normal|2=load low|3=load near overload|4=load ove'),
(205,'load','PDU Banks Load','pdu_banks','');

INSERT INTO pollers_groups VALUES
(49,'PDU',48),
(50,'PDU Banks',49);

INSERT INTO pollers_poller_groups VALUES
(237,48,30,195,32),
(238,48,40,196,9),
(239,48,41,197,9),
(240,48,42,198,9),
(241,48,43,199,9),
(242,48,44,200,9),
(243,48,45,201,9),
(244,48,46,202,9),
(245,48,50,1,10),
(247,49,10,204,32),
(248,50,10,205,32);



INSERT INTO interface_types_fields VALUES
(393,'Cpu Threshold','cpu_threshold',40,46,8,2,1,0,'90');

INSERT INTO pollers_poller_groups VALUES
(263,47,5,218,43);
--
-- UPS fixes

INSERT INTO interface_types_fields VALUES
(367,'UPS Type','upstype',50,40,7,1,0,1,'');

INSERT INTO pollers_poller_groups VALUES
(246,42,50,203,32);
SELECT SETVAL('interface_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from interface_types));
SELECT SETVAL('interface_types_fields_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from interface_types_fields));
SELECT SETVAL('interface_types_field_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from interface_types_field_types));
SELECT SETVAL('graph_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from graph_types));
SELECT SETVAL('alarm_states_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from alarm_states));
SELECT SETVAL('severity_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from severity));
SELECT SETVAL('syslog_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from syslog_types));
SELECT SETVAL('trap_receivers_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from trap_receivers));
SELECT SETVAL('types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from types));
SELECT SETVAL('slas_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from slas));
SELECT SETVAL('slas_cond_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from slas_cond));
SELECT SETVAL('slas_sla_cond_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from slas_sla_cond));
SELECT SETVAL('filters_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from filters));
SELECT SETVAL('filters_fields_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from filters_fields));
SELECT SETVAL('filters_cond_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from filters_cond));
SELECT SETVAL('pollers_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers));
SELECT SETVAL('pollers_groups_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers_groups));
SELECT SETVAL('pollers_backend_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers_backend));
SELECT SETVAL('pollers_poller_groups_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from pollers_poller_groups));
SELECT SETVAL('autodiscovery_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from autodiscovery));
SELECT SETVAL('hosts_config_types_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from hosts_config_types));
SELECT SETVAL('tools_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from tools));
SELECT SETVAL('profiles_options_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from profiles_options));
SELECT SETVAL('actions_id_seq',(select case when max(id)>10000 then max(id) else 10000 end from actions));
SELECT SETVAL('profiles_values_id_seq',(select case when max(id)>299 then max(id) else 299 end from profiles_values));
