/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.InputTagSupport;
import net.sourceforge.stripes.tag.PopulationStrategy;
import net.sourceforge.stripes.util.CryptoUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;
import net.sourceforge.stripes.validation.ValidationErrors;
import net.sourceforge.stripes.validation.ValidationMetadata;

public class DefaultPopulationStrategy
implements PopulationStrategy {
    private Configuration config;
    private static final Log log = Log.getInstance(DefaultPopulationStrategy.class);

    public void init(Configuration configuration) throws Exception {
        this.config = configuration;
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    public Object getValue(InputTagSupport tag) throws StripesJspException {
        Object value = this.getValuesFromRequest(tag);
        if (value == null) {
            value = this.getValueFromActionBean(tag);
        }
        if (value == null) {
            value = this.getValueFromTag(tag);
        }
        return value;
    }

    protected String[] getValuesFromRequest(InputTagSupport tag) throws StripesJspException {
        ValidationMetadata validate;
        Class<? extends ActionBean> beanClass;
        String[] value = tag.getPageContext().getRequest().getParameterValues(tag.getName());
        if (value != null && (beanClass = tag.getParentFormTag().getActionBeanClass()) != null && (validate = this.config.getValidationMetadataProvider().getValidationMetadata(beanClass, new ParameterName(tag.getName()))) != null && validate.encrypted()) {
            String[] copy = new String[value.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = CryptoUtil.decrypt(value[i]);
            }
            value = copy;
        }
        return value;
    }

    protected Object getValueFromActionBean(InputTagSupport tag) throws StripesJspException {
        ActionBean actionBean = tag.getParentFormTag().getActionBean();
        Object value = null;
        if (actionBean != null) {
            try {
                value = BeanUtil.getPropertyValue(tag.getName(), actionBean);
            }
            catch (ExpressionException ee) {
                log.info("Could not locate property of name [" + tag.getName() + "] on ActionBean.", ee);
            }
        }
        return value;
    }

    protected Object getValueFromTag(InputTagSupport tag) {
        return tag.getValueOnPage();
    }

    protected boolean isFormInError(InputTagSupport tag) throws StripesJspException {
        boolean inError = false;
        ActionBean actionBean = tag.getParentFormTag().getActionBean();
        if (actionBean != null) {
            ValidationErrors errors = actionBean.getContext().getValidationErrors();
            inError = errors != null && errors.size() > 0;
        }
        return inError;
    }
}

