/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.CollectionUtil;

public class StringUtil {
    private static final Pattern STANDARD_SPLIT = Pattern.compile("[\\s,]+");

    public static String[] standardSplit(String input) {
        if (input == null) {
            return new String[0];
        }
        return STANDARD_SPLIT.split(input.trim());
    }

    public static String combineParts(Object ... messageParts) {
        StringBuilder builder = new StringBuilder(128);
        for (Object part : messageParts) {
            if (part != null && part.getClass().isArray()) {
                builder.append(Arrays.toString(CollectionUtil.asObjectArray(part)));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StripesRuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StripesRuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
        }
    }
}

