/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "kvpnc.h"

#include <QtCore/QString>

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kmessagebox.h>
#include <kuser.h>

static const char *description = "KDE frontend for various vpn clients\nCurrently supported protocols:\n* Cisco (vpnc (free), vpnclient (proprietary))\n* IPSec (FreeS/WAN, Openswan, strongSwan, racoon)\n* PPTP\n* OpenVPN\n* L2TP (l2tpd, xl2tpd, openl2tp) over IPSec (racoon, FreeS/WAN, Openswan, strongSwan)\n* Vtun\n* SSH" ;
// QDate().fromString(, Qt::LocalDate ).toString( "yyyyMMdd" )
QString date(__DATE__);
QString day = date.section(' ', 0, 0);
QString month = QString().setNum(QDate::fromString(date.section(' ', 0, 0), Qt::ISODate).month());
QString year = date.section(' ', 2, 2);

QString currentdate("+SVN(" + date + " " + QTime().fromString(QString(__TIME__)).toString("hhmm") + ")");


#define __is_release__

QString versionstring1 = "0.9.6";

#ifdef __is_release__
static const char *KVPNCVERSION = versionstring1.toAscii();
QString versionstring = QString(KVPNCVERSION);
#else
QString versionstring = versionstring1 + QString(" KDE4 ") + currentdate;
static const char *KVPNCVERSION  = versionstring.toAscii() ;
#endif

int main(int argc, char *argv[])
{
    KAboutData aboutData("kvpnc",
                         0,
                         ki18n("KVpnc"),
                         KVPNCVERSION,
                         ki18n(description),
                         KAboutData::License_GPL,
                         ki18n("(C) 2004-2009 the KVpnc team"),
                         ki18n("http://home.gna.org/kvpnc/"),
                         "crissi99@gmx.de");

    aboutData.addAuthor(ki18n("Christoph Thielecke"),
                        ki18n("Developer and maintainer"),
                        "crissi99@gmx.de");

    aboutData.setVersion(versionstring.toAscii());
    aboutData.setShortDescription(ki18n(description));

    aboutData.addCredit(ki18n("KDE Team") , ki18n("KDE"), "", "http://www.kde.org/");
    aboutData.addCredit(ki18n("KDevelop Team") , ki18n("KDevelop"), "", "http://www.kdevelop.org/");
    aboutData.addCredit(ki18n("Maurice Massar") , ki18n("Vpnc"), "vpnc@unix-ag.uni-kl.de", "http://www.unix-ag.uni-kl.de/~massar/vpnc/");
    aboutData.addCredit(ki18n("Witek Strzelczyk"), ki18n("Polish translation"), "witek_strzelczyk@go2.pl");
    aboutData.addCredit(ki18n("Tomas Olah") , ki18n("Slovak translation"), "tomas.olah@alert.sk");
    aboutData.addCredit(ki18n("Lapo Luchini") , ki18n("Italian translation"), "lapo@lapo.it");
    aboutData.addCredit(ki18n("Karoly Barcza"), ki18n("Hungary translation"), "kbarcza@blackpanther.hu");
    aboutData.addCredit(ki18n("Luk De Ketelaere") , ki18n("Dutch translation"), "balboy@kvirc.net");
    aboutData.addCredit(ki18n("Jorgen Kessler") , ki18n("Dutch translation"), "jkesseler@home.nl");
    aboutData.addCredit(ki18n("Atanas M.") , ki18n("Bulgarian translation"), "bugar@developer.bg");
    aboutData.addCredit(ki18n("Juanjo Avarez Martinez") , ki18n("Spanish translation"), "juanjux@yahoo.es");
    aboutData.addCredit(ki18n("He Shi Jun"), ki18n("Chinese translation"), "hax.sfo@gmail.com");
    aboutData.addCredit(ki18n("Marius Pacha") , ki18n("Chinese translation"), "marius@matux.de");
    aboutData.addCredit(ki18n("Valeriy Girchenko") , ki18n("Russian translation"), "valeragir@mail.ru");
    aboutData.addCredit(ki18n("Ahinu") , ki18n("French translation"), "ahinu@wanadoo.fr");
    aboutData.addCredit(ki18n("Florian Fainelli") , ki18n("French translation"), "florian@alphacore.net");
    aboutData.addCredit(ki18n("Damien Raude-Morvan") , ki18n("French translation"), "drazib@drazzib.com");
    aboutData.addCredit(ki18n("Daniel Nylander") , ki18n("Swedish translation"), "po@danielnylander.se");
    aboutData.addCredit(ki18n("Yukiko Bando") , ki18n("Japanese translation"), "ybando@k6.dion.ne.jp");
    aboutData.addCredit(ki18n("Marc Serra Romero") , ki18n("Catalan translation"), "mad93@majomo.com");
    aboutData.addCredit(ki18n("Buelent SENER") , ki18n("Turkish translation"), "bsener@inonu.edu.tr");
    aboutData.addCredit(ki18n("Laurent Montel"), ki18n("Patches"), "montel@kde.org");
    aboutData.addCredit(ki18n("Peter Kussmann") , ki18n("PPTP-Test environment, OpenVPN testing, new ideas"), "peter.kussmann@gmx.de");
    aboutData.addCredit(ki18n("Ansgar Jazdzewski") , ki18n("OpenVPN-Test environment, OpenVPN testing, new ideas"), "ansgarj@gmx.de");
    aboutData.addCredit(ki18n("D. Klinkenberg") , ki18n("Testing PPTP, usebility hints & tests, bug hunting"), "d.klinkenberg@gmx.net");
    aboutData.addCredit(ki18n("Lenon Kitchens") , ki18n("Testing OpenSWAN, bug hunting"), "lenon@sanctuary.org");
    aboutData.addCredit(ki18n("Fathi Boudra") , ki18n("Testing OpenVPN, bug hunting"), "fboudra@free.fr");
    aboutData.addCredit(ki18n("HAL9000") , ki18n("Cisco password decoder"), "hal9000@evilscientists.de");
    aboutData.addCredit(ki18n("Marcin Prejsnar") , ki18n("Testing OpenVPN auth+cert, bug hunting"), "alex@pronet.pl");
    aboutData.addCredit(ki18n("Elias Probst") , ki18n("Icon artwork, bug hunting"), " elias.probst@gmx.de");
    aboutData.addCredit(ki18n("Andreas Diestelmann") , ki18n("Support KVpnc development with 15EUR"), "andreas@diestelmann.de");
    aboutData.addCredit(ki18n("Frank Visconti") , ki18n("Support KVpnc development with 30$"), "frank3@viscontifamily.net");
    aboutData.addCredit(ki18n("Christoph Schmid") , ki18n("Support KVpnc development with 30EUR"), "chris@schlagmichtod.de");
    aboutData.addCredit(ki18n("Attila Ruzsinszky") , ki18n("Cisco testbed, bug hunting"), "ruzsinszky.attila@gmail.com");
    aboutData.addCredit(ki18n("Christiansen") , ki18n("Danish translation"), "susebruger@mailme.dk");
    //aboutData.setBugAddress ("crissi99@gmx.de");


    // Initialize command line args
    KCmdLineArgs::init(argc, argv, &aboutData);

    KCmdLineOptions options;
    options.add("openvpnimport <file>", ki18n("Import OpenVPN config file"));
    options.add("ciscoimport <file>", ki18n("Import Cisco PCF file"));
    options.add(":", ki18n("Extra options:"));

    KCmdLineArgs::addCmdLineOptions(options);    // Add our own options.

    KApplication a;
    KVpnc *kvpnc =  new KVpnc(&a);


    // Broken on request from Eric M.
    if (a.isSessionRestored()) {
        kvpnc->restore();
    } else {
        if (!KUser().isSuperUser()) {
            KMessageBox::error(0L, i18n("Kvpnc must be started as root."));
            exit(0);
        }

        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->isSet("openvpnimport")) {
            QString openvpnimportfile = QString(args->getOption("openvpnimport"));
            kvpnc->importOpenvpnProfileClicked(openvpnimportfile);
        } else if (args->isSet("ciscoimport")) {
            QString ciscoimportfile = QString(args->getOption("ciscoimport"));
            kvpnc->importOpenvpnProfileClicked(ciscoimportfile);
        }

    }
    // we need a running app for the init method
//  QTimer::singleShot ( 0, &a, SLOT ( init() ) );
    return a.exec();
}

