package latexDraw.parsers.svg.elements.path;

/**
 * Defines the SVGPath moveto segment.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 10/20/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 0.1<br>
 * @since 0.1
 */
public class SVGPathSegMoveto extends SVGPathSegLineto
{
	/**
	 * The main constructor.
	 * @param x The X-coordinate of the point to go.
	 * @param y The Y-coordinate of the point to go.
	 * @param isRelative
	 */
	public SVGPathSegMoveto(double x, double y, boolean isRelative)
	{
		super(x, y, isRelative);
	}

	
	@Override
	public String toString()
	{
		StringBuffer stringBuffer = new StringBuffer();
		
		stringBuffer.append((isRelative() ? "m" : "M"));//$NON-NLS-1$//$NON-NLS-2$
		stringBuffer.append(' ');
		stringBuffer.append(x);
		stringBuffer.append(' ');
		stringBuffer.append(y);
		
		return stringBuffer.toString();
	}
	
	
	@Override
	public PathSeg getType()
	{
		return isRelative() ? PathSeg.MOVETO_REL : PathSeg.MOVETO_ABS;
	}
}
