// Reconcile DEP-5 debian/copyright to licensecheck
//
// Copyright : 2023-2025 P Blackman
// License   : BSD-2-clause
//

unit loadsourcefiles;
{$mode delphi}

interface

procedure LoadSource;


implementation uses Classes, Process, options, rstrings, support, filedata;

procedure LoadSource;
var OK          : Boolean;
    S1          : AnsiString;
    SourceList  : tStringList;
begin
    if not Option_Format then
    begin
        Writeln;
        Writeln (rsPST + '  ....'); // Parsing Source Tree
    end;

    OK := RunCommand('/usr/libexec/lrc-find', ['.'], S1,  [poUsePipes, poWaitOnExit]);

    if not OK then
        writeln (rsFps)  // Failed to parse source tree
    else
    begin
        MangleName (S1);
        SourceList := tStringList.Create;
        SourceList.text := S1;
        InitFileData (SourceList);
        SourceList.Free;
    end;
end;

end.
