/* Define the X & Y dimensions of the main window
 * Should be close to "Maximized" on a 640x480 screen. 
 * If someone knows how to ask the window manager to maximize a window, let me know!*/

#define MAIN_X 630
#define MAIN_Y 470

#include "config.h"
/* Libraries */
#include <gtk/gtk.h>
#include <gdk_imlib.h>
/* For lln_file */
#include <sys/types.h>
#include <sys/dir.h>
#include <time.h>
/* Common stuff */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <ctype.h>
/* Internationalization support - by Jan-Philip Velders, Mar 6 1999 */
#define _(x) gettext (x)
#include <libintl.h>
#include <sys/stat.h> /* Added by Lalo Martins, Feb 27 1999: */

/* Widgets */
void 
lln_set_widget_font      (GtkWidget *widget);

void 
lln_pack_image_in_box    (GtkWidget *parent, 
			  GtkWidget *box,
			  gchar *xpm_filename);

GtkWidget*
lln_image_popup_new      (char *filename, 
			  char *title, 
			  char *label);

/* Window manipulation */

void close_my_window     (GtkWidget *widget,  //Closes the parent 
			  GtkWidget *window); //Window of a button

int close_window         (GtkWidget *widget,  //Close the window in
			  GdkEvent *event,    //response from window 
			  GtkWidget *window );//manager event

int close_window_onclick (GtkWidget *widget,  
			  GdkEventButton *event,
			  GtkWidget *window );

void lln_show_letter     (GtkWidget *widget,  //Display a letter 
			  gpointer *data);

void lln_show_number     (GtkWidget *widget, 
			  gpointer *data);

gint lln_sound_play (gpointer *word);

/* Utility event handling */

int
retransmit_press (GtkWidget * widget,
                  GdkEventButton * event,
                  gpointer * data);

int
retransmit_release (GtkWidget * widget,
                    GdkEventButton * event,
                    gpointer * data);

int
get_keystroke (GtkWidget * widget, 
	       GdkEventKey * event, 
	       gpointer * data);

/* String Parsing */

char lln_get_1st_letter  (char *filename);

char *lln_get_word (char *filename);

char *lln_get_number (char *filename);

char *lln_get_file (char letter);

int lln_check_file (char *path);

int lln_get_random (double max, char letter);

extern char * lln_image_dir;

extern char * lln_sound_dir;
/* Part of Paul's IMMEDIATE EXPOSURE patch */
extern int lln_ignore;

int play_file (char *filename);





