/*=============================================================================
** Lynkeos
** $Id: fourier.h,v 1.7 2005/01/27 23:15:13 j-etienne Exp $
**-----------------------------------------------------------------------------
**
**  Created by Jean-Etienne LAMIAUD on Aug 5, 2003.
**  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
**-----------------------------------------------------------------------------
*/
#ifndef __FOURIER_H
#define __FOURIER_H

#include "processing_core.h"

/*-----------------------------------------------------------------------------
** MACROS
**-----------------------------------------------------------------------------
*/

#define FOR_DIRECT  1
#define FOR_INVERSE 2

#ifdef FLOAT_PIXELS
#define FFT_MALLOC fftwf_malloc
#define FFT_PLAN_R2C fftwf_plan_many_dft_r2c
#define FFT_PLAN_C2R fftwf_plan_many_dft_c2r
#define FFT_EXECUTE fftwf_execute
#define FFT_FREE fftwf_free
#define FFT_DESTROY_PLAN fftwf_destroy_plan
#else
#define FFT_MALLOC fftw_malloc
#define FFT_PLAN_R2C fftw_plan_many_dft_r2c
#define FFT_PLAN_C2R fftw_plan_many_dft_r2c
#define FFT_EXECUTE fftw_execute
#define FFT_FREE fftw_free
#define FFT_DESTROY_PLAN fftw_destroy_plan
#endif

/*-----------------------------------------------------------------------------
** PROTOTYPES 
**-----------------------------------------------------------------------------
*/
extern void FFT_DATA_INIT( FFT_DATA *d );

extern short log_2( short val );

extern void free_spectrum( FFT_DATA *s );
extern void allocate_spectrum( FFT_DATA *s, u_short w, u_short h, 
                               u_char nplanes, u_char goal );
extern void fourier( FFT_DATA sample );
extern void fourier_inverse( FFT_DATA sample, 
                            REAL *vmin, REAL *vmax );

/** Access to the color plane */
extern inline void *rgbPlane( FFT_DATA sample, u_char c );
#define RED_PLANE 0
#define GREEN_PLANE 1
#define BLUE_PLANE 2

/** Access to the color sample (spatial data) */
extern inline REAL *colorValue( FFT_DATA sample, u_short x, u_short y, 
                               u_char c );
#define redValue(s,x,y) colorValue(s,x,y,RED_PLANE)
#define greenValue(s,x,y) colorValue(s,x,y,GREEN_PLANE)
#define blueValue(s,x,y) colorValue(s,x,y,BLUE_PLANE)

#endif
