/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file GribLoopAttributes.h
    \brief Definition of GribLoop Attributes class.
    \author Meteorological Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Mon Apr 15 17:55:21 2013
*/
   

#ifndef GribLoopAttributes_H
#define GribLoopAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "WindMode.h"
#include "GribAddressMode.h"
#include "GribLoopStep.h"

namespace magics {

class XmlNode;



class GribLoopAttributes 
{
public:
//  --  constructor
    GribLoopAttributes();
    
//  --  destructor
    virtual ~GribLoopAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const GribLoopAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

	

public:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream& out) const;
	//  --  members:
	string tag_;
	auto_ptr<GribAddressMode> address_mode_;
	intarray dimension_;
	intarray dim_1_;
	intarray dim_2_;
	intarray dim_colour_;
	intarray dim_;
	string path_;
	auto_ptr<GribLoopStep> step_;
	bool scaling_;
	bool derived_scaling_;
	double scaling_factor_;
	double scaling_offset_;
	auto_ptr<WindMode> wind_mode_;

private:
  
	friend ostream& operator<<(ostream& s,const GribLoopAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
