<?php
/**
 * Aliases for Special:NewestPages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = array();

/** English (English) */
$specialPageAliases['en'] = array(
	'NewestPages' => array( 'NewestPages' ),
);

/** Afrikaans (Afrikaans) */
$specialPageAliases['af'] = array(
	'NewestPages' => array( 'NuutsteBladsye' ),
);

/** Arabic (العربية) */
$specialPageAliases['ar'] = array(
	'NewestPages' => array( 'أجدد_الصفحات' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$specialPageAliases['arz'] = array(
	'NewestPages' => array( 'اجدد_الصفح' ),
);

/** Bulgarian (Български) */
$specialPageAliases['bg'] = array(
	'NewestPages' => array( 'Най-нови_страници' ),
);

/** Breton (Brezhoneg) */
$specialPageAliases['br'] = array(
	'NewestPages' => array( 'Pajennoù^Nevesañ' ),
);

/** Bosnian (Bosanski) */
$specialPageAliases['bs'] = array(
	'NewestPages' => array( 'NajnovijeStranice' ),
);

/** Danish (Dansk) */
$specialPageAliases['da'] = array(
	'NewestPages' => array( 'Nyeste_sider' ),
);

/** German (Deutsch) */
$specialPageAliases['de'] = array(
	'NewestPages' => array( 'Neueste_Seiten' ),
);

/** Lower Sorbian (Dolnoserbski) */
$specialPageAliases['dsb'] = array(
	'NewestPages' => array( 'Nejnowše_boki' ),
);

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = array(
	'NewestPages' => array( 'ΝεότερεςΣελίδες' ),
);

/** Persian (فارسی) */
$specialPageAliases['fa'] = array(
	'NewestPages' => array( 'تازه‌ترین_صفحه‌ها' ),
);

/** Finnish (Suomi) */
$specialPageAliases['fi'] = array(
	'NewestPages' => array( 'Uusimmat_sivut' ),
);

/** French (Français) */
$specialPageAliases['fr'] = array(
	'NewestPages' => array( 'Pages_les_plus_récentes', 'PagesLesPlusRécentes' ),
);

/** Franco-Provençal (Arpetan) */
$specialPageAliases['frp'] = array(
	'NewestPages' => array( 'Pâges_les_ples_novèles', 'PâgesLesPlesNovèles' ),
);

/** Galician (Galego) */
$specialPageAliases['gl'] = array(
	'NewestPages' => array( 'Páxinas_máis_novas' ),
);

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = array(
	'NewestPages' => array( 'Neijeschti Syte' ),
);

/** Croatian (Hrvatski) */
$specialPageAliases['hr'] = array(
	'NewestPages' => array( 'Najnovije_stranice' ),
);

/** Upper Sorbian (Hornjoserbsce) */
$specialPageAliases['hsb'] = array(
	'NewestPages' => array( 'Najnowše_strony' ),
);

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = array(
	'NewestPages' => array( 'PajKiPiNouvo' ),
);

/** Hungarian (Magyar) */
$specialPageAliases['hu'] = array(
	'NewestPages' => array( 'Legújabb_lapok' ),
);

/** Interlingua (Interlingua) */
$specialPageAliases['ia'] = array(
	'NewestPages' => array( 'Paginas_le_plus_nove' ),
);

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = array(
	'NewestPages' => array( 'Halaman_terbaru', 'HalamanTerbaru' ),
);

/** Italian (Italiano) */
$specialPageAliases['it'] = array(
	'NewestPages' => array( 'PaginePiùNuove' ),
);

/** Japanese (日本語) */
$specialPageAliases['ja'] = array(
	'NewestPages' => array( '最新のページ' ),
);

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = array(
	'NewestPages' => array( 'ទំព័រថ្មីៗបំផុត' ),
);

/** Korean (한국어) */
$specialPageAliases['ko'] = array(
	'NewestPages' => array( '새_페이지' ),
);

/** Colognian (Ripoarisch) */
$specialPageAliases['ksh'] = array(
	'NewestPages' => array( 'Neueste_Sigge' ),
);

/** Kurdish (Kurdî) */
$specialPageAliases['ku'] = array(
	'NewestPages' => array( 'Rûpelên_nû' ),
);

/** Ladino (Ladino) */
$specialPageAliases['lad'] = array(
	'NewestPages' => array( 'HojasMásNuevas' ),
);

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = array(
	'NewestPages' => array( 'Neiste_Säiten' ),
);

/** Macedonian (Македонски) */
$specialPageAliases['mk'] = array(
	'NewestPages' => array( 'НајновиСтраници' ),
);

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = array(
	'NewestPages' => array( 'പുതുപുത്തൻ‌താളുകൾ' ),
);

/** Marathi (मराठी) */
$specialPageAliases['mr'] = array(
	'NewestPages' => array( 'नवीनतमपाने' ),
);

/** Maltese (Malti) */
$specialPageAliases['mt'] = array(
	'NewestPages' => array( 'PaġniRiċenti' ),
);

/** Norwegian Bokmål (‪Norsk (bokmål)‬) */
$specialPageAliases['nb'] = array(
	'NewestPages' => array( 'Siste_sider', 'Nyeste_sider' ),
);

/** Low German (Plattdüütsch) */
$specialPageAliases['nds'] = array(
	'NewestPages' => array( 'Neeste Sieden' ),
);

/** Nedersaksisch (Nedersaksisch) */
$specialPageAliases['nds-nl'] = array(
	'NewestPages' => array( 'Niejste_pagina\'s' ),
);

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = array(
	'NewestPages' => array( 'NieuwstePaginas', 'NieuwstePagina\'s' ),
);

/** Occitan (Occitan) */
$specialPageAliases['oc'] = array(
	'NewestPages' => array( 'Paginas_mai_recentas', 'PaginasMaiRecentas' ),
);

/** Polish (Polski) */
$specialPageAliases['pl'] = array(
	'NewestPages' => array( 'Najnowsze_strony' ),
);

/** Pashto (پښتو) */
$specialPageAliases['ps'] = array(
	'NewestPages' => array( 'ترټولو_نوي_مخونه' ),
);

/** Portuguese (Português) */
$specialPageAliases['pt'] = array(
	'NewestPages' => array( 'Páginas_mais_recentes' ),
);

/** Brazilian Portuguese (Português do Brasil) */
$specialPageAliases['pt-br'] = array(
	'NewestPages' => array( 'Páginas_mais_novas' ),
);

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = array(
	'NewestPages' => array( 'अतिनूतनपृष्ठ' ),
);

/** Sinhala (සිංහල) */
$specialPageAliases['si'] = array(
	'NewestPages' => array( 'අලුත්මපිටු' ),
);

/** Slovak (Slovenčina) */
$specialPageAliases['sk'] = array(
	'NewestPages' => array( 'NajnovšieStránky' ),
);

/** Albanian (Shqip) */
$specialPageAliases['sq'] = array(
	'NewestPages' => array( 'FaqetMëTëReja' ),
);

/** Swedish (Svenska) */
$specialPageAliases['sv'] = array(
	'NewestPages' => array( 'Nyaste_sidor' ),
);

/** Swahili (Kiswahili) */
$specialPageAliases['sw'] = array(
	'NewestPages' => array( 'KurasaMpya' ),
);

/** Telugu (తెలుగు) */
$specialPageAliases['te'] = array(
	'NewestPages' => array( 'కొంగొత్తపేజీలు' ),
);

/** Thai (ไทย) */
$specialPageAliases['th'] = array(
	'NewestPages' => array( 'หน้าใหม่สุด' ),
);

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = array(
	'NewestPages' => array( 'Pinakabagong mga pahina' ),
);

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = array(
	'NewestPages' => array( 'EnYeniSayfalar' ),
);

/** Vèneto (Vèneto) */
$specialPageAliases['vec'] = array(
	'NewestPages' => array( 'PaginePiNove' ),
);

/** Simplified Chinese (‪中文(简体)‬) */
$specialPageAliases['zh-hans'] = array(
	'NewestPages' => array( '最新页面' ),
);

/** Traditional Chinese (‪中文(繁體)‬) */
$specialPageAliases['zh-hant'] = array(
	'NewestPages' => array( '最新頁面' ),
);