/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/


#ifndef MvQGeoHelp_H
#define MvQGeoHelp_H

#include "MvQRequestPanelHelp.h"
#include "Parameter.h"
#include "ReplyObserver.h"
#include "MessageObserver.h"

#include <QIcon>
#include <QMap>
#include <QString>

class MvQGeoHelp : public MvQRequestPanelHelp,
                   public ReplyObserver, 
                   public MessageObserver
{
public:
	MvQGeoHelp(RequestPanel& owner,const Parameter& param);
	~MvQGeoHelp() {};
	
	void start();
	bool dialog() {return true;}
	QIcon dialogIcon();
	bool useLargeDialogIcon() {return true;}	
	QWidget* widget() {return 0;}
  
protected:
	virtual void refresh(const vector<string>&);
  	virtual long flags() {return 9;}
	virtual void set(Request&);
	
	void reply(const Request&, int);
	void progress(const Request&);
	void message(const string&);
        void message(const Request& );
	
	Request request_;		
};	

#endif