/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQFeatureFactory.h"

#include <cmath>

#include <QApplication>
#include <QDebug>
#include <QGraphicsSceneMouseEvent>
#include <QImage>
#include <QMouseEvent>
#include <QPainter>
#include <QStyle>

#include "MvQPlotView.h"
#include "MvQFeatureCurveItem.h"
#include "MvQFeatureType.h"

#include <map>

static std::map<std::string, MvQFeatureFactory*>* makers = nullptr;

MvQFeatureFactory::MvQFeatureFactory(const std::string& type)
{
    if (!makers)
        makers = new std::map<std::string, MvQFeatureFactory*>;

    (*makers)[type] = this;
}

MvQFeatureItem* MvQFeatureFactory::create(MvQFeatureType* feature, MvQPlotView* view)
{
    Q_ASSERT(feature);
    MvQFeatureItem *item = nullptr;

    std::string type = feature->type().toStdString();
    std::map<std::string, MvQFeatureFactory*>::iterator j = makers->find(type);
    if (j == makers->end()) {
//        if (type != "icon") {
//            item = new MvQFeatureCurveItem(feature, view);
//        }
    } else {
        item = (*j).second->make(feature, view);
    }

    Q_ASSERT(item);
    return item;
}
