/* $Id: BVector_data.cpp 428967 2014-03-10 16:26:03Z vasilche $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'seqtable.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/seqtable/BVector_data.hpp>

#include <corelib/ncbimtx.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CBVector_data::~CBVector_data(void)
{
}


void CBVector_data::Reset(void)
{
    m_BitVector.reset();
    Tparent::Reset();
}


void CBVector_data::ResetBitVector(void)
{
    m_BitVector.reset();
}


DEFINE_STATIC_MUTEX(sx_PrepareMutex_bvector);


void CBVector_data::x_CreateBitVector(void) const
{
    CMutexGuard guard(sx_PrepareMutex_bvector);
    if ( !m_BitVector ) {
        // make bvector
        AutoPtr<bm::bvector<> > bv(new bm::bvector<>(GetSize()));
        bm::deserialize(*bv, (const unsigned char*)&GetData()[0]);
        m_BitVector.reset(bv.release());
    }
}


void CBVector_data::SetBitVector(const bm::bvector<>* bv)
{
    Reset();
    m_BitVector.reset(bv);
    Tparent::SetSize(bv->size());
    bm::bvector<>::statistics stat;
    bv->calc_stat(&stat);
    TData& arr = SetData();
    arr.resize(stat.max_serialize_mem);
    bm::word_t* temp_block = bv->allocate_tempblock();
    size_t size = bm::serialize(*bv, (unsigned char*)&arr[0], temp_block);
    free(temp_block);
    arr.resize(size);
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1735, CRC32: d26bbd21 */
