/*
 *	$Id: lex_stuff.c,v 1.6 2008-07-27 03:18:45 haley Exp $
 */
/************************************************************************
*                                                                       *
*    The use of this Software is governed by a License Agreement.       *
*                                                                       *
************************************************************************/

/***********************************************************************
*                                                                      *
*                          Copyright (C)  1990                         *
*            University Corporation for Atmospheric Research           *
*                          All Rights Reserved                         *
*                                                                      *
*                          NCAR View V3.01                             *
*                                                                      *
***********************************************************************/

/*
 *	lex_stuff.c
 *
 *	Routines so support lexical parser generated by lex
 */
# include <stdio.h>
extern FILE *yyout, *yyin;
extern int yyprevious , *yyfnd;
extern char yyextra[];
extern char yytext[];
extern int yyleng;

extern struct {
	int *yyaa, 
	*yybb; int 
	*yystops;
	} *yylstate [], **yylsp, **yyolsp;

yyreject ()
{
	for( ; yylsp < yyolsp; yylsp++)
		yytext[yyleng++] = yyinput();

	if (*yyfnd > 0)
		return(yyracc(*yyfnd++));

	while (yylsp-- > yylstate) {
		yyunput(yytext[yyleng-1]);
		yytext[--yyleng] = 0;
		if (*yylsp != 0 && (yyfnd= (*yylsp)->yystops) && *yyfnd > 0)
			return(yyracc(*yyfnd++));
	}

	if (yytext[0] == 0)
		return(0);

	yyoutput(yyprevious = yyinput());
	yyleng = 0;
	return(-1);
}

yyracc(yyfnd)
	int	yyfnd;
{
	yyolsp = yylsp;
	if (yyextra[yyfnd]) {

		while ((yyback((*yylsp)->yystops, -yyfnd) != 1) 
			&& yylsp > yylstate) {

			yylsp--;
			yyunput(yytext[--yyleng]);
		}
	}

	yyprevious = yytext[yyleng - 1];
	yytext[yyleng] = 0;
	return(yyfnd);
}

yywrap()
{
	return(1);
}
