# fs-exists-sync [![NPM version](https://img.shields.io/npm/v/fs-exists-sync.svg?style=flat)](https://www.npmjs.com/package/fs-exists-sync) [![NPM downloads](https://img.shields.io/npm/dm/fs-exists-sync.svg?style=flat)](https://npmjs.org/package/fs-exists-sync) [![Build Status](https://img.shields.io/travis/jonschlinkert/fs-exists-sync.svg?style=flat)](https://travis-ci.org/jonschlinkert/fs-exists-sync)

> Drop-in replacement for `fs.existsSync` with zero dependencies. Other libs I found either have crucial differences from fs.existsSync, or unnecessary dependencies. See README.md for more info.

## Install
Install with [npm](https://www.npmjs.com/):

```sh
$ npm install fs-exists-sync --save
```

## Usage

```js
var exists = require('fs-exists-sync');

console.log(exists('.'));
//=> true
console.log(exists(process.cwd()));
//=> true
console.log(exists('README.md'));
//=> true
console.log(exists('foo.txt'));
//=> false
console.log(exists(''));
//=> false
console.log(exists());
//=> false
```

## Why another "exists" lib?

I just want a _simple replacement for `fs.existsSync`_. Here is what I found:

- [path-exists][]: Has dependencies to support a promises API
- [fs-exists][]: async only
- [file-exists][]: returns `false` if the path exists but is a directory.
- [exists][]: nothing to do with `fs`. 

## API

## Related projects

You might also be interested in these projects: 

* [is-absolute](https://www.npmjs.com/package/is-absolute): Polyfill for node.js `path.isAbolute`. Returns true if a file path is absolute. | [homepage](https://github.com/jonschlinkert/is-absolute)
* [parse-filepath](https://www.npmjs.com/package/parse-filepath): Pollyfill for node.js `path.parse`, parses a filepath into an object. | [homepage](https://github.com/jonschlinkert/parse-filepath)
* [try-open](https://www.npmjs.com/package/try-open): Tries to open a file using fs.openSync (only necessary with sync), fails gracefully if the… [more](https://www.npmjs.com/package/try-open) | [homepage](https://github.com/jonschlinkert/try-open)  

## Contributing
Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/fs-exists-sync/issues/new).

## Building docs
Generate readme and API documentation with [verb][]:

```sh
$ npm install verb && npm run docs
```

Or, if [verb][] is installed globally:

```sh
$ verb
```

## Running tests
Install dev dependencies:

```sh
$ npm install -d && npm test
```

## Author
**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License
Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/fs-exists-sync/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on April 09, 2016._

[verb]: https://github.com/verbose/verb
[path-exists]: https://github.com/sindresorhus/path-exists
[fs-exists]: https://github.com/meryn/fs-exists
[file-exists]: https://github.com/scottcorgan/file-exists
[exists]: https://github.com/tjmehta/exists

