/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1
import Ubuntu.Components.Popups 0.1
import Ubuntu.Components.ListItems 0.1 as ListItem

ActionSelectionPopover {
    id: popover

    property int insertPosition: 0
    property int targetIndex: -1
    property variant targetItem: null
    property int selectionStart: 0
    property int selectionEnd: 0

    property bool canCutOrCopy: true
    property bool canPaste: true
    property bool canSelectAll: true

    signal copy()
    signal paste()
    signal cut()
    signal selectAll()

    actions: ActionList {
        Action {
            text: i18n.tr("Select All")
            onTriggered: selectAll()
            enabled: canSelectAll
        }
        Action {
            text: i18n.tr("Cut")
            onTriggered: cut()
            enabled: canCutOrCopy
        }
        Action {
            text: i18n.tr("Copy")
            onTriggered: copy()
            enabled: canCutOrCopy
        }
        Action {
            text: i18n.tr("Paste")
            onTriggered: paste()
            enabled: canPaste
        }
    }
}
